import * as ast from "./AST.js";
import { ASTVisitor } from "./ASTVisitor.js";
export declare class RecursiveASTVisitor<Context> extends ASTVisitor<Context, void> {
    constructor();
    accept(node: ast.AST | undefined, context: Context): void;
    visitTypeId(node: ast.TypeIdAST, context: Context): void;
    visitNestedNameSpecifier(node: ast.NestedNameSpecifierAST, context: Context): void;
    visitUsingDeclarator(node: ast.UsingDeclaratorAST, context: Context): void;
    visitHandler(node: ast.HandlerAST, context: Context): void;
    visitEnumBase(node: ast.EnumBaseAST, context: Context): void;
    visitEnumerator(node: ast.EnumeratorAST, context: Context): void;
    visitDeclarator(node: ast.DeclaratorAST, context: Context): void;
    visitInitDeclarator(node: ast.InitDeclaratorAST, context: Context): void;
    visitBaseSpecifier(node: ast.BaseSpecifierAST, context: Context): void;
    visitBaseClause(node: ast.BaseClauseAST, context: Context): void;
    visitNewTypeId(node: ast.NewTypeIdAST, context: Context): void;
    visitRequiresClause(node: ast.RequiresClauseAST, context: Context): void;
    visitParameterDeclarationClause(node: ast.ParameterDeclarationClauseAST, context: Context): void;
    visitParametersAndQualifiers(node: ast.ParametersAndQualifiersAST, context: Context): void;
    visitLambdaIntroducer(node: ast.LambdaIntroducerAST, context: Context): void;
    visitLambdaDeclarator(node: ast.LambdaDeclaratorAST, context: Context): void;
    visitTrailingReturnType(node: ast.TrailingReturnTypeAST, context: Context): void;
    visitCtorInitializer(node: ast.CtorInitializerAST, context: Context): void;
    visitRequirementBody(node: ast.RequirementBodyAST, context: Context): void;
    visitTypeConstraint(node: ast.TypeConstraintAST, context: Context): void;
    visitGlobalModuleFragment(node: ast.GlobalModuleFragmentAST, context: Context): void;
    visitPrivateModuleFragment(node: ast.PrivateModuleFragmentAST, context: Context): void;
    visitModuleDeclaration(node: ast.ModuleDeclarationAST, context: Context): void;
    visitModuleName(node: ast.ModuleNameAST, context: Context): void;
    visitImportName(node: ast.ImportNameAST, context: Context): void;
    visitModulePartition(node: ast.ModulePartitionAST, context: Context): void;
    visitSimpleRequirement(node: ast.SimpleRequirementAST, context: Context): void;
    visitCompoundRequirement(node: ast.CompoundRequirementAST, context: Context): void;
    visitTypeRequirement(node: ast.TypeRequirementAST, context: Context): void;
    visitNestedRequirement(node: ast.NestedRequirementAST, context: Context): void;
    visitTypeTemplateArgument(node: ast.TypeTemplateArgumentAST, context: Context): void;
    visitExpressionTemplateArgument(node: ast.ExpressionTemplateArgumentAST, context: Context): void;
    visitParenMemInitializer(node: ast.ParenMemInitializerAST, context: Context): void;
    visitBracedMemInitializer(node: ast.BracedMemInitializerAST, context: Context): void;
    visitThisLambdaCapture(node: ast.ThisLambdaCaptureAST, context: Context): void;
    visitDerefThisLambdaCapture(node: ast.DerefThisLambdaCaptureAST, context: Context): void;
    visitSimpleLambdaCapture(node: ast.SimpleLambdaCaptureAST, context: Context): void;
    visitRefLambdaCapture(node: ast.RefLambdaCaptureAST, context: Context): void;
    visitRefInitLambdaCapture(node: ast.RefInitLambdaCaptureAST, context: Context): void;
    visitInitLambdaCapture(node: ast.InitLambdaCaptureAST, context: Context): void;
    visitEqualInitializer(node: ast.EqualInitializerAST, context: Context): void;
    visitBracedInitList(node: ast.BracedInitListAST, context: Context): void;
    visitParenInitializer(node: ast.ParenInitializerAST, context: Context): void;
    visitNewParenInitializer(node: ast.NewParenInitializerAST, context: Context): void;
    visitNewBracedInitializer(node: ast.NewBracedInitializerAST, context: Context): void;
    visitEllipsisExceptionDeclaration(node: ast.EllipsisExceptionDeclarationAST, context: Context): void;
    visitTypeExceptionDeclaration(node: ast.TypeExceptionDeclarationAST, context: Context): void;
    visitDefaultFunctionBody(node: ast.DefaultFunctionBodyAST, context: Context): void;
    visitCompoundStatementFunctionBody(node: ast.CompoundStatementFunctionBodyAST, context: Context): void;
    visitTryStatementFunctionBody(node: ast.TryStatementFunctionBodyAST, context: Context): void;
    visitDeleteFunctionBody(node: ast.DeleteFunctionBodyAST, context: Context): void;
    visitTranslationUnit(node: ast.TranslationUnitAST, context: Context): void;
    visitModuleUnit(node: ast.ModuleUnitAST, context: Context): void;
    visitThisExpression(node: ast.ThisExpressionAST, context: Context): void;
    visitCharLiteralExpression(node: ast.CharLiteralExpressionAST, context: Context): void;
    visitBoolLiteralExpression(node: ast.BoolLiteralExpressionAST, context: Context): void;
    visitIntLiteralExpression(node: ast.IntLiteralExpressionAST, context: Context): void;
    visitFloatLiteralExpression(node: ast.FloatLiteralExpressionAST, context: Context): void;
    visitNullptrLiteralExpression(node: ast.NullptrLiteralExpressionAST, context: Context): void;
    visitStringLiteralExpression(node: ast.StringLiteralExpressionAST, context: Context): void;
    visitUserDefinedStringLiteralExpression(node: ast.UserDefinedStringLiteralExpressionAST, context: Context): void;
    visitIdExpression(node: ast.IdExpressionAST, context: Context): void;
    visitRequiresExpression(node: ast.RequiresExpressionAST, context: Context): void;
    visitNestedExpression(node: ast.NestedExpressionAST, context: Context): void;
    visitRightFoldExpression(node: ast.RightFoldExpressionAST, context: Context): void;
    visitLeftFoldExpression(node: ast.LeftFoldExpressionAST, context: Context): void;
    visitFoldExpression(node: ast.FoldExpressionAST, context: Context): void;
    visitLambdaExpression(node: ast.LambdaExpressionAST, context: Context): void;
    visitSizeofExpression(node: ast.SizeofExpressionAST, context: Context): void;
    visitSizeofTypeExpression(node: ast.SizeofTypeExpressionAST, context: Context): void;
    visitSizeofPackExpression(node: ast.SizeofPackExpressionAST, context: Context): void;
    visitTypeidExpression(node: ast.TypeidExpressionAST, context: Context): void;
    visitTypeidOfTypeExpression(node: ast.TypeidOfTypeExpressionAST, context: Context): void;
    visitAlignofExpression(node: ast.AlignofExpressionAST, context: Context): void;
    visitTypeTraitsExpression(node: ast.TypeTraitsExpressionAST, context: Context): void;
    visitUnaryExpression(node: ast.UnaryExpressionAST, context: Context): void;
    visitBinaryExpression(node: ast.BinaryExpressionAST, context: Context): void;
    visitAssignmentExpression(node: ast.AssignmentExpressionAST, context: Context): void;
    visitBracedTypeConstruction(node: ast.BracedTypeConstructionAST, context: Context): void;
    visitTypeConstruction(node: ast.TypeConstructionAST, context: Context): void;
    visitCallExpression(node: ast.CallExpressionAST, context: Context): void;
    visitSubscriptExpression(node: ast.SubscriptExpressionAST, context: Context): void;
    visitMemberExpression(node: ast.MemberExpressionAST, context: Context): void;
    visitPostIncrExpression(node: ast.PostIncrExpressionAST, context: Context): void;
    visitConditionalExpression(node: ast.ConditionalExpressionAST, context: Context): void;
    visitImplicitCastExpression(node: ast.ImplicitCastExpressionAST, context: Context): void;
    visitCastExpression(node: ast.CastExpressionAST, context: Context): void;
    visitCppCastExpression(node: ast.CppCastExpressionAST, context: Context): void;
    visitNewExpression(node: ast.NewExpressionAST, context: Context): void;
    visitDeleteExpression(node: ast.DeleteExpressionAST, context: Context): void;
    visitThrowExpression(node: ast.ThrowExpressionAST, context: Context): void;
    visitNoexceptExpression(node: ast.NoexceptExpressionAST, context: Context): void;
    visitLabeledStatement(node: ast.LabeledStatementAST, context: Context): void;
    visitCaseStatement(node: ast.CaseStatementAST, context: Context): void;
    visitDefaultStatement(node: ast.DefaultStatementAST, context: Context): void;
    visitExpressionStatement(node: ast.ExpressionStatementAST, context: Context): void;
    visitCompoundStatement(node: ast.CompoundStatementAST, context: Context): void;
    visitIfStatement(node: ast.IfStatementAST, context: Context): void;
    visitSwitchStatement(node: ast.SwitchStatementAST, context: Context): void;
    visitWhileStatement(node: ast.WhileStatementAST, context: Context): void;
    visitDoStatement(node: ast.DoStatementAST, context: Context): void;
    visitForRangeStatement(node: ast.ForRangeStatementAST, context: Context): void;
    visitForStatement(node: ast.ForStatementAST, context: Context): void;
    visitBreakStatement(node: ast.BreakStatementAST, context: Context): void;
    visitContinueStatement(node: ast.ContinueStatementAST, context: Context): void;
    visitReturnStatement(node: ast.ReturnStatementAST, context: Context): void;
    visitGotoStatement(node: ast.GotoStatementAST, context: Context): void;
    visitCoroutineReturnStatement(node: ast.CoroutineReturnStatementAST, context: Context): void;
    visitDeclarationStatement(node: ast.DeclarationStatementAST, context: Context): void;
    visitTryBlockStatement(node: ast.TryBlockStatementAST, context: Context): void;
    visitAccessDeclaration(node: ast.AccessDeclarationAST, context: Context): void;
    visitFunctionDefinition(node: ast.FunctionDefinitionAST, context: Context): void;
    visitConceptDefinition(node: ast.ConceptDefinitionAST, context: Context): void;
    visitForRangeDeclaration(node: ast.ForRangeDeclarationAST, context: Context): void;
    visitAliasDeclaration(node: ast.AliasDeclarationAST, context: Context): void;
    visitSimpleDeclaration(node: ast.SimpleDeclarationAST, context: Context): void;
    visitStaticAssertDeclaration(node: ast.StaticAssertDeclarationAST, context: Context): void;
    visitEmptyDeclaration(node: ast.EmptyDeclarationAST, context: Context): void;
    visitAttributeDeclaration(node: ast.AttributeDeclarationAST, context: Context): void;
    visitOpaqueEnumDeclaration(node: ast.OpaqueEnumDeclarationAST, context: Context): void;
    visitUsingEnumDeclaration(node: ast.UsingEnumDeclarationAST, context: Context): void;
    visitNamespaceDefinition(node: ast.NamespaceDefinitionAST, context: Context): void;
    visitNamespaceAliasDefinition(node: ast.NamespaceAliasDefinitionAST, context: Context): void;
    visitUsingDirective(node: ast.UsingDirectiveAST, context: Context): void;
    visitUsingDeclaration(node: ast.UsingDeclarationAST, context: Context): void;
    visitAsmDeclaration(node: ast.AsmDeclarationAST, context: Context): void;
    visitExportDeclaration(node: ast.ExportDeclarationAST, context: Context): void;
    visitExportCompoundDeclaration(node: ast.ExportCompoundDeclarationAST, context: Context): void;
    visitModuleImportDeclaration(node: ast.ModuleImportDeclarationAST, context: Context): void;
    visitTemplateDeclaration(node: ast.TemplateDeclarationAST, context: Context): void;
    visitTypenameTypeParameter(node: ast.TypenameTypeParameterAST, context: Context): void;
    visitTypenamePackTypeParameter(node: ast.TypenamePackTypeParameterAST, context: Context): void;
    visitTemplateTypeParameter(node: ast.TemplateTypeParameterAST, context: Context): void;
    visitTemplatePackTypeParameter(node: ast.TemplatePackTypeParameterAST, context: Context): void;
    visitDeductionGuide(node: ast.DeductionGuideAST, context: Context): void;
    visitExplicitInstantiation(node: ast.ExplicitInstantiationAST, context: Context): void;
    visitParameterDeclaration(node: ast.ParameterDeclarationAST, context: Context): void;
    visitLinkageSpecification(node: ast.LinkageSpecificationAST, context: Context): void;
    visitSimpleName(node: ast.SimpleNameAST, context: Context): void;
    visitDestructorName(node: ast.DestructorNameAST, context: Context): void;
    visitDecltypeName(node: ast.DecltypeNameAST, context: Context): void;
    visitOperatorName(node: ast.OperatorNameAST, context: Context): void;
    visitConversionName(node: ast.ConversionNameAST, context: Context): void;
    visitTemplateName(node: ast.TemplateNameAST, context: Context): void;
    visitQualifiedName(node: ast.QualifiedNameAST, context: Context): void;
    visitTypedefSpecifier(node: ast.TypedefSpecifierAST, context: Context): void;
    visitFriendSpecifier(node: ast.FriendSpecifierAST, context: Context): void;
    visitConstevalSpecifier(node: ast.ConstevalSpecifierAST, context: Context): void;
    visitConstinitSpecifier(node: ast.ConstinitSpecifierAST, context: Context): void;
    visitConstexprSpecifier(node: ast.ConstexprSpecifierAST, context: Context): void;
    visitInlineSpecifier(node: ast.InlineSpecifierAST, context: Context): void;
    visitStaticSpecifier(node: ast.StaticSpecifierAST, context: Context): void;
    visitExternSpecifier(node: ast.ExternSpecifierAST, context: Context): void;
    visitThreadLocalSpecifier(node: ast.ThreadLocalSpecifierAST, context: Context): void;
    visitThreadSpecifier(node: ast.ThreadSpecifierAST, context: Context): void;
    visitMutableSpecifier(node: ast.MutableSpecifierAST, context: Context): void;
    visitVirtualSpecifier(node: ast.VirtualSpecifierAST, context: Context): void;
    visitExplicitSpecifier(node: ast.ExplicitSpecifierAST, context: Context): void;
    visitAutoTypeSpecifier(node: ast.AutoTypeSpecifierAST, context: Context): void;
    visitVoidTypeSpecifier(node: ast.VoidTypeSpecifierAST, context: Context): void;
    visitVaListTypeSpecifier(node: ast.VaListTypeSpecifierAST, context: Context): void;
    visitIntegralTypeSpecifier(node: ast.IntegralTypeSpecifierAST, context: Context): void;
    visitFloatingPointTypeSpecifier(node: ast.FloatingPointTypeSpecifierAST, context: Context): void;
    visitComplexTypeSpecifier(node: ast.ComplexTypeSpecifierAST, context: Context): void;
    visitNamedTypeSpecifier(node: ast.NamedTypeSpecifierAST, context: Context): void;
    visitAtomicTypeSpecifier(node: ast.AtomicTypeSpecifierAST, context: Context): void;
    visitUnderlyingTypeSpecifier(node: ast.UnderlyingTypeSpecifierAST, context: Context): void;
    visitElaboratedTypeSpecifier(node: ast.ElaboratedTypeSpecifierAST, context: Context): void;
    visitDecltypeAutoSpecifier(node: ast.DecltypeAutoSpecifierAST, context: Context): void;
    visitDecltypeSpecifier(node: ast.DecltypeSpecifierAST, context: Context): void;
    visitPlaceholderTypeSpecifier(node: ast.PlaceholderTypeSpecifierAST, context: Context): void;
    visitConstQualifier(node: ast.ConstQualifierAST, context: Context): void;
    visitVolatileQualifier(node: ast.VolatileQualifierAST, context: Context): void;
    visitRestrictQualifier(node: ast.RestrictQualifierAST, context: Context): void;
    visitEnumSpecifier(node: ast.EnumSpecifierAST, context: Context): void;
    visitClassSpecifier(node: ast.ClassSpecifierAST, context: Context): void;
    visitTypenameSpecifier(node: ast.TypenameSpecifierAST, context: Context): void;
    visitIdDeclarator(node: ast.IdDeclaratorAST, context: Context): void;
    visitNestedDeclarator(node: ast.NestedDeclaratorAST, context: Context): void;
    visitPointerOperator(node: ast.PointerOperatorAST, context: Context): void;
    visitReferenceOperator(node: ast.ReferenceOperatorAST, context: Context): void;
    visitPtrToMemberOperator(node: ast.PtrToMemberOperatorAST, context: Context): void;
    visitFunctionDeclarator(node: ast.FunctionDeclaratorAST, context: Context): void;
    visitArrayDeclarator(node: ast.ArrayDeclaratorAST, context: Context): void;
}
