// Copyright (c) 2022 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
import { ASTVisitor } from "./ASTVisitor.js";
export class RecursiveASTVisitor extends ASTVisitor {
    constructor() {
        super();
    }
    accept(node, context) {
        node?.accept(this, context);
    }
    visitTypeId(node, context) {
        for (const element of node.getTypeSpecifierList()) {
            this.accept(element, context);
        }
        this.accept(node.getDeclarator(), context);
    }
    visitNestedNameSpecifier(node, context) {
        for (const element of node.getNameList()) {
            this.accept(element, context);
        }
    }
    visitUsingDeclarator(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitHandler(node, context) {
        this.accept(node.getExceptionDeclaration(), context);
        this.accept(node.getStatement(), context);
    }
    visitEnumBase(node, context) {
        for (const element of node.getTypeSpecifierList()) {
            this.accept(element, context);
        }
    }
    visitEnumerator(node, context) {
        this.accept(node.getName(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getExpression(), context);
    }
    visitDeclarator(node, context) {
        for (const element of node.getPtrOpList()) {
            this.accept(element, context);
        }
        this.accept(node.getCoreDeclarator(), context);
        for (const element of node.getModifiers()) {
            this.accept(element, context);
        }
    }
    visitInitDeclarator(node, context) {
        this.accept(node.getDeclarator(), context);
        this.accept(node.getRequiresClause(), context);
        this.accept(node.getInitializer(), context);
    }
    visitBaseSpecifier(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getName(), context);
    }
    visitBaseClause(node, context) {
        for (const element of node.getBaseSpecifierList()) {
            this.accept(element, context);
        }
    }
    visitNewTypeId(node, context) {
        for (const element of node.getTypeSpecifierList()) {
            this.accept(element, context);
        }
    }
    visitRequiresClause(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitParameterDeclarationClause(node, context) {
        for (const element of node.getParameterDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitParametersAndQualifiers(node, context) {
        this.accept(node.getParameterDeclarationClause(), context);
        for (const element of node.getCvQualifierList()) {
            this.accept(element, context);
        }
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitLambdaIntroducer(node, context) {
        for (const element of node.getCaptureList()) {
            this.accept(element, context);
        }
    }
    visitLambdaDeclarator(node, context) {
        this.accept(node.getParameterDeclarationClause(), context);
        for (const element of node.getDeclSpecifierList()) {
            this.accept(element, context);
        }
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getTrailingReturnType(), context);
        this.accept(node.getRequiresClause(), context);
    }
    visitTrailingReturnType(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitCtorInitializer(node, context) {
        for (const element of node.getMemInitializerList()) {
            this.accept(element, context);
        }
    }
    visitRequirementBody(node, context) {
        for (const element of node.getRequirementList()) {
            this.accept(element, context);
        }
    }
    visitTypeConstraint(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitGlobalModuleFragment(node, context) {
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitPrivateModuleFragment(node, context) {
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitModuleDeclaration(node, context) {
        this.accept(node.getModuleName(), context);
        this.accept(node.getModulePartition(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitModuleName(node, context) {
    }
    visitImportName(node, context) {
        this.accept(node.getModulePartition(), context);
        this.accept(node.getModuleName(), context);
    }
    visitModulePartition(node, context) {
        this.accept(node.getModuleName(), context);
    }
    visitSimpleRequirement(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitCompoundRequirement(node, context) {
        this.accept(node.getExpression(), context);
        this.accept(node.getTypeConstraint(), context);
    }
    visitTypeRequirement(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitNestedRequirement(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitTypeTemplateArgument(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitExpressionTemplateArgument(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitParenMemInitializer(node, context) {
        this.accept(node.getName(), context);
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitBracedMemInitializer(node, context) {
        this.accept(node.getName(), context);
        this.accept(node.getBracedInitList(), context);
    }
    visitThisLambdaCapture(node, context) {
    }
    visitDerefThisLambdaCapture(node, context) {
    }
    visitSimpleLambdaCapture(node, context) {
    }
    visitRefLambdaCapture(node, context) {
    }
    visitRefInitLambdaCapture(node, context) {
        this.accept(node.getInitializer(), context);
    }
    visitInitLambdaCapture(node, context) {
        this.accept(node.getInitializer(), context);
    }
    visitEqualInitializer(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitBracedInitList(node, context) {
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitParenInitializer(node, context) {
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitNewParenInitializer(node, context) {
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitNewBracedInitializer(node, context) {
        this.accept(node.getBracedInit(), context);
    }
    visitEllipsisExceptionDeclaration(node, context) {
    }
    visitTypeExceptionDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getTypeSpecifierList()) {
            this.accept(element, context);
        }
        this.accept(node.getDeclarator(), context);
    }
    visitDefaultFunctionBody(node, context) {
    }
    visitCompoundStatementFunctionBody(node, context) {
        this.accept(node.getCtorInitializer(), context);
        this.accept(node.getStatement(), context);
    }
    visitTryStatementFunctionBody(node, context) {
        this.accept(node.getCtorInitializer(), context);
        this.accept(node.getStatement(), context);
        for (const element of node.getHandlerList()) {
            this.accept(element, context);
        }
    }
    visitDeleteFunctionBody(node, context) {
    }
    visitTranslationUnit(node, context) {
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitModuleUnit(node, context) {
        this.accept(node.getGlobalModuleFragment(), context);
        this.accept(node.getModuleDeclaration(), context);
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
        this.accept(node.getPrivateModuleFragmentAST(), context);
    }
    visitThisExpression(node, context) {
    }
    visitCharLiteralExpression(node, context) {
    }
    visitBoolLiteralExpression(node, context) {
    }
    visitIntLiteralExpression(node, context) {
    }
    visitFloatLiteralExpression(node, context) {
    }
    visitNullptrLiteralExpression(node, context) {
    }
    visitStringLiteralExpression(node, context) {
    }
    visitUserDefinedStringLiteralExpression(node, context) {
    }
    visitIdExpression(node, context) {
        this.accept(node.getName(), context);
    }
    visitRequiresExpression(node, context) {
        this.accept(node.getParameterDeclarationClause(), context);
        this.accept(node.getRequirementBody(), context);
    }
    visitNestedExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitRightFoldExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitLeftFoldExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitFoldExpression(node, context) {
        this.accept(node.getLeftExpression(), context);
        this.accept(node.getRightExpression(), context);
    }
    visitLambdaExpression(node, context) {
        this.accept(node.getLambdaIntroducer(), context);
        for (const element of node.getTemplateParameterList()) {
            this.accept(element, context);
        }
        this.accept(node.getRequiresClause(), context);
        this.accept(node.getLambdaDeclarator(), context);
        this.accept(node.getStatement(), context);
    }
    visitSizeofExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitSizeofTypeExpression(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitSizeofPackExpression(node, context) {
    }
    visitTypeidExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitTypeidOfTypeExpression(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitAlignofExpression(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitTypeTraitsExpression(node, context) {
        for (const element of node.getTypeIdList()) {
            this.accept(element, context);
        }
    }
    visitUnaryExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitBinaryExpression(node, context) {
        this.accept(node.getLeftExpression(), context);
        this.accept(node.getRightExpression(), context);
    }
    visitAssignmentExpression(node, context) {
        this.accept(node.getLeftExpression(), context);
        this.accept(node.getRightExpression(), context);
    }
    visitBracedTypeConstruction(node, context) {
        this.accept(node.getTypeSpecifier(), context);
        this.accept(node.getBracedInitList(), context);
    }
    visitTypeConstruction(node, context) {
        this.accept(node.getTypeSpecifier(), context);
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitCallExpression(node, context) {
        this.accept(node.getBaseExpression(), context);
        for (const element of node.getExpressionList()) {
            this.accept(element, context);
        }
    }
    visitSubscriptExpression(node, context) {
        this.accept(node.getBaseExpression(), context);
        this.accept(node.getIndexExpression(), context);
    }
    visitMemberExpression(node, context) {
        this.accept(node.getBaseExpression(), context);
        this.accept(node.getName(), context);
    }
    visitPostIncrExpression(node, context) {
        this.accept(node.getBaseExpression(), context);
    }
    visitConditionalExpression(node, context) {
        this.accept(node.getCondition(), context);
        this.accept(node.getIftrueExpression(), context);
        this.accept(node.getIffalseExpression(), context);
    }
    visitImplicitCastExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitCastExpression(node, context) {
        this.accept(node.getTypeId(), context);
        this.accept(node.getExpression(), context);
    }
    visitCppCastExpression(node, context) {
        this.accept(node.getTypeId(), context);
        this.accept(node.getExpression(), context);
    }
    visitNewExpression(node, context) {
        this.accept(node.getTypeId(), context);
        this.accept(node.getNewInitalizer(), context);
    }
    visitDeleteExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitThrowExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitNoexceptExpression(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitLabeledStatement(node, context) {
        this.accept(node.getStatement(), context);
    }
    visitCaseStatement(node, context) {
        this.accept(node.getExpression(), context);
        this.accept(node.getStatement(), context);
    }
    visitDefaultStatement(node, context) {
        this.accept(node.getStatement(), context);
    }
    visitExpressionStatement(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitCompoundStatement(node, context) {
        for (const element of node.getStatementList()) {
            this.accept(element, context);
        }
    }
    visitIfStatement(node, context) {
        this.accept(node.getInitializer(), context);
        this.accept(node.getCondition(), context);
        this.accept(node.getStatement(), context);
        this.accept(node.getElseStatement(), context);
    }
    visitSwitchStatement(node, context) {
        this.accept(node.getInitializer(), context);
        this.accept(node.getCondition(), context);
        this.accept(node.getStatement(), context);
    }
    visitWhileStatement(node, context) {
        this.accept(node.getCondition(), context);
        this.accept(node.getStatement(), context);
    }
    visitDoStatement(node, context) {
        this.accept(node.getStatement(), context);
        this.accept(node.getExpression(), context);
    }
    visitForRangeStatement(node, context) {
        this.accept(node.getInitializer(), context);
        this.accept(node.getRangeDeclaration(), context);
        this.accept(node.getRangeInitializer(), context);
        this.accept(node.getStatement(), context);
    }
    visitForStatement(node, context) {
        this.accept(node.getInitializer(), context);
        this.accept(node.getCondition(), context);
        this.accept(node.getExpression(), context);
        this.accept(node.getStatement(), context);
    }
    visitBreakStatement(node, context) {
    }
    visitContinueStatement(node, context) {
    }
    visitReturnStatement(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitGotoStatement(node, context) {
    }
    visitCoroutineReturnStatement(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitDeclarationStatement(node, context) {
        this.accept(node.getDeclaration(), context);
    }
    visitTryBlockStatement(node, context) {
        this.accept(node.getStatement(), context);
        for (const element of node.getHandlerList()) {
            this.accept(element, context);
        }
    }
    visitAccessDeclaration(node, context) {
    }
    visitFunctionDefinition(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getDeclSpecifierList()) {
            this.accept(element, context);
        }
        this.accept(node.getDeclarator(), context);
        this.accept(node.getRequiresClause(), context);
        this.accept(node.getFunctionBody(), context);
    }
    visitConceptDefinition(node, context) {
        this.accept(node.getName(), context);
        this.accept(node.getExpression(), context);
    }
    visitForRangeDeclaration(node, context) {
    }
    visitAliasDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getTypeId(), context);
    }
    visitSimpleDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getDeclSpecifierList()) {
            this.accept(element, context);
        }
        for (const element of node.getInitDeclaratorList()) {
            this.accept(element, context);
        }
        this.accept(node.getRequiresClause(), context);
    }
    visitStaticAssertDeclaration(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitEmptyDeclaration(node, context) {
    }
    visitAttributeDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitOpaqueEnumDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
        this.accept(node.getEnumBase(), context);
    }
    visitUsingEnumDeclaration(node, context) {
    }
    visitNamespaceDefinition(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
        for (const element of node.getExtraAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitNamespaceAliasDefinition(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitUsingDirective(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitUsingDeclaration(node, context) {
        for (const element of node.getUsingDeclaratorList()) {
            this.accept(element, context);
        }
    }
    visitAsmDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitExportDeclaration(node, context) {
        this.accept(node.getDeclaration(), context);
    }
    visitExportCompoundDeclaration(node, context) {
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitModuleImportDeclaration(node, context) {
        this.accept(node.getImportName(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitTemplateDeclaration(node, context) {
        for (const element of node.getTemplateParameterList()) {
            this.accept(element, context);
        }
        this.accept(node.getRequiresClause(), context);
        this.accept(node.getDeclaration(), context);
    }
    visitTypenameTypeParameter(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitTypenamePackTypeParameter(node, context) {
    }
    visitTemplateTypeParameter(node, context) {
        for (const element of node.getTemplateParameterList()) {
            this.accept(element, context);
        }
        this.accept(node.getRequiresClause(), context);
        this.accept(node.getName(), context);
    }
    visitTemplatePackTypeParameter(node, context) {
        for (const element of node.getTemplateParameterList()) {
            this.accept(element, context);
        }
    }
    visitDeductionGuide(node, context) {
    }
    visitExplicitInstantiation(node, context) {
        this.accept(node.getDeclaration(), context);
    }
    visitParameterDeclaration(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getTypeSpecifierList()) {
            this.accept(element, context);
        }
        this.accept(node.getDeclarator(), context);
        this.accept(node.getExpression(), context);
    }
    visitLinkageSpecification(node, context) {
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitSimpleName(node, context) {
    }
    visitDestructorName(node, context) {
        this.accept(node.getId(), context);
    }
    visitDecltypeName(node, context) {
        this.accept(node.getDecltypeSpecifier(), context);
    }
    visitOperatorName(node, context) {
    }
    visitConversionName(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitTemplateName(node, context) {
        this.accept(node.getId(), context);
        for (const element of node.getTemplateArgumentList()) {
            this.accept(element, context);
        }
    }
    visitQualifiedName(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getId(), context);
    }
    visitTypedefSpecifier(node, context) {
    }
    visitFriendSpecifier(node, context) {
    }
    visitConstevalSpecifier(node, context) {
    }
    visitConstinitSpecifier(node, context) {
    }
    visitConstexprSpecifier(node, context) {
    }
    visitInlineSpecifier(node, context) {
    }
    visitStaticSpecifier(node, context) {
    }
    visitExternSpecifier(node, context) {
    }
    visitThreadLocalSpecifier(node, context) {
    }
    visitThreadSpecifier(node, context) {
    }
    visitMutableSpecifier(node, context) {
    }
    visitVirtualSpecifier(node, context) {
    }
    visitExplicitSpecifier(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitAutoTypeSpecifier(node, context) {
    }
    visitVoidTypeSpecifier(node, context) {
    }
    visitVaListTypeSpecifier(node, context) {
    }
    visitIntegralTypeSpecifier(node, context) {
    }
    visitFloatingPointTypeSpecifier(node, context) {
    }
    visitComplexTypeSpecifier(node, context) {
    }
    visitNamedTypeSpecifier(node, context) {
        this.accept(node.getName(), context);
    }
    visitAtomicTypeSpecifier(node, context) {
        this.accept(node.getTypeId(), context);
    }
    visitUnderlyingTypeSpecifier(node, context) {
    }
    visitElaboratedTypeSpecifier(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitDecltypeAutoSpecifier(node, context) {
    }
    visitDecltypeSpecifier(node, context) {
        this.accept(node.getExpression(), context);
    }
    visitPlaceholderTypeSpecifier(node, context) {
        this.accept(node.getTypeConstraint(), context);
        this.accept(node.getSpecifier(), context);
    }
    visitConstQualifier(node, context) {
    }
    visitVolatileQualifier(node, context) {
    }
    visitRestrictQualifier(node, context) {
    }
    visitEnumSpecifier(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
        this.accept(node.getEnumBase(), context);
        for (const element of node.getEnumeratorList()) {
            this.accept(element, context);
        }
    }
    visitClassSpecifier(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        this.accept(node.getName(), context);
        this.accept(node.getBaseClause(), context);
        for (const element of node.getDeclarationList()) {
            this.accept(element, context);
        }
    }
    visitTypenameSpecifier(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        this.accept(node.getName(), context);
    }
    visitIdDeclarator(node, context) {
        this.accept(node.getName(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitNestedDeclarator(node, context) {
        this.accept(node.getDeclarator(), context);
    }
    visitPointerOperator(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getCvQualifierList()) {
            this.accept(element, context);
        }
    }
    visitReferenceOperator(node, context) {
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
    visitPtrToMemberOperator(node, context) {
        this.accept(node.getNestedNameSpecifier(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
        for (const element of node.getCvQualifierList()) {
            this.accept(element, context);
        }
    }
    visitFunctionDeclarator(node, context) {
        this.accept(node.getParametersAndQualifiers(), context);
        this.accept(node.getTrailingReturnType(), context);
    }
    visitArrayDeclarator(node, context) {
        this.accept(node.getExpression(), context);
        for (const element of node.getAttributeList()) {
            this.accept(element, context);
        }
    }
}
//# sourceMappingURL=RecursiveASTVisitor.js.map