// Copyright (c) 2022 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
export var TokenKind;
(function (TokenKind) {
    TokenKind[TokenKind["EOF_SYMBOL"] = 0] = "EOF_SYMBOL";
    TokenKind[TokenKind["ERROR"] = 1] = "ERROR";
    TokenKind[TokenKind["COMMENT"] = 2] = "COMMENT";
    TokenKind[TokenKind["IDENTIFIER"] = 3] = "IDENTIFIER";
    TokenKind[TokenKind["CHARACTER_LITERAL"] = 4] = "CHARACTER_LITERAL";
    TokenKind[TokenKind["FLOATING_POINT_LITERAL"] = 5] = "FLOATING_POINT_LITERAL";
    TokenKind[TokenKind["INTEGER_LITERAL"] = 6] = "INTEGER_LITERAL";
    TokenKind[TokenKind["STRING_LITERAL"] = 7] = "STRING_LITERAL";
    TokenKind[TokenKind["WIDE_STRING_LITERAL"] = 8] = "WIDE_STRING_LITERAL";
    TokenKind[TokenKind["UTF8_STRING_LITERAL"] = 9] = "UTF8_STRING_LITERAL";
    TokenKind[TokenKind["UTF16_STRING_LITERAL"] = 10] = "UTF16_STRING_LITERAL";
    TokenKind[TokenKind["UTF32_STRING_LITERAL"] = 11] = "UTF32_STRING_LITERAL";
    TokenKind[TokenKind["USER_DEFINED_STRING_LITERAL"] = 12] = "USER_DEFINED_STRING_LITERAL";
    TokenKind[TokenKind["HASH"] = 13] = "HASH";
    TokenKind[TokenKind["HASH_HASH"] = 14] = "HASH_HASH";
    TokenKind[TokenKind["EXCLAIM"] = 15] = "EXCLAIM";
    TokenKind[TokenKind["EXCLAIM_EQUAL"] = 16] = "EXCLAIM_EQUAL";
    TokenKind[TokenKind["PERCENT"] = 17] = "PERCENT";
    TokenKind[TokenKind["PERCENT_EQUAL"] = 18] = "PERCENT_EQUAL";
    TokenKind[TokenKind["AMP"] = 19] = "AMP";
    TokenKind[TokenKind["AMP_AMP"] = 20] = "AMP_AMP";
    TokenKind[TokenKind["AMP_EQUAL"] = 21] = "AMP_EQUAL";
    TokenKind[TokenKind["LPAREN"] = 22] = "LPAREN";
    TokenKind[TokenKind["RPAREN"] = 23] = "RPAREN";
    TokenKind[TokenKind["STAR"] = 24] = "STAR";
    TokenKind[TokenKind["STAR_EQUAL"] = 25] = "STAR_EQUAL";
    TokenKind[TokenKind["PLUS"] = 26] = "PLUS";
    TokenKind[TokenKind["PLUS_PLUS"] = 27] = "PLUS_PLUS";
    TokenKind[TokenKind["PLUS_EQUAL"] = 28] = "PLUS_EQUAL";
    TokenKind[TokenKind["COMMA"] = 29] = "COMMA";
    TokenKind[TokenKind["MINUS"] = 30] = "MINUS";
    TokenKind[TokenKind["MINUS_MINUS"] = 31] = "MINUS_MINUS";
    TokenKind[TokenKind["MINUS_EQUAL"] = 32] = "MINUS_EQUAL";
    TokenKind[TokenKind["MINUS_GREATER"] = 33] = "MINUS_GREATER";
    TokenKind[TokenKind["MINUS_GREATER_STAR"] = 34] = "MINUS_GREATER_STAR";
    TokenKind[TokenKind["DOT"] = 35] = "DOT";
    TokenKind[TokenKind["DOT_STAR"] = 36] = "DOT_STAR";
    TokenKind[TokenKind["DOT_DOT_DOT"] = 37] = "DOT_DOT_DOT";
    TokenKind[TokenKind["SLASH"] = 38] = "SLASH";
    TokenKind[TokenKind["SLASH_EQUAL"] = 39] = "SLASH_EQUAL";
    TokenKind[TokenKind["COLON"] = 40] = "COLON";
    TokenKind[TokenKind["COLON_COLON"] = 41] = "COLON_COLON";
    TokenKind[TokenKind["SEMICOLON"] = 42] = "SEMICOLON";
    TokenKind[TokenKind["LESS"] = 43] = "LESS";
    TokenKind[TokenKind["LESS_LESS"] = 44] = "LESS_LESS";
    TokenKind[TokenKind["LESS_LESS_EQUAL"] = 45] = "LESS_LESS_EQUAL";
    TokenKind[TokenKind["LESS_EQUAL"] = 46] = "LESS_EQUAL";
    TokenKind[TokenKind["LESS_EQUAL_GREATER"] = 47] = "LESS_EQUAL_GREATER";
    TokenKind[TokenKind["EQUAL"] = 48] = "EQUAL";
    TokenKind[TokenKind["EQUAL_EQUAL"] = 49] = "EQUAL_EQUAL";
    TokenKind[TokenKind["GREATER"] = 50] = "GREATER";
    TokenKind[TokenKind["GREATER_EQUAL"] = 51] = "GREATER_EQUAL";
    TokenKind[TokenKind["GREATER_GREATER"] = 52] = "GREATER_GREATER";
    TokenKind[TokenKind["GREATER_GREATER_EQUAL"] = 53] = "GREATER_GREATER_EQUAL";
    TokenKind[TokenKind["QUESTION"] = 54] = "QUESTION";
    TokenKind[TokenKind["LBRACKET"] = 55] = "LBRACKET";
    TokenKind[TokenKind["RBRACKET"] = 56] = "RBRACKET";
    TokenKind[TokenKind["CARET"] = 57] = "CARET";
    TokenKind[TokenKind["CARET_EQUAL"] = 58] = "CARET_EQUAL";
    TokenKind[TokenKind["LBRACE"] = 59] = "LBRACE";
    TokenKind[TokenKind["BAR"] = 60] = "BAR";
    TokenKind[TokenKind["BAR_EQUAL"] = 61] = "BAR_EQUAL";
    TokenKind[TokenKind["BAR_BAR"] = 62] = "BAR_BAR";
    TokenKind[TokenKind["RBRACE"] = 63] = "RBRACE";
    TokenKind[TokenKind["TILDE"] = 64] = "TILDE";
    TokenKind[TokenKind["NEW_ARRAY"] = 65] = "NEW_ARRAY";
    TokenKind[TokenKind["DELETE_ARRAY"] = 66] = "DELETE_ARRAY";
    TokenKind[TokenKind["IMPORT"] = 67] = "IMPORT";
    TokenKind[TokenKind["MODULE"] = 68] = "MODULE";
    TokenKind[TokenKind["ALIGNAS"] = 69] = "ALIGNAS";
    TokenKind[TokenKind["ALIGNOF"] = 70] = "ALIGNOF";
    TokenKind[TokenKind["ASM"] = 71] = "ASM";
    TokenKind[TokenKind["AUTO"] = 72] = "AUTO";
    TokenKind[TokenKind["BOOL"] = 73] = "BOOL";
    TokenKind[TokenKind["BREAK"] = 74] = "BREAK";
    TokenKind[TokenKind["CASE"] = 75] = "CASE";
    TokenKind[TokenKind["CATCH"] = 76] = "CATCH";
    TokenKind[TokenKind["CHAR"] = 77] = "CHAR";
    TokenKind[TokenKind["CHAR16_T"] = 78] = "CHAR16_T";
    TokenKind[TokenKind["CHAR32_T"] = 79] = "CHAR32_T";
    TokenKind[TokenKind["CHAR8_T"] = 80] = "CHAR8_T";
    TokenKind[TokenKind["CLASS"] = 81] = "CLASS";
    TokenKind[TokenKind["CO_AWAIT"] = 82] = "CO_AWAIT";
    TokenKind[TokenKind["CO_RETURN"] = 83] = "CO_RETURN";
    TokenKind[TokenKind["CO_YIELD"] = 84] = "CO_YIELD";
    TokenKind[TokenKind["CONCEPT"] = 85] = "CONCEPT";
    TokenKind[TokenKind["CONST"] = 86] = "CONST";
    TokenKind[TokenKind["CONST_CAST"] = 87] = "CONST_CAST";
    TokenKind[TokenKind["CONSTEVAL"] = 88] = "CONSTEVAL";
    TokenKind[TokenKind["CONSTEXPR"] = 89] = "CONSTEXPR";
    TokenKind[TokenKind["CONSTINIT"] = 90] = "CONSTINIT";
    TokenKind[TokenKind["CONTINUE"] = 91] = "CONTINUE";
    TokenKind[TokenKind["DECLTYPE"] = 92] = "DECLTYPE";
    TokenKind[TokenKind["DEFAULT"] = 93] = "DEFAULT";
    TokenKind[TokenKind["DELETE"] = 94] = "DELETE";
    TokenKind[TokenKind["DO"] = 95] = "DO";
    TokenKind[TokenKind["DOUBLE"] = 96] = "DOUBLE";
    TokenKind[TokenKind["DYNAMIC_CAST"] = 97] = "DYNAMIC_CAST";
    TokenKind[TokenKind["ELSE"] = 98] = "ELSE";
    TokenKind[TokenKind["ENUM"] = 99] = "ENUM";
    TokenKind[TokenKind["EXPLICIT"] = 100] = "EXPLICIT";
    TokenKind[TokenKind["EXPORT"] = 101] = "EXPORT";
    TokenKind[TokenKind["EXTERN"] = 102] = "EXTERN";
    TokenKind[TokenKind["FALSE"] = 103] = "FALSE";
    TokenKind[TokenKind["FLOAT"] = 104] = "FLOAT";
    TokenKind[TokenKind["FOR"] = 105] = "FOR";
    TokenKind[TokenKind["FRIEND"] = 106] = "FRIEND";
    TokenKind[TokenKind["GOTO"] = 107] = "GOTO";
    TokenKind[TokenKind["IF"] = 108] = "IF";
    TokenKind[TokenKind["INLINE"] = 109] = "INLINE";
    TokenKind[TokenKind["INT"] = 110] = "INT";
    TokenKind[TokenKind["LONG"] = 111] = "LONG";
    TokenKind[TokenKind["MUTABLE"] = 112] = "MUTABLE";
    TokenKind[TokenKind["NAMESPACE"] = 113] = "NAMESPACE";
    TokenKind[TokenKind["NEW"] = 114] = "NEW";
    TokenKind[TokenKind["NOEXCEPT"] = 115] = "NOEXCEPT";
    TokenKind[TokenKind["NULLPTR"] = 116] = "NULLPTR";
    TokenKind[TokenKind["OPERATOR"] = 117] = "OPERATOR";
    TokenKind[TokenKind["PRIVATE"] = 118] = "PRIVATE";
    TokenKind[TokenKind["PROTECTED"] = 119] = "PROTECTED";
    TokenKind[TokenKind["PUBLIC"] = 120] = "PUBLIC";
    TokenKind[TokenKind["REINTERPRET_CAST"] = 121] = "REINTERPRET_CAST";
    TokenKind[TokenKind["REQUIRES"] = 122] = "REQUIRES";
    TokenKind[TokenKind["RETURN"] = 123] = "RETURN";
    TokenKind[TokenKind["SHORT"] = 124] = "SHORT";
    TokenKind[TokenKind["SIGNED"] = 125] = "SIGNED";
    TokenKind[TokenKind["SIZEOF"] = 126] = "SIZEOF";
    TokenKind[TokenKind["STATIC"] = 127] = "STATIC";
    TokenKind[TokenKind["STATIC_ASSERT"] = 128] = "STATIC_ASSERT";
    TokenKind[TokenKind["STATIC_CAST"] = 129] = "STATIC_CAST";
    TokenKind[TokenKind["STRUCT"] = 130] = "STRUCT";
    TokenKind[TokenKind["SWITCH"] = 131] = "SWITCH";
    TokenKind[TokenKind["TEMPLATE"] = 132] = "TEMPLATE";
    TokenKind[TokenKind["THIS"] = 133] = "THIS";
    TokenKind[TokenKind["THREAD_LOCAL"] = 134] = "THREAD_LOCAL";
    TokenKind[TokenKind["THROW"] = 135] = "THROW";
    TokenKind[TokenKind["TRUE"] = 136] = "TRUE";
    TokenKind[TokenKind["TRY"] = 137] = "TRY";
    TokenKind[TokenKind["TYPEDEF"] = 138] = "TYPEDEF";
    TokenKind[TokenKind["TYPEID"] = 139] = "TYPEID";
    TokenKind[TokenKind["TYPENAME"] = 140] = "TYPENAME";
    TokenKind[TokenKind["UNION"] = 141] = "UNION";
    TokenKind[TokenKind["UNSIGNED"] = 142] = "UNSIGNED";
    TokenKind[TokenKind["USING"] = 143] = "USING";
    TokenKind[TokenKind["VIRTUAL"] = 144] = "VIRTUAL";
    TokenKind[TokenKind["VOID"] = 145] = "VOID";
    TokenKind[TokenKind["VOLATILE"] = 146] = "VOLATILE";
    TokenKind[TokenKind["WCHAR_T"] = 147] = "WCHAR_T";
    TokenKind[TokenKind["WHILE"] = 148] = "WHILE";
    TokenKind[TokenKind["_ATOMIC"] = 149] = "_ATOMIC";
    TokenKind[TokenKind["_COMPLEX"] = 150] = "_COMPLEX";
    TokenKind[TokenKind["__ATTRIBUTE__"] = 151] = "__ATTRIBUTE__";
    TokenKind[TokenKind["__BUILTIN_VA_LIST"] = 152] = "__BUILTIN_VA_LIST";
    TokenKind[TokenKind["__COMPLEX__"] = 153] = "__COMPLEX__";
    TokenKind[TokenKind["__EXTENSION__"] = 154] = "__EXTENSION__";
    TokenKind[TokenKind["__FLOAT128"] = 155] = "__FLOAT128";
    TokenKind[TokenKind["__FLOAT80"] = 156] = "__FLOAT80";
    TokenKind[TokenKind["__IMAG__"] = 157] = "__IMAG__";
    TokenKind[TokenKind["__INT128"] = 158] = "__INT128";
    TokenKind[TokenKind["__INT64"] = 159] = "__INT64";
    TokenKind[TokenKind["__REAL__"] = 160] = "__REAL__";
    TokenKind[TokenKind["__RESTRICT__"] = 161] = "__RESTRICT__";
    TokenKind[TokenKind["__THREAD"] = 162] = "__THREAD";
    TokenKind[TokenKind["__UNDERLYING_TYPE"] = 163] = "__UNDERLYING_TYPE";
    TokenKind[TokenKind["__HAS_UNIQUE_OBJECT_REPRESENTATIONS"] = 164] = "__HAS_UNIQUE_OBJECT_REPRESENTATIONS";
    TokenKind[TokenKind["__HAS_VIRTUAL_DESTRUCTOR"] = 165] = "__HAS_VIRTUAL_DESTRUCTOR";
    TokenKind[TokenKind["__IS_ABSTRACT"] = 166] = "__IS_ABSTRACT";
    TokenKind[TokenKind["__IS_AGGREGATE"] = 167] = "__IS_AGGREGATE";
    TokenKind[TokenKind["__IS_ARITHMETIC"] = 168] = "__IS_ARITHMETIC";
    TokenKind[TokenKind["__IS_ARRAY"] = 169] = "__IS_ARRAY";
    TokenKind[TokenKind["__IS_ASSIGNABLE"] = 170] = "__IS_ASSIGNABLE";
    TokenKind[TokenKind["__IS_BASE_OF"] = 171] = "__IS_BASE_OF";
    TokenKind[TokenKind["__IS_BOUNDED_ARRAY"] = 172] = "__IS_BOUNDED_ARRAY";
    TokenKind[TokenKind["__IS_CLASS"] = 173] = "__IS_CLASS";
    TokenKind[TokenKind["__IS_COMPOUND"] = 174] = "__IS_COMPOUND";
    TokenKind[TokenKind["__IS_CONST"] = 175] = "__IS_CONST";
    TokenKind[TokenKind["__IS_CONSTRUCTIBLE"] = 176] = "__IS_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_CONVERTIBLE"] = 177] = "__IS_CONVERTIBLE";
    TokenKind[TokenKind["__IS_COPY_ASSIGNABLE"] = 178] = "__IS_COPY_ASSIGNABLE";
    TokenKind[TokenKind["__IS_COPY_CONSTRUCTIBLE"] = 179] = "__IS_COPY_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_DEFAULT_CONSTRUCTIBLE"] = 180] = "__IS_DEFAULT_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_DESTRUCTIBLE"] = 181] = "__IS_DESTRUCTIBLE";
    TokenKind[TokenKind["__IS_EMPTY"] = 182] = "__IS_EMPTY";
    TokenKind[TokenKind["__IS_ENUM"] = 183] = "__IS_ENUM";
    TokenKind[TokenKind["__IS_FINAL"] = 184] = "__IS_FINAL";
    TokenKind[TokenKind["__IS_FLOATING_POINT"] = 185] = "__IS_FLOATING_POINT";
    TokenKind[TokenKind["__IS_FUNCTION"] = 186] = "__IS_FUNCTION";
    TokenKind[TokenKind["__IS_FUNDAMENTAL"] = 187] = "__IS_FUNDAMENTAL";
    TokenKind[TokenKind["__IS_INTEGRAL"] = 188] = "__IS_INTEGRAL";
    TokenKind[TokenKind["__IS_INVOCABLE"] = 189] = "__IS_INVOCABLE";
    TokenKind[TokenKind["__IS_INVOCABLE_R"] = 190] = "__IS_INVOCABLE_R";
    TokenKind[TokenKind["__IS_LAYOUT_COMPATIBLE"] = 191] = "__IS_LAYOUT_COMPATIBLE";
    TokenKind[TokenKind["__IS_LITERAL_TYPE"] = 192] = "__IS_LITERAL_TYPE";
    TokenKind[TokenKind["__IS_LVALUE_REFERENCE"] = 193] = "__IS_LVALUE_REFERENCE";
    TokenKind[TokenKind["__IS_MEMBER_FUNCTION_POINTER"] = 194] = "__IS_MEMBER_FUNCTION_POINTER";
    TokenKind[TokenKind["__IS_MEMBER_OBJECT_POINTER"] = 195] = "__IS_MEMBER_OBJECT_POINTER";
    TokenKind[TokenKind["__IS_MEMBER_POINTER"] = 196] = "__IS_MEMBER_POINTER";
    TokenKind[TokenKind["__IS_MOVE_ASSIGNABLE"] = 197] = "__IS_MOVE_ASSIGNABLE";
    TokenKind[TokenKind["__IS_MOVE_CONSTRUCTIBLE"] = 198] = "__IS_MOVE_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_ASSIGNABLE"] = 199] = "__IS_NOTHROW_ASSIGNABLE";
    TokenKind[TokenKind["__IS_NOTHROW_CONSTRUCTIBLE"] = 200] = "__IS_NOTHROW_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_CONVERTIBLE"] = 201] = "__IS_NOTHROW_CONVERTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_COPY_ASSIGNABLE"] = 202] = "__IS_NOTHROW_COPY_ASSIGNABLE";
    TokenKind[TokenKind["__IS_NOTHROW_COPY_CONSTRUCTIBLE"] = 203] = "__IS_NOTHROW_COPY_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_DEFAULT_CONSTRUCTIBLE"] = 204] = "__IS_NOTHROW_DEFAULT_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_DESTRUCTIBLE"] = 205] = "__IS_NOTHROW_DESTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_INVOCABLE"] = 206] = "__IS_NOTHROW_INVOCABLE";
    TokenKind[TokenKind["__IS_NOTHROW_INVOCABLE_R"] = 207] = "__IS_NOTHROW_INVOCABLE_R";
    TokenKind[TokenKind["__IS_NOTHROW_MOVE_ASSIGNABLE"] = 208] = "__IS_NOTHROW_MOVE_ASSIGNABLE";
    TokenKind[TokenKind["__IS_NOTHROW_MOVE_CONSTRUCTIBLE"] = 209] = "__IS_NOTHROW_MOVE_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_NOTHROW_SWAPPABLE"] = 210] = "__IS_NOTHROW_SWAPPABLE";
    TokenKind[TokenKind["__IS_NOTHROW_SWAPPABLE_WITH"] = 211] = "__IS_NOTHROW_SWAPPABLE_WITH";
    TokenKind[TokenKind["__IS_NULL_POINTER"] = 212] = "__IS_NULL_POINTER";
    TokenKind[TokenKind["__IS_OBJECT"] = 213] = "__IS_OBJECT";
    TokenKind[TokenKind["__IS_POD"] = 214] = "__IS_POD";
    TokenKind[TokenKind["__IS_POINTER"] = 215] = "__IS_POINTER";
    TokenKind[TokenKind["__IS_POINTER_INTERCONVERTIBLE_BASE_OF"] = 216] = "__IS_POINTER_INTERCONVERTIBLE_BASE_OF";
    TokenKind[TokenKind["__IS_POLYMORPHIC"] = 217] = "__IS_POLYMORPHIC";
    TokenKind[TokenKind["__IS_REFERENCE"] = 218] = "__IS_REFERENCE";
    TokenKind[TokenKind["__IS_RVALUE_REFERENCE"] = 219] = "__IS_RVALUE_REFERENCE";
    TokenKind[TokenKind["__IS_SAME"] = 220] = "__IS_SAME";
    TokenKind[TokenKind["__IS_SCALAR"] = 221] = "__IS_SCALAR";
    TokenKind[TokenKind["__IS_SCOPED_ENUM"] = 222] = "__IS_SCOPED_ENUM";
    TokenKind[TokenKind["__IS_SIGNED"] = 223] = "__IS_SIGNED";
    TokenKind[TokenKind["__IS_STANDARD_LAYOUT"] = 224] = "__IS_STANDARD_LAYOUT";
    TokenKind[TokenKind["__IS_SWAPPABLE"] = 225] = "__IS_SWAPPABLE";
    TokenKind[TokenKind["__IS_SWAPPABLE_WITH"] = 226] = "__IS_SWAPPABLE_WITH";
    TokenKind[TokenKind["__IS_TRIVIAL"] = 227] = "__IS_TRIVIAL";
    TokenKind[TokenKind["__IS_TRIVIALLY_ASSIGNABLE"] = 228] = "__IS_TRIVIALLY_ASSIGNABLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_CONSTRUCTIBLE"] = 229] = "__IS_TRIVIALLY_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_COPY_ASSIGNABLE"] = 230] = "__IS_TRIVIALLY_COPY_ASSIGNABLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_COPY_CONSTRUCTIBLE"] = 231] = "__IS_TRIVIALLY_COPY_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_COPYABLE"] = 232] = "__IS_TRIVIALLY_COPYABLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_DEFAULT_CONSTRUCTIBLE"] = 233] = "__IS_TRIVIALLY_DEFAULT_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_DESTRUCTIBLE"] = 234] = "__IS_TRIVIALLY_DESTRUCTIBLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_MOVE_ASSIGNABLE"] = 235] = "__IS_TRIVIALLY_MOVE_ASSIGNABLE";
    TokenKind[TokenKind["__IS_TRIVIALLY_MOVE_CONSTRUCTIBLE"] = 236] = "__IS_TRIVIALLY_MOVE_CONSTRUCTIBLE";
    TokenKind[TokenKind["__IS_UNBOUNDED_ARRAY"] = 237] = "__IS_UNBOUNDED_ARRAY";
    TokenKind[TokenKind["__IS_UNION"] = 238] = "__IS_UNION";
    TokenKind[TokenKind["__IS_UNSIGNED"] = 239] = "__IS_UNSIGNED";
    TokenKind[TokenKind["__IS_VOID"] = 240] = "__IS_VOID";
    TokenKind[TokenKind["__IS_VOLATILE"] = 241] = "__IS_VOLATILE";
    TokenKind[TokenKind["__REFERENCE_BINDS_TO_TEMPORARY"] = 242] = "__REFERENCE_BINDS_TO_TEMPORARY";
})(TokenKind || (TokenKind = {}));
//# sourceMappingURL=TokenKind.js.map