import { SourceLocation } from "./SourceLocation.js";
import { TokenKind } from "./TokenKind.js";
import { Unit } from "./Unit.js";
export declare enum ASTSlotKind {
    Invalid = 0,
    Token = 1,
    Node = 2,
    TokenList = 3,
    NodeList = 4
}
export interface CXX {
    createUnit(source: string, path: string): Unit;
    getASTKind(handle: number): number;
    getASTSlot(handle: number, slot: number): number;
    getASTSlotKind(handle: number, slot: number): ASTSlotKind;
    getASTSlotCount(handle: number, slot: number): number;
    getListValue(handle: number): number;
    getListNext(handle: number): number;
    getTokenText(handle: number, unitHandle: number): string;
    getTokenKind(handle: number, unitHandle: number): TokenKind;
    getTokenLocation(handle: number, unitHandle: number): SourceLocation;
    getStartLocation(handle: number, unitHandle: number): SourceLocation;
    getEndLocation(handle: number, unitHandle: number): SourceLocation;
}
export declare let cxx: CXX;
declare const _default: ({ wasmBinary }: {
    wasmBinary: Uint8Array;
}) => Promise<CXX>;
export default _default;
