// Copyright (c) 2022 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//@ts-ignore
import makeCxx from "./cxx-js.js";
export var ASTSlotKind;
(function (ASTSlotKind) {
    ASTSlotKind[ASTSlotKind["Invalid"] = 0] = "Invalid";
    ASTSlotKind[ASTSlotKind["Token"] = 1] = "Token";
    ASTSlotKind[ASTSlotKind["Node"] = 2] = "Node";
    ASTSlotKind[ASTSlotKind["TokenList"] = 3] = "TokenList";
    ASTSlotKind[ASTSlotKind["NodeList"] = 4] = "NodeList";
})(ASTSlotKind || (ASTSlotKind = {}));
;
export let cxx;
export default async ({ wasmBinary }) => {
    cxx = await makeCxx({ wasmBinary });
    return cxx;
};
//# sourceMappingURL=cxx.js.map