// Copyright (c) 2022 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

export enum TokenKind {
    EOF_SYMBOL,
    ERROR,
    COMMENT,
    IDENTIFIER,
    CHARACTER_LITERAL,
    FLOATING_POINT_LITERAL,
    INTEGER_LITERAL,
    STRING_LITERAL,
    WIDE_STRING_LITERAL,
    UTF8_STRING_LITERAL,
    UTF16_STRING_LITERAL,
    UTF32_STRING_LITERAL,
    USER_DEFINED_STRING_LITERAL,
    HASH,
    HASH_HASH,
    EXCLAIM,
    EXCLAIM_EQUAL,
    PERCENT,
    PERCENT_EQUAL,
    AMP,
    AMP_AMP,
    AMP_EQUAL,
    LPAREN,
    RPAREN,
    STAR,
    STAR_EQUAL,
    PLUS,
    PLUS_PLUS,
    PLUS_EQUAL,
    COMMA,
    MINUS,
    MINUS_MINUS,
    MINUS_EQUAL,
    MINUS_GREATER,
    MINUS_GREATER_STAR,
    DOT,
    DOT_STAR,
    DOT_DOT_DOT,
    SLASH,
    SLASH_EQUAL,
    COLON,
    COLON_COLON,
    SEMICOLON,
    LESS,
    LESS_LESS,
    LESS_LESS_EQUAL,
    LESS_EQUAL,
    LESS_EQUAL_GREATER,
    EQUAL,
    EQUAL_EQUAL,
    GREATER,
    GREATER_EQUAL,
    GREATER_GREATER,
    GREATER_GREATER_EQUAL,
    QUESTION,
    LBRACKET,
    RBRACKET,
    CARET,
    CARET_EQUAL,
    LBRACE,
    BAR,
    BAR_EQUAL,
    BAR_BAR,
    RBRACE,
    TILDE,
    NEW_ARRAY,
    DELETE_ARRAY,
    IMPORT,
    MODULE,
    ALIGNAS,
    ALIGNOF,
    ASM,
    AUTO,
    BOOL,
    BREAK,
    CASE,
    CATCH,
    CHAR,
    CHAR16_T,
    CHAR32_T,
    CHAR8_T,
    CLASS,
    CO_AWAIT,
    CO_RETURN,
    CO_YIELD,
    CONCEPT,
    CONST,
    CONST_CAST,
    CONSTEVAL,
    CONSTEXPR,
    CONSTINIT,
    CONTINUE,
    DECLTYPE,
    DEFAULT,
    DELETE,
    DO,
    DOUBLE,
    DYNAMIC_CAST,
    ELSE,
    ENUM,
    EXPLICIT,
    EXPORT,
    EXTERN,
    FALSE,
    FLOAT,
    FOR,
    FRIEND,
    GOTO,
    IF,
    INLINE,
    INT,
    LONG,
    MUTABLE,
    NAMESPACE,
    NEW,
    NOEXCEPT,
    NULLPTR,
    OPERATOR,
    PRIVATE,
    PROTECTED,
    PUBLIC,
    REINTERPRET_CAST,
    REQUIRES,
    RETURN,
    SHORT,
    SIGNED,
    SIZEOF,
    STATIC,
    STATIC_ASSERT,
    STATIC_CAST,
    STRUCT,
    SWITCH,
    TEMPLATE,
    THIS,
    THREAD_LOCAL,
    THROW,
    TRUE,
    TRY,
    TYPEDEF,
    TYPEID,
    TYPENAME,
    UNION,
    UNSIGNED,
    USING,
    VIRTUAL,
    VOID,
    VOLATILE,
    WCHAR_T,
    WHILE,
    _ATOMIC,
    _COMPLEX,
    __ATTRIBUTE__,
    __BUILTIN_VA_LIST,
    __COMPLEX__,
    __EXTENSION__,
    __FLOAT128,
    __FLOAT80,
    __IMAG__,
    __INT128,
    __INT64,
    __REAL__,
    __RESTRICT__,
    __THREAD,
    __UNDERLYING_TYPE,
    __HAS_UNIQUE_OBJECT_REPRESENTATIONS,
    __HAS_VIRTUAL_DESTRUCTOR,
    __IS_ABSTRACT,
    __IS_AGGREGATE,
    __IS_ARITHMETIC,
    __IS_ARRAY,
    __IS_ASSIGNABLE,
    __IS_BASE_OF,
    __IS_BOUNDED_ARRAY,
    __IS_CLASS,
    __IS_COMPOUND,
    __IS_CONST,
    __IS_CONSTRUCTIBLE,
    __IS_CONVERTIBLE,
    __IS_COPY_ASSIGNABLE,
    __IS_COPY_CONSTRUCTIBLE,
    __IS_DEFAULT_CONSTRUCTIBLE,
    __IS_DESTRUCTIBLE,
    __IS_EMPTY,
    __IS_ENUM,
    __IS_FINAL,
    __IS_FLOATING_POINT,
    __IS_FUNCTION,
    __IS_FUNDAMENTAL,
    __IS_INTEGRAL,
    __IS_INVOCABLE,
    __IS_INVOCABLE_R,
    __IS_LAYOUT_COMPATIBLE,
    __IS_LITERAL_TYPE,
    __IS_LVALUE_REFERENCE,
    __IS_MEMBER_FUNCTION_POINTER,
    __IS_MEMBER_OBJECT_POINTER,
    __IS_MEMBER_POINTER,
    __IS_MOVE_ASSIGNABLE,
    __IS_MOVE_CONSTRUCTIBLE,
    __IS_NOTHROW_ASSIGNABLE,
    __IS_NOTHROW_CONSTRUCTIBLE,
    __IS_NOTHROW_CONVERTIBLE,
    __IS_NOTHROW_COPY_ASSIGNABLE,
    __IS_NOTHROW_COPY_CONSTRUCTIBLE,
    __IS_NOTHROW_DEFAULT_CONSTRUCTIBLE,
    __IS_NOTHROW_DESTRUCTIBLE,
    __IS_NOTHROW_INVOCABLE,
    __IS_NOTHROW_INVOCABLE_R,
    __IS_NOTHROW_MOVE_ASSIGNABLE,
    __IS_NOTHROW_MOVE_CONSTRUCTIBLE,
    __IS_NOTHROW_SWAPPABLE,
    __IS_NOTHROW_SWAPPABLE_WITH,
    __IS_NULL_POINTER,
    __IS_OBJECT,
    __IS_POD,
    __IS_POINTER,
    __IS_POINTER_INTERCONVERTIBLE_BASE_OF,
    __IS_POLYMORPHIC,
    __IS_REFERENCE,
    __IS_RVALUE_REFERENCE,
    __IS_SAME,
    __IS_SCALAR,
    __IS_SCOPED_ENUM,
    __IS_SIGNED,
    __IS_STANDARD_LAYOUT,
    __IS_SWAPPABLE,
    __IS_SWAPPABLE_WITH,
    __IS_TRIVIAL,
    __IS_TRIVIALLY_ASSIGNABLE,
    __IS_TRIVIALLY_CONSTRUCTIBLE,
    __IS_TRIVIALLY_COPY_ASSIGNABLE,
    __IS_TRIVIALLY_COPY_CONSTRUCTIBLE,
    __IS_TRIVIALLY_COPYABLE,
    __IS_TRIVIALLY_DEFAULT_CONSTRUCTIBLE,
    __IS_TRIVIALLY_DESTRUCTIBLE,
    __IS_TRIVIALLY_MOVE_ASSIGNABLE,
    __IS_TRIVIALLY_MOVE_CONSTRUCTIBLE,
    __IS_UNBOUNDED_ARRAY,
    __IS_UNION,
    __IS_UNSIGNED,
    __IS_VOID,
    __IS_VOLATILE,
    __REFERENCE_BINDS_TO_TEMPORARY,
}
