"use strict";
var xstream_1 = require('xstream');
var xstream_adapter_1 = require('@cycle/xstream-adapter');
var HTMLSource = (function () {
    function HTMLSource(html$, runSA) {
        this.runSA = runSA;
        this._html$ = html$;
        this._empty$ = runSA.adapt(xstream_1.default.empty(), xstream_adapter_1.default.streamSubscribe);
    }
    HTMLSource.prototype.elements = function () {
        return this.runSA.adapt(this._html$, xstream_adapter_1.default.streamSubscribe);
    };
    HTMLSource.prototype.select = function (selector) {
        return new HTMLSource(xstream_1.default.empty(), this.runSA);
    };
    HTMLSource.prototype.events = function (eventType, options) {
        return this._empty$;
    };
    return HTMLSource;
}());
exports.HTMLSource = HTMLSource;
//# sourceMappingURL=HTMLSource.js.map