import { StreamAdapter } from '@cycle/base';
import { Stream } from 'xstream';
import { DOMSource } from './DOMSource';
import { VNode } from './interfaces';
import { IsolateModule } from './isolateModule';
import { EventDelegator } from './EventDelegator';
export interface EventsFnOptions {
    useCapture?: boolean;
}
export declare class MainDOMSource implements DOMSource {
    private _rootElement$;
    private _runStreamAdapter;
    private _namespace;
    _isolateModule: IsolateModule;
    _delegators: Map<string, EventDelegator>;
    constructor(_rootElement$: Stream<Element>, _runStreamAdapter: StreamAdapter, _namespace: Array<string>, _isolateModule: IsolateModule, _delegators: Map<string, EventDelegator>);
    elements(): any;
    namespace: Array<string>;
    select(selector: string): DOMSource;
    events(eventType: string, options?: EventsFnOptions): any;
    dispose(): void;
    isolateSource: (source: DOMSource, scope: string) => DOMSource;
    isolateSink: (sink: Stream<VNode>, scope: string) => Stream<VNode>;
}
