'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _rx = require('rx');

var _rx2 = _interopRequireDefault(_rx);

var emptyStream = _rx2['default'].Observable.empty();

function getEventsStreamForSelector(mockedEventTypes) {
  return function getEventsStream(eventType) {
    for (var key in mockedEventTypes) {
      if (mockedEventTypes.hasOwnProperty(key) && key === eventType) {
        return mockedEventTypes[key];
      }
    }
    return emptyStream;
  };
}

function makeMockSelector(mockedSelectors) {
  return function select(selector) {
    for (var key in mockedSelectors) {
      if (mockedSelectors.hasOwnProperty(key) && key === selector) {
        var observable = emptyStream;
        if (mockedSelectors[key].hasOwnProperty('observable')) {
          observable = mockedSelectors[key].observable;
        }
        return {
          observable: observable,
          select: makeMockSelector(mockedSelectors[key]),
          events: getEventsStreamForSelector(mockedSelectors[key])
        };
      }
    }
    return {
      observable: emptyStream,
      select: makeMockSelector(mockedSelectors),
      events: function events() {
        return emptyStream;
      }
    };
  };
}

function mockDOMSource() {
  var mockedSelectors = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  return {
    observable: emptyStream,
    select: makeMockSelector(mockedSelectors),
    events: function events() {
      return emptyStream;
    }
  };
}

exports['default'] = mockDOMSource;
module.exports = exports['default'];