"use strict";

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; })();

var Rx = require("rx");
var fromEvent = require("./fromevent");
var VDOM = {
  h: require("./virtual-hyperscript"),
  diff: require("virtual-dom/diff"),
  patch: require("virtual-dom/patch"),
  parse: typeof window !== "undefined" ? require("vdom-parser") : function () {}
};

var _require = require("./transposition");

var transposeVTree = _require.transposeVTree;

var matchesSelector = undefined;
// Try-catch to prevent unnecessary import of DOM-specifics in Node.js env:
try {
  matchesSelector = require("matches-selector");
} catch (err) {
  matchesSelector = function () {};
}

function isElement(obj) {
  return typeof HTMLElement === "object" ? obj instanceof HTMLElement || obj instanceof DocumentFragment : //DOM2
  obj && typeof obj === "object" && obj !== null && (obj.nodeType === 1 || obj.nodeType === 11) && typeof obj.nodeName === "string";
}

function wrapTopLevelVTree(vtree, rootElem) {
  var _vtree$properties$id = vtree.properties.id;
  var vtreeId = _vtree$properties$id === undefined ? "" : _vtree$properties$id;
  var _vtree$properties$className = vtree.properties.className;
  var vtreeClass = _vtree$properties$className === undefined ? "" : _vtree$properties$className;

  var sameId = vtreeId === rootElem.id;
  var sameClass = vtreeClass === rootElem.className;
  var sameTagName = vtree.tagName.toUpperCase() === rootElem.tagName;
  if (sameId && sameClass && sameTagName) {
    return vtree;
  }
  var attrs = {};
  if (rootElem.id) {
    attrs.id = rootElem.id;
  }
  if (rootElem.className) {
    attrs.className = rootElem.className;
  }
  return VDOM.h(rootElem.tagName, attrs, [vtree]);
}

function makeDiffAndPatchToElement$(rootElem) {
  return function diffAndPatchToElement$(_ref) {
    var _ref2 = _slicedToArray(_ref, 2);

    var oldVTree = _ref2[0];
    var newVTree = _ref2[1];

    if (typeof newVTree === "undefined") {
      return Rx.Observable.empty();
    }

    var prevVTree = wrapTopLevelVTree(oldVTree, rootElem);
    var nextVTree = wrapTopLevelVTree(newVTree, rootElem);
    /* eslint-disable */
    rootElem = VDOM.patch(rootElem, VDOM.diff(prevVTree, nextVTree));
    /* eslint-enable */
    return Rx.Observable.just(rootElem);
  };
}

function renderRawRootElem$(vtree$, domContainer) {
  var diffAndPatchToElement$ = makeDiffAndPatchToElement$(domContainer);
  return vtree$.flatMapLatest(transposeVTree).startWith(VDOM.parse(domContainer)).pairwise().flatMap(diffAndPatchToElement$);
}

function isolateSource(source, scope) {
  return source.select(".cycle-scope-" + scope);
}

function isolateSink(sink, scope) {
  return sink.map(function (vtree) {
    var _vtree$properties$className2 = vtree.properties.className;
    var vtreeClass = _vtree$properties$className2 === undefined ? "" : _vtree$properties$className2;

    if (vtreeClass.indexOf("cycle-scope-" + scope) === -1) {
      var c = (vtreeClass + " cycle-scope-" + scope).trim();
      vtree.properties.className = c;
    }
    if (vtree.properties.attributes) {
      // for svg root elements
      var vtreeAttrClass = vtree.properties.attributes["class"] || "";
      if (vtreeAttrClass.indexOf("cycle-scope-" + scope) === -1) {
        var cattr = (vtreeAttrClass + " cycle-scope-" + scope).trim();
        vtree.properties.attributes["class"] = cattr;
      }
    }
    return vtree;
  });
}

function makeIsStrictlyInRootScope(namespace) {
  var classIsForeign = function classIsForeign(c) {
    var matched = c.match(/cycle-scope-(\S+)/);
    return matched && namespace.indexOf("." + c) === -1;
  };
  var classIsDomestic = function classIsDomestic(c) {
    var matched = c.match(/cycle-scope-(\S+)/);
    return matched && namespace.indexOf("." + c) !== -1;
  };
  return function isStrictlyInRootScope(leaf) {
    for (var el = leaf; el; el = el.parentElement) {
      var split = String.prototype.split;
      var classList = el.classList || split.call(el.className, " ");
      if (Array.prototype.some.call(classList, classIsDomestic)) {
        return true;
      }
      if (Array.prototype.some.call(classList, classIsForeign)) {
        return false;
      }
    }
    return true;
  };
}

var eventTypesThatDontBubble = ["load", "unload", "focus", "blur", "mouseenter", "mouseleave", "submit", "change", "reset", "timeupdate", "playing", "waiting", "seeking", "seeked", "ended", "loadedmetadata", "loadeddata", "canplay", "canplaythrough", "durationchange", "play", "pause", "ratechange", "volumechange", "suspend", "emptied", "stalled"];

function maybeMutateEventPropagationAttributes(event) {
  if (!event.hasOwnProperty("propagationHasBeenStopped")) {
    (function () {
      event.propagationHasBeenStopped = false;
      var oldStopPropagation = event.stopPropagation;
      event.stopPropagation = function stopPropagation() {
        oldStopPropagation.call(this);
        this.propagationHasBeenStopped = true;
      };
    })();
  }
}

function mutateEventCurrentTarget(event, currentTargetElement) {
  try {
    Object.defineProperty(event, "currentTarget", {
      value: currentTargetElement,
      configurable: true
    });
  } catch (err) {
    void err; // noop
  }
  event.ownerTarget = currentTargetElement;
}

function makeSimulateBubbling(namespace, rootEl) {
  var isStrictlyInRootScope = makeIsStrictlyInRootScope(namespace);
  var descendantSel = namespace.join(" ");
  var topSel = namespace.join("");
  var roof = rootEl.parentElement;

  return function simulateBubbling(ev) {
    maybeMutateEventPropagationAttributes(ev);
    if (ev.propagationHasBeenStopped) {
      return false;
    }
    for (var el = ev.target; el && el !== roof; el = el.parentElement) {
      if (!isStrictlyInRootScope(el)) {
        continue;
      }
      if (matchesSelector(el, descendantSel) || matchesSelector(el, topSel)) {
        mutateEventCurrentTarget(ev, el);
        return true;
      }
    }
    return false;
  };
}

function makeEventsSelector(rootEl$, namespace) {
  return function events(eventName) {
    var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    if (typeof eventName !== "string") {
      throw new Error("DOM driver's events() expects argument to be a " + "string representing the event type to listen for.");
    }
    var useCapture = false;
    if (eventTypesThatDontBubble.indexOf(eventName) !== -1) {
      useCapture = true;
    }
    if (typeof options.useCapture === "boolean") {
      useCapture = options.useCapture;
    }

    return rootEl$.first().flatMapLatest(function (rootEl) {
      if (!namespace || namespace.length === 0) {
        return fromEvent(rootEl, eventName, useCapture);
      }
      var simulateBubbling = makeSimulateBubbling(namespace, rootEl);
      return fromEvent(rootEl, eventName, useCapture).filter(simulateBubbling);
    }).share();
  };
}

function makeElementSelector(rootEl$) {
  return function select(selector) {
    if (typeof selector !== "string") {
      throw new Error("DOM driver's select() expects the argument to be a " + "string as a CSS selector");
    }

    var namespace = this.namespace;
    var trimmedSelector = selector.trim();
    var childNamespace = trimmedSelector === ":root" ? namespace : namespace.concat(trimmedSelector);
    var element$ = rootEl$.map(function (rootEl) {
      if (childNamespace.join("") === "") {
        return rootEl;
      }
      var nodeList = rootEl.querySelectorAll(childNamespace.join(" "));
      if (nodeList.length === 0) {
        nodeList = rootEl.querySelectorAll(childNamespace.join(""));
      }
      var array = Array.prototype.slice.call(nodeList);
      return array.filter(makeIsStrictlyInRootScope(childNamespace));
    });
    return {
      observable: element$,
      namespace: childNamespace,
      select: makeElementSelector(rootEl$),
      events: makeEventsSelector(rootEl$, childNamespace),
      isolateSource: isolateSource,
      isolateSink: isolateSink
    };
  };
}

function validateDOMSink(vtree$) {
  if (!vtree$ || typeof vtree$.subscribe !== "function") {
    throw new Error("The DOM driver function expects as input an " + "Observable of virtual DOM elements");
  }
}

function defaultOnErrorFn(msg) {
  if (console && console.error) {
    console.error(msg);
  } else {
    console.log(msg);
  }
}

function makeDOMDriver(container, options) {
  // Find and prepare the container
  var domContainer = typeof container === "string" ? document.querySelector(container) : container;
  // Check pre-conditions
  if (typeof container === "string" && domContainer === null) {
    throw new Error("Cannot render into unknown element `" + container + "`");
  } else if (!isElement(domContainer)) {
    throw new Error("Given container is not a DOM element neither a selector " + "string.");
  }

  var _ref3 = options || {};

  var _ref3$onError = _ref3.onError;
  var onError = _ref3$onError === undefined ? defaultOnErrorFn : _ref3$onError;

  if (typeof onError !== "function") {
    throw new Error("You provided an `onError` to makeDOMDriver but it was " + "not a function. It should be a callback function to handle errors.");
  }

  return function domDriver(vtree$) {
    validateDOMSink(vtree$);
    var rootElem$ = renderRawRootElem$(vtree$, domContainer).startWith(domContainer).doOnError(onError).replay(null, 1);
    var disposable = rootElem$.connect();
    return {
      observable: rootElem$,
      namespace: [],
      select: makeElementSelector(rootElem$),
      events: makeEventsSelector(rootElem$, []),
      dispose: function dispose() {
        return disposable.dispose();
      },
      isolateSource: isolateSource,
      isolateSink: isolateSink
    };
  };
}

module.exports = {
  isElement: isElement,
  wrapTopLevelVTree: wrapTopLevelVTree,
  makeDiffAndPatchToElement$: makeDiffAndPatchToElement$,
  renderRawRootElem$: renderRawRootElem$,
  validateDOMSink: validateDOMSink,

  makeDOMDriver: makeDOMDriver
};