"use strict";

var Rx = require("rx");
var toHTML = require("vdom-to-html");

var _require = require("./transposition");

var transposeVTree = _require.transposeVTree;

function makeBogusSelect() {
  return function select() {
    return {
      observable: Rx.Observable.empty(),
      events: function events() {
        return Rx.Observable.empty();
      }
    };
  };
}

function makeHTMLDriver() {
  return function htmlDriver(vtree$) {
    var output$ = vtree$.flatMapLatest(transposeVTree).last().map(toHTML);
    output$.select = makeBogusSelect();
    return output$;
  };
}

module.exports = {
  makeBogusSelect: makeBogusSelect,

  makeHTMLDriver: makeHTMLDriver
};