"use strict";
var isolate_1 = require('./isolate');
var xstream_adapter_1 = require('@cycle/xstream-adapter');
var MainHTTPSource = (function () {
    function MainHTTPSource(_res$$, runStreamAdapter, _namespace) {
        if (_namespace === void 0) { _namespace = []; }
        this._res$$ = _res$$;
        this.runStreamAdapter = runStreamAdapter;
        this._namespace = _namespace;
        this.isolateSource = isolate_1.isolateSource;
        this.isolateSink = isolate_1.isolateSink;
    }
    Object.defineProperty(MainHTTPSource.prototype, "response$$", {
        get: function () {
            return this.runStreamAdapter.adapt(this._res$$, xstream_adapter_1.default.streamSubscribe);
        },
        enumerable: true,
        configurable: true
    });
    MainHTTPSource.prototype.filter = function (predicate) {
        var filteredResponse$$ = this._res$$.filter(predicate);
        return new MainHTTPSource(filteredResponse$$, this.runStreamAdapter, this._namespace);
    };
    MainHTTPSource.prototype.select = function (category) {
        var res$$ = this._res$$;
        if (category) {
            res$$ = this._res$$.filter(function (res$) { return res$.request && res$.request.category === category; });
        }
        return this.runStreamAdapter.adapt(res$$, xstream_adapter_1.default.streamSubscribe);
    };
    return MainHTTPSource;
}());
exports.MainHTTPSource = MainHTTPSource;
//# sourceMappingURL=MainHTTPSource.js.map