'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var d3Array = require('d3-array');
var d3Collection = require('d3-collection');
var d3Random = require('d3-random');
var d3Ease = require('d3-ease');
var d3Polygon = require('d3-polygon');
var d3Path = require('d3-path');
var d3Quadtree = require('d3-quadtree');
var d3Queue = require('d3-queue');
var d3Shape = require('d3-shape');
var d3Color = require('d3-color');
var d3Interpolate = require('d3-interpolate');
var d3Dispatch = require('d3-dispatch');
var d3Dsv = require('d3-dsv');
var d3Request = require('d3-request');
var d3Timer = require('d3-timer');
var d3Time = require('d3-time');
var d3Format = require('d3-format');
var d3TimeFormat = require('d3-time-format');
var d3Scale = require('d3-scale');
var d3Selection = require('d3-selection');
var d3Transition = require('d3-transition');
var d3Axis = require('d3-axis');
var d3Hierarchy = require('d3-hierarchy');
var d3Force = require('d3-force');
var d3Drag = require('d3-drag');
var d3Voronoi = require('d3-voronoi');
var d3Zoom = require('d3-zoom');
var d3Brush = require('d3-brush');
var d3Chord = require('d3-chord');
var d3Geo = require('d3-geo');

var version = "4.2.1";

exports.version = version;
exports.bisect = d3Array.bisect;
exports.bisectRight = d3Array.bisectRight;
exports.bisectLeft = d3Array.bisectLeft;
exports.ascending = d3Array.ascending;
exports.bisector = d3Array.bisector;
exports.descending = d3Array.descending;
exports.deviation = d3Array.deviation;
exports.extent = d3Array.extent;
exports.histogram = d3Array.histogram;
exports.thresholdFreedmanDiaconis = d3Array.thresholdFreedmanDiaconis;
exports.thresholdScott = d3Array.thresholdScott;
exports.thresholdSturges = d3Array.thresholdSturges;
exports.max = d3Array.max;
exports.mean = d3Array.mean;
exports.median = d3Array.median;
exports.merge = d3Array.merge;
exports.min = d3Array.min;
exports.pairs = d3Array.pairs;
exports.permute = d3Array.permute;
exports.quantile = d3Array.quantile;
exports.range = d3Array.range;
exports.scan = d3Array.scan;
exports.shuffle = d3Array.shuffle;
exports.sum = d3Array.sum;
exports.ticks = d3Array.ticks;
exports.tickStep = d3Array.tickStep;
exports.transpose = d3Array.transpose;
exports.variance = d3Array.variance;
exports.zip = d3Array.zip;
exports.entries = d3Collection.entries;
exports.keys = d3Collection.keys;
exports.values = d3Collection.values;
exports.map = d3Collection.map;
exports.set = d3Collection.set;
exports.nest = d3Collection.nest;
exports.randomUniform = d3Random.randomUniform;
exports.randomNormal = d3Random.randomNormal;
exports.randomLogNormal = d3Random.randomLogNormal;
exports.randomBates = d3Random.randomBates;
exports.randomIrwinHall = d3Random.randomIrwinHall;
exports.randomExponential = d3Random.randomExponential;
exports.easeLinear = d3Ease.easeLinear;
exports.easeQuad = d3Ease.easeQuad;
exports.easeQuadIn = d3Ease.easeQuadIn;
exports.easeQuadOut = d3Ease.easeQuadOut;
exports.easeQuadInOut = d3Ease.easeQuadInOut;
exports.easeCubic = d3Ease.easeCubic;
exports.easeCubicIn = d3Ease.easeCubicIn;
exports.easeCubicOut = d3Ease.easeCubicOut;
exports.easeCubicInOut = d3Ease.easeCubicInOut;
exports.easePoly = d3Ease.easePoly;
exports.easePolyIn = d3Ease.easePolyIn;
exports.easePolyOut = d3Ease.easePolyOut;
exports.easePolyInOut = d3Ease.easePolyInOut;
exports.easeSin = d3Ease.easeSin;
exports.easeSinIn = d3Ease.easeSinIn;
exports.easeSinOut = d3Ease.easeSinOut;
exports.easeSinInOut = d3Ease.easeSinInOut;
exports.easeExp = d3Ease.easeExp;
exports.easeExpIn = d3Ease.easeExpIn;
exports.easeExpOut = d3Ease.easeExpOut;
exports.easeExpInOut = d3Ease.easeExpInOut;
exports.easeCircle = d3Ease.easeCircle;
exports.easeCircleIn = d3Ease.easeCircleIn;
exports.easeCircleOut = d3Ease.easeCircleOut;
exports.easeCircleInOut = d3Ease.easeCircleInOut;
exports.easeBounce = d3Ease.easeBounce;
exports.easeBounceIn = d3Ease.easeBounceIn;
exports.easeBounceOut = d3Ease.easeBounceOut;
exports.easeBounceInOut = d3Ease.easeBounceInOut;
exports.easeBack = d3Ease.easeBack;
exports.easeBackIn = d3Ease.easeBackIn;
exports.easeBackOut = d3Ease.easeBackOut;
exports.easeBackInOut = d3Ease.easeBackInOut;
exports.easeElastic = d3Ease.easeElastic;
exports.easeElasticIn = d3Ease.easeElasticIn;
exports.easeElasticOut = d3Ease.easeElasticOut;
exports.easeElasticInOut = d3Ease.easeElasticInOut;
exports.polygonArea = d3Polygon.polygonArea;
exports.polygonCentroid = d3Polygon.polygonCentroid;
exports.polygonHull = d3Polygon.polygonHull;
exports.polygonContains = d3Polygon.polygonContains;
exports.polygonLength = d3Polygon.polygonLength;
exports.path = d3Path.path;
exports.quadtree = d3Quadtree.quadtree;
exports.queue = d3Queue.queue;
exports.arc = d3Shape.arc;
exports.area = d3Shape.area;
exports.line = d3Shape.line;
exports.pie = d3Shape.pie;
exports.radialArea = d3Shape.radialArea;
exports.radialLine = d3Shape.radialLine;
exports.symbol = d3Shape.symbol;
exports.symbols = d3Shape.symbols;
exports.symbolCircle = d3Shape.symbolCircle;
exports.symbolCross = d3Shape.symbolCross;
exports.symbolDiamond = d3Shape.symbolDiamond;
exports.symbolSquare = d3Shape.symbolSquare;
exports.symbolStar = d3Shape.symbolStar;
exports.symbolTriangle = d3Shape.symbolTriangle;
exports.symbolWye = d3Shape.symbolWye;
exports.curveBasisClosed = d3Shape.curveBasisClosed;
exports.curveBasisOpen = d3Shape.curveBasisOpen;
exports.curveBasis = d3Shape.curveBasis;
exports.curveBundle = d3Shape.curveBundle;
exports.curveCardinalClosed = d3Shape.curveCardinalClosed;
exports.curveCardinalOpen = d3Shape.curveCardinalOpen;
exports.curveCardinal = d3Shape.curveCardinal;
exports.curveCatmullRomClosed = d3Shape.curveCatmullRomClosed;
exports.curveCatmullRomOpen = d3Shape.curveCatmullRomOpen;
exports.curveCatmullRom = d3Shape.curveCatmullRom;
exports.curveLinearClosed = d3Shape.curveLinearClosed;
exports.curveLinear = d3Shape.curveLinear;
exports.curveMonotoneX = d3Shape.curveMonotoneX;
exports.curveMonotoneY = d3Shape.curveMonotoneY;
exports.curveNatural = d3Shape.curveNatural;
exports.curveStep = d3Shape.curveStep;
exports.curveStepAfter = d3Shape.curveStepAfter;
exports.curveStepBefore = d3Shape.curveStepBefore;
exports.stack = d3Shape.stack;
exports.stackOffsetExpand = d3Shape.stackOffsetExpand;
exports.stackOffsetNone = d3Shape.stackOffsetNone;
exports.stackOffsetSilhouette = d3Shape.stackOffsetSilhouette;
exports.stackOffsetWiggle = d3Shape.stackOffsetWiggle;
exports.stackOrderAscending = d3Shape.stackOrderAscending;
exports.stackOrderDescending = d3Shape.stackOrderDescending;
exports.stackOrderInsideOut = d3Shape.stackOrderInsideOut;
exports.stackOrderNone = d3Shape.stackOrderNone;
exports.stackOrderReverse = d3Shape.stackOrderReverse;
exports.color = d3Color.color;
exports.rgb = d3Color.rgb;
exports.hsl = d3Color.hsl;
exports.lab = d3Color.lab;
exports.hcl = d3Color.hcl;
exports.cubehelix = d3Color.cubehelix;
exports.interpolate = d3Interpolate.interpolate;
exports.interpolateArray = d3Interpolate.interpolateArray;
exports.interpolateDate = d3Interpolate.interpolateDate;
exports.interpolateNumber = d3Interpolate.interpolateNumber;
exports.interpolateObject = d3Interpolate.interpolateObject;
exports.interpolateRound = d3Interpolate.interpolateRound;
exports.interpolateString = d3Interpolate.interpolateString;
exports.interpolateTransformCss = d3Interpolate.interpolateTransformCss;
exports.interpolateTransformSvg = d3Interpolate.interpolateTransformSvg;
exports.interpolateZoom = d3Interpolate.interpolateZoom;
exports.interpolateRgb = d3Interpolate.interpolateRgb;
exports.interpolateRgbBasis = d3Interpolate.interpolateRgbBasis;
exports.interpolateRgbBasisClosed = d3Interpolate.interpolateRgbBasisClosed;
exports.interpolateHsl = d3Interpolate.interpolateHsl;
exports.interpolateHslLong = d3Interpolate.interpolateHslLong;
exports.interpolateLab = d3Interpolate.interpolateLab;
exports.interpolateHcl = d3Interpolate.interpolateHcl;
exports.interpolateHclLong = d3Interpolate.interpolateHclLong;
exports.interpolateCubehelix = d3Interpolate.interpolateCubehelix;
exports.interpolateCubehelixLong = d3Interpolate.interpolateCubehelixLong;
exports.interpolateBasis = d3Interpolate.interpolateBasis;
exports.interpolateBasisClosed = d3Interpolate.interpolateBasisClosed;
exports.quantize = d3Interpolate.quantize;
exports.dispatch = d3Dispatch.dispatch;
exports.dsvFormat = d3Dsv.dsvFormat;
exports.csvParse = d3Dsv.csvParse;
exports.csvParseRows = d3Dsv.csvParseRows;
exports.csvFormat = d3Dsv.csvFormat;
exports.csvFormatRows = d3Dsv.csvFormatRows;
exports.tsvParse = d3Dsv.tsvParse;
exports.tsvParseRows = d3Dsv.tsvParseRows;
exports.tsvFormat = d3Dsv.tsvFormat;
exports.tsvFormatRows = d3Dsv.tsvFormatRows;
exports.request = d3Request.request;
exports.html = d3Request.html;
exports.json = d3Request.json;
exports.text = d3Request.text;
exports.xml = d3Request.xml;
exports.csv = d3Request.csv;
exports.tsv = d3Request.tsv;
exports.now = d3Timer.now;
exports.timer = d3Timer.timer;
exports.timerFlush = d3Timer.timerFlush;
exports.timeout = d3Timer.timeout;
exports.interval = d3Timer.interval;
exports.timeInterval = d3Time.timeInterval;
exports.timeMillisecond = d3Time.timeMillisecond;
exports.timeMilliseconds = d3Time.timeMilliseconds;
exports.timeSecond = d3Time.timeSecond;
exports.timeSeconds = d3Time.timeSeconds;
exports.timeMinute = d3Time.timeMinute;
exports.timeMinutes = d3Time.timeMinutes;
exports.timeHour = d3Time.timeHour;
exports.timeHours = d3Time.timeHours;
exports.timeDay = d3Time.timeDay;
exports.timeDays = d3Time.timeDays;
exports.timeWeek = d3Time.timeWeek;
exports.timeWeeks = d3Time.timeWeeks;
exports.timeSunday = d3Time.timeSunday;
exports.timeSundays = d3Time.timeSundays;
exports.timeMonday = d3Time.timeMonday;
exports.timeMondays = d3Time.timeMondays;
exports.timeTuesday = d3Time.timeTuesday;
exports.timeTuesdays = d3Time.timeTuesdays;
exports.timeWednesday = d3Time.timeWednesday;
exports.timeWednesdays = d3Time.timeWednesdays;
exports.timeThursday = d3Time.timeThursday;
exports.timeThursdays = d3Time.timeThursdays;
exports.timeFriday = d3Time.timeFriday;
exports.timeFridays = d3Time.timeFridays;
exports.timeSaturday = d3Time.timeSaturday;
exports.timeSaturdays = d3Time.timeSaturdays;
exports.timeMonth = d3Time.timeMonth;
exports.timeMonths = d3Time.timeMonths;
exports.timeYear = d3Time.timeYear;
exports.timeYears = d3Time.timeYears;
exports.utcMillisecond = d3Time.utcMillisecond;
exports.utcMilliseconds = d3Time.utcMilliseconds;
exports.utcSecond = d3Time.utcSecond;
exports.utcSeconds = d3Time.utcSeconds;
exports.utcMinute = d3Time.utcMinute;
exports.utcMinutes = d3Time.utcMinutes;
exports.utcHour = d3Time.utcHour;
exports.utcHours = d3Time.utcHours;
exports.utcDay = d3Time.utcDay;
exports.utcDays = d3Time.utcDays;
exports.utcWeek = d3Time.utcWeek;
exports.utcWeeks = d3Time.utcWeeks;
exports.utcSunday = d3Time.utcSunday;
exports.utcSundays = d3Time.utcSundays;
exports.utcMonday = d3Time.utcMonday;
exports.utcMondays = d3Time.utcMondays;
exports.utcTuesday = d3Time.utcTuesday;
exports.utcTuesdays = d3Time.utcTuesdays;
exports.utcWednesday = d3Time.utcWednesday;
exports.utcWednesdays = d3Time.utcWednesdays;
exports.utcThursday = d3Time.utcThursday;
exports.utcThursdays = d3Time.utcThursdays;
exports.utcFriday = d3Time.utcFriday;
exports.utcFridays = d3Time.utcFridays;
exports.utcSaturday = d3Time.utcSaturday;
exports.utcSaturdays = d3Time.utcSaturdays;
exports.utcMonth = d3Time.utcMonth;
exports.utcMonths = d3Time.utcMonths;
exports.utcYear = d3Time.utcYear;
exports.utcYears = d3Time.utcYears;
exports.format = d3Format.format;
exports.formatPrefix = d3Format.formatPrefix;
exports.formatLocale = d3Format.formatLocale;
exports.formatDefaultLocale = d3Format.formatDefaultLocale;
exports.formatSpecifier = d3Format.formatSpecifier;
exports.precisionFixed = d3Format.precisionFixed;
exports.precisionPrefix = d3Format.precisionPrefix;
exports.precisionRound = d3Format.precisionRound;
exports.timeFormat = d3TimeFormat.timeFormat;
exports.timeParse = d3TimeFormat.timeParse;
exports.utcFormat = d3TimeFormat.utcFormat;
exports.utcParse = d3TimeFormat.utcParse;
exports.isoFormat = d3TimeFormat.isoFormat;
exports.isoParse = d3TimeFormat.isoParse;
exports.timeFormatLocale = d3TimeFormat.timeFormatLocale;
exports.timeFormatDefaultLocale = d3TimeFormat.timeFormatDefaultLocale;
exports.scaleBand = d3Scale.scaleBand;
exports.scalePoint = d3Scale.scalePoint;
exports.scaleIdentity = d3Scale.scaleIdentity;
exports.scaleLinear = d3Scale.scaleLinear;
exports.scaleLog = d3Scale.scaleLog;
exports.scaleOrdinal = d3Scale.scaleOrdinal;
exports.scaleImplicit = d3Scale.scaleImplicit;
exports.scalePow = d3Scale.scalePow;
exports.scaleSqrt = d3Scale.scaleSqrt;
exports.scaleQuantile = d3Scale.scaleQuantile;
exports.scaleQuantize = d3Scale.scaleQuantize;
exports.scaleThreshold = d3Scale.scaleThreshold;
exports.scaleTime = d3Scale.scaleTime;
exports.scaleUtc = d3Scale.scaleUtc;
exports.schemeCategory10 = d3Scale.schemeCategory10;
exports.schemeCategory20b = d3Scale.schemeCategory20b;
exports.schemeCategory20c = d3Scale.schemeCategory20c;
exports.schemeCategory20 = d3Scale.schemeCategory20;
exports.scaleSequential = d3Scale.scaleSequential;
exports.interpolateCubehelixDefault = d3Scale.interpolateCubehelixDefault;
exports.interpolateRainbow = d3Scale.interpolateRainbow;
exports.interpolateWarm = d3Scale.interpolateWarm;
exports.interpolateCool = d3Scale.interpolateCool;
exports.interpolateViridis = d3Scale.interpolateViridis;
exports.interpolateMagma = d3Scale.interpolateMagma;
exports.interpolateInferno = d3Scale.interpolateInferno;
exports.interpolatePlasma = d3Scale.interpolatePlasma;
exports.creator = d3Selection.creator;
exports.customEvent = d3Selection.customEvent;
Object.defineProperty(exports, "event", {get: function() { return d3Selection.event; }});
exports.local = d3Selection.local;
exports.matcher = d3Selection.matcher;
exports.mouse = d3Selection.mouse;
exports.namespace = d3Selection.namespace;
exports.namespaces = d3Selection.namespaces;
exports.select = d3Selection.select;
exports.selectAll = d3Selection.selectAll;
exports.selection = d3Selection.selection;
exports.selector = d3Selection.selector;
exports.selectorAll = d3Selection.selectorAll;
exports.touch = d3Selection.touch;
exports.touches = d3Selection.touches;
exports.window = d3Selection.window;
exports.active = d3Transition.active;
exports.interrupt = d3Transition.interrupt;
exports.transition = d3Transition.transition;
exports.axisTop = d3Axis.axisTop;
exports.axisRight = d3Axis.axisRight;
exports.axisBottom = d3Axis.axisBottom;
exports.axisLeft = d3Axis.axisLeft;
exports.cluster = d3Hierarchy.cluster;
exports.hierarchy = d3Hierarchy.hierarchy;
exports.pack = d3Hierarchy.pack;
exports.packSiblings = d3Hierarchy.packSiblings;
exports.packEnclose = d3Hierarchy.packEnclose;
exports.partition = d3Hierarchy.partition;
exports.stratify = d3Hierarchy.stratify;
exports.tree = d3Hierarchy.tree;
exports.treemap = d3Hierarchy.treemap;
exports.treemapBinary = d3Hierarchy.treemapBinary;
exports.treemapDice = d3Hierarchy.treemapDice;
exports.treemapSlice = d3Hierarchy.treemapSlice;
exports.treemapSliceDice = d3Hierarchy.treemapSliceDice;
exports.treemapSquarify = d3Hierarchy.treemapSquarify;
exports.treemapResquarify = d3Hierarchy.treemapResquarify;
exports.forceCenter = d3Force.forceCenter;
exports.forceCollide = d3Force.forceCollide;
exports.forceLink = d3Force.forceLink;
exports.forceManyBody = d3Force.forceManyBody;
exports.forceSimulation = d3Force.forceSimulation;
exports.forceX = d3Force.forceX;
exports.forceY = d3Force.forceY;
exports.drag = d3Drag.drag;
exports.dragDisable = d3Drag.dragDisable;
exports.dragEnable = d3Drag.dragEnable;
exports.voronoi = d3Voronoi.voronoi;
exports.zoom = d3Zoom.zoom;
exports.zoomIdentity = d3Zoom.zoomIdentity;
exports.zoomTransform = d3Zoom.zoomTransform;
exports.brush = d3Brush.brush;
exports.brushX = d3Brush.brushX;
exports.brushY = d3Brush.brushY;
exports.brushSelection = d3Brush.brushSelection;
exports.chord = d3Chord.chord;
exports.ribbon = d3Chord.ribbon;
exports.geoAlbers = d3Geo.geoAlbers;
exports.geoAlbersUsa = d3Geo.geoAlbersUsa;
exports.geoArea = d3Geo.geoArea;
exports.geoAzimuthalEqualArea = d3Geo.geoAzimuthalEqualArea;
exports.geoAzimuthalEqualAreaRaw = d3Geo.geoAzimuthalEqualAreaRaw;
exports.geoAzimuthalEquidistant = d3Geo.geoAzimuthalEquidistant;
exports.geoAzimuthalEquidistantRaw = d3Geo.geoAzimuthalEquidistantRaw;
exports.geoBounds = d3Geo.geoBounds;
exports.geoCentroid = d3Geo.geoCentroid;
exports.geoCircle = d3Geo.geoCircle;
exports.geoClipExtent = d3Geo.geoClipExtent;
exports.geoConicConformal = d3Geo.geoConicConformal;
exports.geoConicConformalRaw = d3Geo.geoConicConformalRaw;
exports.geoConicEqualArea = d3Geo.geoConicEqualArea;
exports.geoConicEqualAreaRaw = d3Geo.geoConicEqualAreaRaw;
exports.geoConicEquidistant = d3Geo.geoConicEquidistant;
exports.geoConicEquidistantRaw = d3Geo.geoConicEquidistantRaw;
exports.geoDistance = d3Geo.geoDistance;
exports.geoEquirectangular = d3Geo.geoEquirectangular;
exports.geoEquirectangularRaw = d3Geo.geoEquirectangularRaw;
exports.geoGnomonic = d3Geo.geoGnomonic;
exports.geoGnomonicRaw = d3Geo.geoGnomonicRaw;
exports.geoGraticule = d3Geo.geoGraticule;
exports.geoInterpolate = d3Geo.geoInterpolate;
exports.geoLength = d3Geo.geoLength;
exports.geoMercator = d3Geo.geoMercator;
exports.geoMercatorRaw = d3Geo.geoMercatorRaw;
exports.geoOrthographic = d3Geo.geoOrthographic;
exports.geoOrthographicRaw = d3Geo.geoOrthographicRaw;
exports.geoPath = d3Geo.geoPath;
exports.geoProjection = d3Geo.geoProjection;
exports.geoProjectionMutator = d3Geo.geoProjectionMutator;
exports.geoRotation = d3Geo.geoRotation;
exports.geoStereographic = d3Geo.geoStereographic;
exports.geoStereographicRaw = d3Geo.geoStereographicRaw;
exports.geoStream = d3Geo.geoStream;
exports.geoTransform = d3Geo.geoTransform;
exports.geoTransverseMercator = d3Geo.geoTransverseMercator;
exports.geoTransverseMercatorRaw = d3Geo.geoTransverseMercatorRaw;