(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('d3-selection'), require('d3-scale'), require('d3-dispatch'), require('d3-brush')) :
    typeof define === 'function' && define.amd ? define(['exports', 'd3-selection', 'd3-scale', 'd3-dispatch', 'd3-brush'], factory) :
    (factory((global.fc = global.fc || {}),global.d3,global.d3,global.d3,global.d3));
}(this, (function (exports,d3Selection,d3Scale,d3Dispatch,d3Brush) { 'use strict';

var createReboundMethod = (function (target, source, name) {
    var method = source[name];
    if (typeof method !== 'function') {
        throw new Error('Attempt to rebind ' + name + ' which isn\'t a function on the source object');
    }
    return function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        var value = method.apply(source, args);
        return value === source ? target : value;
    };
});

var rebind = (function (target, source) {
    for (var _len = arguments.length, names = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        names[_key - 2] = arguments[_key];
    }

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = names[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var name = _step.value;

            target[name] = createReboundMethod(target, source, name);
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    return target;
});

// "Caution: avoid interpolating to or from the number zero when the interpolator is used to generate
// a string (such as with attr).
// Very small values, when stringified, may be converted to scientific notation and
// cause a temporarily invalid attribute or style property value.
// For example, the number 0.0000001 is converted to the string "1e-7".
// This is particularly noticeable when interpolating opacity values.
// To avoid scientific notation, start or end the transition at 1e-6,
// which is the smallest value that is not stringified in exponential notation."
// - https://github.com/mbostock/d3/wiki/Transitions#d3_interpolateNumber
var effectivelyZero = 1e-6;

// Wrapper around d3's selectAll/data data-join, which allows decoration of the result.
// This is achieved by appending the element to the enter selection before exposing it.
// A default transition of fade in/out is also implicitly added but can be modified.
var dataJoin = (function (element, className) {
    element = element || 'g';

    var key = function key(_, i) {
        return i;
    };
    var explicitTransition = null;

    var dataJoin = function dataJoin(container, data) {
        data = data || function (d) {
            return d;
        };

        var implicitTransition = container.selection ? container : null;
        if (implicitTransition) {
            container = container.selection();
        }

        var selected = container.selectAll(function (d, i, nodes) {
            return Array.from(nodes[i].childNodes).filter(function (node) {
                return node.nodeType === 1;
            });
        }).filter(className == null ? element : element + '.' + className);
        var update = selected.data(data, key);

        var enter = update.enter().append(element).attr('class', className);

        var exit = update.exit();

        // automatically merge in the enter selection
        update = update.merge(enter);

        // if transitions are enabled apply a default fade in/out transition
        var transition = implicitTransition || explicitTransition;
        if (transition) {
            update = update.transition(transition).style('opacity', 1);
            enter.style('opacity', effectivelyZero);
            exit = exit.transition(transition).style('opacity', effectivelyZero);
        }

        exit.remove();

        update.enter = function () {
            return enter;
        };
        update.exit = function () {
            return exit;
        };

        return update;
    };

    dataJoin.element = function () {
        if (!arguments.length) {
            return element;
        }
        element = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.className = function () {
        if (!arguments.length) {
            return className;
        }
        className = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.key = function () {
        if (!arguments.length) {
            return key;
        }
        key = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.transition = function () {
        if (!arguments.length) {
            return explicitTransition;
        }
        explicitTransition = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };

    return dataJoin;
});

var brushForOrient = function brushForOrient(orient) {
    switch (orient) {
        case 'x':
            return d3Brush.brushX();
        case 'y':
            return d3Brush.brushY();
        case 'xy':
            return d3Brush.brush();
    }
};

var invertRange = function invertRange(range) {
    return [range[1], range[0]];
};

var brushBase = function brushBase(orient) {

    var brush$$1 = brushForOrient(orient);
    var eventDispatch = d3Dispatch.dispatch('brush', 'start', 'end');
    var xScale = d3Scale.scaleIdentity();
    var yScale = d3Scale.scaleIdentity();

    var innerJoin = dataJoin('g', 'brush');

    var mapSelection = function mapSelection(selection, xMapping, yMapping) {
        switch (orient) {
            case 'x':
                return selection.map(xMapping);
            case 'y':
                return selection.map(yMapping);
            case 'xy':
                return [[xMapping(selection[0][0]), yMapping(selection[0][1])], [xMapping(selection[1][0]), yMapping(selection[1][1])]];
        }
    };

    var percentToSelection = function percentToSelection(percent) {
        return mapSelection(percent, d3Scale.scaleLinear().domain(xScale.range()).invert, d3Scale.scaleLinear().domain(invertRange(yScale.range())).invert);
    };

    var selectionToPercent = function selectionToPercent(selection) {
        return mapSelection(selection, d3Scale.scaleLinear().domain(xScale.range()), d3Scale.scaleLinear().domain(invertRange(yScale.range())));
    };

    var updateXDomain = function updateXDomain(selection) {
        var f = d3Scale.scaleLinear().domain(xScale.domain());
        if (orient === 'x') {
            return selection.map(f.invert);
        } else if (orient === 'xy') {
            return [f.invert(selection[0][0]), f.invert(selection[1][0])];
        }
    };

    var updateYDomain = function updateYDomain(selection) {
        var g = d3Scale.scaleLinear().domain(invertRange(yScale.domain()));
        if (orient === 'y') {
            return [selection[1], selection[0]].map(g.invert);
        } else if (orient === 'xy') {
            return [g.invert(selection[1][1]), g.invert(selection[0][1])];
        }
    };

    var transformEvent = function transformEvent(event$$1) {
        // The render function calls brush.move, which triggers, start, brush and end events. We don't
        // really want those events so suppress them.
        if (event$$1.sourceEvent && event$$1.sourceEvent.type === 'draw') return;

        if (event$$1.selection) {
            var mappedSelection = selectionToPercent(event$$1.selection);
            eventDispatch.call(event$$1.type, {}, {
                selection: mappedSelection,
                xDomain: updateXDomain(mappedSelection),
                yDomain: updateYDomain(mappedSelection)
            });
        } else {
            eventDispatch.call(event$$1.type, {}, {});
        }
    };

    var base = function base(selection) {
        selection.each(function (data, index, group) {

            // set the extent
            brush$$1.extent([[xScale.range()[0], yScale.range()[1]], [xScale.range()[1], yScale.range()[0]]]);

            // forwards events
            brush$$1.on('end', function () {
                return transformEvent(d3Selection.event);
            }).on('brush', function () {
                return transformEvent(d3Selection.event);
            }).on('start', function () {
                return transformEvent(d3Selection.event);
            });

            // render
            var container = innerJoin(d3Selection.select(group[index]), [data]);
            container.call(brush$$1).call(brush$$1.move, data ? percentToSelection(data) : null);
        });
    };

    base.xScale = function () {
        if (!arguments.length) {
            return xScale;
        }
        xScale = arguments.length <= 0 ? undefined : arguments[0];
        return base;
    };

    base.yScale = function () {
        if (!arguments.length) {
            return yScale;
        }
        yScale = arguments.length <= 0 ? undefined : arguments[0];
        return base;
    };

    rebind(base, eventDispatch, 'on');
    rebind(base, brush$$1, 'filter', 'handleSize');

    return base;
};

var brushX$1 = function brushX$1() {
    return brushBase('x');
};

var brushY$1 = function brushY$1() {
    return brushBase('y');
};

var brush$1 = function brush$1() {
    return brushBase('xy');
};

exports.brushX = brushX$1;
exports.brushY = brushY$1;
exports.brush = brush$1;

Object.defineProperty(exports, '__esModule', { value: true });

})));
