(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('d3-scale'), require('d3-selection'), require('d3-shape'), require('d3-path'), require('d3-array')) :
  typeof define === 'function' && define.amd ? define(['exports', 'd3-scale', 'd3-selection', 'd3-shape', 'd3-path', 'd3-array'], factory) :
  (factory((global.fc = global.fc || {}),global.d3,global.d3,global.d3,global.d3,global.d3));
}(this, (function (exports,d3Scale,d3Selection,d3Shape,d3Path,d3Array) { 'use strict';

var createReboundMethod = (function (target, source, name) {
    var method = source[name];
    if (typeof method !== 'function') {
        throw new Error('Attempt to rebind ' + name + ' which isn\'t a function on the source object');
    }
    return function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        var value = method.apply(source, args);
        return value === source ? target : value;
    };
});

var rebind = (function (target, source) {
    for (var _len = arguments.length, names = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        names[_key - 2] = arguments[_key];
    }

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = names[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var name = _step.value;

            target[name] = createReboundMethod(target, source, name);
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    return target;
});

var createTransform = function createTransform(transforms) {
    return function (name) {
        return transforms.reduce(function (name, fn) {
            return name && fn(name);
        }, name);
    };
};

var rebindAll = (function (target, source) {
    for (var _len = arguments.length, transforms = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        transforms[_key - 2] = arguments[_key];
    }

    var transform = createTransform(transforms);
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = Object.keys(source)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var name = _step.value;

            var result = transform(name);
            if (result) {
                target[result] = createReboundMethod(target, source, name);
            }
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    return target;
});

var regexify = (function (strsOrRegexes) {
    return strsOrRegexes.map(function (strOrRegex) {
        return typeof strOrRegex === 'string' ? new RegExp('^' + strOrRegex + '$') : strOrRegex;
    });
});

var exclude = (function () {
    for (var _len = arguments.length, exclusions = Array(_len), _key = 0; _key < _len; _key++) {
        exclusions[_key] = arguments[_key];
    }

    exclusions = regexify(exclusions);
    return function (name) {
        return exclusions.every(function (exclusion) {
            return !exclusion.test(name);
        }) && name;
    };
});

var include = (function () {
    for (var _len = arguments.length, inclusions = Array(_len), _key = 0; _key < _len; _key++) {
        inclusions[_key] = arguments[_key];
    }

    inclusions = regexify(inclusions);
    return function (name) {
        return inclusions.some(function (inclusion) {
            return inclusion.test(name);
        }) && name;
    };
});

var capitalizeFirstLetter = function capitalizeFirstLetter(str) {
  return str[0].toUpperCase() + str.slice(1);
};

var prefix = (function (prefix) {
  return function (name) {
    return prefix + capitalizeFirstLetter(name);
  };
});

// "Caution: avoid interpolating to or from the number zero when the interpolator is used to generate
// a string (such as with attr).
// Very small values, when stringified, may be converted to scientific notation and
// cause a temporarily invalid attribute or style property value.
// For example, the number 0.0000001 is converted to the string "1e-7".
// This is particularly noticeable when interpolating opacity values.
// To avoid scientific notation, start or end the transition at 1e-6,
// which is the smallest value that is not stringified in exponential notation."
// - https://github.com/mbostock/d3/wiki/Transitions#d3_interpolateNumber
var effectivelyZero = 1e-6;

// Wrapper around d3's selectAll/data data-join, which allows decoration of the result.
// This is achieved by appending the element to the enter selection before exposing it.
// A default transition of fade in/out is also implicitly added but can be modified.
var _dataJoin = (function (element, className) {
    element = element || 'g';

    var key = function key(_, i) {
        return i;
    };
    var explicitTransition = null;

    var dataJoin = function dataJoin(container, data) {
        data = data || function (d) {
            return d;
        };

        var implicitTransition = container.selection ? container : null;
        if (implicitTransition) {
            container = container.selection();
        }

        var selected = container.selectAll(function (d, i, nodes) {
            return Array.from(nodes[i].childNodes).filter(function (node) {
                return node.nodeType === 1;
            });
        }).filter(className == null ? element : element + '.' + className);
        var update = selected.data(data, key);

        var enter = update.enter().append(element).attr('class', className);

        var exit = update.exit();

        // automatically merge in the enter selection
        update = update.merge(enter);

        // if transitions are enabled apply a default fade in/out transition
        var transition = implicitTransition || explicitTransition;
        if (transition) {
            update = update.transition(transition).style('opacity', 1);
            enter.style('opacity', effectivelyZero);
            exit = exit.transition(transition).style('opacity', effectivelyZero);
        }

        exit.remove();

        update.enter = function () {
            return enter;
        };
        update.exit = function () {
            return exit;
        };

        return update;
    };

    dataJoin.element = function () {
        if (!arguments.length) {
            return element;
        }
        element = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.className = function () {
        if (!arguments.length) {
            return className;
        }
        className = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.key = function () {
        if (!arguments.length) {
            return key;
        }
        key = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };
    dataJoin.transition = function () {
        if (!arguments.length) {
            return explicitTransition;
        }
        explicitTransition = arguments.length <= 0 ? undefined : arguments[0];
        return dataJoin;
    };

    return dataJoin;
});

var functor$2 = (function (d) {
  return typeof d === 'function' ? d : function () {
    return d;
  };
});

// Checks that passes properties are 'defined', meaning that calling them with (d, i) returns non null values
function defined$1() {
    var outerArguments = arguments;
    return function (d, i) {
        for (var c = 0, j = outerArguments.length; c < j; c++) {
            if (outerArguments[c](d, i) == null) {
                return false;
            }
        }
        return true;
    };
}

// determines the offset required along the cross scale based
// on the series alignment
var alignOffset = (function (align, width) {
    switch (align) {
        case 'left':
            return width / 2;
        case 'right':
            return -width / 2;
        default:
            return 0;
    }
});

var createBase = (function (initialValues) {

    var env = Object.assign({}, initialValues);
    var base = function base() {};

    Object.keys(env).forEach(function (key) {
        base[key] = function () {
            if (!arguments.length) {
                return env[key];
            }
            env[key] = arguments.length <= 0 ? undefined : arguments[0];
            return base;
        };
    });

    return base;
});

var xyBase = (function () {

    var baseValue = function baseValue() {
        return 0;
    };
    var crossValue = function crossValue(d) {
        return d.x;
    };
    var mainValue = function mainValue(d) {
        return d.y;
    };
    var align = 'center';
    var bandwidth = function bandwidth() {
        return 5;
    };
    var orient = 'vertical';

    var base = createBase({
        decorate: function decorate() {},
        defined: function defined(d, i) {
            return defined$1(baseValue, crossValue, mainValue)(d, i);
        },
        xScale: d3Scale.scaleIdentity(),
        yScale: d3Scale.scaleIdentity()
    });

    base.values = function (d, i) {
        var width = bandwidth(d, i);
        var offset = alignOffset(align, width);
        var xScale = base.xScale();
        var yScale = base.yScale();

        if (orient === 'vertical') {
            var y = yScale(mainValue(d, i), i);
            var y0 = yScale(baseValue(d, i), i);
            var x = xScale(crossValue(d, i), i) + offset;
            return {
                d: d,
                x: x,
                y: y,
                y0: y0,
                width: width,
                height: y - y0,
                origin: [x, y],
                baseOrigin: [x, y0],
                transposedX: x,
                transposedY: y
            };
        } else {
            var _y = xScale(mainValue(d, i), i);
            var _y2 = xScale(baseValue(d, i), i);
            var _x = yScale(crossValue(d, i), i) + offset;
            return {
                d: d,
                x: _x,
                y: _y,
                y0: _y2,
                width: width,
                height: _y - _y2,
                origin: [_y, _x],
                baseOrigin: [_y2, _x],
                transposedX: _y,
                transposedY: _x
            };
        }
    };

    base.baseValue = function () {
        if (!arguments.length) {
            return baseValue;
        }
        baseValue = functor$2(arguments.length <= 0 ? undefined : arguments[0]);
        return base;
    };
    base.crossValue = function () {
        if (!arguments.length) {
            return crossValue;
        }
        crossValue = functor$2(arguments.length <= 0 ? undefined : arguments[0]);
        return base;
    };
    base.mainValue = function () {
        if (!arguments.length) {
            return mainValue;
        }
        mainValue = functor$2(arguments.length <= 0 ? undefined : arguments[0]);
        return base;
    };
    base.bandwidth = function () {
        if (!arguments.length) {
            return bandwidth;
        }
        bandwidth = functor$2(arguments.length <= 0 ? undefined : arguments[0]);
        return base;
    };
    base.align = function () {
        if (!arguments.length) {
            return align;
        }
        align = arguments.length <= 0 ? undefined : arguments[0];
        return base;
    };
    base.orient = function () {
        if (!arguments.length) {
            return orient;
        }
        orient = arguments.length <= 0 ? undefined : arguments[0];
        return base;
    };

    return base;
});

var red = '#c60';
var green = '#6c0';
var black = '#000';
var gray = '#ddd';
var darkGray = '#999';

var colors = {
    red: red,
    green: green,
    black: black,
    gray: gray,
    darkGray: darkGray
};

var line$1 = (function () {
    var base = xyBase();

    var lineData = d3Shape.line().x(function (d, i) {
        return base.values(d, i).transposedX;
    }).y(function (d, i) {
        return base.values(d, i).transposedY;
    });

    var join = _dataJoin('path', 'line');

    var line$$1 = function line$$1(selection$$1) {

        if (selection$$1.selection) {
            join.transition(selection$$1);
        }

        lineData.defined(base.defined());

        selection$$1.each(function (data, index, group) {
            var path$$1 = join(d3Selection.select(group[index]), [data]);

            path$$1.enter().attr('fill', 'none').attr('stroke', colors.black);

            path$$1.attr('d', lineData);

            base.decorate()(path$$1, data, index);
        });
    };

    rebindAll(line$$1, base, exclude('baseValue', 'bandwidth', 'align'));
    rebind(line$$1, join, 'key');
    rebind(line$$1, lineData, 'curve');

    return line$$1;
});

var seriesCanvasLine = (function () {
    var base = xyBase();

    var lineData = d3Shape.line().x(function (d, i) {
        return base.values(d, i).transposedX;
    }).y(function (d, i) {
        return base.values(d, i).transposedY;
    });

    var line$$1 = function line$$1(data) {
        var context = lineData.context();

        context.beginPath();
        lineData.defined(base.defined())(data);
        context.strokeStyle = colors.black;
        context.fillStyle = 'transparent';

        base.decorate()(context, data);

        context.fill();
        context.stroke();
        context.closePath();
    };

    rebindAll(line$$1, base, exclude('baseValue', 'bandwidth', 'align'));
    rebind(line$$1, lineData, 'curve', 'context');

    return line$$1;
});

// Renders an OHLC as an SVG path based on the given array of datapoints. Each
// OHLC has a fixed width, whilst the x, open, high, low and close positions are
// obtained from each point via the supplied accessor functions.

// Renders a bar series as an SVG path based on the given array of datapoints. Each
// bar has a fixed width, whilst the x, y and height are obtained from each data
// point via the supplied accessor functions.

// Renders a candlestick as an SVG path based on the given array of datapoints. Each
// candlestick has a fixed width, whilst the x, open, high, low and close positions are
// obtained from each point via the supplied accessor functions.

// Renders a box plot series as an SVG path based on the given array of datapoints.

// Renders an error bar series as an SVG path based on the given array of datapoints.

var multiBase = (function () {

    var series = [];
    var mapping = function mapping(d) {
        return d;
    };
    var key = function key(_, i) {
        return i;
    };

    var multi = createBase({
        decorate: function decorate() {},
        xScale: d3Scale.scaleIdentity(),
        yScale: d3Scale.scaleIdentity()
    });

    multi.mapping = function () {
        if (!arguments.length) {
            return mapping;
        }
        mapping = arguments.length <= 0 ? undefined : arguments[0];
        return multi;
    };
    multi.key = function () {
        if (!arguments.length) {
            return key;
        }
        key = arguments.length <= 0 ? undefined : arguments[0];
        return multi;
    };
    multi.series = function () {
        if (!arguments.length) {
            return series;
        }
        series = arguments.length <= 0 ? undefined : arguments[0];
        return multi;
    };

    return multi;
});

var multiSeries = (function () {

    var base = multiBase();

    var innerJoin = _dataJoin('g');

    var join = _dataJoin('g', 'multi');

    var multi = function multi(selection$$1) {

        if (selection$$1.selection) {
            join.transition(selection$$1);
            innerJoin.transition(selection$$1);
        }

        var mapping = base.mapping();
        var series = base.series();
        var xScale = base.xScale();
        var yScale = base.yScale();

        selection$$1.each(function (data, index, group) {

            var container = join(d3Selection.select(group[index]), series);

            // iterate over the containers, 'call'-ing the series for each
            container.each(function (dataSeries, seriesIndex, seriesGroup) {
                dataSeries.xScale(xScale).yScale(yScale);

                var seriesData = mapping(data, seriesIndex, series);
                var innerContainer = innerJoin(d3Selection.select(seriesGroup[seriesIndex]), [seriesData]);

                innerContainer.call(dataSeries);
            });

            var unwrappedSelection = container.selection ? container.selection() : container;
            unwrappedSelection.order();

            base.decorate()(container, data, index);
        });
    };

    rebindAll(multi, base);
    rebind(multi, join, 'key');

    return multi;
});

var multiSeries$1 = (function () {

    var context = null;
    var base = multiBase();

    var multi = function multi(data) {
        var mapping = base.mapping();
        var series = base.series();
        var xScale = base.xScale();
        var yScale = base.yScale();

        series.forEach(function (dataSeries, index) {
            var seriesData = mapping(data, index, series);
            dataSeries.context(context).xScale(xScale).yScale(yScale);

            var adaptedDecorate = dataSeries.decorate();
            dataSeries.decorate(function (c, d, i) {
                base.decorate()(c, data, index);
                adaptedDecorate(c, d, i);
            });

            dataSeries(seriesData);

            dataSeries.decorate(adaptedDecorate);
        });
    };

    multi.context = function () {
        if (!arguments.length) {
            return context;
        }
        context = arguments.length <= 0 ? undefined : arguments[0];
        return multi;
    };

    rebindAll(multi, base);

    return multi;
});

var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

var identity = function identity(d) {
    return d;
};

var axis = function axis(orient, scale) {

    var tickArguments = [10];
    var tickValues = null;
    var decorate = function decorate() {};
    var tickFormat = null;
    var tickSizeOuter = 6;
    var tickSizeInner = 6;
    var tickPadding = 3;

    var svgDomainLine = d3Shape.line();

    var dataJoin$$1 = _dataJoin('g', 'tick').key(identity);

    var domainPathDataJoin = _dataJoin('path', 'domain');

    // returns a function that creates a translation based on
    // the bound data
    var containerTranslate = function containerTranslate(scale, trans) {
        var offset = 0;
        if (scale.bandwidth) {
            offset = scale.bandwidth() / 2;
            if (scale.round()) {
                offset = Math.round(offset);
            }
        }
        return function (d) {
            return trans(scale(d) + offset, 0);
        };
    };

    var translate = function translate(x, y) {
        return isVertical() ? 'translate(' + y + ', ' + x + ')' : 'translate(' + x + ', ' + y + ')';
    };

    var pathTranspose = function pathTranspose(arr) {
        return isVertical() ? arr.map(function (d) {
            return [d[1], d[0]];
        }) : arr;
    };

    var isVertical = function isVertical() {
        return orient === 'left' || orient === 'right';
    };

    var tryApply = function tryApply(fn, args, defaultVal) {
        return scale[fn] ? scale[fn].apply(scale, args) : defaultVal;
    };

    var axis = function axis(selection$$1) {

        if (selection$$1.selection) {
            dataJoin$$1.transition(selection$$1);
            domainPathDataJoin.transition(selection$$1);
        }

        selection$$1.each(function (data, index, group) {

            var element = group[index];

            var container = d3Selection.select(element);
            if (!element.__scale__) {
                container.attr('fill', 'none').attr('font-size', 10).attr('font-family', 'sans-serif').attr('text-anchor', orient === 'right' ? 'start' : orient === 'left' ? 'end' : 'middle');
            }

            // Stash a snapshot of the new scale, and retrieve the old snapshot.
            var scaleOld = element.__scale__ || scale;
            element.__scale__ = scale.copy();

            var ticksArray = tickValues == null ? tryApply('ticks', tickArguments, scale.domain()) : tickValues;
            var tickFormatter = tickFormat == null ? tryApply('tickFormat', tickArguments, identity) : tickFormat;
            var sign = orient === 'bottom' || orient === 'right' ? 1 : -1;

            // add the domain line
            var range$$1 = scale.range();
            var domainPathData = pathTranspose([[range$$1[0], sign * tickSizeOuter], [range$$1[0], 0], [range$$1[1], 0], [range$$1[1], sign * tickSizeOuter]]);

            var domainLine = domainPathDataJoin(container, [data]);
            domainLine.attr('d', svgDomainLine(domainPathData)).attr('stroke', '#000');

            var g = dataJoin$$1(container, ticksArray);

            // enter
            g.enter().attr('transform', containerTranslate(scaleOld, translate)).append('path').attr('stroke', '#000');

            var labelOffset = sign * (tickSizeInner + tickPadding);
            g.enter().append('text').attr('transform', translate(0, labelOffset)).attr('fill', '#000');

            // exit
            g.exit().attr('transform', containerTranslate(scale, translate));

            // update
            g.select('path').attr('d', function (d) {
                return svgDomainLine(pathTranspose([[0, 0], [0, sign * tickSizeInner]]));
            });

            g.select('text').attr('transform', translate(0, labelOffset)).attr('dy', function () {
                var offset = '0em';
                if (isVertical()) {
                    offset = '0.32em';
                } else if (orient === 'bottom') {
                    offset = '0.71em';
                }
                return offset;
            }).text(tickFormatter);

            g.attr('transform', containerTranslate(scale, translate));

            decorate(g, data, index);
        });
    };

    axis.tickFormat = function () {
        if (!arguments.length) {
            return tickFormat;
        }
        tickFormat = arguments.length <= 0 ? undefined : arguments[0];
        return axis;
    };

    axis.tickSize = function () {
        if (!arguments.length) {
            return tickSizeInner;
        }
        tickSizeInner = tickSizeOuter = Number(arguments.length <= 0 ? undefined : arguments[0]);
        return axis;
    };

    axis.tickSizeInner = function () {
        if (!arguments.length) {
            return tickSizeInner;
        }
        tickSizeInner = Number(arguments.length <= 0 ? undefined : arguments[0]);
        return axis;
    };

    axis.tickSizeOuter = function () {
        if (!arguments.length) {
            return tickSizeOuter;
        }
        tickSizeOuter = Number(arguments.length <= 0 ? undefined : arguments[0]);
        return axis;
    };

    axis.tickPadding = function () {
        if (!arguments.length) {
            return tickPadding;
        }
        tickPadding = arguments.length <= 0 ? undefined : arguments[0];
        return axis;
    };

    axis.decorate = function () {
        if (!arguments.length) {
            return decorate;
        }
        decorate = arguments.length <= 0 ? undefined : arguments[0];
        return axis;
    };

    axis.scale = function () {
        if (!arguments.length) {
            return scale;
        }
        scale = arguments.length <= 0 ? undefined : arguments[0];
        return axis;
    };

    axis.ticks = function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        tickArguments = [].concat(args);
        return axis;
    };

    axis.tickArguments = function () {
        if (!arguments.length) {
            return tickArguments.slice();
        }
        tickArguments = (arguments.length <= 0 ? undefined : arguments[0]) == null ? [] : [].concat(toConsumableArray(arguments.length <= 0 ? undefined : arguments[0]));
        return axis;
    };

    axis.tickValues = function () {
        if (!arguments.length) {
            return tickValues.slice();
        }
        tickValues = (arguments.length <= 0 ? undefined : arguments[0]) == null ? [] : [].concat(toConsumableArray(arguments.length <= 0 ? undefined : arguments[0]));
        return axis;
    };

    return axis;
};

var axisTop = function axisTop(scale) {
    return axis('top', scale);
};

var axisBottom = function axisBottom(scale) {
    return axis('bottom', scale);
};

var axisLeft = function axisLeft(scale) {
    return axis('left', scale);
};

var axisRight = function axisRight(scale) {
    return axis('right', scale);
};

var store = (function () {
    for (var _len = arguments.length, names = Array(_len), _key = 0; _key < _len; _key++) {
        names[_key] = arguments[_key];
    }

    var data = {};

    var store = function store(target) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = Object.keys(data)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var key = _step.value;

                target[key](data[key]);
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        return target;
    };

    var _loop = function _loop(name) {
        store[name] = function () {
            if (!arguments.length) {
                return data[name];
            }
            data[name] = arguments.length <= 0 ? undefined : arguments[0];
            return store;
        };
    };

    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
        for (var _iterator2 = names[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var name = _step2.value;

            _loop(name);
        }
    } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion2 && _iterator2.return) {
                _iterator2.return();
            }
        } finally {
            if (_didIteratorError2) {
                throw _iteratorError2;
            }
        }
    }

    return store;
});

// Adapted from https://github.com/substack/insert-css
var css = 'd3fc-group.cartesian-chart{width:100%;height:100%;overflow:hidden;display:grid;display:-ms-grid;grid-template-columns:minmax(1em,max-content) auto 1fr auto minmax(1em,max-content);-ms-grid-columns:minmax(1em,max-content) auto 1fr auto minmax(1em,max-content);grid-template-rows:minmax(1em,max-content) auto 1fr auto minmax(1em,max-content);-ms-grid-rows:minmax(1em,max-content) auto 1fr auto minmax(1em,max-content);}\nd3fc-group.cartesian-chart>.top-label{align-self:center;-ms-grid-column-align:center;justify-self:center;-ms-grid-row-align:center;grid-column:3;-ms-grid-column:3;-ms-grid-row:1;-ms-grid-row:1;}\nd3fc-group.cartesian-chart>.top-axis{height:2em;grid-column:3;-ms-grid-column:3;grid-row:2;-ms-grid-row:2;}\nd3fc-group.cartesian-chart>.left-label{align-self:center;-ms-grid-column-align:center;justify-self:center;-ms-grid-row-align:center;grid-column:1;-ms-grid-column:1;grid-row:3;-ms-grid-row:3;}\nd3fc-group.cartesian-chart>.left-axis{width:3em;grid-column:2;-ms-grid-column:2;grid-row:3;-ms-grid-row:3;}\nd3fc-group.cartesian-chart>.plot-area{overflow:hidden;grid-column:3;-ms-grid-column:3;grid-row:3;-ms-grid-row:3;}\nd3fc-group.cartesian-chart>.right-axis{width:3em;grid-column:4;-ms-grid-column:4;grid-row:3;-ms-grid-row:3;}\nd3fc-group.cartesian-chart>.right-label{align-self:center;-ms-grid-column-align:center;justify-self:center;-ms-grid-row-align:center;grid-column:5;-ms-grid-column:5;grid-row:3;-ms-grid-row:3;}\nd3fc-group.cartesian-chart>.bottom-axis{height:2em;grid-column:3;-ms-grid-column:3;grid-row:4;-ms-grid-row:4;}\nd3fc-group.cartesian-chart>.bottom-label{align-self:center;-ms-grid-column-align:center;justify-self:center;-ms-grid-row-align:center;grid-column:3;-ms-grid-column:3;grid-row:5;-ms-grid-row:5;}';

var styleElement = document.createElement('style');
styleElement.setAttribute('type', 'text/css');

document.querySelector('head').appendChild(styleElement);

if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText += css;
} else {
    styleElement.textContent += css;
}

var functor$1 = function functor$1(v) {
    return typeof v === 'function' ? v : function () {
        return v;
    };
};

var cartesianChart = (function () {
    var xScale = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : d3Scale.scaleIdentity();
    var yScale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : d3Scale.scaleIdentity();


    var xLabel = functor$1('');
    var yLabel = functor$1('');
    var yOrient = functor$1('right');
    var xOrient = functor$1('bottom');
    var canvasPlotArea = multiSeries$1();
    var svgPlotArea = multiSeries();
    var xAxisStore = store('tickFormat', 'ticks', 'tickArguments', 'tickSize', 'tickSizeInner', 'tickSizeOuter', 'tickValues', 'tickPadding');
    var xDecorate = function xDecorate() {};
    var yAxisStore = store('tickFormat', 'ticks', 'tickArguments', 'tickSize', 'tickSizeInner', 'tickSizeOuter', 'tickValues', 'tickPadding');
    var yDecorate = function yDecorate() {};
    var decorate = function decorate() {};

    var containerDataJoin = _dataJoin('d3fc-group', 'cartesian-chart');
    var xAxisDataJoin = _dataJoin('d3fc-svg', 'x-axis').key(function (d) {
        return d;
    });
    var yAxisDataJoin = _dataJoin('d3fc-svg', 'y-axis').key(function (d) {
        return d;
    });
    var xLabelDataJoin = _dataJoin('div', 'x-label').key(function (d) {
        return d;
    });
    var yLabelDataJoin = _dataJoin('div', 'y-label').key(function (d) {
        return d;
    });

    var propagateTransition = function propagateTransition(maybeTransition) {
        return function (selection$$1) {
            return maybeTransition.selection ? selection$$1.transition(maybeTransition) : selection$$1;
        };
    };

    var cartesian = function cartesian(selection$$1) {

        var transitionPropagator = propagateTransition(selection$$1);

        selection$$1.each(function (data, index, group) {
            var container = containerDataJoin(d3Selection.select(group[index]), [data]);

            container.enter().attr('auto-resize', '').html('<d3fc-svg class="plot-area"></d3fc-svg>' + '<d3fc-canvas class="plot-area"></d3fc-canvas>');

            xLabelDataJoin(container, [xOrient(data)]).attr('class', function (d) {
                return 'x-label ' + d + '-label';
            }).text(xLabel(data));

            yLabelDataJoin(container, [yOrient(data)]).attr('class', function (d) {
                return 'y-label ' + d + '-label';
            }).text(yLabel(data));

            xAxisDataJoin(container, [xOrient(data)]).attr('class', function (d) {
                return 'x-axis ' + d + '-axis';
            }).on('measure', function (d, i, nodes) {
                var _event$detail = d3Selection.event.detail,
                    width = _event$detail.width,
                    height = _event$detail.height;

                if (d === 'top') {
                    d3Selection.select(nodes[i]).select('svg').attr('viewBox', '0 ' + -height + ' ' + width + ' ' + height);
                }
                xScale.range([0, width]);
            }).on('draw', function (d, i, nodes) {
                var xAxis = d === 'top' ? axisTop(xScale) : axisBottom(xScale);
                xAxis.decorate(xDecorate);
                transitionPropagator(d3Selection.select(nodes[i])).select('svg').call(xAxisStore(xAxis));
            });

            yAxisDataJoin(container, [yOrient(data)]).attr('class', function (d) {
                return 'y-axis ' + d + '-axis';
            }).on('measure', function (d, i, nodes) {
                var _event$detail2 = d3Selection.event.detail,
                    width = _event$detail2.width,
                    height = _event$detail2.height;

                if (d === 'left') {
                    d3Selection.select(nodes[i]).select('svg').attr('viewBox', -width + ' 0 ' + width + ' ' + height);
                }
                yScale.range([height, 0]);
            }).on('draw', function (d, i, nodes) {
                var yAxis = d === 'left' ? axisLeft(yScale) : axisRight(yScale);
                yAxis.decorate(yDecorate);
                transitionPropagator(d3Selection.select(nodes[i])).select('svg').call(yAxisStore(yAxis));
            });

            container.select('d3fc-canvas.plot-area').on('draw', function (d, i, nodes) {
                var canvas = d3Selection.select(nodes[i]).select('canvas').node();
                canvasPlotArea.context(canvas.getContext('2d')).xScale(xScale).yScale(yScale);
                canvasPlotArea(d);
            });

            container.select('d3fc-svg.plot-area').on('draw', function (d, i, nodes) {
                svgPlotArea.xScale(xScale).yScale(yScale);
                transitionPropagator(d3Selection.select(nodes[i])).select('svg').call(svgPlotArea);
            });

            container.each(function (d, i, nodes) {
                return nodes[i].requestRedraw();
            });

            decorate(container, data, index);
        });
    };

    var scaleExclusions = exclude(/range\w*/, // the scale range is set via the component layout
    /tickFormat/ // use axis.tickFormat instead (only present on linear scales)
    );
    rebindAll(cartesian, xScale, scaleExclusions, prefix('x'));
    rebindAll(cartesian, yScale, scaleExclusions, prefix('y'));
    rebindAll(cartesian, xAxisStore, prefix('x'));
    rebindAll(cartesian, yAxisStore, prefix('y'));

    cartesian.xOrient = function () {
        if (!arguments.length) {
            return xOrient;
        }
        xOrient = functor$1(arguments.length <= 0 ? undefined : arguments[0]);
        return cartesian;
    };
    cartesian.yOrient = function () {
        if (!arguments.length) {
            return yOrient;
        }
        yOrient = functor$1(arguments.length <= 0 ? undefined : arguments[0]);
        return cartesian;
    };
    cartesian.xDecorate = function () {
        if (!arguments.length) {
            return xDecorate;
        }
        xDecorate = arguments.length <= 0 ? undefined : arguments[0];
        return cartesian;
    };
    cartesian.yDecorate = function () {
        if (!arguments.length) {
            return yDecorate;
        }
        yDecorate = arguments.length <= 0 ? undefined : arguments[0];
        return cartesian;
    };
    cartesian.xLabel = function () {
        if (!arguments.length) {
            return xLabel;
        }
        xLabel = functor$1(arguments.length <= 0 ? undefined : arguments[0]);
        return cartesian;
    };
    cartesian.yLabel = function () {
        if (!arguments.length) {
            return yLabel;
        }
        yLabel = functor$1(arguments.length <= 0 ? undefined : arguments[0]);
        return cartesian;
    };
    cartesian.canvasPlotArea = function () {
        if (!arguments.length) {
            return canvasPlotArea;
        }
        canvasPlotArea = arguments.length <= 0 ? undefined : arguments[0];
        return cartesian;
    };
    cartesian.svgPlotArea = function () {
        if (!arguments.length) {
            return svgPlotArea;
        }
        svgPlotArea = arguments.length <= 0 ? undefined : arguments[0];
        return cartesian;
    };
    cartesian.decorate = function () {
        if (!arguments.length) {
            return decorate;
        }
        decorate = arguments.length <= 0 ? undefined : arguments[0];
        return cartesian;
    };

    return cartesian;
});

var functor = function functor(v) {
    return typeof v === 'function' ? v : function () {
        return v;
    };
};

var cartesianBase = (function (setPlotArea, defaultPlotArea) {
    return function () {
        var xScale = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : d3Scale.scaleIdentity();
        var yScale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : d3Scale.scaleIdentity();


        var chartLabel = functor('');
        var yLabel = functor('');
        var plotArea = defaultPlotArea;
        var decorate = function decorate() {};

        var cartesian = cartesianChart(xScale, yScale);

        var cartesianBase = function cartesianBase(selection$$1) {
            setPlotArea(cartesian, plotArea);

            cartesian.decorate(function (container, data, index) {
                container.enter().select('.x-label').style('height', '1em').style('line-height', '1em');

                var yOrientValue = cartesian.yOrient()(data);

                container.enter().append('div').attr('class', 'y-label-container').style('grid-column', yOrientValue === 'left' ? 1 : 5).style('-ms-grid-column', yOrientValue === 'left' ? 1 : 5).style('grid-row', 3).style('-ms-grid-row', 3).style('width', '1em').style('display', 'flex').style('align-items', 'center').style('justify-content', 'center').append('div').attr('class', 'y-label').style('transform', 'rotate(-90deg)');

                container.select('.y-label-container>.y-label').text(yLabel);

                container.select('.top-label').style('margin-top', '2em');

                container.enter().append('div').attr('class', 'chart-label').style('grid-column', 3).style('-ms-grid-column', 3).style('grid-row', 1).style('-ms-grid-row', 1).style('height', '2em').style('line-height', '2em').style('text-align', 'center');

                container.select('.chart-label').text(chartLabel(data));

                decorate(container, data, index);
            });

            selection$$1.call(cartesian);
        };

        rebindAll(cartesianBase, cartesian, include(/^x/, /^y/));

        cartesianBase.chartLabel = function () {
            if (!arguments.length) {
                return chartLabel;
            }
            chartLabel = functor(arguments.length <= 0 ? undefined : arguments[0]);
            return cartesianBase;
        };
        cartesianBase.yLabel = function () {
            if (!arguments.length) {
                return yLabel;
            }
            yLabel = functor(arguments.length <= 0 ? undefined : arguments[0]);
            return cartesianBase;
        };
        cartesianBase.plotArea = function () {
            if (!arguments.length) {
                return plotArea;
            }
            plotArea = arguments.length <= 0 ? undefined : arguments[0];
            return cartesianBase;
        };
        cartesianBase.decorate = function () {
            if (!arguments.length) {
                return decorate;
            }
            decorate = arguments.length <= 0 ? undefined : arguments[0];
            return cartesianBase;
        };

        return cartesianBase;
    };
});

var cartesian = cartesianBase(function (cartesian, plotArea) {
    return cartesian.svgPlotArea(plotArea);
}, line$1);

var cartesian$1 = cartesianBase(function (cartesian, plotArea) {
    return cartesian.canvasPlotArea(plotArea);
}, seriesCanvasLine);

exports.chartSvgCartesian = cartesian;
exports.chartCanvasCartesian = cartesian$1;
exports.chartCartesian = cartesianChart;

Object.defineProperty(exports, '__esModule', { value: true });

})));
