(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (factory());
}(this, (function () { 'use strict';

var key = '__d3fc-elements__';

var get$1 = function get$1(element) {
  return element[key] || {};
};

var set$1 = function set$1(element, data) {
  return void (element[key] = data);
};

var clear = function clear(element) {
  return delete element[key];
};

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};











var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();









var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};











var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};

















var toArray = function (arr) {
  return Array.isArray(arr) ? arr : Array.from(arr);
};

var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

/* eslint-env browser */

var find = function find(element) {
    return element.tagName === 'D3FC-GROUP' ? [element].concat(toConsumableArray(element.querySelectorAll('d3fc-canvas, d3fc-group, d3fc-svg'))) : [element];
};

var measure = function measure(element) {
    var _data$get = get$1(element),
        previousWidth = _data$get.width,
        previousHeight = _data$get.height;

    var pixelRatio = element.useDevicePixelRatio && global.devicePixelRatio != null ? global.devicePixelRatio : 1;
    var width = element.clientWidth * pixelRatio;
    var height = element.clientHeight * pixelRatio;
    var resized = width !== previousWidth || height !== previousHeight;
    set$1(element, { pixelRatio: pixelRatio, width: width, height: height, resized: resized });
};

if (typeof CustomEvent !== 'function') {
    throw new Error('d3fc-element depends on CustomEvent. Make sure that you load a polyfill in older browsers. See README.');
}

var resize = function resize(element) {
    var detail = get$1(element);
    var event = new CustomEvent('measure', { detail: detail });
    element.dispatchEvent(event);
};

var draw = function draw(element) {
    var detail = get$1(element);
    var event = new CustomEvent('draw', { detail: detail });
    element.dispatchEvent(event);
};

var redraw = (function (elements) {
    var allElements = elements.map(find).reduce(function (a, b) {
        return a.concat(b);
    });
    allElements.forEach(measure);
    allElements.forEach(resize);
    allElements.forEach(draw);
});

/* eslint-env browser */

var getQueue = function getQueue(element) {
    return get$1(element.ownerDocument).queue || [];
};

var setQueue = function setQueue(element, queue) {
    var _data$get = get$1(element.ownerDocument),
        requestId = _data$get.requestId;

    if (requestId == null) {
        requestId = requestAnimationFrame(function () {
            // This seems like a weak way of retrieving the queue
            // but I can't see an edge case at the minute...
            var queue = getQueue(element);
            redraw(queue);
            clearQueue(element);
        });
    }
    set$1(element.ownerDocument, { queue: queue, requestId: requestId });
};

var clearQueue = function clearQueue(element) {
    return clear(element.ownerDocument);
};

var isDescendentOf = function isDescendentOf(element, ancestor) {
    var node = element;
    do {
        if (node.parentNode === ancestor) {
            return true;
        }
        // eslint-disable-next-line no-cond-assign
    } while (node = node.parentNode);
    return false;
};

var _requestRedraw = (function (element) {
    var queue = getQueue(element);
    var queueContainsElement = queue.indexOf(element) > -1;
    if (queueContainsElement) {
        return;
    }
    var queueContainsAncestor = queue.some(function (queuedElement) {
        return isDescendentOf(element, queuedElement);
    });
    if (queueContainsAncestor) {
        return;
    }
    var queueExcludingDescendents = queue.filter(function (queuedElement) {
        return !isDescendentOf(queuedElement, element);
    });
    queueExcludingDescendents.push(element);
    setQueue(element, queueExcludingDescendents);
});

function _CustomElement() {
    return Reflect.construct(HTMLElement, [], this.__proto__.constructor);
}


Object.setPrototypeOf(_CustomElement.prototype, HTMLElement.prototype);
Object.setPrototypeOf(_CustomElement, HTMLElement);
/* eslint-env browser */

if (typeof HTMLElement !== 'function') {
    throw new Error('d3fc-element depends on Custom Elements (v1). Make sure that you load a polyfill in older browsers. See README.');
}

var addMeasureListener = function addMeasureListener(element) {
    if (element.__measureListener__ != null) {
        return;
    }
    element.__measureListener__ = function (event) {
        return element.setMeasurements(event.detail);
    };
    element.addEventListener('measure', element.__measureListener__);
};

var removeMeasureListener = function removeMeasureListener(element) {
    if (element.__measureListener__ == null) {
        return;
    }
    element.removeEventListener('measure', element.__measureListener__);
    element.__measureListener__ = null;
};

var element = (function (createNode, applyMeasurements) {
    return function (_CustomElement2) {
        inherits(_class, _CustomElement2);

        function _class() {
            classCallCheck(this, _class);
            return possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
        }

        createClass(_class, [{
            key: 'attributeChangedCallback',
            value: function attributeChangedCallback(name) {
                switch (name) {
                    case 'use-device-pixel-ratio':
                        this.requestRedraw();
                        break;
                }
            }
        }, {
            key: 'connectedCallback',
            value: function connectedCallback() {
                if (this.childNodes.length === 0) {
                    this.appendChild(createNode());
                }
                addMeasureListener(this);
            }
        }, {
            key: 'disconnectedCallback',
            value: function disconnectedCallback() {
                removeMeasureListener(this);
            }
        }, {
            key: 'setMeasurements',
            value: function setMeasurements(_ref) {
                var width = _ref.width,
                    height = _ref.height;

                var _childNodes = toArray(this.childNodes),
                    node = _childNodes[0],
                    other = _childNodes.slice(1);

                if (other.length > 0) {
                    throw new Error('A d3fc-svg/canvas element must only contain a single svg/canvas element.');
                }
                applyMeasurements(node, { width: width, height: height });
            }
        }, {
            key: 'requestRedraw',
            value: function requestRedraw() {
                _requestRedraw(this);
            }
        }, {
            key: 'useDevicePixelRatio',
            get: function get() {
                return this.hasAttribute('use-device-pixel-ratio') && this.getAttribute('use-device-pixel-ratio') !== 'false';
            },
            set: function set(useDevicePixelRatio) {
                if (useDevicePixelRatio && !this.useDevicePixelRatio) {
                    this.setAttribute('use-device-pixel-ratio', '');
                } else if (!useDevicePixelRatio && this.useDevicePixelRatio) {
                    this.removeAttribute('use-device-pixel-ratio');
                }
                this.requestRedraw();
            }
        }], [{
            key: 'observedAttributes',
            get: function get() {
                return ['use-device-pixel-ratio'];
            }
        }]);
        return _class;
    }(_CustomElement);
});

var Canvas = element(function () {
    return document.createElement('canvas');
}, function (node, _ref) {
    var width = _ref.width,
        height = _ref.height;

    node.setAttribute('width', width);
    node.setAttribute('height', height);
});

function _CustomElement$1() {
    return Reflect.construct(HTMLElement, [], this.__proto__.constructor);
}


Object.setPrototypeOf(_CustomElement$1.prototype, HTMLElement.prototype);
Object.setPrototypeOf(_CustomElement$1, HTMLElement);
/* eslint-env browser */

var updateAutoResize = function updateAutoResize(element) {
    if (element.autoResize) {
        addAutoResizeListener(element);
    } else {
        removeAutoResizeListener(element);
    }
};

var addAutoResizeListener = function addAutoResizeListener(element) {
    if (element.__autoResizeListener__ != null) {
        return;
    }
    element.__autoResizeListener__ = function () {
        return _requestRedraw(element);
    };
    addEventListener('resize', element.__autoResizeListener__);
};

var removeAutoResizeListener = function removeAutoResizeListener(element) {
    if (element.__autoResizeListener__ == null) {
        return;
    }
    removeEventListener('resize', element.__autoResizeListener__);
    element.__autoResizeListener__ = null;
};

var _class = function (_CustomElement2) {
    inherits(_class, _CustomElement2);

    function _class() {
        classCallCheck(this, _class);
        return possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    createClass(_class, [{
        key: 'connectedCallback',
        value: function connectedCallback() {
            updateAutoResize(this);
        }
    }, {
        key: 'disconnectedCallback',
        value: function disconnectedCallback() {
            removeAutoResizeListener(this);
        }
    }, {
        key: 'requestRedraw',
        value: function requestRedraw() {
            _requestRedraw(this);
        }
    }, {
        key: 'attributeChangedCallback',
        value: function attributeChangedCallback(name) {
            switch (name) {
                case 'auto-resize':
                    updateAutoResize(this);
                    break;
            }
        }
    }, {
        key: 'autoResize',
        get: function get() {
            return this.hasAttribute('auto-resize') && this.getAttribute('auto-resize') !== 'false';
        },
        set: function set(autoResize) {
            if (autoResize && !this.autoResize) {
                this.setAttribute('auto-resize', '');
            } else if (!autoResize && this.autoResize) {
                this.removeAttribute('auto-resize');
            }
            updateAutoResize(this);
        }
    }], [{
        key: 'observedAttributes',
        get: function get() {
            return ['auto-resize'];
        }
    }]);
    return _class;
}(_CustomElement$1);

var Svg = element(function () {
    return document.createElementNS('http://www.w3.org/2000/svg', 'svg');
}, function (node, _ref) {
    var width = _ref.width,
        height = _ref.height;

    node.setAttribute('viewBox', '0 0 ' + width + ' ' + height);
});

// Adapted from https://github.com/substack/insert-css
var css = 'd3fc-canvas,d3fc-svg{position:relative;display:block}d3fc-canvas>canvas,d3fc-svg>svg{position:absolute;height:100%;width:100%}d3fc-svg>svg{overflow:visible}';

var styleElement = document.createElement('style');
styleElement.setAttribute('type', 'text/css');

document.querySelector('head').appendChild(styleElement);

if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText += css;
} else {
    styleElement.textContent += css;
}

/* globals customElements */
if ((typeof customElements === 'undefined' ? 'undefined' : _typeof(customElements)) !== 'object' || typeof customElements.define !== 'function') {
    throw new Error('d3fc-element depends on Custom Elements (v1). Make sure that you load a polyfill in older browsers. See README.');
}

customElements.define('d3fc-canvas', Canvas);
customElements.define('d3fc-group', _class);
customElements.define('d3fc-svg', Svg);

})));
