(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('d3-array')) :
  typeof define === 'function' && define.amd ? define(['exports', 'd3-array'], factory) :
  (factory((global.fc = global.fc || {}),global.d3));
}(this, (function (exports,d3Array) { 'use strict';

var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

var linearExtent = function () {

    var accessors = [function (d) {
        return d;
    }];
    var pad = [0, 0];
    var padUnit = 'percent';
    var symmetricalAbout = null;
    var include = [];

    var instance = function instance(data) {
        var values = new Array(data.length);
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = accessors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var accessor = _step.value;

                for (var i = 0; i < data.length; i++) {
                    var value = accessor(data[i], i);
                    if (Array.isArray(value)) {
                        values.push.apply(values, toConsumableArray(value));
                    } else {
                        values.push(value);
                    }
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        var extent = [d3Array.min(values), d3Array.max(values)];

        extent[0] = extent[0] == null ? d3Array.min(include) : d3Array.min([extent[0]].concat(toConsumableArray(include)));
        extent[1] = extent[1] == null ? d3Array.max(include) : d3Array.max([extent[1]].concat(toConsumableArray(include)));

        if (symmetricalAbout != null) {
            var halfRange = Math.max(Math.abs(extent[1] - symmetricalAbout), Math.abs(extent[0] - symmetricalAbout));
            extent[0] = symmetricalAbout - halfRange;
            extent[1] = symmetricalAbout + halfRange;
        }

        switch (padUnit) {
            case 'domain':
                {
                    extent[0] -= pad[0];
                    extent[1] += pad[1];
                    break;
                }
            case 'percent':
                {
                    var delta = extent[1] - extent[0];
                    extent[0] -= pad[0] * delta;
                    extent[1] += pad[1] * delta;
                    break;
                }
            default:
                throw new Error('Unknown padUnit: ' + padUnit);
        }

        return extent;
    };

    instance.accessors = function () {
        if (!arguments.length) {
            return accessors;
        }
        accessors = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.pad = function () {
        if (!arguments.length) {
            return pad;
        }
        pad = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.padUnit = function () {
        if (!arguments.length) {
            return padUnit;
        }
        padUnit = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.include = function () {
        if (!arguments.length) {
            return include;
        }
        include = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.symmetricalAbout = function () {
        if (!arguments.length) {
            return symmetricalAbout;
        }
        symmetricalAbout = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    return instance;
};

var time = function () {

    var accessors = [];
    var pad = [0, 0];
    var padUnit = 'percent';
    var symmetricalAbout = null;
    var include = [];

    var extent = linearExtent();

    var valueOf = function valueOf(date) {
        return date != null ? date.valueOf() : null;
    };

    var instance = function instance(data) {
        var adaptedAccessors = accessors.map(function (accessor) {
            return function () {
                var value = accessor.apply(undefined, arguments);
                return Array.isArray(value) ? value.map(valueOf) : valueOf(value);
            };
        });

        extent.accessors(adaptedAccessors).pad(pad).padUnit(padUnit).symmetricalAbout(symmetricalAbout != null ? symmetricalAbout.valueOf() : null).include(include.map(function (date) {
            return date.valueOf();
        }));

        return extent(data).map(function (value) {
            return new Date(value);
        });
    };

    instance.accessors = function () {
        if (!arguments.length) {
            return accessors;
        }
        accessors = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.pad = function () {
        if (!arguments.length) {
            return pad;
        }
        pad = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.padUnit = function () {
        if (!arguments.length) {
            return padUnit;
        }
        padUnit = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.include = function () {
        if (!arguments.length) {
            return include;
        }
        include = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    instance.symmetricalAbout = function () {
        if (!arguments.length) {
            return symmetricalAbout;
        }
        symmetricalAbout = arguments.length <= 0 ? undefined : arguments[0];
        return instance;
    };

    return instance;
};

exports.extentLinear = linearExtent;
exports.extentTime = time;
exports.extentDate = time;

Object.defineProperty(exports, '__esModule', { value: true });

})));
