import jsdom from 'jsdom';

describe('bundle', function() {
    it('should corectly wire-up all the dependencies via their UMD-exposed globals', function(done) {
        jsdom.env({
            html: '<html></html>',
            virtualConsole: jsdom.createVirtualConsole().sendTo({
                error: fail
            }),
            scripts: [
                require.resolve('d3/dist/d3.js'),
                './build/d3fc-financial-feed.js'
            ],
            done: (_, win) => {
                const gdaxFeed = win.fc.feedGdax();
                const quandlFeed = win.fc.feedQuandl();

                expect(gdaxFeed).toBeDefined();
                expect(quandlFeed).toBeDefined();
                done();
            }
        });
    });
});
