var addTextLabel = require("./add-text-label"),
    addHtmlLabel = require("./add-html-label");

module.exports = addLabel;

function addLabel(root, node) {
  var label = node.label;
  var labelSvg = root.append("g");

  // Allow the label to be a string, a function that returns a DOM element, or
  // a DOM element itself.
  if (typeof label !== "string" || node.labelType === "html") {
    addHtmlLabel(labelSvg, node);
  } else {
    addTextLabel(labelSvg, node);
  }

  var labelBBox = labelSvg.node().getBBox();
  labelSvg.attr("transform",
                "translate(" + (-labelBBox.width / 2) + "," + (-labelBBox.height / 2) + ")");

  return labelSvg;
}
