/*!
  * BsMultiSelect v1.1.18 (https://dashboardcode.github.io/BsMultiSelect/)
  * Copyright 2017-2021 Roman Pokrovskij (github user rpokrovskij)
  * Licensed under Apache 2 (https://github.com/DashboardCode/BsMultiSelect/blob/master/LICENSE)
  */
function findDirectChildByTagName(e,t){for(var n=null,i=0;i<e.children.length;i++){var o=e.children[i];if(o.tagName==t){n=o;break}}return n}function closestByTagName(e,t){return closest(e,(function(e){return e.tagName===t}))}function closestByClassName(e,t){return closest(e,(function(e){return e.classList.contains(t)}))}function closestByAttribute(e,t,n){return closest(e,(function(e){return e.getAttribute(t)===n}))}function containsAndSelf(e,t){return e===t||e.contains(t)}function getDataGuardedWithPrefix(e,t,n){var i=e.getAttribute("data-"+t+"-"+n);if(i)return i;var o=e.getAttribute("data-"+n);return o||null}function closest(e,t){return e&&e instanceof Element?t(e)?e:closest(e.parentNode,t):null}function siblingsAsArray(e){var t=[];if(e.parentNode){var n=e.parentNode.children,i=e.parentNode.children.length;if(n.length>1)for(var o=0;o<i;++o){var c=n[o];c!=e&&t.push(c)}}return t}function getIsRtl(e){var t=!1;return closestByAttribute(e,"dir","rtl")&&(t=!0),t}function EventBinder(){var e=[];return{bind:function(t,n,i){t.addEventListener(n,i),e.push({element:t,eventName:n,handler:i})},unbind:function(){e.forEach((function(e){var t=e.element,n=e.eventName,i=e.handler;t.removeEventListener(n,i)}))}}}function AttributeBackup(){var e=[];return{set:function(t,n,i){var o=t.getAttribute(n);e.push({element:t,currentAtribute:o,attribute:i}),t.setAttribute(n,i)},restore:function(){e.forEach((function(e){var t=e.element,n=e.attributeName,i=e.attribute;n?t.setAttribute(n,i):t.removeAttribute(n)}))}}}function EventLoopProlongableFlag(e){var t=!1,n=null;return{get:function(){return t},set:function(i){t&&n&&e.clearTimeout(n),t=!0,n=e.setTimeout((function(){t=!1,n=null}),i||0)}}}function ResetableFlag(){var e=!1;return{get:function(){return e},set:function(){e=!0},reset:function(){e=!1}}}function Bs4Plugin(){}function setDefaults(e){e.useCssPatch=!0,e.cssPatch=cssPatch,e.pickButtonHTML='<button aria-label="Remove" tabIndex="-1" type="button"><span aria-hidden="true">&times;</span></button>',e.composeGetSize=composeGetSize,e.getDefaultLabel=getDefaultLabel}Bs4Plugin.plugDefaultConfig=function(e){e.css=css,setDefaults(e)};var css={choices:"dropdown-menu",choicesList:"",choice_hover:"hover",choice_selected:"",choice_disabled:"",picks:"form-control",picks_focus:"focus",picks_disabled:"disabled",pick_disabled:"",pickFilter:"",filterInput:"",pick:"badge",pickContent:"",pickContent_disabled:"disabled",pickButton:"close",choiceCheckBox_disabled:"disabled",choiceContent:"custom-control custom-checkbox d-flex",choiceCheckBox:"custom-control-input",choiceLabel:"custom-control-label justify-content-start",choiceLabel_disabled:"",warning:"alert-warning bg-warning"},cssPatch={choicesList:{listStyleType:"none",paddingLeft:"0",paddingRight:"0",marginBottom:"0"},picks:{listStyleType:"none",display:"flex",flexWrap:"wrap",height:"auto",marginBottom:"0",cursor:"text"},choice:{classes:"px-md-2 px-1",styles:{cursor:"pointer"}},choice_hover:"text-primary bg-light",choice_disabled_hover:"bg-light",filterInput:{border:"0px",height:"auto",boxShadow:"none",padding:"0",margin:"0",outline:"none",backgroundColor:"transparent",backgroundImage:"none"},filterInput_empty:"form-control",picks_disabled:{backgroundColor:"#e9ecef"},picks_focus:{borderColor:"#80bdff",boxShadow:"0 0 0 0.2rem rgba(0, 123, 255, 0.25)"},picks_focus_valid:{borderColor:"",boxShadow:"0 0 0 0.2rem rgba(40, 167, 69, 0.25)"},picks_focus_invalid:{borderColor:"",boxShadow:"0 0 0 0.2rem rgba(220, 53, 69, 0.25)"},picks_def:{minHeight:"calc(2.25rem + 2px)"},picks_lg:{minHeight:"calc(2.875rem + 2px)"},picks_sm:{minHeight:"calc(1.8125rem + 2px)"},pick:{lineHeight:"1.5em",paddingLeft:"0",paddingRight:".5rem",paddingInlineStart:"0",paddingInlineEnd:"0.5rem"},pickButton:{fontSize:"1.5em",lineHeight:".9em",float:"none"},pickContent_disabled:{opacity:".65"},choiceContent:{justifyContent:"flex-start",cursor:"inherit"},choiceLabel:{color:"inherit",cursor:"inherit"},choiceCheckBox:{color:"inherit",cursor:"inherit"},choiceLabel_disabled:{opacity:".65"},warning:{paddingLeft:".25rem",paddingRight:".25rem",zIndex:4,fontSize:"small",backgroundColor:"var(--bs-warning)"}};function composeGetSize(e){var t=closestByClassName(e,"input-group");return t?function(){var e=null;return t.classList.contains("input-group-lg")?e="lg":t.classList.contains("input-group-sm")&&(e="sm"),e}:function(){var t=null;return e.classList.contains("custom-select-lg")||e.classList.contains("form-control-lg")?t="lg":(e.classList.contains("custom-select-sm")||e.classList.contains("form-control-sm"))&&(t="sm"),t}}function getDefaultLabel(e){var t=null,n=closestByClassName(e,"form-group");return n&&(t=n.querySelector('label[for="'+e.id+'"]')),t}function isBoolean(e){return!0===e||!1===e}function isString(e){return e instanceof String||"string"==typeof e}function extendIfUndefined(e,t){for(var n in t)void 0===e[n]&&(e[n]=t[n])}function shallowClearClone(e){var t={};for(var n in e){var i=e[n];null!=i&&(t[n]=i)}for(var o=arguments.length,c=new Array(o>1?o-1:0),r=1;r<o;r++)c[r-1]=arguments[r];return c&&c.forEach((function(e){for(var n in e){var i=e[n];null!=i?t[n]=i:t.hasOwnProperty(n)&&delete t[n]}})),t}function forEachRecursion(e,t){t&&(!1!==e(t.value)&&forEachRecursion(e,t.prev))}function indexRecursion(e,t){if(!t.prev)return e;indexRecursion(++e,t.prev)}function List(){var e=null,t=0;return{add:function(n){e?(e.next={value:n,prev:e,next:null},e=e.next):e={value:n,prev:null,next:null},t++;var i=e;return{remove:function(){i.prev&&(i.prev.next=i.next),i.next&&(i.next.prev=i.prev),e==i&&(e=i.prev),t--},index:function(){return indexRecursion(0,i)}}},forEach:function(t){forEachRecursion(t,e)},getTail:function(){return e?e.value:null},getCount:function(){return t},isEmpty:function(){return 0==t},reset:function(){e=null,t=0}}}function DoublyLinkedList(e,t,n,i){var o=null,c=null,r=0;return{add:function(n,s){if(c)if(s){s===o&&(o=n);var a=e(s);i(n,s),t(s,n),a?(t(n,a),i(a,n)):t(n,null)}else t(n,c),i(n,null),i(c,n),c=n;else o=c=n,t(n,null),i(n,null);r++},remove:function(s){var a=n(s),l=e(s);l&&i(l,a),a&&t(a,l),c==s&&(c=l),o==s&&(o=a),r--},getHead:function(){return o},getTail:function(){return c},getCount:function(){return r},isEmpty:function(){return 0==r},reset:function(){c=o=null,r=0}}}function ArrayFacade(){var e=[];return{push:function(t){e.push(t)},add:function(t,n){e.splice(n,0,t)},get:function(t){return e[t]},getNext:function(t,n){var i=e.length,o=t+1;if(t<i){if(!n)return e[o];for(var c=o;c<i;c++){var r=e[c];if(n(r))return r}}},remove:function(t){var n=e[t];return e.splice(t,1),n},forLoop:function(t){for(var n=0;n<e.length;n++){t(e[n],n)}},getHead:function(){return e[0]},getCount:function(){return e.length},isEmpty:function(){return 0==e.length},reset:function(){e=[]}}}function composeSync(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return function(){return t.forEach((function(e){e&&e()}))}}function defCall(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];for(var i=0,o=t;i<o.length;i++){var c=o[i];if(c){if(!(c instanceof Function))return c;var r=c();if(r)return r}}}function ObservableValue(e){var t=List();return{getValue:function(){return e},setValue:function(n){e=n,t.forEach((function(e){return e(n)}))},attach:function(e){return t.add(e)},detachAll:function(){t.reset()}}}function ObservableLambda(e){var t=List(),n=e();return{getValue:function(){return n},call:function(){n=e(),t.forEach((function(e){return e(n)}))},attach:function(e){return t.add(e)},detachAll:function(){t.reset()}}}function ObjectValues(e){var t=[];for(var n in e)t.push(e[n]);return t}function LabelForAttributePlugin(e){var t=e.staticDom,n=e.filterDom,i=e.getLabelElementAspect,o=e.configuration,c=e.loadAspect,r=e.disposeAspect,s=LabelForAttributeAspect(t,n,o.containerClass,i,r);e.labelForAttributeAspect=s,c.load=composeSync(c.load,(function(){return s.update()}))}function GetLabelElementAspect(e){return{getLabelElement:function(){defCall(e)}}}function LabelForAttributeAspect(e,t,n,i,o){return{update:function(){var c=null,r=e.selectElement,s=e.containerElement,a=t.filterInputElement;c=r?function(){return n+"-generated-input-"+(r.id?r.id:r.name).toLowerCase()+"-id"}:function(){return n+"-generated-filter-"+s.id};var l=i.getLabelElement();if(l){var u=l.getAttribute("for"),d=c();a.setAttribute("id",d),l.setAttribute("for",d),u&&(o.dispose=composeSync(o.dispose,(function(){return l.setAttribute("for",u)})))}}}}function RtlPlugin(e){var t=e.configuration,n=e.rtlAspect,i=e.staticDom,o=t.isRtl,c=!1;isBoolean(o)?c=!0:o=getIsRtl(i.initialElement);var r=AttributeBackup();if(c)r.set(i.containerElement,"dir","rtl");else if(i.selectElement){var s=i.selectElement.getAttribute("dir");s&&r.set(i.containerElement,"dir",s)}return{buildApi:function(e){n.updateRtl(o)},dispose:function(){r.restore()}}}function RtlAspect(){return{updateRtl:function(){}}}function FormResetPlugin(e){var t=e.staticDom,n=e.updateDataAspect,i=e.environment,o=EventBinder();if(t.selectElement){var c=closestByTagName(t.selectElement,"FORM");c&&o.bind(c,"reset",(function(){return i.window.setTimeout((function(){return n.updateData()}))}))}return{dispose:function(){o.unbind()}}}function createValidity(e,t){return Object.freeze({valueMissing:e,customError:t,valid:!(e||t)})}function ValidityApi(e,t,n,i,o){var c="",r="",s=null;function a(t,o){s=createValidity(t,o),r=o?c:t?n:"",e.setCustomValidity(r),i(s.valid)}a(t.getValue(),!1),t.attach((function(e){a(e,s.customError)}));var l=function(){return s.valid||o("dashboardcode.multiselect:invalid"),s.valid};return{validationMessage:r,willValidate:!0,validity:s,setCustomValidity:function(e){c=e,a(s.valueMissing,!!c)},checkValidity:l,reportValidity:function(){return e.reportValidity(),l()}}}LabelForAttributePlugin.plugDefaultConfig=function(e){e.label=null},LabelForAttributePlugin.plugStaticDom=function(e){e.getLabelElementAspect=GetLabelElementAspect(e.configuration.label)},RtlPlugin.plugStaticDom=function(e){e.rtlAspect=RtlAspect()};var defValueMissingMessage="Please select an item in the list";function ValidationApiPlugin(e){var t=e.configuration,n=e.triggerAspect,i=e.onChangeAspect,o=e.optionsAspect,c=e.staticDom,r=e.filterDom,s=e.updateDataAspect,a=t.getIsValueMissing,l=t.valueMissingMessage,u=t.required,d=t.getValueRequired;isBoolean(u)||(u=d()),l=defCall(l,(function(){return getDataGuardedWithPrefix(c.initialElement,"bsmultiselect","value-missing-message")}),defValueMissingMessage),a||(a=function(){for(var e=0,t=o.getOptions(),n=0;n<t.length;n++)t[n].selected&&e++;return 0===e});var p=ObservableLambda((function(){return u&&a()})),f=ObservableValue(!p.getValue());i.onChange=composeSync(p.call,i.onChange),s.updateData=composeSync(p.call,s.updateData),e.validationApiPluginData={validationApiObservable:f};var g=ValidityApi(r.filterInputElement,p,l,(function(e){return f.setValue(e)}),n.trigger);return{buildApi:function(e){e.validationApi=g},dispose:function(){p.detachAll(),f.detachAll()}}}function addStyling(e,t){var n={classes:[],styles:{}};if(t){var i=t.classes,o=t.styles;for(var c in i.forEach((function(t){return e.classList.add(t)})),n.classes=i.slice(),o)n.styles[c]=e.style[c],e.style[c]=o[c]}return n}function removeStyling(e,t){if(t){var n=t.classes,i=t.styles;for(var o in n.forEach((function(t){return e.classList.remove(t)})),i)e.style[o]=i[o]}}function toggleStyling(e,t){var n={classes:[],styles:{}},i=!1,o=t instanceof Function;return function(c,r){c?!1===i?(n=addStyling(e,o?t():t),i=!0):r&&(removeStyling(e,n),n=addStyling(e,o?t():t)):!0!==i&&!0!==r||(removeStyling(e,n),i=!1)}}function extendClasses(e,t,n,i,o){if(isString(t)){if(""===t)o&&(e.classes=[]);else{var c=t.split(" ");e.classes=n(c)}return!0}return t instanceof Array&&(0==t.length?o&&(e.classes=[]):e.classes=i(t),!0)}function extend(e,t,n,i,o,c){if(!1===extendClasses(e,t,n,i,c)&&t instanceof Object){var r=t.classes,s=t.styles;extendClasses(e,r,n,i,c),s?e.styles=o(s):r||(e.styles=o(t))}}function Styling(e){var t={classes:[],styles:{}};return e&&extend(t,e,(function(e){return e}),(function(e){return e.slice()}),(function(e){return shallowClearClone(e)}),!0),Object.freeze(t)}function createStyling(e,t){var n={classes:[],styles:{}};if(t){extend(n,t,(function(e){return e}),(function(e){return e.slice()}),(function(e){return shallowClearClone(e)}),!0);for(var i=arguments.length,o=new Array(i>2?i-2:0),c=2;c<i;c++)o[c-2]=arguments[c];if(o){var r=n.classes,s=n.styles,a=e?function(e){return extend(n,e,(function(e){return e}),(function(e){return e.slice()}),(function(e){return shallowClearClone(s,e)}),!0)}:function(e){return extend(n,e,(function(e){return r.concat(e)}),(function(e){return r.concat(e)}),(function(e){return shallowClearClone(s,e)}),!1)};o.forEach((function(e){return a(e)}))}}return Styling(n)}function createCss(e,t){var n={};for(var i in e){var o=e[i],c=t?t[i]:void 0;n[i]=void 0===c?Styling(o):createStyling(!0,o,c)}if(t)for(var r in t)e[r]||(n[r]=Styling(t[r]));return n}function extendCss(e,t){for(var n in t){var i=t[n],o=e[n];e[n]=void 0===o?Styling(i):createStyling(!1,o,i)}}function BsAppearancePlugin(e){var t,n=e.configuration,i=e.validationApiPluginData,o=e.picksDom,c=e.staticDom,r=e.getLabelElementAspect,s=e.updateAppearanceAspect,a=e.componentPropertiesAspect,l=e.floatingLabelAspect,u=n.getValidity,d=n.getSize,p=n.useCssPatch,f=n.css,g=n.composeGetSize,h=n.getDefaultLabel,m=c.selectElement,v=c.initialElement,b=!1;if(l&&(b=closestByClassName(v,"form-floating"),l.isFloatingLabel=function(){return b}),r){var C=r.getLabelElement;r.getLabelElement=function(){var e=C();return e||(m?h(m):void 0)}}if(c.selectElement?(u||(u=composeGetValidity(m)),d||(d=g(m))):(u||(u=function(){return null}),d||(d=function(){return null})),a.getSize=d,a.getValidity=u,p){var A=f.picks_lg,y=f.picks_sm,P=f.picks_def,S=f.picks_floating_def;b&&(A=y=P=S),t=function(){return updateSizeJsForAdapter(o.picksElement,A,y,P,d)}}else t=function(){return updateSizeForAdapter(o.picksElement,d)};if(p){var D=o.toggleFocusStyling;o.toggleFocusStyling=function(){var e=I.getValue(),t=o.getIsFocusIn();D(t),t&&(!1===e?(o.setIsFocusIn(t),addStyling(o.picksElement,f.picks_focus_invalid)):!0===e&&(o.setIsFocusIn(t),addStyling(o.picksElement,f.picks_focus_valid)))}}var k=ObservableLambda((function(){return!!closestByClassName(c.initialElement,"was-validated")})),E=ObservableLambda((function(){return u()})),L=null==i?void 0:i.validationApiObservable,I=ObservableLambda((function(){return k.getValue()?L.getValue():E.getValue()}));return I.attach((function(e){var t=getMessagesElements(c.containerElement),n=t.validMessages,i=t.invalidMessages;updateValidity(o.picksElement,n,i,e),o.toggleFocusStyling()})),k.attach((function(){return I.call()})),L&&L.attach((function(){return I.call()})),E.attach((function(){return I.call()})),s.updateAppearance=composeSync(s.updateAppearance,t,I.call,E.call),{buildApi:function(e){e.updateSize=t,e.updateValidity=function(){return E.call()},e.updateWasValidated=function(){return k.call()}},dispose:function(){k.detachAll(),I.detachAll(),E.detachAll()}}}function updateValidity(e,t,n,i){!1===i?(e.classList.add("is-invalid"),e.classList.remove("is-valid"),n.map((function(e){return e.style.display="block"})),t.map((function(e){return e.style.display="none"}))):!0===i?(e.classList.remove("is-invalid"),e.classList.add("is-valid"),n.map((function(e){return e.style.display="none"})),t.map((function(e){return e.style.display="block"}))):(e.classList.remove("is-invalid"),e.classList.remove("is-valid"),n.map((function(e){return e.style.display=""})),t.map((function(e){return e.style.display=""})))}function updateSizeClasses(e,t){"lg"==t?(e.classList.add("form-control-lg"),e.classList.remove("form-control-sm")):"sm"==t?(e.classList.remove("form-control-lg"),e.classList.add("form-control-sm")):(e.classList.remove("form-control-lg"),e.classList.remove("form-control-sm"))}function updateSizeJsPicks(e,t,n,i,o){addStyling(e,"lg"==o?t:"sm"==o?n:i)}function updateSizeJs(e,t,n,i,o){updateSizeClasses(e,o),updateSizeJsPicks(e,t,n,i,o)}function updateSizeForAdapter(e,t){updateSizeClasses(e,t())}function updateSizeJsForAdapter(e,t,n,i,o){updateSizeJs(e,t,n,i,o())}function getMessagesElements(e){var t=siblingsAsArray(e),n=t.filter((function(e){return e.classList.contains("invalid-feedback")||e.classList.contains("invalid-tooltip")}));return{validMessages:t.filter((function(e){return e.classList.contains("valid-feedback")||e.classList.contains("valid-tooltip")})),invalidMessages:n}}function composeGetValidity(e){return function(){return!e.classList.contains("is-invalid")&&(!!e.classList.contains("is-valid")||null)}}function HiddenOptionPlugin(e){var t=e.configuration,n=e.createWrapAspect,i=e.isChoiceSelectableAspect,o=e.wrapsCollection,c=e.buildChoiceAspect,r=e.buildAndAttachChoiceAspect,s=e.countableChoicesListInsertAspect,a=e.countableChoicesList;s.countableChoicesListInsert=function(e,t){if(!e.isOptionHidden){var n=o.getNext(t,(function(e){return!e.isOptionHidden}));a.add(e,n)}};var l=r.buildAndAttachChoice;r.buildAndAttachChoice=function(e,t){e.isOptionHidden?buildHiddenChoice(e):l(e,t)};var u=i.isSelectable;i.isSelectable=function(e){return u(e)&&!e.isOptionHidden};var d=t.getIsOptionHidden;t.options?d||(d=function(e){return void 0!==e.hidden&&e.hidden}):d||(d=function(e){return e.hidden});var p=n.createWrap;return n.createWrap=function(e){var t=p(e);return t.isOptionHidden=d(e),t},{buildApi:function(e){var t=function(e){return o.getNext(e,(function(e){return!e.isOptionHidden}))};e.updateOptionsHidden=function(){return o.forLoop((function(e,n){return updateChoiceHidden(e,n,t,a,d,c)}))},e.updateOptionHidden=function(e){return updateChoiceHidden(o.get(e),e,t,a,d,c)}}}}function buildHiddenChoice(e){e.updateSelected=function(){},e.choice.isChoiceElementAttached=!1,e.choice.choiceElement=null,e.choice.choiceElementAttach=null,e.choice.setVisible=null,e.choice.setHoverIn=null,e.choice.remove=null,e.choice.dispose=function(){e.choice.dispose=null},e.dispose=function(){e.choice.dispose(),e.dispose=null}}function updateChoiceHidden(e,t,n,i,o,c){var r=o(e.option);if(r!=e.isOptionHidden)if(e.isOptionHidden=r,e.isOptionHidden)i.remove(e),e.choice.remove(),buildHiddenChoice(e);else{var s=n(t);i.add(e,s),c.buildChoice(e),e.choice.choiceElementAttach(null==s?void 0:s.choice.choiceElement)}}function CssPatchPlugin(){}function PlaceholderPlugin(e){var t=e.configuration,n=e.staticManager,i=e.picksList,o=e.picksDom,c=e.filterDom,r=e.staticDom,s=e.updateDataAspect,a=e.resetFilterListAspect,l=e.filterManagerAspect,u=e.environment.isIE11,d=t.placeholder,p=t.css,f=o.picksElement,g=c.filterInputElement;function h(e){g.placeholder=e}if(u){var m=ResetableFlag(),v=PlaceholderStopInputAspect(m),b=h;h=function(e){m.set(),b(e)},e.placeholderStopInputAspect=v}function C(e){g.style.width=e?"100%":"2ch"}d||(d=getDataGuardedWithPrefix(r.initialElement,"bsmultiselect","placeholder"));var A=toggleStyling(g,p.filterInput_empty);function y(e){e?(h(d||""),f.style.display="block"):(h(""),f.style.display="flex"),A(e),C(e)}y(!0);var P=function(){return i.isEmpty()&&c.isEmpty()};function S(){y(P())}function D(){C(P())}var k=o.disable;o.disable=function(e){!function(e){g.disabled=e}(e),k(e)},n.appendToContainer=composeSync(n.appendToContainer,D),l.processEmptyInput=composeSync(D,l.processEmptyInput),a.forceResetFilter=composeSync(a.forceResetFilter,S);var E=i.add;i.add=function(e){var t=E(e);return 1==i.getCount()&&(c.isEmpty()?(h(""),f.style.display="flex",A(!1),g.style.width="2ch"):f.style.display="flex"),e.dispose=composeSync(e.dispose,(function(){P()&&y(!0)})),t},s.updateData=composeSync(s.updateData,S)}function PlaceholderStopInputAspect(e){return{get:function(){return e.get()},reset:function(){return e.reset()}}}function JQueryMethodsPlugin(e){var t=e.staticDom,n=e.choicesDom,i=e.filterDom,o=e.picksList,c=e.picksDom;return{buildApi:function(e){e.getContainer=function(){return t.containerElement},e.getChoices=function(){return n.choicesElement},e.getChoicesList=function(){return n.choicesListElement},e.getFilterInput=function(){return i.filterInputElement},e.getPicks=function(){return c.picksElement},e.picksCount=function(){return o.getCount()}}}}function OptionsApiPlugin(e){var t=e.buildAndAttachChoiceAspect,n=e.wraps,i=e.wrapsCollection,o=e.createWrapAspect,c=e.createChoiceBaseAspect,r=e.optionsAspect,s=e.resetLayoutAspect;return{buildApi:function(e){e.updateOptionAdded=function(e){var s=r.getOptions()[e],a=o.createWrap(s);a.choice=c.createChoiceBase(s),n.insert(e,a);t.buildAndAttachChoice(a,(function(){var t;return null==(t=i.getNext(e,(function(e){return e.choice.choiceElement})))?void 0:t.choice.choiceElement}))},e.updateOptionRemoved=function(e){s.resetLayout();var t=n.remove(e);null==t.choice.remove||t.choice.remove(),null==t.dispose||t.dispose()}}}}function FormRestoreOnBackwardPlugin(e){var t=e.staticDom,n=e.environment,i=e.loadAspect,o=e.updateOptionsSelectedAspect,c=n.window;t.selectElement&&o&&(i.load=composeSync(i.load,(function(){"complete"!=c.document.readyState&&c.setTimeout((function(){o.updateOptionsSelected()}))})))}function SelectElementPlugin(e){var t=e.loadAspect,n=e.environment,i=t.loop,o=n.window.document;t.loop=function(){if("loading"!=o.readyState)i();else{o.addEventListener("DOMContentLoaded",(function e(){i(),o.removeEventListener("DOMContentLoaded",e)}))}}}function SelectedOptionPlugin(e){var t=e.configuration,n=e.wrapsCollection,i=e.updateOptionsSelectedAspect,o=e.createWrapAspect,c=e.buildChoiceAspect,r=e.removePickAspect,s=e.resetLayoutAspect,a=e.picksList,l=e.isChoiceSelectableAspect,u=e.optionToggleAspect,d=e.createPickHandlersAspect,p=e.addPickAspect,f=e.fullMatchAspect,g=e.onChangeAspect,h=e.filterPredicateAspect,m=t.getSelected,v=t.setSelected,b=h.filterPredicate;h.filterPredicate=function(e,t){return!e.isOptionSelected&&b(e,t)};var C=c.buildChoice;function A(e,t){return function(){e.isOptionSelected=t,e.updateSelected()}}function y(e,t,n){var i=!1;return!1!==v(e,n)&&(t(),i=!0),i}c.buildChoice=function(e){C(e),e.updateSelected=function(){e.choice.choiceDomManagerHandlers.updateSelected(),g.onChange()},e.dispose=composeSync((function(){e.updateSelected=null}),e.dispose)};var P=o.createWrap;o.createWrap=function(e){var t=P(e);return t.isOptionSelected=m(e),t.updateSelected=null,t},u.toggle,u.toggle=function(e){return y(e.option,A(e,!e.isOptionSelected),!e.isOptionSelected)},f.fullMatch,f.fullMatch=function(e){return y(e.option,A(e,!0),!0)},r.removePick,r.removePick=function(e,t){return y(e.option,A(e,!1),!1)};var S=d.createPickHandlers;d.createPickHandlers=function(e){var t=S(e);return e.updateSelected=composeSync((function(){if(e.isOptionSelected){var n=t.producePick();e.pick=n,n.dispose=composeSync(n.dispose,(function(){e.pick=null}))}else t.removeAndDispose(),t.removeAndDispose=null}),e.updateSelected),p.addPick(e,t),t};var D=p.addPick;return p.addPick=function(e,t){if(e.isOptionSelected){var n=D(e,t);return e.pick=n,n.dispose=composeSync(n.dispose,(function(){e.pick=null})),n}},{buildApi:function(e){e.selectAll=function(){s.resetLayout(),n.forLoop((function(e){l.isSelectable(e)&&!e.isOptionSelected&&y(e.option,A(e,!0),!0)}))},e.deselectAll=function(){s.resetLayout(),a.forEach((function(e){return e.setSelectedFalse()}))},e.setOptionSelected=function(e,t){var i=n.get(e);return y(i.option,A(i,t),t)},e.updateOptionsSelected=function(){return i.updateOptionsSelected()},e.updateOptionSelected=function(e){return updateChoiceSelected(n.get(e),m)}}}}function UpdateOptionsSelectedAspect(e,t){return{updateOptionsSelected:function(){e.forLoop((function(e){return updateChoiceSelected(e,t)}))}}}function updateChoiceSelected(e,t){var n=t(e.option);n!=e.isOptionSelected&&(e.isOptionSelected=n,null==e.updateSelected||e.updateSelected())}function DisabledOptionPlugin(e){var t=e.configuration,n=e.isChoiceSelectableAspect,i=e.createWrapAspect,o=e.buildChoiceAspect,c=e.filterPredicateAspect,r=e.wrapsCollection,s=e.optionToggleAspect,a=e.buildPickAspect,l=t.getIsOptionDisabled;t.options?l||(l=function(e){return void 0!==e.disabled&&e.disabled}):l||(l=function(e){return e.disabled});var u=i.createWrap;i.createWrap=function(e){var t=u(e);return t.isOptionDisabled=l(e),t.updateDisabled=null,t};var d=s.toggle;s.toggle=function(e){var t=!1;return void 0!==e.isOptionSelected?!e.isOptionSelected&&e.isOptionDisabled||(t=d(e)):e.isOptionDisabled||(t=d(e)),t};var p=n.isSelectable;n.isSelectable=function(e){return p(e)&&!e.isOptionDisabled};var f=c.filterPredicate;c.filterPredicate=function(e,t){return!e.isOptionDisabled&&f(e,t)};var g=o.buildChoice;o.buildChoice=function(e){g(e),e.updateDisabled=e.choice.choiceDomManagerHandlers.updateDisabled,e.choice.dispose=composeSync((function(){e.updateDisabled=null}),e.choice.dispose)};var h=a.buildPick;return a.buildPick=function(e,t){var n=h(e,t);n.updateDisabled=function(){return n.pickDomManagerHandlers.updateDisabled()},n.dispose=composeSync(n.dispose,(function(){n.updateDisabled=null}));var i=e.updateDisabled;return e.updateDisabled=composeSync(i,n.updateDisabled),n.dispose=composeSync(n.dispose,(function(){e.updateDisabled=i,e.updateDisabled()})),n},{buildApi:function(e){e.updateOptionsDisabled=function(){return r.forLoop((function(e){return updateChoiceDisabled(e,l)}))},e.updateOptionDisabled=function(e){return updateChoiceDisabled(r.get(e),l)}}}}function updateChoiceDisabled(e,t){var n=t(e.option);n!=e.isOptionDisabled&&(e.isOptionDisabled=n,null==e.updateDisabled||e.updateDisabled())}function PicksApiPlugin(e){var t=e.picksList,n=e.createWrapAspect,i=e.createPickHandlersAspect,o=e.addPickAspect;return{buildApi:function(e){e.forEachPeak=function(e){return t.forEach((function(t){return e(t.option)}))},e.getTailPeak=function(){var e;return null==(e=t.getTail())?void 0:e.option},e.countPeaks=function(){return t.getCount()},e.isEmptyPeaks=function(){return t.isEmpty()},e.addPick=function(e){var t=n.createWrap(e);t.updateDisabled=function(){},t.updateHidden=function(){};var c=i.createPickHandlers(t);o.addPick(t,c)}}}}function PicksPlugin(e){var t=e.configuration;e.inputAspect,e.filterDom,e.filterManagerAspect,t.picks,t.addOptionPicked}function CreatePopperPlugin(e){var t,n=e.environment,i=n.createPopper,o=n.Popper,c=n.globalPopper,r=null,s=null;if(o)t=o,s=i=function(e,n,i){return new t(e,n,i)},r=CreateModifiersV1;else if(i)s=i,r=CreateModifiersV2;else{if(!c)throw new Error("BsMultiSelect: Popper component (https://popper.js.org) is required");c.createPopper?(s=c.createPopper,r=CreateModifiersV2):(s=i=function(e){return function(t,n,i){return new e(t,n,i)}}(c),r=CreateModifiersV1)}e.createPopperAspect=CreatePopperAspect(s,r)}function CreateModifiersV1(e){return{preventOverflow:{enabled:e},hide:{enabled:!1},flip:{enabled:!1}}}function CreateModifiersV2(e){var t=[{name:"flip",options:{fallbackPlacements:["bottom"]}}];return e&&t.push({name:"preventOverflow"}),t}function CreatePopperAspect(e,t){return{createPopper:function(n,i,o){var c={placement:"bottom-start",modifiers:t(o)},r=null;return{init:function(){r=e(i,n,c)},update:function(){r.update()},setRtl:function(e){e&&(c.placement="bottom-end")},dispose:function(){r.destroy()}}}}}function FloatingLabelPlugin(e){var t=e.configuration,n=e.picksList,i=e.picksDom,o=e.filterDom,c=e.staticDom,r=e.updateDataAspect,s=e.resetFilterListAspect,a=e.floatingLabelAspect,l=t.css,u=t.getDefaultLabel,d=c.initialElement;if(a.isFloatingLabel()){var p=function(){!function(e){h(e),m(e)}(!v())},f=u(d),g=i.picksElement,h=toggleStyling(f,l.label_floating_lifted),m=toggleStyling(g,l.picks_floating_lifted),v=function(){return n.isEmpty()&&o.isEmpty()&&!i.getIsFocusIn()};p(),s.forceResetFilter=composeSync(s.forceResetFilter,p);var b=n.add;n.add=function(e){var t=b(e);return 1==n.getCount()&&p(),e.dispose=composeSync(e.dispose,(function(){0==n.getCount()&&p()})),t};var C=i.toggleFocusStyling;i.toggleFocusStyling=function(){var e=i.getIsFocusIn();C(e),p()},r.updateData=composeSync(r.updateData,p)}}function FloatingLabelAspect(){return{isFloatingLabel:function(){}}}function ChoicesDynamicStylingPlugin(e){if(e.configuration.useChoicesDynamicStyling){var t=e.choicesVisibilityAspect,n=e.specialPicksEventsAspect,i=t.setChoicesVisible;e.choicesVisibilityAspect.setChoicesVisible=function(t){t&&choicesDynamicStyling(e),i(t)};var o=n.backSpace;n.backSpace=function(t){o(t),choicesDynamicStyling(e)}}}function choicesDynamicStyling(e){var t=e.configuration,n=e.environment,i=e.choicesDom,o=e.navigateAspect,c=n.window,r=i.choicesElement,s=t.minimalChoicesDynamicStylingMaxHeight,a=c.document.getElementsByTagName("body")[0],l=c.document.documentElement,u=(c.innerHeight||l.clientHeight||a.clientHeight)-r.parentNode.getBoundingClientRect().top,d=Math.max(s,Math.round(.85*u));if(r.style.setProperty("max-height",d+"px"),r.style.setProperty("overflow-y","auto"),!i.ChoicesDynamicStylingPlugin_scrollHandle){i.ChoicesDynamicStylingPlugin_scrollHandle=!0;var p=o.navigate;o.navigate=function(e){var t=p(e);return null!=t&&null!=t.choice&&null!=t.choice.choiceElement&&t.choice.choiceElement.scrollIntoView(!1),t}}}ValidationApiPlugin.plugDefaultConfig=function(e){e.getValueRequired=function(){return!1},e.valueMissingMessage=""},CssPatchPlugin.plugMergeSettings=function(e,t,n){var i=null==n?void 0:n.cssPatch;if(isBoolean(i))throw new Error("BsMultiSelect: 'cssPatch' was used instead of 'useCssPatch'");e.cssPatch=createCss(t.cssPatch,i)},CssPatchPlugin.plugStaticDom=function(e){var t=e.configuration;t.useCssPatch&&extendCss(t.css,t.cssPatch)},SelectElementPlugin.plugStaticDom=function(e){var t=e.configuration,n=e.staticDomFactory,i=e.createElementAspect,o=e.componentPropertiesAspect,c=e.onChangeAspect,r=e.triggerAspect,s=e.optionsAspect,a=e.optGroupAspect,l=e.disposeAspect,u=n.create;n.create=function(e){var n=u(e),d=n.choicesDom,p=n.createStaticDom,f=d.choicesElement;return{choicesDom:d,createStaticDom:function(e,n){var u=null,d=null,g=null;if("SELECT"==e.tagName)u=e,n&&(d=closestByClassName(u,n))&&(g=findDirectChildByTagName(d,"UL"));else if("DIV"==e.tagName){if(!(u=findDirectChildByTagName(e,"SELECT")))return p(e,n);n&&(d=closestByClassName(e,n))&&(g=findDirectChildByTagName(d,"UL"))}var h=!1;d||((d=i.createElement("DIV")).classList.add(n),h=!0);var m=!1;if(g||(g=i.createElement("UL"),m=!0),u){var v=u.style.display;u.style.display="none";var b=u.required;if(t.getValueRequired=function(){return b},!0===u.required&&(u.required=!1),!t.getDisabled){var C=closestByTagName(u,"FIELDSET");o.getDisabled=C?function(){return u.disabled||C.disabled}:function(){return u.disabled}}c.onChange=composeSync((function(){return r.trigger("change")}),c.onChange),s.getOptions=function(){return u.options},a&&(a.getOptionOptGroup=function(e){return e.parentNode},a.getOptGroupText=function(e){return e.label},a.getOptGroupId=function(e){return e.id}),l.dispose=composeSync(l.dispose,(function(){u.required=b,u.style.display=v}))}return{staticDom:{initialElement:e,containerElement:d,picksElement:g,isDisposablePicksElement:m,selectElement:u},staticManager:{appendToContainer:function(){h?(u.parentNode.insertBefore(d,u.nextSibling),d.appendChild(f)):u.parentNode.insertBefore(f,u.nextSibling),m&&d.appendChild(g)},dispose:function(){f.parentNode.removeChild(f),h&&u.parentNode.removeChild(d),m&&d.removeChild(g)}}}}}}},SelectedOptionPlugin.plugStaticDom=function(e){var t=e.configuration,n=e.wrapsCollection,i=t.getSelected,o=t.setSelected;t.options?(o||(o=function(e,t){e.selected=t}),i||(i=function(e){return e.selected})):(i||(i=function(e){return e.selected}),o||(o=function(e,t){e.selected=t})),t.getSelected=i,t.setSelected=o,e.updateOptionsSelectedAspect=UpdateOptionsSelectedAspect(n,i)},PicksPlugin.plugStaticDom=function(e){var t=e.configuration,n=e.picksList,i=t.picks;if(i){var o=n.add,c=n.reset;n.add=function(e){var t=o(e),n=t.remove,c=t.index;return i.push(e),{remove:composeSync(n,(function(){i.splice(c(),1)})),index:c}},n.reset=function(){c(),i.length=0}}},FloatingLabelPlugin.plugStaticDom=function(e){e.floatingLabelAspect=FloatingLabelAspect()},ChoicesDynamicStylingPlugin.plugDefaultConfig=function(e){e.useChoicesDynamicStyling=!1,e.choicesDynamicStyling=choicesDynamicStyling,e.minimalChoicesDynamicStylingMaxHeight=20};var defNoResultsWarningMessage="No results found";function WarningPlugin(e){var t=e.configuration,n=e.choicesDom,i=e.createElementAspect,o=e.staticManager,c=t.css;t.isNoResultsWarningEnabled&&(e.warningAspect=WarningAspect(n,i,o,c))}function WarningAspect(e,t,n,i){var o=e.choicesElement,c=t.createElement("DIV"),r=n.appendToContainer;return n.appendToContainer=function(){r(),o.parentNode.insertBefore(c,o.nextSibling)},c.style.display="none",addStyling(c,i.warning),{warningElement:c,show:function(e){c.style.display="block",c.innerHTML=e},hide:function(){c.style.display="none",c.innerHTML=""}}}function HighlightPlugin(e){var t=e.highlightAspect,n=e.filterManagerAspect,i=e.buildChoiceAspect;if(t){var o=n.processEmptyInput;n.processEmptyInput=function(){t.reset(),o()};var c=n.setFilter;n.setFilter=function(e){t.set(e),c(e)};var r=i.buildChoice;i.buildChoice=function(e){r(e);var t=e.choice.setVisible;e.choice.setVisible=function(n){t(n),e.choice.choiceDomManagerHandlers.updateHighlighted()}}}}function HighlightAspect(){var e=null;return{getHighlighter:function(){return e},set:function(t){var n=t.replace(/[.*+?^${}()|[\]\\]/g,"\\$&"),i=new RegExp("("+n+")","gi");e=function(e,t,n){e.innerHTML=n.replace(i,"<u>$1</u>")}},reset:function(){e=null}}}function CustomChoiceStylingsPlugin(e){var t=e.configuration,n=e.choiceDomFactory,i=CustomChoiceStylingsAspect(t.customChoiceStylings),o=n.create;n.create=function(e,t,n){var c=o(e,t,n);return i.customize(t,c.choiceDom,c.choiceDomManagerHandlers),c}}function CustomChoiceStylingsAspect(e){return{customize:function(t,n,i){if(e){var o=e(n,t.option);if(o){var c=function(e){return function(){e({isOptionSelected:t.isOptionSelected,isOptionDisabled:t.isOptionDisabled,isHoverIn:t.choice.isHoverIn})}};i.updateHoverIn&&o.updateHoverIn&&(i.updateHoverIn=composeSync(i.updateHoverIn,c(o.updateHoverIn))),i.updateSelected&&o.updateSelected&&(i.updateSelected=composeSync(i.updateSelected,c(o.updateSelected))),i.updateDisabled&&o.updateDisabled&&(i.updateDisabled=composeSync(i.updateDisabled,c(o.updateDisabled))),i.updateHighlighted&&o.updateHighlighted&&(i.updateHighlighted=composeSync(i.updateHighlighted,c(o.updateHighlighted)))}}}}}function CustomPickStylingsPlugin(e){var t=e.componentPropertiesAspect,n=e.configuration,i=e.pickDomFactory,o=CustomPickStylingsAspect(t,n.customPickStylings),c=i.create;i.create=function(e,t,n){var i=c(e,t,n);return o.customize(t,i.pickDom,i.pickDomManagerHandlers),i}}function CustomPickStylingsAspect(e,t){return{customize:function(n,i,o){if(t){var c=t(i,n.option);if(c){var r=function(t){return function(){t({isOptionDisabled:n.isOptionDisabled,isComponentDisabled:e.getDisabled()})}};o.updateDisabled&&c.updateDisabled&&(o.updateDisabled=composeSync(o.updateDisabled,r(c.updateDisabled))),o.updateComponentDisabled&&c.updateComponentDisabled&&(o.updateComponentDisabled=composeSync(o.updateComponentDisabled,r(c.updateComponentDisabled)))}}}}}function UpdateAppearancePlugin(e){var t=e.updateAppearanceAspect,n=e.updateAspect,i=e.loadAspect;return n.update=composeSync(n.update,(function(){return t.updateAppearance()})),i.load=composeSync(i.load,(function(){return t.updateAppearance()})),{buildApi:function(e){e.updateAppearance=function(){return t.updateAppearance()}}}}function UpdateAppearanceAspect(){return{updateAppearance:function(){}}}function DisableComponentPlugin(e){var t,n=e.updateAppearanceAspect,i=e.picksList,o=e.picksDom,c=e.componentPropertiesAspect,r=DisableComponentAspect(i,o);function s(){var e=c.getDisabled();t!==e&&(t=e,r.disableComponent(e))}return e.disableComponentAspect=r,n.updateAppearance=composeSync(n.updateAppearance,s),{buildApi:function(e){e.updateDisabled=s}}}function DisableComponentAspect(e,t){return{disableComponent:function(n){e.forEach((function(e){return e.pickDomManagerHandlers.updateComponentDisabled()})),t.disable(n)}}}WarningPlugin.plugDefaultConfig=function(e){e.noResultsWarning=defNoResultsWarningMessage,e.isNoResultsWarningEnabled=!1},HighlightPlugin.plugStaticDom=function(e){e.configuration.useHighlighting&&(e.highlightAspect=HighlightAspect())},HighlightPlugin.plugDefaultConfig=function(e){e.useHighlighting=!1},CustomChoiceStylingsPlugin.plugDefaultConfig=function(e){e.customChoiceStylings=null},CustomPickStylingsPlugin.plugDefaultConfig=function(e){e.customPickStylings=null},UpdateAppearancePlugin.plugStaticDom=function(e){e.updateAppearanceAspect=UpdateAppearanceAspect()};var defaultPlugins={CssPatchPlugin:CssPatchPlugin,SelectElementPlugin:SelectElementPlugin,LabelForAttributePlugin:LabelForAttributePlugin,HiddenOptionPlugin:HiddenOptionPlugin,ValidationApiPlugin:ValidationApiPlugin,UpdateAppearancePlugin:UpdateAppearancePlugin,BsAppearancePlugin:BsAppearancePlugin,DisableComponentPlugin:DisableComponentPlugin,FormResetPlugin:FormResetPlugin,CreatePopperPlugin:CreatePopperPlugin,WarningPlugin:WarningPlugin,RtlPlugin:RtlPlugin,PlaceholderPlugin:PlaceholderPlugin,FloatingLabelPlugin:FloatingLabelPlugin,OptionsApiPlugin:OptionsApiPlugin,JQueryMethodsPlugin:JQueryMethodsPlugin,SelectedOptionPlugin:SelectedOptionPlugin,FormRestoreOnBackwardPlugin:FormRestoreOnBackwardPlugin,DisabledOptionPlugin:DisabledOptionPlugin,PicksApiPlugin:PicksApiPlugin,HighlightPlugin:HighlightPlugin,ChoicesDynamicStylingPlugin:ChoicesDynamicStylingPlugin,CustomPickStylingsPlugin:CustomPickStylingsPlugin,CustomChoiceStylingsPlugin:CustomChoiceStylingsPlugin},picksPlugins={CssPatchPlugin:CssPatchPlugin,PicksPlugin:PicksPlugin,LabelForAttributePlugin:LabelForAttributePlugin,ValidationApiPlugin:ValidationApiPlugin,UpdateAppearancePlugin:UpdateAppearancePlugin,BsAppearancePlugin:BsAppearancePlugin,DisableComponentPlugin:DisableComponentPlugin,CreatePopperPlugin:CreatePopperPlugin,WarningPlugin:WarningPlugin,RtlPlugin:RtlPlugin,PlaceholderPlugin:PlaceholderPlugin,FloatingLabelPlugin:FloatingLabelPlugin,OptionsApiPlugin:OptionsApiPlugin,JQueryMethodsPlugin:JQueryMethodsPlugin,PicksApiPlugin:PicksApiPlugin,HighlightPlugin:HighlightPlugin,ChoicesDynamicStylingPlugin:ChoicesDynamicStylingPlugin,CustomPickStylingsPlugin:CustomPickStylingsPlugin,CustomChoiceStylingsPlugin:CustomChoiceStylingsPlugin},allPlugins=shallowClearClone(defaultPlugins,{PicksPlugin:PicksPlugin}),utilities={composeSync:composeSync,EventBinder:EventBinder,addStyling:addStyling,toggleStyling:toggleStyling};function PluginManager(e,t){var n=[];if(e)for(var i=0;i<e.length;i++){var o=e[i](t);o&&n.push(o)}var c=[];return{buildApi:function(e){for(var t=0;t<n.length;t++){var i,o,r=null==(i=(o=n[t]).buildApi)?void 0:i.call(o,e);r&&c.push(r)}},dispose:function(){for(var e=0;e<c.length;e++)c[e]();c=null;for(var t=0;t<n.length;t++){var i,o;null==(i=(o=n[t]).dispose)||i.call(o)}n=null}}}function plugDefaultConfig(e,t){for(var n=0;n<e.length;n++){var i,o;null==(i=(o=e[n]).plugDefaultConfig)||i.call(o,t)}}function plugMergeSettings(e,t,n,i){for(var o=0;o<e.length;o++){var c,r;null==(c=(r=e[o]).plugMergeSettings)||c.call(r,t,n,i)}}function plugStaticDom(e,t){for(var n=0;n<e.length;n++){var i,o;null==(i=(o=e[n]).plugStaticDom)||i.call(o,t)}}function PickDomFactory(e,t,n,i){return{create:function(o,c,r){var s=EventBinder(),a=i.getButtonHTML();o.innerHTML="<span></span>"+a;var l=o.querySelector("SPAN"),u=o.querySelector("BUTTON");s.bind(u,"click",r),addStyling(l,e.pickContent),addStyling(u,e.pickButton);var d=toggleStyling(l,e.pickContent_disabled);return{pickDom:{pickContentElement:l,pickButtonElement:u},pickDomManagerHandlers:{updateData:function(){l.textContent=n.getText(c.option)},updateDisabled:function(){d(c.isOptionDisabled)},updateComponentDisabled:function(){u.disabled=t.getDisabled()}},dispose:function(){s.unbind()}}}}}function ChoiceDomFactory(e,t,n){var i=function(e,i,o){var c=t.getText(e.option),r=n.getHighlighter();r?r(o,i,c):o.textContent=c},o=function(e,n){n.textContent=t.getText(e.option)};return{create:function(t,n,c){var r=null,s=null,a=EventBinder();if(a.bind(t,"click",c),n.hasOwnProperty("isOptionSelected")){t.innerHTML='<div><input formnovalidate type="checkbox"><label></label></div>';var l=t.querySelector("DIV"),u=l.querySelector("INPUT"),d=l.querySelector("LABEL");addStyling(l,e.choiceContent),addStyling(u,e.choiceCheckBox),addStyling(d,e.choiceLabel),r={choiceElement:t,choiceContentElement:l,choiceCheckBoxElement:u,choiceLabelElement:d};var p=toggleStyling(t,e.choice_selected),f=toggleStyling(t,e.choice_disabled),g=toggleStyling(u,e.choiceCheckBox_disabled),h=toggleStyling(d,e.choiceLabel_disabled),m=toggleStyling(t,{classes:[],styles:{cursor:"default"}}),v=toggleStyling(t,(function(){return e.choice_disabled_hover&&!0===n.isOptionDisabled&&!1===n.isOptionSelected?e.choice_disabled_hover:e.choice_hover}));s={updateData:function(){return o(n,d)},updateHighlighted:function(){return i(n,r,d)},updateHoverIn:function(){v(n.choice.isHoverIn)},updateDisabled:function(){f(n.isOptionDisabled),g(n.isOptionDisabled),h(n.isOptionDisabled);var e=n.isOptionDisabled&&!n.isOptionSelected;u.disabled=e,m(e)},updateSelected:function(){p(n.isOptionSelected),u.checked=n.isOptionSelected,(n.isOptionDisabled||n.choice.isHoverIn)&&v(n.choice.isHoverIn,!0)}}}else{var b=toggleStyling(t,(function(){return n.isOptionDisabled&&e.choice_disabled_hover?e.choice_disabled_hover:e.choice_hover}));t.innerHTML="<span></span>";var C=t.querySelector("SPAN");r={choiceElement:t,choiceContentElement:C},s={updateData:function(){return o(n,C)},updateHighlighted:function(){return i(n,r,t)},updateHoverIn:function(){b(n.choice.isHoverIn)}}}return{choiceDom:r,choiceDomManagerHandlers:s,dispose:function(){a.unbind()}}}}}function CreateElementAspect(e){return{createElement:e}}function StaticDomFactory(e,t){return{create:function(n){var i=e.create(n);return{choicesDom:i,createStaticDom:function(e,n){function o(t){throw e.style.backgroundColor="red",e.style.color="white",new Error(t)}var c,r,s=!1;"DIV"==e.tagName?((c=e).classList.contains(n)||(c.classList.add(n),s=!0),r=findDirectChildByTagName(c,"UL")):"UL"==e.tagName?(r=e,(c=closestByClassName(e,n))||o("BsMultiSelect: defined on UL but precedentant DIV for container not found; class="+n)):"INPUT"==e.tagName&&o("BsMultiSelect: INPUT element is not supported");var a=!1;return r||(r=t.createElement("UL"),a=!0),{choicesDom:i,staticDom:{initialElement:e,containerElement:c,picksElement:r,isDisposablePicksElement:a},staticManager:{appendToContainer:function(){c.appendChild(i.choicesElement),a&&c.appendChild(r)},dispose:function(){c.removeChild(i.choicesElement),s&&c.classList.remove(n),a&&c.removeChild(r)}}}}}}}}function PicksDom(e,t,n,i){var o=n.createElement("LI");addStyling(e,i.picks),addStyling(o,i.pickFilter);var c=toggleStyling(e,i.picks_disabled),r=toggleStyling(e,i.picks_focus),s=!1;return{picksElement:e,pickFilterElement:o,createPickElement:function(){var t=n.createElement("LI");return addStyling(t,i.pick),{pickElement:t,attach:function(n){return e.insertBefore(t,null!=n?n:o)},detach:function(){return e.removeChild(t)}}},disable:function(e){c(e)},toggleFocusStyling:function(){r(s)},getIsFocusIn:function(){return s},setIsFocusIn:function(e){s=e},dispose:function(){t||(c(!1),r(!1),o.parentNode&&o.parentNode.removeChild(o))}}}function FilterDom(e,t,n){var i=t.createElement("INPUT");addStyling(i,n.filterInput),i.setAttribute("type","search"),i.setAttribute("autocomplete","off");var o=EventBinder();return{filterInputElement:i,isEmpty:function(){return!i.value},setEmpty:function(){i.value=""},getValue:function(){return i.value},setFocus:function(){i.focus()},setWidth:function(e){i.style.width=1.3*e.length+2+"ch"},setFocusIfNotTarget:function(e){e!=i&&i.focus()},onInput:function(e){o.bind(i,"input",e)},onFocusIn:function(e){o.bind(i,"focusin",e)},onFocusOut:function(e){o.bind(i,"focusout",e)},onKeyDown:function(e){o.bind(i,"keydown",e)},onKeyUp:function(e){o.bind(i,"keyup",e)},dispose:function(){o.unbind(),e||i.parentNode&&i.parentNode.removeChild(i)}}}function ChoicesDomFactory(e){return{create:function(t){var n=e.createElement("DIV"),i=e.createElement("UL");return n.appendChild(i),n.style.display="none",addStyling(n,t.choices),addStyling(i,t.choicesList),{choicesElement:n,choicesListElement:i,createChoiceElement:function(){var n=e.createElement("LI");return addStyling(n,t.choice),{choiceElement:n,setVisible:function(e){return n.style.display=e?"block":"none"},attach:function(e){return i.insertBefore(n,e)},detach:function(){return i.removeChild(n)}}}}}}}function ChoicesVisibilityAspect(e){return{isChoicesVisible:function(){return"none"!=e.style.display},setChoicesVisible:function(t){e.style.display=t?"block":"none"},updatePopupLocation:function(){}}}function SpecialPicksEventsAspect(){return{backSpace:function(e){e.setSelectedFalse()}}}function TriggerAspect(e,t){return{trigger:function(n){t(e,n)}}}function OnChangeAspect(e,t){return{onChange:function(){e.trigger(t)}}}function ComponentPropertiesAspect(e){return{getDisabled:e}}function OptionsAspect(e){return{getOptions:function(){return e}}}function OptionPropertiesAspect(e){return e||(e=function(e){return e.text}),{getText:e}}function ChoicesEnumerableAspect(e,t){return{forEach:function(n){for(var i=e.getHead();i;)n(i),i=t(i)}}}function NavigateManager(e,t,n){return{navigate:function(i,o){return i?o?n(o):e.getHead():o?t(o):e.getTail()},getCount:function(){return e.getCount()},getHead:function(){return e.getHead()}}}function FilterPredicateAspect(){return{filterPredicate:function(e,t){return e.choice.searchText.indexOf(t)>=0}}}function FilterManagerAspect(e,t,n,i,o){var c=!0,r="";return{getNavigateManager:function(){return c?e:t},processEmptyInput:function(){c=!0,r="",i.forEach((function(e){e.choice.setVisible(!0)}))},getFilter:function(){return r},setFilter:function(e){c=!1,r=e,n.reset(),i.forEach((function(t){t.choice.filteredPrev=t.choice.filteredNext=null;var i=o.filterPredicate(t,e);i&&n.add(t),t.choice.setVisible(i)}))}}}function BuildAndAttachChoiceAspect(e){return{buildAndAttachChoice:function(t,n){e.buildChoice(t),t.choice.choiceElementAttach(null==n?void 0:n())}}}function BuildChoiceAspect(e,t,n){return{buildChoice:function(i){var o=e.createChoiceElement(),c=o.choiceElement,r=o.setVisible,s=o.attach,a=o.detach;i.choice.choiceElement=c,i.choice.choiceElementAttach=s,i.choice.isChoiceElementAttached=!0;var l=t.create(c,i,(function(){return n.choiceClick(i)})),u=l.dispose,d=l.choiceDom,p=l.choiceDomManagerHandlers;i.choice.choiceDom=d,p.updateData(),p.updateSelected&&p.updateSelected(),p.updateDisabled&&p.updateDisabled(),i.choice.choiceDomManagerHandlers=p,i.choice.remove=function(){a()},i.choice.isFilteredIn=!0,i.choice.setHoverIn=function(e){i.choice.isHoverIn=e,p.updateHoverIn()},i.choice.setVisible=function(e){i.choice.isFilteredIn=e,r(i.choice.isFilteredIn)},i.choice.dispose=function(){i.choice.choiceDomManagerHandlers=null,u(),i.choice.choiceElement=null,i.choice.choiceDom=null,i.choice.choiceElementAttach=null,i.choice.isChoiceElementAttached=!1,i.choice.remove=null,i.choice.setVisible=null,i.choice.setHoverIn=null,i.choice.dispose=null},i.dispose=function(){i.choice.dispose(),i.dispose=null}}}}function OptionAttachAspect(e,t,n,i){return{attach:function(o){var c=e.createWrap(o);c.choice=t.createChoiceBase(o),i.push(c),n.buildAndAttachChoice(c)}}}function OptionsLoopAspect(e,t){return{loop:function(){for(var n=e.getOptions(),i=0;i<n.length;i++){var o=n[i];t.attach(o)}}}}function UpdateDataAspect(e,t,n,i,o){return{updateData:function(){o.resetLayout(),e.choicesListElement.innerHTML="",t.clear(),n.forEach((function(e){return e.dispose()})),n.reset(),i.loop()}}}function UpdateAspect(e){return{update:function(){e.updateData()}}}function IsChoiceSelectableAspect(){return{isSelectable:function(e){return!0}}}function ChoiceClickAspect(e,t){return{choiceClick:function(n){e.toggle(n),t.setFocus()}}}function OptionToggleAspect(e,t){return{toggle:function(n){var i=e.createPickHandlers(n);return t.addPick(n,i),!0}}}function AddPickAspect(){return{addPick:function(e,t){return t.producePick()}}}function FullMatchAspect(e,t){return{fullMatch:function(n){var i=e.createPickHandlers(n);return t.addPick(n,i),!0}}}function RemovePickAspect(){return{removePick:function(e,t){t.dispose()}}}function ProducePickAspect(e,t,n){return{producePick:function(i,o){var c=n.buildPick(i,(function(e){return o.removeOnButton(e)})),r=function(){return t.removePick(i,c)};o.removeOnButton=r,c.pickElementAttach();var s=e.add(c).remove;return c.setSelectedFalse=r,c.wrap=i,c.dispose=composeSync(s,(function(){c.setSelectedFalse=null,c.wrap=null}),c.dispose),o.removeAndDispose=function(){return c.dispose()},c}}}function CreatePickHandlersAspect(e){return{createPickHandlers:function(t){var n={producePick:(null,function(){return e.producePick(t,n)}),removeAndDispose:null,removeOnButton:null};return n}}}function CreateChoiceBaseAspect(e){return{createChoiceBase:function(t){return{filteredPrev:null,filteredNext:null,searchText:e.getText(t).toLowerCase().trim(),isHoverIn:!1,isFilteredIn:!1,setVisible:null,setHoverIn:null,isChoiceElementAttached:!1,choiceElement:null,choiceDom:null,choiceElementAttach:null,itemPrev:null,itemNext:null,remove:null,dispose:null}}}}function CreateWrapAspect(){return{createWrap:function(e){return{option:e}}}}function HoveredChoiceAspect(){var e=null;return{getHoveredChoice:function(){return e},setHoveredChoice:function(t){e=t},resetHoveredChoice:function(){e&&(e.choice.setHoverIn(!1),e=null)}}}function NavigateAspect(e,t){return{hoverIn:function(t){e.resetHoveredChoice(),e.setHoveredChoice(t),t.choice.setHoverIn(!0)},navigate:function(n){return t(n,e.getHoveredChoice())}}}function Wraps(e,t,n,i){return{push:function(t){return _push(t,e,i)},insert:function(t,n){return _insert(t,n,e,i)},remove:function(t){var i=e.remove(t);return n(i),i},clear:function(){e.reset(),t()},dispose:function(){return e.forLoop((function(e){return e.dispose()}))}}}function _push(e,t,n){t.push(e),n(e)}function _insert(e,t,n,i){e>=n.getCount()?_push(t,n,i):(n.add(t,e),i(t,e))}function PickButtonAspect(e){return{getButtonHTML:function(){return e}}}function BuildPickAspect(e,t){return{buildPick:function(n,i){var o=e.createPickElement(),c=o.pickElement,r=o.attach,s=o.detach,a=t.create(c,n,i),l=a.dispose,u=a.pickDom,d=a.pickDomManagerHandlers;d.updateData(),d.updateDisabled&&d.updateDisabled(),d.updateComponentDisabled&&d.updateComponentDisabled();var p={pickDom:u,pickDomManagerHandlers:d,pickElementAttach:r,dispose:function(){s(),l(),p.pickDomManagerHandlers=null,p.pickDom=u,p.pickElementAttach=null,p.dispose=null}};return p}}}function InputAspect(e,t,n){return{processInput:function(){var i=e.getValue(),o=i.trim(),c=!1;if(""==o?c=!0:t.setFilter(o.toLowerCase()),!c&&1==t.getNavigateManager().getCount()){var r=t.getNavigateManager().getHead(),s=t.getFilter();if(r.choice.searchText==s)n.fullMatch(r)&&(e.setEmpty(),c=!0)}return{filterInputValue:i,isEmpty:c}}}}function ResetFilterListAspect(e,t){return{forceResetFilter:function(){e.setEmpty(),t.processEmptyInput()}}}function ResetFilterAspect(e,t){return{resetFilter:function(){e.isEmpty()||t.forceResetFilter()}}}function FocusInAspect(e){return{setFocusIn:function(t){e.setIsFocusIn(t),e.toggleFocusStyling()}}}function MultiSelectInlineLayout(e){var t=e.environment,n=e.filterDom,i=e.picksDom,o=e.choicesDom,c=e.choicesVisibilityAspect,r=e.hoveredChoiceAspect,s=e.navigateAspect,a=e.filterManagerAspect,l=e.focusInAspect,u=e.optionToggleAspect,d=e.createPickHandlersAspect,p=e.picksList,f=e.inputAspect,g=e.specialPicksEventsAspect,h=e.buildChoiceAspect,m=e.disableComponentAspect,v=e.resetLayoutAspect,b=e.placeholderStopInputAspect,C=e.warningAspect,A=e.configuration,y=e.createPopperAspect,P=e.rtlAspect,S=e.staticManager,D=i.picksElement,k=o.choicesElement,E=n.filterInputElement,L=y.createPopper(k,E,!0);S.appendToContainer=composeSync(S.appendToContainer,L.init);var I=g.backSpace;if(g.backSpace=function(e){I(e),L.update()},P){var F=P.updateRtl;P.updateRtl=function(e){F(e),L.setRtl(e)}}if(c.updatePopupLocation=composeSync(c.updatePopupLocation,(function(){L.update()})),C){var H=y.createPopper(C.warningElement,E,!1);if(S.appendToContainer=composeSync(S.appendToContainer,H.init),P){var M=P.updateRtl;P.updateRtl=function(e){M(e),H.setRtl(e)}}var O=C.show;C.show=function(e){H.update(),O(e)},L.dispose=composeSync(L.dispose,H.dispose)}var B=t.window,x=B.document,w=EventLoopProlongableFlag(B),V=!1;function N(){V=!1}var _=function(){V=!0},T=function(e){k==e.target?n.setFocus():containsAndSelf(k,e.target)||containsAndSelf(D,e.target)||(v.resetLayout(),l.setFocusIn(!1))};function R(){c.isChoicesVisible()||(c.updatePopupLocation(),w.set(),c.setChoicesVisible(!0),k.scrollTop=0,k.addEventListener("mousedown",_),x.addEventListener("mouseup",T))}function W(){Q(),r.resetHoveredChoice(),c.isChoicesVisible()&&(c.setChoicesVisible(!1),k.removeEventListener("mousedown",_),x.removeEventListener("mouseup",T))}var U=null,z=EventBinder();function q(){_(),B.setTimeout((function(){return N()}))}function G(e){n.setFocusIfNotTarget(e.target),U!=e&&(c.isChoicesVisible()?W():a.getNavigateManager().getCount()>0&&R()),U=null}function j(e){return function(t){!function(e,t){B.setTimeout((function(){return e()})),U=t}(e,t),v.resetLayout()}}D.addEventListener("mousedown",q);var J=EventBinder(),Q=function(){J.unbind()},K=function(e){e.choice.isHoverIn||s.hoverIn(e),Q()};function $(e){var t=s.navigate(e);t&&(w.set(400),s.hoverIn(t),R())}function X(){var e=r.getHoveredChoice();e&&(u.toggle(e)&&v.resetLayout())}n.onFocusIn((function(){return l.setFocusIn(!0)})),n.onFocusOut((function(){V||(v.resetLayout(),l.setFocusIn(!1)),N()})),n.onInput((function(){if(b&&b.get())b.reset();else{var e=f.processInput(),t=e.filterInputValue;e.isEmpty?a.processEmptyInput():n.setWidth(t),w.set(),function(){var e=a.getNavigateManager().getCount();if(e>0){C&&C.hide();var t=c.isChoicesVisible();t||R(),1==e?s.hoverIn(a.getNavigateManager().getHead()):t&&r.resetHoveredChoice()}else c.isChoicesVisible()&&W(),C&&(a.getFilter()?C.show(A.noResultsWarning):C.hide())}()}}));if(n.onKeyDown((function(e){var t=e.which,i=n.isEmpty();if(([13,27].indexOf(t)>=0||9==t&&!i)&&e.preventDefault(),[38,40].indexOf(t)>=0&&e.preventDefault(),8==t){if(i){var o=p.getTail();o&&g.backSpace(o)}}else 9==t?i&&W():27==t?i&&!c.isChoicesVisible()||e.stopPropagation():38==t?$(!1):40==t&&$(!0)})),n.onKeyUp((function(e){var t=e.which;9==t?c.isChoicesVisible()&&X():13==t?c.isChoicesVisible()?X():a.getNavigateManager().getCount()>0&&R():27==t&&v.resetLayout()})),m){var Y=m.disableComponent;m.disableComponent=function(e){Y(e),e?z.unbind():z.bind(D,"click",G)}}v.resetLayout=composeSync(W,(function(){C&&C.hide()}),v.resetLayout);var Z=d.createPickHandlers;d.createPickHandlers=function(e){var t=Z(e);return t.removeOnButton=j(t.removeOnButton),t};var ee=h.buildChoice;return h.buildChoice=function(e){ee(e);var t=d.createPickHandlers(e);e.choice.remove=composeSync(e.choice.remove,(function(){t.removeAndDispose&&(t.removeAndDispose(),t.removeAndDispose=null)}));var n=function(e){var t=e.choice.choiceElement,n=EventBinder();return n.bind(t,"mouseover",(function(){w.get()?(Q(),J.bind(t,"mousemove",(function(){return K(e)})),J.bind(t,"mousedown",(function(){return K(e)}))):e.choice.isHoverIn||s.hoverIn(e)})),n.bind(t,"mouseleave",(function(){w.get()||r.resetHoveredChoice()})),n.unbind}(e);e.choice.dispose=composeSync(n,e.choice.dispose)},{dispose:function(){Q(),D.removeEventListener("mousedown",q),z.unbind(),L.dispose()}}}function ResetLayoutAspect(e){return{resetLayout:e}}function LoadAspect(e){return{load:function(){e.loop()}}}function CountableChoicesListInsertAspect(e,t){return{countableChoicesListInsert:function(n,i){var o=t.getNext(i);e.add(n,o)}}}function BsMultiSelect(e,t,n,i,o){var c,r=t.window;t.isIE11=!!r.MSInputMethodContext&&!!document.documentMode;var s=i.containerClass,a=i.css,l=i.getDisabled,u=i.options,d=i.getText,p={dispose:function(){}},f=TriggerAspect(e,t.trigger),g=OnChangeAspect(f,"dashboardcode.multiselect:change"),h=ComponentPropertiesAspect(null!=l?l:function(){return!1}),m=OptionsAspect(u),v=OptionPropertiesAspect(d),b=IsChoiceSelectableAspect(),C=CreateWrapAspect(),A=CreateChoiceBaseAspect(v),y=AddPickAspect(),P=RemovePickAspect(),S=CreateElementAspect((function(e){return r.document.createElement(e)})),D=ChoicesDomFactory(S),k=StaticDomFactory(D,S),E=ArrayFacade(),L=DoublyLinkedList((function(e){return e.choice.itemPrev}),(function(e,t){return e.choice.itemPrev=t}),(function(e){return e.choice.itemNext}),(function(e,t){return e.choice.itemNext=t})),I=CountableChoicesListInsertAspect(L,E),F=ChoicesEnumerableAspect(L,(function(e){return e.choice.itemNext})),H=DoublyLinkedList((function(e){return e.choice.filteredPrev}),(function(e,t){return e.choice.filteredPrev=t}),(function(e){return e.choice.filteredNext}),(function(e,t){return e.choice.filteredNext=t})),M=NavigateManager(L,(function(e){return e.choice.itemPrev}),(function(e){return e.choice.itemNext})),O=NavigateManager(H,(function(e){return e.choice.filteredPrev}),(function(e){return e.choice.filteredNext})),B=FilterPredicateAspect(),x=FilterManagerAspect(M,O,H,F,B),w=HoveredChoiceAspect(),V=NavigateAspect(w,(function(e,t){return x.getNavigateManager().navigate(e,t)})),N=List(),_=Wraps(E,(function(){return L.reset()}),(function(e){return L.remove(e)}),(function(e,t){return I.countableChoicesListInsert(e,t)})),T={environment:t,configuration:i,triggerAspect:f,onChangeAspect:g,componentPropertiesAspect:h,disposeAspect:p,countableChoicesList:L,countableChoicesListInsertAspect:I,optionsAspect:m,optionPropertiesAspect:v,createWrapAspect:C,createChoiceBaseAspect:A,isChoiceSelectableAspect:b,createElementAspect:S,choicesDomFactory:D,staticDomFactory:k,filterPredicateAspect:B,wrapsCollection:E,choicesEnumerableAspect:F,filteredChoicesList:H,filterManagerAspect:x,hoveredChoiceAspect:w,navigateAspect:V,picksList:N,wraps:_,addPickAspect:y,removePickAspect:P};plugStaticDom(n,T);var R=k.create(a),W=R.choicesDom,U=(0,R.createStaticDom)(e,s),z=U.staticDom,q=U.staticManager,G=FilterDom(z.isDisposablePicksElement,S,a),j=PicksDom(z.picksElement,z.isDisposablePicksElement,S,a),J=SpecialPicksEventsAspect(),Q=ChoicesVisibilityAspect(W.choicesElement),K=ResetFilterListAspect(G,x),$=ResetFilterAspect(G,K),X=FocusInAspect(j),Y=PickDomFactory(a,h,v,PickButtonAspect(i.pickButtonHTML)),Z=BuildPickAspect(j,Y),ee=ProducePickAspect(N,P,Z),te=CreatePickHandlersAspect(ee),ne=OptionToggleAspect(te,y),ie=FullMatchAspect(te,y),oe=InputAspect(G,x,ie),ce=ChoiceClickAspect(ne,G),re=ChoiceDomFactory(a,v,T.highlightAspect),se=BuildChoiceAspect(W,re,ce),ae=BuildAndAttachChoiceAspect(se),le=ResetLayoutAspect((function(){return $.resetFilter()})),ue=OptionAttachAspect(C,A,ae,_),de=OptionsLoopAspect(m,ue),pe=UpdateDataAspect(W,_,N,de,le),fe=UpdateAspect(pe),ge=LoadAspect(de);extendIfUndefined(T,((c={staticDom:z,picksDom:j,choicesDom:W,filterDom:G,resetLayoutAspect:le,pickDomFactory:Y,choiceDomFactory:re,choicesVisibilityAspect:Q,staticManager:q,buildChoiceAspect:se,optionToggleAspect:ne,choiceClickAspect:ce,buildAndAttachChoiceAspect:ae,optionsLoopAspect:de,optionAttachAspect:ue,buildPickAspect:Z,producePickAspect:ee,createPickHandlersAspect:te,inputAspect:oe,resetFilterListAspect:K,resetFilterAspect:$,specialPicksEventsAspect:J}).resetLayoutAspect=le,c.focusInAspect=X,c.loadAspect=ge,c.updateDataAspect=pe,c.updateAspect=fe,c.fullMatchAspect=ie,c));var he=PluginManager(n,T),me=MultiSelectInlineLayout(T),ve={component:"BsMultiSelect.api"};return he.buildApi(ve),ve.dispose=composeSync(le.resetLayout,(function(){p.dispose()}),he.dispose,(function(){N.forEach((function(e){return e.dispose()}))}),me.dispose,_.dispose,q.dispose,j.dispose,G.dispose),ve.updateData=function(){pe.updateData()},ve.update=function(){fe.update()},null==o||o(ve,T),j.pickFilterElement.appendChild(G.filterInputElement),j.picksElement.appendChild(j.pickFilterElement),q.appendToContainer(),ge.load(),ve}var transformStyles=[{old:"selectedPanelDisabledBackgroundColor",opt:"picks_disabled",style:"backgroundColor"},{old:"selectedPanelFocusValidBoxShadow",opt:"picks_focus_valid",style:"boxShadow"},{old:"selectedPanelFocusInvalidBoxShadow",opt:"picks_focus_invalid",style:"boxShadow"},{old:"selectedPanelDefMinHeight",opt:"picks_def",style:"minHeight"},{old:"selectedPanelLgMinHeight",opt:"picks_lg",style:"minHeight"},{old:"selectedPanelSmMinHeight",opt:"picks_sm",style:"minHeight"},{old:"selectedItemContentDisabledOpacity",opt:"choiceLabel_disabled",style:"opacity"}],transformClasses=[{old:"dropDownMenuClass",opt:"choices"},{old:"dropDownItemClass",opt:"choice"},{old:"dropDownItemHoverClass",opt:"choice_hover"},{old:"selectedPanelClass",opt:"picks"},{old:"selectedItemClass",opt:"pick"},{old:"removeSelectedItemButtonClass",opt:"pickButton"},{old:"filterInputItemClass",opt:"pickFilter"},{old:"filterInputClass",opt:"filterInput"},{old:"selectedPanelFocusClass",opt:"picks_focus"},{old:"selectedPanelDisabledClass",opt:"picks_disabled"},{old:"selectedItemContentDisabledClass",opt:"pick_disabled"}];function adjustLegacySettings(e){e.css||(e.css={});var t=e.css;e.cssPatch||(e.cssPatch={});var n=e.cssPatch;if((e.selectedPanelFocusBorderColor||e.selectedPanelFocusBoxShadow)&&(console.log("DashboarCode.BsMultiSelect: selectedPanelFocusBorderColor and selectedPanelFocusBoxShadow are depricated, use - cssPatch:{picks_focus:{borderColor:'myValue', boxShadow:'myValue'}}"),n.picks_focus||(n.picks_focus={boxShadow:e.selectedPanelFocusBoxShadow,borderColor:e.selectedPanelFocusBorderColor}),delete e.selectedPanelFocusBorderColor,delete e.selectedPanelFocusBoxShadow),transformStyles.forEach((function(t){if(e[t.old]){if(console.log("DashboarCode.BsMultiSelect: "+t.old+" is depricated, use - cssPatch:{"+t.opt+":{"+t.style+":'myValue'}}"),!e[t.opt]){var n={};n[t.style]=e[t.old],e.cssPatch[t.opt]=n}delete e[t.old]}})),transformClasses.forEach((function(n){e[n.old]&&(console.log("DashboarCode.BsMultiSelect: "+n.old+" is depricated, use - css:{"+n.opt+":'myValue'}"),t[n.opt]||(t[n.opt]=e[n.old]),delete e[n.old])})),e.inputColor&&(console.log("DashboarCode.BsMultiSelect: inputColor is depricated, remove parameter"),delete e.inputColor),e.useCss&&(console.log("DashboarCode.BsMultiSelect: useCss(=true) is depricated, use - 'useCssPatch: false'"),t.pick_disabled||(e.useCssPatch=!e.useCss),delete e.useCss),e.getIsValid||e.getIsInValid)throw"DashboarCode.BsMultiSelect: parameters getIsValid and getIsInValid are depricated and removed, use - getValidity that should return (true|false|null) "}function MultiSelectBuilder(e,t){var n={containerClass:"dashboardcode-bsmultiselect"};return plugDefaultConfig(t,n),{create:function(i,o){var c;o&&o.plugins&&console.log("DashboarCode.BsMultiSelect: 'options.plugins' is depricated, use - MultiSelectBuilder(environment, plugins) instead");var r,s,a={};o instanceof Function?(r=o,o=null):r=null==(s=o)?void 0:s.buildConfiguration;o&&adjustLegacySettings(o),a.css=createCss(n.css,null==(c=o)?void 0:c.css),plugMergeSettings(t,a,n,o),extendIfUndefined(a,o),extendIfUndefined(a,n);var l=null==r?void 0:r(i,a);return BsMultiSelect(i,e,t,a,l)},defaultSettings:n}}function ModuleFactory(e){e.trigger||(e.trigger=function(t,n){return t.dispatchEvent(new e.window.Event(n))});var t=ObjectValues(shallowClearClone({Bs4Plugin:Bs4Plugin},defaultPlugins)),n=MultiSelectBuilder(e,t),i=n.create,o=n.BsMultiSelectDefault;i.Default=o;var c=ObjectValues(shallowClearClone({Bs4Plugin:Bs4Plugin},picksPlugins)),r=MultiSelectBuilder(e,c),s=r.create,a=r.BsPicksDefault;return s.Default=a,{BsMultiSelect:i,BsPicks:s,MultiSelectTools:{MultiSelectBuilder:MultiSelectBuilder,plugins:shallowClearClone({Bs4Plugin:Bs4Plugin},allPlugins),utilities:utilities}}}function legacyConstructor(e,t,n){return console.log("DashboarCode.BsMultiSelect: 'BsMultiSelect' is depricated, use - ModuleFactory(environment).BsMultiSelect(element, settings)"),(0,ModuleFactory(t).BsMultiSelect)(e,n)}export{legacyConstructor as BsMultiSelect,ModuleFactory};
//# sourceMappingURL=BsMultiSelect.bs4.esm.min.js.map