import { PluginManager, plugStaticDom } from './PluginManager';
import { composeSync, List, extendIfUndefined } from './ToolsJs';
import { PickDomFactory } from './PickDomFactory';
import { ChoiceDomFactory } from './ChoiceDomFactory';
import { StaticDomFactory, CreateElementAspect } from './StaticDomFactory';
import { PicksDom } from './PicksDom';
import { FilterDom } from './FilterDom';
import { ChoicesDomFactory } from './ChoicesDomFactory';
import { ChoicesVisibilityAspect } from './ChoicesVisibilityAspect';
import { SpecialPicksEventsAspect } from './SpecialPicksEventsAspect';
import { ComponentPropertiesAspect, TriggerAspect, OnChangeAspect } from './ComponentPropertiesAspect';
import { OptionsAspect, OptionPropertiesAspect } from './OptionsAspect';
import { ChoicesEnumerableAspect } from './ChoicesEnumerableAspect';
import { FilterManagerAspect, NavigateManager, FilterPredicateAspect } from './FilterManagerAspect';
import { BuildAndAttachChoiceAspect, BuildChoiceAspect } from './BuildChoiceAspect';
import { OptionsLoopAspect, OptionAttachAspect } from './OptionsLoopAspect';
import { UpdateDataAspect } from './UpdateDataAspect';
import { UpdateAspect } from './UpdateDataAspect';
import { CreateWrapAspect, CreateChoiceBaseAspect, OptionToggleAspect, CreatePickHandlersAspect, RemovePickAspect, AddPickAspect, FullMatchAspect, ChoiceClickAspect, IsChoiceSelectableAspect, ProducePickAspect } from './CreateWrapAspect.js';
import { NavigateAspect, HoveredChoiceAspect } from './NavigateAspect';
import { Wraps } from './Wraps';
import { PickButtonAspect } from './PickButtonAspect';
import { BuildPickAspect } from './BuildPickAspect';
import { InputAspect } from './InputAspect';
import { ResetFilterAspect, FocusInAspect, ResetFilterListAspect } from './ResetFilterListAspect';
import { MultiSelectInlineLayout } from './MultiSelectInlineLayout';
import { ResetLayoutAspect } from './ResetLayoutAspect';
import { LoadAspect } from './LoadAspect';
import { DoublyLinkedList, ArrayFacade } from './ToolsJs';
import { CountableChoicesListInsertAspect } from './CountableChoicesListInsertAspect'; /// environment - common for many; configuration for concreate

export function BsMultiSelect(element, environment, plugins, configuration, onInit) {
  var _extendIfUndefined;

  var window = environment.window;
  environment.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
  var containerClass = configuration.containerClass,
      css = configuration.css,
      getDisabled = configuration.getDisabled,
      options = configuration.options,
      getText = configuration.getText;
  var disposeAspect = {
    dispose: function dispose() {}
  };
  var triggerAspect = TriggerAspect(element, environment.trigger);
  var onChangeAspect = OnChangeAspect(triggerAspect, 'dashboardcode.multiselect:change');
  var componentPropertiesAspect = ComponentPropertiesAspect(getDisabled != null ? getDisabled : function () {
    return false;
  });
  var optionsAspect = OptionsAspect(options);
  var optionPropertiesAspect = OptionPropertiesAspect(getText);
  var isChoiceSelectableAspect = IsChoiceSelectableAspect();
  var createWrapAspect = CreateWrapAspect();
  var createChoiceBaseAspect = CreateChoiceBaseAspect(optionPropertiesAspect); //let rtlAspect = RtlAspect();
  //let setOptionSelectedAspect = SetOptionSelectedAspect(optionPropertiesAspect);

  var addPickAspect = AddPickAspect();
  var removePickAspect = RemovePickAspect();
  var createElementAspect = CreateElementAspect(function (name) {
    return window.document.createElement(name);
  });
  var choicesDomFactory = ChoicesDomFactory(createElementAspect);
  var staticDomFactory = StaticDomFactory(choicesDomFactory, createElementAspect);
  var wrapsCollection = ArrayFacade();
  var countableChoicesList = DoublyLinkedList(function (wrap) {
    return wrap.choice.itemPrev;
  }, function (warp, v) {
    return warp.choice.itemPrev = v;
  }, function (wrap) {
    return wrap.choice.itemNext;
  }, function (wrap, v) {
    return wrap.choice.itemNext = v;
  });
  var countableChoicesListInsertAspect = CountableChoicesListInsertAspect(countableChoicesList, wrapsCollection);
  var choicesEnumerableAspect = ChoicesEnumerableAspect(countableChoicesList, function (wrap) {
    return wrap.choice.itemNext;
  });
  var filteredChoicesList = DoublyLinkedList(function (wrap) {
    return wrap.choice.filteredPrev;
  }, function (wrap, v) {
    return wrap.choice.filteredPrev = v;
  }, function (wrap) {
    return wrap.choice.filteredNext;
  }, function (wrap, v) {
    return wrap.choice.filteredNext = v;
  });
  var emptyNavigateManager = NavigateManager(countableChoicesList, function (wrap) {
    return wrap.choice.itemPrev;
  }, function (wrap) {
    return wrap.choice.itemNext;
  });
  var filteredNavigateManager = NavigateManager(filteredChoicesList, function (wrap) {
    return wrap.choice.filteredPrev;
  }, function (wrap) {
    return wrap.choice.filteredNext;
  });
  var filterPredicateAspect = FilterPredicateAspect();
  var filterManagerAspect = FilterManagerAspect(emptyNavigateManager, filteredNavigateManager, filteredChoicesList, choicesEnumerableAspect, filterPredicateAspect);
  var hoveredChoiceAspect = HoveredChoiceAspect();
  var navigateAspect = NavigateAspect(hoveredChoiceAspect, function (down, hoveredChoice) {
    return filterManagerAspect.getNavigateManager().navigate(down, hoveredChoice);
  });
  var picksList = List();
  var wraps = Wraps(wrapsCollection, function () {
    return countableChoicesList.reset();
  }, function (w) {
    return countableChoicesList.remove(w);
  }, function (w, key) {
    return countableChoicesListInsertAspect.countableChoicesListInsert(w, key);
  });
  var aspects = {
    environment: environment,
    configuration: configuration,
    triggerAspect: triggerAspect,
    onChangeAspect: onChangeAspect,
    componentPropertiesAspect: componentPropertiesAspect,
    disposeAspect: disposeAspect,
    countableChoicesList: countableChoicesList,
    countableChoicesListInsertAspect: countableChoicesListInsertAspect,
    optionsAspect: optionsAspect,
    optionPropertiesAspect: optionPropertiesAspect,
    createWrapAspect: createWrapAspect,
    createChoiceBaseAspect: createChoiceBaseAspect,
    isChoiceSelectableAspect: isChoiceSelectableAspect,
    createElementAspect: createElementAspect,
    choicesDomFactory: choicesDomFactory,
    staticDomFactory: staticDomFactory,
    filterPredicateAspect: filterPredicateAspect,
    wrapsCollection: wrapsCollection,
    choicesEnumerableAspect: choicesEnumerableAspect,
    filteredChoicesList: filteredChoicesList,
    filterManagerAspect: filterManagerAspect,
    hoveredChoiceAspect: hoveredChoiceAspect,
    navigateAspect: navigateAspect,
    picksList: picksList,
    wraps: wraps,
    addPickAspect: addPickAspect,
    removePickAspect: removePickAspect
  };
  plugStaticDom(plugins, aspects); // apply cssPatch to css, apply selectElement support;  

  var _staticDomFactory$cre = staticDomFactory.create(css),
      choicesDom = _staticDomFactory$cre.choicesDom,
      createStaticDom = _staticDomFactory$cre.createStaticDom;

  var _createStaticDom = createStaticDom(element, containerClass),
      staticDom = _createStaticDom.staticDom,
      staticManager = _createStaticDom.staticManager; // after this we can use staticDom (means generated DOM elements) in plugin construtctor, what simplifies parameters passing a lot   
  // THINK: get filterDom, picksDom  from createStaticDom ?  But this would create excesive dublicate call in  selectElementPlugin


  var filterDom = FilterDom(staticDom.isDisposablePicksElement, createElementAspect, css);
  var picksDom = PicksDom(staticDom.picksElement, staticDom.isDisposablePicksElement, createElementAspect, css);
  var specialPicksEventsAspect = SpecialPicksEventsAspect();
  var choicesVisibilityAspect = ChoicesVisibilityAspect(choicesDom.choicesElement);
  var resetFilterListAspect = ResetFilterListAspect(filterDom, filterManagerAspect);
  var resetFilterAspect = ResetFilterAspect(filterDom, resetFilterListAspect);
  var focusInAspect = FocusInAspect(picksDom);
  var pickButtonAspect = PickButtonAspect(configuration.pickButtonHTML);
  var pickDomFactory = PickDomFactory(css, componentPropertiesAspect, optionPropertiesAspect, pickButtonAspect);
  var buildPickAspect = BuildPickAspect(picksDom, pickDomFactory);
  var producePickAspect = ProducePickAspect(picksList, removePickAspect, buildPickAspect);
  var createPickHandlersAspect = CreatePickHandlersAspect(producePickAspect);
  var optionToggleAspect = OptionToggleAspect(createPickHandlersAspect, addPickAspect);
  var fullMatchAspect = FullMatchAspect(createPickHandlersAspect, addPickAspect);
  var inputAspect = InputAspect(filterDom, filterManagerAspect, fullMatchAspect);
  var choiceClickAspect = ChoiceClickAspect(optionToggleAspect, filterDom);
  var choiceDomFactory = ChoiceDomFactory(css, optionPropertiesAspect, aspects.highlightAspect); // optional highlightAspect added by highlightPlugin

  var buildChoiceAspect = BuildChoiceAspect(choicesDom, choiceDomFactory, choiceClickAspect);
  var buildAndAttachChoiceAspect = BuildAndAttachChoiceAspect(buildChoiceAspect);
  var resetLayoutAspect = ResetLayoutAspect(function () {
    return resetFilterAspect.resetFilter();
  });
  var optionAttachAspect = OptionAttachAspect(createWrapAspect, createChoiceBaseAspect, buildAndAttachChoiceAspect, wraps);
  var optionsLoopAspect = OptionsLoopAspect(optionsAspect, optionAttachAspect);
  var updateDataAspect = UpdateDataAspect(choicesDom, wraps, picksList, optionsLoopAspect, resetLayoutAspect);
  var updateAspect = UpdateAspect(updateDataAspect);
  var loadAspect = LoadAspect(optionsLoopAspect);
  extendIfUndefined(aspects, (_extendIfUndefined = {
    staticDom: staticDom,
    picksDom: picksDom,
    choicesDom: choicesDom,
    filterDom: filterDom,
    resetLayoutAspect: resetLayoutAspect,
    pickDomFactory: pickDomFactory,
    choiceDomFactory: choiceDomFactory,
    choicesVisibilityAspect: choicesVisibilityAspect,
    staticManager: staticManager,
    buildChoiceAspect: buildChoiceAspect,
    optionToggleAspect: optionToggleAspect,
    choiceClickAspect: choiceClickAspect,
    buildAndAttachChoiceAspect: buildAndAttachChoiceAspect,
    optionsLoopAspect: optionsLoopAspect,
    optionAttachAspect: optionAttachAspect,
    buildPickAspect: buildPickAspect,
    producePickAspect: producePickAspect,
    createPickHandlersAspect: createPickHandlersAspect,
    inputAspect: inputAspect,
    resetFilterListAspect: resetFilterListAspect,
    resetFilterAspect: resetFilterAspect,
    specialPicksEventsAspect: specialPicksEventsAspect
  }, _extendIfUndefined["resetLayoutAspect"] = resetLayoutAspect, _extendIfUndefined.focusInAspect = focusInAspect, _extendIfUndefined.loadAspect = loadAspect, _extendIfUndefined.updateDataAspect = updateDataAspect, _extendIfUndefined.updateAspect = updateAspect, _extendIfUndefined.fullMatchAspect = fullMatchAspect, _extendIfUndefined));
  var pluginManager = PluginManager(plugins, aspects);
  var multiSelectInlineLayout = MultiSelectInlineLayout(aspects);
  var api = {
    component: "BsMultiSelect.api"
  }; // key to use in memory leak analyzes

  pluginManager.buildApi(api); // after this we can pass aspects methods call without wrapping - there should be no more overridings. TODO freeze aspects?

  api.dispose = composeSync(resetLayoutAspect.resetLayout, function () {
    disposeAspect.dispose();
  }, pluginManager.dispose, function () {
    picksList.forEach(function (pick) {
      return pick.dispose();
    });
  }, multiSelectInlineLayout.dispose, // TODO move to layout
  wraps.dispose, staticManager.dispose, picksDom.dispose, filterDom.dispose);

  api.updateData = function () {
    updateDataAspect.updateData();
  };

  api.update = function () {
    updateAspect.update();
  }; // TODO api.updateOption = (key) => {/* all updates: selected, disabled, hidden, text */}


  onInit == null ? void 0 : onInit(api, aspects);
  picksDom.pickFilterElement.appendChild(filterDom.filterInputElement);
  picksDom.picksElement.appendChild(picksDom.pickFilterElement);
  staticManager.appendToContainer();
  loadAspect.load();
  return api;
}

//# sourceMappingURL=BsMultiSelect.js.map