define(function(require) {
    'use strict';

    function Restore(model) {
        this.model = model;
    }

    Restore.defaultOption = {
        show: false,
        type: [],
        icon: 'M3.8,33.4 M47,18.9h9.8V8.7 M56.3,20.1 C52.1,9,40.5,0.6,26.8,2.1C12.6,3.7,1.6,16.2,2.1,30.6 M13,41.1H3.1v10.2 M3.7,39.9c4.2,11.1,15.8,19.5,29.5,18 c14.2-1.6,25.2-14.1,24.7-28.5',
        title: '还原'
    };

    var proto = Restore.prototype;

    proto.onclick = function (ecModel, api, type) {
        api.dispatchAction({
            type: 'restore',
            from: this.uid
        });
    };


    require('../featureManager').register('restore', Restore);


    require('../../../echarts').registerAction(
        {type: 'restore', event: 'restore', update: 'prepareAndUpdate'},
        function (payload, ecModel) {
            ecModel.resetOption('recreate');
        }
    );

    return Restore;
});