/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
'use strict';

var gulp = require('gulp');
var plugin = {
  concat: require('gulp-concat'),
};

gulp.task('default', ['deps-js', 'deps-css'], function() {
});

// concat all js files as one
gulp.task('deps-js', function() {
  return gulp.src([
      'node_modules/angular/angular.min.js', 
      'node_modules/angular-animate/angular-animate.min.js', 
      'node_modules/angular-cookies/angular-cookies.min.js', 
      'node_modules/angular-smart-table/dist/smart-table.min.js', 
      'node_modules/angular-strap/dist/angular-strap.min.js', 
      'node_modules/angular-strap/dist/angular-strap.tpl.min.js', 
      'node_modules/angular-ui-router/release/angular-ui-router.min.js', 
      'node_modules/moment/min/moment.min.js',
      'node_modules/underscore/underscore-min.js'])
    .pipe(plugin.concat('vendors.min.js'))
    .pipe(gulp.dest('vendors'));
});

// concat all css files as one
gulp.task('deps-css', ['deps-fonts'], function() {
  return gulp.src([
      'node_modules/angular-motion/dist/angular-motion.min.css', 
      'node_modules/bootstrap/dist/css/bootstrap.min.css'])
    .pipe(plugin.concat('vendors.min.css'))
    .pipe(gulp.dest('vendors'));
});

// copy fonts to styles
gulp.task('deps-fonts', function() {
  return gulp.src([
      'node_modules/bootstrap/dist/fonts/*.*'])
    .pipe(gulp.dest('styles/fonts'));
});
