/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */

angular.module('examples')

  .config(['$stateProvider',
    function($stateProvider) {
      'use strict';
      $stateProvider
        .state('barchart', {
          url: '/charts/bar',
          templateUrl: 'views/charts/bar.html',
          controller: 'BarChartExampleCtrl'
        });
    }])

  .controller('BarChartExampleCtrl', ['$scope', '$timeout', function($scope, $timeout) {
    var timeLabel = moment().format('HH:mm:ss');
    var maxChartDataPoints = 30;

    $scope.lineChartOption = {
      height: '168px',
      data: _.range(maxChartDataPoints).map(function() {
        return {x: timeLabel, y: [Math.random() * 1000 + 50, Math.random() * 1200 + 150]};
      }),
      maxDataNum: maxChartDataPoints,
      seriesNames: ['One', 'Two']
    };

    $scope.barChartOption = {
      height: '160px',
      color: 'red',
      data: _.range(maxChartDataPoints).map(function(i) {
        return {x: i, y: [Math.random() * 1000 + 50, Math.random() * 1200 + 150]};
      })
    };
    $timeout(function() {
      $scope.barChartData = _.range(maxChartDataPoints).map(function(i) {
        return {x: i, y: Math.random() * 12000 + 50};
      });
    }, 5000);

    $scope.ringChartOption = {
      height: '160px'
    };

    $scope.ringChartOption2 = {
      height: '160px',
      textPosition: 'right',
      title: 'Total Memory'
    };

    $scope.ringChartData = {
      used: {value: 30, label: 'Used', unit: 'GB'},
      available: {value: 70, label: 'Available'}
    };
    $timeout(function() {
      $scope.ringChartData = {
        used: {value: 20.6},
        available: {value: 50}
      };
    }, 5000);
  }])
;