/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */

angular.module('examples')

  .controller('LayoutCtrl', ['$scope', '$cookieStore',
    function($scope, $cookieStore) {
      'use strict';

      $scope.windowInnerWidth = function() {
        return window.innerWidth;
      };

      $scope.$watch($scope.windowInnerWidth, function(width) {
        var toggle = false;
        if (width >= 952) {
          toggle = $cookieStore.get('toggle');
          if (!angular.isDefined(toggle)) {
            toggle = true;
          }
        }
        $scope.toggle = toggle;
      });

      $scope.toggleSidebar = function() {
        $scope.toggle = !$scope.toggle;
        $cookieStore.put('toggle', $scope.toggle);
      };

      window.onresize = function() {
        $scope.$apply();
      };
    }])
;