/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.metrics', [])
/**
 * A card component to show metric value and its meaning.
 *
 * @example
 *  <metrics caption="CPU" value="99.5" unit="%"></metrics>
 *  <metrics caption="Disk Write Rate" value="500" unit="MB/s"
 *    sub-text="SSD hard disk"></metrics>
 */
  .directive('metrics', function() {
    'use strict';

    return {
      restrict: 'E',
      templateUrl: 'metrics/metrics.html',
      scope: {
        caption: '@',
        help: '@',
        value: '@',
        unit: '@',
        subText: '@'
      }
    };
  })
;