/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tables.sortable-table.searchctrl-sortable-table', [
  'dashing.tables.sortable-table' // smart-table
])
/**
 * A sortable table with a search controls.
 *
 * @example
 *  <searchctrl-sortable-table
 *    caption="Table caption"
 *    pagination="5"
 *    columns-bind="columnsVariable"
 *    records-bind="recordsVariable">
 *  </searchctrl-sortable-table>
 *
 *    @param caption string
 *      the caption of the table (optional)
 *    @param pagination int
 *      the number of records to be shown per page (optional)
 *    @param columns-bind array
 *      an array of column objects
 *    @param records-bind array
 *      an array of record objects
 */
  .directive('searchctrlSortableTable', function() {
    'use strict';

    return {
      restrict: 'E',
      templateUrl: 'tables/sortable-table/sortable-table.html',
      scope: {
        caption: '@',
        pagination: '@',
        columns: '=columnsBind',
        records: '=recordsBind'
      },
      link: function(scope) {
        scope.beforeTableTemplate = 'tables/sortable-table/searchctrl.html';
        scope.caption = '';
      }
    };
  })
;