/*
 * dashing (assembled widgets)
 * @version v0.1.6
 * @link https://github.com/stanleyxu2005/dashing
 * @license Apache License 2.0, see accompanying LICENSE file
 */
!function(t,e,r){"use strict";angular.module("dashing",["dashing.charts.echarts","dashing.charts.bar","dashing.charts.line","dashing.charts.metrics-sparkline","dashing.charts.ring","dashing.charts.sparkline","dashing.contextmenu","dashing.filters.duration","dashing.forms.searchbox","dashing.metrics","dashing.progressbar","dashing.property","dashing.property.bytes","dashing.remark","dashing.state.indicator","dashing.state.tag","dashing.tables.property-table","dashing.tables.property-table.builder","dashing.tables.sortable-table","dashing.tables.sortable-table.builder","dashing.tabset","dashing.util"]),angular.module("dashing").run(["$templateCache",function(t){t.put("charts/metrics-sparkline-td.html",'<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>'),t.put("forms/searchbox.html",'<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <span class="glyphicon glyphicon-search form-control-feedback"></span> </div>'),t.put("metrics/metrics.html",'<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="question" tooltip="{{help}}"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <small ng-bind="unit"></small> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>'),t.put("progressbar/progressbar.html",'<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>'),t.put("property/bytes.html",'<span ng-bind="raw|number:0"></span> <span ng-if="unit" ng-bind="unit"></span>'),t.put("property/property.html",'<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <bytes ng-switch-when="Bytes" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-readable="{{readable}}"></bytes>  <span ng-switch-when="Duration" ng-bind="value|duration"></span>  <span ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:MM:ss\'"></span>  <span ng-switch-when="Number" ng-bind="value|number:0"></span>  <span ng-switch-default ng-bind="value"></span> </ng-switch>'),t.put("remark/remark.html",'<span class="{{fontClass}} remark-icon" bs-tooltip="tooltip"></span>'),t.put("state/indicator.html",'<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle, \'cursor\': cursorStyle}" style="display: inline-block; height: 100%; width: 8px" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>'),t.put("state/tag.html",'<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>'),t.put("tables/property-table/property-table.html",'<table class="table table-striped table-hover"> <caption ng-if="caption" ng-bind="caption"></caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>'),t.put("tables/sortable-table/sortable-table-pagination.html",'<div class="pull-left"> <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs">  <button type="button" class="btn btn-default" ng-class="{disabled:1==currentPage}" ng-click="selectPage(currentPage-1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active:page==currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button type="button" class="btn btn-default" ng-class="{disabled:numPages==currentPage}" ng-click="selectPage(currentPage+1)"> &raquo;</button>  </div> </div>'),t.put("tables/sortable-table/sortable-table.html",'<table class="table table-striped table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption" ng-bind="caption"></caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody> <tr ng-repeat="record in showing track by $index"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="records !== null && !showing.length"> <td colspan="{{columns.length}}" class="text-center"> <i>No data found</i> </td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable-table/sortable-table-pagination.html"> </td> </tr> </tfoot> </table>'),t.put("tabset/tabset.html",'<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>')}]),angular.module("dashing.charts.bar",["dashing.charts.echarts"]).directive("barChart",function(){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){var e=t.$$childHead;t.$watch("data",function(t){e.addDataPoints(t)})},controller:["$scope","$element","$echarts",function(t,e,r){var n=angular.merge({barMinWidth:14,barMinSpacing:4,color:r.colorPalette(0)[0].line,yAxisValuesNum:3,yAxisLabelWidth:60},t.options),a=n.data,o=r.buildColorStates(n.color),i={height:n.height,width:n.width,ignoreContainerResizeEvent:!0,tooltip:r.tooltip({formatter:n.tooltipFormatter?n.tooltipFormatter:r.tooltipFirstSeriesFormatter(n.valueFormatter)}),grid:angular.merge({borderWidth:0,x:n.yAxisLabelWidth,y:15,x2:5,y2:28},n.grid),xAxis:[{axisLabel:{show:!0},axisLine:{show:!1},axisTick:{show:!1},splitLine:{show:!1},data:a.map(function(t){return t.x})}],yAxis:[{splitNumber:n.yAxisValuesNum,splitLine:{show:!1},axisLine:{show:!1},axisLabel:{formatter:n.yAxisLabelFormatter},scale:n.scale}],series:[r.makeDataSeries({colors:o,type:"bar",data:a.map(function(t){return Array.isArray(t.y)?t.y[0]:t.y})})],xAxisDataNum:n.maxDataNum},s=2*i.grid.borderWidth+i.grid.x+i.grid.x2,l=a.length*(n.barMinWidth+n.barMinSpacing)-n.barMinSpacing,c=e[0].offsetParent.offsetWidth;if(l>0&&l+s>c){var u=20,d=5;i.dataZoom={show:!0,barWidth:n.barMinWidth,barGap:n.barMinSpacing,barCategoryGap:n.barMinSpacing,end:Math.floor(100*(c-s)/l),zoomLock:!0,height:u,y:parseInt(n.height)-u-d,handleColor:o.line,dataBackgroundColor:o.area,fillerColor:zrender.tool.color.alpha(o.line,.2)},i.grid.y2+=u+2*d}t.echartOptions=i}]}}),angular.module("dashing.charts.echarts",[]).directive("echart",function(){function e(t,e){function r(t){return Array.isArray(t)?t:[t]}var n=[];return angular.forEach(r(e),function(e){var a=t-->0;angular.forEach(r(e.y),function(t,r){var o=[r,t,!1,a];0===r&&o.push(e.x),n.push(o)})}),n}function n(){return{markLine:{symbol:["circle","circle"]},title:{textStyle:{fontSize:14,fontWeight:"400",color:"#000"}},textStyle:{fontFamily:'lato,roboto,"helvetica neue","segoe ui",arial'},loadingText:"Data Loading...",noDataText:"No Graphic Data Found",addDataAnimation:!1}}return{restrict:"E",template:"<div></div>",replace:!0,scope:{options:"="},controller:["$scope","$element",function(a,o){var i=a.options,s=o[0];angular.forEach(["width","height"],function(t){i[t]&&(s.style[t]=i[t])});var l=echarts.init(s);i.ignoreContainerResizeEvent||(angular.element(t).on("resize",l.resize),a.$on("$destroy",function(){angular.element(t).off("resize",l.resize),l.dispose(),l=null})),l.setTheme(n()),l.setOption(i,!0),a.addDataPoints=function(t,n){try{var a=l.getOption(),o=a.xAxis[0].data.length,i=Math.min(80,Math.max(0,a.xAxisDataNum-o)),s=e(i,t);s.length>0&&(n!==r&&l.setOption({yAxis:[{max:n}]},!1),l.addData(s))}catch(c){}},a.setOptions=function(t){l.setOption(t)},i.dataPointsQueue&&a.addDataPoints(i.dataPointsQueue),i=null}]}}).factory("$echarts",["$filter",function(t){function e(t){var e=zrender.tool.color.lift(t,-.2);return'<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid '+e+"; background-color: "+t+'"></div>'}function r(e){return angular.isDate(e)?t("date")(e,"YYYY-MM-DD HH:mm:ss"):e}var n={tooltip:function(t){var e={trigger:t.trigger||"axis",textStyle:{fontSize:12},axisPointer:{type:"none"},borderRadius:2,showDelay:0,formatter:t.formatter,position:t.position||function(t){return[t[0],22]}};return t.color&&(e.axisPointer={type:"line",lineStyle:{color:t.color,width:3,type:"dotted"}}),e},tooltipFirstSeriesFormatter:function(t,e){return function(n){var a=(e?e:r)(n[0].name),o=t?t(n[0].value):n[0].value;return a+"<br/>"+o}},tooltipAllSeriesFormatter:function(t,n){return function(a){var o=(n?n:r)(a[0].name);return o+"<table>"+a.map(function(r){var n=r.series.colors.line,a=t?t(r.value):r.value;return"<tr><td>"+e(n)+'</td><td style="padding: 0 12px 0 4px">'+r.seriesName+"</td><td>"+a+"</td></tr>"}).join("")+"</table>"}},axisLabelFormatter:function(e){return function(r){if(0!==r){var n=1e3,a=["","K","M","G","T","P"],o=Math.floor(Math.log(r)/Math.log(n));r/=Math.pow(n,o),r=t("number")(r,Number(1===Math.floor(r))),r+=" "+a[o]+(e||"")}return r}},makeDataSeries:function(t){t.type=t.type||"line";var e=t.stack?4:3,r={symbol:"circle",smooth:t.smooth||!0,itemStyle:{normal:{color:t.colors.line,lineStyle:{color:t.colors.line,width:e}},emphasis:{color:t.colors.hover,lineStyle:{color:t.colors.line,width:e}}}};return t.stack?r.itemStyle.normal.areaStyle={type:"default",color:t.colors.area}:t.showAllSymbol&&(r.itemStyle.normal.lineStyle.width-=1),angular.merge(t,r)},splitInitialData:function(t,e){return t&&Array.isArray(t)||(console.warn("Chart need at least 1 data point to initialize the axises."),t=[]),t.length<=e?{older:t,newer:[]}:{older:t.slice(0,e),newer:t.slice(e)}},colorPalette:function(t){function e(t){var e={blue:"rgb(0,119,215)",purple:"rgb(110,119,215)",green:"rgb(41,189,181)",darkRed:"rgb(212,102,138)",orange:"rgb(255,127,80)"};switch(t){case 1:return[e.blue];case 2:return[e.blue,e.green];default:return Object.keys(e).map(function(t){return e[t]})}}return e(t).map(function(t){return n.buildColorStates(t)})},buildColorStates:function(t){return{line:t,area:zrender.tool.color.lift(t,-.92),hover:zrender.tool.color.lift(t,.1)}}};return n}]),angular.module("dashing.charts.line",["dashing.charts.echarts"]).directive("lineChart",function(){return{restrict:"E",template:'<echart options="::echartOptions" data="data"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){var e=t.$$childHead;t.$watch("data",function(t){e.addDataPoints(t)})},controller:["$scope","$echarts",function(t,e){var r=angular.merge({stacked:!0,showLegend:!0,yAxisValuesNum:3,yAxisLabelWidth:60,yAxisSplitLine:!0},t.options),n=e.splitInitialData(r.data||t.data,r.maxDataNum);r.seriesNames||(console.warn("seriesName not defined"),r.seriesNames=n.older[0].y.map(function(t,e){return"Series "+(e+1)}));var a=e.colorPalette(r.seriesNames.length),o={lineStyle:{width:1,color:"#ddd"}},i={height:r.height,width:r.width,tooltip:e.tooltip({color:"rgb(235,235,235)",formatter:r.tooltipFormatter?r.tooltipFormatter:e.tooltipAllSeriesFormatter(r.valueFormatter)}),dataZoom:{show:!1},grid:angular.merge({borderWidth:0,x:r.yAxisLabelWidth,y:20,x2:5,y2:23},r.grid),xAxis:[{boundaryGap:!1,axisLine:o,axisTick:o,axisLabel:{show:!0},splitLine:!1,data:n.older.map(function(t){return t.x})}],yAxis:[{splitNumber:r.yAxisValuesNum,splitLine:{show:r.yAxisSplitLine},axisLine:{show:!1},axisLabel:{formatter:r.yAxisLabelFormatter},scale:r.scale}],series:[],color:r.seriesNames.map(function(t,e){return a[e%a.length].line}),xAxisDataNum:r.maxDataNum,dataPointsQueue:n.newer};angular.forEach(r.seriesNames,function(t,o){i.series.push(e.makeDataSeries({name:t,colors:a[o%a.length],stack:r.stacked,showAllSymbol:r.showAllSymbol,data:n.older.map(function(t){return Array.isArray(t.y)?t.y[o]:t.y})}))}),1===i.series.length&&(i.yAxis.boundaryGap=[0,.15]);var s=20,l=16;r.title&&(i.title={text:r.title,x:0,y:3},i.grid.y+=s);var c=i.series.length>1&&r.showLegend;c&&(i.legend={show:!0,itemWidth:8,data:[]},angular.forEach(i.series,function(t){i.legend.data.push(t.name)}),i.legend.y=6,r.title&&(i.legend.y+=s,i.grid.y+=l)),(c||r.title)&&(i.grid.y+=12),t.echartOptions=i}]}}),angular.module("dashing.charts.metrics-sparkline",["dashing.charts.sparkline","dashing.metrics"]).directive("metricsSparklineChartTd",function(){return{restrict:"E",templateUrl:"charts/metrics-sparkline-td.html",scope:{caption:"@",help:"@",current:"@",unit:"@",subText:"@",options:"=optionsBind",data:"=datasourceBind"}}}),angular.module("dashing.charts.ring",["dashing.charts.echarts"]).directive("ringChart",function(){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){var e=t.$$childHead;t.$watch("data",function(t){e.setOptions({series:[{data:[{value:t.available.value},{value:t.used.value}]}]})})},controller:["$scope","$echarts",function(t,e){var r=angular.merge({color:"rgb(35,183,229)",textPosition:"inner"},t.options),n=r.data||t.data;n||console.warn("Need data to render the ring pie chart");var a=e.buildColorStates(r.color),o=8,i=(parseInt(r.height)-30-2*o)/2,s={normal:{color:"rgb(232,239,240)",label:{show:"inner"===r.textPosition,position:"center"},labelLine:{show:!1}}},l={height:r.height,width:r.width,grid:{borderWidth:0},xAxis:[{show:!1,data:[0]}],legend:{selectedMode:!1,itemGap:20,itemWidth:13,y:"bottom",data:[n.used.label,n.available.label].map(function(t){return{name:t,textStyle:{fontWeight:500},icon:"a"}})},series:[{type:"pie",center:["50%",i+o],radius:[Math.floor(.74*i),i],data:[{name:n.available.label,value:n.available.value,itemStyle:s},{name:n.used.label,value:n.used.value,itemStyle:angular.merge({},s,{normal:{color:a.line}})}]}]};switch(r.textPosition){case"inner":l.series[0].itemStyle={normal:{label:{formatter:function(){return Math.round(100*t.data.used.value/(t.data.used.value+t.data.available.value))+"%"},textStyle:{color:"#111",fontSize:28,fontWeight:500,baseline:"middle"}}}};break;case"right":r.title&&(l.series[0].center[0]=i+o,l.legend.x=o,l.title={text:t.data.used.value+(t.data.used.unit||""),subtext:r.title,itemGap:11,x:2*(i+o)+o,y:i+o-40,textStyle:{fontSize:40,fontWeight:500},subtextStyle:{fontSize:14}})}t.echartOptions=l}]}}),angular.module("dashing.charts.sparkline",["dashing.charts.echarts"]).directive("sparklineChart",function(){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){var e=t.$$childHead;t.$watch("data",function(t){e.addDataPoints(t)})},controller:["$scope","$echarts",function(t,e){var r=t.options,n=e.splitInitialData(r.data||t.data,r.maxDataNum),a=e.colorPalette(1)[0];t.echartOptions={height:r.height,width:r.width,tooltip:e.tooltip({formatter:r.tooltipFormatter?r.tooltipFormatter:e.tooltipFirstSeriesFormatter(r.valueFormatter)}),dataZoom:{show:!1},grid:angular.merge({borderWidth:1,x:5,y:5,x2:5,y2:1},r.grid),xAxis:[{boundaryGap:!1,axisLabel:!1,splitLine:!1,data:n.older.map(function(t){return t.x})}],yAxis:[{boundaryGap:[0,.15],show:!1,scale:r.scale}],series:[e.makeDataSeries({colors:a,stack:!0,data:n.older.map(function(t){return Array.isArray(t.y)?t.y[0]:t.y})})],xAxisDataNum:r.maxDataNum,dataPointsQueue:n.newer}}]}}),angular.module("dashing.contextmenu",["mgcrea.ngStrap.dropdown"]).factory("$contextmenu",function(){return{popup:function(t,e){var r=angular.element(t);r.css({left:e.x+"px",top:e.y+"px"}),r.triggerHandler("click")}}}),angular.module("dashing.filters.duration",[]).filter("duration",function(){return function(t,e){var r=parseInt(t,10);if(isNaN(r))return t;for(var n=[{label:" ms",mod:1e3},{label:e?"s":" secs",mod:60},{label:e?"m":" mins",mod:60},{label:e?"h":" hours",mod:24},{label:e?"d":" days",mod:7},{label:e?"w":" weeks",mod:52}],a=[],o=0;o<n.length;o++){var i=n[o],s=r%i.mod;0!==s&&a.unshift({label:i.label,value:s}),r=(r-s)/i.mod}return a=a.slice(0,2),a.length>1&&" ms"===a[1].label&&(a=[a[0]]),a.map(function(t){return t.value+t.label}).join(e?" ":" and ")}}),angular.module("dashing.forms.searchbox",[]).directive("searchbox",function(){return{restrict:"E",templateUrl:"forms/searchbox.html",scope:{placeholder:"@",ngModel:"="}}}),angular.module("dashing.metrics",[]).directive("metrics",function(){return{restrict:"E",templateUrl:"metrics/metrics.html",scope:{caption:"@",help:"@",value:"@",unit:"@",subText:"@"}}}),angular.module("dashing.progressbar",[]).directive("progressbar",function(){return{restrict:"E",templateUrl:"progressbar/progressbar.html",scope:{current:"@",max:"@",colorMapperFn:"="},link:function(t,e,r){function n(e,r){t.usage=r>0?Math.round(100*e/r):-1,t.usageClass=(t.colorMapperFn?t.colorMapperFn:a)(t.usage)}function a(t){return"progress-bar-"+(50>t?"info":75>t?"warning":"danger")}r.$observe("current",function(t){n(Number(t),Number(r.max))}),r.$observe("max",function(t){n(Number(r.current),Number(t))})}}}),angular.module("dashing.property.bytes",[]).directive("bytes",function(){return{restrict:"E",templateUrl:"property/bytes.html",scope:{raw:"@"},link:function(t,e,r){r.$observe("raw",function(e){if(-1!==["true","1"].indexOf(r.readable)){var n=Number(e),a=["","K","M","G","T","P"],o=Math.floor(Math.log(n)/Math.log(1024));t.raw=Math.floor(n/Math.pow(1024,o)),t.unit=a[o]+r.unit}else t.unit=r.unit})}}}),angular.module("dashing.property",["mgcrea.ngStrap.tooltip"]).directive("property",function(){return{restrict:"E",templateUrl:"property/property.html",replace:!1,scope:{value:"=valueBind",renderer:"@"},controller:["$scope",function(t){t.$watch("value",function(e){if(e){switch(t.renderer){case"Link":e.href||(t.href=e.text);break;case"Button":e.href&&!e.click&&(t.click=function(){location.href=e.href});break;case"Bytes":if(!e.hasOwnProperty("raw"))return void(t.raw=e)}angular.isObject(e)&&(e.hasOwnProperty("value")&&(console.warn({message:"Property should not have value.value",object:e}),delete e.value),angular.merge(t,e))}})}]}}).constant("PROPERTY_RENDERER",{BUTTON:"Button",BYTES:"Bytes",DATETIME:"DateTime",DURATION:"Duration",INDICATOR:"Indicator",LINK:"Link",NUMBER:"Number",PROGRESS_BAR:"ProgressBar",TAG:"Tag",TEXT:r}),angular.module("dashing.remark",["mgcrea.ngStrap.tooltip"]).directive("remark",function(){return{restrict:"E",templateUrl:"remark/remark.html",scope:{tooltip:"@"},link:function(t,e,r){switch(r.type){case"info":t.fontClass="glyphicon glyphicon-info-sign";break;case"warning":t.fontClass="glyphicon glyphicon-exclamation-sign";break;default:t.fontClass="glyphicon glyphicon-question-sign"}}}}),angular.module("dashing.state.indicator",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("indicator",["$util",function(t){return{restrict:"E",templateUrl:"state/indicator.html",scope:{tooltip:"@",shape:"@"},link:function(e,r,n){n.condition||(n.condition=""),n.$observe("condition",function(r){e.colorStyle=t.conditionToColor(r)}),n.$observe("tooltip",function(t){e.cursorStyle=t?"pointer":"default"})}}}]),angular.module("dashing.state.tag",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("tag",["$util",function(t){return{restrict:"E",templateUrl:"state/tag.html",scope:{href:"@",text:"@",tooltip:"@"},link:function(e,r,n){n.condition||(n.condition=""),n.$observe("condition",function(r){e.labelColorClass=t.conditionToBootstrapLabelClass(r)}),n.$observe("tooltip",function(t){e.href||(e.cursorStyle=t?"pointer":"default")})}}}]),angular.module("dashing.tables.property-table.builder",[]).factory("$propertyTableBuilder",["PROPERTY_RENDERER",function(t){var e=function(t,e){this.props=t?{renderer:t}:{},e&&this.title(e)};return e.prototype.title=function(t){return this.props.name=t,this},e.prototype.help=function(t){return this.props.help=t,this},e.prototype.value=function(t){return this.props.value=t,this},e.prototype.values=function(t){return Array.isArray(t)||(console.warn("values must be an array"),t=[t]),this.props.values=t,this},e.prototype.done=function(){return this.props},{button:function(r){return new e(t.BUTTON,r)},bytes:function(r){return new e(t.BYTES,r)},datetime:function(r){return new e(t.DATETIME,r)},duration:function(r){return new e(t.DURATION,r)},indicator:function(r){return new e(t.INDICATOR,r)},link:function(r){return new e(t.LINK,r)},number:function(r){return new e(t.NUMBER,r)},progressbar:function(r){return new e(t.PROGRESS_BAR,r)},tag:function(r){return new e(t.TAG,r)},text:function(r){return new e(t.TEXT,r)},$update:function(t,e){angular.forEach(e,function(e,r){t[r][Array.isArray(e)?"values":"value"]=e})}}}]),angular.module("dashing.tables.property-table",[]).directive("propertyTable",function(){return{restrict:"E",templateUrl:"tables/property-table/property-table.html",scope:{caption:"@",props:"=propsBind",propNameClass:"@",propValueClass:"@"}}}),angular.module("dashing.tables.sortable-table.builder",["dashing.property"]).factory("$sortableTableBuilder",["PROPERTY_RENDERER",function(t){var e=function(t,e){this.props=t?{renderer:t}:{},e&&this.title(e)};return e.prototype.title=function(t){return this.props.name=t,this},e.prototype.key=function(t){return this.props.key=t,this},e.prototype.canSort=function(e){if(!e&&!this.props.key)return void console.warn("Specify a sort key or define column key first!");if(this.props.sortKey=e||this.props.key,this.props.sortKey===this.props.key)switch(this.props.renderer){case t.LINK:this.props.sortKey+=".text";break;case t.INDICATOR:case t.TAG:this.props.sortKey+=".condition";break;case t.PROGRESS_BAR:this.props.sortKey+=".usage";break;case t.BYTES:this.props.sortKey+=".raw";break;case t.BUTTON:return void console.warn('"%s" column is not sortable.')}return this},e.prototype.sortDefault=function(t){return this.props.sortKey?(this.props.defaultSort=t?"reverse":!0,this):void console.warn("Specify a sort key or define column key first!")},e.prototype.sortDefaultDescent=function(){return this.sortDefault(!1)},e.prototype.styleClass=function(t){return this.props.styleClass=t,this},e.prototype.sortBy=function(t){return this.props.sortKey=t,this},e.prototype.unit=function(t){return this.props.unit=t,this},e.prototype.help=function(t){return this.props.help=t,this},e.prototype.done=function(){return this.props},{button:function(r){return new e(t.BUTTON,r)},bytes:function(r){return new e(t.BYTES,r)},datetime:function(r){return new e(t.DATETIME,r)},duration:function(r){return new e(t.DURATION,r)},indicator:function(r){return new e(t.INDICATOR,r)},link:function(r){return new e(t.LINK,r)},multiple:function(t,r){return new e(r,t)},number:function(r){return new e(t.NUMBER,r)},progressbar:function(r){return new e(t.PROGRESS_BAR,r)},tag:function(r){return new e(t.TAG,r)},text:function(r){return new e(t.TEXT,r)},$check:function(t,e){angular.forEach(t,function(t){var r=Array.isArray(t.key)?t.key:[t.key];angular.forEach(r,function(r){e.hasOwnProperty(r)||console.warn("Model does not have a property matches column key `"+t+"`")})})}}}]),angular.module("dashing.tables.sortable-table",["smart-table"]).directive("sortableTable",function(){return{restrict:"E",templateUrl:"tables/sortable-table/sortable-table.html",scope:{caption:"@",pagination:"@",columns:"=columnsBind",records:"=recordsBind",search:"=searchBind"},link:function(t,e){var n=e.find("input")[0];t.$watch("search",function(t){n.value=t||"",angular.element(n).triggerHandler("input")}),t.$watch("columns",function(e){return Array.isArray(e)?(t.columnStyleClass=e.map(function(t){function e(t,e,r){r&&t.push(e)}var n=[];return e(n,t.styleClass,t.styleClass!==r),e(n,"text-right","Number"===t.renderer),e(n,"text-nowrap",Array.isArray(t.key)&&!t.vertical),n.join(" ")}),void(t.multipleRendererColumnsRenderers=e.map(function(t){return Array.isArray(t.key)?Array.isArray(t.renderer)?(t.renderer.length!==t.key.length&&console.error("Every column key should have a renderer, or share one renderer."),t.renderer):t.key.map(function(){return t.renderer}):null}))):void console.warn("Failed to create table, until columns are defined.")}),t.isArray=Array.isArray}}}).directive("stSummary",function(){return{require:"^stTable",template:"Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records",link:function(t,e,r,n){t.stRange={from:null,to:null},t.$watch("currentPage",function(){var e=n.tableState().pagination;t.stRange.from=e.start+1,t.stRange.to=t.currentPage===e.numberOfPages?e.totalItemCount:t.stRange.from+t.stItemsByPage-1})}}}).config(["stConfig",function(t){t.sort.skipNatural=!0}]),angular.module("dashing.tabset",[]).directive("tabset",[function(){return{restrict:"E",templateUrl:"tabset/tabset.html",transclude:!0,scope:!0,controller:["$scope",function(t){function e(t,e){angular.forEach(n,function(e){e.selected=e===t}),t.load!==r&&t.load(e)}var n=t.tabs=[];this.addTab=function(t){n.push(t),1===n.length&&e(t)},t.selectTab=function(t,r){t>=0&&t<n.length&&e(n[t],r)}}]}}]).directive("tab",["$http","$controller","$compile",function(t,e,r){return{restrict:"E",require:"^tabset",template:'<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',replace:!0,transclude:!0,link:function(n,a,o,i){function s(t){a.html(t);var i=n.$new(!1);if(o.controller){var s=e(o.controller,{$scope:i});a.children().data("$ngController",s)}r(a.contents())(i),n.loaded=!0}n.heading=o.heading,n.loaded=!1,n.load=function(e){(!n.loaded||e)&&o.template&&t.get(o.template).then(function(t){s(t.data)})},i.addTab(n)}}}]),angular.module("dashing.util",[]).factory("$util",function(){return{conditionToBootstrapLabelClass:function(t){switch(t){case"good":return"label-success";case"concern":return"label-warning";case"danger":return"label-danger";default:return"label-default"}},conditionToColor:function(t){switch(t){case"good":return"#5cb85c";case"concern":return"#f0ad4e";case"danger":return"#d9534f";default:return"#aaa"}}}})}(window,document);
//# sourceMappingURL=dashing.min.js.map