/*
 * dashing (assembled widgets)
 * @version v0.2.4
 * @link https://github.com/stanleyxu2005/dashing
 * @license Apache License 2.0, see accompanying LICENSE file
 */
(function(window, document, undefined) {
'use strict';
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
/* Module register */
angular.module('dashing', [
  // directives
  'dashing.charts.bar',
  'dashing.charts.line',
  'dashing.charts.metrics-sparkline',
  'dashing.charts.ring',
  'dashing.charts.sparkline',
  'dashing.forms.searchbox',
  'dashing.metrics',
  'dashing.progressbar',
  'dashing.property',
  'dashing.property.bytes',
  'dashing.remark',
  'dashing.state.indicator',
  'dashing.state.tag',
  'dashing.tables.property-table',
  'dashing.tables.sortable-table',
  'dashing.tabset',
  // helpers
  'dashing.contextmenu',
  'dashing.tables.property-table.builder',
  'dashing.tables.sortable-table.builder',
  // filters
  'dashing.filters.duration'
]);
angular.module('dashing').run(['$templateCache', function($templateCache) {$templateCache.put('charts/metrics-sparkline-td.html','<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>');
$templateCache.put('forms/searchbox.html','<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <span class="glyphicon glyphicon-search form-control-feedback"></span> </div>');
$templateCache.put('metrics/metrics.html','<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="question" tooltip="{{help}}"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <small ng-bind="unit"></small> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>');
$templateCache.put('progressbar/progressbar.html','<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>');
$templateCache.put('property/bytes.html','<div> <span ng-bind="value|number:0"></span> <span ng-if="unit" ng-bind="unit"></span> </div>');
$templateCache.put('property/property.html','<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <bytes ng-switch-when="Bytes" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-readable="{{readable}}"></bytes>  <div ng-switch-when="Duration" ng-bind="value|duration"></div>  <div ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:mm:ss\'"></div>  <div ng-switch-when="Number" ng-bind="value|number:0"></div>  <div ng-switch-default ng-bind="value"></div> </ng-switch>');
$templateCache.put('remark/remark.html','<span class="{{fontClass}} remark-icon" bs-tooltip="tooltip"></span>');
$templateCache.put('state/indicator.html','<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle, \'cursor\': cursorStyle}" style="display: inline-block; height: 100%; width: 8px" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>');
$templateCache.put('state/tag.html','<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>');
$templateCache.put('tables/property-table/property-table.html','<table class="table table-striped table-hover"> <caption ng-if="caption" ng-bind="caption"></caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>');
$templateCache.put('tables/sortable-table/sortable-table-pagination.html','<div class="pull-left"> <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs">  <button type="button" class="btn btn-default" ng-class="{disabled:1==currentPage}" ng-click="selectPage(currentPage-1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active:page==currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button type="button" class="btn btn-default" ng-class="{disabled:numPages==currentPage}" ng-click="selectPage(currentPage+1)"> &raquo;</button>  </div> </div>');
$templateCache.put('tables/sortable-table/sortable-table.html','<table class="table table-striped table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption" ng-bind="caption"></caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody> <tr ng-repeat="record in showing track by $index"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="records !== null && !showing.length"> <td colspan="{{columns.length}}" class="text-center"> <i>No data found</i> </td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable-table/sortable-table-pagination.html"> </td> </tr> </tfoot> </table>');
$templateCache.put('tabset/tabset.html','<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>');}]);
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.bar', [
  'dashing.charts.echarts'
])
/**
 * Bar chart control.
 *
 * The width of the chart will be calculated by the number bars. If its too narrow to show all bars,
 * the chart will have a data zoom control to scroll the value bars.
 *
 * todo: support multiple series (stacked and not stacked)
 *
 * @example
 *   <bar-chart
 *     options-bind="::chartOptions"
 *     datasource-bind="chartData">
 *   </bar-chart>
 *
 * @param options-bind - the option object, which the following elements:
 * {
 *   height: string // the css height of the chart
 *   width: string // the css width of the chart
 *   data: // an array of initial data points
 *
 *   colors: array|string // optional to override bar colors
 *   static: boolean // update existing data points instead of adding new data points (default: true)
 *   rotate: boolean // rotate the bar control (default: false)
 *   yAxisSplitNum: number // the number of split ticks to be shown on y-axis (default: 3)
 *   yAxisShowMinorAxisLine: boolean // show minor axis line (default: false)
 *   yAxisLabelWidth: number // the pixels for the y-axis labels (default: 3)
 *   yAxisLabelFormatter: function // optional to override the label formatter
 *   valueFormatter: function // optional to override the value formatter
 *   barMaxWidth: number // reduce chart width, if bar actual width will exceed the value (default: 16)
 *   barMaxSpacing: number // reduce chart width, if bar actual spacing will exceed the value (default: 4)
 *   barMinWidth: number // show data zoom control, if bar width is narrower than the value (default: 7)
 *   barMinSpacing: number // show data zoom control, if bar spacing is narrower than the value (default: 1)
 *   xAxisShowLabels: boolean // show x-axis labels (default: true)
 * }
 * @param datasource-bind - array of data objects
 *   every data object is {x: string, y: number}
 */
  .directive('barChart', ['$echarts', function($echarts) {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            echartScope.addDataPoints(data);
          }
        });
      },
      controller: ['$scope', '$element', function($scope, $element) {
        var use = angular.merge({
          yAxisSplitNum: 3,
          yAxisShowMinorAxisLine: false,
          yAxisLabelWidth: 60,
          yAxisLabelFormatter: $echarts.axisLabelFormatter(''),
          yBoundaryGap: [0.2, 0.2],
          static: true,
          rotate: false,
          xAxisShowLabels: true
        }, $scope.options);
        use = angular.merge({
          barMaxWidth: use.rotate ? 20 : 16,
          barMinWidth: use.rotate ? 8 : 7,
          barMaxSpacing: 4,
          barMinSpacing: 1
        }, use);
        var data = use.data;
        if (!Array.isArray(data)) {
          console.warn({message: 'Initial data is expected to be an array', data: data});
          data = data ? [data] : [];
        }
        $echarts.validateSeriesNames(use, data);
        if (!Array.isArray(use.colors) || !use.colors.length) {
          use.colors = $echarts.barChartColorRecommendation(
            use.seriesNames.length || 1);
        }
        var colors = use.colors.map(function(base) {
          return $echarts.buildColorStates(base);
        });
        var axisColor = colors.length > 1 ? '#999' : colors[0].line;
        var options = {
          height: use.height,
          width: use.width,
          tooltip: angular.merge(
            $echarts.categoryTooltip(use.valueFormatter), {
              axisPointer: {
                type: 'shadow',
                shadowStyle: {
                  color: 'rgba(225,225,225,0.3)'
                }
              }
            }),
          grid: angular.merge({
            borderWidth: 0,
            x: Math.max(5, use.yAxisLabelWidth), /* add 5px margin to avoid overlap a data point */
            x2: 15, /* increase the right margin, otherwise last label might be cropped */
            y: 15, y2: 28
          }, use.grid),
          xAxis: [{
            // dashing bar-chart does not support time as x-axis values
            axisLabel: {show: true},
            axisLine: {
              show: true,
              lineStyle: {
                width: 1,
                color: axisColor,
                type: 'dotted'
              }
            },
            axisTick: false,
            splitLine: false
          }],
          yAxis: [{
            type: 'value',
            // todo: optional to hide y-axis
            splitNumber: use.yAxisSplitNum,
            splitLine: {
              show: use.yAxisShowMinorAxisLine,
              lineStyle: {
                color: axisColor,
                type: 'dotted'
              }
            },
            axisLine: false,
            axisLabel: {formatter: use.yAxisLabelFormatter}
          }],
          series: use.seriesNames.map(function(name, i) {
            return $echarts.makeDataSeries({
              type: 'bar',
              name: name,
              stack: true,
              colors: colors[i]
              // No need to set widths and gaps, the chart control will calculate it automatically.
            });
          }),
          // override the default color colorPalette, otherwise the colors look messy.
          color: use.colors
        };
        if (use.static) {
          delete use.visibleDataPointsNum;
        }
        $echarts.fillAxisData(options, data, use);
        if (use.static) {
          // Tell chart control only update existing data points' value.
          options.visibleDataPointsNum = -1;
        }
        if (use.rotate) {
          var axisSwap = options.xAxis;
          options.xAxis = angular.copy(options.yAxis);
          options.xAxis[0].type = options.xAxis[0].type || 'value';
          options.yAxis = axisSwap;
          options.yAxis[0].type = options.yAxis[0].type || 'category';
        }
        if (!use.xAxisShowLabels) {
          options.xAxis[0].axisLabel = false;
          options.grid.y2 = options.grid.y;
        }
        if (use.static) {
          // todo: currently the calculation can only happen at initialization stage, the chart will not response on a resizing event.
          var drawBarMinWidth = use.barMinWidth + use.barMinSpacing;
          var drawBarMaxWidth = use.barMaxWidth + use.barMaxSpacing;
          var drawAllBarMinWidth = data.length * drawBarMinWidth;
          var drawAllBarMaxWidth = data.length * drawBarMaxWidth;
          var chartHeight = parseInt(use.height);
          if (use.rotate) {
            var gridMarginY = options.grid.borderWidth * 2 + options.grid.y + options.grid.y2;
            if (chartHeight < gridMarginY + drawAllBarMinWidth) {
              console.info('Increased the height to ' + (gridMarginY + drawAllBarMinWidth) + 'px, ' +
                'because rotated bar chart does not support data zoom yet.');
              options.height = (gridMarginY + drawAllBarMinWidth) + 'px';
            } else if (chartHeight > gridMarginY + drawAllBarMaxWidth) {
              options.height = (gridMarginY + drawAllBarMaxWidth) + 'px';
            }
          } else {
            var gridMarginX = options.grid.borderWidth * 2 + options.grid.x + options.grid.x2;
            var chartControlWidth = angular.element($element[0]).children()[0].offsetWidth;
            var visibleWidthForBars = chartControlWidth - gridMarginX;
            if (drawAllBarMinWidth > 0 && drawAllBarMinWidth > visibleWidthForBars) {
              // Add a scrollbar if bar widths exceeds the minimal width
              var roundedVisibleWidthForBars = Math.floor(visibleWidthForBars / drawBarMinWidth) * drawBarMinWidth;
              options.grid.x2 += visibleWidthForBars - roundedVisibleWidthForBars;
              var scrollbarHeight = 20;
              var scrollbarGridMargin = 5;
              options.dataZoom = {
                show: true,
                end: roundedVisibleWidthForBars * 100 / drawAllBarMinWidth,
                realtime: true,
                height: scrollbarHeight,
                y: chartHeight - scrollbarHeight - scrollbarGridMargin,
                handleColor: axisColor
              };
              options.dataZoom.fillerColor =
                zrender.tool.color.alpha(options.dataZoom.handleColor, 0.08);
              options.grid.y2 += scrollbarHeight + scrollbarGridMargin * 2;
            } else if (data.length) {
              if (visibleWidthForBars > drawAllBarMaxWidth) {
                // Too few bars to fill up the whole area, so increase the right/bottom margin
                options.grid.x2 += chartControlWidth - drawAllBarMaxWidth - gridMarginX;
              } else {
                options.grid.x2 += visibleWidthForBars -
                  Math.floor(visibleWidthForBars / data.length) * data.length;
              }
            }
          }
        }
        $scope.echartOptions = options;
      }]
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.echarts', [
  'dashing.util'
])
/**
 * Make DIV becoming an echart control.
 *
 * Recommend use `<echart options="::YourOptions"></echart>`, because the options will not accept new changes
 * anyway after the directive is stabilized.
 */
  .directive('echart', ['dashing.util', function(util) {
    function makeDataArray(data, seriesNum, dataPointsGrowNum, xAxisTypeIsTime) {
      var array = [];
      angular.forEach(util.array.ensureArray(data), function(datum) {
        var dataGrow = dataPointsGrowNum-- > 0;
        var yValues = util.array.ensureArray(datum.y).slice(0, seriesNum);
        if (xAxisTypeIsTime) {
          angular.forEach(yValues, function(yValue, seriesIndex) {
            var params = [seriesIndex, [datum.x, yValue], /*isHead=*/false, dataGrow];
            array.push(params);
          });
        } else {
          var lastSeriesIndex = yValues.length - 1;
          angular.forEach(yValues, function(yValue, seriesIndex) {
            var params = [seriesIndex, yValue, /*isHead=*/false, dataGrow];
            if (seriesIndex === lastSeriesIndex) {
              // x-axis label (for category type) must be added to the last series!
              params.push(datum.x);
            }
            array.push(params);
          });
        }
      });
      return array;
    }
    return {
      restrict: 'E',
      template: '<div></div>',
      replace: true /* tag will be replaced as div, otherwise echart cannot find a container to stay. */,
      scope: {
        options: '='
      },
      controller: ['$scope', '$element', 'dsEchartsDefaults', '$echarts',
        function($scope, $element, defaults, $echarts) {
          var options = $scope.options;
          var elem0 = $element[0];
          angular.forEach(['width', 'height'], function(prop) {
            if (options[prop]) {
              elem0.style[prop] = options[prop];
            }
          });
          var chart = echarts.init(elem0);
          angular.element(window).on('resize', chart.resize);
          $scope.$on('$destroy', function() {
            angular.element(window).off('resize', chart.resize);
          });
          // Must after `chart.resize` is removed
          $scope.$on('$destroy', function() {
            chart.dispose();
            chart = null;
          });
          chart.setTheme(defaults.lookAndFeel);
          chart.setOption(options, /*overwrite=*/true);
          // Automatically group charts with same group id
          if (angular.isFunction(chart.group) && options.hasOwnProperty('groupId')) {
            chart.groupId = options.groupId;
            chart.group();
          }
          // If no data is provided, the chart is not initialized. And you can see a caution on the canvas.
          var initialized = angular.isDefined(chart.getOption().xAxis);
          function initializeDoneCheck() {
            if (initialized) {
              // If data points are more than the maximal visible data points, we put them into a queue and then
              // add them to the chart after the option is applied, otherwise all data points will be shown on
              // the chart.
              if (options.dataPointsQueue && options.dataPointsQueue.length) {
                addDataPoints(options.dataPointsQueue);
                delete options.dataPointsQueue;
              }
              delete options.data;
            }
          }
          initializeDoneCheck();
          /** Method to add data points to chart */
          function addDataPoints(data, newYAxisMaxValue) {
            if (!data || (Array.isArray(data) && !data.length)) {
              return;
            }
            try {
              // try to re-initialize when data is available
              if (!initialized) {
                $echarts.fillAxisData(options, util.array.ensureArray(data));
                chart.setOption(options, /*overwrite=*/true);
                initialized = angular.isDefined(chart.getOption().xAxis);
                initializeDoneCheck();
                if (initialized) {
                  chart.hideLoading();
                }
                return;
              }
              var currentOption = chart.getOption();
              var actualVisibleDataPoints = currentOption.series[0].data.length;
              var dataPointsGrowNum = Math.max(0,
                (currentOption.visibleDataPointsNum || defaults.visibleDataPointsNum) - actualVisibleDataPoints);
              var xAxisTypeIsTime = (currentOption.xAxis[0].type === 'time') || // or rotated bar chart
                (currentOption.xAxis[0].type === 'value' && currentOption.yAxis[0].type === 'time');
              var seriesNum = currentOption.series.length;
              var dataArray = makeDataArray(data, seriesNum, dataPointsGrowNum, xAxisTypeIsTime);
              if (dataArray.length > 0) {
                if (newYAxisMaxValue !== undefined) {
                  chart.setOption({
                    yAxis: [{max: newYAxisMaxValue}]
                  }, /*overwrite=*/false);
                }
                chart.addData(dataArray);
              }
            } catch (ex) {
            }
          }
          /** Export these functions. */
          $scope.addDataPoints = addDataPoints;
          $scope.getChartControl = function() {
            return chart;
          };
        }]
    };
  }])
/**
 * Constants of chart
 */
  .constant('dsEchartsDefaults', {
    // Echarts look and feel recommendation
    lookAndFeel: {
      markLine: {
        symbol: ['circle', 'circle']
      },
      title: {
        textStyle: {
          fontSize: 14,
          fontWeight: 400,
          color: '#000'
        }
      },
      legend: {
        textStyle: {
          color: '#111',
          fontWeight: 500
        },
        itemGap: 20
      },
      tooltip: {
        borderRadius: 2,
        padding: 0, // don't add padding here, otherwise empty tooltip will be a black square
        showDelay: 0,
        transitionDuration: 0.5
      },
      textStyle: {
        fontFamily: 'lato,roboto,"helvetica neue","segoe ui",arial',
        fontSize: 12
      },
      loadingText: 'Data Loading...',
      noDataText: 'No Graphic Data Available',
      addDataAnimation: false
    },
    // The number of visible data points can be shown on chart
    visibleDataPointsNum: 80
  }
)
/**
 * Customize chart's look and feel.
 */
  .factory('$echarts', ['$filter', 'dashing.util', function($filter, util) {
    function buildTooltipSeriesTable(name, array, use) {
      function tooltipSeriesColorIndicatorHtml(color) {
        var border = zrender.tool.color.lift(color, -0.2);
        return '<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid ' + border + '; background-color: ' + color + '"></div>';
      }
      function mergeValuesAndSortDescent(array) {
        var grouped = {};
        angular.forEach(array, function(point) {
          grouped[point.name] = grouped[point.name] || [];
          grouped[point.name].push(point);
        });
        var result = [];
        angular.forEach(grouped, function(group) {
          var selected = group.reduce(function(p, c) {
            return Math.abs(p.value) > Math.abs(c.value) ? p : c;
          });
          selected.value = group.reduce(function(p, c) {
            return {value: p.value + c.value};
          }).value;
          result.push(selected);
        });
        return $filter('orderBy')(result, 'value', /*reversed=*/true);
      }
      var valueFormatter = use.valueFormatter || defaultValueFormatter;
      return '<div style="padding: 8px">' + [
          (use.nameFormatter || defaultNameFormatter)(name),
          '<table>' +
          mergeValuesAndSortDescent(array).map(function(point) {
            if (point.value === '-') {
              return '';
            } else {
              point.value = valueFormatter(point.value);
            }
            if (!point.name) {
              point.name = point.value;
              point.value = '';
            }
            return '<tr>' +
              '<td>' + tooltipSeriesColorIndicatorHtml(point.color) + '</td>' +
              '<td style="padding: 0 12px 0 4px">' + point.name + '</td>' +
              '<td style="text-align: right">' + point.value + '</td>' +
              '</tr>';
          }).join('') +
          '</table>'].join('') +
        '</div>';
    }
    function defaultNameFormatter(name) {
      if (angular.isDate(name)) {
        var now = new Date();
        return $filter('date')(name,
          (now.getYear() === name.getYear() &&
          now.getMonth() === name.getMonth() &&
          now.getDay() === name.getDay()) ?
            'HH:mm:ss' : 'yyyy-MM-dd HH:mm:ss');
      }
      return name;
    }
    function defaultValueFormatter(value) {
      return $filter('number')(value);
    }
    /**
     * Build the option object for tooltip
     */
    function tooltip(args) {
      return {
        trigger: args.trigger || 'axis',
        axisPointer: {type: 'none'},
        formatter: args.formatter
      };
    }
    /**
     * As we define the maximal visible data points, so we should split the data array
     * into two. The part `older` are old data points, that will be shown when the chart
     * is created. The part `newer` will be added afterwards by `addDataPoints()`.
     */
    function splitInitialData(data, visibleDataPoints) {
      if (!Array.isArray(data)) {
        data = [];
      }
      if (!visibleDataPoints || data.length <= visibleDataPoints) {
        return {older: data, newer: []};
      }
      return {
        older: data.slice(0, visibleDataPoints),
        newer: data.slice(visibleDataPoints)
      };
    }
    return {
      /**
       * Tooltip for category x-axis chart.
       */
      categoryTooltip: function(valueFormatter, nameFormatter) {
        return tooltip({
          trigger: 'axis',
          formatter: function(params) {
            params = util.array.ensureArray(params);
            var name = params[0].name;
            var array = params.map(function(param) {
              return {
                color: param.series.colors.line,
                name: param.seriesName,
                value: param.value
              };
            });
            // If no data at this moment, we should hint user instead of an empty tooltip.
            if (!name.length && !array.filter(function(point) {
                return point.value !== '-';
              }).length) {
              return '';
            }
            var args = {nameFormatter: nameFormatter, valueFormatter: valueFormatter};
            return buildTooltipSeriesTable(name, array, args);
          }
        });
      },
      /**
       * https://github.com/ecomfe/echarts/issues/1954
       */
      timelineChartFix: function(options, use) {
        console.warn('Echarts does not have a good experience for time series. ' +
          'We suggest to use category as x-axis type.');
        // Tooltip for timeline x-axis chart. Due to current limitation:
        // 1. trigger can only be 'item'. Use 'axis' would draw line in wrong direction!
        // 2. only the active data series will be shown in tooltip.
        options.tooltip = tooltip({
          trigger: 'item',
          formatter: function(params) {
            var array = [{
              color: params.series.colors.line,
              name: params.series.name,
              value: params.value[1]
            }];
            return buildTooltipSeriesTable(params.value[0], array, use);
          }
        });
        angular.forEach(options.xAxis, function(axis) {
          delete axis.boundaryGap;
        });
        angular.forEach(options.series, function(series) {
          series.showAllSymbol = true;
          series.stack = false;
        });
      },
      /**
       * Validate data series names. In case of problem, set default series names and warn user.
       */
      validateSeriesNames: function(use, data) {
        if (!use.seriesNames) {
          var first = util.array.ensureArray(data[0].y);
          if (first.length > 1) {
            console.warn({
              message: 'You should define `options.seriesNames`',
              options: use
            });
          }
          use.seriesNames = first.map(function(_, i) {
            return 'Series ' + (i + 1);
          });
        }
      },
      /**
       * Formatter to change axis label to human readable values.
       */
      axisLabelFormatter: function(unit) {
        return function(value) {
          if (angular.isNumber(value)) {
            value = Number(value); // echarts return 0.1 as "0.1"
            if (value !== 0) {
              var hr = util.text.toHumanReadableNumber(value, 1000, 1);
              value = hr.value + ' ' + hr.modifier + (unit || '');
            }
          }
          return value;
        };
      },
      /**
       * Build the option object for data series.
       */
      makeDataSeries: function(args) {
        var options = {
          type: args.type || 'line',
          symbol: 'circle',
          symbolSize: 4,
          smooth: args.smooth,
          itemStyle: {
            normal: {
              color: args.colors.line,
              lineStyle: {
                width: args.stack ? 4 : 3
              },
              borderColor: 'transparent',
              borderWidth: 6
            },
            emphasis: {
              color: args.colors.hover,
              borderColor: zrender.tool.color.alpha(args.colors.line, 0.3)
            }
          }
        };
        if (args.stack) {
          options.itemStyle.normal.areaStyle = {
            type: 'default',
            color: args.colors.area
          };
        } else if (args.showAllSymbol) {
          // bugfix: seems the line is 1px thicker than args.stack version!
          options.itemStyle.normal.lineStyle.width -= 1;
        }
        return angular.merge(args, options);
      },
      /**
       * Reset axises in option and fill with initial data (for line/bar/area charts)
       */
      fillAxisData: function(options, data, inputs) {
        if (angular.isObject(inputs)) {
          // #1: Set groupId when it is defined and valid
          if (angular.isString(inputs.groupId) && inputs.groupId.length) {
            options.groupId = inputs.groupId;
          }
          // #2: Set maximal visible data points
          if (inputs.visibleDataPointsNum > 0) {
            options.visibleDataPointsNum = inputs.visibleDataPointsNum;
            var placeholder = {
              x: '',
              y: Array(options.series.length).fill({value: '-', tooltip: {}})
            };
            while (data.length < inputs.visibleDataPointsNum) {
              data.unshift(placeholder);
            }
          }
        }
        var dataSplit = splitInitialData(data, options.visibleDataPointsNum);
        if (dataSplit.newer.length) {
          options.dataPointsQueue = dataSplit.newer;
        }
        delete options.xAxis[0].data;
        angular.forEach(options.series, function(series) {
          series.data = [];
        });
        if (options.xAxis[0].type === 'time') {
          angular.forEach(dataSplit.older, function(datum) {
            angular.forEach(options.series, function(series, seriesIndex) {
              series.data.push([datum.x, Array.isArray(datum.y) ? datum.y[seriesIndex] : datum.y]);
            });
          });
        } else {
          var xLabels = [];
          angular.forEach(dataSplit.older, function(datum) {
            xLabels.push(datum.x);
            angular.forEach(options.series, function(series, seriesIndex) {
              series.data.push(Array.isArray(datum.y) ? datum.y[seriesIndex] : datum.y);
            });
          });
          options.xAxis[0].data = xLabels;
        }
      },
      /**
       * Return a recommended color palette for line chart.
       */
      lineChartColorRecommendation: function(seriesNum) {
        var colors = util.color.palette;
        switch (seriesNum) {
          case 1:
            return [colors.blue];
          case 2:
            return [colors.blue, colors.blueishGreen];
          default:
            return util.array.repeatArray([
              colors.blue,
              colors.purple,
              colors.blueishGreen,
              colors.darkRed,
              colors.orange
            ], seriesNum);
        }
      },
      /**
       * Return a recommended color palette for bar chart.
       */
      barChartColorRecommendation: function(seriesNum) {
        var colors = util.color.palette;
        switch (seriesNum) {
          case 1:
            return [colors.orange];
          case 2:
            return [colors.blue, colors.darkBlue];
          default:
            return util.array.repeatArray([
              colors.lightGreen,
              colors.darkGray,
              colors.lightBlue,
              colors.blue,
              colors.darkBlue
            ], seriesNum);
        }
      },
      /**
       * Build colors for state set.
       */
      buildColorStates: function(base) {
        return {
          line: base,
          area: zrender.tool.color.lift(base, -0.92),
          hover: zrender.tool.color.lift(base, 0.15)
        };
      }
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.line', [
  'dashing.charts.echarts'
])
/**
 * Line chart control.
 *
 * @example
 *   <line-chart
 *     options-bind="::chartOptions"
 *     datasource-bind="chartData">
 *   </line-chart>
 *
 * @param options-bind - the option object, which the following elements:
 * {
 *   height: string // the css height of the chart
 *   width: string // the css width of the chart
 *   seriesNames: [string] // name of data series in an array (the text will be shown in legend and tooltip as well)
 *   data: // an array of initial data points
 *
 *   colors: array|string // optional to override line colors
 *   visibleDataPointsNum: number // the maximal number of data points in the chart (default: unlimited)
 *   showLegend: boolean // show legend even when multiple data series on chart (default: true)
 *   yAxisSplitNum: number // the number of split ticks to be shown on y-axis (default: 3)
 *   yAxisShowSplitLine: boolean // show split lines on y-axis (default: true)
 *   yAxisLabelWidth: number // the pixels for the y-axis labels (default: 3)
 *   yAxisLabelFormatter: function // optional to override the label formatter
 *   valueFormatter: function // function to override the representation of y-axis value
 *   xAxisTypeIsTime: boolean // use timeline as x-axis (currently disabled)
 *   seriesStacked: boolean // should stack all data series (default: true)
 *   seriesLineSmooth: boolean // draw line of series smooth (default: false)
 *   xAxisShowLabels: boolean // show x-axis labels (default: true)
 * }
 * @param datasource-bind - array of data objects
 *   every data object is {x: time|string, y: [number]}
 */
  .directive('lineChart', function() {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions" data="data"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            echartScope.addDataPoints(data);
          }
        });
      },
      controller: ['$scope', '$echarts', function($scope, $echarts) {
        var use = angular.merge({
          seriesStacked: true,
          seriesLineSmooth: false,
          showLegend: true,
          yAxisSplitNum: 3,
          yAxisShowSplitLine: true,
          yAxisLabelWidth: 60,
          yAxisLabelFormatter: $echarts.axisLabelFormatter(''),
          xAxisShowLabels: true
        }, $scope.options);
        var data = use.data;
        $echarts.validateSeriesNames(use, data);
        if (!Array.isArray(use.colors) || !use.colors.length) {
          use.colors = $echarts.lineChartColorRecommendation(
            use.seriesNames.length || 1);
        }
        var colors = use.colors.map(function(base) {
          return $echarts.buildColorStates(base);
        });
        var axisColor = '#999';
        var borderLineStyle = {
          length: 4,
          lineStyle: {
            width: 1,
            color: axisColor
          }
        };
        var options = {
          height: use.height,
          width: use.width,
          tooltip: angular.merge(
            $echarts.categoryTooltip(use.valueFormatter), {
              axisPointer: {
                type: 'line',
                lineStyle: {
                  width: 3,
                  color: 'rgb(235,235,235)',
                  type: 'dotted'
                }
              }
            }),
          grid: angular.merge({
            borderWidth: 0,
            x: Math.max(5, use.yAxisLabelWidth), /* add 5px margin to avoid overlap a data point */
            x2: 15, /* increase the right margin, otherwise last label might be cropped */
            y: 20, y2: 25
          }, use.grid),
          xAxis: [{
            type: use.xAxisTypeIsTime ? 'time' : undefined,
            boundaryGap: false,
            axisLine: borderLineStyle,
            axisTick: borderLineStyle,
            axisLabel: {show: true},
            splitLine: false
          }],
          yAxis: [{
            splitNumber: use.yAxisSplitNum,
            splitLine: {
              show: use.yAxisShowSplitLine,
              lineStyle: {
                color: axisColor,
                type: 'dotted'
              }
            },
            axisLine: false,
            axisLabel: {formatter: use.yAxisLabelFormatter}
          }],
          series: use.seriesNames.map(function(name, i) {
            return $echarts.makeDataSeries({
              name: name,
              colors: colors[i],
              stack: use.seriesStacked,
              smooth: use.seriesLineSmooth,
              showAllSymbol: use.showAllSymbol
            });
          }),
          // override the default color colorPalette, otherwise the colors look messy.
          color: use.colors
        };
        $echarts.fillAxisData(options, data, use);
        if (!use.xAxisShowLabels) {
          options.xAxis[0].axisLabel = false;
          options.grid.y2 = options.grid.y;
        }
        if (use.xAxisTypeIsTime) {
          // todo: https://github.com/ecomfe/echarts/issues/1954
          $echarts.timelineChartFix(options, use);
        }
        if (options.series.length === 1) {
          options.yAxis.boundaryGap = [0, 0.1];
        }
        // todo: external font size and style should fit global style automatically (e.g. use sass)
        var titleHeight = 20;
        var legendHeight = 16;
        // Add inline chart title
        if (use.title) {
          options.title = {
            text: use.title,
            x: 0,
            y: 3
          };
          options.grid.y += titleHeight;
        }
        // Add legend if there multiple data series
        var addLegend = options.series.length > 1 && use.showLegend;
        if (addLegend) {
          options.legend = {
            show: true,
            itemWidth: 8,
            data: options.series.map(function(series) {
              return series.name;
            })
          };
          options.legend.y = 6;
          if (use.title) {
            options.legend.y += titleHeight;
            options.grid.y += legendHeight;
          }
        }
        if (addLegend || use.title) {
          options.grid.y += 12;
        }
        $scope.echartOptions = options;
      }]
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.metrics-sparkline', [
  'dashing.charts.sparkline',
  'dashing.metrics'
])
/**
 * Sparkline control with current value information on top.
 *
 * @example
 *   <metrics-sparkline-chart-td
 *     caption="CPU usage" help="CPU usage in real time"
 *     value="50" unit="%"
 *     options-bind="sparkLineOptions" datasource-bind="sparkLineData">
 *   </metrics-sparkline-chart-td>
 */
  .directive('metricsSparklineChartTd', function() {
    return {
      restrict: 'E',
      templateUrl: 'charts/metrics-sparkline-td.html',
      scope: {
        caption: '@',
        help: '@',
        current: '@',
        unit: '@',
        subText: '@',
        options: '=optionsBind',
        data: '=datasourceBind'
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.ring', [
  'dashing.charts.echarts'
])
/**
 * Ring (pie) chart control.
 *
 * The width of the chart will be calculated by the number bars. If its too narrow to show all bars,
 * the chart will have a data zoom control to scroll the value bars.
 *
 * @example
 *   <ring-chart
 *     options-bind="::chartOptions"
 *     datasource-bind="chartData">
 *   </ring-chart>
 *
 * @param options-bind - the option object, which the following elements:
 * {
 *   height: string // the css height of the chart
 *   textPosition: 'inner'|'right' // either show current usage inside the ring or show total value at right (default: inner)
 *   color: string // optional to override ring color
 * }
 * @param datasource-bind - array of data objects
 *   every data object is {x: time|string, y: [number]}
 */
  .directive('ringChart', function() {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          var chartControl = echartScope.getChartControl();
          chartControl.setOption({
            series: [{
              data: [
                {value: data.available.value},
                {value: data.used.value}
              ]
            }]
          });
        });
      },
      controller: ['$scope', '$echarts', function($scope, $echarts) {
        var use = angular.merge({
          color: 'rgb(35,183,229)',
          textPosition: 'inner'
        }, $scope.options);
        var data = use.data || $scope.data;
        if (!data) {
          console.warn('Need data to render the ring pie chart.');
        }
        var colors = $echarts.buildColorStates(use.color);
        var padding = 8;
        var outerRadius = (parseInt(use.height) - 30 - padding * 2) / 2;
        var itemStyleBase = {
          normal: {
            color: 'rgb(232,239,240)',
            label: {show: use.textPosition === 'inner', position: 'center'},
            labelLine: false
          }
        };
        var options = {
          height: use.height,
          width: use.width,
          grid: {borderWidth: 0},
          xAxis: [{show: false, data: [0]}],
          legend: {
            selectedMode: false,
            itemGap: 20,
            itemWidth: 13,
            y: 'bottom',
            data: [data.used.label, data.available.label].map(function(label) {
              return {name: label, textStyle: {fontWeight: 500}, icon: 'a'};
            })
          },
          series: [{
            type: 'pie',
            center: ['50%', outerRadius + padding],
            radius: [Math.floor(outerRadius * 0.74), outerRadius],
            data: [{
              name: data.available.label,
              value: data.available.value,
              itemStyle: itemStyleBase
            }, {
              name: data.used.label,
              value: data.used.value,
              itemStyle: angular.merge({}, itemStyleBase, {
                normal: {color: colors.line}
              })
            }]
          }]
        };
        switch (use.textPosition) {
          case 'inner':
            options.series[0].itemStyle = {
              normal: {
                label: {
                  formatter: function() {
                    return Math.round($scope.data.used.value * 100 /
                        ($scope.data.used.value + $scope.data.available.value)) + '%';
                  },
                  textStyle: {
                    color: '#111',
                    fontSize: 28, // todo: auto-adjust font size?
                    fontWeight: 500,
                    baseline: 'middle'
                  }
                }
              }
            };
            break;
          case 'right':
            if (use.title) {
              options.series[0].center[0] = outerRadius + padding;
              options.legend.x = padding;
              options.title = {
                text: $scope.data.used.value + ($scope.data.used.unit || ''),
                subtext: use.title,
                itemGap: 11,
                x: (outerRadius + padding) * 2 + padding,
                y: outerRadius + padding - 40,
                textStyle: {
                  fontSize: 40,
                  fontWeight: 500
                },
                subtextStyle: {
                  fontSize: 14
                }
              };
            }
            break;
        }
        $scope.echartOptions = options;
      }]
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.charts.sparkline', [
  'dashing.charts.echarts'
])
/**
 * Sparkline is an one data series line chart without axis labels.
 *
 * @example
 *   <sparkline-chart
 *     options-bind="::chartOptions"
 *     datasource-bind="chartData">
 *   </sparkline-chart>
 *
 * @param options-bind - the option object, which the following elements:
 * {
 *   height: string // the css height of the chart
 *   width: string // the css width of the chart
 *   data: // an array of initial data points
 *
 *   color: string // optional to override line color
 *   visibleDataPointsNum: number // the maximal number of data points in the chart (default: unlimited)
 *   valueFormatter: function // function to override the representation of y-axis value
 *   xAxisTypeIsTime: boolean // use timeline as x-axis (currently disabled)
 *   series0Type: 'bar'|'area' // renders data series as bar or area (default: area)
 * }
 * @param datasource-bind - array of data objects
 *   every data object is {x: time|string, y: number|array}
 */
  .directive('sparklineChart', ['$echarts', function($echarts) {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            echartScope.addDataPoints(data);
          }
        });
      },
      controller: ['$scope', function($scope) {
        var use = angular.merge({
          color: 'rgb(0,119,215)'
        }, $scope.options);
        if (use.xAxisTypeIsTime) {
          // todo: https://github.com/ecomfe/echarts/issues/1954
          console.warn('Echarts does not have a good experience for time series, so we fallback to category.');
          use.xAxisTypeIsTime = false;
        }
        var colors = $echarts.buildColorStates(use.color);
        var options = {
          height: use.height,
          width: use.width,
          tooltip: $echarts.categoryTooltip(use.valueFormatter),
          grid: angular.merge({
            borderWidth: 1,
            x: 5, y: 5, x2: 5, /* add 5px margin to avoid overlap a data point */
            y2: 1 /* reduce to 1px, because 5px will have a thick ugly grey border */
          }, use.grid),
          xAxis: [{
            type: use.xAxisTypeIsTime ? 'time' : undefined,
            boundaryGap: false,
            axisLabel: false,
            splitLine: false
          }],
          yAxis: [{
            boundaryGap: [0, 0.1],
            show: false
          }],
          series: [$echarts.makeDataSeries({
            colors: colors,
            stack: true /* stack=true means fill area */
          })]
        };
        if (use.series0Type === 'bar') {
          options.grid.borderWidth = 0;
          options.grid.y2 = 0;
          options.xAxis[0].boundaryGap = true;
          options.series[0].type = 'bar';
        }
        var data = use.data;
        $echarts.fillAxisData(options, data, use);
        $scope.echartOptions = options;
      }]
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.contextmenu', [
  'mgcrea.ngStrap.dropdown' // angular-strap
])
/**
 * A context menu helper that can popup an element (e.g. dropdown menu) at any position of any surface.
 *
 * @example
 *  <div class="cm-container" id="my_contextmenu"
 *    bs-dropdown data-animation="am-fade"
 *    html="true" template-url="path/to/contextmenu.html"></div>
 *
 *  In script:
 *    var elem = document.getElementById('my_contextmenu');
 *    $contextmenu.popup(elem, {x: 100, y: 100});
 */
  .factory('$contextmenu', function() {
    return {
      popup: function(elem, position) {
        var elem0 = angular.element(elem);
        elem0.css({left: position.x + 'px', top: position.y + 'px'});
        elem0.triggerHandler('click');
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.filters.duration', [
  'dashing.util'
])
/**
 * Converts milliseconds to human readable duration representation.
 * */
  .filter('duration', ['dashing.util', function(util) {
    return function(millis, compact) {
      return util.text.toHumanReadableDuration(millis, compact);
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.forms.searchbox', [
])
/**
 * A (Bootstrap style based) search box with a search icon on the right side.
 *
 * @example
 *  <searchbox ng-model="search" placeholder="Search Anything"></searchbox>
 */
  .directive('searchbox', function() {
    return {
      restrict: 'E',
      templateUrl: 'forms/searchbox.html',
      scope: {
        placeholder: '@',
        ngModel: '='
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.metrics', [])
/**
 * A card component to show metric value and its meaning.
 *
 * @example
 *  <metrics caption="CPU" value="99.5" unit="%"></metrics>
 *  <metrics caption="Disk Write Rate" value="500" unit="MB/s"
 *    sub-text="SSD hard disk"></metrics>
 */
  .directive('metrics', function() {
    return {
      restrict: 'E',
      templateUrl: 'metrics/metrics.html',
      scope: {
        caption: '@',
        help: '@',
        value: '@',
        unit: '@',
        subText: '@'
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.progressbar', [])
/**
 * A combination of labels and a bootstrap progress bar. The color of the progress bar is
 * determined by the progress value.
 *
 * @example
 *  <progressbar current="50" max="100" color-mapper-fn="customColorMapperFn"></progressbar>
 */
  .directive('progressbar', function() {
    return {
      restrict: 'E',
      templateUrl: 'progressbar/progressbar.html',
      scope: {
        current: '@',
        max: '@',
        colorMapperFn: '='
      },
      link: function(scope, elem, attrs) {
        attrs.$observe('current', function(current) {
          updateUsageAndClass(Number(current), Number(attrs.max));
        });
        attrs.$observe('max', function(max) {
          updateUsageAndClass(Number(attrs.current), Number(max));
        });
        function updateUsageAndClass(current, max) {
          scope.usage = max > 0 ? Math.round(current * 100 / max) : -1;
          scope.usageClass = (scope.colorMapperFn ?
            scope.colorMapperFn : defaultColorMapperFn)(scope.usage);
        }
        function defaultColorMapperFn(usage) {
          return 'progress-bar-' +
            (usage < 50 ? 'info' : (usage < 75 ? 'warning' : 'danger'));
        }
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.property.bytes', [
  'dashing.util'
])
/**
 * Bytes as text with a human readable unit.
 *
 * @param raw number
 * @param unit string (optional)
 *
 * @example
 *  <bytes raw="1234"></bytes>
 *  <bytes raw="102400" unit="byte"></bytes>
 *  <bytes raw="102400" unit="byte" readable="true"></bytes>
 */
  .directive('bytes', ['dashing.util', function(util) {
    return {
      restrict: 'E',
      templateUrl: 'property/bytes.html',
      scope: {
        raw: '@'
      },
      link: function(scope, elem, attrs) {
        attrs.$observe('raw', function(raw) {
          if (['true', '1'].indexOf(attrs['readable']) !== -1) {
            var hr = util.text.toHumanReadableNumber(Number(raw), 1024);
            scope.value = hr.value;
            scope.unit = hr.modifier + attrs.unit;
          } else {
            scope.value = raw;
            scope.unit = attrs.unit;
          }
        });
      }
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.property', [
  'mgcrea.ngStrap.tooltip' // angular-strap
])
/**
 * A runtime determined auto property widget, which can be rendered as progress bar,
 * button, time duration, state indicator, colored tag, etc.
 *
 * @example
 *  <property value-bind="tagArgs" renderer="Tag"></property>
 */
  .directive('property', function() {
    return {
      restrict: 'E',
      templateUrl: 'property/property.html',
      replace: false,
      scope: {
        value: '=valueBind',
        renderer: '@'
      },
      controller: ['$scope', function($scope) {
        $scope.$watch('value', function(value) {
          if (value) {
            switch ($scope.renderer) {
              case 'Link':
                if (!value.href) {
                  $scope.href = value.text;
                }
                break;
              case 'Button':
                if (value.href && !value.click) {
                  $scope.click = function() {
                    location.href = value.href;
                  };
                }
                break;
              case 'Bytes':
                if (!value.hasOwnProperty('raw')) {
                  $scope.raw = value;
                  return; // fallback to simple value
                }
                break;
            }
            if (angular.isObject(value)) {
              if (value.hasOwnProperty('value')) {
                // `value.value` will assign `$scope.value`, which will trigger watch notification again.
                console.warn({message: 'Ignore `value.value`, because it is a reversed field.', object: value});
                delete value.value;
              }
              // bind all value fields to scope.
              angular.merge($scope, value);
            }
          }
        });
      }]
    };
  })
  /** Renderer constants */
  .constant('dsPropertyRenderer', {
    BUTTON: 'Button',
    BYTES: 'Bytes',
    DATETIME: 'DateTime',
    DURATION: 'Duration',
    INDICATOR: 'Indicator',
    LINK: 'Link',
    NUMBER: 'Number',
    PROGRESS_BAR: 'ProgressBar',
    TAG: 'Tag',
    TEXT: undefined /* default renderer */
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.remark', [
  'mgcrea.ngStrap.tooltip' // angular-strap
])
/**
 * A question mark icon with a tooltip.
 *
 * @param type question|warning (default=question)
 * @param tooltip string (optional)
 *
 * @example
 *  <remark text="This is a tooltip"></remark>
 */
  .directive('remark', function() {
    return {
      restrict: 'E',
      templateUrl: 'remark/remark.html',
      scope: {
        tooltip: '@'
      },
      link: function(scope, elem, attrs) {
        switch (attrs.type) {
          case 'info':
            scope.fontClass = 'glyphicon glyphicon-info-sign';
            break;
          case 'warning':
            scope.fontClass = 'glyphicon glyphicon-exclamation-sign';
            break;
          //case 'question':
          default:
            scope.fontClass = 'glyphicon glyphicon-question-sign';
            break;
        }
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.state.indicator', [
  'dashing.util',
  'mgcrea.ngStrap.tooltip' // angular-strap
])
/**
 * A small square icon that indicates one of these states: good, concern, danger or whatever.
 *
 * @param condition good|concern|danger
 *          specify the background color according to condition.
 *          fallback to gray, if condition is not specified or recognized.
 * @param tooltip string (optional)
 * @param shape stripe string (optional)
 *          stripe means a full filled bar (width=8px)
 *          fallback to a small square icon, if shape is not specified or recognized.
 *
 * @example
 *  <indicator condition="good"></indicator>
 *  <indicator condition="good" tooltip="Build passed"></indicator>
 *  <indicator condition="good" shape="stripe"></indicator>
 */
  .directive('indicator', ['dashing.util', function(util) {
    return {
      restrict: 'E',
      templateUrl: 'state/indicator.html',
      scope: {
        tooltip: '@',
        shape: '@'
      },
      link: function(scope, elem, attrs) {
        if (!attrs.condition) {
          attrs.condition = '';
        }
        /** Condition will affect the color */
        attrs.$observe('condition', function(condition) {
          scope.colorStyle = util.bootstrap.conditionToColor(condition);
        });
        /** Tooltip text will affect the cursor type */
        attrs.$observe('tooltip', function(tooltip) {
          scope.cursorStyle = tooltip ? 'pointer' : 'default';
        });
      }
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.state.tag', [
  'dashing.util',
  'mgcrea.ngStrap.tooltip' // angular-strap
])
/**
 * A clickable bootstrap label indicates one of these states: good, concern, danger or unknown.
 *
 * @param condition good|concern|danger|unknown
 * @param text text to shown on the tag
 * @param href link to follow when click on the tag control (optional)
 * @param tooltip string (optional)
 *
 * @example
 *  <tag condition="good" text="Build passed"></tag>
 *  <tag href="/path/to/page" condition="concern" text="error" tooltip="Build failed"></tag>
 */
  .directive('tag', ['dashing.util', function(util) {
    return {
      restrict: 'E',
      templateUrl: 'state/tag.html',
      scope: {
        href: '@',
        text: '@',
        tooltip: '@'
      },
      link: function(scope, elem, attrs) {
        if (!attrs.condition) {
          attrs.condition = '';
        }
        /** Condition will affect the color */
        attrs.$observe('condition', function(condition) {
          scope.labelColorClass = util.bootstrap.conditionToBootstrapLabelClass(condition);
        });
        /** Tooltip text will affect the cursor type */
        attrs.$observe('tooltip', function(tooltip) {
          if (!scope.href) {
            scope.cursorStyle = tooltip ? 'pointer' : 'default';
          }
        });
      }
    };
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tables.property-table.builder', [])
/**
 * A helper class to build column as a chained object
 */
  .factory('$propertyTableBuilder', ['dsPropertyRenderer',
    function(renderer) {
      var PB = function(renderer, title) {
        this.props = renderer ? {renderer: renderer} : {};
        if (title) {
          this.title(title);
        }
      };
      PB.prototype.title = function(title) {
        this.props.name = title;
        return this;
      };
      PB.prototype.help = function(help) {
        this.props.help = help;
        return this;
      };
      PB.prototype.value = function(value) {
        this.props.value = value;
        return this;
      };
      PB.prototype.values = function(values) {
        if (!Array.isArray(values)) {
          console.warn('values must be an array');
          values = [values];
        }
        this.props.values = values;
        return this;
      };
      PB.prototype.done = function() {
        return this.props;
      };
      return {
        button: function(title) {
          return new PB(renderer.BUTTON, title);
        },
        bytes: function(title) {
          return new PB(renderer.BYTES, title);
        },
        datetime: function(title) {
          return new PB(renderer.DATETIME, title);
        },
        duration: function(title) {
          return new PB(renderer.DURATION, title);
        },
        indicator: function(title) {
          return new PB(renderer.INDICATOR, title);
        },
        link: function(title) {
          return new PB(renderer.LINK, title);
        },
        number: function(title) {
          return new PB(renderer.NUMBER, title);
        },
        progressbar: function(title) {
          return new PB(renderer.PROGRESS_BAR, title);
        },
        tag: function(title) {
          return new PB(renderer.TAG, title);
        },
        text: function(title) {
          return new PB(renderer.TEXT, title);
        },
        /** Updates table values */
        $update: function(props, values) {
          angular.forEach(values, function(value, index) {
            var field = Array.isArray(value) ? 'values' : 'value';
            props[index][field] = value;
          });
        }
      };
      // todo: build values regarding renderer type
    }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tables.property-table', [])
/**
 * A two column table. The first column is the property name. The second column is
 * the value of the property rendered in a suitable way.
 *
 * @param caption string (optional)
 *   the caption of the table
 * @param props-bind array
 *   an array of property objects
 *
 * @example
 *  <property-table
 *    caption="Table caption"
 *    props-bind="propsVariable"
 *    prop-name-class="col-md-4"
 *    prop-value-class="col-md-8">
 *  </property-table>
 */
  .directive('propertyTable', function() {
    return {
      restrict: 'E',
      templateUrl: 'tables/property-table/property-table.html',
      scope: {
        caption: '@',
        props: '=propsBind',
        propNameClass: '@',
        propValueClass: '@'
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tables.sortable-table.builder', [
  'dashing.property',
  'dashing.util'
])
/**
 * A helper class to build column as a chained object
 */
  .factory('$sortableTableBuilder', ['dashing.util', 'dsPropertyRenderer',
    function(util, renderer) {
      var CB = function(renderer, title) {
        this.props = renderer ? {renderer: renderer} : {};
        if (title) {
          this.title(title);
        }
      };
      CB.prototype.title = function(title) {
        this.props.name = title;
        return this;
      };
      CB.prototype.key = function(key) {
        this.props.key = key;
        return this;
      };
      CB.prototype.canSort = function(overrideSortKey) {
        if (!overrideSortKey && !this.props.key) {
          console.warn('Specify a sort key or define column key first!');
          return;
        }
        this.props.sortKey = overrideSortKey || this.props.key;
        if (this.props.sortKey === this.props.key) {
          switch (this.props.renderer) {
            case renderer.LINK:
              this.props.sortKey += '.text';
              break;
            case renderer.INDICATOR:
            case renderer.TAG:
              this.props.sortKey += '.condition';
              break;
            case renderer.PROGRESS_BAR:
              this.props.sortKey += '.usage';
              break;
            case renderer.BYTES:
              this.props.sortKey += '.raw';
              break;
            case renderer.BUTTON:
              console.warn('"%s" column is not sortable.');
              return;
            default:
          }
        }
        return this;
      };
      CB.prototype.sortDefault = function(descent) {
        if (!this.props.sortKey) {
          console.warn('Specify a sort key or define column key first!');
          return;
        }
        this.props.defaultSort = descent ? 'reverse' : true;
        return this;
      };
      CB.prototype.sortDefaultDescent = function() {
        return this.sortDefault(/*descent=*/true);
      };
      CB.prototype.styleClass = function(styleClass) {
        this.props.styleClass = styleClass;
        return this;
      };
      CB.prototype.sortBy = function(sortKey) {
        this.props.sortKey = sortKey;
        return this;
      };
      CB.prototype.unit = function(unit) {
        this.props.unit = unit;
        return this;
      };
      CB.prototype.help = function(help) {
        this.props.help = help;
        return this;
      };
      CB.prototype.vertical = function() {
        if (Array.isArray(this.props.key)) {
          this.props.vertical = true;
        }
        return this;
      };
      CB.prototype.done = function() {
        return this.props;
      };
      return {
        button: function(title) {
          return new CB(renderer.BUTTON, title);
        },
        bytes: function(title) {
          return new CB(renderer.BYTES, title);
        },
        datetime: function(title) {
          return new CB(renderer.DATETIME, title);
        },
        duration: function(title) {
          return new CB(renderer.DURATION, title);
        },
        indicator: function(title) {
          return new CB(renderer.INDICATOR, title);
        },
        link: function(title) {
          return new CB(renderer.LINK, title);
        },
        multiple: function(title, renderers) {
          return new CB(renderers, title);
        },
        number: function(title) {
          return new CB(renderer.NUMBER, title);
        },
        progressbar: function(title) {
          return new CB(renderer.PROGRESS_BAR, title);
        },
        tag: function(title) {
          return new CB(renderer.TAG, title);
        },
        text: function(title) {
          return new CB(renderer.TEXT, title);
        },
        /** Debug util */
        $check: function(cols, model) {
          angular.forEach(cols, function(col) {
            var keys = util.array.ensureArray(col.key);
            angular.forEach(keys, function(key) {
              if (!model.hasOwnProperty(key)) {
                console.warn('Model does not have a property matches column key `' + col + '`.');
              }
            });
          });
        }
      };
    }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tables.sortable-table', [
  'smart-table' // smart-table
])
/**
 * A customized "smart-table" widget which is sortable; has nice pagination
 * control; is able to bind with a nice external search controls.
 *
 * @example
 *  <sortable-table
 *    caption="Table caption"
 *    pagination="5"
 *    columns-bind="columnsVariable"
 *    records-bind="recordsVariable"
 *    search-bind="searchVariable">
 *  </sortable-table>
 *
 *    @param caption string
 *      the caption of the table (optional)
 *    @param pagination int
 *      the number of records to be shown per page (optional)
 *    @param columns-bind array
 *      an array of column objects
 *    @param records-bind array
 *      an array of record objects
 *    @param search-bind string
 *      the text in a global search bar (optional)
 */
  .directive('sortableTable', function() {
    return {
      restrict: 'E',
      templateUrl: 'tables/sortable-table/sortable-table.html',
      scope: {
        caption: '@',
        pagination: '@',
        columns: '=columnsBind',
        records: '=recordsBind',
        search: '=searchBind'
      },
      link: function(scope, elem) {
        // TODO: https://github.com/lorenzofox3/Smart-Table/issues/436
        var searchControl = elem.find('input')[0];
        scope.$watch('search', function(val) {
          searchControl.value = val || ''; // empty string means to show all records
          angular.element(searchControl).triggerHandler('input');
        });
        // Columns are not changed after table is created, we cache frequently accessed values rather than
        // evaluating them in every digest cycle.
        scope.$watch('columns', function(columns) {
          if (!Array.isArray(columns)) {
            console.warn('Failed to create table, until columns are defined.');
            return;
          }
          // 1
          scope.columnStyleClass = columns.map(function(column) {
            function addStyleClass(dest, clazz, condition) {
              if (condition) {
                dest.push(clazz);
              }
            }
            var array = [];
            addStyleClass(array, column.styleClass, column.styleClass !== undefined);
            addStyleClass(array, 'text-right', 'Number' === column.renderer);
            addStyleClass(array, 'text-nowrap', Array.isArray(column.key) && !column.vertical);
            return array.join(' ');
          });
          // 2
          scope.multipleRendererColumnsRenderers = columns.map(function(column) {
            if (!Array.isArray(column.key)) {
              return null; // Template will not call the method at all
            }
            if (Array.isArray(column.renderer)) {
              if (column.renderer.length !== column.key.length) {
                console.warn('Every column key should have a renderer, or share one renderer.');
              }
              return column.renderer;
            }
            return column.key.map(function() {
              return column.renderer;
            });
          });
        });
        // Expose isArray into template.
        scope.isArray = Array.isArray;
      }
    };
  })
  // TODO: as long as st-table does not support pagination start and stop
  // https://github.com/lorenzofox3/Smart-Table/issues/440
  .directive('stSummary', function() {
    return {
      require: '^stTable',
      template: 'Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records',
      link: function(scope, element, attrs, stTable) {
        scope.stRange = {
          from: null,
          to: null
        };
        scope.$watch('currentPage', function() {
          var pagination = stTable.tableState().pagination;
          scope.stRange.from = pagination.start + 1;
          scope.stRange.to = scope.currentPage === pagination.numberOfPages ?
            pagination.totalItemCount : (scope.stRange.from + scope.stItemsByPage - 1);
        });
      }
    };
  })
/**
 * Override smart-table's default behavior(s)
 */
  .config(['stConfig', function(stConfig) {
    stConfig.sort.skipNatural = true;
  }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.tabset', [])
/**
 * A lazy loading tab control in Google UI style.
 *
 * @example
 *  <tabset id="my_tabset">
 *    <tab ng-repeat="tab in tabs track by $index"
 *      heading="{{tab.heading}}"
 *      template="{{tab.templateUrl}}"
 *      controller="{{tab.controller}}"></tab>
 *  </tabset>
 *
 *  In script:
 *    var elem = document.getElementById('my_tabset');
 *    var tabsetScope = angular.element(elem).scope();
 *    tabsetScope.selectTab(2);
 */
  .directive('tabset', [function() {
    return {
      restrict: 'E',
      templateUrl: 'tabset/tabset.html',
      transclude: true,
      scope: true, // in order to expose the method `selectTab()`
      controller: ['$scope', function($scope) {
        var tabs = $scope.tabs = [];
        function select(tab, reload) {
          angular.forEach(tabs, function(item) {
            item.selected = item === tab;
          });
          if (tab.load !== undefined) {
            tab.load(reload);
          }
        }
        this.addTab = function(tab) {
          tabs.push(tab);
          if (tabs.length === 1) {
            select(tab);
          }
        };
        $scope.selectTab = function(activeTabIndex, reload) {
          if (activeTabIndex >= 0 && activeTabIndex < tabs.length) {
            select(tabs[activeTabIndex], reload);
          }
        };
      }]
    };
  }])
/** Directive of tab that is associated with tabs */
  .directive('tab', ['$http', '$controller', '$compile',
    function($http, $controller, $compile) {
      return {
        restrict: 'E',
        require: '^tabset',
        template: '<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',
        replace: true,
        transclude: true,
        link: function(scope, elem, attrs, ctrl) {
          scope.heading = attrs.heading;
          scope.loaded = false;
          scope.load = function(reload) {
            if (scope.loaded && !reload) {
              return;
            }
            if (attrs.template) {
              $http.get(attrs.template).then(function(response) {
                createTemplateScope(response.data);
              });
            }
          };
          function createTemplateScope(template) {
            elem.html(template);
            var templateScope = scope.$new(false);
            if (attrs.controller) {
              var scopeController = $controller(attrs.controller, {$scope: templateScope});
              elem.children().data('$ngController', scopeController);
            }
            $compile(elem.contents())(templateScope);
            scope.loaded = true;
          }
          ctrl.addTab(scope);
        }
      };
    }])
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.util.array', [])
  .factory('dashing.util.array', function() {
    return {
      /**
       * Return the array, if required length is less or equal to the array's, otherwise make a
       * copy and fill the extra positions with a default value.
       */
      alignArray: function(array, length, default_) {
        if (length <= array.length) {
          return array.slice(0, length);
        }
        var result = angular.copy(array);
        for (var i = result.length; i < length; i++) {
          result.push(default_);
        }
        return result;
      },
      /**
       * Return the array, if the required length is less or equal to the array's, otherwise
       * make a copy and fill the extra positions with a value of the array.
       */
      repeatArray: function(array, sum) {
        if (sum <= array.length) {
          return array.slice(0, sum);
        }
        var result = [];
        for (var i = 0; i < sum; i++) {
          result.push(array[i % array.length]);
        }
        return result;
      },
      /**
       * Return the array, if it is an array or return an array with one element.
       */
      ensureArray: function(value) {
        return Array.isArray(value) ? value : [value];
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.util.bootstrap', [])
  .factory('dashing.util.bootstrap', function() {
    return {
      /** Convert a condition to a Bootstrap label style class */
      conditionToBootstrapLabelClass: function(condition) {
        switch (condition) {
          case 'good':
            return 'label-success';
          case 'concern':
            return 'label-warning';
          case 'danger':
            return 'label-danger';
          default:
            return 'label-default';
        }
      },
      /** Convert a condition to a css color */
      conditionToColor: function(condition) {
        switch (condition) {
          case 'good':
            return '#5cb85c';
          case 'concern':
            return '#f0ad4e';
          case 'danger':
            return '#d9534f';
          default:
            return '#aaa';
        }
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.util.color', [])
  .factory('dashing.util.color', function() {
    return {
      /**
       * Return pre-defined color palette.
       */
      palette: {
        blue: 'rgb(0,119,215)',
        blueishGreen: 'rgb(41,189,181)',
        orange: 'rgb(255,127,80)',
        purple: 'rgb(110,119,215)',
        skyBlue: 'rgb(91,204,246)',
        darkBlue: 'rgb(102,168,212)',
        darkGray: 'rgb(92,92,97)',
        darkPink: 'rgb(212,102,138)',
        darkRed: 'rgb(212,102,138)',
        lightBlue: 'rgb(149,206,255)',
        lightGreen: 'rgb(169,255,150)'
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.util.text', [])
  .factory('dashing.util.text', function() {
    return {
      /**
       * Return the human readable number notation.
       */
      toHumanReadableNumber: function(value, base, precision) {
        var modifier = '';
        if (value !== 0) {
          if (base !== 1024) {
            base = 1000;
          }
          var positive = value > 0;
          var positiveValue = Math.abs(value);
          var s = ['', 'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'];
          var e = Math.floor(Math.log(positiveValue) / Math.log(base));
          value = positiveValue / Math.pow(base, e);
          if (angular.isNumber(precision) && value !== Math.floor(value)) {
            value = value.toFixed(precision);
          }
          if (!positive) {
            value *= -1;
          }
          modifier = s[e];
        }
        return {value: value, modifier: modifier};
      },
      /**
       * Return the human readable duration notation.
       */
      toHumanReadableDuration: function(millis, compact) {
        var x = parseInt(millis, 10);
        if (isNaN(x)) {
          return millis;
        }
        var units = [
          {label: ' ms', mod: 1000},
          {label: compact ? 's' : ' secs', mod: 60},
          {label: compact ? 'm' : ' mins', mod: 60},
          {label: compact ? 'h' : ' hours', mod: 24},
          {label: compact ? 'd' : ' days', mod: 7},
          {label: compact ? 'w' : ' weeks', mod: 52}
        ];
        var duration = [];
        for (var i = 0; i < units.length; i++) {
          var unit = units[i];
          var t = x % unit.mod;
          if (t !== 0) {
            duration.unshift({label: unit.label, value: t});
          }
          x = (x - t) / unit.mod;
        }
        duration = duration.slice(0, 2);
        if (duration.length > 1 && duration[1].label === ' ms') {
          duration = [duration[0]];
        }
        return duration.map(function(unit) {
          return unit.value + unit.label;
        }).join(compact ? ' ' : ' and ');
      }
    };
  })
;
/*
 * Licensed under the Apache License, Version 2.0
 * See accompanying LICENSE file.
 */
angular.module('dashing.util', [
  'dashing.util.array',
  'dashing.util.bootstrap',
  'dashing.util.color',
  'dashing.util.text'
])
  .factory('dashing.util', [
    'dashing.util.array',
    'dashing.util.bootstrap',
    'dashing.util.color',
    'dashing.util.text',
    function(array, bootstrap, color, text) {
      return {
        array: array,
        bootstrap: bootstrap,
        color: color,
        text: text
      };
    }])
;
})(window, document);