/*
 * dashing (assembled widgets)
 * @version v0.2.4
 * @link https://github.com/stanleyxu2005/dashing
 * @license Apache License 2.0, see accompanying LICENSE file
 */
!function(e,t,r){"use strict";angular.module("dashing",["dashing.charts.bar","dashing.charts.line","dashing.charts.metrics-sparkline","dashing.charts.ring","dashing.charts.sparkline","dashing.forms.searchbox","dashing.metrics","dashing.progressbar","dashing.property","dashing.property.bytes","dashing.remark","dashing.state.indicator","dashing.state.tag","dashing.tables.property-table","dashing.tables.sortable-table","dashing.tabset","dashing.contextmenu","dashing.tables.property-table.builder","dashing.tables.sortable-table.builder","dashing.filters.duration"]),angular.module("dashing").run(["$templateCache",function(e){e.put("charts/metrics-sparkline-td.html",'<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>'),e.put("forms/searchbox.html",'<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <span class="glyphicon glyphicon-search form-control-feedback"></span> </div>'),e.put("metrics/metrics.html",'<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="question" tooltip="{{help}}"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <small ng-bind="unit"></small> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>'),e.put("progressbar/progressbar.html",'<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>'),e.put("property/bytes.html",'<div> <span ng-bind="value|number:0"></span> <span ng-if="unit" ng-bind="unit"></span> </div>'),e.put("property/property.html",'<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <bytes ng-switch-when="Bytes" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-readable="{{readable}}"></bytes>  <div ng-switch-when="Duration" ng-bind="value|duration"></div>  <div ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:mm:ss\'"></div>  <div ng-switch-when="Number" ng-bind="value|number:0"></div>  <div ng-switch-default ng-bind="value"></div> </ng-switch>'),e.put("remark/remark.html",'<span class="{{fontClass}} remark-icon" bs-tooltip="tooltip"></span>'),e.put("state/indicator.html",'<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle, \'cursor\': cursorStyle}" style="display: inline-block; height: 100%; width: 8px" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>'),e.put("state/tag.html",'<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>'),e.put("tables/property-table/property-table.html",'<table class="table table-striped table-hover"> <caption ng-if="caption" ng-bind="caption"></caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>'),e.put("tables/sortable-table/sortable-table-pagination.html",'<div class="pull-left"> <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs">  <button type="button" class="btn btn-default" ng-class="{disabled:1==currentPage}" ng-click="selectPage(currentPage-1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active:page==currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button type="button" class="btn btn-default" ng-class="{disabled:numPages==currentPage}" ng-click="selectPage(currentPage+1)"> &raquo;</button>  </div> </div>'),e.put("tables/sortable-table/sortable-table.html",'<table class="table table-striped table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption" ng-bind="caption"></caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody> <tr ng-repeat="record in showing track by $index"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="records !== null && !showing.length"> <td colspan="{{columns.length}}" class="text-center"> <i>No data found</i> </td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable-table/sortable-table-pagination.html"> </td> </tr> </tfoot> </table>'),e.put("tabset/tabset.html",'<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>')}]),angular.module("dashing.charts.bar",["dashing.charts.echarts"]).directive("barChart",["$echarts",function(e){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope","$element",function(t,r){var a=angular.merge({yAxisSplitNum:3,yAxisShowMinorAxisLine:!1,yAxisLabelWidth:60,yAxisLabelFormatter:e.axisLabelFormatter(""),yBoundaryGap:[.2,.2],"static":!0,rotate:!1,xAxisShowLabels:!0},t.options);a=angular.merge({barMaxWidth:a.rotate?20:16,barMinWidth:a.rotate?8:7,barMaxSpacing:4,barMinSpacing:1},a);var n=a.data;Array.isArray(n)||(console.warn({message:"Initial data is expected to be an array",data:n}),n=n?[n]:[]),e.validateSeriesNames(a,n),Array.isArray(a.colors)&&a.colors.length||(a.colors=e.barChartColorRecommendation(a.seriesNames.length||1));var i=a.colors.map(function(t){return e.buildColorStates(t)}),o=i.length>1?"#999":i[0].line,s={height:a.height,width:a.width,tooltip:angular.merge(e.categoryTooltip(a.valueFormatter),{axisPointer:{type:"shadow",shadowStyle:{color:"rgba(225,225,225,0.3)"}}}),grid:angular.merge({borderWidth:0,x:Math.max(5,a.yAxisLabelWidth),x2:15,y:15,y2:28},a.grid),xAxis:[{axisLabel:{show:!0},axisLine:{show:!0,lineStyle:{width:1,color:o,type:"dotted"}},axisTick:!1,splitLine:!1}],yAxis:[{type:"value",splitNumber:a.yAxisSplitNum,splitLine:{show:a.yAxisShowMinorAxisLine,lineStyle:{color:o,type:"dotted"}},axisLine:!1,axisLabel:{formatter:a.yAxisLabelFormatter}}],series:a.seriesNames.map(function(t,r){return e.makeDataSeries({type:"bar",name:t,stack:!0,colors:i[r]})}),color:a.colors};if(a["static"]&&delete a.visibleDataPointsNum,e.fillAxisData(s,n,a),a["static"]&&(s.visibleDataPointsNum=-1),a.rotate){var l=s.xAxis;s.xAxis=angular.copy(s.yAxis),s.xAxis[0].type=s.xAxis[0].type||"value",s.yAxis=l,s.yAxis[0].type=s.yAxis[0].type||"category"}if(a.xAxisShowLabels||(s.xAxis[0].axisLabel=!1,s.grid.y2=s.grid.y),a["static"]){var u=a.barMinWidth+a.barMinSpacing,c=a.barMaxWidth+a.barMaxSpacing,d=n.length*u,p=n.length*c,h=parseInt(a.height);if(a.rotate){var g=2*s.grid.borderWidth+s.grid.y+s.grid.y2;g+d>h?(console.info("Increased the height to "+(g+d)+"px, because rotated bar chart does not support data zoom yet."),s.height=g+d+"px"):h>g+p&&(s.height=g+p+"px")}else{var m=2*s.grid.borderWidth+s.grid.x+s.grid.x2,b=angular.element(r[0]).children()[0].offsetWidth,y=b-m;if(d>0&&d>y){var f=Math.floor(y/u)*u;s.grid.x2+=y-f;var v=20,x=5;s.dataZoom={show:!0,end:100*f/d,realtime:!0,height:v,y:h-v-x,handleColor:o},s.dataZoom.fillerColor=zrender.tool.color.alpha(s.dataZoom.handleColor,.08),s.grid.y2+=v+2*x}else n.length&&(y>p?s.grid.x2+=b-p-m:s.grid.x2+=y-Math.floor(y/n.length)*n.length)}}t.echartOptions=s}]}}]),angular.module("dashing.charts.echarts",["dashing.util"]).directive("echart",["dashing.util",function(t){function a(e,r,a,n){var i=[];return angular.forEach(t.array.ensureArray(e),function(e){var o=a-->0,s=t.array.ensureArray(e.y).slice(0,r);if(n)angular.forEach(s,function(t,r){var a=[r,[e.x,t],!1,o];i.push(a)});else{var l=s.length-1;angular.forEach(s,function(t,r){var a=[r,t,!1,o];r===l&&a.push(e.x),i.push(a)})}}),i}return{restrict:"E",template:"<div></div>",replace:!0,scope:{options:"="},controller:["$scope","$element","dsEchartsDefaults","$echarts",function(n,i,o,s){function l(){h&&(c.dataPointsQueue&&c.dataPointsQueue.length&&(u(c.dataPointsQueue),delete c.dataPointsQueue),delete c.data)}function u(e,n){if(e&&(!Array.isArray(e)||e.length))try{if(!h)return s.fillAxisData(c,t.array.ensureArray(e)),p.setOption(c,!0),h=angular.isDefined(p.getOption().xAxis),l(),void(h&&p.hideLoading());var i=p.getOption(),u=i.series[0].data.length,d=Math.max(0,(i.visibleDataPointsNum||o.visibleDataPointsNum)-u),g="time"===i.xAxis[0].type||"value"===i.xAxis[0].type&&"time"===i.yAxis[0].type,m=i.series.length,b=a(e,m,d,g);b.length>0&&(n!==r&&p.setOption({yAxis:[{max:n}]},!1),p.addData(b))}catch(y){}}var c=n.options,d=i[0];angular.forEach(["width","height"],function(e){c[e]&&(d.style[e]=c[e])});var p=echarts.init(d);angular.element(e).on("resize",p.resize),n.$on("$destroy",function(){angular.element(e).off("resize",p.resize)}),n.$on("$destroy",function(){p.dispose(),p=null}),p.setTheme(o.lookAndFeel),p.setOption(c,!0),angular.isFunction(p.group)&&c.hasOwnProperty("groupId")&&(p.groupId=c.groupId,p.group());var h=angular.isDefined(p.getOption().xAxis);l(),n.addDataPoints=u,n.getChartControl=function(){return p}}]}}]).constant("dsEchartsDefaults",{lookAndFeel:{markLine:{symbol:["circle","circle"]},title:{textStyle:{fontSize:14,fontWeight:400,color:"#000"}},legend:{textStyle:{color:"#111",fontWeight:500},itemGap:20},tooltip:{borderRadius:2,padding:0,showDelay:0,transitionDuration:.5},textStyle:{fontFamily:'lato,roboto,"helvetica neue","segoe ui",arial',fontSize:12},loadingText:"Data Loading...",noDataText:"No Graphic Data Available",addDataAnimation:!1},visibleDataPointsNum:80}).factory("$echarts",["$filter","dashing.util",function(e,t){function r(t,r,i){function o(e){var t=zrender.tool.color.lift(e,-.2);return'<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid '+t+"; background-color: "+e+'"></div>'}function s(t){var r={};angular.forEach(t,function(e){r[e.name]=r[e.name]||[],r[e.name].push(e)});var a=[];return angular.forEach(r,function(e){var t=e.reduce(function(e,t){return Math.abs(e.value)>Math.abs(t.value)?e:t});t.value=e.reduce(function(e,t){return{value:e.value+t.value}}).value,a.push(t)}),e("orderBy")(a,"value",!0)}var l=i.valueFormatter||n;return'<div style="padding: 8px">'+[(i.nameFormatter||a)(t),"<table>"+s(r).map(function(e){return"-"===e.value?"":(e.value=l(e.value),e.name||(e.name=e.value,e.value=""),"<tr><td>"+o(e.color)+'</td><td style="padding: 0 12px 0 4px">'+e.name+'</td><td style="text-align: right">'+e.value+"</td></tr>")}).join("")+"</table>"].join("")+"</div>"}function a(t){if(angular.isDate(t)){var r=new Date;return e("date")(t,r.getYear()===t.getYear()&&r.getMonth()===t.getMonth()&&r.getDay()===t.getDay()?"HH:mm:ss":"yyyy-MM-dd HH:mm:ss")}return t}function n(t){return e("number")(t)}function i(e){return{trigger:e.trigger||"axis",axisPointer:{type:"none"},formatter:e.formatter}}function o(e,t){return Array.isArray(e)||(e=[]),!t||e.length<=t?{older:e,newer:[]}:{older:e.slice(0,t),newer:e.slice(t)}}return{categoryTooltip:function(e,a){return i({trigger:"axis",formatter:function(n){n=t.array.ensureArray(n);var i=n[0].name,o=n.map(function(e){return{color:e.series.colors.line,name:e.seriesName,value:e.value}});if(!i.length&&!o.filter(function(e){return"-"!==e.value}).length)return"";var s={nameFormatter:a,valueFormatter:e};return r(i,o,s)}})},timelineChartFix:function(e,t){console.warn("Echarts does not have a good experience for time series. We suggest to use category as x-axis type."),e.tooltip=i({trigger:"item",formatter:function(e){var a=[{color:e.series.colors.line,name:e.series.name,value:e.value[1]}];return r(e.value[0],a,t)}}),angular.forEach(e.xAxis,function(e){delete e.boundaryGap}),angular.forEach(e.series,function(e){e.showAllSymbol=!0,e.stack=!1})},validateSeriesNames:function(e,r){if(!e.seriesNames){var a=t.array.ensureArray(r[0].y);a.length>1&&console.warn({message:"You should define `options.seriesNames`",options:e}),e.seriesNames=a.map(function(e,t){return"Series "+(t+1)})}},axisLabelFormatter:function(e){return function(r){if(angular.isNumber(r)&&(r=Number(r),0!==r)){var a=t.text.toHumanReadableNumber(r,1e3,1);r=a.value+" "+a.modifier+(e||"")}return r}},makeDataSeries:function(e){var t={type:e.type||"line",symbol:"circle",symbolSize:4,smooth:e.smooth,itemStyle:{normal:{color:e.colors.line,lineStyle:{width:e.stack?4:3},borderColor:"transparent",borderWidth:6},emphasis:{color:e.colors.hover,borderColor:zrender.tool.color.alpha(e.colors.line,.3)}}};return e.stack?t.itemStyle.normal.areaStyle={type:"default",color:e.colors.area}:e.showAllSymbol&&(t.itemStyle.normal.lineStyle.width-=1),angular.merge(e,t)},fillAxisData:function(e,t,r){if(angular.isObject(r)&&(angular.isString(r.groupId)&&r.groupId.length&&(e.groupId=r.groupId),r.visibleDataPointsNum>0)){e.visibleDataPointsNum=r.visibleDataPointsNum;for(var a={x:"",y:Array(e.series.length).fill({value:"-",tooltip:{}})};t.length<r.visibleDataPointsNum;)t.unshift(a)}var n=o(t,e.visibleDataPointsNum);if(n.newer.length&&(e.dataPointsQueue=n.newer),delete e.xAxis[0].data,angular.forEach(e.series,function(e){e.data=[]}),"time"===e.xAxis[0].type)angular.forEach(n.older,function(t){angular.forEach(e.series,function(e,r){e.data.push([t.x,Array.isArray(t.y)?t.y[r]:t.y])})});else{var i=[];angular.forEach(n.older,function(t){i.push(t.x),angular.forEach(e.series,function(e,r){e.data.push(Array.isArray(t.y)?t.y[r]:t.y)})}),e.xAxis[0].data=i}},lineChartColorRecommendation:function(e){var r=t.color.palette;switch(e){case 1:return[r.blue];case 2:return[r.blue,r.blueishGreen];default:return t.array.repeatArray([r.blue,r.purple,r.blueishGreen,r.darkRed,r.orange],e)}},barChartColorRecommendation:function(e){var r=t.color.palette;switch(e){case 1:return[r.orange];case 2:return[r.blue,r.darkBlue];default:return t.array.repeatArray([r.lightGreen,r.darkGray,r.lightBlue,r.blue,r.darkBlue],e)}},buildColorStates:function(e){return{line:e,area:zrender.tool.color.lift(e,-.92),hover:zrender.tool.color.lift(e,.15)}}}}]),angular.module("dashing.charts.line",["dashing.charts.echarts"]).directive("lineChart",function(){return{restrict:"E",template:'<echart options="::echartOptions" data="data"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope","$echarts",function(e,t){var a=angular.merge({seriesStacked:!0,seriesLineSmooth:!1,showLegend:!0,yAxisSplitNum:3,yAxisShowSplitLine:!0,yAxisLabelWidth:60,yAxisLabelFormatter:t.axisLabelFormatter(""),xAxisShowLabels:!0},e.options),n=a.data;t.validateSeriesNames(a,n),Array.isArray(a.colors)&&a.colors.length||(a.colors=t.lineChartColorRecommendation(a.seriesNames.length||1));var i=a.colors.map(function(e){return t.buildColorStates(e)}),o="#999",s={length:4,lineStyle:{width:1,color:o}},l={height:a.height,width:a.width,tooltip:angular.merge(t.categoryTooltip(a.valueFormatter),{axisPointer:{type:"line",lineStyle:{width:3,color:"rgb(235,235,235)",type:"dotted"}}}),grid:angular.merge({borderWidth:0,x:Math.max(5,a.yAxisLabelWidth),x2:15,y:20,y2:25},a.grid),xAxis:[{type:a.xAxisTypeIsTime?"time":r,boundaryGap:!1,axisLine:s,axisTick:s,axisLabel:{show:!0},splitLine:!1}],yAxis:[{splitNumber:a.yAxisSplitNum,splitLine:{show:a.yAxisShowSplitLine,lineStyle:{color:o,type:"dotted"}},axisLine:!1,axisLabel:{formatter:a.yAxisLabelFormatter}}],series:a.seriesNames.map(function(e,r){return t.makeDataSeries({name:e,colors:i[r],stack:a.seriesStacked,smooth:a.seriesLineSmooth,showAllSymbol:a.showAllSymbol})}),color:a.colors};t.fillAxisData(l,n,a),a.xAxisShowLabels||(l.xAxis[0].axisLabel=!1,l.grid.y2=l.grid.y),a.xAxisTypeIsTime&&t.timelineChartFix(l,a),1===l.series.length&&(l.yAxis.boundaryGap=[0,.1]);var u=20,c=16;a.title&&(l.title={text:a.title,x:0,y:3},l.grid.y+=u);var d=l.series.length>1&&a.showLegend;d&&(l.legend={show:!0,itemWidth:8,data:l.series.map(function(e){return e.name})},l.legend.y=6,a.title&&(l.legend.y+=u,l.grid.y+=c)),(d||a.title)&&(l.grid.y+=12),e.echartOptions=l}]}}),angular.module("dashing.charts.metrics-sparkline",["dashing.charts.sparkline","dashing.metrics"]).directive("metricsSparklineChartTd",function(){return{restrict:"E",templateUrl:"charts/metrics-sparkline-td.html",scope:{caption:"@",help:"@",current:"@",unit:"@",subText:"@",options:"=optionsBind",data:"=datasourceBind"}}}),angular.module("dashing.charts.ring",["dashing.charts.echarts"]).directive("ringChart",function(){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){var r=t.getChartControl();r.setOption({series:[{data:[{value:e.available.value},{value:e.used.value}]}]})})},controller:["$scope","$echarts",function(e,t){var r=angular.merge({color:"rgb(35,183,229)",textPosition:"inner"},e.options),a=r.data||e.data;a||console.warn("Need data to render the ring pie chart.");var n=t.buildColorStates(r.color),i=8,o=(parseInt(r.height)-30-2*i)/2,s={normal:{color:"rgb(232,239,240)",label:{show:"inner"===r.textPosition,position:"center"},labelLine:!1}},l={height:r.height,width:r.width,grid:{borderWidth:0},xAxis:[{show:!1,data:[0]}],legend:{selectedMode:!1,itemGap:20,itemWidth:13,y:"bottom",data:[a.used.label,a.available.label].map(function(e){return{name:e,textStyle:{fontWeight:500},icon:"a"}})},series:[{type:"pie",center:["50%",o+i],radius:[Math.floor(.74*o),o],data:[{name:a.available.label,value:a.available.value,itemStyle:s},{name:a.used.label,value:a.used.value,itemStyle:angular.merge({},s,{normal:{color:n.line}})}]}]};switch(r.textPosition){case"inner":l.series[0].itemStyle={normal:{label:{formatter:function(){return Math.round(100*e.data.used.value/(e.data.used.value+e.data.available.value))+"%"},textStyle:{color:"#111",fontSize:28,fontWeight:500,baseline:"middle"}}}};break;case"right":r.title&&(l.series[0].center[0]=o+i,l.legend.x=i,l.title={text:e.data.used.value+(e.data.used.unit||""),subtext:r.title,itemGap:11,x:2*(o+i)+i,y:o+i-40,textStyle:{fontSize:40,fontWeight:500},subtextStyle:{fontSize:14}})}e.echartOptions=l}]}}),angular.module("dashing.charts.sparkline",["dashing.charts.echarts"]).directive("sparklineChart",["$echarts",function(e){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope",function(t){var a=angular.merge({color:"rgb(0,119,215)"},t.options);a.xAxisTypeIsTime&&(console.warn("Echarts does not have a good experience for time series, so we fallback to category."),a.xAxisTypeIsTime=!1);var n=e.buildColorStates(a.color),i={height:a.height,width:a.width,tooltip:e.categoryTooltip(a.valueFormatter),grid:angular.merge({borderWidth:1,x:5,y:5,x2:5,y2:1},a.grid),xAxis:[{type:a.xAxisTypeIsTime?"time":r,boundaryGap:!1,axisLabel:!1,splitLine:!1}],yAxis:[{boundaryGap:[0,.1],show:!1}],series:[e.makeDataSeries({colors:n,stack:!0})]};"bar"===a.series0Type&&(i.grid.borderWidth=0,i.grid.y2=0,i.xAxis[0].boundaryGap=!0,i.series[0].type="bar");var o=a.data;e.fillAxisData(i,o,a),t.echartOptions=i}]}}]),angular.module("dashing.contextmenu",["mgcrea.ngStrap.dropdown"]).factory("$contextmenu",function(){return{popup:function(e,t){var r=angular.element(e);r.css({left:t.x+"px",top:t.y+"px"}),r.triggerHandler("click")}}}),angular.module("dashing.filters.duration",["dashing.util"]).filter("duration",["dashing.util",function(e){return function(t,r){return e.text.toHumanReadableDuration(t,r)}}]),angular.module("dashing.forms.searchbox",[]).directive("searchbox",function(){return{restrict:"E",templateUrl:"forms/searchbox.html",scope:{placeholder:"@",ngModel:"="}}}),angular.module("dashing.metrics",[]).directive("metrics",function(){return{restrict:"E",templateUrl:"metrics/metrics.html",scope:{caption:"@",help:"@",value:"@",unit:"@",subText:"@"}}}),angular.module("dashing.progressbar",[]).directive("progressbar",function(){return{restrict:"E",templateUrl:"progressbar/progressbar.html",scope:{current:"@",max:"@",colorMapperFn:"="},link:function(e,t,r){function a(t,r){e.usage=r>0?Math.round(100*t/r):-1,e.usageClass=(e.colorMapperFn?e.colorMapperFn:n)(e.usage)}function n(e){return"progress-bar-"+(50>e?"info":75>e?"warning":"danger")}r.$observe("current",function(e){a(Number(e),Number(r.max))}),r.$observe("max",function(e){a(Number(r.current),Number(e))})}}}),angular.module("dashing.property.bytes",["dashing.util"]).directive("bytes",["dashing.util",function(e){return{restrict:"E",templateUrl:"property/bytes.html",scope:{raw:"@"},link:function(t,r,a){a.$observe("raw",function(r){if(-1!==["true","1"].indexOf(a.readable)){var n=e.text.toHumanReadableNumber(Number(r),1024);t.value=n.value,t.unit=n.modifier+a.unit}else t.value=r,t.unit=a.unit})}}}]),angular.module("dashing.property",["mgcrea.ngStrap.tooltip"]).directive("property",function(){return{restrict:"E",templateUrl:"property/property.html",replace:!1,scope:{value:"=valueBind",renderer:"@"},controller:["$scope",function(e){e.$watch("value",function(t){if(t){switch(e.renderer){case"Link":t.href||(e.href=t.text);break;case"Button":t.href&&!t.click&&(e.click=function(){location.href=t.href});break;case"Bytes":if(!t.hasOwnProperty("raw"))return void(e.raw=t)}angular.isObject(t)&&(t.hasOwnProperty("value")&&(console.warn({message:"Ignore `value.value`, because it is a reversed field.",object:t}),delete t.value),angular.merge(e,t))}})}]}}).constant("dsPropertyRenderer",{BUTTON:"Button",BYTES:"Bytes",DATETIME:"DateTime",DURATION:"Duration",INDICATOR:"Indicator",LINK:"Link",NUMBER:"Number",PROGRESS_BAR:"ProgressBar",TAG:"Tag",TEXT:r}),angular.module("dashing.remark",["mgcrea.ngStrap.tooltip"]).directive("remark",function(){return{restrict:"E",templateUrl:"remark/remark.html",scope:{tooltip:"@"},link:function(e,t,r){switch(r.type){case"info":e.fontClass="glyphicon glyphicon-info-sign";break;case"warning":e.fontClass="glyphicon glyphicon-exclamation-sign";break;default:e.fontClass="glyphicon glyphicon-question-sign"}}}}),angular.module("dashing.state.indicator",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("indicator",["dashing.util",function(e){return{restrict:"E",templateUrl:"state/indicator.html",scope:{tooltip:"@",shape:"@"},link:function(t,r,a){a.condition||(a.condition=""),a.$observe("condition",function(r){t.colorStyle=e.bootstrap.conditionToColor(r)}),a.$observe("tooltip",function(e){t.cursorStyle=e?"pointer":"default"})}}}]),angular.module("dashing.state.tag",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("tag",["dashing.util",function(e){return{restrict:"E",templateUrl:"state/tag.html",scope:{href:"@",text:"@",tooltip:"@"},link:function(t,r,a){a.condition||(a.condition=""),a.$observe("condition",function(r){t.labelColorClass=e.bootstrap.conditionToBootstrapLabelClass(r)}),a.$observe("tooltip",function(e){t.href||(t.cursorStyle=e?"pointer":"default")})}}}]),angular.module("dashing.tables.property-table.builder",[]).factory("$propertyTableBuilder",["dsPropertyRenderer",function(e){var t=function(e,t){this.props=e?{renderer:e}:{},t&&this.title(t)};return t.prototype.title=function(e){return this.props.name=e,this},t.prototype.help=function(e){return this.props.help=e,this},t.prototype.value=function(e){return this.props.value=e,this},t.prototype.values=function(e){return Array.isArray(e)||(console.warn("values must be an array"),e=[e]),this.props.values=e,this},t.prototype.done=function(){return this.props},{button:function(r){return new t(e.BUTTON,r)},bytes:function(r){return new t(e.BYTES,r)},datetime:function(r){return new t(e.DATETIME,r)},duration:function(r){return new t(e.DURATION,r)},indicator:function(r){return new t(e.INDICATOR,r)},link:function(r){return new t(e.LINK,r)},number:function(r){return new t(e.NUMBER,r)},progressbar:function(r){return new t(e.PROGRESS_BAR,r)},tag:function(r){return new t(e.TAG,r)},text:function(r){return new t(e.TEXT,r)},$update:function(e,t){angular.forEach(t,function(t,r){var a=Array.isArray(t)?"values":"value";e[r][a]=t})}}}]),angular.module("dashing.tables.property-table",[]).directive("propertyTable",function(){return{restrict:"E",templateUrl:"tables/property-table/property-table.html",scope:{caption:"@",props:"=propsBind",propNameClass:"@",propValueClass:"@"}}}),angular.module("dashing.tables.sortable-table.builder",["dashing.property","dashing.util"]).factory("$sortableTableBuilder",["dashing.util","dsPropertyRenderer",function(e,t){var r=function(e,t){this.props=e?{renderer:e}:{},t&&this.title(t)};return r.prototype.title=function(e){return this.props.name=e,this},r.prototype.key=function(e){return this.props.key=e,this},r.prototype.canSort=function(e){if(!e&&!this.props.key)return void console.warn("Specify a sort key or define column key first!");if(this.props.sortKey=e||this.props.key,this.props.sortKey===this.props.key)switch(this.props.renderer){case t.LINK:this.props.sortKey+=".text";break;case t.INDICATOR:case t.TAG:this.props.sortKey+=".condition";break;case t.PROGRESS_BAR:this.props.sortKey+=".usage";break;case t.BYTES:this.props.sortKey+=".raw";break;case t.BUTTON:return void console.warn('"%s" column is not sortable.')}return this},r.prototype.sortDefault=function(e){return this.props.sortKey?(this.props.defaultSort=e?"reverse":!0,this):void console.warn("Specify a sort key or define column key first!")},r.prototype.sortDefaultDescent=function(){return this.sortDefault(!0)},r.prototype.styleClass=function(e){return this.props.styleClass=e,this},r.prototype.sortBy=function(e){return this.props.sortKey=e,this},r.prototype.unit=function(e){return this.props.unit=e,this},r.prototype.help=function(e){return this.props.help=e,this},r.prototype.vertical=function(){return Array.isArray(this.props.key)&&(this.props.vertical=!0),this},r.prototype.done=function(){return this.props},{button:function(e){return new r(t.BUTTON,e)},bytes:function(e){return new r(t.BYTES,e)},datetime:function(e){return new r(t.DATETIME,e)},duration:function(e){return new r(t.DURATION,e)},indicator:function(e){return new r(t.INDICATOR,e)},link:function(e){return new r(t.LINK,e)},multiple:function(e,t){return new r(t,e)},number:function(e){return new r(t.NUMBER,e)},progressbar:function(e){return new r(t.PROGRESS_BAR,e)},tag:function(e){return new r(t.TAG,e)},text:function(e){return new r(t.TEXT,e)},$check:function(t,r){angular.forEach(t,function(t){var a=e.array.ensureArray(t.key);angular.forEach(a,function(e){r.hasOwnProperty(e)||console.warn("Model does not have a property matches column key `"+t+"`.")})})}}}]),angular.module("dashing.tables.sortable-table",["smart-table"]).directive("sortableTable",function(){return{restrict:"E",templateUrl:"tables/sortable-table/sortable-table.html",scope:{caption:"@",pagination:"@",columns:"=columnsBind",records:"=recordsBind",search:"=searchBind"},link:function(e,t){var a=t.find("input")[0];e.$watch("search",function(e){a.value=e||"",angular.element(a).triggerHandler("input")}),e.$watch("columns",function(t){return Array.isArray(t)?(e.columnStyleClass=t.map(function(e){function t(e,t,r){r&&e.push(t)}var a=[];return t(a,e.styleClass,e.styleClass!==r),t(a,"text-right","Number"===e.renderer),t(a,"text-nowrap",Array.isArray(e.key)&&!e.vertical),a.join(" ")}),void(e.multipleRendererColumnsRenderers=t.map(function(e){return Array.isArray(e.key)?Array.isArray(e.renderer)?(e.renderer.length!==e.key.length&&console.warn("Every column key should have a renderer, or share one renderer."),e.renderer):e.key.map(function(){return e.renderer}):null}))):void console.warn("Failed to create table, until columns are defined.")}),e.isArray=Array.isArray}}}).directive("stSummary",function(){return{require:"^stTable",template:"Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records",link:function(e,t,r,a){e.stRange={from:null,to:null},e.$watch("currentPage",function(){var t=a.tableState().pagination;e.stRange.from=t.start+1,e.stRange.to=e.currentPage===t.numberOfPages?t.totalItemCount:e.stRange.from+e.stItemsByPage-1})}}}).config(["stConfig",function(e){e.sort.skipNatural=!0}]),angular.module("dashing.tabset",[]).directive("tabset",[function(){return{restrict:"E",templateUrl:"tabset/tabset.html",transclude:!0,scope:!0,controller:["$scope",function(e){function t(e,t){angular.forEach(a,function(t){t.selected=t===e}),e.load!==r&&e.load(t)}var a=e.tabs=[];this.addTab=function(e){a.push(e),1===a.length&&t(e)},e.selectTab=function(e,r){e>=0&&e<a.length&&t(a[e],r)}}]}}]).directive("tab",["$http","$controller","$compile",function(e,t,r){return{restrict:"E",require:"^tabset",template:'<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',replace:!0,transclude:!0,link:function(a,n,i,o){function s(e){n.html(e);var o=a.$new(!1);if(i.controller){var s=t(i.controller,{$scope:o});n.children().data("$ngController",s)}r(n.contents())(o),a.loaded=!0}a.heading=i.heading,a.loaded=!1,a.load=function(t){(!a.loaded||t)&&i.template&&e.get(i.template).then(function(e){s(e.data)})},o.addTab(a)}}}]),angular.module("dashing.util.array",[]).factory("dashing.util.array",function(){return{alignArray:function(e,t,r){if(t<=e.length)return e.slice(0,t);for(var a=angular.copy(e),n=a.length;t>n;n++)a.push(r);
return a},repeatArray:function(e,t){if(t<=e.length)return e.slice(0,t);for(var r=[],a=0;t>a;a++)r.push(e[a%e.length]);return r},ensureArray:function(e){return Array.isArray(e)?e:[e]}}}),angular.module("dashing.util.bootstrap",[]).factory("dashing.util.bootstrap",function(){return{conditionToBootstrapLabelClass:function(e){switch(e){case"good":return"label-success";case"concern":return"label-warning";case"danger":return"label-danger";default:return"label-default"}},conditionToColor:function(e){switch(e){case"good":return"#5cb85c";case"concern":return"#f0ad4e";case"danger":return"#d9534f";default:return"#aaa"}}}}),angular.module("dashing.util.color",[]).factory("dashing.util.color",function(){return{palette:{blue:"rgb(0,119,215)",blueishGreen:"rgb(41,189,181)",orange:"rgb(255,127,80)",purple:"rgb(110,119,215)",skyBlue:"rgb(91,204,246)",darkBlue:"rgb(102,168,212)",darkGray:"rgb(92,92,97)",darkPink:"rgb(212,102,138)",darkRed:"rgb(212,102,138)",lightBlue:"rgb(149,206,255)",lightGreen:"rgb(169,255,150)"}}}),angular.module("dashing.util.text",[]).factory("dashing.util.text",function(){return{toHumanReadableNumber:function(e,t,r){var a="";if(0!==e){1024!==t&&(t=1e3);var n=e>0,i=Math.abs(e),o=["","K","M","G","T","P","E","Z","Y"],s=Math.floor(Math.log(i)/Math.log(t));e=i/Math.pow(t,s),angular.isNumber(r)&&e!==Math.floor(e)&&(e=e.toFixed(r)),n||(e*=-1),a=o[s]}return{value:e,modifier:a}},toHumanReadableDuration:function(e,t){var r=parseInt(e,10);if(isNaN(r))return e;for(var a=[{label:" ms",mod:1e3},{label:t?"s":" secs",mod:60},{label:t?"m":" mins",mod:60},{label:t?"h":" hours",mod:24},{label:t?"d":" days",mod:7},{label:t?"w":" weeks",mod:52}],n=[],i=0;i<a.length;i++){var o=a[i],s=r%o.mod;0!==s&&n.unshift({label:o.label,value:s}),r=(r-s)/o.mod}return n=n.slice(0,2),n.length>1&&" ms"===n[1].label&&(n=[n[0]]),n.map(function(e){return e.value+e.label}).join(t?" ":" and ")}}}),angular.module("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text"]).factory("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text",function(e,t,r,a){return{array:e,bootstrap:t,color:r,text:a}}])}(window,document);
//# sourceMappingURL=dashing.min.js.map