/*! dashing (assembled widgets) v0.2.7 | Apache License 2.0 | github.com/stanleyxu2005/dashing */
(function(window, document, undefined) {
'use strict';
angular.module('dashing', [
  'dashing.charts.bar',
  'dashing.charts.line',
  'dashing.charts.metrics_sparkline',
  'dashing.charts.ring',
  'dashing.charts.sparkline',
  'dashing.forms.form_control',
  'dashing.forms.searchbox',
  'dashing.metrics',
  'dashing.progressbar',
  'dashing.property',
  'dashing.property.bytes',
  'dashing.remark',
  'dashing.state.indicator',
  'dashing.state.tag',
  'dashing.tables.property_table',
  'dashing.tables.sortable_table',
  'dashing.tabset',
  'dashing.contextmenu',
  'dashing.tables.property_table.builder',
  'dashing.tables.sortable_table.builder',
  'dashing.filters.any',
  'dashing.filters.duration'
]);
angular.module('dashing').run(['$templateCache',
  function($templateCache) {
    $templateCache.put('charts/metrics_sparkline_td.html', '<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>');
    $templateCache.put('forms/form_controls.html', '<div class="form-group"> <label class="col-sm-3 control-label text-right" ng-bind="label"></label> <ng-switch on="renderAs">  <div ng-switch-when="text"> <div class="col-sm-8"> <div ng-class="{\'has-error\': !pristine && invalid, \'has-feedback\': choicesMenu}"> <input class="form-control input-sm" type="text" ng-model="$parent.value" reset-search-input="false">  <button ng-if="choicesMenu" type="button" class="btn btn-sm form-control-feedback" style="height: 28px; line-height: 100%; padding: 0 0 2px 0; right: 1px" bs-dropdown="choicesMenu" html="true"> <span class="glyphicon glyphicon-search"></span> </button> </div> </div> </div>  <div ng-switch-when="choices"> <div class="col-sm-8"> <ui-select theme="select2" class="form-control" ng-model="$parent.$parent.value" search-enabled="allowSearchInChoices"> <ui-select-match>{{$select.selected.text}}</ui-select-match> <ui-select-choices repeat="choice in choices|\n          any: {text: $select.search, subtext: $select.search}"> <div ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.text|highlight:$select.search"></div> <small ng-if="choice.subtext" ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.subtext|highlight:$select.search"></small> </ui-select-choices> </ui-select> </div> </div>  <div ng-switch-when="radio"> <div class="col-sm-8"> <div class="btn-group btn-group-justified"> <div ng-repeat="choice in choices track by $index" class="btn-group"> <button type="button" class="btn {{buttonStyleClass}} btn-default" ng-class="{\'btn-primary\': choice.value == value}" ng-bind="choice.text" value="{{choice.value}}" ng-click="toggle(choice.value)"></button> </div> </div> </div> </div>  <div ng-switch-when="number"> <div class="col-sm-4" style="padding-right: 8px" ng-class="{\'has-error\': !pristine && invalid}"> <input class="form-control input-sm" type="number" ng-attr-min="{{min}}" ng-model="$parent.value"> </div> </div>  <div ng-switch-when="datetime"> <div class="col-sm-4" style="padding-right: 8px" ng-class="{\'has-error\': dateInputInvalid}"> <input class="form-control input-sm" data-date-format="yyyy-MM-dd" type="text" size="10" placeholder="Date" ng-model="$parent.dateValue" date-type="string" data-autoclose="1" bs-datepicker> </div> <div class="col-sm-4" style="padding-left: 0" ng-class="{\'has-error\': timeInputInvalid}"> <input class="form-control input-sm" data-time-format="HH:mm:ss" type="text" size="8" placeholder="Time" ng-click="fillDefaultTime()" ng-model="$parent.timeValue" time-type="string" hour-step="-1" minute-step="-1" second-step="-1" arrow-behavior="picker" bs-timepicker> </div> </div> </ng-switch> </div>');
    $templateCache.put('forms/searchbox.html', '<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <span class="glyphicon glyphicon-search form-control-feedback"></span> </div>');
    $templateCache.put('metrics/metrics.html', '<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="question" tooltip="{{help}}"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <small ng-bind="unit"></small> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>');
    $templateCache.put('progressbar/progressbar.html', '<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>');
    $templateCache.put('property/bytes.html', '<div> <span ng-bind="value|number:0"></span> <span ng-if="unit" ng-bind="unit"></span> </div>');
    $templateCache.put('property/property.html', '<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <bytes ng-switch-when="Bytes" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-readable="{{readable}}"></bytes>  <div ng-switch-when="Duration" ng-bind="value|duration"></div>  <div ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:mm:ss\'"></div>  <div ng-switch-when="Number" ng-bind="value|number:0"></div>  <div ng-switch-default ng-bind="value"></div> </ng-switch>');
    $templateCache.put('remark/remark.html', '<span class="{{fontClass}} remark-icon" bs-tooltip="tooltip" ng-attr-placement="{{placement}}"></span>');
    $templateCache.put('state/indicator.html', '<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle, \'cursor\': cursorStyle}" style="display: inline-block; height: 100%; width: 8px" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>');
    $templateCache.put('state/tag.html', '<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>');
    $templateCache.put('tables/property_table/property_table.html', '<table class="table table-striped table-hover"> <caption ng-if="caption" ng-bind="caption"></caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>');
    $templateCache.put('tables/sortable_table/sortable_table.html', '<table class="table table-striped table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption" ng-bind="caption"></caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody> <tr ng-repeat="record in showing track by $index"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="records !== null && !showing.length"> <td colspan="{{columns.length}}" class="text-center"> <i>No data found</i> </td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable_table/sortable_table_pagination.html"> </td> </tr> </tfoot> </table>');
    $templateCache.put('tables/sortable_table/sortable_table_pagination.html', '<div class="pull-left"> <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs">  <button type="button" class="btn btn-default" ng-class="{disabled:1==currentPage}" ng-click="selectPage(currentPage-1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active:page==currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button type="button" class="btn btn-default" ng-class="{disabled:numPages==currentPage}" ng-click="selectPage(currentPage+1)"> &raquo;</button>  </div> </div>');
    $templateCache.put('tabset/tabset.html', '<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>');
  }
]);
angular.module('dashing.charts.bar', [
  'dashing.charts.echarts'
])
  .directive('barChart', ['$echarts',
    function($echarts) {
      return {
        restrict: 'E',
        template: '<echart options="::echartOptions"></echart>',
        scope: {
          options: '=optionsBind',
          data: '=datasourceBind'
        },
        link: function(scope) {
          var echartScope = scope.$$childHead;
          scope.$watch('data', function(data) {
            if (data) {
              echartScope.addDataPoints(data);
            }
          });
        },
        controller: ['$scope', '$element',
          function($scope, $element) {
            var use = angular.merge({
              yAxisSplitNum: 3,
              yAxisShowMinorAxisLine: false,
              yAxisLabelWidth: 60,
              yAxisLabelFormatter: $echarts.axisLabelFormatter(''),
              yBoundaryGap: [0.2, 0.2],
              static: true,
              rotate: false,
              xAxisShowLabels: true
            }, $scope.options);
            use = angular.merge({
              barMaxWidth: use.rotate ? 20 : 16,
              barMinWidth: use.rotate ? 8 : 7,
              barMaxSpacing: 4,
              barMinSpacing: 1
            }, use);
            var data = use.data;
            if (!Array.isArray(data)) {
              console.warn({
                message: 'Initial data is expected to be an array',
                data: data
              });
              data = data ? [data] : [];
            }
            $echarts.validateSeriesNames(use, data);
            if (!Array.isArray(use.colors) || !use.colors.length) {
              use.colors = $echarts.barChartColorRecommendation(
                use.seriesNames.length || 1);
            }
            var colors = use.colors.map(function(base) {
              return $echarts.buildColorStates(base);
            });
            var axisColor = colors.length > 1 ? '#999' : colors[0].line;
            var options = {
              height: use.height,
              width: use.width,
              tooltip: angular.merge(
                $echarts.categoryTooltip(use.valueFormatter), {
                  axisPointer: {
                    type: 'shadow',
                    shadowStyle: {
                      color: 'rgba(225,225,225,0.3)'
                    }
                  }
                }),
              grid: angular.merge({
                borderWidth: 0,
                x: Math.max(15, use.yAxisLabelWidth),
                y: 15,
                y2: 28
              }, use.grid),
              xAxis: [{
                axisLabel: {
                  show: true
                },
                axisLine: {
                  show: true,
                  lineStyle: {
                    width: 1,
                    color: axisColor,
                    type: 'dotted'
                  }
                },
                axisTick: false,
                splitLine: false
              }],
              yAxis: [{
                type: 'value',
                splitNumber: use.yAxisSplitNum,
                splitLine: {
                  show: use.yAxisShowMinorAxisLine,
                  lineStyle: {
                    color: axisColor,
                    type: 'dotted'
                  }
                },
                axisLine: false,
                axisLabel: {
                  formatter: use.yAxisLabelFormatter
                }
              }],
              series: use.seriesNames.map(function(name, i) {
                return $echarts.makeDataSeries({
                  type: 'bar',
                  name: name,
                  stack: true,
                  colors: colors[i]
                });
              }),
              color: use.colors
            };
            if (use.static) {
              delete use.visibleDataPointsNum;
            }
            $echarts.fillAxisData(options, data, use);
            if (use.static) {
              options.visibleDataPointsNum = -1;
            }
            if (use.rotate) {
              var axisSwap = options.xAxis;
              options.xAxis = angular.copy(options.yAxis);
              options.xAxis[0].type = options.xAxis[0].type || 'value';
              options.yAxis = axisSwap;
              options.yAxis[0].type = options.yAxis[0].type || 'category';
            }
            if (!use.xAxisShowLabels) {
              options.xAxis[0].axisLabel = false;
              options.grid.y2 = options.grid.y;
            }
            if (use.static) {
              var drawBarMinWidth = use.barMinWidth + use.barMinSpacing;
              var drawBarMaxWidth = use.barMaxWidth + use.barMaxSpacing;
              var drawAllBarMinWidth = data.length * drawBarMinWidth;
              var drawAllBarMaxWidth = data.length * drawBarMaxWidth;
              var chartHeight = parseInt(use.height);
              if (use.rotate) {
                var gridMarginY = options.grid.borderWidth * 2 + options.grid.y + options.grid.y2;
                if (chartHeight < gridMarginY + drawAllBarMinWidth) {
                  console.info('Increased the height to ' + (gridMarginY + drawAllBarMinWidth) + 'px, ' +
                    'because rotated bar chart does not support data zoom yet.');
                  options.height = (gridMarginY + drawAllBarMinWidth) + 'px';
                } else if (chartHeight > gridMarginY + drawAllBarMaxWidth) {
                  options.height = (gridMarginY + drawAllBarMaxWidth) + 'px';
                }
              } else {
                var gridMarginX = options.grid.borderWidth * 2 + options.grid.x + options.grid.x2;
                var chartControlWidth = angular.element($element[0]).children()[0].offsetWidth;
                var visibleWidthForBars = chartControlWidth - gridMarginX;
                if (drawAllBarMinWidth > 0 && drawAllBarMinWidth > visibleWidthForBars) {
                  var roundedVisibleWidthForBars = Math.floor(visibleWidthForBars / drawBarMinWidth) * drawBarMinWidth;
                  options.grid.x2 += visibleWidthForBars - roundedVisibleWidthForBars;
                  var scrollbarHeight = 20;
                  var scrollbarGridMargin = 5;
                  options.dataZoom = {
                    show: true,
                    end: roundedVisibleWidthForBars * 100 / drawAllBarMinWidth,
                    realtime: true,
                    height: scrollbarHeight,
                    y: chartHeight - scrollbarHeight - scrollbarGridMargin,
                    handleColor: axisColor
                  };
                  options.dataZoom.fillerColor =
                    zrender.tool.color.alpha(options.dataZoom.handleColor, 0.08);
                  options.grid.y2 += scrollbarHeight + scrollbarGridMargin * 2;
                } else if (data.length) {
                  if (visibleWidthForBars > drawAllBarMaxWidth) {
                    options.grid.x2 += chartControlWidth - drawAllBarMaxWidth - gridMarginX;
                  }
                }
              }
            }
            $scope.echartOptions = options;
          }
        ]
      };
    }
  ]);
angular.module('dashing.charts.echarts', [
  'dashing.util'
])
  .directive('echart', ['dashing.util',
    function(util) {
      function makeDataArray(data, seriesNum, dataPointsGrowNum, xAxisTypeIsTime) {
        var array = [];
        angular.forEach(util.array.ensureArray(data), function(datum) {
          var dataGrow = dataPointsGrowNum-- > 0;
          var yValues = util.array.ensureArray(datum.y).slice(0, seriesNum);
          if (xAxisTypeIsTime) {
            angular.forEach(yValues, function(yValue, seriesIndex) {
              var params = [seriesIndex, [datum.x, yValue], false, dataGrow];
              array.push(params);
            });
          } else {
            var lastSeriesIndex = yValues.length - 1;
            angular.forEach(yValues, function(yValue, seriesIndex) {
              var params = [seriesIndex, yValue, false, dataGrow];
              if (seriesIndex === lastSeriesIndex) {
                params.push(datum.x);
              }
              array.push(params);
            });
          }
        });
        return array;
      }
      return {
        restrict: 'E',
        template: '<div></div>',
        replace: true,
        scope: {
          options: '='
        },
        controller: ['$scope', '$element', 'dsEchartsDefaults', '$echarts',
          function($scope, $element, defaults, $echarts) {
            var options = $scope.options;
            var elem0 = $element[0];
            angular.forEach(['width', 'height'], function(prop) {
              if (options[prop]) {
                elem0.style[prop] = options[prop];
              }
            });
            var chart = echarts.init(elem0);
            angular.element(window).on('resize', chart.resize);
            $scope.$on('$destroy', function() {
              angular.element(window).off('resize', chart.resize);
            });
            $scope.$on('$destroy', function() {
              chart.dispose();
              chart = null;
            });
            chart.setTheme(defaults.lookAndFeel);
            chart.setOption(options, true);
            if (angular.isFunction(chart.group) && options.hasOwnProperty('groupId')) {
              chart.groupId = options.groupId;
              chart.group();
            }
            var initialized = angular.isDefined(chart.getOption().xAxis);
            function initializeDoneCheck() {
              if (initialized) {
                if (options.dataPointsQueue && options.dataPointsQueue.length) {
                  addDataPoints(options.dataPointsQueue);
                  delete options.dataPointsQueue;
                }
                delete options.data;
              }
            }
            initializeDoneCheck();
            function addDataPoints(data, newYAxisMaxValue) {
              if (!data || (Array.isArray(data) && !data.length)) {
                return;
              }
              try {
                if (!initialized) {
                  $echarts.fillAxisData(options, util.array.ensureArray(data));
                  chart.setOption(options, true);
                  initialized = angular.isDefined(chart.getOption().xAxis);
                  initializeDoneCheck();
                  if (initialized) {
                    chart.hideLoading();
                  }
                  return;
                }
                var currentOption = chart.getOption();
                var actualVisibleDataPoints = currentOption.series[0].data.length;
                var dataPointsGrowNum = Math.max(0, (currentOption.visibleDataPointsNum || defaults.visibleDataPointsNum) - actualVisibleDataPoints);
                var xAxisTypeIsTime = (currentOption.xAxis[0].type === 'time') ||
                  (currentOption.xAxis[0].type === 'value' && currentOption.yAxis[0].type === 'time');
                var seriesNum = currentOption.series.length;
                var dataArray = makeDataArray(data, seriesNum, dataPointsGrowNum, xAxisTypeIsTime);
                if (dataArray.length > 0) {
                  if (newYAxisMaxValue !== undefined) {
                    chart.setOption({
                      yAxis: [{
                        max: newYAxisMaxValue
                      }]
                    }, false);
                  }
                  chart.addData(dataArray);
                }
              } catch (ex) {}
            }
            $scope.addDataPoints = addDataPoints;
            $scope.getChartControl = function() {
              return chart;
            };
          }
        ]
      };
    }
  ])
  .constant('dsEchartsDefaults', {
    lookAndFeel: {
      markLine: {
        symbol: ['circle', 'circle']
      },
      title: {
        textStyle: {
          fontSize: 14,
          fontWeight: 400,
          color: '#000'
        }
      },
      legend: {
        textStyle: {
          color: '#111',
          fontWeight: 500
        },
        itemGap: 20
      },
      tooltip: {
        borderRadius: 2,
        padding: 0,
        showDelay: 0,
        transitionDuration: 0.5
      },
      textStyle: {
        fontFamily: 'Roboto,"Helvetica Neue","Segoe UI","Hiragino Sans GB","Microsoft YaHei",Arial,Helvetica,SimSun,sans-serif',
        fontSize: 12
      },
      loadingText: 'Data Loading...',
      noDataText: 'No Graphic Data Available',
      addDataAnimation: false
    },
    visibleDataPointsNum: 80
  })
  .factory('$echarts', ['$filter', 'dashing.util',
    function($filter, util) {
      function buildTooltipSeriesTable(name, array, use) {
        function tooltipSeriesColorIndicatorHtml(color) {
          var border = zrender.tool.color.lift(color, -0.2);
          return '<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid ' + border + '; background-color: ' + color + '"></div>';
        }
        function mergeValuesAndSortDescent(array) {
          var grouped = {};
          angular.forEach(array, function(point) {
            grouped[point.name] = grouped[point.name] || [];
            grouped[point.name].push(point);
          });
          var result = [];
          angular.forEach(grouped, function(group) {
            var selected = group.reduce(function(p, c) {
              return Math.abs(p.value) > Math.abs(c.value) ? p : c;
            });
            selected.value = group.reduce(function(p, c) {
              return {
                value: p.value + c.value
              };
            }).value;
            result.push(selected);
          });
          return $filter('orderBy')(result, 'value', true);
        }
        var valueFormatter = use.valueFormatter || defaultValueFormatter;
        return '<div style="padding: 8px">' + [
          (use.nameFormatter || defaultNameFormatter)(name),
          '<table>' +
          mergeValuesAndSortDescent(array).map(function(point) {
            if (point.value === '-') {
              return '';
            } else {
              point.value = valueFormatter(point.value);
            }
            if (!point.name) {
              point.name = point.value;
              point.value = '';
            }
            return '<tr>' +
              '<td>' + tooltipSeriesColorIndicatorHtml(point.color) + '</td>' +
              '<td style="padding: 0 12px 0 4px">' + point.name + '</td>' +
              '<td style="text-align: right">' + point.value + '</td>' +
              '</tr>';
          }).join('') +
          '</table>'
        ].join('') +
          '</div>';
      }
      function defaultNameFormatter(name) {
        if (angular.isDate(name)) {
          var now = new Date();
          return $filter('date')(name, (now.getYear() === name.getYear() &&
              now.getMonth() === name.getMonth() &&
              now.getDay() === name.getDay()) ?
            'HH:mm:ss' : 'yyyy-MM-dd HH:mm:ss');
        }
        return name;
      }
      function defaultValueFormatter(value) {
        return $filter('number')(value);
      }
      function tooltip(args) {
        return {
          trigger: args.trigger || 'axis',
          axisPointer: {
            type: 'none'
          },
          formatter: args.formatter
        };
      }
      function splitInitialData(data, visibleDataPoints) {
        if (!Array.isArray(data)) {
          data = [];
        }
        if (!visibleDataPoints || data.length <= visibleDataPoints) {
          return {
            older: data,
            newer: []
          };
        }
        return {
          older: data.slice(0, visibleDataPoints),
          newer: data.slice(visibleDataPoints)
        };
      }
      return {
        categoryTooltip: function(valueFormatter, nameFormatter) {
          return tooltip({
            trigger: 'axis',
            formatter: function(params) {
              params = util.array.ensureArray(params);
              var name = params[0].name;
              var array = params.map(function(param) {
                return {
                  color: param.series.colors.line,
                  name: param.seriesName,
                  value: param.value
                };
              });
              if (!name.length && !array.filter(function(point) {
                return point.value !== '-';
              }).length) {
                return '';
              }
              var args = {
                nameFormatter: nameFormatter,
                valueFormatter: valueFormatter
              };
              return buildTooltipSeriesTable(name, array, args);
            }
          });
        },
        timelineChartFix: function(options, use) {
          console.warn('Echarts does not have a good experience for time series. ' +
            'We suggest to use category as x-axis type.');
          options.tooltip = tooltip({
            trigger: 'item',
            formatter: function(params) {
              var array = [{
                color: params.series.colors.line,
                name: params.series.name,
                value: params.value[1]
              }];
              return buildTooltipSeriesTable(params.value[0], array, use);
            }
          });
          angular.forEach(options.xAxis, function(axis) {
            delete axis.boundaryGap;
          });
          angular.forEach(options.series, function(series) {
            series.showAllSymbol = true;
            series.stack = false;
          });
        },
        validateSeriesNames: function(use, data) {
          if (!use.seriesNames) {
            var first = util.array.ensureArray(data[0].y);
            if (first.length > 1) {
              console.warn({
                message: 'You should define `options.seriesNames`',
                options: use
              });
            }
            use.seriesNames = first.map(function(_, i) {
              return 'Series ' + (i + 1);
            });
          }
        },
        axisLabelFormatter: function(unit) {
          return function(value) {
            if (angular.isNumber(value)) {
              value = Number(value);
              if (value !== 0) {
                var hr = util.text.toHumanReadableNumber(value, 1000, 1);
                value = hr.value + (unit ? ' ' + hr.modifier + unit : hr.modifier.toLowerCase());
              }
            }
            return value;
          };
        },
        makeDataSeries: function(args) {
          var options = {
            type: args.type || 'line',
            symbol: 'circle',
            symbolSize: 4,
            smooth: args.smooth,
            itemStyle: {
              normal: {
                color: args.colors.line,
                lineStyle: {
                  width: args.stack ? 4 : 3
                },
                borderColor: 'transparent',
                borderWidth: 6
              },
              emphasis: {
                color: args.colors.hover,
                borderColor: zrender.tool.color.alpha(args.colors.line, 0.3)
              }
            }
          };
          if (args.stack) {
            options.itemStyle.normal.areaStyle = {
              type: 'default',
              color: args.colors.area
            };
          } else if (args.showAllSymbol) {
            options.itemStyle.normal.lineStyle.width -= 1;
          }
          return angular.merge(args, options);
        },
        fillAxisData: function(options, data, inputs) {
          data = data || [];
          options.grid.x2 = options.grid.x;
          if (angular.isObject(inputs)) {
            if (angular.isString(inputs.groupId) && inputs.groupId.length) {
              options.groupId = inputs.groupId;
            }
            if (inputs.visibleDataPointsNum > 0) {
              options.visibleDataPointsNum = inputs.visibleDataPointsNum;
              var placeholder = {
                x: '',
                y: options.series.map(function() {
                  return {
                    value: '-',
                    tooltip: {}
                  };
                })
              };
              while (data.length < inputs.visibleDataPointsNum) {
                data.unshift(placeholder);
              }
            }
          }
          var dataSplit = splitInitialData(data, options.visibleDataPointsNum);
          if (dataSplit.newer.length) {
            options.dataPointsQueue = dataSplit.newer;
          }
          delete options.xAxis[0].data;
          angular.forEach(options.series, function(series) {
            series.data = [];
          });
          if (options.xAxis[0].type === 'time') {
            angular.forEach(dataSplit.older, function(datum) {
              angular.forEach(options.series, function(series, seriesIndex) {
                series.data.push([datum.x, Array.isArray(datum.y) ? datum.y[seriesIndex] : datum.y]);
              });
            });
          } else {
            var xLabels = [];
            angular.forEach(dataSplit.older, function(datum) {
              xLabels.push(datum.x);
              angular.forEach(options.series, function(series, seriesIndex) {
                series.data.push(Array.isArray(datum.y) ? datum.y[seriesIndex] : datum.y);
              });
            });
            options.xAxis[0].data = xLabels;
          }
        },
        lineChartColorRecommendation: function(seriesNum) {
          var colors = util.color.palette;
          switch (seriesNum) {
            case 1:
              return [colors.blue];
            case 2:
              return [colors.blue, colors.blueishGreen];
            default:
              return util.array.repeatArray([
                colors.blue,
                colors.purple,
                colors.blueishGreen,
                colors.darkRed,
                colors.orange
              ], seriesNum);
          }
        },
        barChartColorRecommendation: function(seriesNum) {
          var colors = util.color.palette;
          switch (seriesNum) {
            case 1:
              return [colors.orange];
            case 2:
              return [colors.blue, colors.darkBlue];
            default:
              return util.array.repeatArray([
                colors.lightGreen,
                colors.darkGray,
                colors.lightBlue,
                colors.blue,
                colors.darkBlue
              ], seriesNum);
          }
        },
        buildColorStates: function(base) {
          return {
            line: base,
            area: zrender.tool.color.lift(base, -0.92),
            hover: zrender.tool.color.lift(base, 0.15)
          };
        }
      };
    }
  ]);
angular.module('dashing.ideas')
  .directive('highchart', function() {
    return {
      restrict: 'E',
      template: '<div></div>',
      replace: true,
      scope: {
        options: '='
      },
      controller: ['$scope', '$element', 'dsHighchartsDefaults',
        function($scope, $element, defaults) {
          var options = $scope.options;
          var elem0 = $element[0];
          angular.forEach(['width', 'height'], function(prop) {
            if (options[prop]) {
              elem0.style[prop] = options[prop];
            }
          });
          var chart = new Highcharts.Chart(
            angular.merge({
              chart: {
                renderTo: elem0
              }
            }, defaults.lookAndFeel, options)
          );
          $scope.$on('$destroy', function() {
            chart.destroy();
            chart = null;
          });
          $scope.addDataPoints = function(data) {
            if (!data || (Array.isArray(data) && !data.length)) {
              return;
            }
            try {
              var visibleDataPointsNum = options.visibleDataPointsNum || defaults.visibleDataPointsNum;
              angular.forEach(chart.series, function(series, i) {
                var shift = series.data.length > visibleDataPointsNum;
                angular.forEach(data, function(datum) {
                  var point = [
                    datum.x,
                    Array.isArray(datum.y) ? datum.y[i] : datum.y
                  ];
                  if (point[1] !== null) {
                    if (!shift) {
                      shift = series.data.length > visibleDataPointsNum;
                    }
                    series.addPoint(point, false, shift);
                  }
                });
              });
              chart.redraw();
            } catch (ex) {
              console.log(ex);
            }
          };
          if (options.dataPointsQueue && options.dataPointsQueue.length) {
            $scope.addDataPoints(options.dataPointsQueue);
            delete options.dataPointsQueue;
          }
          delete options.data;
        }
      ]
    };
  })
  .constant('dsHighchartsDefaults', {
    lookAndFeel: {
      chart: {
        spacingTop: 0,
        spacingBottom: 0,
        style: {
          fontFamily: 'lato,roboto,"helvetica neue","segoe ui",arial'
        }
      },
      credits: {
        enabled: false
      },
      legend: {
        verticalAlign: 'top'
      },
      plotOptions: {
        series: {
          marker: {
            enabled: false
          }
        }
      },
      title: {
        text: null
      },
      tooltip: {
        style: {
          fontSize: 12,
          fontWeight: 500
        }
      },
      xAxis: {
        labels: {
          style: {
            fontSize: 12
          }
        }
      },
      yAxis: {
        title: {
          text: null
        },
        labels: {
          style: {
            fontSize: 12
          }
        }
      }
    },
    visibleDataPointsNum: 80
  })
  .factory('$highcharts', ['$filter', '$util',
    function($filter, $util) {
      Highcharts.setOptions({
        global: {
          useUTC: false
        },
        lang: {
          thousandsSep: ','
        }
      });
      function buildTooltipSeriesTable(array) {
        function tooltipSeriesColorIndicatorHtml(color) {
          var border = zrender.tool.color.lift(color, -0.2);
          return '<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid ' + border + '; background-color: ' + color + '"></div>';
        }
        return '<table style="margin-top: 4px">' +
          array.map(function(obj) {
            if (!obj.name || obj.name === ' ') {
              obj.name = obj.value;
              obj.value = '';
            }
            return '<tr>' +
              '<td>' + tooltipSeriesColorIndicatorHtml(obj.color) + '</td>' +
              '<td style="padding: 0 12px 0 4px">' + obj.name + '</td>' +
              '<td style="text-align: right">' + obj.value + '</td>' +
              '</tr>';
          }).join('') + '</table>';
      }
      function defaultNameFormatter(name) {
        var date = new Date(name);
        if (angular.isDate(date)) {
          return $filter('date')(name, (new Date()).getDate() === date.getDate() ?
            'HH:mm:ss' : 'yyyy-MM-dd HH:mm:ss');
        }
        return name;
      }
      function defaultValueFormatter(value) {
        return $filter('number')(value);
      }
      var self = {
        tooltip: function(args) {
          var result = {
            backgroundColor: 'rgba(0,0,0,0.7)',
            style: {
              color: '#fff'
            },
            borderRadius: 4,
            borderWidth: 0,
            shadow: false,
            followPointer: true
          };
          if (args.guideLineColor) {
            result.crosshairs = {
              width: 3,
              color: args.guideLineColor,
              dashStyle: 'shortdot'
            };
          }
          if (args.formatter) {
            result.formatter = args.formatter;
            result.shared = true;
            result.useHTML = true;
          }
          return result;
        },
        tooltipAllSeriesFormatter: function(valueFormatter, nameFormatter) {
          return function() {
            var name = (nameFormatter || defaultNameFormatter)(this.points[0].key);
            var pointsSorted = $filter('orderBy')(this.points, 'y', true);
            return name +
              buildTooltipSeriesTable(pointsSorted.map(function(point) {
                return {
                  color: point.color,
                  name: point.series.name,
                  value: (valueFormatter || defaultValueFormatter)(point.y)
                };
              }));
          };
        },
        axisBytesLabelFormatter: function(unit) {
          return function() {
            var value = this.value;
            if (value !== 0) {
              var hr = $util.toHumanReadable(value, 1000);
              value = hr.value + ' ' + hr.modifier + (unit || '');
            }
            return value;
          };
        },
        makeDataSeries: function(args) {
          var options = {
            type: args.type,
            name: args.name,
            color: args.colors.line,
            lineWidth: 3,
            marker: {
              symbol: 'circle',
              radius: 3
            },
            animation: false
          };
          if (args.type === 'area') {
            options.fillColor = args.colors.area;
            options.lineWidth -= 1;
          }
          if (args.stack) {
            angular.merge(options, {
              stack: 0,
              stacking: 'normal',
              fillColor: 'transparent' //args.colors.line,
            });
          }
          return options;
        },
        splitInitialData: function(data, visibleDataPointsNum) {
          if (!Array.isArray(data)) {
            data = [];
          }
          if (data.length <= visibleDataPointsNum) {
            return {
              older: data,
              newer: []
            };
          }
          return {
            older: data.slice(0, visibleDataPointsNum),
            newer: data.slice(visibleDataPointsNum)
          };
        },
        fillAxisData: function(options, data) {
          angular.forEach(options.series, function(series) {
            series.data = [];
          });
          angular.forEach(data, function(datum) {
            angular.forEach(options.series, function(series, i) {
              var point = [
                datum.x,
                Array.isArray(datum.y) ? datum.y[i] : datum.y
              ];
              if (point[1] !== null) {
                series.data.push(point);
              }
            });
          });
        },
        colorPalette: function(size) {
          return $util.colorPalette(size).map(function(base) {
            return self.buildColorStates(base);
          });
        },
        buildColorStates: function(base) {
          return {
            line: base,
            area: zrender.tool.color.lift(base, -0.92),
            hover: zrender.tool.color.lift(base, 0.1)
          };
        }
      };
      return self;
    }
  ]);
angular.module('dashing.ideas')
  .directive('lineChart1', function() {
    return {
      restrict: 'E',
      template: '<highchart options="::chartControlOptions"></highchart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var chartControlScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            chartControlScope.addDataPoints(data);
          }
        });
      },
      controller: ['$scope', '$highcharts',
        function($scope, $highcharts) {
          var use = angular.merge({
            yAxisMin: 0,
            yAxisSplitNum: 3,
            xAxisTypeIsTime: false,
            seriesStacked: false
          }, $scope.options);
          var data = $highcharts.splitInitialData(use.data || $scope.data, use.visibleDataPointsNum);
          if (!use.seriesNames) {
            console.warn('Series names are NOT defined.');
            use.seriesNames = data.older[0].y.map(function(_, i) {
              return 'Series ' + (i + 1);
            });
          }
          var colors = $highcharts.colorPalette(use.seriesNames.length);
          var options = {
            height: use.height,
            width: use.width,
            tooltip: $highcharts.tooltip({
              guideLineColor: 'rgb(235,235,235)',
              formatter: $highcharts.tooltipAllSeriesFormatter(use.valueFormatter)
            }),
            xAxis: {
              type: use.xAxisTypeIsTime ? 'datetime' : undefined,
              tickLength: 6,
              lineColor: '#ddd'
            },
            yAxis: {
              min: use.yAxisMin,
              labels: {
                formatter: use.yAxisLabelFormatter
              }
            },
            series: [],
            colors: use.seriesNames.map(function(_, i) {
              return colors[i % colors.length].line;
            }),
            visibleDataPointsNum: use.visibleDataPointsNum,
            dataPointsQueue: data.newer
          };
          if (use.yAxisSplitNum) {
            options.yAxis.tickPixelInterval =
              Math.floor(parseInt(use.height) / use.yAxisSplitNum);
          }
          angular.forEach(use.seriesNames, function(name, i) {
            options.series.push(
              $highcharts.makeDataSeries({
                type: use.seriesStacked ? 'area' : 'line',
                name: name,
                colors: colors[i % colors.length],
                stack: use.seriesStacked
              })
            );
          });
          $highcharts.fillAxisData(options, data.older);
          $scope.chartControlOptions = options;
        }
      ]
    };
  });
angular.module('dashing.ideas')
  .directive('sparklineChart1', function() {
    return {
      restrict: 'E',
      template: '<highchart options="::chartControlOptions"></highchart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var chartControlScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            var filtered = Array.isArray(data) ?
              data.map(function(datum) {
                return {
                  x: datum.x,
                  y: Array.isArray(datum.y) ? datum.y[0] : datum.y
                };
              }) : [data];
            chartControlScope.addDataPoints(filtered);
          }
        });
      },
      controller: ['$scope', '$highcharts',
        function($scope, $highcharts) {
          var use = angular.merge({
            bordered: true
          }, $scope.options);
          var data = $highcharts.splitInitialData(use.data || $scope.data, use.visibleDataPointsNum);
          var colors = $highcharts.colorPalette(1)[0];
          var options = {
            height: use.height,
            width: use.width,
            tooltip: $highcharts.tooltip({
              formatter: $highcharts.tooltipAllSeriesFormatter(use.valueFormatter)
            }),
            xAxis: {
              type: use.xAxisTypeIsTime ? 'datetime' : undefined,
              labels: {
                enabled: false
              },
              title: {
                text: null
              },
              startOnTick: false,
              endOnTick: false,
              tickPositions: []
            },
            yAxis: {
              labels: {
                enabled: false
              },
              title: {
                text: null
              },
              endOnTick: false,
              startOnTick: false,
              tickPositions: []
            },
            series: [$highcharts.makeDataSeries({
              type: 'area',
              name: (use.seriesName && use.seriesName.length) ?
                use.seriesName[0] : ' ',
              colors: colors
            })],
            chart: {
              spacingTop: 10
            },
            legend: {
              enabled: false
            },
            plotOptions: {
              series: {
                states: {
                  hover: {
                    lineWidth: 2
                  }
                }
              }
            },
            visibleDataPointsNum: use.visibleDataPointsNum,
            dataPointsQueue: data.newer
          };
          if (use.bordered) {
            angular.merge(options, {
              chart: {
                borderWidth: 1,
                borderColor: '#ddd',
                spacingBottom: 3,
                spacingLeft: -2,
                spacingRight: -1
              }
            });
          }
          $highcharts.fillAxisData(options, data.older);
          $scope.chartControlOptions = options;
        }
      ]
    };
  });
angular.module('dashing.charts.line', [
  'dashing.charts.echarts'
])
  .directive('lineChart', function() {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions" data="data"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          if (data) {
            echartScope.addDataPoints(data);
          }
        });
      },
      controller: ['$scope', '$echarts',
        function($scope, $echarts) {
          var use = angular.merge({
            seriesStacked: true,
            seriesLineSmooth: false,
            showLegend: true,
            yAxisSplitNum: 3,
            yAxisShowSplitLine: true,
            yAxisLabelWidth: 60,
            yAxisLabelFormatter: $echarts.axisLabelFormatter(''),
            yAxisScaled: false,
            xAxisShowLabels: true
          }, $scope.options);
          var data = use.data;
          $echarts.validateSeriesNames(use, data);
          if (!Array.isArray(use.colors) || !use.colors.length) {
            use.colors = $echarts.lineChartColorRecommendation(
              use.seriesNames.length || 1);
          }
          var colors = use.colors.map(function(base) {
            return $echarts.buildColorStates(base);
          });
          var axisColor = '#ccc';
          var borderLineStyle = {
            length: 4,
            lineStyle: {
              width: 1,
              color: axisColor
            }
          };
          var options = {
            height: use.height,
            width: use.width,
            tooltip: angular.merge(
              $echarts.categoryTooltip(use.valueFormatter), {
                axisPointer: {
                  type: 'line',
                  lineStyle: {
                    width: 3,
                    color: 'rgb(235,235,235)',
                    type: 'dotted'
                  }
                }
              }),
            grid: angular.merge({
              borderWidth: 0,
              x: Math.max(15, use.yAxisLabelWidth),
              y: 20,
              y2: 25
            }, use.grid),
            xAxis: [{
              type: use.xAxisTypeIsTime ? 'time' : undefined,
              boundaryGap: use.xAxisBoundaryGap,
              axisLine: angular.merge({
                onZero: false
              }, borderLineStyle),
              axisTick: borderLineStyle,
              axisLabel: {
                show: true
              },
              splitLine: false
            }],
            yAxis: [{
              splitNumber: use.yAxisSplitNum,
              splitLine: {
                show: use.yAxisShowSplitLine,
                lineStyle: {
                  color: axisColor,
                  type: 'dotted'
                }
              },
              axisLine: false,
              axisLabel: {
                formatter: use.yAxisLabelFormatter
              },
              scale: use.yAxisScaled
            }],
            series: use.seriesNames.map(function(name, i) {
              return $echarts.makeDataSeries({
                name: name,
                colors: colors[i],
                stack: use.seriesStacked,
                smooth: use.seriesLineSmooth,
                showAllSymbol: use.showAllSymbol,
                yAxisIndex: Array.isArray(use.seriesYAxisIndex) ?
                  use.seriesYAxisIndex[i] : 0
              });
            }),
            color: use.colors
          };
          if (_.contains(use.seriesYAxisIndex, 1)) {
            var yAxis2 = angular.copy(options.yAxis[0]);
            if (angular.isFunction(use.yAxis2LabelFormatter)) {
              yAxis2.axisLabel.formatter = use.yAxis2LabelFormatter;
            }
            options.yAxis.push(yAxis2);
            options.grid.x2 = options.grid.x;
          }
          $echarts.fillAxisData(options, data, use);
          if (!use.xAxisShowLabels) {
            options.xAxis[0].axisLabel = false;
            options.grid.y2 = options.grid.y;
          }
          if (use.xAxisTypeIsTime) {
            $echarts.timelineChartFix(options, use);
          }
          if (options.series.length === 1) {
            options.yAxis.boundaryGap = [0, 0.1];
          }
          var titleHeight = 20;
          var legendHeight = 16;
          if (use.title) {
            options.title = {
              text: use.title,
              x: 0,
              y: 3
            };
            options.grid.y += titleHeight;
          }
          var addLegend = options.series.length > 1 && use.showLegend;
          if (addLegend) {
            options.legend = {
              show: true,
              itemWidth: 8,
              data: options.series.map(function(series) {
                return series.name;
              })
            };
            options.legend.y = 6;
            if (use.title) {
              options.legend.y += titleHeight;
              options.grid.y += legendHeight;
            }
          }
          if (addLegend || use.title) {
            options.grid.y += 12;
          }
          $scope.echartOptions = options;
        }
      ]
    };
  });
angular.module('dashing.charts.metrics_sparkline', [
  'dashing.charts.sparkline',
  'dashing.metrics'
])
  .directive('metricsSparklineChartTd', function() {
    return {
      restrict: 'E',
      templateUrl: 'charts/metrics_sparkline_td.html',
      scope: {
        caption: '@',
        help: '@',
        current: '@',
        unit: '@',
        subText: '@',
        options: '=optionsBind',
        data: '=datasourceBind'
      }
    };
  });
angular.module('dashing.charts.ring', [
  'dashing.charts.echarts'
])
  .directive('ringChart', function() {
    return {
      restrict: 'E',
      template: '<echart options="::echartOptions"></echart>',
      scope: {
        options: '=optionsBind',
        data: '=datasourceBind'
      },
      link: function(scope) {
        var echartScope = scope.$$childHead;
        scope.$watch('data', function(data) {
          var chartControl = echartScope.getChartControl();
          chartControl.setOption({
            series: [{
              data: [{
                value: data.available.value
              }, {
                value: data.used.value
              }]
            }]
          });
        });
      },
      controller: ['$scope', '$element', '$echarts',
        function($scope, $element, $echarts) {
          var use = angular.merge({
            color: 'rgb(35,183,229)',
            thickness: 0.25
          }, $scope.options);
          if (!angular.isNumber(use.thickness) || use.thickness > 1 || use.thickness <= 0) {
            console.warn({
              message: 'Invalid thickness value',
              value: use.thickness
            });
            use.thickness = 0.25;
          }
          var data = use.data || $scope.data;
          if (!data) {
            console.warn('Need data to render the ring pie chart.');
          }
          var colors = $echarts.buildColorStates(use.color);
          var padding = 8;
          var outerRadius = (parseInt(use.height) - 30 - padding * 2) / 2;
          var innerRadius = Math.floor(outerRadius * (1 - use.thickness));
          var innerTextFontSize = Math.floor(28 * innerRadius / 39);
          if (innerTextFontSize < 12) {
            console.warn('Please increase the height to get a better visual experience.');
          }
          var itemStyleBase = {
            normal: {
              color: 'rgb(232,239,240)',
              label: {
                show: true,
                position: 'center'
              },
              labelLine: false
            }
          };
          var options = {
            height: use.height,
            width: use.width,
            grid: {
              borderWidth: 0
            },
            xAxis: [{
              show: false,
              data: [0]
            }],
            legend: {
              selectedMode: false,
              itemGap: 20,
              itemWidth: 13,
              y: 'bottom',
              data: [data.used.label, data.available.label].map(function(label) {
                return {
                  name: label,
                  textStyle: {
                    fontWeight: 500
                  },
                  icon: 'a'
                };
              })
            },
            series: [{
              type: 'pie',
              center: ['50%', outerRadius + padding],
              radius: [innerRadius, outerRadius],
              data: [{
                name: data.available.label,
                value: data.available.value,
                itemStyle: itemStyleBase
              }, {
                name: data.used.label,
                value: data.used.value,
                itemStyle: angular.merge({}, itemStyleBase, {
                  normal: {
                    color: colors.line
                  }
                })
              }]
            }]
          };
          options.series[0].itemStyle = {
            normal: {
              label: {
                formatter: function() {
                  return Math.round($scope.data.used.value * 100 /
                    ($scope.data.used.value + $scope.data.available.value)) + '%';
                },
                textStyle: {
                  color: '#111',
                  fontSize: Math.floor(28 * innerRadius / 39),
                  fontWeight: 500,
                  baseline: 'middle'
                }
              }
            }
          };
          if (use.title) {
            options.series[0].center[0] = outerRadius + padding;
            options.legend.x = padding;
            options.title = {
              text: use.title,
              x: (outerRadius + padding) * 2 + padding + 4,
              y: outerRadius + padding + 4,
              textStyle: {
                fontSize: 12,
                fontWeight: 500,
                color: '#666'
              }
            };
            var left = options.title.x + 14;
            var top = options.title.y - 48;
            var total = $scope.data.used.value + $scope.data.available.value;
            var unit = $scope.data.used.unit;
            var unselectable =
              '-webkit-touch-callout: none;' +
              '-webkit-user-select: none;' +
              '-khtml-user-select: none;' +
              '-moz-user-select: none;' +
              '-ms-user-select: none;' +
              'user-select: none;';
            angular.element($element[0]).append([
              '<div style="position: absolute; left: ' + left + 'px; top: ' + top + 'px">',
              '<p style="cursor: default; ' + unselectable + '">',
              '<span style="font-size: 40px; font-weight: 500">' + total + '</span>', (unit ? ('<span style="font-size: 15px; font-weight: 700">' + unit + '</span>') : ''),
              '</p>',
              '</div>'
            ].join(' '));
          }
          $scope.echartOptions = options;
        }
      ]
    };
  });
angular.module('dashing.charts.sparkline', [
  'dashing.charts.echarts'
])
  .directive('sparklineChart', ['$echarts',
    function($echarts) {
      return {
        restrict: 'E',
        template: '<echart options="::echartOptions"></echart>',
        scope: {
          options: '=optionsBind',
          data: '=datasourceBind'
        },
        link: function(scope) {
          var echartScope = scope.$$childHead;
          scope.$watch('data', function(data) {
            if (data) {
              echartScope.addDataPoints(data);
            }
          });
        },
        controller: ['$scope',
          function($scope) {
            var use = angular.merge({
              color: 'rgb(0,119,215)'
            }, $scope.options);
            if (use.xAxisTypeIsTime) {
              console.warn('Echarts does not have a good experience for time series, so we fallback to category.');
              use.xAxisTypeIsTime = false;
            }
            var colors = $echarts.buildColorStates(use.color);
            var options = {
              height: use.height,
              width: use.width,
              tooltip: $echarts.categoryTooltip(use.valueFormatter),
              grid: angular.merge({
                borderWidth: 1,
                x: 5,
                y: 5,
                x2: 5,
                y2: 1
              }, use.grid),
              xAxis: [{
                type: use.xAxisTypeIsTime ? 'time' : undefined,
                boundaryGap: false,
                axisLabel: false,
                splitLine: false
              }],
              yAxis: [{
                boundaryGap: [0, 0.1],
                show: false
              }],
              series: [$echarts.makeDataSeries({
                colors: colors,
                stack: true
              })]
            };
            if (use.series0Type === 'bar') {
              options.grid.borderWidth = 0;
              options.grid.y2 = 0;
              options.xAxis[0].boundaryGap = true;
              options.series[0].type = 'bar';
            }
            var data = use.data;
            $echarts.fillAxisData(options, data, use);
            $scope.echartOptions = options;
          }
        ]
      };
    }
  ]);
angular.module('dashing.contextmenu', [
  'mgcrea.ngStrap.dropdown'
])
  .factory('$contextmenu', function() {
    return {
      popup: function(elem, position) {
        var elem0 = angular.element(elem);
        elem0.css({
          left: position.x + 'px',
          top: position.y + 'px'
        });
        elem0.triggerHandler('click');
      }
    };
  });
angular.module('dashing.filters.any', [])
  .filter('any', function() {
    return function(items, props) {
      if (!Array.isArray(items)) {
        return items;
      }
      return items.filter(function(item) {
        var keys = Object.keys(props);
        for (var i = 0; i < keys.length; i++) {
          var prop = keys[i];
          var subtext = angular.lowercase(props[prop] || '');
          var text = angular.lowercase(item[prop] || '');
          if (text.indexOf(subtext) !== -1) {
            return true;
          }
        }
        return false;
      });
    }
  });
angular.module('dashing.filters.duration', [
  'dashing.util'
])
  .filter('duration', ['dashing.util',
    function(util) {
      return function(millis, compact) {
        return util.text.toHumanReadableDuration(millis, compact);
      };
    }
  ]);
angular.module('dashing.forms.form_control', [
  'ngSanitize',
  'dashing.filters.any',
  'dashing.util.validation',
  'mgcrea.ngStrap.datepicker',
  'mgcrea.ngStrap.timepicker',
  'ui.select'
])
.directive('formControl', ['dashing.util.validation',
  function(validation) {
    function buildChoicesForSelect(choices) {
      var result = [];
      angular.forEach(choices, function(choice, value) {
        if (angular.isString(choice)) {
          choice = {
            text: choice
          };
        }
        result.push({
          value: value,
          text: choice.text,
          subtext: choice.subtext
        });
      });
      return result;
    }
    function buildChoicesForButtonGroup(choices) {
      var result = [];
      angular.forEach(choices, function(choice, value) {
        result.push({
          value: value,
          text: choice
        });
      });
      return result;
    }
    function buildChoicesForDropDownMenu(choices, onSelect) {
      return choices.map(function(choice) {
        if (angular.isString(choice)) {
          choice = {
            text: choice
          };
        }
        return {
          text: (choice.icon ? '<i class="' + choice.icon + '"></i> ' : '') + choice.text,
          click: function() {
            onSelect(choice.text);
          }
        };
      });
    }
    return {
      restrict: 'E',
      templateUrl: 'forms/form_controls.html',
      replace: true,
      scope: {
        label: '@',
        value: '=ngModel',
        invalid: '='
      },
      link: function(scope, elem, attrs) {
        scope.renderAs = attrs.type;
        scope.pristine = true;
        scope.invalid = attrs.required;
        switch (attrs.type) {
          case 'class':
            scope.renderAs = 'text';
            scope.validateFn = validation.class;
            break;
          case 'choices':
            scope.choices = buildChoicesForSelect(eval('(' + attrs.choices + ')'));
            scope.allowSearchInChoices = Object.keys(scope.choices).length >= 5;
            break;
          case 'radio':
            scope.choices = buildChoicesForButtonGroup(eval('(' + attrs.choices + ')'));
            scope.buttonStyleClass = attrs.btnStyleClass || 'btn-sm';
            scope.toggle = function(value) {
              scope.value = value;
            };
            break;
          case 'integer':
            scope.renderAs = 'number';
            scope.validateFn = validation.integer;
            break;
          case 'positiveInteger':
            scope.renderAs = 'number';
            scope.min = '1';
            scope.validateFn = validation.positiveInteger;
            break;
          case 'nonNegativeInteger':
            scope.renderAs = 'number';
            scope.min = '0';
            scope.validateFn = validation.nonNegativeInteger;
            break;
          case 'datetime':
            scope.fillDefaultTime = function() {
              scope.timeValue = scope.timeValue || moment().format('HH:mm:00');
            };
            scope.dateInputInvalid = false;
            scope.timeInputInvalid = false;
            scope.$watch('dateValue', function(newVal, oldVal) {
              scope.dateInputInvalid =
                angular.isUndefined(newVal) && !angular.isUndefined(oldVal);
              scope.invalid = scope.dateInputInvalid || scope.timeInputInvalid;
              if (newVal) {
                scope.value = newVal + (scope.timeValue ? 'T' + scope.timeValue : '');
              }
            });
            scope.$watch('timeValue', function(newVal, oldVal) {
              scope.timeInputInvalid =
                angular.isUndefined(newVal) && !angular.isUndefined(oldVal);
              scope.invalid = scope.dateInputInvalid || scope.timeInputInvalid;
              if (newVal) {
                scope.value = (scope.dateValue ? scope.dateValue + 'T' : '') + newVal;
              }
            });
            break;
        }
        if (scope.renderAs === 'text' && attrs.choices) {
          scope.choicesMenu = buildChoicesForDropDownMenu(
            eval('(' + attrs.choices + ')'),
            function(choice) {
              scope.value = choice;
            });
        }
        scope.$watch('value', function(value) {
          scope.pristine = !angular.isNumber(value) && (value || '').length === 0;
          scope.invalid =
            (angular.isFunction(scope.validateFn) && !scope.validateFn(value)) ||
            (attrs.required && scope.pristine);
        });
      }
    };
  }
]);
angular.module('dashing.forms.searchbox', [])
  .directive('searchbox', function() {
    return {
      restrict: 'E',
      templateUrl: 'forms/searchbox.html',
      scope: {
        placeholder: '@',
        ngModel: '='
      }
    };
  });
angular.module('dashing.metrics', [])
  .directive('metrics', function() {
    return {
      restrict: 'E',
      templateUrl: 'metrics/metrics.html',
      scope: {
        caption: '@',
        help: '@',
        value: '@',
        unit: '@',
        subText: '@'
      }
    };
  });
angular.module('dashing.progressbar', [])
  .directive('progressbar', function() {
    return {
      restrict: 'E',
      templateUrl: 'progressbar/progressbar.html',
      scope: {
        current: '@',
        max: '@',
        colorMapperFn: '='
      },
      link: function(scope, elem, attrs) {
        attrs.$observe('current', function(current) {
          updateUsageAndClass(Number(current), Number(attrs.max));
        });
        attrs.$observe('max', function(max) {
          updateUsageAndClass(Number(attrs.current), Number(max));
        });
        function updateUsageAndClass(current, max) {
          scope.usage = max > 0 ? Math.round(current * 100 / max) : -1;
          scope.usageClass = (scope.colorMapperFn ?
            scope.colorMapperFn : defaultColorMapperFn)(scope.usage);
        }
        function defaultColorMapperFn(usage) {
          return 'progress-bar-' +
            (usage < 50 ? 'info' : (usage < 75 ? 'warning' : 'danger'));
        }
      }
    };
  });
angular.module('dashing.property.bytes', [
  'dashing.util'
])
  .directive('bytes', ['dashing.util',
    function(util) {
      return {
        restrict: 'E',
        templateUrl: 'property/bytes.html',
        scope: {
          raw: '@'
        },
        link: function(scope, elem, attrs) {
          attrs.$observe('raw', function(raw) {
            if (['true', '1'].indexOf(attrs['readable']) !== -1) {
              var hr = util.text.toHumanReadableNumber(Number(raw), 1024);
              scope.value = hr.value;
              scope.unit = hr.modifier + attrs.unit;
            } else {
              scope.value = raw;
              scope.unit = attrs.unit;
            }
          });
        }
      };
    }
  ]);
angular.module('dashing.property', [
  'mgcrea.ngStrap.tooltip'
])
  .directive('property', function() {
    return {
      restrict: 'E',
      templateUrl: 'property/property.html',
      replace: false,
      scope: {
        value: '=valueBind',
        renderer: '@'
      },
      controller: ['$scope',
        function($scope) {
          $scope.$watch('value', function(value) {
            if (value) {
              switch ($scope.renderer) {
                case 'Link':
                  if (!value.href) {
                    $scope.href = value.text;
                  }
                  break;
                case 'Button':
                  if (value.href && !value.click) {
                    $scope.click = function() {
                      location.href = value.href;
                    };
                  }
                  break;
                case 'Bytes':
                  if (!value.hasOwnProperty('raw')) {
                    $scope.raw = value;
                    return;
                  }
                  break;
              }
              if (angular.isObject(value)) {
                if (value.hasOwnProperty('value')) {
                  console.warn({
                    message: 'Ignore `value.value`, because it is a reversed field.',
                    object: value
                  });
                  delete value.value;
                }
                angular.merge($scope, value);
              }
            }
          });
        }
      ]
    };
  })
  .constant('dsPropertyRenderer', {
    BUTTON: 'Button',
    BYTES: 'Bytes',
    DATETIME: 'DateTime',
    DURATION: 'Duration',
    INDICATOR: 'Indicator',
    LINK: 'Link',
    NUMBER: 'Number',
    PROGRESS_BAR: 'ProgressBar',
    TAG: 'Tag',
    TEXT: undefined
  });
angular.module('dashing.remark', [
  'mgcrea.ngStrap.tooltip'
])
  .directive('remark', function() {
    return {
      restrict: 'E',
      templateUrl: 'remark/remark.html',
      scope: {
        tooltip: '@',
        placement: '@'
      },
      link: function(scope, elem, attrs) {
        switch (attrs.type) {
          case 'info':
            scope.fontClass = 'glyphicon glyphicon-info-sign';
            break;
          case 'warning':
            scope.fontClass = 'glyphicon glyphicon-exclamation-sign';
            break;
          default:
            scope.fontClass = 'glyphicon glyphicon-question-sign';
            break;
        }
      }
    };
  });
angular.module('dashing.state.indicator', [
  'dashing.util',
  'mgcrea.ngStrap.tooltip'
])
  .directive('indicator', ['dashing.util',
    function(util) {
      return {
        restrict: 'E',
        templateUrl: 'state/indicator.html',
        scope: {
          tooltip: '@',
          shape: '@'
        },
        link: function(scope, elem, attrs) {
          if (!attrs.condition) {
            attrs.condition = '';
          }
          attrs.$observe('condition', function(condition) {
            scope.colorStyle = util.bootstrap.conditionToColor(condition);
          });
          attrs.$observe('tooltip', function(tooltip) {
            scope.cursorStyle = tooltip ? 'pointer' : 'default';
          });
        }
      };
    }
  ]);
angular.module('dashing.state.tag', [
  'dashing.util',
  'mgcrea.ngStrap.tooltip'
])
  .directive('tag', ['dashing.util',
    function(util) {
      return {
        restrict: 'E',
        templateUrl: 'state/tag.html',
        scope: {
          href: '@',
          text: '@',
          tooltip: '@'
        },
        link: function(scope, elem, attrs) {
          if (!attrs.condition) {
            attrs.condition = '';
          }
          attrs.$observe('condition', function(condition) {
            scope.labelColorClass = util.bootstrap.conditionToBootstrapLabelClass(condition);
          });
          attrs.$observe('tooltip', function(tooltip) {
            if (!scope.href) {
              scope.cursorStyle = tooltip ? 'pointer' : 'default';
            }
          });
        }
      };
    }
  ]);
angular.module('dashing.tables.property_table', [])
  .directive('propertyTable', function() {
    return {
      restrict: 'E',
      templateUrl: 'tables/property_table/property_table.html',
      scope: {
        caption: '@',
        props: '=propsBind',
        propNameClass: '@',
        propValueClass: '@'
      }
    };
  });
angular.module('dashing.tables.property_table.builder', [])
  .factory('$propertyTableBuilder', ['dsPropertyRenderer',
    function(renderer) {
      var PB = function(renderer, title) {
        this.props = renderer ? {
          renderer: renderer
        } : {};
        if (title) {
          this.title(title);
        }
      };
      PB.prototype.title = function(title) {
        this.props.name = title;
        return this;
      };
      PB.prototype.help = function(help) {
        this.props.help = help;
        return this;
      };
      PB.prototype.value = function(value) {
        this.props.value = value;
        return this;
      };
      PB.prototype.values = function(values) {
        if (!Array.isArray(values)) {
          console.warn('values must be an array');
          values = [values];
        }
        this.props.values = values;
        return this;
      };
      PB.prototype.done = function() {
        return this.props;
      };
      return {
        button: function(title) {
          return new PB(renderer.BUTTON, title);
        },
        bytes: function(title) {
          return new PB(renderer.BYTES, title);
        },
        datetime: function(title) {
          return new PB(renderer.DATETIME, title);
        },
        duration: function(title) {
          return new PB(renderer.DURATION, title);
        },
        indicator: function(title) {
          return new PB(renderer.INDICATOR, title);
        },
        link: function(title) {
          return new PB(renderer.LINK, title);
        },
        number: function(title) {
          return new PB(renderer.NUMBER, title);
        },
        progressbar: function(title) {
          return new PB(renderer.PROGRESS_BAR, title);
        },
        tag: function(title) {
          return new PB(renderer.TAG, title);
        },
        text: function(title) {
          return new PB(renderer.TEXT, title);
        },
        $update: function(props, values) {
          angular.forEach(values, function(value, index) {
            var field = Array.isArray(value) ? 'values' : 'value';
            props[index][field] = value;
          });
        }
      };
    }
  ]);
angular.module('dashing.tables.sortable_table', [
  'smart-table'
])
  .directive('sortableTable', function() {
    return {
      restrict: 'E',
      templateUrl: 'tables/sortable_table/sortable_table.html',
      scope: {
        caption: '@',
        pagination: '@',
        columns: '=columnsBind',
        records: '=recordsBind',
        search: '=searchBind'
      },
      link: function(scope, elem) {
        var searchControl = elem.find('input')[0];
        scope.$watch('search', function(val) {
          searchControl.value = val || '';
          angular.element(searchControl).triggerHandler('input');
        });
        scope.$watch('columns', function(columns) {
          if (!Array.isArray(columns)) {
            console.warn('Failed to create table, until columns are defined.');
            return;
          }
          scope.columnStyleClass = columns.map(function(column) {
            function addStyleClass(dest, clazz, condition) {
              if (condition) {
                dest.push(clazz);
              }
            }
            var array = [];
            addStyleClass(array, column.styleClass, column.styleClass !== undefined);
            addStyleClass(array, 'text-right', 'Number' === column.renderer);
            addStyleClass(array, 'text-nowrap', Array.isArray(column.key) && !column.vertical);
            return array.join(' ');
          });
          scope.multipleRendererColumnsRenderers = columns.map(function(column) {
            if (!Array.isArray(column.key)) {
              return null;
            }
            if (Array.isArray(column.renderer)) {
              if (column.renderer.length !== column.key.length) {
                console.warn('Every column key should have a renderer, or share one renderer.');
              }
              return column.renderer;
            }
            return column.key.map(function() {
              return column.renderer;
            });
          });
        });
        scope.isArray = Array.isArray;
      }
    };
  })
.directive('stSummary', function() {
  return {
    require: '^stTable',
    template: 'Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records',
    link: function(scope, element, attrs, stTable) {
      scope.stRange = {
        from: null,
        to: null
      };
      scope.$watch('currentPage', function() {
        var pagination = stTable.tableState().pagination;
        scope.stRange.from = pagination.start + 1;
        scope.stRange.to = scope.currentPage === pagination.numberOfPages ?
          pagination.totalItemCount : (scope.stRange.from + scope.stItemsByPage - 1);
      });
    }
  };
})
  .config(['stConfig',
    function(stConfig) {
      stConfig.sort.skipNatural = true;
    }
  ]);
angular.module('dashing.tables.sortable_table.builder', [
  'dashing.property',
  'dashing.util'
])
  .factory('$sortableTableBuilder', ['dashing.util', 'dsPropertyRenderer',
    function(util, renderer) {
      var CB = function(renderer, title) {
        this.props = renderer ? {
          renderer: renderer
        } : {};
        if (title) {
          this.title(title);
        }
      };
      CB.prototype.title = function(title) {
        this.props.name = title;
        return this;
      };
      CB.prototype.key = function(key) {
        this.props.key = key;
        return this;
      };
      CB.prototype.canSort = function(overrideSortKey) {
        if (!overrideSortKey && !this.props.key) {
          console.warn('Specify a sort key or define column key first!');
          return;
        }
        this.props.sortKey = overrideSortKey || this.props.key;
        if (this.props.sortKey === this.props.key) {
          switch (this.props.renderer) {
            case renderer.LINK:
              this.props.sortKey += '.text';
              break;
            case renderer.INDICATOR:
            case renderer.TAG:
              this.props.sortKey += '.condition';
              break;
            case renderer.PROGRESS_BAR:
              this.props.sortKey += '.usage';
              break;
            case renderer.BYTES:
              this.props.sortKey += '.raw';
              break;
            case renderer.BUTTON:
              console.warn('"%s" column is not sortable.');
              return;
            default:
          }
        }
        return this;
      };
      CB.prototype.sortDefault = function(descent) {
        if (!this.props.sortKey) {
          console.warn('Specify a sort key or define column key first!');
          return;
        }
        this.props.defaultSort = descent ? 'reverse' : true;
        return this;
      };
      CB.prototype.sortDefaultDescent = function() {
        return this.sortDefault(true);
      };
      CB.prototype.styleClass = function(styleClass) {
        this.props.styleClass = styleClass;
        return this;
      };
      CB.prototype.sortBy = function(sortKey) {
        this.props.sortKey = sortKey;
        return this;
      };
      CB.prototype.unit = function(unit) {
        this.props.unit = unit;
        return this;
      };
      CB.prototype.help = function(help) {
        this.props.help = help;
        return this;
      };
      CB.prototype.vertical = function() {
        if (Array.isArray(this.props.key)) {
          this.props.vertical = true;
        }
        return this;
      };
      CB.prototype.done = function() {
        return this.props;
      };
      return {
        button: function(title) {
          return new CB(renderer.BUTTON, title);
        },
        bytes: function(title) {
          return new CB(renderer.BYTES, title);
        },
        datetime: function(title) {
          return new CB(renderer.DATETIME, title);
        },
        duration: function(title) {
          return new CB(renderer.DURATION, title);
        },
        indicator: function(title) {
          return new CB(renderer.INDICATOR, title);
        },
        link: function(title) {
          return new CB(renderer.LINK, title);
        },
        multiple: function(title, renderers) {
          return new CB(renderers, title);
        },
        number: function(title) {
          return new CB(renderer.NUMBER, title);
        },
        progressbar: function(title) {
          return new CB(renderer.PROGRESS_BAR, title);
        },
        tag: function(title) {
          return new CB(renderer.TAG, title);
        },
        text: function(title) {
          return new CB(renderer.TEXT, title);
        },
        $check: function(cols, model) {
          angular.forEach(cols, function(col) {
            var keys = util.array.ensureArray(col.key);
            angular.forEach(keys, function(key) {
              if (!model.hasOwnProperty(key)) {
                console.warn('Model does not have a property matches column key `' + col + '`.');
              }
            });
          });
        }
      };
    }
  ]);
angular.module('dashing.tabset', [])
  .directive('tabset', [
    function() {
      return {
        restrict: 'E',
        templateUrl: 'tabset/tabset.html',
        transclude: true,
        scope: true,
        controller: ['$scope',
          function($scope) {
            var tabs = $scope.tabs = [];
            function select(tab, reload) {
              angular.forEach(tabs, function(item) {
                item.selected = item === tab;
              });
              if (tab.load !== undefined) {
                tab.load(reload);
              }
            }
            this.addTab = function(tab) {
              tabs.push(tab);
              if (tabs.length === 1) {
                select(tab);
              }
            };
            $scope.selectTab = function(activeTabIndex, reload) {
              if (activeTabIndex >= 0 && activeTabIndex < tabs.length) {
                select(tabs[activeTabIndex], reload);
              }
            };
          }
        ]
      };
    }
  ])
.directive('tab', ['$http', '$controller', '$compile',
  function($http, $controller, $compile) {
    return {
      restrict: 'E',
      require: '^tabset',
      template: '<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',
      replace: true,
      transclude: true,
      link: function(scope, elem, attrs, ctrl) {
        scope.heading = attrs.heading;
        scope.loaded = false;
        scope.load = function(reload) {
          if (scope.loaded && !reload) {
            return;
          }
          if (attrs.template) {
            $http.get(attrs.template).then(function(response) {
              createTemplateScope(response.data);
            });
          }
        };
        function createTemplateScope(template) {
          elem.html(template);
          var templateScope = scope.$new(false);
          if (attrs.controller) {
            var scopeController = $controller(attrs.controller, {
              $scope: templateScope
            });
            elem.children().data('$ngController', scopeController);
          }
          $compile(elem.contents())(templateScope);
          scope.loaded = true;
        }
        ctrl.addTab(scope);
      }
    };
  }
]);
angular.module('dashing.util.array', [])
.factory('dashing.util.array', function() {
  return {
    alignArray: function(array, length, default_) {
      if (length <= array.length) {
        return array.slice(0, length);
      }
      var result = angular.copy(array);
      for (var i = result.length; i < length; i++) {
        result.push(default_);
      }
      return result;
    },
    repeatArray: function(array, sum) {
      if (sum <= array.length) {
        return array.slice(0, sum);
      }
      var result = [];
      for (var i = 0; i < sum; i++) {
        result.push(array[i % array.length]);
      }
      return result;
    },
    ensureArray: function(value) {
      return Array.isArray(value) ? value : [value];
    }
  };
});
angular.module('dashing.util.bootstrap', [])
.factory('dashing.util.bootstrap', function() {
  return {
    conditionToBootstrapLabelClass: function(condition) {
      switch (condition) {
        case 'good':
          return 'label-success';
        case 'concern':
          return 'label-warning';
        case 'danger':
          return 'label-danger';
        default:
          return 'label-default';
      }
    },
    conditionToColor: function(condition) {
      switch (condition) {
        case 'good':
          return '#5cb85c';
        case 'concern':
          return '#f0ad4e';
        case 'danger':
          return '#d9534f';
        default:
          return '#aaa';
      }
    }
  };
});
angular.module('dashing.util.color', [])
.factory('dashing.util.color', function() {
  return {
    palette: {
      blue: 'rgb(0,119,215)',
      blueishGreen: 'rgb(41,189,181)',
      orange: 'rgb(255,127,80)',
      purple: 'rgb(110,119,215)',
      skyBlue: 'rgb(91,204,246)',
      darkBlue: 'rgb(102,168,212)',
      darkGray: 'rgb(92,92,97)',
      darkPink: 'rgb(212,102,138)',
      darkRed: 'rgb(212,102,138)',
      lightBlue: 'rgb(149,206,255)',
      lightGreen: 'rgb(169,255,150)'
    }
  };
});
angular.module('dashing.util.text', [])
.factory('dashing.util.text', function() {
  return {
    toHumanReadableNumber: function(value, base, digits) {
      var modifier = '';
      if (value !== 0) {
        if (base !== 1024) {
          base = 1000;
        }
        var positive = value > 0;
        var positiveValue = Math.abs(value);
        var s = ['', 'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'];
        var e = Math.floor(Math.log(positiveValue) / Math.log(base));
        value = positiveValue / Math.pow(base, e);
        if (digits > 0 && value !== Math.floor(value)) {
          value = value.toFixed(digits);
        }
        if (!positive) {
          value *= -1;
        }
        modifier = s[e];
      }
      return {
        value: value,
        modifier: modifier
      };
    },
    toHumanReadableDuration: function(millis, compact) {
      var x = parseInt(millis, 10);
      if (isNaN(x)) {
        return millis;
      }
      var units = [{
        label: ' ms',
        mod: 1000
      }, {
        label: compact ? 's' : ' secs',
        mod: 60
      }, {
        label: compact ? 'm' : ' mins',
        mod: 60
      }, {
        label: compact ? 'h' : ' hours',
        mod: 24
      }, {
        label: compact ? 'd' : ' days',
        mod: 7
      }, {
        label: compact ? 'w' : ' weeks',
        mod: 52
      }];
      var duration = [];
      for (var i = 0; i < units.length; i++) {
        var unit = units[i];
        var t = x % unit.mod;
        if (t !== 0) {
          duration.unshift({
            label: unit.label,
            value: t
          });
        }
        x = (x - t) / unit.mod;
      }
      duration = duration.slice(0, 2);
      if (duration.length > 1 && duration[1].label === ' ms') {
        duration = [duration[0]];
      }
      return duration.map(function(unit) {
        return unit.value + unit.label;
      }).join(compact ? ' ' : ' and ');
    }
  };
});
angular.module('dashing.util', [
  'dashing.util.array',
  'dashing.util.bootstrap',
  'dashing.util.color',
  'dashing.util.text',
  'dashing.util.validation'
])
.factory('dashing.util', [
  'dashing.util.array',
  'dashing.util.bootstrap',
  'dashing.util.color',
  'dashing.util.text',
  'dashing.util.validation',
  function(array, bootstrap, color, text, validation) {
    return {
      array: array,
      bootstrap: bootstrap,
      color: color,
      text: text,
      validation: validation
    };
  }
]);
angular.module('dashing.util.validation', [])
.factory('dashing.util.validation', function() {
  return {
    class: function(s) {
      return /^[a-zA-Z_][a-zA-Z_\d]*(\.[a-zA-Z_][a-zA-Z_\d]*)*$/i.test(s);
    },
    integer: function(s) {
      return s == parseInt(s, 10);
    },
    positiveInteger: function(s) {
      var n = parseInt(s, 10);
      return s == n && n > 0;
    },
    nonNegativeInteger: function(s) {
      var n = parseInt(s, 10);
      return s == n && n >= 0;
    }
  };
});
})(window, document);