/*! dashing (assembled widgets) v0.3.8 | Apache License 2.0 | https://github.com/stanleyxu2005/dashing */
!function(window,document,undefined){"use strict";angular.module("dashing",["dashing.charts.bar","dashing.charts.line","dashing.charts.metrics_sparkline","dashing.charts.ring","dashing.charts.sparkline","dashing.forms.form_control","dashing.forms.searchbox","dashing.metrics","dashing.progressbar","dashing.property","dashing.property.number","dashing.remark","dashing.state.indicator","dashing.state.tag","dashing.tables.property_table","dashing.tables.sortable_table","dashing.tabset","dashing.contextmenu","dashing.tables.property_table.builder","dashing.tables.sortable_table.builder","dashing.filters.any","dashing.filters.duration"]),angular.module("dashing").run(["$templateCache",function(e){e.put("charts/metrics_sparkline_td.html",'<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>'),e.put("forms/datepicker.html",'<div class="dropdown-menu datepicker" ng-class="\'datepicker-mode-\' + $mode" style="max-width: 320px"> <table style="table-layout: fixed; height: 100%; width: 100%"> <thead> <tr class="text-center dt-header"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$selectPane(-1)"> <i class="glyphicon glyphicon-triangle-left"></i> </button> </th> <th colspan="{{ rows[0].length - 2 }}"> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius btn-block text-strong" ng-click="$toggleMode()"> <strong style="text-transform: capitalize" ng-bind="title"></strong> </button> </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-right" ng-click="$selectPane(+1)"> <i class="glyphicon glyphicon-triangle-right"></i> </button> </th> </tr> <tr ng-if="showLabels" ng-bind-html="labels"></tr> </thead> <tbody> <tr ng-repeat="(i, row) in rows track by $index" ng-if="$index < 5" style="height: 21px"> <td class="text-center" ng-repeat="(j, el) in row track by $index"> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius" style="width: 100%; padding: 4px 3px" ng-class="{\'btn-primary\': el.selected, \'btn-info btn-today\': el.isToday && !el.selected}" ng-click="$select(el.date)" ng-disabled="el.disabled"> <span ng-class="{\'text-muted\': el.muted}" ng-bind="el.label"></span> </button> </td> </tr> </tbody> </table> </div>'),e.put("forms/form_controls.html",'<div class="form-group"> <label class="{{labelStyleClass}} control-label text-right"> <span ng-bind="label"></span> <span ng-if="help" style="font-size: 0.9em"> <remark tooltip="{{help}}" type="info"></remark> </span> </label> <ng-switch on="renderAs">  <div ng-switch-when="choices"> <div class="{{controlStyleClass}}"> <ui-select theme="select2" class="form-control" ng-model="$parent.$parent.value" search-enabled="allowSearchInChoices"> <ui-select-match placeholder="{{placeholder}}" allow-clear="{{allowClearSelection}}">{{$select.selected.text}} </ui-select-match> <ui-select-choices repeat="choice in choices|\n          any: {text: $select.search, subtext: $select.search}"> <div ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.text|highlight:$select.search"></div> <small ng-if="choice.subtext" ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.subtext|highlight:$select.search"></small> </ui-select-choices> </ui-select> </div> </div>  <div ng-switch-when="check"> <div class="{{controlStyleClass}} checkbox"> <label> <input type="checkbox" ng-checked="$parent.value" ng-click="$parent.value = !$parent.value"> <span ng-bind="text"></span> </label> </div> </div>  <div ng-switch-when="multi-checks"> <div class="{{controlStyleClass}}"> <label class="checkbox-inline" ng-repeat="choice in choices track by $index"> <input type="checkbox" ng-checked="$parent.value[$index]" ng-click="$parent.value[$index] = !$parent.value[$index]"> <span ng-bind="choice"></span> </label> </div> </div>  <div ng-switch-when="radio"> <div class="{{controlStyleClass}}"> <div class="btn-group btn-group-justified"> <div ng-repeat="choice in choices track by $index" class="btn-group"> <button type="button" class="btn {{buttonStyleClass}} btn-default" ng-class="{\'btn-primary\': choice.value == value}" ng-bind="choice.text" value="{{choice.value}}" ng-click="toggle(choice.value)"></button> </div> </div> </div> </div>  <div ng-switch-when="integer"> <div class="{{controlStyleClass}}" ng-class="{\'has-error\': !pristine && invalid}"> <input type="number" class="form-control input-sm" ng-attr-min="{{min}}" ng-attr-max="{{max}}" ng-model="$parent.value"> </div> </div>  <div ng-switch-when="datetime"> <div class="{{dateControlStyleClass}} has-feedback" ng-class="{\'has-error\': dateInputInvalid}"> <input class="form-control input-sm" data-date-format="yyyy-MM-dd" type="text" size="10" placeholder="YYYY-MM-DD" ng-model="$parent.dateValue" date-type="string" data-autoclose="1" template-url="forms/datepicker.html" use-native="true" bs-datepicker> <span class="glyphicon glyphicon-calendar form-control-feedback fc-feedback-sm"></span> </div> <div class="{{timeControlStyleClass}} has-feedback" style="padding-left: 0" ng-class="{\'has-error\': timeInputInvalid}"> <input class="form-control input-sm" data-time-format="HH:mm:ss" type="text" size="8" placeholder="HH:mm:ss" ng-click="fillDefaultTime()" ng-model="$parent.timeValue" time-type="string" hour-step="1" minute-step="1" second-step="1" data-length="3" arrow-behavior="picker" template-url="forms/timepicker.html" use-native="true" bs-timepicker> <span class="glyphicon glyphicon-time form-control-feedback fc-feedback-sm"></span> </div> </div>  <div ng-switch-when="upload"> <div class="{{controlStyleClass}} has-feedback" ng-class="{\'has-error\': !pristine && invalid}"> <input type="text" readonly="readonly" class="form-control input-sm" placeholder="Click here to select a file" style="cursor: pointer" ng-click="openUpload()" ng-model="$parent.filename">  <span ng-hide="$parent.value" class="glyphicon glyphicon-folder-open form-control-feedback fc-feedback-sm clickable" ngf-select ng-model="$parent.files" accept="{{acceptPattern}}" ngf-accept="\'{{acceptPattern}}\'"></span> <span ng-show="$parent.value" class="glyphicon glyphicon-trash form-control-feedback fc-feedback-sm clickable" ng-click="clearSelection()"></span> </div> </div>  <div ng-switch-default> <div class="{{controlStyleClass}}"> <div ng-class="{\'has-error\': !pristine && invalid}"> <div ng-class="{\'input-group\': choicesMenu}"> <input type="text" class="form-control input-sm" ng-model="$parent.value"> <div ng-if="choicesMenu" class="input-group-btn"> <button type="button" class="btn btn-sm btn-default dropdown-toggle" bs-dropdown="choicesMenu" placement="auto bottom-left" html="true"> <span class="{{choiceIconStyleClass}} clickable"></span> <span ng-if="!hideMenuCaret" class="caret"></span> </button> </div> </div> </div> </div> </div> </ng-switch> </div>'),e.put("forms/searchbox.html",'<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <small class="glyphicon glyphicon-search form-control-feedback"></small> </div>'),e.put("forms/timepicker.html",'<div class="dropdown-menu timepicker" style="min-width: 0; width: auto"> <table height="100%"> <thead> <tr class="text-center"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 0)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> <th> &nbsp; </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 1)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> <th> &nbsp; </th> <th> <button ng-if="showSeconds" tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 2)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> </tr> </thead> <tbody> <tr ng-repeat="(i, row) in rows"> <td class="text-center"> <button tabindex="-1" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[0].selected}" ng-click="$select(row[0].date, 0)" ng-disabled="row[0].disabled"> <span ng-class="{\'text-muted\': row[0].muted}" ng-bind="row[0].label"></span> </button> </td> <td> <span class="time-separator" ng-bind="i == midIndex ? timeSeparator : \' \'"></span> </td> <td class="text-center"> <button tabindex="-1" ng-if="row[1].date" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[1].selected}" ng-click="$select(row[1].date, 1)" ng-disabled="row[1].disabled"> <span ng-class="{\'text-muted\': row[1].muted}" ng-bind="row[1].label"></span> </button> </td> <td> <span class="time-separator" ng-bind="i == midIndex ? timeSeparator : \' \'"></span> </td> <td class="text-center"> <button tabindex="-1" ng-if="showSeconds && row[2].date" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[2].selected}" ng-click="$select(row[2].date, 2)" ng-disabled="row[2].disabled"> <span ng-class="{\'text-muted\': row[2].muted}" ng-bind="row[2].label"></span> </button> </td> <td ng-if="showAM"> &nbsp; </td> <td ng-if="showAM"> <button tabindex="-1" ng-show="i == midIndex - !isAM * 1" style="width: 100%" type="button" ng-class="{\'btn-primary\': !!isAM}" class="btn btn-default" ng-click="$switchMeridian()" ng-disabled="el.disabled">AM</button> <button tabindex="-1" ng-show="i == midIndex + 1 - !isAM * 1" style="width: 100%" type="button" ng-class="{\'btn-primary\': !isAM}" class="btn btn-default" ng-click="$switchMeridian()" ng-disabled="el.disabled">PM</button> </td> </tr> </tbody> <tfoot> <tr class="text-center"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 0)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> <th> &nbsp; </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 1)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> <th> &nbsp; </th> <th> <button ng-if="showSeconds" tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 2)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> </tr> </tfoot> </table> </div>'),e.put("metrics/metrics.html",'<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="{{remarkType}}" tooltip="{{help}}" ng-click="clickHelp()"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <ng-switch on="unitPlural && value > 1"> <small ng-switch-when="true" ng-bind="unitPlural"></small> <small ng-switch-default ng-bind="unit"></small> </ng-switch> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>'),e.put("progressbar/progressbar.html",'<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="clear: both; height: 1px"></div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>'),e.put("property/number.html",'<div> <span ng-bind="value"></span> <span ng-if="unit" ng-bind="unit"></span> </div>'),e.put("property/property.html",'<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text" ng-attr-target="{{target}}"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <div ng-switch-when="Duration" ng-bind="value|duration"></div>  <div ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:mm:ss\'"></div>  <number ng-switch-when="Number" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-precision="{{precision}}" ng-attr-readable="{{readable}}"></number>  <div ng-switch-when="Number1" ng-bind="value|number:1"></div>  <div ng-switch-when="Number2" ng-bind="value|number:2"></div>  <div ng-switch-default ng-bind="value"></div> </ng-switch>'),e.put("remark/remark.html",'<span class="{{styleClass}}" ng-attr-bs-tooltip="tooltip" ng-style="{cursor: tooltip ? \'pointer\': \'default\'}" ng-attr-placement="{{placement}}"></span>'),e.put("state/indicator.html",'<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle}" style="display: inline-block; height: 100%; width: 8px; cursor: default" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>'),e.put("state/tag.html",'<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>'),e.put("tables/property_table/property_table.html",'<table class="table table-striped table-hover"> <caption ng-if="caption" ng-bind="caption"></caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>'),e.put("tables/sortable_table/sortable_table.html",'<table class="table table-striped table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption" ng-bind="caption"></caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="::column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody style="height: 100%"> <tr ng-repeat="record in showing track by $index" style="display: table-row; height: 100%"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}" style="height: 100%" ng-style="{\'background-color\': bgColorForStripeFix($index, record)}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="records !== null && !showing.length"> <td colspan="{{columns.length}}" class="text-center"> <i>No data found</i> </td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable_table/sortable_table_pagination.html"> </td> </tr> </tfoot> </table>'),e.put("tables/sortable_table/sortable_table_pagination.html",'<div class="pull-left hidden-sm hidden-xs" style="margin-bottom: 10px">  <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs tb-pagination"> <button ng-if="pages[0] > 1 + 10" type="button" class="btn btn-default" ng-click="selectPage(1)"> 1 </button> <button ng-if="pages[0] > 1" type="button" class="btn btn-default" ng-click="selectPage(currentPage - 1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active: page == currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button ng-if="pages[pages.length - 1] < numPages" type="button" class="btn btn-default" ng-click="selectPage(currentPage + 1)"> &raquo;</button> <button ng-if="pages[pages.length - 1] < numPages - 10" type="button" class="btn btn-default" ng-click="selectPage(numPages)"> {{numPages}} </button> </div> </div>'),e.put("tabset/tabset.html",'<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>')}]),angular.module("dashing.util.bootstrap",[]).factory("dashing.util.bootstrap",function(){return{conditionToBootstrapLabelClass:function(e){switch(e){case"good":return"label-success";case"concern":return"label-warning";case"danger":return"label-danger";default:return"label-default"}}}}),angular.module("dashing.charts.bar",["dashing.charts.echarts"]).directive("barChart",["$echarts",function(e){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope","$element",function(t,n){var a=angular.merge({yAxisSplitNum:3,yAxisShowMinorAxisLine:!1,yAxisLabelWidth:60,yAxisLabelFormatter:e.axisLabelFormatter(""),yBoundaryGap:[.2,.2],"static":!0,rotate:!1,xAxisShowLabels:!0},t.options);a=angular.merge({barMaxWidth:a.rotate?20:16,barMinWidth:a.rotate?8:7,barMaxSpacing:4,barMinSpacing:1},a);var r=a.data;Array.isArray(r)||(console.warn({message:"Initial data is expected to be an array",data:r}),r=r?[r]:[]),e.validateSeriesNames(a,r),Array.isArray(a.colors)&&a.colors.length||(a.colors=e.barChartColorRecommendation(a.seriesNames.length||1));var i=a.colors.map(function(t){return e.buildColorStates(t)}),o=i.length>1?"#999":i[0].line,s={height:a.height,width:a.width,tooltip:angular.merge(e.categoryTooltip(a.valueFormatter),{axisPointer:{type:"shadow",shadowStyle:{color:"rgba(225,225,225,0.3)"}}}),grid:angular.merge({borderWidth:0,x:Math.max(15,a.yAxisLabelWidth),x2:15,y:15,y2:28},a.grid),xAxis:[{axisLabel:{show:!0},axisLine:{show:!0,lineStyle:{width:1,color:o,type:"dotted"}},axisTick:!1,splitLine:!1}],yAxis:[{type:"value",splitNumber:a.yAxisSplitNum,splitLine:{show:a.yAxisShowMinorAxisLine,lineStyle:{color:o,type:"dotted"}},axisLine:!1,axisLabel:{formatter:a.yAxisLabelFormatter}}],series:a.seriesNames.map(function(t,n){return e.makeDataSeries({type:"bar",name:t,stack:!0,colors:i[n]})}),color:a.colors};if(a["static"]&&delete a.visibleDataPointsNum,e.fillAxisData(s,r,a),a["static"]&&(s.visibleDataPointsNum=-1),a.rotate){var l=s.xAxis;s.xAxis=angular.copy(s.yAxis),s.xAxis[0].type=s.xAxis[0].type||"value",s.yAxis=l,s.yAxis[0].type=s.yAxis[0].type||"category"}if(a.xAxisShowLabels||(s.xAxis[0].axisLabel=!1,s.grid.y2=s.grid.y),a["static"]){var c=a.barMinWidth+a.barMinSpacing,u=a.barMaxWidth+a.barMaxSpacing,d=r.length*c,p=r.length*u,h=parseInt(a.height);if(a.rotate){var g=2*s.grid.borderWidth+s.grid.y+s.grid.y2;g+d>h?(console.info("Increased the height to "+(g+d)+"px, because rotated bar chart does not support data zoom yet."),s.height=g+d+"px"):h>g+p&&(s.height=g+p+"px")}else{var b=2*s.grid.borderWidth+s.grid.x+s.grid.x2,m=angular.element(n[0]).children()[0].offsetWidth,f=m-b;if(d>0&&d>f){var y=Math.floor(f/c)*c;s.grid.x2+=f-y;var v=20,x=5;s.dataZoom={show:!0,end:100*y/d,realtime:!0,height:v,y:h-v-x,handleColor:o},s.dataZoom.fillerColor=zrender.tool.color.alpha(s.dataZoom.handleColor,.08),s.grid.y2+=v+2*x}else r.length&&f>p&&(s.grid.x2+=m-p-b)}}t.echartOptions=s}]}}]),angular.module("dashing.charts.echarts",["dashing.util"]).directive("echart",["dashing.util",function(e){function t(t,n,a,r){var i=[];return angular.forEach(e.array.ensureArray(t),function(t){var o=a-- >0,s=e.array.ensureArray(t.y).slice(0,n);if(r)angular.forEach(s,function(e,n){var a=[n,[t.x,e],!1,o];i.push(a)});else{var l=s.length-1;angular.forEach(s,function(e,n){var a=[n,e,!1,o];n===l&&a.push(t.x),i.push(a)})}}),i}return{restrict:"E",template:"<div></div>",replace:!0,scope:{options:"="},controller:["$scope","$element","dsEchartsDefaults","$echarts",function(n,a,r,i){function o(){d&&(l.dataPointsQueue&&l.dataPointsQueue.length&&(s(l.dataPointsQueue),delete l.dataPointsQueue),delete l.data)}function s(n,a){if(n&&(!Array.isArray(n)||n.length))try{if(!d)return i.fillAxisData(l,e.array.ensureArray(n)),u.setOption(l,!0),d=angular.isDefined(u.getOption().xAxis),o(),void(d&&u.hideLoading());var s=u.getOption(),c=s.series[0].data.length,p=Math.max(0,(s.visibleDataPointsNum||r.visibleDataPointsNum)-c),h="time"===s.xAxis[0].type||"value"===s.xAxis[0].type&&"time"===s.yAxis[0].type,g=s.series.length,b=t(n,g,p,h);b.length>0&&(a!==undefined&&u.setOption({yAxis:[{max:a}]},!1),u.addData(b))}catch(m){}}var l=n.options,c=a[0];angular.forEach(["width","height"],function(e){l[e]&&(c.style[e]=l[e])});var u=echarts.init(c);angular.element(window).on("resize",u.resize),n.$on("$destroy",function(){angular.element(window).off("resize",u.resize)}),n.$on("$destroy",function(){u.dispose(),u=null}),u.setTheme(r.lookAndFeel),u.setOption(l,!0),angular.isFunction(u.group)&&l.hasOwnProperty("groupId")&&(u.groupId=l.groupId,u.group());var d=angular.isDefined(u.getOption().xAxis);o(),n.addDataPoints=s,n.getChartControl=function(){return u}}]}}]).constant("dsEchartsDefaults",{lookAndFeel:{markLine:{symbol:["circle","circle"]},title:{textStyle:{fontSize:14,fontWeight:400,color:"#000"}},legend:{textStyle:{color:"#111",fontWeight:500},itemGap:20},tooltip:{borderRadius:2,padding:0,showDelay:0,transitionDuration:.5},textStyle:{fontFamily:'Roboto,"Helvetica Neue","Segoe UI","Hiragino Sans GB","Microsoft YaHei",Arial,Helvetica,SimSun,sans-serif',fontSize:12},loadingText:"Data Loading...",noDataText:"No Graphic Data Available",addDataAnimation:!1},visibleDataPointsNum:80}).factory("$echarts",["$filter","dashing.util",function(e,t){function n(t,n,i){function o(e){var t=zrender.tool.color.lift(e,-.2);return'<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid '+t+"; background-color: "+e+'"></div>'}function s(t){var n={};angular.forEach(t,function(e){n[e.name]=n[e.name]||[],n[e.name].push(e)});var a=[];return angular.forEach(n,function(e){var t=e.reduce(function(e,t){return Math.abs(Number(e.value))>Math.abs(t.value)?e:t});t.value=e.reduce(function(e,t){return{value:e.value+t.value}}).value,a.push(t)}),e("orderBy")(a,"value",!0)}var l=i.valueFormatter||r;return'<div style="padding: 8px">'+[(i.nameFormatter||a)(t),"<table>"+s(n).map(function(e){return"-"===e.value?"":(e.value=l(e.value),e.name||(e.name=e.value,e.value=""),"<tr><td>"+o(e.color)+'</td><td style="padding: 0 12px 0 4px">'+e.name+'</td><td style="text-align: right">'+e.value+"</td></tr>")}).join("")+"</table>"].join("")+"</div>"}function a(t){if(angular.isDate(t)){var n=new Date;return e("date")(t,n.getYear()===t.getYear()&&n.getMonth()===t.getMonth()&&n.getDay()===t.getDay()?"HH:mm:ss":"yyyy-MM-dd HH:mm:ss")}return t}function r(t){return e("number")(t)}function i(e){return{trigger:e.trigger||"axis",axisPointer:{type:"none"},formatter:e.formatter}}function o(e,t){return Array.isArray(e)||(e=[]),!t||e.length<=t?{older:e,newer:[]}:{older:e.slice(0,t),newer:e.slice(t)}}return{categoryTooltip:function(e,a){return i({trigger:"axis",formatter:function(r){r=t.array.ensureArray(r);var i=r[0].name,o=r.map(function(e){return{color:e.series.colors.line,name:e.seriesName,value:e.value}});if(!i.length&&!o.filter(function(e){return"-"!==e.value}).length)return"";var s={nameFormatter:a,valueFormatter:e};return n(i,o,s)}})},timelineChartFix:function(e,t){console.warn("Echarts does not have a good experience for time series. We suggest to use category as x-axis type."),e.tooltip=i({trigger:"item",formatter:function(e){var a=[{color:e.series.colors.line,name:e.series.name,value:e.value[1]}];return n(e.value[0],a,t)}}),angular.forEach(e.xAxis,function(e){delete e.boundaryGap}),angular.forEach(e.series,function(e){e.showAllSymbol=!0,e.stack=!1})},validateSeriesNames:function(e,n){if(!e.seriesNames){var a=t.array.ensureArray(n[0].y);a.length>1&&console.warn({message:"You should define `options.seriesNames`",options:e}),e.seriesNames=a.map(function(e,t){return"Series "+(t+1)})}},axisLabelFormatter:function(e){return function(n){if(angular.isNumber(n)&&(n=Number(n),0!==n)){var a=t.text.toHumanReadableNumber(n,1e3,1);n=a.value+(e?" "+a.modifier+e:a.modifier.toLowerCase())}return n}},makeDataSeries:function(e){var t={type:e.type||"line",symbol:"circle",symbolSize:4,smooth:e.smooth,itemStyle:{normal:{color:e.colors.line,lineStyle:{width:e.stack?4:3},borderColor:"transparent",borderWidth:6},emphasis:{color:e.colors.hover,borderColor:zrender.tool.color.alpha(e.colors.line,.3)}}};return e.stack?t.itemStyle.normal.areaStyle={type:"default",color:e.colors.area}:e.showAllSymbol&&(t.itemStyle.normal.lineStyle.width-=1),angular.merge(e,t)},fillAxisData:function(e,t,n){if(t=t||[],angular.isObject(n)&&(angular.isString(n.groupId)&&n.groupId.length&&(e.groupId=n.groupId),n.visibleDataPointsNum>0)){e.visibleDataPointsNum=n.visibleDataPointsNum;for(var a={x:"",y:e.series.map(function(){return{value:"-",tooltip:{}}})};t.length<n.visibleDataPointsNum;)t.unshift(a)}var r=o(t,e.visibleDataPointsNum);if(r.newer.length&&(e.dataPointsQueue=r.newer),delete e.xAxis[0].data,angular.forEach(e.series,function(e){e.data=[]}),"time"===e.xAxis[0].type)angular.forEach(r.older,function(t){angular.forEach(e.series,function(e,n){e.data.push([t.x,Array.isArray(t.y)?t.y[n]:t.y])})});else{var i=[];angular.forEach(r.older,function(t){i.push(t.x),angular.forEach(e.series,function(e,n){e.data.push(Array.isArray(t.y)?t.y[n]:t.y)})}),e.xAxis[0].data=i}},lineChartColorRecommendation:function(e){var n=t.color.palette;switch(e){case 1:return[n.blue];case 2:return[n.blue,n.blueishGreen];default:return t.array.repeatArray([n.blue,n.purple,n.blueishGreen,n.darkRed,n.orange],e)}},barChartColorRecommendation:function(e){var n=t.color.palette;switch(e){case 1:return[n.lightBlue];case 2:return[n.blue,n.darkBlue];default:return t.array.repeatArray([n.lightGreen,n.darkGray,n.lightBlue,n.blue,n.darkBlue],e)}},buildColorStates:function(e){return{line:e,area:zrender.tool.color.lift(e,-.92),hover:zrender.tool.color.lift(e,.15)}}}}]),angular.module("dashing.charts.line",["dashing.charts.echarts"]).directive("lineChart",function(){return{restrict:"E",template:'<echart options="::echartOptions" data="data"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope","$echarts",function(e,t){var n=angular.merge({seriesStacked:!0,seriesLineSmooth:!1,showLegend:!0,yAxisSplitNum:3,yAxisShowSplitLine:!0,yAxisLabelWidth:60,yAxisLabelFormatter:t.axisLabelFormatter(""),yAxisScaled:!1,xAxisShowLabels:!0},e.options),a=n.data;t.validateSeriesNames(n,a),Array.isArray(n.colors)&&n.colors.length||(n.colors=t.lineChartColorRecommendation(n.seriesNames.length||1));var r=n.colors.map(function(e){return t.buildColorStates(e)}),i="#ccc",o={length:4,lineStyle:{width:1,color:i}},s={height:n.height,width:n.width,tooltip:angular.merge(t.categoryTooltip(n.valueFormatter),{axisPointer:{type:"line",lineStyle:{width:3,color:"rgb(235,235,235)",type:"dotted"}}}),grid:angular.merge({borderWidth:0,x:Math.max(15,n.yAxisLabelWidth),x2:15,y:20,y2:25},n.grid),xAxis:[{type:n.xAxisTypeIsTime?"time":undefined,boundaryGap:n.xAxisBoundaryGap,axisLine:angular.merge({onZero:!1},o),axisTick:o,axisLabel:{show:!0},splitLine:!1}],yAxis:[{splitNumber:n.yAxisSplitNum,splitLine:{show:n.yAxisShowSplitLine,lineStyle:{color:i,type:"dotted"}},axisLine:!1,axisLabel:{formatter:n.yAxisLabelFormatter},scale:n.yAxisScaled}],series:n.seriesNames.map(function(e,a){return t.makeDataSeries({name:e,colors:r[a],stack:n.seriesStacked,smooth:n.seriesLineSmooth,showAllSymbol:n.showAllSymbol,yAxisIndex:Array.isArray(n.seriesYAxisIndex)?n.seriesYAxisIndex[a]:0})}),color:n.colors};if(_.contains(n.seriesYAxisIndex,1)){var l=angular.copy(s.yAxis[0]);angular.isFunction(n.yAxis2LabelFormatter)&&(l.axisLabel.formatter=n.yAxis2LabelFormatter),s.yAxis.push(l),s.grid.x2=s.grid.x}t.fillAxisData(s,a,n),n.xAxisShowLabels||(s.xAxis[0].axisLabel=!1,s.grid.y2=s.grid.y),n.xAxisTypeIsTime&&t.timelineChartFix(s,n),1===s.series.length&&(s.yAxis.boundaryGap=[0,.1]);var c=20,u=16;n.title&&(s.title={text:n.title,x:0,y:3},s.grid.y+=c);var d=s.series.length>1&&n.showLegend;d&&(s.legend={show:!0,itemWidth:8,data:s.series.map(function(e){return e.name})},s.legend.y=6,n.title&&(s.legend.y+=c,s.grid.y+=u)),(d||n.title)&&(s.grid.y+=12),e.echartOptions=s}]}}),angular.module("dashing.charts.metrics_sparkline",["dashing.charts.sparkline","dashing.metrics"]).directive("metricsSparklineChartTd",function(){return{restrict:"E",templateUrl:"charts/metrics_sparkline_td.html",scope:{caption:"@",help:"@",current:"@",unit:"@",subText:"@",options:"=optionsBind",data:"=datasourceBind"}}}),angular.module("dashing.charts.ring",["dashing.charts.echarts"]).directive("ringChart",function(){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){var n=t.getChartControl();n.setOption({series:[{data:[{value:e.available.value},{value:e.used.value}]}]})})},controller:["$scope","$element","$echarts",function(e,t,n){var a=angular.merge({color:"rgb(35,183,229)",thickness:.25},e.options);(!angular.isNumber(a.thickness)||a.thickness>1||a.thickness<=0)&&(console.warn({message:"Invalid thickness value",value:a.thickness}),a.thickness=.25);var r=a.data||e.data;r||console.warn("Need data to render the ring pie chart.");var i=n.buildColorStates(a.color),o=8,s=(parseInt(a.height)-30-2*o)/2,l=Math.floor(s*(1-a.thickness)),c=Math.floor(28*l/39);12>c&&console.warn("Please increase the height to get a better visual experience.");var u={normal:{color:"rgb(232,239,240)",label:{show:!0,position:"center"},labelLine:!1}},d={height:a.height,width:a.width,grid:{borderWidth:0},xAxis:[{show:!1,data:[0]}],legend:{selectedMode:!1,itemGap:20,itemWidth:13,y:"bottom",data:[r.used.label,r.available.label].map(function(e){return{name:e,textStyle:{fontWeight:500},icon:"a"}})},series:[{type:"pie",center:["50%",s+o],radius:[l,s],data:[{name:r.available.label,value:r.available.value,itemStyle:u},{name:r.used.label,value:r.used.value,itemStyle:angular.merge({},u,{normal:{color:i.line}})}]}]};if(d.series[0].itemStyle={normal:{label:{formatter:function(){return Math.round(100*e.data.used.value/(e.data.used.value+e.data.available.value))+"%"},textStyle:{color:"#111",fontSize:Math.floor(28*l/39),fontWeight:500,baseline:"middle"}}}},a.title){d.series[0].center[0]=s+o,d.legend.x=o,d.title={text:a.title,x:2*(s+o)+o+4,y:s+o+4,textStyle:{
fontSize:12,fontWeight:500,color:"#666"}};var p=d.title.x+14,h=d.title.y-48,g=e.data.used.value+e.data.available.value,b=e.data.used.unit,m="-webkit-touch-callout: none;-webkit-user-select: none;-khtml-user-select: none;-moz-user-select: none;-ms-user-select: none;user-select: none;";angular.element(t[0]).append(['<div style="position: absolute; left: '+p+"px; top: "+h+'px">','<p style="cursor: default; '+m+'">','<span style="font-size: 40px; font-weight: 500">'+g+"</span>",b?'<span style="font-size: 15px; font-weight: 700">'+b+"</span>":"","</p>","</div>"].join(" "))}e.echartOptions=d}]}}),angular.module("dashing.charts.sparkline",["dashing.charts.echarts"]).directive("sparklineChart",["$echarts",function(e){return{restrict:"E",template:'<echart options="::echartOptions"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(e){var t=e.$$childHead;e.$watch("data",function(e){e&&t.addDataPoints(e)})},controller:["$scope",function(t){var n=angular.merge({color:"rgb(0,119,215)"},t.options);n.xAxisTypeIsTime&&(console.warn("Echarts does not have a good experience for time series, so we fallback to category."),n.xAxisTypeIsTime=!1);var a=e.buildColorStates(n.color),r={height:n.height,width:n.width,tooltip:e.categoryTooltip(n.valueFormatter),grid:angular.merge({borderWidth:1,x:5,y:5,x2:5,y2:1},n.grid),xAxis:[{type:n.xAxisTypeIsTime?"time":undefined,boundaryGap:!1,axisLabel:!1,splitLine:!1}],yAxis:[{boundaryGap:[0,.1],show:!1}],series:[e.makeDataSeries({colors:a,stack:!0})]};"bar"===n.series0Type&&(r.grid.borderWidth=0,r.grid.y2=0,r.xAxis[0].boundaryGap=!0,r.series[0].type="bar");var i=n.data;e.fillAxisData(r,i,n),t.echartOptions=r}]}}]),angular.module("dashing.contextmenu",["mgcrea.ngStrap.dropdown"]).factory("$contextmenu",function(){return{popup:function(e,t){var n=angular.element(e);n.css({left:t.x+"px",top:t.y+"px"}),n.triggerHandler("click")}}}),angular.module("dashing.filters.any",[]).filter("any",function(){return function(e,t){return Array.isArray(e)?e.filter(function(e){for(var n=Object.keys(t),a=0;a<n.length;a++){var r=n[a],i=angular.lowercase(t[r]||""),o=angular.lowercase(e[r]||"");if(-1!==o.indexOf(i))return!0}return!1}):e}}),angular.module("dashing.filters.duration",["dashing.util"]).filter("duration",["dashing.util",function(e){return function(t,n){return e.text.toHumanReadableDuration(t,n)}}]),angular.module("dashing.forms.form_control",["ngSanitize","dashing.filters.any","dashing.util.validation","mgcrea.ngStrap","ui.select"]).directive("formControl",["dashing.util.validation",function(validation){function buildChoicesForSelect(e){var t=[];return angular.forEach(e,function(e,n){angular.isString(e)&&(e={text:e}),t.push({value:n,text:e.text,subtext:e.subtext})}),t}function buildChoicesForRadioGroup(e){var t=[];return angular.forEach(e,function(e,n){t.push({value:n,text:e})}),t}function buildChoicesForDropDownMenu(e,t){return e.map(function(e){return angular.isString(e)&&(e={text:e}),{text:(e.icon?'<i class="'+e.icon+'"></i> ':"")+e.text,click:function(){t(e.text)}}})}return{restrict:"E",templateUrl:"forms/form_controls.html",replace:!0,scope:{help:"@",value:"=ngModel",invalid:"="},link:function(scope,elem,attrs){switch(scope.labelStyleClass=attrs.labelStyleClass||"col-sm-3",scope.controlStyleClass=attrs.controlStyleClass||"col-sm-9",scope.choiceIconStyleClass=attrs.choiceIconStyleClass||"glyphicon glyphicon-menu-hamburger",scope.label=attrs.label,scope.renderAs=attrs.type,scope.pristine=!0,scope.invalid=attrs.required,attrs.type){case"class":scope.renderAs="text",scope.validateFn=validation["class"];break;case"choices":scope.placeholder=attrs.searchPlaceholder,scope.choices=buildChoicesForSelect(eval("("+attrs.choices+")")),scope.allowSearchInChoices=attrs.hasOwnProperty("searchEnabled")?"true"===attrs.searchEnabled:Object.keys(scope.choices).length>=5,scope.allowClearSelection=!attrs.required;break;case"radio":scope.choices=buildChoicesForRadioGroup(eval("("+attrs.choices+")")),scope.buttonStyleClass=attrs.btnStyleClass||"btn-sm",scope.toggle=function(e){scope.value=e};break;case"multi-checks":scope.choices=eval("("+attrs.choices+")"),Array.isArray(scope.choices)||(scope.choices=[attrs.choices]),Array.isArray(scope.value)||(scope.value=scope.choices.map(function(){return!1}));break;case"check":scope.text=scope.label,scope.label="";break;case"integer":scope.min=attrs.min,scope.max=attrs.max,scope.validateFn=function(e){return validation.integerInRange(e,attrs.min,attrs.max)};break;case"datetime":scope.dateControlStyleClass=attrs.dateControlStyleClass||"col-md-5",scope.timeControlStyleClass=attrs.timeControlStyleClass||"col-md-4",scope.fillDefaultTime=function(){if(!scope.timeValue){var e=new Date;scope.timeValue=[(e.getHours()+100).toString().slice(1),(e.getMinutes()+100).toString().slice(1),"00"].join(":")}},scope.dateInputInvalid=!1,scope.timeInputInvalid=!1,scope.$watch("dateValue",function(e,t){scope.dateInputInvalid=angular.isUndefined(e)&&!angular.isUndefined(t),scope.invalid=scope.dateInputInvalid||scope.timeInputInvalid,e&&(scope.value=[e,scope.timeValue])}),scope.$watch("timeValue",function(e,t){scope.timeInputInvalid=angular.isUndefined(e)&&!angular.isUndefined(t),scope.invalid=scope.dateInputInvalid||scope.timeInputInvalid,e&&(scope.value=[scope.dateValue,e])}),scope.$watchCollection("value",function(e){Array.isArray(e)&&2===e.length&&(scope.dateValue=e[0],scope.timeValue=e[1])});break;case"upload":scope.acceptPattern=attrs.acceptPattern,scope.filename="",scope.$watch("files",function(e){Array.isArray(e)&&e.length?(scope.value=e[0],scope.filename=e[0].name):(scope.value=null,scope.filename="")}),scope.openUpload=function(){if(!scope.files){var e=elem.find("span");if(e.length>2){var t=e[e.length-2];t.click()}}},scope.clearSelection=function(){scope.files=null};break;default:scope.hideMenuCaret=-1!==["true","1"].indexOf(String(attrs.hideMenuCaret))}"text"===scope.renderAs&&attrs.choices&&(scope.choicesMenu=buildChoicesForDropDownMenu(eval("("+attrs.choices+")"),function(e){scope.value=e})),scope.$watch("value",function(e){scope.pristine="integer"!==attrs.type&&0===(e||"").length,scope.invalid=angular.isFunction(scope.validateFn)&&!scope.validateFn(e)||attrs.required&&scope.pristine})}}}]),angular.module("dashing.forms.searchbox",[]).directive("searchbox",function(){return{restrict:"E",templateUrl:"forms/searchbox.html",scope:{placeholder:"@",ngModel:"="}}}),angular.module("dashing.metrics",[]).directive("metrics",function(){return{restrict:"E",templateUrl:"metrics/metrics.html",scope:{caption:"@",value:"@",unit:"@",unitPlural:"@",subText:"@",help:"@",remarkType:"@",clickHelp:"&"}}}),angular.module("dashing.progressbar",[]).directive("progressbar",function(){return{restrict:"E",templateUrl:"progressbar/progressbar.html",scope:{current:"@",max:"@",colorMapperFn:"="},link:function(e,t,n){function a(t,n){e.usage=n>0?Math.round(100*t/n):-1,e.usageClass=(e.colorMapperFn?e.colorMapperFn:r)(e.usage)}function r(e){return"progress-bar-"+(50>e?"info":75>e?"warning":"danger")}n.$observe("current",function(e){a(Number(e),Number(n.max))}),n.$observe("max",function(e){a(Number(n.current),Number(e))})}}}),angular.module("dashing.property.number",["dashing.util"]).directive("number",["$filter","dashing.util",function(e,t){return{restrict:"E",templateUrl:"property/number.html",scope:{raw:"@"},link:function(n,a,r){var i=-1!==["true","1"].indexOf(String(r.readable));r.$observe("raw",function(a){if(i){var o=t.text.toHumanReadableNumber(Number(a),1024);n.value=o.value.toFixed(0),n.unit=o.modifier+r.unit}else n.value=e("number")(a,Number(r.precision)||0),n.unit=r.unit})}}}]),angular.module("dashing.property",["mgcrea.ngStrap.tooltip"]).directive("property",function(){return{restrict:"E",templateUrl:"property/property.html",replace:!1,scope:{value:"=valueBind",renderer:"@"},controller:["$scope","dsPropertyRenderer",function(e,t){e.renderer===t.BYTES&&(console.warn("deprecated: should use renderer NUMBER instead"),e.renderer=t.NUMBER),e.$watch("value",function(n){if(angular.isObject(n)){switch(e.renderer){case t.LINK:n.href||(e.href=n.text);break;case t.BUTTON:n.href&&!n.click&&(e.click=function(){if(n.target){var e=window.open(n.href,n.target);e.focus()}else location.href=n.href})}n.hasOwnProperty("value")&&(console.warn({message:"Ignore `value.value`, because it is a reversed field.",object:n}),delete n.value),angular.merge(e,n)}else angular.isNumber(n)&&e.renderer===t.NUMBER&&(e.raw=n)})}]}}).constant("dsPropertyRenderer",{BUTTON:"Button",BYTES:"Bytes",DATETIME:"DateTime",DURATION:"Duration",INDICATOR:"Indicator",LINK:"Link",NUMBER:"Number",NUMBER1:"Number1",NUMBER2:"Number2",PROGRESS_BAR:"ProgressBar",TAG:"Tag",TEXT:undefined}),angular.module("dashing.remark",["mgcrea.ngStrap.tooltip"]).directive("remark",function(){return{restrict:"E",templateUrl:"remark/remark.html",scope:{tooltip:"@",placement:"@",type:"@"},link:function(e){e.$watch("type",function(t){switch(t){case"info":e.styleClass="glyphicon glyphicon-info-sign remark-icon";break;case"warning":e.styleClass="glyphicon glyphicon-warning-sign remark-icon-warning";break;default:e.styleClass="glyphicon glyphicon-question-sign remark-icon"}})}}}),angular.module("dashing.state.indicator",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("indicator",["dashing.util",function(e){return{restrict:"E",templateUrl:"state/indicator.html",scope:{tooltip:"@",shape:"@"},link:function(t,n,a){a.condition||(a.condition=""),a.$observe("condition",function(n){t.colorStyle=e.color.conditionToColor(n)}),a.$observe("tooltip",function(e){t.cursorStyle=e?"pointer":"default"})}}}]),angular.module("dashing.state.tag",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("tag",["dashing.util",function(e){return{restrict:"E",templateUrl:"state/tag.html",scope:{href:"@",text:"@",tooltip:"@"},link:function(t,n,a){a.condition||(a.condition=""),a.$observe("condition",function(n){t.labelColorClass=e.bootstrap.conditionToBootstrapLabelClass(n)}),a.$observe("tooltip",function(e){t.href||(t.cursorStyle=e?"pointer":"default")})}}}]),angular.module("dashing.tables.property_table",[]).directive("propertyTable",function(){return{restrict:"E",templateUrl:"tables/property_table/property_table.html",scope:{caption:"@",props:"=propsBind",propNameClass:"@",propValueClass:"@"}}}),angular.module("dashing.tables.property_table.builder",[]).factory("$propertyTableBuilder",["dsPropertyRenderer",function(e){var t=function(e,t){this.props=e?{renderer:e}:{},t&&this.title(t)};return t.prototype.title=function(e){return this.props.name=e,this},t.prototype.help=function(e){return this.props.help=e,this},t.prototype.value=function(e){return this.props.value=e,this},t.prototype.values=function(e){return Array.isArray(e)||(console.warn("values must be an array"),e=[e]),this.props.values=e,this},t.prototype.done=function(){return this.props},{button:function(n){return new t(e.BUTTON,n)},bytes:function(n){return console.warn("deprecated: should use number() instead"),new t(e.BYTES,n)},datetime:function(n){return new t(e.DATETIME,n)},duration:function(n){return new t(e.DURATION,n)},indicator:function(n){return new t(e.INDICATOR,n)},link:function(n){return new t(e.LINK,n)},number:function(n){return new t(e.NUMBER,n)},number1:function(n){return new t(e.NUMBER1,n)},number2:function(n){return new t(e.NUMBER2,n)},progressbar:function(n){return new t(e.PROGRESS_BAR,n)},tag:function(n){return new t(e.TAG,n)},text:function(n){return new t(e.TEXT,n)},$update:function(e,t){return angular.forEach(t,function(t,n){var a=Array.isArray(t)?"values":"value";e[n][a]=t}),e}}}]),angular.module("dashing.tables.sortable_table",["smart-table","dashing.property","dashing.util"]).directive("sortableTable",["dsPropertyRenderer","dashing.util",function(e,t){return{restrict:"E",templateUrl:"tables/sortable_table/sortable_table.html",scope:{caption:"@",pagination:"@",columns:"=columnsBind",records:"=recordsBind",search:"=searchBind"},link:function(n,a){var r=a.find("input")[0];n.$watch("search",function(e){r.value=e||"",angular.element(r).triggerHandler("input")}),n.$watch("columns",function(a){if(!Array.isArray(a))return void console.warn("Failed to create table, until columns are defined.");n.columnStyleClass=a.map(function(e){function t(e,t,n){n&&e.push(t)}var n=[];return t(n,e.styleClass,e.styleClass!==undefined),t(n,"text-right",e.renderer&&0===e.renderer.indexOf("Number")),t(n,"text-nowrap",Array.isArray(e.key)&&!e.vertical),n.join(" ")});var r=a.map(function(t){return Array.isArray(t.key)||t.renderer!==e.INDICATOR?void 0:t.key});n.bgColorForStripeFix=function(e,n){var a=r[e];if(a){var i=n[a];if("stripe"===i.shape)return t.color.conditionToColor(i.condition)}},n.multipleRendererColumnsRenderers=a.map(function(e){return Array.isArray(e.key)?Array.isArray(e.renderer)?(e.renderer.length!==e.key.length&&console.warn("Every column key should have a renderer, or share one renderer."),e.renderer):e.key.map(function(){return e.renderer}):null})}),n.isArray=Array.isArray}}}]).directive("stSummary",function(){return{require:"^stTable",template:"Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records",link:function(e,t,n,a){e.stRange={from:null,to:null},e.$watch("currentPage",function(){var t=a.tableState().pagination;e.stRange.from=t.start+1,e.stRange.to=e.currentPage===t.numberOfPages?t.totalItemCount:e.stRange.from+e.stItemsByPage-1})}}}).config(["stConfig",function(e){e.sort.skipNatural=!0,e.sort.delay=-1}]),angular.module("dashing.tables.sortable_table.builder",["dashing.property","dashing.util"]).factory("$sortableTableBuilder",["dashing.util","dsPropertyRenderer",function(e,t){function n(e,t,n){var a=!0;return angular.forEach(t,function(r,i){var o=e[i];return o.hasOwnProperty(n)&&o.key===t.key?void 0:(a=!1,!1)}),a}var a=function(e,t){this.props=e?{renderer:e}:{},t&&this.title(t)};return a.prototype.title=function(e){return this.props.name=e,this},a.prototype.key=function(e){return this.props.key=e,this},a.prototype.canSort=function(e){if(!e){if(!this.props.key)return void console.warn('The column does not have a key. Call `.key("some")` first!');Array.isArray(this.props.key)&&(console.warn("Multiple keys found. We use the first key for sorting by default."),e=this.props.key[0])}if(this.props.sortKey=e||this.props.key,this.props.sortKey===this.props.key)switch(this.props.renderer){case t.LINK:this.props.sortKey+=".text";break;case t.INDICATOR:case t.TAG:this.props.sortKey+=".condition";break;case t.PROGRESS_BAR:this.props.sortKey+=".usage";break;case t.BYTES:this.props.sortKey+=".raw";break;case t.BUTTON:return void console.warn('"%s" column is not sortable.')}return this},a.prototype.sortDefault=function(e){return this.props.sortKey?(this.props.defaultSort=e?"reverse":!0,this):void console.warn("Specify a sort key or define column key first!")},a.prototype.sortDefaultDescent=function(){return this.sortDefault(!0)},a.prototype.styleClass=function(e){return this.props.styleClass=e,this},a.prototype.sortBy=function(e){return this.props.sortKey=e,this},a.prototype.unit=function(e){return this.props.unit=e,this},a.prototype.help=function(e){return this.props.help=e,this},a.prototype.vertical=function(){return Array.isArray(this.props.key)&&(this.props.vertical=!0),this},a.prototype.done=function(){return this.props},{button:function(e){return new a(t.BUTTON,e)},bytes:function(e){return console.warn("deprecated: should use number instead"),new a(t.BYTES,e)},datetime:function(e){return new a(t.DATETIME,e)},duration:function(e){return new a(t.DURATION,e)},indicator:function(e){return new a(t.INDICATOR,e)},link:function(e){return new a(t.LINK,e)},multiple:function(e,t){return new a(t,e)},number:function(e){return new a(t.NUMBER,e)},number1:function(e){return new a(t.NUMBER1,e)},number2:function(e){return new a(t.NUMBER2,e)},progressbar:function(e){return new a(t.PROGRESS_BAR,e)},tag:function(e){return new a(t.TAG,e)},text:function(e){return new a(t.TEXT,e)},$update:function(e,t,a){return(e||[]).length!==(t||[]).length?t:angular.isString(a)&&!n(e,t,a)?t:(angular.forEach(t,function(t,n){e[n]=t}),e)},$check:function(t,n){angular.forEach(t,function(t){var a=e.array.ensureArray(t.key);angular.forEach(a,function(e){n.hasOwnProperty(e)||console.warn("Model does not have a property matches column key `"+t+"`.")})})}}}]),angular.module("dashing.tabset",[]).directive("tabset",[function(){return{restrict:"E",templateUrl:"tabset/tabset.html",transclude:!0,scope:!0,controller:["$scope",function(e){function t(e,t){angular.forEach(n,function(t){t.selected=t===e}),e.load!==undefined&&e.load(t)}var n=e.tabs=[];this.addTab=function(e){n.push(e),1===n.length&&t(e)},e.selectTab=function(e,a){e>=0&&e<n.length&&t(n[e],a)}}]}}]).directive("tab",["$http","$controller","$compile",function(e,t,n){return{restrict:"E",require:"^tabset",template:'<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',replace:!0,transclude:!0,link:function(a,r,i,o){function s(e){r.html(e);var o=a.$new(!1);if(i.controller){var s=t(i.controller,{$scope:o});r.children().data("$ngController",s)}n(r.contents())(o),a.loaded=!0}a.heading=i.heading,a.loaded=!1,a.load=function(t){(!a.loaded||t)&&i.template&&e.get(i.template).then(function(e){s(e.data)})},o.addTab(a)}}}]),angular.module("dashing.util.array",[]).factory("dashing.util.array",function(){return{alignArray:function(e,t,n){if(t<=e.length)return e.slice(0,t);for(var a=angular.copy(e),r=a.length;t>r;r++)a.push(n);return a},repeatArray:function(e,t){if(t<=e.length)return e.slice(0,t);for(var n=[],a=0;t>a;a++)n.push(e[a%e.length]);return n},ensureArray:function(e){return Array.isArray(e)?e:[e]}}}),angular.module("dashing.util.color",[]).factory("dashing.util.color",function(){return{palette:{blue:"rgb(0,119,215)",blueishGreen:"rgb(41,189,181)",orange:"rgb(255,127,80)",purple:"rgb(110,119,215)",skyBlue:"rgb(91,204,246)",darkBlue:"rgb(102,168,212)",darkGray:"rgb(92,92,97)",darkPink:"rgb(212,102,138)",darkRed:"rgb(212,102,138)",lightBlue:"rgb(93,201,242)",lightGreen:"rgb(169,255,150)"},conditionToColor:function(e){switch(e){case"good":return"#5cb85c";case"concern":return"#f0ad4e";case"danger":return"#d9534f";default:return"#aaa"}}}}),angular.module("dashing.util.text",[]).factory("dashing.util.text",function(){return{toHumanReadableNumber:function(e,t,n){var a="";if(0!==e){1024!==t&&(t=1e3);var r=e>0,i=Math.abs(e),o=["","K","M","G","T","P","E","Z","Y"],s=Math.floor(Math.log(i)/Math.log(t));e=i/Math.pow(t,s),n>0&&e!==Math.floor(e)&&(e=e.toFixed(n)),r||(e*=-1),a=o[s]}return{value:e,modifier:a}},toHumanReadableDuration:function(e,t){var n=parseInt(e,10);if(isNaN(n))return e;for(var a=[{label:" ms",mod:1e3},{label:t?"s":" secs",mod:60},{label:t?"m":" mins",mod:60},{label:t?"h":" hours",mod:24},{label:t?"d":" days",mod:7},{label:t?"w":" weeks",mod:52}],r=[],i=0;i<a.length;i++){var o=a[i],s=n%o.mod;0!==s&&r.unshift({label:o.label,value:s}),n=(n-s)/o.mod}return r=r.slice(0,2),r.length>1&&" ms"===r[1].label&&(r=[r[0]]),r.map(function(e){return e.value+e.label}).join(t?" ":" and ")}}}),angular.module("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text","dashing.util.validation"]).factory("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text","dashing.util.validation",function(e,t,n,a,r){return{array:e,bootstrap:t,color:n,text:a,validation:r}}]),angular.module("dashing.util.validation",[]).factory("dashing.util.validation",function(){var e={"class":function(e){return/^[a-zA-Z_][a-zA-Z_\d]*(\.[a-zA-Z_][a-zA-Z_\d]*)*$/i.test(e)},integer:function(e){return/^-?\d+$/.test(e)},integerInRange:function(t,n,a){return e.integer(t)?(t=Number(t),(isNaN(n)||t>=n)&&(isNaN(a)||a>=t)):!1}};return e})}(window,document);
//# sourceMappingURL=dashing.min.js.map
