/*! dashing (assembled widgets) v0.4.4 | Apache License 2.0 | https://github.com/stanleyxu2005/dashing */
!function(window,document,undefined){"use strict";angular.module("dashing",["dashing.charts.bar","dashing.charts.line","dashing.charts.metrics_sparkline","dashing.charts.ring","dashing.charts.sparkline","dashing.forms.form_control","dashing.forms.searchbox","dashing.metrics","dashing.progressbar","dashing.property","dashing.property.number","dashing.remark","dashing.state.indicator","dashing.state.tag","dashing.tables.property_table","dashing.tables.sortable_table","dashing.tabset","dashing.contextmenu","dashing.tables.property_table.builder","dashing.tables.sortable_table.builder","dashing.filters.any","dashing.filters.duration"]),angular.module("dashing").run(["$templateCache",function(t){t.put("charts/metrics_sparkline_td.html",'<metrics caption="{{caption}}" ng-attr-help="{{help}}" value="{{current}}" unit="{{unit}}" sub-text="{{subText}}" class="metrics-thicker-bottom"> </metrics> <sparkline-chart options-bind="options" datasource-bind="data"> </sparkline-chart>'),t.put("forms/datepicker.html",'<div class="dropdown-menu datepicker" ng-class="\'datepicker-mode-\' + $mode" style="max-width: 320px"> <table style="table-layout: fixed; height: 100%; width: 100%"> <thead> <tr class="text-center dt-header"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$selectPane(-1)"> <i class="glyphicon glyphicon-triangle-left"></i> </button> </th> <th colspan="{{ rows[0].length - 2 }}"> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius btn-block text-strong" ng-click="$toggleMode()"> <strong style="text-transform: capitalize" ng-bind="title"></strong> </button> </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-right" ng-click="$selectPane(+1)"> <i class="glyphicon glyphicon-triangle-right"></i> </button> </th> </tr> <tr ng-if="showLabels" ng-bind-html="labels"></tr> </thead> <tbody> <tr ng-repeat="(i, row) in rows track by $index" style="height: 21px"> <td class="text-center" ng-repeat="(j, el) in row track by $index"> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius" style="width: 100%; padding: 4px 3px" ng-class="{\'btn-primary\': el.selected, \'btn-info btn-today\': el.isToday && !el.selected}" ng-click="$select(el.date)" ng-disabled="el.disabled"> <span ng-class="{\'text-muted\': el.muted}" ng-bind="el.label"></span> </button> </td> </tr> </tbody> </table> </div>'),t.put("forms/form_controls.html",'<div class="form-group"> <label class="{{labelStyleClass}} control-label text-right"> <span ng-bind="label"></span> <span ng-if="help" style="font-size: 0.9em"> <remark tooltip="{{help}}" type="info"></remark> </span> </label> <ng-switch on="renderAs">  <div ng-switch-when="choices"> <div class="{{controlStyleClass}}"> <ui-select theme="select2" class="form-control" ng-model="$parent.$parent.value" search-enabled="allowSearchInChoices"> <ui-select-match placeholder="{{placeholder}}" allow-clear="{{allowClearSelection}}">{{$select.selected.text}} </ui-select-match> <ui-select-choices repeat="choice in choices|\n          any: {text: $select.search, subtext: $select.search}"> <div ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.text|highlight:$select.search"></div> <small ng-if="choice.subtext" ng-class="{\'bold\': $select.selected === choice}" ng-bind-html="choice.subtext|highlight:$select.search"></small> </ui-select-choices> </ui-select> </div> </div>  <div ng-switch-when="check"> <div class="{{controlStyleClass}} checkbox"> <label> <input type="checkbox" ng-checked="$parent.value" ng-click="$parent.value = !$parent.value"> <span ng-bind="text"></span> </label> </div> </div>  <div ng-switch-when="multi-checks"> <div class="{{controlStyleClass}}"> <label class="checkbox-inline" ng-repeat="choice in choices track by $index"> <input type="checkbox" ng-checked="$parent.value[$index]" ng-click="$parent.value[$index] = !$parent.value[$index]"> <span ng-bind="choice"></span> </label> </div> </div>  <div ng-switch-when="radio"> <div class="{{controlStyleClass}}"> <div class="btn-group btn-group-justified"> <div ng-repeat="choice in choices track by $index" class="btn-group"> <button type="button" class="btn {{buttonStyleClass}} btn-default" ng-class="{\'btn-primary\': choice.value == value}" ng-bind="choice.text" value="{{choice.value}}" ng-click="toggle(choice.value)"></button> </div> </div> </div> </div>  <div ng-switch-when="integer"> <div class="{{controlStyleClass}}" ng-class="{\'has-error\': !pristine && invalid}"> <input type="number" class="form-control input-sm" ng-attr-min="{{min}}" ng-attr-max="{{max}}" ng-model="$parent.value"> </div> </div>  <div ng-switch-when="datetime"> <div class="{{dateControlStyleClass}} has-feedback" ng-class="{\'has-error\': dateInputInvalid}"> <input class="form-control input-sm" data-date-format="yyyy-MM-dd" type="text" size="10" placeholder="YYYY-MM-DD" ng-click="fillDefaultDate()" ng-model="$parent.dateValue" date-type="string" data-autoclose="1" template-url="forms/datepicker.html" use-native="true" bs-datepicker> <span class="glyphicon glyphicon-calendar form-control-feedback fc-feedback-sm"></span> </div> <div class="{{timeControlStyleClass}} has-feedback" style="padding-left: 0" ng-class="{\'has-error\': timeInputInvalid}"> <input class="form-control input-sm" data-time-format="HH:mm:ss" type="text" size="8" placeholder="HH:mm:ss" ng-click="fillDefaultTime()" ng-model="$parent.timeValue" time-type="string" hour-step="1" minute-step="1" second-step="1" data-length="3" arrow-behavior="picker" template-url="forms/timepicker.html" use-native="true" bs-timepicker> <span class="glyphicon glyphicon-time form-control-feedback fc-feedback-sm"></span> </div> </div>  <div ng-switch-when="upload"> <div class="{{controlStyleClass}} has-feedback" ng-class="{\'has-error\': !pristine && invalid}"> <input type="text" readonly="readonly" class="form-control input-sm" placeholder="Click here to select a file" style="cursor: pointer" ng-click="openUpload()" ng-model="$parent.filename">  <span ng-hide="$parent.value" class="glyphicon glyphicon-folder-open form-control-feedback fc-feedback-sm clickable" ngf-select ng-model="$parent.files" accept="{{acceptPattern}}" ngf-accept="\'{{acceptPattern}}\'"></span> <span ng-show="$parent.value" class="glyphicon glyphicon-trash form-control-feedback fc-feedback-sm clickable" ng-click="clearSelection()"></span> </div> </div>  <div ng-switch-default> <div class="{{controlStyleClass}}"> <div ng-class="{\'has-error\': !pristine && invalid}"> <div ng-class="{\'input-group\': choicesMenu}"> <input type="text" class="form-control input-sm" ng-model="$parent.value"> <div ng-if="choicesMenu" class="input-group-btn"> <button type="button" class="btn btn-sm btn-default dropdown-toggle" bs-dropdown="choicesMenu" placement="auto bottom-left" html="true"> <span class="{{choiceIconStyleClass}} clickable"></span> <span ng-if="!hideMenuCaret" class="caret"></span> </button> </div> </div> </div> </div> </div> </ng-switch> </div>'),t.put("forms/searchbox.html",'<div class="form-group has-feedback"> <input type="text" class="form-control" ng-model="ngModel" placeholder="{{placeholder}}"> <small class="glyphicon glyphicon-search form-control-feedback"></small> </div>'),t.put("forms/timepicker.html",'<div class="dropdown-menu timepicker" style="min-width: 0; width: auto"> <table height="100%"> <thead> <tr class="text-center"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 0)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> <th> &nbsp; </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 1)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> <th> &nbsp; </th> <th> <button ng-if="showSeconds" tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(1, 2)"> <i class="glyphicon glyphicon-triangle-top"></i> </button> </th> </tr> </thead> <tbody> <tr ng-repeat="(i, row) in rows"> <td class="text-center"> <button tabindex="-1" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[0].selected}" ng-click="$select(row[0].date, 0)" ng-disabled="row[0].disabled"> <span ng-class="{\'text-muted\': row[0].muted}" ng-bind="row[0].label"></span> </button> </td> <td> <span class="time-separator" ng-bind="i == midIndex ? timeSeparator : \' \'"></span> </td> <td class="text-center"> <button tabindex="-1" ng-if="row[1].date" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[1].selected}" ng-click="$select(row[1].date, 1)" ng-disabled="row[1].disabled"> <span ng-class="{\'text-muted\': row[1].muted}" ng-bind="row[1].label"></span> </button> </td> <td> <span class="time-separator" ng-bind="i == midIndex ? timeSeparator : \' \'"></span> </td> <td class="text-center"> <button tabindex="-1" ng-if="showSeconds && row[2].date" style="width: 100%" type="button" class="btn btn-sm btn-default btn-no-radius" ng-class="{\'btn-primary\': row[2].selected}" ng-click="$select(row[2].date, 2)" ng-disabled="row[2].disabled"> <span ng-class="{\'text-muted\': row[2].muted}" ng-bind="row[2].label"></span> </button> </td> <td ng-if="showAM"> &nbsp; </td> <td ng-if="showAM"> <button tabindex="-1" ng-show="i == midIndex - !isAM * 1" style="width: 100%" type="button" ng-class="{\'btn-primary\': !!isAM}" class="btn btn-default" ng-click="$switchMeridian()" ng-disabled="el.disabled">AM</button> <button tabindex="-1" ng-show="i == midIndex + 1 - !isAM * 1" style="width: 100%" type="button" ng-class="{\'btn-primary\': !isAM}" class="btn btn-default" ng-click="$switchMeridian()" ng-disabled="el.disabled">PM</button> </td> </tr> </tbody> <tfoot> <tr class="text-center"> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 0)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> <th> &nbsp; </th> <th> <button tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 1)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> <th> &nbsp; </th> <th> <button ng-if="showSeconds" tabindex="-1" type="button" class="btn btn-sm btn-default btn-no-radius pull-left" ng-click="$arrowAction(-1, 2)"> <i class="glyphicon glyphicon-triangle-bottom"></i> </button> </th> </tr> </tfoot> </table> </div>'),t.put("metrics/metrics.html",'<div class="metrics"> <div> <span class="metrics-caption" ng-bind="caption"></span> <remark ng-if="help" type="{{remarkType}}" tooltip="{{help}}" ng-click="clickHelp()"></remark> </div> <h3 class="metrics-value"> <span ng-bind="value"></span> <ng-switch on="unitPlural && value > 1"> <small ng-switch-when="true" ng-bind="unitPlural"></small> <small ng-switch-default ng-bind="unit"></small> </ng-switch> </h3> <small ng-if="subText" class="metrics-sub-text" ng-bind="subText"></small> </div>'),t.put("progressbar/progressbar.html",'<div style="width: 100%">  <span class="small pull-left" ng-bind="current+\'/\'+max"></span> <span class="small pull-right" ng-bind="usage + \'%\'"></span> </div> <div style="clear: both; height: 1px"></div> <div style="width: 100%" class="progress progress-tiny"> <div ng-style="{\'width\': usage+\'%\'}" class="progress-bar {{usageClass}}"></div> </div>'),t.put("property/number.html",'<div> <span ng-bind="value"></span> <span ng-if="unit" ng-bind="unit"></span> </div>'),t.put("property/property.html",'<ng-switch on="renderer">  <a ng-switch-when="Link" ng-href="{{href}}" ng-bind="text" ng-attr-target="{{target}}"></a>  <button ng-switch-when="Button" ng-if="!hide" type="button" class="btn btn-default {{class}}" ng-bind="text" ng-click="click()" ng-disabled="disabled" ng-attr-bs-tooltip="tooltip"></button>  <tag ng-switch-when="Tag" text="{{text}}" ng-attr-href="{{href}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></tag>  <indicator ng-switch-when="Indicator" ng-attr-shape="{{shape}}" ng-attr-condition="{{condition}}" ng-attr-tooltip="{{tooltip}}"></indicator>  <progressbar ng-switch-when="ProgressBar" current="{{current}}" max="{{max}}"></progressbar>  <div ng-switch-when="Duration" ng-bind="value|duration"></div>  <div ng-switch-when="DateTime" ng-bind="value|date:\'yyyy-MM-dd HH:mm:ss\'"></div>  <number ng-switch-when="Number" raw="{{raw}}" ng-attr-unit="{{unit}}" ng-attr-precision="{{precision}}" ng-attr-readable="{{readable}}"></number>  <div ng-switch-when="Number1" ng-bind="value|number:1"></div>  <div ng-switch-when="Number2" ng-bind="value|number:2"></div>  <div ng-switch-default ng-bind="value"></div> </ng-switch>'),t.put("remark/remark.html",'<span class="{{styleClass}}" ng-attr-bs-tooltip="tooltip" ng-style="{cursor: tooltip ? \'pointer\': \'default\'}" ng-attr-placement="{{placement}}" ng-attr-trigger="{{trigger}}"></span>'),t.put("state/indicator.html",'<ng-switch on="shape"> <div ng-switch-when="stripe" ng-style="{\'background-color\': colorStyle}" style="display: inline-block; height: 100%; width: 8px; cursor: default" bs-tooltip="tooltip" placement="right auto"></div> <span ng-switch-default ng-style="{\'color\': colorStyle, \'cursor\': cursorStyle}" class="glyphicon glyphicon-stop" bs-tooltip="tooltip"></span> </ng-switch>'),t.put("state/tag.html",'<ng-switch on="!href"> <a ng-switch-when="false" ng-href="{{href}}" class="label label-lg {{labelColorClass}}" ng-bind="text" bs-tooltip="tooltip"></a> <span ng-switch-when="true" class="label label-lg {{labelColorClass}}" ng-style="{\'cursor\': cursorStyle}" ng-bind="text" bs-tooltip="tooltip"></span> </ng-switch>'),t.put("tables/property_table/property_table.html",'<table class="table table-striped table-hover"> <caption ng-if="caption"> {{caption}} <remark ng-if="captionTooltip" type="info" tooltip="{{captionTooltip}}" placement="right"></remark> <small ng-if="subCaption" class="visible-md" ng-bind="subCaption"></small> </caption> <tbody> <tr ng-repeat="prop in props track by $index"> <td ng-attr-ng-class="propNameClass"> <span ng-bind="prop.name"></span> <remark ng-if="prop.help" type="question" tooltip="{{prop.help}}"></remark> </td> <td ng-attr-ng-class="propValueClass"> <ng-switch on="prop.hasOwnProperty(\'values\')"> <property ng-switch-when="true" ng-repeat="value in prop.values track by $index" value-bind="value" renderer="{{::prop.renderer}}"></property> <property ng-switch-when="false" value-bind="prop.value" renderer="{{::prop.renderer}}"></property> </ng-switch> </td> </tr> </tbody> </table>'),t.put("tables/sortable_table/sortable_table.html",'<table class="table table-hover" st-table="showing" st-safe-src="records"> <caption ng-if="caption"> {{caption}} <remark ng-if="captionTooltip" type="info" tooltip="{{captionTooltip}}" placement="right"></remark> <small ng-if="subCaption" class="visible-md" ng-bind="subCaption"></small> </caption> <thead> <tr> <th ng-repeat="column in columns track by $index" class="{{::columnStyleClass[$index]}}" ng-attr-st-sort="{{::column.sortKey}}" ng-attr-st-sort-default="{{::column.defaultSort}}"> <span ng-bind="::column.name"></span> <remark ng-if="column.help" type="question" tooltip="{{::column.help}}"></remark> <span ng-if="column.unit" class="unit" ng-bind="::column.unit"></span> </th> </tr> <tr ng-show="false"> <th colspan="{{columns.length}}">  <input type="hidden" st-search>  <div st-pagination st-items-by-page="pagination"></div> </th> </tr> </thead> <tbody style="height: 100%"> <tr ng-repeat="record in showing track by $index" style="display: table-row; height: 100%"> <td ng-repeat="column in columns track by $index" class="{{columnStyleClass[$index]}}" style="height: 100%" ng-style="{\'background-color\': bgColorForStripeFix($index, record)}"> <ng-switch on="isArray(column.key)"> <property ng-switch-when="true" ng-repeat="columnKeyChild in column.key track by $index" value-bind="record[columnKeyChild]" renderer="{{multipleRendererColumnsRenderers[$parent.$index][$index]}}"></property> <property ng-switch-when="false" value-bind="record[column.key]" renderer="{{column.renderer}}"></property> </ng-switch> </td> </tr> <tr ng-if="search && (!showing || !showing.length)"> <td colspan="{{columns.length}}" class="text-center"> <h5 ng-bind="emptySearchResult"></h5> </td> </tr> <tr ng-if="!search && (!records || !records.length)"> <td colspan="{{columns.length}}" class="text-center" ng-transclude></td> </tr> </tbody> <tfoot ng-if="records.length"> <tr> <td colspan="{{columns.length}}" st-pagination st-items-by-page="pagination" st-template="tables/sortable_table/sortable_table_pagination.html"> </td> </tr> </tfoot> </table>'),t.put("tables/sortable_table/sortable_table_pagination.html",'<div class="pull-left hidden-sm hidden-xs" style="margin-bottom: 10px">  <st-summary></st-summary> </div> <div class="pull-right"> <div ng-if="pages.length >= 2" class="btn-group btn-group-xs tb-pagination"> <button ng-if="pages[0] > 1 + 10" type="button" class="btn btn-default" ng-click="selectPage(1)"> 1 </button> <button ng-if="pages[0] > 1" type="button" class="btn btn-default" ng-click="selectPage(currentPage - 1)"> &laquo;</button> <button type="button" class="btn btn-default" ng-repeat="page in pages track by $index" ng-class="{active: page == currentPage}" ng-click="selectPage(page)"> {{page}} </button> <button ng-if="pages[pages.length - 1] < numPages" type="button" class="btn btn-default" ng-click="selectPage(currentPage + 1)"> &raquo;</button> <button ng-if="pages[pages.length - 1] < numPages - 10" type="button" class="btn btn-default" ng-click="selectPage(numPages)"> {{numPages}} </button> </div> </div>'),t.put("tabset/tabset.html",'<ul class="nav nav-tabs nav-tabs-underlined"> <li ng-repeat="tab in tabs track by $index" ng-class="{active:tab.selected}"> <a href="" ng-click="selectTab($index)" ng-bind="tab.heading"></a> </li> </ul> <div class="tab-content" ng-transclude></div>')}]),angular.module("dashing.util.bootstrap",[]).factory("dashing.util.bootstrap",function(){return{conditionToBootstrapLabelClass:function(t){switch(t){case"good":return"label-success";case"concern":return"label-warning";case"danger":return"label-danger";default:return"label-default"}}}}),angular.module("dashing.charts.adapter.echarts",["dashing.util"]).directive("echart",["EchartWrapper",function(t){return{restrict:"E",template:"<div></div>",replace:!0,scope:{options:"=",api:"=",onResize:"&"},controller:["$scope","$element","dashing.charts.echarts.defaults",function(e,n,a){function r(){var t=e.onResize();return t?e.$apply():void s.resize()}var i=e.options,o=n[0];angular.forEach(["width","height"],function(t){i[t]&&(o.style[t]=i[t])});var s=echarts.init(o);s.setTheme(a.lookAndFeel),angular.element(window).on("resize",r),e.$on("$destroy",function(){angular.element(window).off("resize",r),s.dispose(),s=null}),e.api=new t(s),e.api.rebuild(i)}]}}]).service("EchartWrapper",["dashing.util",function(t){var e=function(t){this.chart=t,this.initOptions=null};return e.prototype={rebuild:function(t){return this.chart.hideLoading(),this.chart.clear(),this.initOptions=null,this.chart.setOption(t,!0),this.chart.resize(),this.isGraphDataAvailable()?(this.addDataPoints(t.dataPointsQueue,!0),void this._applyGroupingFix(t.groupId)):void(this.initOptions=angular.copy(t))},_applyGroupingFix:function(t){angular.isFunction(this.chart.group)&&String(t).length&&(this.chart.groupId=t,this.chart.group())},addDataPoints:function(t,e){if(!Array.isArray(t)||!t.length)return void(e||console.warn({msg:"Invalid input data points",data:t}));null!==this.initOptions&&this.rebuild(this.initOptions);var n=this.chart.getOption(),a=this._dataPointsToDataArray(t,n);a.length>0&&this.chart.addData(a)},_dataPointsToDataArray:function(t,e){try{var n=e.series[0].data.length,a=Math.max(0,(e.visibleDataPointsNum||Number.MAX_VALUE)-n),r="time"===e.xAxis[0].type||"value"===e.xAxis[0].type&&"time"===e.yAxis[0].type,i=e.series.length;return this._makeDataArray(t,i,a,r)}catch(o){}return[]},_makeDataArray:function(e,n,a,r){var i=[];return angular.forEach(t.array.ensureArray(e),function(e){var o=a-- >0,s=t.array.ensureArray(e.y).slice(0,n);if(r)angular.forEach(s,function(t,n){var a=[n,[e.x,t],!1,o];i.push(a)});else{var l=s.length-1;angular.forEach(s,function(t,n){var a=[n,t,!1,o];n===l&&a.push(e.x),i.push(a)})}}),i},isGraphDataAvailable:function(){var t=this.chart.getOption();return angular.isObject(t.xAxis)&&t.xAxis.length&&t.xAxis[0].data},updateOption:function(t){this.chart.setOption(t,!1)}},e}]).constant("dashing.charts.echarts.defaults",{lookAndFeel:{markLine:{symbol:["circle","circle"]},title:{textStyle:{fontSize:14,fontWeight:400,color:"#000"}},legend:{textStyle:{color:"#111",fontWeight:500},itemGap:20},tooltip:{borderRadius:2,padding:0,showDelay:0,transitionDuration:.5,position:function(t){return[t[0],10]}},textStyle:{fontFamily:'Roboto,"Helvetica Neue","Segoe UI","Hiragino Sans GB","Microsoft YaHei",Arial,Helvetica,SimSun,sans-serif',fontSize:12},loadingText:"Data Loading...",noDataText:"No Graphic Data Available",addDataAnimation:!1},visibleDataPointsNum:80}).factory("$echarts",["$filter","dashing.util",function(t,e){function n(n,i,o){function s(t){var n=e.color.lighter(t,-.2);return'<div style="width: 10px; height: 10px; margin-top: 2px; border-radius: 2px; border: 1px solid '+n+"; background-color: "+t+'"></div>'}function l(e){var n={};angular.forEach(e,function(t){n[t.name]=n[t.name]||[],n[t.name].push(t)});var a=[];return angular.forEach(n,function(t){var e=t.reduce(function(t,e){return Math.abs(Number(t.value))>Math.abs(e.value)?t:e});e.value=t.reduce(function(t,e){return{value:t.value+e.value}}).value,a.push(e)}),t("orderBy")(a,"value",!0)}var c=o.valueFormatter||r;return'<div style="padding: 8px">'+[(o.nameFormatter||a)(n),"<table>"+l(i).map(function(t){return"-"===t.value?"":(t.value=c(t.value),t.name||(t.name=t.value,t.value=""),"<tr><td>"+s(t.color)+'</td><td style="padding: 0 12px 0 4px">'+t.name+'</td><td style="text-align: right">'+t.value+"</td></tr>")}).join("")+"</table>"].join("")+"</div>"}function a(e){if(angular.isDate(e)){var n=new Date;return t("date")(e,n.getYear()===e.getYear()&&n.getMonth()===e.getMonth()&&n.getDay()===e.getDay()?"HH:mm:ss":"yyyy-MM-dd HH:mm:ss")}return e}function r(e){return t("number")(e)}function i(t){return{trigger:t.trigger||"axis",axisPointer:{type:"none"},formatter:t.formatter}}function o(t,e){return Array.isArray(t)||(t=[]),!e||t.length<=e?{older:t,newer:[]}:{older:t.slice(0,e),newer:t.slice(e)}}return{categoryTooltip:function(t,a){return i({trigger:"axis",formatter:function(r){r=e.array.ensureArray(r);var i=r[0].name,o=r.map(function(t){return{color:t.series.colors.line,name:t.seriesName,value:t.value}});if(!i.length&&!o.filter(function(t){return"-"!==t.value}).length)return"";var s={nameFormatter:a,valueFormatter:t};return n(i,o,s)}})},timelineChartFix:function(t,e){console.warn("Echarts does not have a good experience for time series. We suggest to use category as x-axis type."),t.tooltip=i({trigger:"item",formatter:function(t){var a=[{color:t.series.colors.line,name:t.series.name,value:t.value[1]}];return n(t.value[0],a,e)}}),angular.forEach(t.xAxis,function(t){delete t.boundaryGap}),angular.forEach(t.series,function(t){t.showAllSymbol=!0,t.stack=!1})},validateSeriesNames:function(t,n){if(!t.seriesNames){var a=e.array.ensureArray(n[0].y);a.length>1&&console.warn({message:"You should define `options.seriesNames`",options:t}),t.seriesNames=a.map(function(t,e){return"Series "+(e+1)})}},axisLabelFormatter:function(t,n){return function(a){if(n&&n.hasOwnProperty(a))return n[a];if(0!=a&&angular.isNumber(a)){var r=e.text.toHumanReadableNumber(a,1e3,1);return r.value+(t?" "+r.modifier+t:r.modifier.toLowerCase())}return a}},makeDataSeries:function(t){var n={type:t.type||"line",symbol:"circle",symbolSize:4,smooth:t.smooth,itemStyle:{normal:{color:t.colors.line,lineStyle:{width:t.stack?4:3},borderColor:"transparent",borderWidth:6},emphasis:{color:t.colors.hover,borderColor:e.color.alpha(t.colors.line,.3)}}};return t.stack?n.itemStyle.normal.areaStyle={type:"default",color:t.colors.area}:t.showAllSymbol&&(n.itemStyle.normal.lineStyle.width-=1),angular.merge(t,n)},fillAxisData:function(t,e,n){if(e=e||[],angular.isObject(n)&&(angular.isString(n.groupId)&&n.groupId.length&&(t.groupId=n.groupId),n.visibleDataPointsNum>0)){t.visibleDataPointsNum=n.visibleDataPointsNum;for(var a={x:"",y:t.series.map(function(){return{value:"-",tooltip:{}}})};e.length<n.visibleDataPointsNum;)e.unshift(a)}var r=o(e,t.visibleDataPointsNum);if(r.newer.length&&(t.dataPointsQueue=r.newer),angular.forEach(t.series,function(t){t.data=[]}),"time"===t.xAxis[0].type)angular.forEach(r.older,function(e){angular.forEach(t.series,function(t,n){t.data.push([e.x,Array.isArray(e.y)?e.y[n]:e.y])})});else{var i=[];angular.forEach(r.older,function(e){i.push(e.x),angular.forEach(t.series,function(t,n){t.data.push(Array.isArray(e.y)?e.y[n]:e.y)})}),t.xAxis[0].data=i}},linkFn:function(t,e){t.$watch("data",function(e){if(e){var n=Array.isArray(e)?e:[e];t.api.addDataPoints(n)}}),t.$watch("options",function(n,a){angular.equals(n,a)||t.api.rebuild(e(n,t))},!0)}}}]),angular.module("dashing.charts.bar",["dashing.charts.adapter.echarts","dashing.charts.look_and_feel","dashing.util"]).directive("barChart",["dashing.charts.look_and_feel","dashing.util","$echarts",function(t,e,n){function a(a,r){var i=angular.merge({yAxisSplitNum:3,yAxisShowMinorAxisLine:!1,yAxisLabelWidth:60,yAxisLabelFormatter:n.axisLabelFormatter(""),"static":!0,rotate:!1,xAxisShowLabels:!0,margin:{left:undefined,right:undefined,top:undefined,bottom:undefined}},a);i=angular.merge({barMaxWidth:i.rotate?20:16,barMaxSpacing:i.rotate?5:4,barMinWidth:i.rotate?6:4,barMinSpacing:i.rotate?2:1},i);var o=i.data;Array.isArray(o)||(console.warn({message:"Initial data is expected to be an array",data:o}),o=o?[o]:[]),n.validateSeriesNames(i,o),Array.isArray(i.colors)&&i.colors.length||(i.colors=t.barChartColorRecommendation(i.seriesNames.length||1));var s=i.colors.map(function(e){return t.buildColorStates(e)}),l=s.length>1?"#999":s[0].line,c=15,u=Math.max(c,i.yAxisLabelWidth),d={height:i.height,width:i.width,tooltip:angular.merge(n.categoryTooltip(i.valueFormatter),{axisPointer:{type:"shadow",shadowStyle:{color:"rgba(225,225,225,0.3)"}}}),grid:angular.merge({borderWidth:0,x:i.margin.left||u,x2:i.margin.right||u,y:i.margin.top||c,y2:i.margin.bottom||c+13},i.grid),xAxis:[{axisLabel:{show:!0},axisLine:{show:!0,lineStyle:{width:1,color:l,type:"dotted"}},axisTick:!1,splitLine:!1}],yAxis:[{type:"value",splitNumber:i.yAxisSplitNum,splitLine:{show:i.yAxisShowMinorAxisLine,lineStyle:{color:l,type:"dotted"}},axisLine:!1,axisLabel:{formatter:i.yAxisLabelFormatter}}],series:i.seriesNames.map(function(t,e){return n.makeDataSeries({type:"bar",name:t,stack:!0,colors:s[e]})}),color:i.colors};if(i["static"]&&delete i.visibleDataPointsNum,n.fillAxisData(d,o,i),i["static"]&&(d.visibleDataPointsNum=-1),i.rotate){var p=d.xAxis;d.xAxis=angular.copy(d.yAxis),d.xAxis[0].type=d.xAxis[0].type||"value",d.yAxis=p,d.yAxis[0].type=d.yAxis[0].type||"category"}if(i.xAxisShowLabels||(d.xAxis[0].axisLabel=!1,d.grid.y2=d.grid.y),i["static"]){var h=i.barMinWidth+i.barMinSpacing,g=i.barMaxWidth+i.barMaxSpacing,b=o.length*h,m=o.length*g,f=parseInt(i.height);if(i.rotate){var y=2*d.grid.borderWidth+d.grid.y+d.grid.y2;y+b>f?(console.info("The chart is too short to hold so many bars, so that we increase the height to "+(y+b)+"px for you."),d.height=y+b+"px"):f>y+m&&(d.height=y+m+"px")}else{var v=2*d.grid.borderWidth+d.grid.x+d.grid.x2,x=r.getChartControlWidthFn(),w=x-v;if(b>0&&b>w){var k=Math.floor(w/h)*h;d.grid.x2+=w-k;var A=20,S=5;d.dataZoom={show:!0,end:100*k/b,realtime:!0,height:A,y:f-A-S,handleColor:l},d.dataZoom.fillerColor=e.color.alpha(d.dataZoom.handleColor,.08),d.grid.y2+=A+2*S}else o.length&&(w>m?d.grid.x2+=x-m-v:angular.isDefined(i.margin.right)||(k=Math.floor(w/o.length)*o.length,d.grid.x2+=w-k))}}return d}return{restrict:"E",template:'<echart options="::initOptions" api="api" on-resize="handleResize()"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){return n.linkFn(t,a)},controller:["$scope","$element",function(t,e){t.getChartControlWidthFn=function(){return angular.element(e[0]).children()[0].offsetWidth},t.initOptions=a(t.options,t),t.handleResize=function(){return t.options._dirty=new Date,!0}}]}}]),angular.module("dashing.charts.line",["dashing.charts.adapter.echarts","dashing.charts.look_and_feel"]).directive("lineChart",["dashing.charts.look_and_feel","$echarts",function(t,e){function n(n){var a=angular.merge({seriesStacked:!0,seriesLineSmooth:!1,showLegend:!0,yAxisSplitNum:3,yAxisShowSplitLine:!0,yAxisLabelWidth:60,yAxisLabelFormatter:e.axisLabelFormatter(""),yAxisScaled:!1,xAxisShowLabels:!0,margin:{left:undefined,right:undefined,top:undefined,bottom:undefined}},n),r=a.data;e.validateSeriesNames(a,r),Array.isArray(a.colors)&&a.colors.length||(a.colors=t.lineChartColorRecommendation(a.seriesNames.length||1));var i=a.colors.map(function(e){return t.buildColorStates(e)}),o="#ccc",s={length:4,lineStyle:{width:1,color:o}},l=Math.max(15,a.yAxisLabelWidth),c={height:a.height,width:a.width,tooltip:angular.merge(e.categoryTooltip(a.valueFormatter),{axisPointer:{type:"line",lineStyle:{width:3,color:"rgb(235,235,235)",type:"dotted"}}}),grid:angular.merge({borderWidth:0,x:a.margin.left||l,x2:a.margin.right||l,y:a.margin.top||20,y2:a.margin.bottom||25},a.grid),xAxis:[{type:a.xAxisTypeIsTime?"time":undefined,boundaryGap:a.xAxisBoundaryGap,axisLine:angular.merge({onZero:!1},s),axisTick:s,axisLabel:{show:!0},splitLine:!1}],yAxis:[{splitNumber:a.yAxisSplitNum,splitLine:{show:a.yAxisShowSplitLine,lineStyle:{color:o,type:"dotted"}},axisLine:!1,axisLabel:{formatter:a.yAxisLabelFormatter},scale:a.yAxisScaled}],series:a.seriesNames.map(function(t,n){return e.makeDataSeries({name:t,colors:i[n],stack:a.seriesStacked,smooth:a.seriesLineSmooth,showAllSymbol:a.showAllSymbol,yAxisIndex:Array.isArray(a.seriesYAxisIndex)?a.seriesYAxisIndex[n]:0})}),color:a.colors};if(_.contains(a.seriesYAxisIndex,1)){var u=angular.copy(c.yAxis[0]);angular.isFunction(a.yAxis2LabelFormatter)&&(u.axisLabel.formatter=a.yAxis2LabelFormatter),c.yAxis.push(u)}e.fillAxisData(c,r,a),a.xAxisShowLabels||(c.xAxis[0].axisLabel=!1,c.grid.y2=c.grid.y),a.xAxisTypeIsTime&&e.timelineChartFix(c,a),1===c.series.length&&(c.yAxis.boundaryGap=[0,.1]);var d=20,p=16;a.title&&(c.title={text:a.title,x:0,y:3},c.grid.y+=d);var h=c.series.length>1&&a.showLegend;return h&&(c.legend={show:!0,itemWidth:8,data:c.series.map(function(t){return t.name})},c.legend.y=6,c.grid.y+=14,a.title&&(c.legend.y+=d,c.grid.y+=p)),(h||a.title)&&(c.grid.y+=12),c}return{restrict:"E",template:'<echart options="::initOptions" api="api"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){return e.linkFn(t,n)},controller:["$scope",function(t){t.initOptions=n(t.options)}]}}]),angular.module("dashing.charts.look_and_feel",["dashing.util"]).factory("dashing.charts.look_and_feel",["dashing.util",function(t){var e={lineChartColorRecommendation:function(e){var n=t.color.palette;switch(e){case 1:return[n.blue];case 2:return[n.blue,n.blueishGreen];default:return t.array.repeatArray([n.blue,n.purple,n.blueishGreen,n.darkRed,n.orange],e)}},barChartColorRecommendation:function(e){var n=t.color.palette;switch(e){case 1:return[n.lightBlue];case 2:return[n.blue,n.darkBlue];default:return t.array.repeatArray([n.lightGreen,n.darkGray,n.lightBlue,n.blue,n.darkBlue],e)}},ringChartColorRecommendation:function(t){return e.barChartColorRecommendation(t)},buildColorStates:function(e){return{line:e,area:t.color.lighter(e,-.92),hover:t.color.lighter(e,.15)}}};return e}]),angular.module("dashing.charts.metrics_sparkline",["dashing.charts.sparkline","dashing.metrics"]).directive("metricsSparklineChartTd",function(){
return{restrict:"E",templateUrl:"charts/metrics_sparkline_td.html",scope:{caption:"@",help:"@",current:"@",unit:"@",subText:"@",options:"=optionsBind",data:"=datasourceBind"}}}),angular.module("dashing.charts.ring",["dashing.charts.adapter.echarts","dashing.charts.look_and_feel"]).directive("ringChart",function(){return{restrict:"E",template:'<echart options="::initOptions" api="api"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){t.$watch("data",function(e){t.api.updateOption({series:[{data:[{value:e.available.value},{value:e.used.value}]}]})})},controller:["$scope","$element","dashing.charts.look_and_feel",function(t,e,n){var a=angular.merge({color:n.ringChartColorRecommendation(1)[0],thickness:.25},t.options);(!angular.isNumber(a.thickness)||a.thickness>1||a.thickness<=0)&&(console.warn({message:"Ignored invalid thickness value",value:a.thickness}),a.thickness=.25);var r=a.data||t.data;r||console.warn("Need data to render the ring chart.");var i=n.buildColorStates(a.color),o=8,s=(parseInt(a.height)-30-2*o)/2,l=Math.floor(s*(1-a.thickness)),c=Math.floor(28*l/39);12>c&&console.warn("Please increase the height to get a better visual experience.");var u={normal:{color:"rgb(232,239,240)",label:{show:!0,position:"center"},labelLine:!1}},d={height:a.height,width:a.width,grid:{borderWidth:0},xAxis:[{show:!1,data:[0]}],legend:{selectedMode:!1,itemGap:20,itemWidth:13,y:"bottom",data:[r.used.label,r.available.label].map(function(t){return{name:t,textStyle:{fontWeight:500},icon:"a"}})},series:[{type:"pie",center:["50%",s+o],radius:[l,s],data:[{name:r.available.label,value:r.available.value,itemStyle:u},{name:r.used.label,value:r.used.value,itemStyle:angular.merge({},u,{normal:{color:i.line}})}]}]};if(d.series[0].itemStyle={normal:{label:{formatter:function(){return Math.round(100*t.data.used.value/(t.data.used.value+t.data.available.value))+"%"},textStyle:{color:"#111",fontSize:Math.floor(28*l/39),fontWeight:500,baseline:"middle"}}}},a.title){d.series[0].center[0]=s+o,d.legend.x=o,d.title={text:a.title,x:2*(s+o)+o+4,y:s+o+4,textStyle:{fontSize:12,fontWeight:500,color:"#666"}};var p=d.title.x+14,h=d.title.y-48,g=t.data.used.value+t.data.available.value,b=t.data.used.unit,m="-webkit-touch-callout: none;-webkit-user-select: none;-khtml-user-select: none;-moz-user-select: none;-ms-user-select: none;user-select: none;";angular.element(e[0]).append(['<div style="position: absolute; left: '+p+"px; top: "+h+'px">','<p style="cursor: default; '+m+'">','<span style="font-size: 40px; font-weight: 500">'+g+"</span>",b?'<span style="font-size: 15px; font-weight: 700">'+b+"</span>":"","</p>","</div>"].join(" "))}t.initOptions=d}]}}),angular.module("dashing.charts.sparkline",["dashing.charts.adapter.echarts","dashing.charts.look_and_feel"]).directive("sparklineChart",["dashing.charts.look_and_feel","$echarts",function(t,e){function n(n){var a=angular.merge({color:t.lineChartColorRecommendation(1)[0],yAxisBoundaryGap:[0,.5]},n);a.xAxisTypeIsTime&&(console.warn("Echarts does not have a good experience for time series, so we fallback to category. Please track https://github.com/ecomfe/echarts/issues/1954"),a.xAxisTypeIsTime=!1);var r=t.buildColorStates(a.color),i=5,o={height:a.height,width:a.width,tooltip:e.categoryTooltip(a.valueFormatter),grid:angular.merge({borderWidth:1,x:i,y:i,x2:i,y2:1},a.grid),xAxis:[{type:a.xAxisTypeIsTime?"time":undefined,boundaryGap:!1,axisLine:!1,axisLabel:!1,splitLine:!1}],yAxis:[{boundaryGap:a.yAxisBoundaryGap,show:!1}],series:[e.makeDataSeries({colors:r,stack:!0})]};"bar"===a.series0Type&&(o.grid.borderWidth=0,o.grid.y2=0,o.xAxis[0].boundaryGap=!0,o.series[0].type="bar");var s=a.data;return e.fillAxisData(o,s,a),o}return{restrict:"E",template:'<echart options="::initOptions" api="api"></echart>',scope:{options:"=optionsBind",data:"=datasourceBind"},link:function(t){return e.linkFn(t,n)},controller:["$scope",function(t){t.initOptions=n(t.options)}]}}]),angular.module("dashing.contextmenu",["mgcrea.ngStrap.dropdown"]).factory("$contextmenu",function(){return{popup:function(t,e){var n=angular.element(t);n.css({left:e.x+"px",top:e.y+"px"}),n.triggerHandler("click")}}}),angular.module("dashing.filters.any",[]).filter("any",function(){return function(t,e){return Array.isArray(t)?t.filter(function(t){for(var n=Object.keys(e),a=0;a<n.length;a++){var r=n[a],i=angular.lowercase(e[r]||""),o=angular.lowercase(t[r]||"");if(-1!==o.indexOf(i))return!0}return!1}):t}}),angular.module("dashing.filters.duration",["dashing.util"]).filter("duration",["dashing.util",function(t){return function(e,n){return t.text.toHumanReadableDuration(e,n)}}]),angular.module("dashing.forms.form_control",["ngSanitize","dashing.filters.any","dashing.util.validation","mgcrea.ngStrap","ui.select"]).directive("formControl",["dashing.util.validation",function(validation){function buildChoicesForSelect(t){var e=[];return angular.forEach(t,function(t,n){angular.isString(t)&&(t={text:t}),e.push({value:n,text:t.text,subtext:t.subtext})}),e}function buildChoicesForRadioGroup(t){var e=[];return angular.forEach(t,function(t,n){e.push({value:n,text:t})}),e}function buildChoicesForDropDownMenu(t,e){return t.map(function(t){return angular.isString(t)&&(t={text:t}),{text:(t.icon?'<i class="'+t.icon+'"></i> ':"")+t.text,click:function(){e(t.text)}}})}return{restrict:"E",templateUrl:"forms/form_controls.html",replace:!0,scope:{help:"@",value:"=ngModel",invalid:"="},link:function(scope,elem,attrs){switch(scope.labelStyleClass=attrs.labelStyleClass||"col-sm-3",scope.controlStyleClass=attrs.controlStyleClass||"col-sm-9",scope.choiceIconStyleClass=attrs.choiceIconStyleClass||"glyphicon glyphicon-menu-hamburger",scope.label=attrs.label,scope.renderAs=attrs.type,scope.pristine=!0,scope.invalid=attrs.required,attrs.type){case"class":scope.renderAs="text",scope.validateFn=validation["class"];break;case"choices":scope.placeholder=attrs.searchPlaceholder,scope.choices=buildChoicesForSelect(eval("("+attrs.choices+")")),scope.allowSearchInChoices=attrs.hasOwnProperty("searchEnabled")?"true"===attrs.searchEnabled:Object.keys(scope.choices).length>=5,scope.allowClearSelection=!attrs.required;break;case"radio":scope.choices=buildChoicesForRadioGroup(eval("("+attrs.choices+")")),scope.buttonStyleClass=attrs.btnStyleClass||"btn-sm",scope.toggle=function(t){scope.value=t};break;case"multi-checks":scope.choices=eval("("+attrs.choices+")"),Array.isArray(scope.choices)||(scope.choices=[attrs.choices]),Array.isArray(scope.value)||(scope.value=scope.choices.map(function(){return!1}));break;case"check":scope.text=scope.label,scope.label="";break;case"integer":scope.min=attrs.min,scope.max=attrs.max,scope.validateFn=function(t){return validation.integerInRange(t,attrs.min,attrs.max)};break;case"datetime":scope.dateControlStyleClass=attrs.dateControlStyleClass||"col-md-5",scope.timeControlStyleClass=attrs.timeControlStyleClass||"col-md-4",scope.fillDefaultDate=function(){scope.dateValue||(scope.dateValue=new Date)},scope.fillDefaultTime=function(){if(!scope.timeValue){var t=new Date;t.setSeconds(0),t.setMilliseconds(0),scope.timeValue=t}},scope.dateInputInvalid=!1,scope.timeInputInvalid=!1,scope.$watch("dateValue",function(t,e){scope.dateInputInvalid=angular.isUndefined(t)&&!angular.isUndefined(e),scope.invalid=scope.dateInputInvalid||scope.timeInputInvalid,t&&(scope.value=[t,scope.timeValue])}),scope.$watch("timeValue",function(t,e){scope.timeInputInvalid=angular.isUndefined(t)&&!angular.isUndefined(e),scope.invalid=scope.dateInputInvalid||scope.timeInputInvalid,t&&(scope.value=[scope.dateValue,t])}),scope.$watchCollection("value",function(t){Array.isArray(t)&&2===t.length&&(scope.dateValue=t[0],scope.timeValue=t[1])});break;case"upload":scope.acceptPattern=attrs.acceptPattern,scope.filename="",scope.$watch("files",function(t){Array.isArray(t)&&t.length?(scope.value=t[0],scope.filename=t[0].name):(scope.value=null,scope.filename="")}),scope.openUpload=function(){if(!scope.files){var t=elem.find("span");if(t.length>2){var e=t[t.length-2];e.click()}}},scope.clearSelection=function(){scope.files=null};break;default:scope.hideMenuCaret=-1!==["true","1"].indexOf(String(attrs.hideMenuCaret))}"text"===scope.renderAs&&attrs.choices&&(scope.choicesMenu=buildChoicesForDropDownMenu(eval("("+attrs.choices+")"),function(t){scope.value=t})),scope.$watch("value",function(t){scope.pristine="integer"!==attrs.type&&0===(t||"").length,scope.invalid=angular.isFunction(scope.validateFn)&&!scope.validateFn(t)||attrs.required&&scope.pristine})}}}]),angular.module("dashing.forms.searchbox",[]).directive("searchbox",function(){return{restrict:"E",templateUrl:"forms/searchbox.html",scope:{placeholder:"@",ngModel:"="}}}),angular.module("dashing").constant("dashing.i18n",{emptySearchResult:"No results matched your search :-(",paginationSummary:"Showing {{ stRange.from }}-{{ stRange.to }} of {{ totalItemCount }} records"}),angular.module("dashing.metrics",[]).directive("metrics",function(){return{restrict:"E",templateUrl:"metrics/metrics.html",scope:{caption:"@",value:"@",unit:"@",unitPlural:"@",subText:"@",help:"@",remarkType:"@",clickHelp:"&"}}}),angular.module("dashing.progressbar",[]).directive("progressbar",function(){return{restrict:"E",templateUrl:"progressbar/progressbar.html",scope:{current:"@",max:"@",colorMapperFn:"="},link:function(t,e,n){function a(e,n){t.usage=n>0?Math.round(100*e/n):-1,t.usageClass=(t.colorMapperFn?t.colorMapperFn:r)(t.usage)}function r(t){return"progress-bar-"+(50>t?"info":75>t?"warning":"danger")}n.$observe("current",function(t){a(Number(t),Number(n.max))}),n.$observe("max",function(t){a(Number(n.current),Number(t))})}}}),angular.module("dashing.property.number",["dashing.util"]).directive("number",["$filter","dashing.util",function(t,e){return{restrict:"E",templateUrl:"property/number.html",scope:{raw:"@"},link:function(n,a,r){var i=-1!==["true","1"].indexOf(String(r.readable));r.$observe("raw",function(a){if(i){var o=e.text.toHumanReadableNumber(Number(a),1024);n.value=o.value.toFixed(0),n.unit=o.modifier+r.unit}else n.value=t("number")(a,Number(r.precision)||0),n.unit=r.unit})}}}]),angular.module("dashing.property",["mgcrea.ngStrap.tooltip"]).directive("property",function(){return{restrict:"E",templateUrl:"property/property.html",replace:!1,scope:{value:"=valueBind",renderer:"@"},controller:["$scope","dsPropertyRenderer",function(t,e){t.renderer===e.BYTES&&(console.warn("deprecated: should use renderer NUMBER instead"),t.renderer=e.NUMBER),t.$watch("value",function(n){if(angular.isObject(n)){switch(t.renderer){case e.LINK:n.href||(t.href=n.text);break;case e.BUTTON:n.href&&!n.click&&(t.click=function(){if(n.target){var t=window.open(n.href,n.target);t.focus()}else location.href=n.href})}n.hasOwnProperty("value")&&(console.warn({message:"Ignore `value.value`, because it is a reversed field.",object:n}),delete n.value),angular.merge(t,n)}else angular.isNumber(n)&&t.renderer===e.NUMBER&&(t.raw=n)})}]}}).constant("dsPropertyRenderer",{BUTTON:"Button",BYTES:"Bytes",DATETIME:"DateTime",DURATION:"Duration",INDICATOR:"Indicator",LINK:"Link",NUMBER:"Number",NUMBER1:"Number1",NUMBER2:"Number2",PROGRESS_BAR:"ProgressBar",TAG:"Tag",TEXT:undefined}),angular.module("dashing.remark",["mgcrea.ngStrap.tooltip"]).directive("remark",function(){return{restrict:"E",templateUrl:"remark/remark.html",scope:{tooltip:"@",placement:"@",type:"@",trigger:"@"},link:function(t){t.$watch("type",function(e){switch(e){case"info":t.styleClass="glyphicon glyphicon-info-sign remark-icon";break;case"warning":t.styleClass="glyphicon glyphicon-warning-sign remark-icon-warning";break;default:t.styleClass="glyphicon glyphicon-question-sign remark-icon"}})}}}),angular.module("dashing.state.indicator",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("indicator",["dashing.util",function(t){return{restrict:"E",templateUrl:"state/indicator.html",scope:{tooltip:"@",shape:"@"},link:function(e,n,a){a.condition||(a.condition=""),a.$observe("condition",function(n){e.colorStyle=t.color.conditionToColor(n)}),a.$observe("tooltip",function(t){e.cursorStyle=t?"pointer":"default"})}}}]),angular.module("dashing.state.tag",["dashing.util","mgcrea.ngStrap.tooltip"]).directive("tag",["dashing.util",function(t){return{restrict:"E",templateUrl:"state/tag.html",scope:{href:"@",text:"@",tooltip:"@"},link:function(e,n,a){a.condition||(a.condition=""),a.$observe("condition",function(n){e.labelColorClass=t.bootstrap.conditionToBootstrapLabelClass(n)}),a.$observe("tooltip",function(t){e.href||(e.cursorStyle=t?"pointer":"default")})}}}]),angular.module("dashing.tables.property_table",[]).directive("propertyTable",function(){return{restrict:"E",templateUrl:"tables/property_table/property_table.html",scope:{caption:"@",captionTooltip:"@",subCaption:"@",props:"=propsBind",propNameClass:"@",propValueClass:"@"}}}),angular.module("dashing.tables.property_table.builder",[]).factory("$propertyTableBuilder",["dsPropertyRenderer",function(t){var e=function(t,e){this.props=t?{renderer:t}:{},e&&this.title(e)};return e.prototype.title=function(t){return this.props.name=t,this},e.prototype.help=function(t){return this.props.help=t,this},e.prototype.value=function(t){return this.props.value=t,this},e.prototype.values=function(t){return Array.isArray(t)||(console.warn("values must be an array"),t=[t]),this.props.values=t,this},e.prototype.done=function(){return this.props},{button:function(n){return new e(t.BUTTON,n)},bytes:function(n){return console.warn("deprecated: should use number() instead"),new e(t.BYTES,n)},datetime:function(n){return new e(t.DATETIME,n)},duration:function(n){return new e(t.DURATION,n)},indicator:function(n){return new e(t.INDICATOR,n)},link:function(n){return new e(t.LINK,n)},number:function(n){return new e(t.NUMBER,n)},number1:function(n){return new e(t.NUMBER1,n)},number2:function(n){return new e(t.NUMBER2,n)},progressbar:function(n){return new e(t.PROGRESS_BAR,n)},tag:function(n){return new e(t.TAG,n)},text:function(n){return new e(t.TEXT,n)},$update:function(t,e){return angular.forEach(e,function(e,n){var a=Array.isArray(e)?"values":"value";t[n][a]=e}),t}}}]),angular.module("dashing.tables.sortable_table",["smart-table","dashing.property","dashing.util"]).directive("sortableTable",["dsPropertyRenderer","dashing.util","dashing.i18n",function(t,e,n){return{restrict:"E",templateUrl:"tables/sortable_table/sortable_table.html",transclude:!0,scope:{caption:"@",captionTooltip:"@",subCaption:"@",pagination:"@",columns:"=columnsBind",records:"=recordsBind",search:"=searchBind",emptySearchResult:"@"},link:function(a,r){var i=r.find("input")[0];a.$watch("search",function(t){i.value=t||"",angular.element(i).triggerHandler("input")}),a.emptySearchResult=a.emptySearchResult||n.emptySearchResult,a.$watch("columns",function(n){if(!Array.isArray(n))return void console.warn("Failed to create table, until columns are defined.");a.columnStyleClass=n.map(function(t){function e(t,e,n){n&&t.push(e)}var n=[];return e(n,t.styleClassArray.join(" "),t.styleClassArray.length),e(n,"text-nowrap",Array.isArray(t.key)&&!t.vertical),n.join(" ")});var r=n.map(function(e){return Array.isArray(e.key)||e.renderer!==t.INDICATOR?void 0:e.key});a.bgColorForStripeFix=function(t,n){var a=r[t];if(a){var i=n[a];if("stripe"===i.shape)return e.color.conditionToColor(i.condition)}},a.multipleRendererColumnsRenderers=n.map(function(t){return Array.isArray(t.key)?Array.isArray(t.renderer)?(t.renderer.length!==t.key.length&&console.warn("Every column key should have a renderer, or share one renderer."),t.renderer):t.key.map(function(){return t.renderer}):null})}),a.isArray=Array.isArray}}}]).directive("stSummary",["dashing.i18n",function(t){return{require:"^stTable",template:t.paginationSummary,link:function(t,e,n,a){function r(){var e=a.tableState().pagination;0===e.totalItemCount?(t.stRange.from=0,t.stRange.to=0):(t.stRange.from=e.start+1,t.stRange.to=t.currentPage===e.numberOfPages?e.totalItemCount:t.stRange.from+t.stItemsByPage-1)}t.stRange={from:null,to:null},t.$watch("currentPage",r),t.$watch("totalItemCount",r)}}}]).config(["stConfig",function(t){t.sort.skipNatural=!0,t.sort.delay=-1}]),angular.module("dashing.tables.sortable_table.builder",["dashing.property","dashing.util"]).factory("$sortableTableBuilder",["dashing.util","dsPropertyRenderer",function(t,e){function n(t,e,n){var a=!0;return angular.forEach(e,function(r,i){var o=t[i];return o.hasOwnProperty(n)&&o.key===e.key?void 0:(a=!1,!1)}),a}var a=function(t,e){this.props=t?{renderer:t}:{},this.props.styleClassArray=[],e&&this.title(e)};return a.prototype.title=function(t){return this.props.name=t,this},a.prototype.key=function(t){return this.props.key=t,this},a.prototype.canSort=function(t){if(!t){if(!this.props.key)return void console.warn('The column does not have a key. Call `.key("some")` first!');Array.isArray(this.props.key)&&(console.warn("Multiple keys found. We use the first key for sorting by default."),t=this.props.key[0])}if(this.props.sortKey=t||this.props.key,this.props.sortKey===this.props.key)switch(this.props.renderer){case e.LINK:this.props.sortKey+=".text";break;case e.INDICATOR:case e.TAG:this.props.sortKey+=".condition";break;case e.PROGRESS_BAR:this.props.sortKey+=".usage";break;case e.BYTES:this.props.sortKey+=".raw";break;case e.BUTTON:return void console.warn('"%s" column is not sortable.')}return this},a.prototype.sortDefault=function(t){return this.props.sortKey?(this.props.defaultSort=t?"reverse":!0,this):void console.warn("Specify a sort key or define column key first!")},a.prototype.sortDefaultDescent=function(){return this.sortDefault(!0)},a.prototype.styleClass=function(t){var e=t.split(" ");return angular.forEach(e,function(t){-1===this.props.styleClassArray.indexOf(t)&&this.props.styleClassArray.push(t)},this),this},a.prototype.textRight=function(){return this.styleClass("text-right"),this},a.prototype.textLeft=function(){var t=this.props.styleClassArray.indexOf("text-right");return-1!==t&&this.props.styleClassArray.splice(t,1),this},a.prototype.sortBy=function(t){return this.props.sortKey=t,this},a.prototype.unit=function(t){return this.props.unit=t,this},a.prototype.help=function(t){return this.props.help=t,this},a.prototype.vertical=function(){return Array.isArray(this.props.key)&&(this.props.vertical=!0),this},a.prototype.done=function(){return this.props},{button:function(t){return new a(e.BUTTON,t)},bytes:function(t){return console.warn("deprecated: should use number instead"),new a(e.BYTES,t).textRight()},datetime:function(t){return new a(e.DATETIME,t)},duration:function(t){return new a(e.DURATION,t)},indicator:function(t){return new a(e.INDICATOR,t)},link:function(t){return new a(e.LINK,t)},multiple:function(t,e){return new a(e,t)},number:function(t){return new a(e.NUMBER,t).textRight()},number1:function(t){return new a(e.NUMBER1,t).textRight()},number2:function(t){return new a(e.NUMBER2,t).textRight()},progressbar:function(t){return new a(e.PROGRESS_BAR,t)},tag:function(t){return new a(e.TAG,t)},text:function(t){return new a(e.TEXT,t)},$update:function(t,e,a){return(t||[]).length!==(e||[]).length?e:angular.isString(a)&&!n(t,e,a)?e:(angular.forEach(e,function(e,n){t[n]=e}),t)},$check:function(e,n){angular.forEach(e,function(e){var a=t.array.ensureArray(e.key);angular.forEach(a,function(t){n.hasOwnProperty(t)||console.warn("Model does not have a property matches column key `"+e+"`.")})})}}}]),angular.module("dashing.tabset",[]).directive("tabset",[function(){return{restrict:"E",templateUrl:"tabset/tabset.html",transclude:!0,scope:!0,controller:["$scope",function(t){function e(t,e){angular.forEach(n,function(e){e.selected=e===t}),t.load!==undefined&&t.load(e)}var n=t.tabs=[];this.addTab=function(t){n.push(t),1===n.length&&e(t)},t.selectTab=function(t,a){t>=0&&t<n.length&&e(n[t],a)}}]}}]).directive("tab",["$http","$controller","$compile",function(t,e,n){return{restrict:"E",require:"^tabset",template:'<div class="tab-pane" ng-class="{active:selected}" ng-transclude></div>',replace:!0,transclude:!0,link:function(a,r,i,o){function s(t){r.html(t);var o=a.$new(!1);if(i.controller){var s=e(i.controller,{$scope:o});r.children().data("$ngController",s)}n(r.contents())(o),a.loaded=!0}a.heading=i.heading,a.loaded=!1,a.load=function(e){(!a.loaded||e)&&i.template&&t.get(i.template).then(function(t){s(t.data)})},o.addTab(a)}}}]),angular.module("dashing.util.array",[]).factory("dashing.util.array",function(){return{alignArray:function(t,e,n){if(e<=t.length)return t.slice(0,e);for(var a=angular.copy(t),r=a.length;e>r;r++)a.push(n);return a},repeatArray:function(t,e){if(e<=t.length)return t.slice(0,e);for(var n=[],a=0;e>a;a++)n.push(t[a%t.length]);return n},ensureArray:function(t){return Array.isArray(t)?t:[t]}}}),angular.module("dashing.util.color",[]).factory("dashing.util.color",function(){return{palette:{blue:"rgb(0,119,215)",blueishGreen:"rgb(41,189,181)",orange:"rgb(255,127,80)",purple:"rgb(110,119,215)",skyBlue:"rgb(91,204,246)",darkBlue:"rgb(102,168,212)",darkGray:"rgb(92,92,97)",darkPink:"rgb(212,102,138)",darkRed:"rgb(212,102,138)",lightBlue:"rgb(35,183,229)",lightGreen:"rgb(169,255,150)"},conditionToColor:function(t){switch(t){case"good":return"#5cb85c";case"concern":return"#f0ad4e";case"danger":return"#d9534f";default:return"#aaa"}},lighter:function(t,e){return zrender.tool.color.lift(t,e)},alpha:function(t,e){return zrender.tool.color.alpha(t,e)}}}),angular.module("dashing.util.text",[]).factory("dashing.util.text",function(){return{toHumanReadableNumber:function(t,e,n){var a="";if(0!==t){1024!==e&&(e=1e3);var r=t>0,i=Math.abs(t),o=["","K","M","G","T","P","E","Z","Y"],s=Math.floor(Math.log(i)/Math.log(e));t=i/Math.pow(e,s),n>0&&t!==Math.floor(t)&&(t=t.toFixed(n)),r||(t*=-1),a=o[s]}return{value:t,modifier:a}},toHumanReadableDuration:function(t,e){var n=parseInt(t,10);if(isNaN(n))return t;for(var a=[{label:" ms",mod:1e3},{label:e?"s":" secs",mod:60},{label:e?"m":" mins",mod:60},{label:e?"h":" hours",mod:24},{label:e?"d":" days",mod:7},{label:e?"w":" weeks",mod:52}],r=[],i=0;i<a.length;i++){var o=a[i],s=n%o.mod;0!==s&&r.unshift({label:o.label,value:s}),n=(n-s)/o.mod}return r=r.slice(0,2),r.length>1&&" ms"===r[1].label&&(r=[r[0]]),r.map(function(t){return t.value+t.label}).join(e?" ":" and ")}}}),angular.module("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text","dashing.util.validation"]).factory("dashing.util",["dashing.util.array","dashing.util.bootstrap","dashing.util.color","dashing.util.text","dashing.util.validation",function(t,e,n,a,r){return{array:t,bootstrap:e,color:n,text:a,validation:r}}]),angular.module("dashing.util.validation",[]).factory("dashing.util.validation",function(){var t={"class":function(t){return/^[a-zA-Z_][a-zA-Z_\d]*(\.[a-zA-Z_][a-zA-Z_\d]*)*$/i.test(t)},integer:function(t){return/^-?\d+$/.test(t)},integerInRange:function(e,n,a){return t.integer(e)?(e=Number(e),(isNaN(n)||e>=n)&&(isNaN(a)||a>=e)):!1}};return t})}(window,document);
//# sourceMappingURL=dashing.min.js.map
