/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */'use strict';Object.defineProperty(exports,'__esModule',{value:true});function _interopRequireDefault(obj){return obj && obj.__esModule?obj:{'default':obj};}var _streamingConstantsConstants=require('../streaming/constants/Constants');var _streamingConstantsConstants2=_interopRequireDefault(_streamingConstantsConstants);var _constantsDashConstants=require('./constants/DashConstants');var _constantsDashConstants2=_interopRequireDefault(_constantsDashConstants);var _streamingVoFragmentRequest=require('../streaming/vo/FragmentRequest');var _streamingVoFragmentRequest2=_interopRequireDefault(_streamingVoFragmentRequest);var _streamingVoDashJSError=require('../streaming/vo/DashJSError');var _streamingVoDashJSError2=_interopRequireDefault(_streamingVoDashJSError);var _streamingVoMetricsHTTPRequest=require('../streaming/vo/metrics/HTTPRequest');var _coreEventsEvents=require('../core/events/Events');var _coreEventsEvents2=_interopRequireDefault(_coreEventsEvents);var _coreEventBus=require('../core/EventBus');var _coreEventBus2=_interopRequireDefault(_coreEventBus);var _coreErrorsErrors=require('../core/errors/Errors');var _coreErrorsErrors2=_interopRequireDefault(_coreErrorsErrors);var _coreFactoryMaker=require('../core/FactoryMaker');var _coreFactoryMaker2=_interopRequireDefault(_coreFactoryMaker);var _coreDebug=require('../core/Debug');var _coreDebug2=_interopRequireDefault(_coreDebug);var _streamingUtilsURLUtils=require('../streaming/utils/URLUtils');var _streamingUtilsURLUtils2=_interopRequireDefault(_streamingUtilsURLUtils);var _voRepresentation=require('./vo/Representation');var _voRepresentation2=_interopRequireDefault(_voRepresentation);var _utilsSegmentsUtils=require('./utils/SegmentsUtils');var _utilsSegmentsGetter=require('./utils/SegmentsGetter');var _utilsSegmentsGetter2=_interopRequireDefault(_utilsSegmentsGetter);var _SegmentBaseLoader=require('./SegmentBaseLoader');var _SegmentBaseLoader2=_interopRequireDefault(_SegmentBaseLoader);var _WebmSegmentBaseLoader=require('./WebmSegmentBaseLoader');var _WebmSegmentBaseLoader2=_interopRequireDefault(_WebmSegmentBaseLoader);function DashHandler(config){config = config || {};var context=this.context;var eventBus=(0,_coreEventBus2['default'])(context).getInstance();var urlUtils=(0,_streamingUtilsURLUtils2['default'])(context).getInstance();var segmentBaseLoader=undefined;var timelineConverter=config.timelineConverter;var dashMetrics=config.dashMetrics;var metricsModel=config.metricsModel;var mediaPlayerModel=config.mediaPlayerModel;var errHandler=config.errHandler;var baseURLController=config.baseURLController;var instance=undefined,logger=undefined,index=undefined,requestedTime=undefined,currentTime=undefined,streamProcessor=undefined,segmentsGetter=undefined;function setup(){logger = (0,_coreDebug2['default'])(context).getInstance().getLogger(instance);resetInitialSettings();segmentBaseLoader = isWebM(config.mimeType)?(0,_WebmSegmentBaseLoader2['default'])(context).getInstance():(0,_SegmentBaseLoader2['default'])(context).getInstance();segmentBaseLoader.setConfig({baseURLController:baseURLController,metricsModel:metricsModel,mediaPlayerModel:mediaPlayerModel,errHandler:errHandler});eventBus.on(_coreEventsEvents2['default'].INITIALIZATION_LOADED,onInitializationLoaded,instance);eventBus.on(_coreEventsEvents2['default'].SEGMENTS_LOADED,onSegmentsLoaded,instance);}function isWebM(mimeType){var type=mimeType.split('/')[1];return 'webm' === type.toLowerCase();}function initialize(StreamProcessor){streamProcessor = StreamProcessor;segmentBaseLoader.initialize();segmentsGetter = (0,_utilsSegmentsGetter2['default'])(context).create(config,isDynamic());}function getType(){return streamProcessor?streamProcessor.getType():null;}function isDynamic(){var streamInfo=streamProcessor?streamProcessor.getStreamInfo():null;return streamInfo?streamInfo.manifestInfo.isDynamic:null;}function getMediaInfo(){return streamProcessor?streamProcessor.getMediaInfo():null;}function getStreamProcessor(){return streamProcessor;}function setCurrentTime(value){currentTime = value;}function getCurrentTime(){return currentTime;}function resetIndex(){index = -1;}function resetInitialSettings(){resetIndex();currentTime = 0;requestedTime = null;streamProcessor = null;segmentsGetter = null;}function reset(){resetInitialSettings();eventBus.off(_coreEventsEvents2['default'].INITIALIZATION_LOADED,onInitializationLoaded,instance);eventBus.off(_coreEventsEvents2['default'].SEGMENTS_LOADED,onSegmentsLoaded,instance);}function setRequestUrl(request,destination,representation){var baseURL=baseURLController.resolve(representation.path);var url=undefined,serviceLocation=undefined;if(!baseURL || destination === baseURL.url || !urlUtils.isRelative(destination)){url = destination;}else {url = baseURL.url;serviceLocation = baseURL.serviceLocation;if(destination){url = urlUtils.resolve(destination,url);}}if(urlUtils.isRelative(url)){return false;}request.url = url;request.serviceLocation = serviceLocation;return true;}function generateInitRequest(representation,mediaType){var request=new _streamingVoFragmentRequest2['default']();var period=representation.adaptation.period;var presentationStartTime=period.start;var isDynamicStream=isDynamic();request.mediaType = mediaType;request.type = _streamingVoMetricsHTTPRequest.HTTPRequest.INIT_SEGMENT_TYPE;request.range = representation.range;request.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationStartTime,period.mpd,isDynamicStream);request.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationStartTime + period.duration,period.mpd,isDynamicStream);request.quality = representation.index;request.mediaInfo = getMediaInfo();request.representationId = representation.id;if(setRequestUrl(request,representation.initialization,representation)){return request;}}function getInitRequest(representation){if(!representation)return null;var request=generateInitRequest(representation,getType());return request;}function isMediaFinished(representation){var isFinished=false;var isDynamicStream=isDynamic();if(!isDynamicStream && index === representation.availableSegmentsNumber){isFinished = true;}else {var seg=(0,_utilsSegmentsUtils.getSegmentByIndex)(index,representation);if(seg){var time=parseFloat((seg.presentationStartTime - representation.adaptation.period.start).toFixed(5));var duration=representation.adaptation.period.duration;logger.debug(representation.segmentInfoType + ': ' + time + ' / ' + duration);isFinished = representation.segmentInfoType === _constantsDashConstants2['default'].SEGMENT_TIMELINE && isDynamicStream?false:time >= duration;}else {logger.debug('isMediaFinished - no segment found');}}return isFinished;}function updateSegments(voRepresentation){segmentsGetter.getSegments(voRepresentation,requestedTime,index,onSegmentListUpdated);}function onSegmentListUpdated(voRepresentation,segments){voRepresentation.segments = segments;if(segments && segments.length > 0){if(isDynamic()){var lastSegment=segments[segments.length - 1];var liveEdge=lastSegment.presentationStartTime;var metrics=metricsModel.getMetricsFor(_streamingConstantsConstants2['default'].STREAM); // the last segment is the Expected, not calculated, live edge.
timelineConverter.setExpectedLiveEdge(liveEdge);metricsModel.updateManifestUpdateInfo(dashMetrics.getCurrentManifestUpdate(metrics),{presentationStartTime:liveEdge});}}}function updateSegmentList(voRepresentation){if(!voRepresentation){throw new Error('no representation');}voRepresentation.segments = null;updateSegments(voRepresentation);}function updateRepresentation(voRepresentation,keepIdx){var hasInitialization=_voRepresentation2['default'].hasInitialization(voRepresentation);var hasSegments=_voRepresentation2['default'].hasSegments(voRepresentation);var error=undefined;if(!voRepresentation.segmentDuration && !voRepresentation.segments){updateSegmentList(voRepresentation);}voRepresentation.segmentAvailabilityRange = timelineConverter.calcSegmentAvailabilityRange(voRepresentation,isDynamic());if(voRepresentation.segmentAvailabilityRange.end < voRepresentation.segmentAvailabilityRange.start && !voRepresentation.useCalculatedLiveEdgeTime){error = new _streamingVoDashJSError2['default'](_coreErrorsErrors2['default'].SEGMENTS_UNAVAILABLE_ERROR_CODE,_coreErrorsErrors2['default'].SEGMENTS_UNAVAILABLE_ERROR_MESSAGE,{availabilityDelay:voRepresentation.segmentAvailabilityRange.start - voRepresentation.segmentAvailabilityRange.end});eventBus.trigger(_coreEventsEvents2['default'].REPRESENTATION_UPDATED,{sender:this,representation:voRepresentation,error:error});return;}if(!keepIdx){resetIndex();}if(voRepresentation.segmentDuration){updateSegmentList(voRepresentation);}if(!hasInitialization){segmentBaseLoader.loadInitialization(voRepresentation);}if(!hasSegments){segmentBaseLoader.loadSegments(voRepresentation,getType(),voRepresentation.indexRange);}if(hasInitialization && hasSegments){eventBus.trigger(_coreEventsEvents2['default'].REPRESENTATION_UPDATED,{sender:this,representation:voRepresentation});}}function getIndexForSegments(time,representation,timeThreshold){var segments=representation.segments;var ln=segments?segments.length:null;var idx=-1;var epsilon=undefined,frag=undefined,ft=undefined,fd=undefined,i=undefined;if(segments && ln > 0){ // In case timeThreshold is not provided, let's use the default value set in MediaPlayerModel
timeThreshold = timeThreshold === undefined || timeThreshold === null?mediaPlayerModel.getSegmentOverlapToleranceTime():timeThreshold;for(i = 0;i < ln;i++) {frag = segments[i];ft = frag.presentationStartTime;fd = frag.duration; // In case timeThreshold is null, set epsilon to half the fragment duration
epsilon = timeThreshold === undefined || timeThreshold === null?fd / 2:timeThreshold;if(time + epsilon >= ft && time - epsilon < ft + fd){idx = frag.availabilityIdx;break;}}}return idx;}function getRequestForSegment(segment){if(segment === null || segment === undefined){return null;}var request=new _streamingVoFragmentRequest2['default']();var representation=segment.representation;var bandwidth=representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].bandwidth;var url=segment.media;url = (0,_utilsSegmentsUtils.replaceTokenForTemplate)(url,'Number',segment.replacementNumber);url = (0,_utilsSegmentsUtils.replaceTokenForTemplate)(url,'Time',segment.replacementTime);url = (0,_utilsSegmentsUtils.replaceTokenForTemplate)(url,'Bandwidth',bandwidth);url = (0,_utilsSegmentsUtils.replaceIDForTemplate)(url,representation.id);url = (0,_utilsSegmentsUtils.unescapeDollarsInTemplate)(url);request.mediaType = getType();request.type = _streamingVoMetricsHTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE;request.range = segment.mediaRange;request.startTime = segment.presentationStartTime;request.duration = segment.duration;request.timescale = representation.timescale;request.availabilityStartTime = segment.availabilityStartTime;request.availabilityEndTime = segment.availabilityEndTime;request.wallStartTime = segment.wallStartTime;request.quality = representation.index;request.index = segment.availabilityIdx;request.mediaInfo = getMediaInfo();request.adaptationIndex = representation.adaptation.index;request.representationId = representation.id;if(setRequestUrl(request,url,representation)){return request;}}function getSegmentRequestForTime(representation,time,options){var request=undefined,segment=undefined,finished=undefined;if(!representation){return null;}var type=getType();var idx=index;var keepIdx=options?options.keepIdx:false;var timeThreshold=options?options.timeThreshold:null;var ignoreIsFinished=options && options.ignoreIsFinished?true:false;if(requestedTime !== time){ // When playing at live edge with 0 delay we may loop back with same time and index until it is available. Reduces verboseness of logs.
requestedTime = time;logger.debug('Getting the request for ' + type + ' time : ' + time);}updateSegments(representation);index = getIndexForSegments(time,representation,timeThreshold); //Index may be -1 if getSegments needs to update again.  So after getSegments is called and updated then try to get index again.
if(index < 0){updateSegments(representation);index = getIndexForSegments(time,representation,timeThreshold);}if(index >= 0){logger.debug('Index for ' + type + ' time ' + time + ' is ' + index);}finished = !ignoreIsFinished?isMediaFinished(representation):false;if(finished){request = new _streamingVoFragmentRequest2['default']();request.action = _streamingVoFragmentRequest2['default'].ACTION_COMPLETE;request.index = index;request.mediaType = type;request.mediaInfo = getMediaInfo();logger.debug('Signal complete in getSegmentRequestForTime -',type);}else {segment = (0,_utilsSegmentsUtils.getSegmentByIndex)(index,representation);request = getRequestForSegment(segment);}if(keepIdx && idx >= 0){index = representation.segmentInfoType === _constantsDashConstants2['default'].SEGMENT_TIMELINE && isDynamic()?index:idx;}return request;}function getNextSegmentRequest(representation){var request=undefined,segment=undefined,finished=undefined;if(!representation || index === -1){return null;}var type=getType();var isDynamicStream=isDynamic();requestedTime = null;index++;logger.debug('Getting the next request at index: ' + index + ', type: ' + type); // check that there is a segment in this index. If none, update segments and wait for next time loop is called
var seg=(0,_utilsSegmentsUtils.getSegmentByIndex)(index,representation);if(!seg && isDynamicStream){logger.debug('No segment found at index: ' + index + '. Wait for next loop');updateSegments(representation);index--;return null;}finished = isMediaFinished(representation);if(finished){request = new _streamingVoFragmentRequest2['default']();request.action = _streamingVoFragmentRequest2['default'].ACTION_COMPLETE;request.index = index;request.mediaType = type;request.mediaInfo = getMediaInfo();logger.debug('Signal complete -',type);}else {updateSegments(representation);segment = (0,_utilsSegmentsUtils.getSegmentByIndex)(index,representation);request = getRequestForSegment(segment);if(!segment && isDynamicStream){ /*
                 Sometimes when playing dynamic streams with 0 fragment delay at live edge we ask for
                 an index before it is available so we decrement index back and send null request
                 which triggers the validate loop to rerun and the next time the segment should be
                 available.
                 */index--;}}return request;}function onInitializationLoaded(e){var representation=e.representation;if(!representation.segments)return;eventBus.trigger(_coreEventsEvents2['default'].REPRESENTATION_UPDATED,{sender:this,representation:representation});}function onSegmentsLoaded(e){if(e.error || getType() !== e.mediaType)return;var fragments=e.segments;var representation=e.representation;var segments=[];var count=0;var i=undefined,len=undefined,s=undefined,seg=undefined;for(i = 0,len = fragments.length;i < len;i++) {s = fragments[i];seg = (0,_utilsSegmentsUtils.getTimeBasedSegment)(timelineConverter,isDynamic(),representation,s.startTime,s.duration,s.timescale,s.media,s.mediaRange,count);segments.push(seg);seg = null;count++;}representation.segmentAvailabilityRange = {start:segments[0].presentationStartTime,end:segments[len - 1].presentationStartTime};representation.availableSegmentsNumber = len;onSegmentListUpdated(representation,segments);if(!_voRepresentation2['default'].hasInitialization(representation))return;eventBus.trigger(_coreEventsEvents2['default'].REPRESENTATION_UPDATED,{sender:this,representation:representation});}instance = {initialize:initialize,getStreamProcessor:getStreamProcessor,getInitRequest:getInitRequest,getSegmentRequestForTime:getSegmentRequestForTime,getNextSegmentRequest:getNextSegmentRequest,updateRepresentation:updateRepresentation,updateSegmentList:updateSegmentList,setCurrentTime:setCurrentTime,getCurrentTime:getCurrentTime,reset:reset,resetIndex:resetIndex};setup();return instance;}DashHandler.__dashjs_factory_name = 'DashHandler';exports['default'] = _coreFactoryMaker2['default'].getClassFactory(DashHandler);module.exports = exports['default'];
//# sourceMappingURL=DashHandler.js.map
