/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */'use strict';Object.defineProperty(exports,'__esModule',{value:true});function _interopRequireDefault(obj){return obj && obj.__esModule?obj:{'default':obj};}var _constantsConstants=require('../constants/Constants');var _constantsConstants2=_interopRequireDefault(_constantsConstants);var _dashConstantsDashConstants=require('../../dash/constants/DashConstants');var _dashConstantsDashConstants2=_interopRequireDefault(_dashConstantsDashConstants);var _coreFactoryMaker=require('../../core/FactoryMaker');var _coreFactoryMaker2=_interopRequireDefault(_coreFactoryMaker);var _voThumbnailTrackInfo=require('../vo/ThumbnailTrackInfo');var _voThumbnailTrackInfo2=_interopRequireDefault(_voThumbnailTrackInfo);var _streamingUtilsURLUtils=require('../../streaming/utils/URLUtils');var _streamingUtilsURLUtils2=_interopRequireDefault(_streamingUtilsURLUtils);var _dashUtilsSegmentsUtils=require('../../dash/utils/SegmentsUtils');var _dashSegmentBaseLoader=require('../../dash/SegmentBaseLoader');var _dashSegmentBaseLoader2=_interopRequireDefault(_dashSegmentBaseLoader);var _streamingUtilsBoxParser=require('../../streaming/utils/BoxParser');var _streamingUtilsBoxParser2=_interopRequireDefault(_streamingUtilsBoxParser);var _streamingNetXHRLoader=require('../../streaming/net/XHRLoader');var _streamingNetXHRLoader2=_interopRequireDefault(_streamingNetXHRLoader);var THUMBNAILS_SCHEME_ID_URIS=['http://dashif.org/thumbnail_tile','http://dashif.org/guidelines/thumbnail_tile'];exports.THUMBNAILS_SCHEME_ID_URIS = THUMBNAILS_SCHEME_ID_URIS;function ThumbnailTracks(config){var context=this.context;var dashManifestModel=config.dashManifestModel;var adapter=config.adapter;var baseURLController=config.baseURLController;var stream=config.stream;var timelineConverter=config.timelineConverter;var metricsModel=config.metricsModel;var mediaPlayerModel=config.mediaPlayerModel;var errHandler=config.errHandler;var urlUtils=(0,_streamingUtilsURLUtils2['default'])(context).getInstance();var instance=undefined,tracks=undefined,currentTrackIndex=undefined,loader=undefined,segmentBaseLoader=undefined,boxParser=undefined;function initialize(){reset();loader = (0,_streamingNetXHRLoader2['default'])(context).create({});boxParser = (0,_streamingUtilsBoxParser2['default'])(context).getInstance();segmentBaseLoader = (0,_dashSegmentBaseLoader2['default'])(context).getInstance();segmentBaseLoader.setConfig({baseURLController:baseURLController,metricsModel:metricsModel,mediaPlayerModel:mediaPlayerModel,errHandler:errHandler}); // parse representation and create tracks
addTracks();}function normalizeSegments(fragments,representation){var segments=[];var count=0;var i=undefined,len=undefined,s=undefined,seg=undefined;for(i = 0,len = fragments.length;i < len;i++) {s = fragments[i];seg = (0,_dashUtilsSegmentsUtils.getTimeBasedSegment)(timelineConverter,dashManifestModel.getIsDynamic(),representation,s.startTime,s.duration,s.timescale,s.media,s.mediaRange,count);segments.push(seg);seg = null;count++;}return segments;}function addTracks(){if(!stream || !dashManifestModel || !adapter){return;}var streamInfo=stream.getStreamInfo();if(!streamInfo){return;} // Extract thumbnail tracks
var mediaInfo=adapter.getMediaInfoForType(streamInfo,_constantsConstants2['default'].IMAGE);if(!mediaInfo){return;}var voAdaptation=adapter.getDataForMedia(mediaInfo);if(!voAdaptation){return;}var voReps=dashManifestModel.getRepresentationsForAdaptation(voAdaptation);if(voReps && voReps.length > 0){voReps.forEach(function(rep){if(rep.segmentInfoType === _dashConstantsDashConstants2['default'].SEGMENT_TEMPLATE && rep.segmentDuration > 0 && rep.media)createTrack(rep);if(rep.segmentInfoType === _dashConstantsDashConstants2['default'].SEGMENT_BASE)createTrack(rep,true);});}if(tracks.length > 0){ // Sort bitrates and select the lowest bitrate rendition
tracks.sort(function(a,b){return a.bitrate - b.bitrate;});currentTrackIndex = tracks.length - 1;}}function createTrack(representation,useSegmentBase){var track=new _voThumbnailTrackInfo2['default']();track.id = representation.id;track.bitrate = representation.bandwidth;track.width = representation.width;track.height = representation.height;track.tilesHor = 1;track.tilesVert = 1;if(representation.essentialProperties){representation.essentialProperties.forEach(function(p){if(THUMBNAILS_SCHEME_ID_URIS.indexOf(p.schemeIdUri) >= 0 && p.value){var vars=p.value.split('x');if(vars.length === 2 && !isNaN(vars[0]) && !isNaN(vars[1])){track.tilesHor = parseInt(vars[0],10);track.tilesVert = parseInt(vars[1],10);}}});}if(useSegmentBase){segmentBaseLoader.loadSegments(representation,_constantsConstants2['default'].IMAGE,representation.indexRange,{},function(segments,representation){var cache=[];segments = normalizeSegments(segments,representation);track.segmentDuration = segments[0].duration; //assume all segments have the same duration
track.readThumbnail = function(time,callback){var cached=null;cache.some(function(el){if(el.start <= time && el.end > time){cached = el.url;return true;}});if(cached){callback(cached);}else {segments.some(function(ss){if(ss.mediaStartTime <= time && ss.mediaStartTime + ss.duration > time){var baseURL=baseURLController.resolve(representation.path);loader.load({method:'get',url:baseURL.url,request:{range:ss.mediaRange,responseType:'arraybuffer'},onload:function onload(e){var info=boxParser.getSamplesInfo(e.target.response);var blob=new Blob([e.target.response.slice(info.sampleList[0].offset,info.sampleList[0].offset + info.sampleList[0].size)],{type:'image/jpeg'});var imageUrl=window.URL.createObjectURL(blob);cache.push({start:ss.mediaStartTime,end:ss.mediaStartTime + ss.duration,url:imageUrl});if(callback)callback(imageUrl);}});return true;}});}};});}else {track.startNumber = representation.startNumber;track.segmentDuration = representation.segmentDuration;track.timescale = representation.timescale;track.templateUrl = buildTemplateUrl(representation);}if(track.tilesHor > 0 && track.tilesVert > 0){ // Precalculate width and heigth per tile for perf reasons
track.widthPerTile = track.width / track.tilesHor;track.heightPerTile = track.height / track.tilesVert;tracks.push(track);}}function buildTemplateUrl(representation){var templateUrl=urlUtils.isRelative(representation.media)?urlUtils.resolve(representation.media,baseURLController.resolve(representation.path).url):representation.media;if(!templateUrl){return '';}return (0,_dashUtilsSegmentsUtils.replaceIDForTemplate)(templateUrl,representation.id);}function getTracks(){return tracks;}function getCurrentTrackIndex(){return currentTrackIndex;}function getCurrentTrack(){if(currentTrackIndex < 0){return null;}return tracks[currentTrackIndex];}function setTrackByIndex(index){if(!tracks || tracks.length === 0){return;} // select highest bitrate in case selected index is higher than bitrate list length
if(index >= tracks.length){index = tracks.length - 1;}currentTrackIndex = index;}function reset(){tracks = [];currentTrackIndex = -1;}instance = {initialize:initialize,getTracks:getTracks,reset:reset,setTrackByIndex:setTrackByIndex,getCurrentTrack:getCurrentTrack,getCurrentTrackIndex:getCurrentTrackIndex};initialize();return instance;}ThumbnailTracks.__dashjs_factory_name = 'ThumbnailTracks';exports['default'] = _coreFactoryMaker2['default'].getClassFactory(ThumbnailTracks);
//# sourceMappingURL=ThumbnailTracks.js.map
