'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _Segment=require('./vo/Segment');var _Segment2=_interopRequireDefault(_Segment);var _DashJSError=require('../streaming/vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _FactoryMaker=require('../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _FragmentRequest=require('../streaming/vo/FragmentRequest');var _FragmentRequest2=_interopRequireDefault(_FragmentRequest);var _URLLoader=require('../streaming/net/URLLoader');var _URLLoader2=_interopRequireDefault(_URLLoader);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function SegmentBaseLoader(){var context=this.context;var instance=void 0,logger=void 0,errHandler=void 0,boxParser=void 0,requestModifier=void 0,dashMetrics=void 0,settings=void 0,mediaPlayerModel=void 0,urlLoader=void 0,events=void 0,eventBus=void 0,errors=void 0,constants=void 0,dashConstants=void 0,urlUtils=void 0,baseURLController=void 0;function setup(){}function initialize(){urlLoader=(0,_URLLoader2.default)(context).create({errHandler:errHandler,dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,requestModifier:requestModifier,useFetch:settings?settings.get().streaming.lowLatencyEnabled:null,boxParser:boxParser,errors:errors,urlUtils:urlUtils,constants:constants,dashConstants:dashConstants});}function setConfig(config){if(config.baseURLController){baseURLController=config.baseURLController;}if(config.dashMetrics){dashMetrics=config.dashMetrics;}if(config.mediaPlayerModel){mediaPlayerModel=config.mediaPlayerModel;}if(config.errHandler){errHandler=config.errHandler;}if(config.settings){settings=config.settings;}if(config.boxParser){boxParser=config.boxParser;}if(config.events){events=config.events;}if(config.eventBus){eventBus=config.eventBus;}if(config.debug){logger=config.debug.getLogger(instance);}if(config.requestModifier){requestModifier=config.requestModifier;}if(config.errors){errors=config.errors;}if(config.urlUtils){urlUtils=config.urlUtils;}if(config.constants){constants=config.constants;}if(config.dashConstants){dashConstants=config.dashConstants;}}function checkConfig(){if(!baseURLController||!baseURLController.hasOwnProperty('resolve')){throw new Error('setConfig function has to be called previously');}}function loadInitialization(streamId,mediaType,representation,loadingInfo){checkConfig();var initRange=null;var baseUrl=representation?baseURLController.resolve(representation.path):null;var info=loadingInfo||{init:true,url:baseUrl?baseUrl.url:undefined,range:{start:0,end:1500},searching:false,bytesLoaded:0,bytesToLoad:1500,mediaType:mediaType};logger.debug('Start searching for initialization.');var request=getFragmentRequest(info);var onload=function onload(response){info.bytesLoaded=info.range.end;initRange=boxParser.findInitRange(response);if(initRange){representation.range=initRange;// note that we don't explicitly set rep.initialization as this
// will be computed when all BaseURLs are resolved later
eventBus.trigger(events.INITIALIZATION_LOADED,{representation:representation},{streamId:streamId,mediaType:mediaType});}else{info.range.end=info.bytesLoaded+info.bytesToLoad;loadInitialization(streamId,mediaType,representation,info);}};var onerror=function onerror(){eventBus.trigger(events.INITIALIZATION_LOADED,{representation:representation},{streamId:streamId,mediaType:mediaType});};urlLoader.load({request:request,success:onload,error:onerror});logger.debug('Perform init search: '+info.url);}function loadSegments(streamId,mediaType,representation,range,callback,loadingInfo){checkConfig();if(range&&(range.start===undefined||range.end===undefined)){var parts=range?range.toString().split('-'):null;range=parts?{start:parseFloat(parts[0]),end:parseFloat(parts[1])}:null;}callback=!callback?onLoaded:callback;var isoFile=null;var sidx=null;var hasRange=!!range;var baseUrl=representation?baseURLController.resolve(representation.path):null;var info={init:false,url:baseUrl?baseUrl.url:undefined,range:hasRange?range:{start:0,end:1500},searching:!hasRange,bytesLoaded:loadingInfo?loadingInfo.bytesLoaded:0,bytesToLoad:1500,mediaType:mediaType};var request=getFragmentRequest(info);var onload=function onload(response){var extraBytes=info.bytesToLoad;var loadedLength=response.byteLength;info.bytesLoaded=info.range.end-info.range.start;isoFile=boxParser.parse(response);sidx=isoFile.getBox('sidx');if(!sidx||!sidx.isComplete){if(sidx){info.range.start=sidx.offset||info.range.start;info.range.end=info.range.start+(sidx.size||extraBytes);}else if(loadedLength<info.bytesLoaded){// if we have reached a search limit or if we have reached the end of the file we have to stop trying to find sidx
callback(streamId,mediaType,null,representation);return;}else{var lastBox=isoFile.getLastBox();if(lastBox&&lastBox.size){info.range.start=lastBox.offset+lastBox.size;info.range.end=info.range.start+extraBytes;}else{info.range.end+=extraBytes;}}loadSegments(streamId,mediaType,representation,info.range,callback,info);}else{var ref=sidx.references;var loadMultiSidx=void 0,segments=void 0;if(ref!==null&&ref!==undefined&&ref.length>0){loadMultiSidx=ref[0].reference_type===1;}if(loadMultiSidx){logger.debug('Initiate multiple SIDX load.');info.range.end=info.range.start+sidx.size;var j=void 0,len=void 0,ss=void 0,se=void 0,r=void 0;var segs=[];var count=0;var offset=(sidx.offset||info.range.start)+sidx.size;var tmpCallback=function tmpCallback(streamId,mediaType,result){if(result){segs=segs.concat(result);count++;if(count>=len){// http requests can be processed in a wrong order, so, we have to reorder segments with an ascending start Time order
segs.sort(function(a,b){return a.startTime-b.startTime<0?-1:0;});callback(streamId,mediaType,segs,representation);}}else{callback(streamId,mediaType,null,representation);}};for(j=0,len=ref.length;j<len;j++){ss=offset;se=offset+ref[j].referenced_size-1;offset=offset+ref[j].referenced_size;r={start:ss,end:se};loadSegments(streamId,mediaType,representation,r,tmpCallback,info);}}else{logger.debug('Parsing segments from SIDX. representation '+mediaType+' - id: '+representation.id+' for range : '+info.range.start+' - '+info.range.end);segments=getSegmentsForSidx(sidx,info);callback(streamId,mediaType,segments,representation);}}};var onerror=function onerror(){callback(streamId,mediaType,null,representation);};urlLoader.load({request:request,success:onload,error:onerror});logger.debug('Perform SIDX load: '+info.url+' with range : '+info.range.start+' - '+info.range.end);}function reset(){urlLoader.abort();urlLoader=null;errHandler=null;boxParser=null;requestModifier=null;}function getSegmentsForSidx(sidx,info){var refs=sidx.references;var len=refs.length;var timescale=sidx.timescale;var time=sidx.earliest_presentation_time;var start=info.range.start+sidx.offset+sidx.first_offset+sidx.size;var segments=[];var segment=void 0,end=void 0,duration=void 0,size=void 0;for(var i=0;i<len;i++){duration=refs[i].subsegment_duration;size=refs[i].referenced_size;segment=new _Segment2.default();// note that we don't explicitly set segment.media as this will be
// computed when all BaseURLs are resolved later
segment.duration=duration;segment.startTime=time;segment.timescale=timescale;end=start+size-1;segment.mediaRange=start+'-'+end;segments.push(segment);time+=duration;start+=size;}return segments;}function getFragmentRequest(info){if(!info.url){return;}var request=new _FragmentRequest2.default();request.setInfo(info);return request;}function onLoaded(streamId,mediaType,segments,representation){eventBus.trigger(events.SEGMENTS_LOADED,{segments:segments,representation:representation,error:segments?undefined:new _DashJSError2.default(errors.SEGMENT_BASE_LOADER_ERROR_CODE,errors.SEGMENT_BASE_LOADER_ERROR_MESSAGE)},{streamId:streamId,mediaType:mediaType});}instance={setConfig:setConfig,initialize:initialize,loadInitialization:loadInitialization,loadSegments:loadSegments,reset:reset};setup();return instance;}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */SegmentBaseLoader.__dashjs_factory_name='SegmentBaseLoader';exports.default=_FactoryMaker2.default.getSingletonFactory(SegmentBaseLoader);
//# sourceMappingURL=SegmentBaseLoader.js.map
