'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _Constants=require('../../streaming/constants/Constants');var _Constants2=_interopRequireDefault(_Constants);var _DashConstants=require('../constants/DashConstants');var _DashConstants2=_interopRequireDefault(_DashConstants);var _Representation=require('../vo/Representation');var _Representation2=_interopRequireDefault(_Representation);var _AdaptationSet=require('../vo/AdaptationSet');var _AdaptationSet2=_interopRequireDefault(_AdaptationSet);var _Period=require('../vo/Period');var _Period2=_interopRequireDefault(_Period);var _Mpd=require('../vo/Mpd');var _Mpd2=_interopRequireDefault(_Mpd);var _UTCTiming=require('../vo/UTCTiming');var _UTCTiming2=_interopRequireDefault(_UTCTiming);var _Event=require('../vo/Event');var _Event2=_interopRequireDefault(_Event);var _BaseURL=require('../vo/BaseURL');var _BaseURL2=_interopRequireDefault(_BaseURL);var _EventStream=require('../vo/EventStream');var _EventStream2=_interopRequireDefault(_EventStream);var _ObjectUtils=require('../../streaming/utils/ObjectUtils');var _ObjectUtils2=_interopRequireDefault(_ObjectUtils);var _URLUtils=require('../../streaming/utils/URLUtils');var _URLUtils2=_interopRequireDefault(_URLUtils);var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _DashJSError=require('../../streaming/vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _Errors=require('../../core/errors/Errors');var _Errors2=_interopRequireDefault(_Errors);var _ThumbnailTracks=require('../../streaming/thumbnail/ThumbnailTracks');function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function DashManifestModel(){var instance=void 0,logger=void 0,errHandler=void 0,BASE64=void 0;var context=this.context;var urlUtils=(0,_URLUtils2.default)(context).getInstance();var isInteger=Number.isInteger||function(value){return typeof value==='number'&&isFinite(value)&&Math.floor(value)===value;};function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);}function getIsTypeOf(adaptation,type){var i=void 0,len=void 0,representation=void 0,col=void 0,mimeTypeRegEx=void 0,codecs=void 0;var result=false;var found=false;if(!adaptation){throw new Error('adaptation is not defined');}if(!type){throw new Error('type is not defined');}if(adaptation.hasOwnProperty('ContentComponent_asArray')){col=adaptation.ContentComponent_asArray;}mimeTypeRegEx=type!==_Constants2.default.TEXT?new RegExp(type):new RegExp('(vtt|ttml)');if(adaptation.Representation_asArray&&adaptation.Representation_asArray.length&&adaptation.Representation_asArray.length>0){var essentialProperties=getEssentialPropertiesForRepresentation(adaptation.Representation_asArray[0]);if(essentialProperties&&essentialProperties.length>0&&_ThumbnailTracks.THUMBNAILS_SCHEME_ID_URIS.indexOf(essentialProperties[0].schemeIdUri)>=0){return type===_Constants2.default.IMAGE;}if(adaptation.Representation_asArray[0].hasOwnProperty(_DashConstants2.default.CODECS)){// Just check the start of the codecs string
codecs=adaptation.Representation_asArray[0].codecs;if(codecs.search(_Constants2.default.STPP)===0||codecs.search(_Constants2.default.WVTT)===0){return type===_Constants2.default.FRAGMENTED_TEXT;}}}if(col){if(col.length>1){return type===_Constants2.default.MUXED;}else if(col[0]&&col[0].contentType===type){result=true;found=true;}}if(adaptation.hasOwnProperty(_DashConstants2.default.MIME_TYPE)){result=mimeTypeRegEx.test(adaptation.mimeType);found=true;}// couldn't find on adaptationset, so check a representation
if(!found){i=0;len=adaptation.Representation_asArray&&adaptation.Representation_asArray.length?adaptation.Representation_asArray.length:0;while(!found&&i<len){representation=adaptation.Representation_asArray[i];if(representation.hasOwnProperty(_DashConstants2.default.MIME_TYPE)){result=mimeTypeRegEx.test(representation.mimeType);found=true;}i++;}}return result;}function getIsAudio(adaptation){return getIsTypeOf(adaptation,_Constants2.default.AUDIO);}function getIsVideo(adaptation){return getIsTypeOf(adaptation,_Constants2.default.VIDEO);}function getIsFragmentedText(adaptation){return getIsTypeOf(adaptation,_Constants2.default.FRAGMENTED_TEXT);}function getIsMuxed(adaptation){return getIsTypeOf(adaptation,_Constants2.default.MUXED);}function getIsImage(adaptation){return getIsTypeOf(adaptation,_Constants2.default.IMAGE);}function getIsTextTrack(type){return type==='text/vtt'||type==='application/ttml+xml';}function getLanguageForAdaptation(adaptation){var lang='';if(adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.LANG)){//Filter out any other characters not allowed according to RFC5646
lang=adaptation.lang.replace(/[^A-Za-z0-9-]/g,'');}return lang;}function getViewpointForAdaptation(adaptation){return adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.VIEWPOINT)?adaptation.Viewpoint:null;}function getRolesForAdaptation(adaptation){return adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.ROLE_ASARRAY)?adaptation.Role_asArray:[];}function getAccessibilityForAdaptation(adaptation){return adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.ACCESSIBILITY_ASARRAY)?adaptation.Accessibility_asArray:[];}function getAudioChannelConfigurationForAdaptation(adaptation){return adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.AUDIOCHANNELCONFIGURATION_ASARRAY)?adaptation.AudioChannelConfiguration_asArray:[];}function getAudioChannelConfigurationForRepresentation(representation){return representation&&representation.hasOwnProperty(_DashConstants2.default.AUDIOCHANNELCONFIGURATION_ASARRAY)?representation.AudioChannelConfiguration_asArray:[];}function getRepresentationSortFunction(){return function(a,b){return a.bandwidth-b.bandwidth;};}function processAdaptation(realAdaptation){if(realAdaptation&&Array.isArray(realAdaptation.Representation_asArray)){realAdaptation.Representation_asArray.sort(getRepresentationSortFunction());}return realAdaptation;}function getRealAdaptations(manifest,periodIndex){return manifest&&manifest.Period_asArray&&isInteger(periodIndex)?manifest.Period_asArray[periodIndex]?manifest.Period_asArray[periodIndex].AdaptationSet_asArray:[]:[];}function getRealPeriods(manifest){return manifest&&manifest.Period_asArray?manifest.Period_asArray:[];}function getRealPeriodForIndex(index,manifest){var realPeriods=getRealPeriods(manifest);if(realPeriods.length>0&&isInteger(index)){return realPeriods[index];}else{return null;}}function getAdaptationForId(id,manifest,periodIndex){var realAdaptations=getRealAdaptations(manifest,periodIndex);var i=void 0,len=void 0;for(i=0,len=realAdaptations.length;i<len;i++){if(realAdaptations[i].hasOwnProperty(_DashConstants2.default.ID)&&realAdaptations[i].id===id){return realAdaptations[i];}}return null;}function getAdaptationForIndex(index,manifest,periodIndex){var realAdaptations=getRealAdaptations(manifest,periodIndex);if(realAdaptations.length>0&&isInteger(index)){return realAdaptations[index];}else{return null;}}function getIndexForAdaptation(realAdaptation,manifest,periodIndex){if(!realAdaptation){return-1;}var realAdaptations=getRealAdaptations(manifest,periodIndex);for(var i=0;i<realAdaptations.length;i++){var objectUtils=(0,_ObjectUtils2.default)(context).getInstance();if(objectUtils.areEqual(realAdaptations[i],realAdaptation)){return i;}}return-1;}function getAdaptationsForType(manifest,periodIndex,type){var realAdaptations=getRealAdaptations(manifest,periodIndex);var i=void 0,len=void 0;var adaptations=[];for(i=0,len=realAdaptations.length;i<len;i++){if(getIsTypeOf(realAdaptations[i],type)){adaptations.push(processAdaptation(realAdaptations[i]));}}return adaptations;}function getCodec(adaptation,representationId,addResolutionInfo){var codec=null;if(adaptation&&adaptation.Representation_asArray&&adaptation.Representation_asArray.length>0){var representation=isInteger(representationId)&&representationId>=0&&representationId<adaptation.Representation_asArray.length?adaptation.Representation_asArray[representationId]:adaptation.Representation_asArray[0];if(representation){codec=representation.mimeType+';codecs="'+representation.codecs+'"';if(addResolutionInfo&&representation.width!==undefined){codec+=';width="'+representation.width+'";height="'+representation.height+'"';}}}// If the codec contains a profiles parameter we remove it. Otherwise it will cause problems when checking for codec capabilities of the platform
if(codec){codec=codec.replace(/\sprofiles=[^;]*/g,'');}return codec;}function getMimeType(adaptation){return adaptation&&adaptation.Representation_asArray&&adaptation.Representation_asArray.length>0?adaptation.Representation_asArray[0].mimeType:null;}function getKID(adaptation){if(!adaptation||!adaptation.hasOwnProperty(_DashConstants2.default.CENC_DEFAULT_KID)){return null;}return adaptation[_DashConstants2.default.CENC_DEFAULT_KID];}function getLabelsForAdaptation(adaptation){if(!adaptation||!Array.isArray(adaptation.Label_asArray)){return[];}var labelArray=[];for(var i=0;i<adaptation.Label_asArray.length;i++){labelArray.push({lang:adaptation.Label_asArray[i].lang,text:adaptation.Label_asArray[i].__text||adaptation.Label_asArray[i]});}return labelArray;}function getContentProtectionData(adaptation){if(!adaptation||!adaptation.hasOwnProperty(_DashConstants2.default.CONTENTPROTECTION_ASARRAY)||adaptation.ContentProtection_asArray.length===0){return null;}return adaptation.ContentProtection_asArray;}function getIsDynamic(manifest){var isDynamic=false;if(manifest&&manifest.hasOwnProperty('type')){isDynamic=manifest.type===_DashConstants2.default.DYNAMIC;}return isDynamic;}function getId(manifest){return manifest&&manifest[_DashConstants2.default.ID]||null;}function hasProfile(manifest,profile){var has=false;if(manifest&&manifest.profiles&&manifest.profiles.length>0){has=manifest.profiles.indexOf(profile)!==-1;}return has;}function getDuration(manifest){var mpdDuration=void 0;//@mediaPresentationDuration specifies the duration of the entire Media Presentation.
//If the attribute is not present, the duration of the Media Presentation is unknown.
if(manifest&&manifest.hasOwnProperty(_DashConstants2.default.MEDIA_PRESENTATION_DURATION)){mpdDuration=manifest.mediaPresentationDuration;}else if(manifest&&manifest.type=='dynamic'){mpdDuration=Number.POSITIVE_INFINITY;}else{mpdDuration=Number.MAX_SAFE_INTEGER||Number.MAX_VALUE;}return mpdDuration;}function getBandwidth(representation){return representation&&representation.bandwidth?representation.bandwidth:NaN;}function getManifestUpdatePeriod(manifest){var latencyOfLastUpdate=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;var delay=NaN;if(manifest&&manifest.hasOwnProperty(_DashConstants2.default.MINIMUM_UPDATE_PERIOD)){delay=manifest.minimumUpdatePeriod;}return isNaN(delay)?delay:Math.max(delay-latencyOfLastUpdate,1);}function getPublishTime(manifest){return manifest&&manifest.hasOwnProperty(_DashConstants2.default.PUBLISH_TIME)?new Date(manifest[_DashConstants2.default.PUBLISH_TIME]):null;}function getRepresentationCount(adaptation){return adaptation&&Array.isArray(adaptation.Representation_asArray)?adaptation.Representation_asArray.length:0;}function getBitrateListForAdaptation(realAdaptation){var processedRealAdaptation=processAdaptation(realAdaptation);var realRepresentations=processedRealAdaptation&&Array.isArray(processedRealAdaptation.Representation_asArray)?processedRealAdaptation.Representation_asArray:[];return realRepresentations.map(function(realRepresentation){return{bandwidth:realRepresentation.bandwidth,width:realRepresentation.width||0,height:realRepresentation.height||0,scanType:realRepresentation.scanType||null,id:realRepresentation.id||null};});}function getEssentialPropertiesForRepresentation(realRepresentation){if(!realRepresentation||!realRepresentation.EssentialProperty_asArray||!realRepresentation.EssentialProperty_asArray.length)return null;return realRepresentation.EssentialProperty_asArray.map(function(prop){return{schemeIdUri:prop.schemeIdUri,value:prop.value};});}function getRepresentationFor(index,adaptation){return adaptation&&adaptation.Representation_asArray&&adaptation.Representation_asArray.length>0&&isInteger(index)?adaptation.Representation_asArray[index]:null;}function getRealAdaptationFor(voAdaptation){if(voAdaptation&&voAdaptation.period&&isInteger(voAdaptation.period.index)){var periodArray=voAdaptation.period.mpd.manifest.Period_asArray[voAdaptation.period.index];if(periodArray&&periodArray.AdaptationSet_asArray&&isInteger(voAdaptation.index)){return processAdaptation(periodArray.AdaptationSet_asArray[voAdaptation.index]);}}}function getRepresentationsForAdaptation(voAdaptation){var voRepresentations=[];var processedRealAdaptation=getRealAdaptationFor(voAdaptation);var segmentInfo=void 0,baseUrl=void 0;if(processedRealAdaptation&&processedRealAdaptation.Representation_asArray){// TODO: TO BE REMOVED. We should get just the baseUrl elements that affects to the representations
// that we are processing. Making it works properly will require much further changes and given
// parsing base Urls parameters is needed for our ultra low latency examples, we will
// keep this "tricky" code until the real (and good) solution comes
if(voAdaptation&&voAdaptation.period&&isInteger(voAdaptation.period.index)){var baseUrls=getBaseURLsFromElement(voAdaptation.period.mpd.manifest);if(baseUrls){baseUrl=baseUrls[0];}}for(var i=0,len=processedRealAdaptation.Representation_asArray.length;i<len;++i){var realRepresentation=processedRealAdaptation.Representation_asArray[i];var voRepresentation=new _Representation2.default();voRepresentation.index=i;voRepresentation.adaptation=voAdaptation;if(realRepresentation.hasOwnProperty(_DashConstants2.default.ID)){voRepresentation.id=realRepresentation.id;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.CODECS)){voRepresentation.codecs=realRepresentation.codecs;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.CODEC_PRIVATE_DATA)){voRepresentation.codecPrivateData=realRepresentation.codecPrivateData;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.BANDWITH)){voRepresentation.bandwidth=realRepresentation.bandwidth;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.WIDTH)){voRepresentation.width=realRepresentation.width;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.HEIGHT)){voRepresentation.height=realRepresentation.height;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.SCAN_TYPE)){voRepresentation.scanType=realRepresentation.scanType;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.MAX_PLAYOUT_RATE)){voRepresentation.maxPlayoutRate=realRepresentation.maxPlayoutRate;}if(realRepresentation.hasOwnProperty(_DashConstants2.default.SEGMENT_BASE)){segmentInfo=realRepresentation.SegmentBase;voRepresentation.segmentInfoType=_DashConstants2.default.SEGMENT_BASE;}else if(realRepresentation.hasOwnProperty(_DashConstants2.default.SEGMENT_LIST)){segmentInfo=realRepresentation.SegmentList;if(segmentInfo.hasOwnProperty(_DashConstants2.default.SEGMENT_TIMELINE)){voRepresentation.segmentInfoType=_DashConstants2.default.SEGMENT_TIMELINE;}else{voRepresentation.segmentInfoType=_DashConstants2.default.SEGMENT_LIST;}}else if(realRepresentation.hasOwnProperty(_DashConstants2.default.SEGMENT_TEMPLATE)){segmentInfo=realRepresentation.SegmentTemplate;if(segmentInfo.hasOwnProperty(_DashConstants2.default.SEGMENT_TIMELINE)){voRepresentation.segmentInfoType=_DashConstants2.default.SEGMENT_TIMELINE;}else{voRepresentation.segmentInfoType=_DashConstants2.default.SEGMENT_TEMPLATE;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.INITIALIZATION_MINUS)){voRepresentation.initialization=segmentInfo.initialization.split('$Bandwidth$').join(realRepresentation.bandwidth).split('$RepresentationID$').join(realRepresentation.id);}}else{voRepresentation.segmentInfoType=_DashConstants2.default.BASE_URL;}voRepresentation.essentialProperties=getEssentialPropertiesForRepresentation(realRepresentation);if(segmentInfo){if(segmentInfo.hasOwnProperty(_DashConstants2.default.INITIALIZATION)){var initialization=segmentInfo.Initialization;if(initialization.hasOwnProperty(_DashConstants2.default.SOURCE_URL)){voRepresentation.initialization=initialization.sourceURL;}if(initialization.hasOwnProperty(_DashConstants2.default.RANGE)){voRepresentation.range=initialization.range;// initialization source url will be determined from
// BaseURL when resolved at load time.
}}else if(realRepresentation.hasOwnProperty(_DashConstants2.default.MIME_TYPE)&&getIsTextTrack(realRepresentation.mimeType)){voRepresentation.range=0;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.TIMESCALE)){voRepresentation.timescale=segmentInfo.timescale;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.DURATION)){// TODO according to the spec @maxSegmentDuration specifies the maximum duration of any Segment in any Representation in the Media Presentation
// It is also said that for a SegmentTimeline any @d value shall not exceed the value of MPD@maxSegmentDuration, but nothing is said about
// SegmentTemplate @duration attribute. We need to find out if @maxSegmentDuration should be used instead of calculated duration if the the duration
// exceeds @maxSegmentDuration
voRepresentation.segmentDuration=segmentInfo.duration/voRepresentation.timescale;}else if(realRepresentation.hasOwnProperty(_DashConstants2.default.SEGMENT_TEMPLATE)){segmentInfo=realRepresentation.SegmentTemplate;if(segmentInfo.hasOwnProperty(_DashConstants2.default.SEGMENT_TIMELINE)){voRepresentation.segmentDuration=calcSegmentDuration(segmentInfo.SegmentTimeline)/voRepresentation.timescale;}}if(segmentInfo.hasOwnProperty(_DashConstants2.default.MEDIA)){voRepresentation.media=segmentInfo.media;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.START_NUMBER)){voRepresentation.startNumber=segmentInfo.startNumber;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.INDEX_RANGE)){voRepresentation.indexRange=segmentInfo.indexRange;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.PRESENTATION_TIME_OFFSET)){voRepresentation.presentationTimeOffset=segmentInfo.presentationTimeOffset/voRepresentation.timescale;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.AVAILABILITY_TIME_OFFSET)){voRepresentation.availabilityTimeOffset=segmentInfo.availabilityTimeOffset;}else if(baseUrl&&baseUrl.availabilityTimeOffset!==undefined){voRepresentation.availabilityTimeOffset=baseUrl.availabilityTimeOffset;}if(segmentInfo.hasOwnProperty(_DashConstants2.default.AVAILABILITY_TIME_COMPLETE)){voRepresentation.availabilityTimeComplete=segmentInfo.availabilityTimeComplete!=='false';}else if(baseUrl&&baseUrl.availabilityTimeComplete!==undefined){voRepresentation.availabilityTimeComplete=baseUrl.availabilityTimeComplete;}}voRepresentation.MSETimeOffset=calcMSETimeOffset(voRepresentation);voRepresentation.path=[voAdaptation.period.index,voAdaptation.index,i];voRepresentations.push(voRepresentation);}}return voRepresentations;}function calcSegmentDuration(segmentTimeline){var s0=segmentTimeline.S_asArray[0];var s1=segmentTimeline.S_asArray[1];return s0.hasOwnProperty('d')?s0.d:s1.t-s0.t;}function calcMSETimeOffset(representation){// The MSEOffset is offset from AST for media. It is Period@start - presentationTimeOffset
var presentationOffset=representation.presentationTimeOffset;var periodStart=representation.adaptation.period.start;return periodStart-presentationOffset;}function getAdaptationsForPeriod(voPeriod){var realPeriod=voPeriod&&isInteger(voPeriod.index)?voPeriod.mpd.manifest.Period_asArray[voPeriod.index]:null;var voAdaptations=[];var voAdaptationSet=void 0,realAdaptationSet=void 0,i=void 0;if(realPeriod&&realPeriod.AdaptationSet_asArray){for(i=0;i<realPeriod.AdaptationSet_asArray.length;i++){realAdaptationSet=realPeriod.AdaptationSet_asArray[i];voAdaptationSet=new _AdaptationSet2.default();if(realAdaptationSet.hasOwnProperty(_DashConstants2.default.ID)){voAdaptationSet.id=realAdaptationSet.id;}voAdaptationSet.index=i;voAdaptationSet.period=voPeriod;if(getIsMuxed(realAdaptationSet)){voAdaptationSet.type=_Constants2.default.MUXED;}else if(getIsAudio(realAdaptationSet)){voAdaptationSet.type=_Constants2.default.AUDIO;}else if(getIsVideo(realAdaptationSet)){voAdaptationSet.type=_Constants2.default.VIDEO;}else if(getIsFragmentedText(realAdaptationSet)){voAdaptationSet.type=_Constants2.default.FRAGMENTED_TEXT;}else if(getIsImage(realAdaptationSet)){voAdaptationSet.type=_Constants2.default.IMAGE;}else{voAdaptationSet.type=_Constants2.default.TEXT;}voAdaptations.push(voAdaptationSet);}}return voAdaptations;}function getRegularPeriods(mpd){var isDynamic=mpd?getIsDynamic(mpd.manifest):false;var voPeriods=[];var realPreviousPeriod=null;var realPeriod=null;var voPreviousPeriod=null;var voPeriod=null;var len=void 0,i=void 0;for(i=0,len=mpd&&mpd.manifest&&mpd.manifest.Period_asArray?mpd.manifest.Period_asArray.length:0;i<len;i++){realPeriod=mpd.manifest.Period_asArray[i];// If the attribute @start is present in the Period, then the
// Period is a regular Period and the PeriodStart is equal
// to the value of this attribute.
if(realPeriod.hasOwnProperty(_DashConstants2.default.START)){voPeriod=new _Period2.default();voPeriod.start=realPeriod.start;}// If the @start attribute is absent, but the previous Period
// element contains a @duration attribute then then this new
// Period is also a regular Period. The start time of the new
// Period PeriodStart is the sum of the start time of the previous
// Period PeriodStart and the value of the attribute @duration
// of the previous Period.
else if(realPreviousPeriod!==null&&realPreviousPeriod.hasOwnProperty(_DashConstants2.default.DURATION)&&voPreviousPeriod!==null){voPeriod=new _Period2.default();voPeriod.start=parseFloat((voPreviousPeriod.start+voPreviousPeriod.duration).toFixed(5));}// If (i) @start attribute is absent, and (ii) the Period element
// is the first in the MPD, and (iii) the MPD@type is 'static',
// then the PeriodStart time shall be set to zero.
else if(i===0&&!isDynamic){voPeriod=new _Period2.default();voPeriod.start=0;}// The Period extends until the PeriodStart of the next Period.
// The difference between the PeriodStart time of a Period and
// the PeriodStart time of the following Period.
if(voPreviousPeriod!==null&&isNaN(voPreviousPeriod.duration)){if(voPeriod!==null){voPreviousPeriod.duration=parseFloat((voPeriod.start-voPreviousPeriod.start).toFixed(5));}else{logger.warn('First period duration could not be calculated because lack of start and duration period properties. This will cause timing issues during playback');}}if(voPeriod!==null){voPeriod.id=getPeriodId(realPeriod,i);voPeriod.index=i;voPeriod.mpd=mpd;if(realPeriod.hasOwnProperty(_DashConstants2.default.DURATION)){voPeriod.duration=realPeriod.duration;}voPeriods.push(voPeriod);realPreviousPeriod=realPeriod;voPreviousPeriod=voPeriod;}realPeriod=null;voPeriod=null;}if(voPeriods.length===0){return voPeriods;}// The last Period extends until the end of the Media Presentation.
// The difference between the PeriodStart time of the last Period
// and the mpd duration
if(voPreviousPeriod!==null&&isNaN(voPreviousPeriod.duration)){voPreviousPeriod.duration=parseFloat((getEndTimeForLastPeriod(voPreviousPeriod)-voPreviousPeriod.start).toFixed(5));}return voPeriods;}function getPeriodId(realPeriod,i){if(!realPeriod){throw new Error('Period cannot be null or undefined');}var id=_Period2.default.DEFAULT_ID+'_'+i;if(realPeriod.hasOwnProperty(_DashConstants2.default.ID)&&realPeriod.id.length>0&&realPeriod.id!=='__proto__'){id=realPeriod.id;}return id;}function getMpd(manifest){var mpd=new _Mpd2.default();if(manifest){mpd.manifest=manifest;if(manifest.hasOwnProperty(_DashConstants2.default.AVAILABILITY_START_TIME)){mpd.availabilityStartTime=new Date(manifest.availabilityStartTime.getTime());}else{if(manifest.loadedTime){mpd.availabilityStartTime=new Date(manifest.loadedTime.getTime());}}if(manifest.hasOwnProperty(_DashConstants2.default.AVAILABILITY_END_TIME)){mpd.availabilityEndTime=new Date(manifest.availabilityEndTime.getTime());}if(manifest.hasOwnProperty(_DashConstants2.default.MINIMUM_UPDATE_PERIOD)){mpd.minimumUpdatePeriod=manifest.minimumUpdatePeriod;}if(manifest.hasOwnProperty(_DashConstants2.default.MEDIA_PRESENTATION_DURATION)){mpd.mediaPresentationDuration=manifest.mediaPresentationDuration;}if(manifest.hasOwnProperty(_DashConstants2.default.SUGGESTED_PRESENTATION_DELAY)){mpd.suggestedPresentationDelay=manifest.suggestedPresentationDelay;}if(manifest.hasOwnProperty(_DashConstants2.default.TIMESHIFT_BUFFER_DEPTH)){mpd.timeShiftBufferDepth=manifest.timeShiftBufferDepth;}if(manifest.hasOwnProperty(_DashConstants2.default.MAX_SEGMENT_DURATION)){mpd.maxSegmentDuration=manifest.maxSegmentDuration;}if(manifest.hasOwnProperty(_DashConstants2.default.PUBLISH_TIME)){mpd.publishTime=new Date(manifest.publishTime);}}return mpd;}function checkConfig(){if(!errHandler||!errHandler.hasOwnProperty('error')){throw new Error(_Constants2.default.MISSING_CONFIG_ERROR);}}function getEndTimeForLastPeriod(voPeriod){checkConfig();var isDynamic=getIsDynamic(voPeriod.mpd.manifest);var periodEnd=void 0;if(voPeriod.mpd.manifest.mediaPresentationDuration){periodEnd=voPeriod.mpd.manifest.mediaPresentationDuration;}else if(voPeriod.duration){periodEnd=voPeriod.duration;}else if(isDynamic){periodEnd=Number.POSITIVE_INFINITY;}else{errHandler.error(new _DashJSError2.default(_Errors2.default.MANIFEST_ERROR_ID_PARSE_CODE,'Must have @mediaPresentationDuration on MPD or an explicit @duration on the last period.',voPeriod));}return periodEnd;}function getEventsForPeriod(period){var manifest=period&&period.mpd&&period.mpd.manifest?period.mpd.manifest:null;var periodArray=manifest?manifest.Period_asArray:null;var eventStreams=periodArray&&period&&isInteger(period.index)?periodArray[period.index].EventStream_asArray:null;var events=[];var i=void 0,j=void 0;if(eventStreams){for(i=0;i<eventStreams.length;i++){var eventStream=new _EventStream2.default();eventStream.period=period;eventStream.timescale=1;if(eventStreams[i].hasOwnProperty(_Constants2.default.SCHEME_ID_URI)){eventStream.schemeIdUri=eventStreams[i][_Constants2.default.SCHEME_ID_URI];}else{throw new Error('Invalid EventStream. SchemeIdUri has to be set');}if(eventStreams[i].hasOwnProperty(_DashConstants2.default.TIMESCALE)){eventStream.timescale=eventStreams[i][_DashConstants2.default.TIMESCALE];}if(eventStreams[i].hasOwnProperty(_DashConstants2.default.VALUE)){eventStream.value=eventStreams[i][_DashConstants2.default.VALUE];}if(eventStreams[i].hasOwnProperty(_DashConstants2.default.PRESENTATION_TIME_OFFSET)){eventStream.presentationTimeOffset=eventStreams[i][_DashConstants2.default.PRESENTATION_TIME_OFFSET];}for(j=0;eventStreams[i].Event_asArray&&j<eventStreams[i].Event_asArray.length;j++){var currentMpdEvent=eventStreams[i].Event_asArray[j];var event=new _Event2.default();event.presentationTime=0;event.eventStream=eventStream;if(currentMpdEvent.hasOwnProperty(_DashConstants2.default.PRESENTATION_TIME)){event.presentationTime=currentMpdEvent.presentationTime;var presentationTimeOffset=eventStream.presentationTimeOffset?eventStream.presentationTimeOffset/eventStream.timescale:0;event.calculatedPresentationTime=event.presentationTime/eventStream.timescale+period.start-presentationTimeOffset;}if(currentMpdEvent.hasOwnProperty(_DashConstants2.default.DURATION)){event.duration=currentMpdEvent.duration/eventStream.timescale;}if(currentMpdEvent.hasOwnProperty(_DashConstants2.default.ID)){event.id=currentMpdEvent.id;}if(currentMpdEvent.Signal&&currentMpdEvent.Signal.Binary){// toString is used to manage both regular and namespaced tags
event.messageData=BASE64.decodeArray(currentMpdEvent.Signal.Binary.toString());}else{// From Cor.1: 'NOTE: this attribute is an alternative
// to specifying a complete XML element(s) in the Event.
// It is useful when an event leans itself to a compact
// string representation'.
event.messageData=currentMpdEvent.messageData||currentMpdEvent.__text;}events.push(event);}}}return events;}function getEventStreams(inbandStreams,representation){var eventStreams=[];var i=void 0;if(!inbandStreams)return eventStreams;for(i=0;i<inbandStreams.length;i++){var eventStream=new _EventStream2.default();eventStream.timescale=1;eventStream.representation=representation;if(inbandStreams[i].hasOwnProperty(_Constants2.default.SCHEME_ID_URI)){eventStream.schemeIdUri=inbandStreams[i].schemeIdUri;}else{throw new Error('Invalid EventStream. SchemeIdUri has to be set');}if(inbandStreams[i].hasOwnProperty(_DashConstants2.default.TIMESCALE)){eventStream.timescale=inbandStreams[i].timescale;}if(inbandStreams[i].hasOwnProperty(_DashConstants2.default.VALUE)){eventStream.value=inbandStreams[i].value;}eventStreams.push(eventStream);}return eventStreams;}function getEventStreamForAdaptationSet(manifest,adaptation){var inbandStreams=void 0,periodArray=void 0,adaptationArray=void 0;if(manifest&&manifest.Period_asArray&&adaptation&&adaptation.period&&isInteger(adaptation.period.index)){periodArray=manifest.Period_asArray[adaptation.period.index];if(periodArray&&periodArray.AdaptationSet_asArray&&isInteger(adaptation.index)){adaptationArray=periodArray.AdaptationSet_asArray[adaptation.index];if(adaptationArray){inbandStreams=adaptationArray.InbandEventStream_asArray;}}}return getEventStreams(inbandStreams,null);}function getEventStreamForRepresentation(manifest,representation){var inbandStreams=void 0,periodArray=void 0,adaptationArray=void 0,representationArray=void 0;if(manifest&&manifest.Period_asArray&&representation&&representation.adaptation&&representation.adaptation.period&&isInteger(representation.adaptation.period.index)){periodArray=manifest.Period_asArray[representation.adaptation.period.index];if(periodArray&&periodArray.AdaptationSet_asArray&&isInteger(representation.adaptation.index)){adaptationArray=periodArray.AdaptationSet_asArray[representation.adaptation.index];if(adaptationArray&&adaptationArray.Representation_asArray&&isInteger(representation.index)){representationArray=adaptationArray.Representation_asArray[representation.index];if(representationArray){inbandStreams=representationArray.InbandEventStream_asArray;}}}}return getEventStreams(inbandStreams,representation);}function getUTCTimingSources(manifest){var isDynamic=getIsDynamic(manifest);var hasAST=manifest?manifest.hasOwnProperty(_DashConstants2.default.AVAILABILITY_START_TIME):false;var utcTimingsArray=manifest?manifest.UTCTiming_asArray:null;var utcTimingEntries=[];// do not bother synchronizing the clock unless MPD is live,
// or it is static and has availabilityStartTime attribute
if(isDynamic||hasAST){if(utcTimingsArray){// the order is important here - 23009-1 states that the order
// in the manifest "indicates relative preference, first having
// the highest, and the last the lowest priority".
utcTimingsArray.forEach(function(utcTiming){var entry=new _UTCTiming2.default();if(utcTiming.hasOwnProperty(_Constants2.default.SCHEME_ID_URI)){entry.schemeIdUri=utcTiming.schemeIdUri;}else{// entries of type DescriptorType with no schemeIdUri
// are meaningless. let's just ignore this entry and
// move on.
return;}// this is (incorrectly) interpreted as a number - schema
// defines it as a string
if(utcTiming.hasOwnProperty(_DashConstants2.default.VALUE)){entry.value=utcTiming.value.toString();}else{// without a value, there's not a lot we can do with
// this entry. let's just ignore this one and move on
return;}// we're not interested in the optional id or any other
// attributes which might be attached to the entry
utcTimingEntries.push(entry);});}}return utcTimingEntries;}function getBaseURLsFromElement(node){var baseUrls=[];// if node.BaseURL_asArray and node.baseUri are undefined entries
// will be [undefined] which entries.some will just skip
var entries=node.BaseURL_asArray||[node.baseUri];var earlyReturn=false;entries.some(function(entry){if(entry){var baseUrl=new _BaseURL2.default();var text=entry.__text||entry;if(urlUtils.isRelative(text)){// it doesn't really make sense to have relative and
// absolute URLs at the same level, or multiple
// relative URLs at the same level, so assume we are
// done from this level of the MPD
earlyReturn=true;// deal with the specific case where the MPD@BaseURL
// is specified and is relative. when no MPD@BaseURL
// entries exist, that case is handled by the
// [node.baseUri] in the entries definition.
if(node.baseUri){text=urlUtils.resolve(text,node.baseUri);}}baseUrl.url=text;// serviceLocation is optional, but we need it in order
// to blacklist correctly. if it's not available, use
// anything unique since there's no relationship to any
// other BaseURL and, in theory, the url should be
// unique so use this instead.
if(entry.hasOwnProperty(_DashConstants2.default.SERVICE_LOCATION)&&entry.serviceLocation.length){baseUrl.serviceLocation=entry.serviceLocation;}else{baseUrl.serviceLocation=text;}if(entry.hasOwnProperty(_DashConstants2.default.DVB_PRIORITY)){baseUrl.dvb_priority=entry[_DashConstants2.default.DVB_PRIORITY];}if(entry.hasOwnProperty(_DashConstants2.default.DVB_WEIGHT)){baseUrl.dvb_weight=entry[_DashConstants2.default.DVB_WEIGHT];}if(entry.hasOwnProperty(_DashConstants2.default.AVAILABILITY_TIME_OFFSET)){baseUrl.availabilityTimeOffset=entry[_DashConstants2.default.AVAILABILITY_TIME_OFFSET];}if(entry.hasOwnProperty(_DashConstants2.default.AVAILABILITY_TIME_COMPLETE)){baseUrl.availabilityTimeComplete=entry[_DashConstants2.default.AVAILABILITY_TIME_COMPLETE]!=='false';}/* NOTE: byteRange currently unused
                 */baseUrls.push(baseUrl);return earlyReturn;}});return baseUrls;}function getLocation(manifest){if(manifest&&manifest.hasOwnProperty(_Constants2.default.LOCATION)){// for now, do not support multiple Locations -
// just set Location to the first Location.
manifest.Location=manifest.Location_asArray[0];return manifest.Location;}// may well be undefined
return undefined;}function getPatchLocation(manifest){if(manifest&&manifest.hasOwnProperty(_DashConstants2.default.PATCH_LOCATION)){// only include support for single patch location currently
manifest.PatchLocation=manifest.PatchLocation_asArray[0];return manifest.PatchLocation;}// no patch location provided
return undefined;}function getSuggestedPresentationDelay(mpd){return mpd&&mpd.hasOwnProperty(_DashConstants2.default.SUGGESTED_PRESENTATION_DELAY)?mpd.suggestedPresentationDelay:null;}function getAvailabilityStartTime(mpd){return mpd&&mpd.hasOwnProperty(_DashConstants2.default.AVAILABILITY_START_TIME)&&mpd.availabilityStartTime!==null?mpd.availabilityStartTime.getTime():null;}function getServiceDescriptions(manifest){var serviceDescriptions=[];if(manifest&&manifest.hasOwnProperty(_DashConstants2.default.SERVICE_DESCRIPTION)){var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=manifest.ServiceDescription_asArray[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var sd=_step.value;// Convert each of the properties defined in
var id=void 0,schemeIdUri=void 0,latency=void 0,playbackRate=void 0;for(var prop in sd){if(sd.hasOwnProperty(prop)){if(prop===_DashConstants2.default.ID){id=sd[prop];}else if(prop===_DashConstants2.default.SERVICE_DESCRIPTION_SCOPE){schemeIdUri=sd[prop].schemeIdUri;}else if(prop===_DashConstants2.default.SERVICE_DESCRIPTION_LATENCY){latency={target:sd[prop].target,max:sd[prop].max,min:sd[prop].min};}else if(prop===_DashConstants2.default.SERVICE_DESCRIPTION_PLAYBACK_RATE){playbackRate={max:sd[prop].max,min:sd[prop].min};}}}// we have a ServiceDescription for low latency. Add it if it really has parameters defined
if(schemeIdUri===_Constants2.default.SERVICE_DESCRIPTION_LL_SCHEME&&(latency||playbackRate)){serviceDescriptions.push({id:id,schemeIdUri:schemeIdUri,latency:latency,playbackRate:playbackRate});}}}catch(err){_didIteratorError=true;_iteratorError=err;}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return();}}finally{if(_didIteratorError){throw _iteratorError;}}}}return serviceDescriptions;}function getSupplementalPropperties(adaptation){var supplementalProperties={};if(adaptation&&adaptation.hasOwnProperty(_DashConstants2.default.SUPPLEMENTAL_PROPERTY)){var _iteratorNormalCompletion2=true;var _didIteratorError2=false;var _iteratorError2=undefined;try{for(var _iterator2=adaptation.SupplementalProperty_asArray[Symbol.iterator](),_step2;!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=true){var sp=_step2.value;if(sp.hasOwnProperty(_Constants2.default.SCHEME_ID_URI)&&sp.hasOwnProperty(_DashConstants2.default.VALUE)){supplementalProperties[sp[_Constants2.default.SCHEME_ID_URI]]=sp[_DashConstants2.default.VALUE];}}}catch(err){_didIteratorError2=true;_iteratorError2=err;}finally{try{if(!_iteratorNormalCompletion2&&_iterator2.return){_iterator2.return();}}finally{if(_didIteratorError2){throw _iteratorError2;}}}}return supplementalProperties;}function setConfig(config){if(!config)return;if(config.errHandler){errHandler=config.errHandler;}if(config.BASE64){BASE64=config.BASE64;}}instance={getIsTypeOf:getIsTypeOf,getIsTextTrack:getIsTextTrack,getLanguageForAdaptation:getLanguageForAdaptation,getViewpointForAdaptation:getViewpointForAdaptation,getRolesForAdaptation:getRolesForAdaptation,getAccessibilityForAdaptation:getAccessibilityForAdaptation,getAudioChannelConfigurationForAdaptation:getAudioChannelConfigurationForAdaptation,getAudioChannelConfigurationForRepresentation:getAudioChannelConfigurationForRepresentation,getAdaptationForIndex:getAdaptationForIndex,getIndexForAdaptation:getIndexForAdaptation,getAdaptationForId:getAdaptationForId,getAdaptationsForType:getAdaptationsForType,getRealPeriods:getRealPeriods,getRealPeriodForIndex:getRealPeriodForIndex,getCodec:getCodec,getMimeType:getMimeType,getKID:getKID,getLabelsForAdaptation:getLabelsForAdaptation,getContentProtectionData:getContentProtectionData,getIsDynamic:getIsDynamic,getId:getId,hasProfile:hasProfile,getDuration:getDuration,getBandwidth:getBandwidth,getManifestUpdatePeriod:getManifestUpdatePeriod,getPublishTime:getPublishTime,getRepresentationCount:getRepresentationCount,getBitrateListForAdaptation:getBitrateListForAdaptation,getRepresentationFor:getRepresentationFor,getRepresentationsForAdaptation:getRepresentationsForAdaptation,getAdaptationsForPeriod:getAdaptationsForPeriod,getRegularPeriods:getRegularPeriods,getMpd:getMpd,getEventsForPeriod:getEventsForPeriod,getEssentialPropertiesForRepresentation:getEssentialPropertiesForRepresentation,getEventStreamForAdaptationSet:getEventStreamForAdaptationSet,getEventStreamForRepresentation:getEventStreamForRepresentation,getUTCTimingSources:getUTCTimingSources,getBaseURLsFromElement:getBaseURLsFromElement,getRepresentationSortFunction:getRepresentationSortFunction,getLocation:getLocation,getPatchLocation:getPatchLocation,getSuggestedPresentationDelay:getSuggestedPresentationDelay,getAvailabilityStartTime:getAvailabilityStartTime,getServiceDescriptions:getServiceDescriptions,getSupplementalPropperties:getSupplementalPropperties,setConfig:setConfig};setup();return instance;}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */DashManifestModel.__dashjs_factory_name='DashManifestModel';exports.default=_FactoryMaker2.default.getSingletonFactory(DashManifestModel);
//# sourceMappingURL=DashManifestModel.js.map
