'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Constants=require('../../streaming/constants/Constants');var _Constants2=_interopRequireDefault(_Constants);var _SegmentsUtils=require('./SegmentsUtils');function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function TemplateSegmentsGetter(config,isDynamic){config=config||{};var timelineConverter=config.timelineConverter;var instance=void 0;function checkConfig(){if(!timelineConverter||!timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')){throw new Error(_Constants2.default.MISSING_CONFIG_ERROR);}}function getSegmentByIndex(representation,index){checkConfig();if(!representation){return null;}var template=representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate;index=Math.max(index,0);var seg=(0,_SegmentsUtils.getIndexBasedSegment)(timelineConverter,isDynamic,representation,index);if(seg){seg.replacementTime=Math.round((index-1)*representation.segmentDuration*representation.timescale,10);var url=template.media;url=(0,_SegmentsUtils.replaceTokenForTemplate)(url,'Number',seg.replacementNumber);url=(0,_SegmentsUtils.replaceTokenForTemplate)(url,'Time',seg.replacementTime);seg.media=url;}var duration=representation.segmentDuration;var availabilityWindow=representation.segmentAvailabilityRange;if(isNaN(duration)){representation.availableSegmentsNumber=1;}else{representation.availableSegmentsNumber=Math.ceil((availabilityWindow.end-availabilityWindow.start)/duration);}return seg;}function getSegmentByTime(representation,requestedTime){checkConfig();if(!representation){return null;}var duration=representation.segmentDuration;if(isNaN(duration)){return null;}var periodTime=timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation,requestedTime);var index=Math.floor(periodTime/duration);return getSegmentByIndex(representation,index);}instance={getSegmentByIndex:getSegmentByIndex,getSegmentByTime:getSegmentByTime};return instance;}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */TemplateSegmentsGetter.__dashjs_factory_name='TemplateSegmentsGetter';var factory=_FactoryMaker2.default.getClassFactory(TemplateSegmentsGetter);exports.default=factory;
//# sourceMappingURL=TemplateSegmentsGetter.js.map
