'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _Debug=require('../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _DashJSError=require('./vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _EventBus=require('../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _Events=require('../core/events/Events');var _Events2=_interopRequireDefault(_Events);var _FactoryMaker=require('../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _TextController=require('./text/TextController');var _TextController2=_interopRequireDefault(_TextController);var _Errors=require('../core/errors/Errors');var _Errors2=_interopRequireDefault(_Errors);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}var MAX_ALLOWED_DISCONTINUITY=0.1;// 100 milliseconds
/**
 * @class SourceBufferSink
 * @ignore
 * @implements FragmentSink
 *//**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */function SourceBufferSink(mediaSource,mediaInfo,onAppendedCallback,oldBuffer){var context=this.context;var eventBus=(0,_EventBus2.default)(context).getInstance();var instance=void 0,type=void 0,logger=void 0,buffer=void 0,isAppendingInProgress=void 0,intervalId=void 0;var callbacks=[];var appendQueue=[];var onAppended=onAppendedCallback;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);isAppendingInProgress=false;type=mediaInfo.type;var codec=mediaInfo.codec;try{// Safari claims to support anything starting 'application/mp4'.
// it definitely doesn't understand 'application/mp4;codecs="stpp"'
// - currently no browser does, so check for it and use our own
// implementation. The same is true for codecs="wvtt".
if(codec.match(/application\/mp4;\s*codecs="(stpp|wvtt).*"/i)){throw new Error('not really supported');}buffer=oldBuffer?oldBuffer:mediaSource.addSourceBuffer(codec);if(buffer.changeType&&oldBuffer){logger.debug('Doing period transition with changeType');buffer.changeType(codec);}updateAppendWindow();var CHECK_INTERVAL=50;// use updateend event if possible
if(typeof buffer.addEventListener==='function'){try{buffer.addEventListener('updateend',updateEndHandler,false);buffer.addEventListener('error',errHandler,false);buffer.addEventListener('abort',errHandler,false);}catch(err){// use setInterval to periodically check if updating has been completed
intervalId=setInterval(checkIsUpdateEnded,CHECK_INTERVAL);}}else{// use setInterval to periodically check if updating has been completed
intervalId=setInterval(checkIsUpdateEnded,CHECK_INTERVAL);}}catch(ex){// Note that in the following, the quotes are open to allow for extra text after stpp and wvtt
if(mediaInfo.isText||codec.indexOf('codecs="stpp')!==-1||codec.indexOf('codecs="wvtt')!==-1){var textController=(0,_TextController2.default)(context).getInstance();buffer=textController.getTextSourceBuffer();}else{throw ex;}}}function getType(){return type;}function reset(keepBuffer){if(buffer){if(typeof buffer.removeEventListener==='function'){buffer.removeEventListener('updateend',updateEndHandler,false);buffer.removeEventListener('error',errHandler,false);buffer.removeEventListener('abort',errHandler,false);}clearInterval(intervalId);callbacks=[];if(!keepBuffer){try{if(!buffer.getClassName||buffer.getClassName()!=='TextSourceBuffer'){logger.debug('Removing sourcebuffer from media source');mediaSource.removeSourceBuffer(buffer);}}catch(e){logger.error('Failed to remove source buffer from media source.');}buffer=null;}isAppendingInProgress=false;}appendQueue=[];onAppended=null;}function getBuffer(){return buffer;}function getAllBufferRanges(){try{return buffer.buffered;}catch(e){logger.error('getAllBufferRanges exception: '+e.message);return null;}}function hasDiscontinuitiesAfter(time){try{var ranges=getAllBufferRanges();if(ranges&&ranges.length>1){for(var i=0,len=ranges.length;i<len;i++){if(i>0){if(time<ranges.start(i)&&ranges.start(i)>ranges.end(i-1)+MAX_ALLOWED_DISCONTINUITY){return true;}}}}}catch(e){logger.error('hasDiscontinuities exception: '+e.message);}return false;}function append(chunk){if(!chunk){onAppended({chunk:chunk,error:new _DashJSError2.default(_Errors2.default.APPEND_ERROR_CODE,_Errors2.default.APPEND_ERROR_MESSAGE)});return;}appendQueue.push(chunk);if(!isAppendingInProgress){waitForUpdateEnd(appendNextInQueue.bind(this));}}function updateTimestampOffset(MSETimeOffset){if(buffer.timestampOffset!==MSETimeOffset&&!isNaN(MSETimeOffset)){waitForUpdateEnd(function(){if(MSETimeOffset<0){MSETimeOffset+=0.001;}buffer.timestampOffset=MSETimeOffset;});}}function updateAppendWindow(sInfo){if(!buffer){return;}waitForUpdateEnd(function(){try{var appendWindowEnd=mediaSource.duration;var appendWindowStart=0;if(sInfo&&!isNaN(sInfo.start)&&!isNaN(sInfo.duration)&&isFinite(sInfo.duration)){appendWindowEnd=sInfo.start+sInfo.duration;}if(sInfo&&!isNaN(sInfo.start)){appendWindowStart=sInfo.start;}buffer.appendWindowStart=0;buffer.appendWindowEnd=appendWindowEnd;buffer.appendWindowStart=appendWindowStart;logger.debug('Updated append window. Set start to '+buffer.appendWindowStart+' and end to '+buffer.appendWindowEnd);}catch(e){logger.warn('Failed to set append window');}});}function remove(start,end,forceRemoval){var sourceBufferSink=this;// make sure that the given time range is correct. Otherwise we will get InvalidAccessError
waitForUpdateEnd(function(){try{if(start>=0&&end>start&&(forceRemoval||mediaSource.readyState!=='ended')){buffer.remove(start,end);}// updating is in progress, we should wait for it to complete before signaling that this operation is done
waitForUpdateEnd(function(){eventBus.trigger(_Events2.default.SOURCEBUFFER_REMOVE_COMPLETED,{buffer:sourceBufferSink,from:start,to:end,unintended:false});});}catch(err){eventBus.trigger(_Events2.default.SOURCEBUFFER_REMOVE_COMPLETED,{buffer:sourceBufferSink,from:start,to:end,unintended:false,error:new _DashJSError2.default(err.code,err.message)});}});}function appendNextInQueue(){var sourceBufferSink=this;if(appendQueue.length>0){isAppendingInProgress=true;var nextChunk=appendQueue[0];appendQueue.splice(0,1);var oldRanges=[];var afterSuccess=function afterSuccess(){// Safari sometimes drops a portion of a buffer after appending. Handle these situations here
var newRanges=getAllBufferRanges();checkBufferGapsAfterAppend(sourceBufferSink,oldRanges,newRanges,nextChunk);if(appendQueue.length>0){appendNextInQueue.call(this);}else{isAppendingInProgress=false;if(onAppended){onAppended({chunk:nextChunk});}}};try{if(nextChunk.bytes.length===0){afterSuccess.call(this);}else{oldRanges=getAllBufferRanges();if(buffer.appendBuffer){buffer.appendBuffer(nextChunk.bytes);}else{buffer.append(nextChunk.bytes,nextChunk);}// updating is in progress, we should wait for it to complete before signaling that this operation is done
waitForUpdateEnd(afterSuccess.bind(this));}}catch(err){logger.fatal('SourceBuffer append failed "'+err+'"');if(appendQueue.length>0){appendNextInQueue();}else{isAppendingInProgress=false;}if(onAppended){onAppended({chunk:nextChunk,error:new _DashJSError2.default(err.code,err.message)});}}}}function checkBufferGapsAfterAppend(buffer,oldRanges,newRanges,chunk){if(oldRanges&&oldRanges.length>0&&oldRanges.length<newRanges.length&&isChunkAlignedWithRange(oldRanges,chunk)){// A split in the range was created while appending
eventBus.trigger(_Events2.default.SOURCEBUFFER_REMOVE_COMPLETED,{buffer:buffer,from:newRanges.end(newRanges.length-2),to:newRanges.start(newRanges.length-1),unintended:true});}}function isChunkAlignedWithRange(oldRanges,chunk){for(var i=0;i<oldRanges.length;i++){var start=Math.round(oldRanges.start(i));var end=Math.round(oldRanges.end(i));if(end===chunk.start||start===chunk.end||chunk.start>=start&&chunk.end<=end){return true;}}return false;}function abort(){try{if(mediaSource.readyState==='open'){buffer.abort();}else if(buffer.setTextTrack&&mediaSource.readyState==='ended'){buffer.abort();//The cues need to be removed from the TextSourceBuffer via a call to abort()
}}catch(ex){logger.error('SourceBuffer append abort failed: "'+ex+'"');}appendQueue=[];}function executeCallback(){if(callbacks.length>0){var cb=callbacks.shift();if(buffer.updating){waitForUpdateEnd(cb);}else{cb();// Try to execute next callback if still not updating
executeCallback();}}}function checkIsUpdateEnded(){// if updating is still in progress do nothing and wait for the next check again.
if(buffer.updating)return;// updating is completed, now we can stop checking and resolve the promise
executeCallback();}function updateEndHandler(){if(buffer.updating)return;executeCallback();}function errHandler(){logger.error('SourceBufferSink error');}function waitForUpdateEnd(callback){callbacks.push(callback);if(!buffer.updating){executeCallback();}}instance={getType:getType,getAllBufferRanges:getAllBufferRanges,getBuffer:getBuffer,append:append,remove:remove,abort:abort,reset:reset,updateTimestampOffset:updateTimestampOffset,hasDiscontinuitiesAfter:hasDiscontinuitiesAfter,waitForUpdateEnd:waitForUpdateEnd,updateAppendWindow:updateAppendWindow};setup();return instance;}SourceBufferSink.__dashjs_factory_name='SourceBufferSink';var factory=_FactoryMaker2.default.getClassFactory(SourceBufferSink);exports.default=factory;
//# sourceMappingURL=SourceBufferSink.js.map
