'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _Constants=require('./constants/Constants');var _Constants2=_interopRequireDefault(_Constants);var _DashConstants=require('../dash/constants/DashConstants');var _DashConstants2=_interopRequireDefault(_DashConstants);var _MetricsConstants=require('./constants/MetricsConstants');var _MetricsConstants2=_interopRequireDefault(_MetricsConstants);var _FragmentModel=require('./models/FragmentModel');var _FragmentModel2=_interopRequireDefault(_FragmentModel);var _BufferController=require('./controllers/BufferController');var _BufferController2=_interopRequireDefault(_BufferController);var _TextBufferController=require('./text/TextBufferController');var _TextBufferController2=_interopRequireDefault(_TextBufferController);var _ScheduleController=require('./controllers/ScheduleController');var _ScheduleController2=_interopRequireDefault(_ScheduleController);var _RepresentationController=require('../dash/controllers/RepresentationController');var _RepresentationController2=_interopRequireDefault(_RepresentationController);var _LiveEdgeFinder=require('./utils/LiveEdgeFinder');var _LiveEdgeFinder2=_interopRequireDefault(_LiveEdgeFinder);var _FactoryMaker=require('../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _SupervisorTools=require('./utils/SupervisorTools');var _EventBus=require('../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _Events=require('../core/events/Events');var _Events2=_interopRequireDefault(_Events);var _DashHandler=require('../dash/DashHandler');var _DashHandler2=_interopRequireDefault(_DashHandler);var _Errors=require('../core/errors/Errors');var _Errors2=_interopRequireDefault(_Errors);var _DashJSError=require('./vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _Debug=require('../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _RequestModifier=require('./utils/RequestModifier');var _RequestModifier2=_interopRequireDefault(_RequestModifier);var _URLUtils=require('../streaming/utils/URLUtils');var _URLUtils2=_interopRequireDefault(_URLUtils);var _BoxParser=require('./utils/BoxParser');var _BoxParser2=_interopRequireDefault(_BoxParser);var _FragmentRequest=require('./vo/FragmentRequest');var _FragmentRequest2=_interopRequireDefault(_FragmentRequest);var _PlayList=require('./vo/metrics/PlayList');function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */function StreamProcessor(config){config=config||{};var context=this.context;var eventBus=(0,_EventBus2.default)(context).getInstance();var streamInfo=config.streamInfo;var type=config.type;var errHandler=config.errHandler;var mimeType=config.mimeType;var timelineConverter=config.timelineConverter;var adapter=config.adapter;var manifestModel=config.manifestModel;var mediaPlayerModel=config.mediaPlayerModel;var fragmentModel=config.fragmentModel;var abrController=config.abrController;var playbackController=config.playbackController;var mediaController=config.mediaController;var textController=config.textController;var dashMetrics=config.dashMetrics;var settings=config.settings;var boxParser=config.boxParser;var instance=void 0,logger=void 0,isDynamic=void 0,mediaInfo=void 0,mediaInfoArr=void 0,bufferController=void 0,scheduleController=void 0,representationController=void 0,liveEdgeFinder=void 0,indexHandler=void 0,bufferingTime=void 0,bufferPruned=void 0;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);resetInitialSettings();eventBus.on(_Events2.default.DATA_UPDATE_COMPLETED,onDataUpdateCompleted,instance,{priority:_EventBus2.default.EVENT_PRIORITY_HIGH});// High priority to be notified before Stream
eventBus.on(_Events2.default.QUALITY_CHANGE_REQUESTED,onQualityChanged,instance);eventBus.on(_Events2.default.INIT_FRAGMENT_NEEDED,onInitFragmentNeeded,instance);eventBus.on(_Events2.default.MEDIA_FRAGMENT_NEEDED,onMediaFragmentNeeded,instance);eventBus.on(_Events2.default.MEDIA_FRAGMENT_LOADED,onMediaFragmentLoaded,instance);eventBus.on(_Events2.default.BUFFER_LEVEL_UPDATED,onBufferLevelUpdated,instance);eventBus.on(_Events2.default.BUFFER_LEVEL_STATE_CHANGED,onBufferLevelStateChanged,instance);eventBus.on(_Events2.default.BUFFER_CLEARED,onBufferCleared,instance);eventBus.on(_Events2.default.SEEK_TARGET,onSeekTarget,instance);}function initialize(mediaSource,hasVideoTrack){indexHandler=(0,_DashHandler2.default)(context).create({streamInfo:streamInfo,type:type,timelineConverter:timelineConverter,dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,baseURLController:config.baseURLController,errHandler:errHandler,settings:settings,boxParser:boxParser,events:_Events2.default,eventBus:eventBus,errors:_Errors2.default,debug:(0,_Debug2.default)(context).getInstance(),requestModifier:(0,_RequestModifier2.default)(context).getInstance(),dashConstants:_DashConstants2.default,constants:_Constants2.default,urlUtils:(0,_URLUtils2.default)(context).getInstance()});// Create live edge finder for dynamic streams
isDynamic=streamInfo.manifestInfo.isDynamic;if(isDynamic){liveEdgeFinder=(0,_LiveEdgeFinder2.default)(context).create({timelineConverter:timelineConverter});}// Create/initialize controllers
indexHandler.initialize(isDynamic);abrController.registerStreamType(type,instance);representationController=(0,_RepresentationController2.default)(context).create({streamInfo:streamInfo,type:type,abrController:abrController,dashMetrics:dashMetrics,playbackController:playbackController,timelineConverter:timelineConverter,dashConstants:_DashConstants2.default,events:_Events2.default,eventBus:eventBus,errors:_Errors2.default});bufferController=createBufferControllerForType(type);if(bufferController){bufferController.initialize(mediaSource);}scheduleController=(0,_ScheduleController2.default)(context).create({streamInfo:streamInfo,type:type,mimeType:mimeType,adapter:adapter,dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,fragmentModel:fragmentModel,abrController:abrController,playbackController:playbackController,textController:textController,mediaController:mediaController,bufferController:bufferController,settings:settings});scheduleController.initialize(hasVideoTrack);bufferingTime=0;bufferPruned=false;}function getStreamId(){return streamInfo.id;}function getType(){return type;}function resetInitialSettings(){mediaInfoArr=[];mediaInfo=null;bufferingTime=0;}function reset(errored,keepBuffers){if(indexHandler){indexHandler.reset();}if(bufferController){bufferController.reset(errored,keepBuffers);bufferController=null;}if(scheduleController){scheduleController.reset();scheduleController=null;}if(representationController){representationController.reset();representationController=null;}if(liveEdgeFinder){liveEdgeFinder.reset();liveEdgeFinder=null;}if(abrController&&!keepBuffers){abrController.unRegisterStreamType(type);}eventBus.off(_Events2.default.DATA_UPDATE_COMPLETED,onDataUpdateCompleted,instance);eventBus.off(_Events2.default.QUALITY_CHANGE_REQUESTED,onQualityChanged,instance);eventBus.off(_Events2.default.INIT_FRAGMENT_NEEDED,onInitFragmentNeeded,instance);eventBus.off(_Events2.default.MEDIA_FRAGMENT_NEEDED,onMediaFragmentNeeded,instance);eventBus.off(_Events2.default.MEDIA_FRAGMENT_LOADED,onMediaFragmentLoaded,instance);eventBus.off(_Events2.default.BUFFER_LEVEL_UPDATED,onBufferLevelUpdated,instance);eventBus.off(_Events2.default.BUFFER_LEVEL_STATE_CHANGED,onBufferLevelStateChanged,instance);eventBus.off(_Events2.default.BUFFER_CLEARED,onBufferCleared,instance);eventBus.off(_Events2.default.SEEK_TARGET,onSeekTarget,instance);resetInitialSettings();type=null;streamInfo=null;}function isUpdating(){return representationController?representationController.isUpdating():false;}function onDataUpdateCompleted(e){if(!e.error){// Update representation if no error
scheduleController.setCurrentRepresentation(adapter.convertDataToRepresentationInfo(e.currentRepresentation));}if(!e.error||e.error.code===_Errors2.default.SEGMENTS_UPDATE_FAILED_ERROR_CODE){// Update has been postponed, update nevertheless DVR info
var activeStreamId=playbackController.getStreamController().getActiveStreamInfo().id;if(activeStreamId===streamInfo.id){addDVRMetric();}}}function onQualityChanged(e){var representationInfo=getRepresentationInfo(e.newQuality);scheduleController.setCurrentRepresentation(representationInfo);dashMetrics.pushPlayListTraceMetrics(new Date(),_PlayList.PlayListTrace.REPRESENTATION_SWITCH_STOP_REASON);dashMetrics.createPlaylistTraceMetrics(representationInfo.id,playbackController.getTime()*1000,playbackController.getPlaybackRate());}function onBufferLevelUpdated(e){dashMetrics.addBufferLevel(type,new Date(),e.bufferLevel*1000);var activeStreamId=playbackController.getStreamController().getActiveStreamInfo().id;if(!manifestModel.getValue().doNotUpdateDVRWindowOnBufferUpdated&&streamInfo.id===activeStreamId){addDVRMetric();}}function onBufferLevelStateChanged(e){dashMetrics.addBufferState(type,e.state,scheduleController.getBufferTarget());if(e.state===_MetricsConstants2.default.BUFFER_EMPTY&&!playbackController.isSeeking()){// logger.info('Buffer is empty! Stalling!');
dashMetrics.pushPlayListTraceMetrics(new Date(),_PlayList.PlayListTrace.REBUFFERING_REASON);}}function onBufferCleared(e){// Remove executed requests not buffered anymore
fragmentModel.syncExecutedRequestsWithBufferedRange(bufferController.getBuffer().getAllBufferRanges(),streamInfo.duration);// If buffer removed ahead current time (QuotaExceededError or automatic buffer pruning) then adjust current index handler time
if(e.from>playbackController.getTime()){bufferingTime=e.from;bufferPruned=true;}}function addDVRMetric(){var manifestInfo=streamInfo.manifestInfo;var isDynamic=manifestInfo.isDynamic;var range=timelineConverter.calcSegmentAvailabilityRange(representationController.getCurrentRepresentation(),isDynamic);dashMetrics.addDVRInfo(getType(),playbackController.getTime(),manifestInfo,range);}function getRepresentationController(){return representationController;}function getBuffer(){return bufferController?bufferController.getBuffer():null;}function setBuffer(buffer){bufferController.setBuffer(buffer);}function getBufferController(){return bufferController;}function getFragmentModel(){return fragmentModel;}function updateStreamInfo(newStreamInfo){streamInfo=newStreamInfo;if(settings.get().streaming.useAppendWindow){bufferController.updateAppendWindow();}}function getStreamInfo(){return streamInfo;}function selectMediaInfo(newMediaInfo){if(newMediaInfo!==mediaInfo&&(!newMediaInfo||!mediaInfo||newMediaInfo.type===mediaInfo.type)){mediaInfo=newMediaInfo;}var newRealAdaptation=adapter.getRealAdaptation(streamInfo,mediaInfo);var voRepresentations=adapter.getVoRepresentations(mediaInfo);if(representationController){var realAdaptation=representationController.getData();var maxQuality=abrController.getTopQualityIndexFor(type,streamInfo.id);var minIdx=abrController.getMinAllowedIndexFor(type);var quality=void 0,averageThroughput=void 0;var bitrate=null;if((realAdaptation===null||realAdaptation.id!=newRealAdaptation.id)&&type!==_Constants2.default.FRAGMENTED_TEXT){averageThroughput=abrController.getThroughputHistory().getAverageThroughput(type);bitrate=averageThroughput||abrController.getInitialBitrateFor(type);quality=abrController.getQualityForBitrate(mediaInfo,bitrate);}else{quality=abrController.getQualityFor(type);}if(minIdx!==undefined&&quality<minIdx){quality=minIdx;}if(quality>maxQuality){quality=maxQuality;}indexHandler.setMimeType(mediaInfo?mediaInfo.mimeType:null);representationController.updateData(newRealAdaptation,voRepresentations,type,quality);}}function addMediaInfo(newMediaInfo,selectNewMediaInfo){if(mediaInfoArr.indexOf(newMediaInfo)===-1){mediaInfoArr.push(newMediaInfo);}if(selectNewMediaInfo){this.selectMediaInfo(newMediaInfo);}}function getMediaInfoArr(){return mediaInfoArr;}function getMediaInfo(){return mediaInfo;}function getMediaSource(){return bufferController.getMediaSource();}function setMediaSource(mediaSource){bufferController.setMediaSource(mediaSource,getMediaInfoArr());}function dischargePreBuffer(){bufferController.dischargePreBuffer();}function getScheduleController(){return scheduleController;}/**
     * Get a specific voRepresentation. If quality parameter is defined, this function will return the voRepresentation for this quality.
     * Otherwise, this function will return the current voRepresentation used by the representationController.
     * @param {number} quality - quality index of the voRepresentaion expected.
     */function getRepresentationInfo(quality){var voRepresentation=void 0;if(quality!==undefined){(0,_SupervisorTools.checkInteger)(quality);voRepresentation=representationController?representationController.getRepresentationForQuality(quality):null;}else{voRepresentation=representationController?representationController.getCurrentRepresentation():null;}return adapter.convertDataToRepresentationInfo(voRepresentation);}function isBufferingCompleted(){return bufferController?bufferController.getIsBufferingCompleted():false;}function getBufferLevel(){return bufferController?bufferController.getBufferLevel():0;}function onInitFragmentNeeded(e){// Event propagation may have been stopped (see MssHandler)
if(!e.sender)return;if(adapter.getIsTextTrack(mimeType)&&!textController.isTextEnabled())return;if(bufferController&&e.representationId){if(!bufferController.appendInitSegment(e.representationId)){// Init segment not in cache, send new request
var request=indexHandler?indexHandler.getInitRequest(getMediaInfo(),representationController.getCurrentRepresentation()):null;scheduleController.processInitRequest(request);}}}function onMediaFragmentNeeded(e){var request=void 0;// Don't schedule next fragments while pruning to avoid buffer inconsistencies
if(!bufferController.getIsPruningInProgress()){request=findNextRequest(e.seekTarget,e.replacement);if(request){scheduleController.setSeekTarget(NaN);if(!e.replacement){if(!isNaN(request.startTime+request.duration)){bufferingTime=request.startTime+request.duration;}request.delayLoadingTime=new Date().getTime()+scheduleController.getTimeToLoadDelay();scheduleController.setTimeToLoadDelay(0);}}}scheduleController.processMediaRequest(request);}/**
     * Probe the next request. This is used in the CMCD model to get information about the upcoming request. Note: No actual request is performed here.
     * @return {FragmentRequest|null}
     */function probeNextRequest(){var representationInfo=getRepresentationInfo();var representation=representationController&&representationInfo?representationController.getRepresentationForQuality(representationInfo.quality):null;var request=indexHandler.getNextSegmentRequestIdempotent(getMediaInfo(),representation);return request;}function findNextRequest(seekTarget,requestToReplace){var representationInfo=getRepresentationInfo();var hasSeekTarget=!isNaN(seekTarget);var currentTime=playbackController.getNormalizedTime();var time=hasSeekTarget?seekTarget:bufferingTime;var bufferIsDivided=false;var request=void 0;if(isNaN(time)||getType()===_Constants2.default.FRAGMENTED_TEXT&&!textController.isTextEnabled()){return null;}/**
         * This is critical for IE/Safari/EDGE
         * */if(bufferController){var range=bufferController.getRangeAt(time);var playingRange=bufferController.getRangeAt(currentTime);if((range!==null||playingRange!==null)&&!hasSeekTarget){if(!range||playingRange&&playingRange.start!=range.start&&playingRange.end!=range.end){var hasDiscontinuities=bufferController.getBuffer().hasDiscontinuitiesAfter(currentTime);if(hasDiscontinuities&&getType()!==_Constants2.default.FRAGMENTED_TEXT){fragmentModel.removeExecutedRequestsAfterTime(playingRange.end);bufferIsDivided=true;}}}}if(requestToReplace){time=requestToReplace.startTime+requestToReplace.duration/2;request=getFragmentRequest(representationInfo,time,{timeThreshold:0,ignoreIsFinished:true});}else{// Use time just whenever is strictly needed
var useTime=hasSeekTarget||bufferPruned||bufferIsDivided;request=getFragmentRequest(representationInfo,useTime?time:undefined,{keepIdx:!useTime});bufferPruned=false;// Then, check if this request was downloaded or not
while(request&&request.action!==_FragmentRequest2.default.ACTION_COMPLETE&&fragmentModel.isFragmentLoaded(request)){// loop until we found not loaded fragment, or no fragment
request=getFragmentRequest(representationInfo);}}return request;}function onMediaFragmentLoaded(e){var chunk=e.chunk;var bytes=chunk.bytes;var quality=chunk.quality;var currentRepresentation=getRepresentationInfo(quality);var voRepresentation=representationController&&currentRepresentation?representationController.getRepresentationForQuality(currentRepresentation.quality):null;var eventStreamMedia=adapter.getEventsFor(currentRepresentation.mediaInfo);var eventStreamTrack=adapter.getEventsFor(currentRepresentation,voRepresentation);if(eventStreamMedia&&eventStreamMedia.length>0||eventStreamTrack&&eventStreamTrack.length>0){var request=fragmentModel.getRequests({state:_FragmentModel2.default.FRAGMENT_MODEL_EXECUTED,quality:quality,index:chunk.index})[0];var events=handleInbandEvents(bytes,request,eventStreamMedia,eventStreamTrack);eventBus.trigger(_Events2.default.INBAND_EVENTS,{events:events},{streamId:streamInfo.id});}}function handleInbandEvents(data,request,mediaInbandEvents,trackInbandEvents){try{var eventStreams={};var events=[];/* Extract the possible schemeIdUri : If a DASH client detects an event message box with a scheme that is not defined in MPD, the client is expected to ignore it */var inbandEvents=mediaInbandEvents.concat(trackInbandEvents);for(var i=0,ln=inbandEvents.length;i<ln;i++){eventStreams[inbandEvents[i].schemeIdUri+'/'+inbandEvents[i].value]=inbandEvents[i];}var isoFile=(0,_BoxParser2.default)(context).getInstance().parse(data);var eventBoxes=isoFile.getBoxes('emsg');if(!eventBoxes||eventBoxes.length===0){return events;}var sidx=isoFile.getBox('sidx');var mediaAnchorTime=sidx&&!isNaN(sidx.earliest_presentation_time)&&!isNaN(sidx.timescale)?sidx.earliest_presentation_time/sidx.timescale:request&&!isNaN(request.mediaStartTime)?request.mediaStartTime:0;var fragmentMediaStartTime=Math.max(mediaAnchorTime,0);var voRepresentation=representationController.getCurrentRepresentation();for(var _i=0,_ln=eventBoxes.length;_i<_ln;_i++){var event=adapter.getEvent(eventBoxes[_i],eventStreams,fragmentMediaStartTime,voRepresentation);if(event){events.push(event);}}return events;}catch(e){return[];}}function createBuffer(previousBuffers){return getBuffer()||bufferController?bufferController.createBuffer(mediaInfoArr,previousBuffers):null;}function switchTrackAsked(){scheduleController.switchTrackAsked();}function createBufferControllerForType(type){var controller=null;if(!type){errHandler.error(new _DashJSError2.default(_Errors2.default.MEDIASOURCE_TYPE_UNSUPPORTED_CODE,_Errors2.default.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE+'not properly defined'));return null;}if(type===_Constants2.default.VIDEO||type===_Constants2.default.AUDIO){controller=(0,_BufferController2.default)(context).create({streamInfo:streamInfo,type:type,mediaPlayerModel:mediaPlayerModel,manifestModel:manifestModel,fragmentModel:fragmentModel,errHandler:errHandler,mediaController:mediaController,representationController:representationController,adapter:adapter,textController:textController,abrController:abrController,playbackController:playbackController,settings:settings});}else{controller=(0,_TextBufferController2.default)(context).create({streamInfo:streamInfo,type:type,mimeType:mimeType,mediaPlayerModel:mediaPlayerModel,manifestModel:manifestModel,fragmentModel:fragmentModel,errHandler:errHandler,mediaController:mediaController,representationController:representationController,adapter:adapter,textController:textController,abrController:abrController,playbackController:playbackController,settings:settings});}return controller;}function getLiveStartTime(){if(!isDynamic)return NaN;if(!liveEdgeFinder)return NaN;var liveStartTime=NaN;var currentRepresentationInfo=getRepresentationInfo();var liveEdge=liveEdgeFinder.getLiveEdge(currentRepresentationInfo);if(isNaN(liveEdge)){return NaN;}var request=findRequestForLiveEdge(liveEdge,currentRepresentationInfo);if(request){// When low latency mode is selected but browser doesn't support fetch
// start at the beginning of the segment to avoid consuming the whole buffer
if(settings.get().streaming.lowLatencyEnabled){liveStartTime=request.duration<mediaPlayerModel.getLiveDelay()?request.startTime:request.startTime+request.duration-mediaPlayerModel.getLiveDelay();}else{liveStartTime=request.startTime;}}return liveStartTime;}function findRequestForLiveEdge(liveEdge,currentRepresentationInfo){try{var request=null;var liveDelay=playbackController.getLiveDelay();var dvrWindowSize=!isNaN(streamInfo.manifestInfo.DVRWindowSize)?streamInfo.manifestInfo.DVRWindowSize:liveDelay;var dvrWindowSafetyMargin=0.1*dvrWindowSize;var startTime=void 0;// Make sure that we have at least a valid request for the end of the DVR window, otherwise we might try forever
if(!isFinite(dvrWindowSize)||getFragmentRequest(currentRepresentationInfo,liveEdge-dvrWindowSize+dvrWindowSafetyMargin,{ignoreIsFinished:true})){// Try to find a request as close as possible to the targeted live edge
while(!request&&liveDelay<=dvrWindowSize){startTime=liveEdge-liveDelay;request=getFragmentRequest(currentRepresentationInfo,startTime,{ignoreIsFinished:true});if(!request){liveDelay+=1;// Increase by one second for each iteration
}}}if(request){playbackController.setLiveDelay(liveDelay,true);}logger.debug('live edge: '+liveEdge+', live delay: '+liveDelay+', live target: '+startTime);return request;}catch(e){return null;}}function onSeekTarget(e){bufferingTime=e.time;scheduleController.setSeekTarget(e.time);}function setBufferingTime(value){bufferingTime=value;}function resetIndexHandler(){if(indexHandler){indexHandler.resetIndex();}}function getInitRequest(quality){(0,_SupervisorTools.checkInteger)(quality);var representation=representationController?representationController.getRepresentationForQuality(quality):null;return indexHandler?indexHandler.getInitRequest(getMediaInfo(),representation):null;}function getFragmentRequest(representationInfo,time,options){var fragRequest=null;if(indexHandler){var representation=representationController&&representationInfo?representationController.getRepresentationForQuality(representationInfo.quality):null;// if time and options are undefined, it means the next segment is requested
// otherwise, the segment at this specific time is requested.
if(time!==undefined&&options!==undefined){fragRequest=indexHandler.getSegmentRequestForTime(getMediaInfo(),representation,time,options);}else{fragRequest=indexHandler.getNextSegmentRequest(getMediaInfo(),representation);}}return fragRequest;}function finalisePlayList(time,reason){dashMetrics.pushPlayListTraceMetrics(time,reason);}instance={initialize:initialize,getStreamId:getStreamId,getType:getType,isUpdating:isUpdating,getBufferController:getBufferController,getFragmentModel:getFragmentModel,getScheduleController:getScheduleController,getRepresentationController:getRepresentationController,getRepresentationInfo:getRepresentationInfo,getBufferLevel:getBufferLevel,isBufferingCompleted:isBufferingCompleted,createBuffer:createBuffer,updateStreamInfo:updateStreamInfo,getStreamInfo:getStreamInfo,selectMediaInfo:selectMediaInfo,addMediaInfo:addMediaInfo,getLiveStartTime:getLiveStartTime,switchTrackAsked:switchTrackAsked,getMediaInfoArr:getMediaInfoArr,getMediaInfo:getMediaInfo,getMediaSource:getMediaSource,setMediaSource:setMediaSource,dischargePreBuffer:dischargePreBuffer,getBuffer:getBuffer,setBuffer:setBuffer,setBufferingTime:setBufferingTime,resetIndexHandler:resetIndexHandler,getInitRequest:getInitRequest,getFragmentRequest:getFragmentRequest,finalisePlayList:finalisePlayList,probeNextRequest:probeNextRequest,reset:reset};setup();return instance;}StreamProcessor.__dashjs_factory_name='StreamProcessor';exports.default=_FactoryMaker2.default.getClassFactory(StreamProcessor);
//# sourceMappingURL=StreamProcessor.js.map
