'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _Constants=require('../constants/Constants');var _Constants2=_interopRequireDefault(_Constants);var _MetricsConstants=require('../constants/MetricsConstants');var _MetricsConstants2=_interopRequireDefault(_MetricsConstants);var _FragmentModel=require('../models/FragmentModel');var _FragmentModel2=_interopRequireDefault(_FragmentModel);var _SourceBufferSink=require('../SourceBufferSink');var _SourceBufferSink2=_interopRequireDefault(_SourceBufferSink);var _PreBufferSink=require('../PreBufferSink');var _PreBufferSink2=_interopRequireDefault(_PreBufferSink);var _AbrController=require('./AbrController');var _AbrController2=_interopRequireDefault(_AbrController);var _EventBus=require('../../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _Events=require('../../core/events/Events');var _Events2=_interopRequireDefault(_Events);var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _InitCache=require('../utils/InitCache');var _InitCache2=_interopRequireDefault(_InitCache);var _DashJSError=require('../vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _Errors=require('../../core/errors/Errors');var _Errors2=_interopRequireDefault(_Errors);var _HTTPRequest=require('../vo/metrics/HTTPRequest');function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */var BUFFERING_COMPLETED_THRESHOLD=0.1;var BUFFER_END_THRESHOLD=0.5;var BUFFER_RANGE_CALCULATION_THRESHOLD=0.01;var QUOTA_EXCEEDED_ERROR_CODE=22;var BUFFER_CONTROLLER_TYPE='BufferController';function BufferController(config){config=config||{};var context=this.context;var eventBus=(0,_EventBus2.default)(context).getInstance();var errHandler=config.errHandler;var fragmentModel=config.fragmentModel;var representationController=config.representationController;var mediaController=config.mediaController;var adapter=config.adapter;var textController=config.textController;var abrController=config.abrController;var playbackController=config.playbackController;var streamInfo=config.streamInfo;var type=config.type;var settings=config.settings;var instance=void 0,logger=void 0,requiredQuality=void 0,isBufferingCompleted=void 0,bufferLevel=void 0,criticalBufferLevel=void 0,mediaSource=void 0,maxAppendedIndex=void 0,lastIndex=void 0,buffer=void 0,dischargeBuffer=void 0,dischargeFragments=void 0,bufferState=void 0,appendedBytesInfo=void 0,wallclockTicked=void 0,isPruningInProgress=void 0,isQuotaExceeded=void 0,initCache=void 0,seekTarget=void 0,seekClearedBufferingCompleted=void 0,pendingPruningRanges=void 0,replacingBuffer=void 0,mediaChunk=void 0;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);initCache=(0,_InitCache2.default)(context).getInstance();resetInitialSettings();}function getBufferControllerType(){return BUFFER_CONTROLLER_TYPE;}function initialize(Source){setMediaSource(Source);requiredQuality=abrController.getQualityFor(type);eventBus.on(_Events2.default.DATA_UPDATE_COMPLETED,onDataUpdateCompleted,this);eventBus.on(_Events2.default.INIT_FRAGMENT_LOADED,onInitFragmentLoaded,this);eventBus.on(_Events2.default.MEDIA_FRAGMENT_LOADED,onMediaFragmentLoaded,this);eventBus.on(_Events2.default.QUALITY_CHANGE_REQUESTED,onQualityChanged,this);eventBus.on(_Events2.default.STREAM_COMPLETED,onStreamCompleted,this);eventBus.on(_Events2.default.PLAYBACK_PLAYING,onPlaybackPlaying,this);eventBus.on(_Events2.default.PLAYBACK_PROGRESS,onPlaybackProgression,this);eventBus.on(_Events2.default.PLAYBACK_TIME_UPDATED,onPlaybackProgression,this);eventBus.on(_Events2.default.PLAYBACK_RATE_CHANGED,onPlaybackRateChanged,this);eventBus.on(_Events2.default.PLAYBACK_SEEKING,onPlaybackSeeking,this);eventBus.on(_Events2.default.PLAYBACK_SEEKED,onPlaybackSeeked,this);eventBus.on(_Events2.default.PLAYBACK_STALLED,onPlaybackStalled,this);eventBus.on(_Events2.default.WALLCLOCK_TIME_UPDATED,onWallclockTimeUpdated,this);eventBus.on(_Events2.default.CURRENT_TRACK_CHANGED,onCurrentTrackChanged,this,{priority:_EventBus2.default.EVENT_PRIORITY_HIGH});eventBus.on(_Events2.default.SOURCEBUFFER_REMOVE_COMPLETED,onRemoved,this);}function getStreamId(){return streamInfo.id;}function getType(){return type;}function getRepresentationInfo(quality){return adapter.convertDataToRepresentationInfo(representationController.getRepresentationForQuality(quality));}function createBuffer(mediaInfoArr,oldBuffers){if(!initCache||!mediaInfoArr)return null;var mediaInfo=mediaInfoArr[0];if(mediaSource){try{if(oldBuffers&&oldBuffers[type]){buffer=(0,_SourceBufferSink2.default)(context).create(mediaSource,mediaInfo,onAppended.bind(this),oldBuffers[type]);}else{buffer=(0,_SourceBufferSink2.default)(context).create(mediaSource,mediaInfo,onAppended.bind(this),null);}if(settings.get().streaming.useAppendWindow){buffer.updateAppendWindow(streamInfo);}if(typeof buffer.getBuffer().initialize==='function'){buffer.getBuffer().initialize(type,streamInfo,mediaInfoArr,fragmentModel);}}catch(e){logger.fatal('Caught error on create SourceBuffer: '+e);errHandler.error(new _DashJSError2.default(_Errors2.default.MEDIASOURCE_TYPE_UNSUPPORTED_CODE,_Errors2.default.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE+type));}}else{buffer=(0,_PreBufferSink2.default)(context).create(onAppended.bind(this));}updateBufferTimestampOffset(getRepresentationInfo(requiredQuality));return buffer;}function dischargePreBuffer(){if(buffer&&dischargeBuffer&&typeof dischargeBuffer.discharge==='function'){var ranges=dischargeBuffer.getAllBufferRanges();if(ranges.length>0){var rangeStr='Beginning '+type+'PreBuffer discharge, adding buffer for:';for(var i=0;i<ranges.length;i++){rangeStr+=' start: '+ranges.start(i)+', end: '+ranges.end(i)+';';}logger.debug(rangeStr);}else{logger.debug('PreBuffer discharge requested, but there were no media segments in the PreBuffer.');}//A list of fragments to supress bytesAppended events for. This makes transferring from a prebuffer to a sourcebuffer silent.
dischargeFragments=[];var chunks=dischargeBuffer.discharge();var lastInit=null;for(var j=0;j<chunks.length;j++){var chunk=chunks[j];if(chunk.segmentType!=='InitializationSegment'){var initChunk=initCache.extract(chunk.streamId,chunk.representationId);if(initChunk){if(lastInit!==initChunk){dischargeFragments.push(initChunk);buffer.append(initChunk);lastInit=initChunk;}}}dischargeFragments.push(chunk);buffer.append(chunk);}dischargeBuffer.reset();dischargeBuffer=null;}}function onInitFragmentLoaded(e){logger.info('Init fragment finished loading saving to',type+'\'s init cache');initCache.save(e.chunk);logger.debug('Append Init fragment',type,' with representationId:',e.chunk.representationId,' and quality:',e.chunk.quality,', data size:',e.chunk.bytes.byteLength);appendToBuffer(e.chunk);}function appendInitSegment(representationId){// Get init segment from cache
var chunk=initCache.extract(streamInfo.id,representationId);if(!chunk){// Init segment not in cache, shall be requested
return false;}// Append init segment into buffer
logger.info('Append Init fragment',type,' with representationId:',chunk.representationId,' and quality:',chunk.quality,', data size:',chunk.bytes.byteLength);appendToBuffer(chunk);return true;}function onMediaFragmentLoaded(e){var chunk=e.chunk;if(replacingBuffer){mediaChunk=chunk;var ranges=buffer&&buffer.getAllBufferRanges();if(ranges&&ranges.length>0&&playbackController.getTimeToStreamEnd()>settings.get().streaming.stallThreshold){logger.debug('Clearing buffer because track changed - '+(ranges.end(ranges.length-1)+BUFFER_END_THRESHOLD));clearBuffers([{start:0,end:ranges.end(ranges.length-1)+BUFFER_END_THRESHOLD,force:true// Force buffer removal even when buffering is completed and MediaSource is ended
}]);}}else{appendToBuffer(chunk);}}function appendToBuffer(chunk){buffer.append(chunk);if(chunk.mediaInfo.type===_Constants2.default.VIDEO){triggerEvent(_Events2.default.VIDEO_CHUNK_RECEIVED,{chunk:chunk});}}function showBufferRanges(ranges){if(ranges&&ranges.length>0){for(var i=0,len=ranges.length;i<len;i++){logger.debug('Buffered range: '+ranges.start(i)+' - '+ranges.end(i)+', currentTime = ',playbackController.getTime());}}}function onAppended(e){if(e.error){if(e.error.code===QUOTA_EXCEEDED_ERROR_CODE){isQuotaExceeded=true;criticalBufferLevel=getTotalBufferedTime()*0.8;logger.warn('Quota exceeded, Critical Buffer: '+criticalBufferLevel);if(criticalBufferLevel>0){// recalculate buffer lengths according to criticalBufferLevel
var bufferToKeep=Math.max(0.2*criticalBufferLevel,1);var bufferAhead=criticalBufferLevel-bufferToKeep;var bufferTimeAtTopQuality=Math.min(settings.get().streaming.bufferTimeAtTopQuality,bufferAhead*0.9);var bufferTimeAtTopQualityLongForm=Math.min(settings.get().streaming.bufferTimeAtTopQualityLongForm,bufferAhead*0.9);var s={streaming:{bufferToKeep:parseFloat(bufferToKeep.toFixed(5)),bufferTimeAtTopQuality:parseFloat(bufferTimeAtTopQuality.toFixed(5)),bufferTimeAtTopQualityLongForm:parseFloat(bufferTimeAtTopQualityLongForm.toFixed(5))}};settings.update(s);}}if(e.error.code===QUOTA_EXCEEDED_ERROR_CODE||!hasEnoughSpaceToAppend()){logger.warn('Clearing playback buffer to overcome quota exceed situation');// Notify Schedulecontroller to stop scheduling until buffer has been pruned
triggerEvent(_Events2.default.QUOTA_EXCEEDED,{criticalBufferLevel:criticalBufferLevel});clearBuffers(getClearRanges());}return;}isQuotaExceeded=false;appendedBytesInfo=e.chunk;if(appendedBytesInfo&&!isNaN(appendedBytesInfo.index)){maxAppendedIndex=Math.max(appendedBytesInfo.index,maxAppendedIndex);checkIfBufferingCompleted();}var ranges=buffer.getAllBufferRanges();if(appendedBytesInfo.segmentType===_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE){showBufferRanges(ranges);onPlaybackProgression();adjustSeekTarget();}else if(replacingBuffer){// When replacing buffer due to switch track, and once new initialization segment has been appended
// (and previous buffered data removed) then seek stream to current time
var currentTime=playbackController.getTime();logger.debug('AppendToBuffer seek target should be '+currentTime);triggerEvent(_Events2.default.SEEK_TARGET,{time:currentTime});}var suppressAppendedEvent=false;if(dischargeFragments){if(dischargeFragments.indexOf(appendedBytesInfo)>0){suppressAppendedEvent=true;}dischargeFragments=null;}if(appendedBytesInfo&&!suppressAppendedEvent){triggerEvent(appendedBytesInfo.endFragment?_Events2.default.BYTES_APPENDED_END_FRAGMENT:_Events2.default.BYTES_APPENDED,{quality:appendedBytesInfo.quality,startTime:appendedBytesInfo.start,index:appendedBytesInfo.index,bufferedRanges:ranges,mediaType:type});}}function adjustSeekTarget(){// Check buffered data only for audio and video
if(type!==_Constants2.default.AUDIO&&type!==_Constants2.default.VIDEO)return;if(isNaN(seekTarget))return;// Check if current buffered range already contains seek target (and current video element time)
var currentTime=playbackController.getTime();var range=getRangeAt(seekTarget,0);if(currentTime===seekTarget&&range)return;// Get buffered range corresponding to the seek target
var segmentDuration=representationController.getCurrentRepresentation().segmentDuration;range=getRangeAt(seekTarget,segmentDuration);if(!range)return;if(Math.abs(currentTime-seekTarget)>segmentDuration){// If current video model time is decorrelated from seek target (and appended buffer) then seek video element
// (in case of live streams on some browsers/devices for which we can't set video element time at unavalaible range)
// Check if appended segment is not anterior from seek target (segments timeline/template tolerance)
if(seekTarget<=range.end){// Seek video element to seek target or range start if appended buffer starts after seek target (segments timeline/template tolerance)
playbackController.seek(Math.max(seekTarget,range.start),false,true);seekTarget=NaN;}}else if(currentTime<range.start){// If appended buffer starts after seek target (segments timeline/template tolerance) then seek to range start
playbackController.seek(range.start,false,true);seekTarget=NaN;}}function onQualityChanged(e){if(requiredQuality===e.newQuality)return;updateBufferTimestampOffset(this.getRepresentationInfo(e.newQuality));requiredQuality=e.newQuality;}//**********************************************************************
// START Buffer Level, State & Sufficiency Handling.
//**********************************************************************
function onPlaybackSeeking(e){seekTarget=e.seekTime;if(isBufferingCompleted){seekClearedBufferingCompleted=true;isBufferingCompleted=false;//a seek command has occured, reset lastIndex value, it will be set next time that onStreamCompleted will be called.
lastIndex=Number.POSITIVE_INFINITY;}if(type!==_Constants2.default.FRAGMENTED_TEXT){// remove buffer after seeking operations
pruneAllSafely();}else{onPlaybackProgression();}}function onPlaybackSeeked(){seekTarget=NaN;}// Prune full buffer but what is around current time position
function pruneAllSafely(){buffer.waitForUpdateEnd(function(){var ranges=getAllRangesWithSafetyFactor();if(!ranges||ranges.length===0){onPlaybackProgression();}clearBuffers(ranges);});}// Get all buffer ranges but a range around current time position
function getAllRangesWithSafetyFactor(){var clearRanges=[];var ranges=buffer.getAllBufferRanges();if(!ranges||ranges.length===0){return clearRanges;}var currentTime=playbackController.getTime();var endOfBuffer=ranges.end(ranges.length-1)+BUFFER_END_THRESHOLD;var currentTimeRequest=fragmentModel.getRequests({state:_FragmentModel2.default.FRAGMENT_MODEL_EXECUTED,time:currentTime,threshold:BUFFER_RANGE_CALCULATION_THRESHOLD})[0];// There is no request in current time position yet. Let's remove everything
if(!currentTimeRequest){logger.debug('getAllRangesWithSafetyFactor - No request found in current time position, removing full buffer 0 -',endOfBuffer);clearRanges.push({start:0,end:endOfBuffer});}else{// Build buffer behind range. To avoid pruning time around current time position,
// we include fragment right behind the one in current time position
var behindRange={start:0,end:currentTimeRequest.startTime-settings.get().streaming.stallThreshold};var prevReq=fragmentModel.getRequests({state:_FragmentModel2.default.FRAGMENT_MODEL_EXECUTED,time:currentTimeRequest.startTime-currentTimeRequest.duration/2,threshold:BUFFER_RANGE_CALCULATION_THRESHOLD})[0];if(prevReq&&prevReq.startTime!=currentTimeRequest.startTime){behindRange.end=prevReq.startTime;}if(behindRange.start<behindRange.end&&behindRange.end>ranges.start(0)){clearRanges.push(behindRange);}// Build buffer ahead range. To avoid pruning time around current time position,
// we include fragment right after the one in current time position
var aheadRange={start:currentTimeRequest.startTime+currentTimeRequest.duration+settings.get().streaming.stallThreshold,end:endOfBuffer};var nextReq=fragmentModel.getRequests({state:_FragmentModel2.default.FRAGMENT_MODEL_EXECUTED,time:currentTimeRequest.startTime+currentTimeRequest.duration+settings.get().streaming.stallThreshold,threshold:BUFFER_RANGE_CALCULATION_THRESHOLD})[0];if(nextReq&&nextReq.startTime!==currentTimeRequest.startTime){aheadRange.start=nextReq.startTime+nextReq.duration+settings.get().streaming.stallThreshold;}if(aheadRange.start<aheadRange.end&&aheadRange.start<endOfBuffer){clearRanges.push(aheadRange);}}return clearRanges;}function getWorkingTime(){return isNaN(seekTarget)?playbackController.getTime():seekTarget;}function onPlaybackProgression(){if(!replacingBuffer||type===_Constants2.default.FRAGMENTED_TEXT&&textController.isTextEnabled()){updateBufferLevel();}}function onPlaybackStalled(){checkIfSufficientBuffer();}function onPlaybackPlaying(){seekTarget=NaN;checkIfSufficientBuffer();}function getRangeAt(time,tolerance){var ranges=buffer.getAllBufferRanges();var start=0;var end=0;var firstStart=null;var lastEnd=null;var gap=0;var len=void 0,i=void 0;var toler=!isNaN(tolerance)?tolerance:0.15;if(ranges!==null&&ranges!==undefined){for(i=0,len=ranges.length;i<len;i++){start=ranges.start(i);end=ranges.end(i);if(firstStart===null){gap=Math.abs(start-time);if(time>=start&&time<end){// start the range
firstStart=start;lastEnd=end;}else if(gap<=toler){// start the range even though the buffer does not contain time 0
firstStart=start;lastEnd=end;}}else{gap=start-lastEnd;if(gap<=toler){// the discontinuity is smaller than the tolerance, combine the ranges
lastEnd=end;}else{break;}}}if(firstStart!==null){return{start:firstStart,end:lastEnd};}}return null;}function getBufferLength(time,tolerance){var range=void 0,length=void 0;// Consider gap/discontinuity limit as tolerance
if(settings.get().streaming.jumpGaps){tolerance=settings.get().streaming.smallGapLimit;}range=getRangeAt(time,tolerance);if(range===null){length=0;}else{length=range.end-time;}return length;}function updateBufferLevel(){if(playbackController){bufferLevel=getBufferLength(getWorkingTime()||0);triggerEvent(_Events2.default.BUFFER_LEVEL_UPDATED,{bufferLevel:bufferLevel});checkIfSufficientBuffer();}}function checkIfBufferingCompleted(){var isLastIdxAppended=maxAppendedIndex>=lastIndex-1;// Handles 0 and non 0 based request index
if(isLastIdxAppended&&!isBufferingCompleted&&buffer.discharge===undefined){isBufferingCompleted=true;logger.debug('checkIfBufferingCompleted trigger BUFFERING_COMPLETED for '+type);triggerEvent(_Events2.default.BUFFERING_COMPLETED);}}function checkIfSufficientBuffer(){// No need to check buffer if type is not audio or video (for example if several errors occur during text parsing, so that the buffer cannot be filled, no error must occur on video playback)
if(type!==_Constants2.default.AUDIO&&type!==_Constants2.default.VIDEO)return;if(seekClearedBufferingCompleted&&!isBufferingCompleted&&bufferLevel>0&&playbackController&&playbackController.getTimeToStreamEnd()-bufferLevel<BUFFERING_COMPLETED_THRESHOLD){seekClearedBufferingCompleted=false;isBufferingCompleted=true;logger.debug('checkIfSufficientBuffer trigger BUFFERING_COMPLETED for type '+type);triggerEvent(_Events2.default.BUFFERING_COMPLETED);}// When the player is working in low latency mode, the buffer is often below settings.get().streaming.stallThreshold.
// So, when in low latency mode, change dash.js behavior so it notifies a stall just when
// buffer reach 0 seconds
if((!settings.get().streaming.lowLatencyEnabled&&bufferLevel<settings.get().streaming.stallThreshold||bufferLevel===0)&&!isBufferingCompleted){notifyBufferStateChanged(_MetricsConstants2.default.BUFFER_EMPTY);}else{if(isBufferingCompleted||bufferLevel>=streamInfo.manifestInfo.minBufferTime){notifyBufferStateChanged(_MetricsConstants2.default.BUFFER_LOADED);}}}function notifyBufferStateChanged(state){if(bufferState===state||state===_MetricsConstants2.default.BUFFER_EMPTY&&playbackController.getTime()===0||// Don't trigger BUFFER_EMPTY if it's initial loading
type===_Constants2.default.FRAGMENTED_TEXT&&!textController.isTextEnabled()){return;}bufferState=state;triggerEvent(_Events2.default.BUFFER_LEVEL_STATE_CHANGED,{state:state});triggerEvent(state===_MetricsConstants2.default.BUFFER_LOADED?_Events2.default.BUFFER_LOADED:_Events2.default.BUFFER_EMPTY);logger.debug(state===_MetricsConstants2.default.BUFFER_LOADED?'Got enough buffer to start':'Waiting for more buffer before starting playback');}/* prune buffer on our own in background to avoid browsers pruning buffer silently */function pruneBuffer(){if(!buffer||type===_Constants2.default.FRAGMENTED_TEXT){return;}if(!isBufferingCompleted){clearBuffers(getClearRanges());}}function getClearRanges(){var clearRanges=[];var ranges=buffer.getAllBufferRanges();if(!ranges||ranges.length===0){return clearRanges;}var currentTime=playbackController.getTime();var startRangeToKeep=Math.max(0,currentTime-settings.get().streaming.bufferToKeep);var currentTimeRequest=fragmentModel.getRequests({state:_FragmentModel2.default.FRAGMENT_MODEL_EXECUTED,time:currentTime,threshold:BUFFER_RANGE_CALCULATION_THRESHOLD})[0];// Ensure we keep full range of current fragment
if(currentTimeRequest){startRangeToKeep=Math.min(currentTimeRequest.startTime,startRangeToKeep);}else if(currentTime===0&&playbackController.getIsDynamic()){// Don't prune before the live stream starts, it messes with low latency
return[];}if(ranges.start(0)<=startRangeToKeep){var behindRange={start:0,end:startRangeToKeep};for(var i=0;i<ranges.length&&ranges.end(i)<=startRangeToKeep;i++){behindRange.end=ranges.end(i);}if(behindRange.start<behindRange.end){clearRanges.push(behindRange);}}return clearRanges;}function clearBuffers(ranges){if(!ranges||!buffer||ranges.length===0)return;pendingPruningRanges.push.apply(pendingPruningRanges,ranges);if(isPruningInProgress){return;}clearNextRange();}function clearNextRange(){// If there's nothing to prune reset state
if(pendingPruningRanges.length===0||!buffer){logger.debug('Nothing to prune, halt pruning');pendingPruningRanges=[];isPruningInProgress=false;return;}var sourceBuffer=buffer.getBuffer();// If there's nothing buffered any pruning is invalid, so reset our state
if(!sourceBuffer||!sourceBuffer.buffered||sourceBuffer.buffered.length===0){logger.debug('SourceBuffer is empty (or does not exist), halt pruning');pendingPruningRanges=[];isPruningInProgress=false;return;}var range=pendingPruningRanges.shift();logger.debug('Removing buffer from:',range.start,'to',range.end);isPruningInProgress=true;// If removing buffer ahead current playback position, update maxAppendedIndex
var currentTime=playbackController.getTime();if(currentTime<range.end){isBufferingCompleted=false;maxAppendedIndex=0;}buffer.remove(range.start,range.end,range.force);}function onRemoved(e){if(buffer!==e.buffer)return;logger.debug('onRemoved buffer from:',e.from,'to',e.to);var ranges=buffer.getAllBufferRanges();showBufferRanges(ranges);if(pendingPruningRanges.length===0){isPruningInProgress=false;}if(e.unintended){logger.warn('Detected unintended removal from:',e.from,'to',e.to,'setting index handler time to',e.from);triggerEvent(_Events2.default.SEEK_TARGET,{time:e.from,mediaType:type,streamId:streamInfo.id});}if(isPruningInProgress){clearNextRange();}else{if(!replacingBuffer){updateBufferLevel();}else{replacingBuffer=false;if(mediaChunk){appendToBuffer(mediaChunk);}}triggerEvent(_Events2.default.BUFFER_CLEARED,{from:e.from,to:e.to,unintended:e.unintended,hasEnoughSpaceToAppend:hasEnoughSpaceToAppend(),quotaExceeded:isQuotaExceeded});}}function updateBufferTimestampOffset(representationInfo){if(!representationInfo||representationInfo.MSETimeOffset===undefined)return;// Each track can have its own @presentationTimeOffset, so we should set the offset
// if it has changed after switching the quality or updating an mpd
if(buffer&&buffer.updateTimestampOffset){buffer.updateTimestampOffset(representationInfo.MSETimeOffset);}}function updateAppendWindow(){if(buffer&&!isBufferingCompleted){buffer.updateAppendWindow(streamInfo);}}function onDataUpdateCompleted(e){if(e.error||isBufferingCompleted)return;updateBufferTimestampOffset(e.currentRepresentation);}function onStreamCompleted(e){lastIndex=e.request.index;checkIfBufferingCompleted();}function onCurrentTrackChanged(e){if(e.newMediaInfo.streamInfo.id!==streamInfo.id||e.newMediaInfo.type!==type)return;var ranges=buffer&&buffer.getAllBufferRanges();if(!ranges)return;logger.info('Track change asked');if(mediaController.getSwitchMode(type)===_Constants2.default.TRACK_SWITCH_MODE_ALWAYS_REPLACE){if(ranges&&ranges.length>0&&playbackController.getTimeToStreamEnd()>settings.get().streaming.stallThreshold){isBufferingCompleted=false;lastIndex=Number.POSITIVE_INFINITY;}}}function onWallclockTimeUpdated(){wallclockTicked++;var secondsElapsed=wallclockTicked*(settings.get().streaming.wallclockTimeUpdateInterval/1000);if(secondsElapsed>=settings.get().streaming.bufferPruningInterval){wallclockTicked=0;pruneBuffer();}}function onPlaybackRateChanged(){checkIfSufficientBuffer();}function getBuffer(){return buffer;}function setBuffer(newBuffer){buffer=newBuffer;}function getBufferLevel(){return bufferLevel;}function setMediaSource(value,mediaInfo){mediaSource=value;if(buffer&&mediaInfo){//if we have a prebuffer, we should prepare to discharge it, and make a new sourceBuffer ready
if(typeof buffer.discharge==='function'){dischargeBuffer=buffer;createBuffer(mediaInfo);}}}function getMediaSource(){return mediaSource;}function replaceBuffer(){replacingBuffer=true;}function getIsBufferingCompleted(){return isBufferingCompleted;}function getIsPruningInProgress(){return isPruningInProgress;}function getTotalBufferedTime(){var ranges=buffer.getAllBufferRanges();var totalBufferedTime=0;var ln=void 0,i=void 0;if(!ranges)return totalBufferedTime;for(i=0,ln=ranges.length;i<ln;i++){totalBufferedTime+=ranges.end(i)-ranges.start(i);}return totalBufferedTime;}function hasEnoughSpaceToAppend(){var totalBufferedTime=getTotalBufferedTime();return totalBufferedTime<criticalBufferLevel;}function triggerEvent(eventType,data){var payload=data||{};eventBus.trigger(eventType,payload,{streamId:streamInfo.id,mediaType:type});}function resetInitialSettings(errored,keepBuffers){criticalBufferLevel=Number.POSITIVE_INFINITY;bufferState=undefined;requiredQuality=_AbrController2.default.QUALITY_DEFAULT;lastIndex=Number.POSITIVE_INFINITY;maxAppendedIndex=0;appendedBytesInfo=null;isBufferingCompleted=false;isPruningInProgress=false;isQuotaExceeded=false;seekClearedBufferingCompleted=false;bufferLevel=0;wallclockTicked=0;pendingPruningRanges=[];seekTarget=NaN;if(buffer){if(!errored){buffer.abort();}buffer.reset(keepBuffers);buffer=null;}replacingBuffer=false;}function reset(errored,keepBuffers){eventBus.off(_Events2.default.DATA_UPDATE_COMPLETED,onDataUpdateCompleted,this);eventBus.off(_Events2.default.INIT_FRAGMENT_LOADED,onInitFragmentLoaded,this);eventBus.off(_Events2.default.MEDIA_FRAGMENT_LOADED,onMediaFragmentLoaded,this);eventBus.off(_Events2.default.QUALITY_CHANGE_REQUESTED,onQualityChanged,this);eventBus.off(_Events2.default.STREAM_COMPLETED,onStreamCompleted,this);eventBus.off(_Events2.default.PLAYBACK_PLAYING,onPlaybackPlaying,this);eventBus.off(_Events2.default.PLAYBACK_PROGRESS,onPlaybackProgression,this);eventBus.off(_Events2.default.PLAYBACK_TIME_UPDATED,onPlaybackProgression,this);eventBus.off(_Events2.default.PLAYBACK_RATE_CHANGED,onPlaybackRateChanged,this);eventBus.off(_Events2.default.PLAYBACK_SEEKING,onPlaybackSeeking,this);eventBus.off(_Events2.default.PLAYBACK_SEEKED,onPlaybackSeeked,this);eventBus.off(_Events2.default.PLAYBACK_STALLED,onPlaybackStalled,this);eventBus.off(_Events2.default.WALLCLOCK_TIME_UPDATED,onWallclockTimeUpdated,this);eventBus.off(_Events2.default.CURRENT_TRACK_CHANGED,onCurrentTrackChanged,this);eventBus.off(_Events2.default.SOURCEBUFFER_REMOVE_COMPLETED,onRemoved,this);resetInitialSettings(errored,keepBuffers);}instance={initialize:initialize,getStreamId:getStreamId,getType:getType,getBufferControllerType:getBufferControllerType,getRepresentationInfo:getRepresentationInfo,createBuffer:createBuffer,dischargePreBuffer:dischargePreBuffer,getBuffer:getBuffer,setBuffer:setBuffer,getBufferLevel:getBufferLevel,getRangeAt:getRangeAt,setMediaSource:setMediaSource,getMediaSource:getMediaSource,appendInitSegment:appendInitSegment,replaceBuffer:replaceBuffer,getIsBufferingCompleted:getIsBufferingCompleted,getIsPruningInProgress:getIsPruningInProgress,reset:reset,updateAppendWindow:updateAppendWindow};setup();return instance;}BufferController.__dashjs_factory_name=BUFFER_CONTROLLER_TYPE;exports.default=_FactoryMaker2.default.getClassFactory(BufferController);
//# sourceMappingURL=BufferController.js.map
