'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _DashJSError=require('./../vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _HTTPRequest=require('../vo/metrics/HTTPRequest');var _EventBus=require('./../../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _Events=require('./../../core/events/Events');var _Events2=_interopRequireDefault(_Events);var _Errors=require('./../../core/errors/Errors');var _Errors2=_interopRequireDefault(_Errors);var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _URLUtils=require('../utils/URLUtils');var _URLUtils2=_interopRequireDefault(_URLUtils);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */var HTTP_TIMEOUT_MS=5000;var DEFAULT_MAXIMUM_ALLOWED_DRIFT=100;var DEFAULT_TIME_BETWEEN_SYNC_ATTEMPTS_ADJUSTMENT_FACTOR=2;var DEFAULT_BACKGROUND_ATTEMPTS=2;var DEFAULT_TIME_BETWEEN_SYNC_ATTEMPTS=30;var DEFAULT_MINIMUM_TIME_BETWEEN_BACKGROUND_SYNC_ATTEMPTS=30;var DEFAULT_MAXIMUM_TIME_BETWEEN_SYNC=600;var DEFAULT_MINIMUM_TIME_BETWEEN_SYNC=2;function TimeSyncController(){var context=this.context;var eventBus=(0,_EventBus2.default)(context).getInstance();var urlUtils=(0,_URLUtils2.default)(context).getInstance();var instance=void 0,logger=void 0,isSynchronizing=void 0,isBackgroundSynchronizing=void 0,settings=void 0,handlers=void 0,dashMetrics=void 0,backgroundSyncTimeOffsets=void 0,timingSources=void 0,timeOfLastSync=void 0,timeOfLastBackgroundSync=void 0,lastOffset=void 0,lastTimingSource=void 0,internalTimeBetweenSyncAttempts=void 0,baseURLController=void 0;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);eventBus.on(_Events2.default.ATTEMPT_BACKGROUND_SYNC,_onAttemptBackgroundSync,instance);}function setConfig(config){if(!config)return;if(config.dashMetrics){dashMetrics=config.dashMetrics;}if(config.baseURLController){baseURLController=config.baseURLController;}if(config.settings){settings=config.settings;}}function _resetInitialSettings(){backgroundSyncTimeOffsets=[];timingSources=[];timeOfLastSync=null;timeOfLastBackgroundSync=null;lastTimingSource=null;lastOffset=NaN;isSynchronizing=false;isBackgroundSynchronizing=false;internalTimeBetweenSyncAttempts=settings.get().streaming.utcSynchronization.timeBetweenSyncAttempts;}/**
     * Register the timing handler depending on the schemeIdUris. This method is called once when the StreamController is initialized
     */function initialize(){_resetInitialSettings();// a list of known schemeIdUris and a method to call with @value
handlers={'urn:mpeg:dash:utc:http-head:2014':_httpHeadHandler,'urn:mpeg:dash:utc:http-xsdate:2014':_httpHandler.bind(null,_xsdatetimeDecoder),'urn:mpeg:dash:utc:http-iso:2014':_httpHandler.bind(null,_iso8601Decoder),'urn:mpeg:dash:utc:direct:2014':_directHandler,// some specs referencing early ISO23009-1 drafts incorrectly use
// 2012 in the URI, rather than 2014. support these for now.
'urn:mpeg:dash:utc:http-head:2012':_httpHeadHandler,'urn:mpeg:dash:utc:http-xsdate:2012':_httpHandler.bind(null,_xsdatetimeDecoder),'urn:mpeg:dash:utc:http-iso:2012':_httpHandler.bind(null,_iso8601Decoder),'urn:mpeg:dash:utc:direct:2012':_directHandler,// it isn't clear how the data returned would be formatted, and
// no public examples available so http-ntp not supported for now.
// presumably you would do an arraybuffer type xhr and decode the
// binary data returned but I would want to see a sample first.
'urn:mpeg:dash:utc:http-ntp:2014':_notSupportedHandler,// not clear how this would be supported in javascript (in browser)
'urn:mpeg:dash:utc:ntp:2014':_notSupportedHandler,'urn:mpeg:dash:utc:sntp:2014':_notSupportedHandler};}/**
     * Sync against a timing source. T
     * @param {array} tSources
     */function attemptSync(tSources){timingSources=tSources;// Stop if we are already synchronizing
if(isSynchronizing){return;}// No synchronization required we can signal the completion immediately
if(!_shouldPerformSynchronization()){eventBus.trigger(_Events2.default.TIME_SYNCHRONIZATION_COMPLETED);return;}isSynchronizing=true;_attemptRecursiveSync();}/**
     * Does a synchronization in the background in case the last offset should be verified or a 404 occurs
     */function _onAttemptBackgroundSync(){if(isSynchronizing||isBackgroundSynchronizing||!lastTimingSource||!lastTimingSource.value||!lastTimingSource.schemeIdUri||isNaN(lastOffset)||isNaN(settings.get().streaming.utcSynchronization.backgroundAttempts)){return;}if(timeOfLastBackgroundSync&&(Date.now()-timeOfLastBackgroundSync)/1000<DEFAULT_MINIMUM_TIME_BETWEEN_BACKGROUND_SYNC_ATTEMPTS){return;}backgroundSyncTimeOffsets=[];isBackgroundSynchronizing=true;var backgroundAttempts=!isNaN(settings.get().streaming.utcSynchronization.backgroundAttempts)?settings.get().streaming.utcSynchronization.backgroundAttempts:DEFAULT_BACKGROUND_ATTEMPTS;_attemptBackgroundSync(backgroundAttempts);}/**
     * Perform a defined number of background attempts
     * @param {number} attempts
     * @private
     */function _attemptBackgroundSync(attempts){try{if(attempts<=0){_completeBackgroundTimeSyncSequence();return;}var deviceTimeBeforeSync=Date.now();handlers[lastTimingSource.schemeIdUri](lastTimingSource.value,function(serverTime){// the timing source returned something useful
var deviceTimeAfterSync=Date.now();var offset=_calculateOffset(deviceTimeBeforeSync,deviceTimeAfterSync,serverTime);backgroundSyncTimeOffsets.push(offset);_attemptBackgroundSync(attempts-1);},function(){_completeBackgroundTimeSyncSequence();});}catch(e){_completeBackgroundTimeSyncSequence();}}/**
     * Sync against a timing source. This method is called recursively if the time sync for the first entry in timingSources fails.
     * @param {number} sourceIndex
     */function _attemptRecursiveSync(){var sourceIndex=arguments.length>0&&arguments[0]!==undefined?arguments[0]:null;// if called with no sourceIndex, use zero (highest priority)
var index=sourceIndex||0;// the sources should be ordered in priority from the manifest.
// try each in turn, from the top, until either something
// sensible happens, or we run out of sources to try.
if(!timingSources||timingSources.length===0||index>=timingSources.length){_onComplete();return;}var source=timingSources[index];if(source){// check if there is a handler for this @schemeIdUri
if(handlers.hasOwnProperty(source.schemeIdUri)){// if so, call it with its @value
var deviceTimeBeforeSync=new Date().getTime();handlers[source.schemeIdUri](source.value,function(serverTime){// the timing source returned something useful
var deviceTimeAfterSync=new Date().getTime();var offset=_calculateOffset(deviceTimeBeforeSync,deviceTimeAfterSync,serverTime);lastTimingSource=source;_onComplete(offset);},function(){// the timing source was probably uncontactable
// or returned something we can't use - try again
// with the remaining sources
_attemptRecursiveSync(index+1);});}else{// an unknown schemeIdUri must have been found
// try again with the remaining sources
_attemptRecursiveSync(index+1);}}else{// no valid time source could be found, just use device time
_onComplete();}}/**
     * Calculate the offset between client and server. Account for the roundtrip time
     * @param {number} deviceTimeBeforeSync
     * @param {number} deviceTimeAfterSync
     * @param {number} serverTime
     * @return {number}
     * @private
     */function _calculateOffset(deviceTimeBeforeSync,deviceTimeAfterSync,serverTime){var deviceReferenceTime=deviceTimeAfterSync-(deviceTimeAfterSync-deviceTimeBeforeSync)/2;return serverTime-deviceReferenceTime;}/**
     * Checks if a synchronization is required
     * @return {boolean}
     * @private
     */function _shouldPerformSynchronization(){try{var timeBetweenSyncAttempts=!isNaN(internalTimeBetweenSyncAttempts)?internalTimeBetweenSyncAttempts:DEFAULT_TIME_BETWEEN_SYNC_ATTEMPTS;if(!timeOfLastSync||!timeBetweenSyncAttempts||isNaN(timeBetweenSyncAttempts)){return true;}return(Date.now()-timeOfLastSync)/1000>=timeBetweenSyncAttempts;}catch(e){return true;}}/**
     * Callback after sync has been completed
     * @param {number} offset
     * @private
     */function _onComplete(){var offset=arguments.length>0&&arguments[0]!==undefined?arguments[0]:NaN;var failed=isNaN(offset);if(failed&&settings.get().streaming.useManifestDateHeaderTimeSource){//Before falling back to binary search , check if date header exists on MPD. if so, use for a time source.
_checkForDateHeader();}else{_completeTimeSyncSequence(failed,offset);}}/**
     * Takes xsdatetime and returns milliseconds since UNIX epoch. May not be necessary as xsdatetime is very similar to ISO 8601 which is natively understood by javascript Date parser
     * @param {string} xsdatetimeStr
     * @return {number}
     * @private
     */function _alternateXsdatetimeDecoder(xsdatetimeStr){// taken from DashParser - should probably refactor both uses
var SECONDS_IN_MIN=60;var MINUTES_IN_HOUR=60;var MILLISECONDS_IN_SECONDS=1000;var datetimeRegex=/^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\.[0-9]*)?)?(?:([+\-])([0-9]{2})([0-9]{2}))?/;var utcDate=void 0,timezoneOffset=void 0;var match=datetimeRegex.exec(xsdatetimeStr);// If the string does not contain a timezone offset different browsers can interpret it either
// as UTC or as a local time so we have to parse the string manually to normalize the given date value for
// all browsers
utcDate=Date.UTC(parseInt(match[1],10),parseInt(match[2],10)-1,// months start from zero
parseInt(match[3],10),parseInt(match[4],10),parseInt(match[5],10),match[6]&&(parseInt(match[6],10)||0),match[7]&&parseFloat(match[7])*MILLISECONDS_IN_SECONDS||0);// If the date has timezone offset take it into account as well
if(match[9]&&match[10]){timezoneOffset=parseInt(match[9],10)*MINUTES_IN_HOUR+parseInt(match[10],10);utcDate+=(match[8]==='+'?-1:+1)*timezoneOffset*SECONDS_IN_MIN*MILLISECONDS_IN_SECONDS;}return new Date(utcDate).getTime();}/**
     * Try to use the built in parser, since xsdate is a constrained ISO8601 which is supported natively by Date.parse. if that fails, try a regex-based version used elsewhere in this application.
     * @param {string} xsdatetimeStr
     * @return {number}
     */function _xsdatetimeDecoder(xsdatetimeStr){var parsedDate=Date.parse(xsdatetimeStr);if(isNaN(parsedDate)){parsedDate=_alternateXsdatetimeDecoder(xsdatetimeStr);}return parsedDate;}/**
     * Takes ISO 8601 timestamp and returns milliseconds since UNIX epoch
     * @param {string} isoStr
     * @return {number}
     */function _iso8601Decoder(isoStr){return Date.parse(isoStr);}/**
     * Takes RFC 1123 timestamp (which is same as ISO8601) and returns milliseconds since UNIX epoch
     * @param {string} dateStr
     * @return {number}
     */function _rfc1123Decoder(dateStr){return Date.parse(dateStr);}/**
     * Handler for unsupported scheme ids.
     * @param {string} url
     * @param {function} onSuccessCB
     * @param {function} onFailureCB
     * @private
     */function _notSupportedHandler(url,onSuccessCB,onFailureCB){onFailureCB();}/**
     * Direct handler
     * @param {string} xsdatetimeStr
     * @param {function} onSuccessCB
     * @param {function} onFailureCB
     */function _directHandler(xsdatetimeStr,onSuccessCB,onFailureCB){var time=_xsdatetimeDecoder(xsdatetimeStr);if(!isNaN(time)){onSuccessCB(time);return;}onFailureCB();}/**
     * Generic http handler
     * @param {function} decoder
     * @param {string} url
     * @param {function} onSuccessCB
     * @param {function} onFailureCB
     * @param {boolean} isHeadRequest
     * @private
     */function _httpHandler(decoder,url,onSuccessCB,onFailureCB,isHeadRequest){var oncomplete=void 0,onload=void 0;var complete=false;var req=new XMLHttpRequest();var verb=isHeadRequest?_HTTPRequest.HTTPRequest.HEAD:_HTTPRequest.HTTPRequest.GET;var urls=url.match(/\S+/g);// according to ISO 23009-1, url could be a white-space
// separated list of URLs. just handle one at a time.
url=urls.shift();oncomplete=function oncomplete(){if(complete){return;}// we only want to pass through here once per xhr,
// regardless of whether the load was successful.
complete=true;// if there are more urls to try, call self.
if(urls.length){_httpHandler(decoder,urls.join(' '),onSuccessCB,onFailureCB,isHeadRequest);}else{onFailureCB();}};onload=function onload(){var time=void 0,result=void 0;if(req.status===200){time=isHeadRequest?req.getResponseHeader('Date'):req.response;result=decoder(time);// decoder returns NaN if non-standard input
if(!isNaN(result)){onSuccessCB(result);complete=true;}}};if(urlUtils.isRelative(url)){// passing no path to resolve will return just MPD BaseURL/baseUri
var baseUrl=baseURLController.resolve();if(baseUrl){url=urlUtils.resolve(url,baseUrl.url);}}req.open(verb,url);req.timeout=HTTP_TIMEOUT_MS||0;req.onload=onload;req.onloadend=oncomplete;req.send();}/**
     * Handler for http-head schemeIdUri
     * @param {string} url
     * @param {function} onSuccessCB
     * @param {function} onFailureCB
     * @private
     */function _httpHeadHandler(url,onSuccessCB,onFailureCB){_httpHandler(_rfc1123Decoder,url,onSuccessCB,onFailureCB,true);}/**
     * Checks if a date header is present in the MPD response and calculates the offset based on the header
     * @private
     */function _checkForDateHeader(){var dateHeaderValue=dashMetrics.getLatestMPDRequestHeaderValueByID('Date');var dateHeaderTime=dateHeaderValue!==null?new Date(dateHeaderValue).getTime():Number.NaN;if(!isNaN(dateHeaderTime)){var offsetToDeviceTimeMs=dateHeaderTime-Date.now();_completeTimeSyncSequence(false,offsetToDeviceTimeMs);}else{_completeTimeSyncSequence(true);}}/**
     * Triggers the event to signal that the time synchronization was completed
     * @param {boolean} failed
     * @param {number} offset
     * @private
     */function _completeTimeSyncSequence(failed,offset){// Adjust the time of the next sync based on the drift between current offset and last offset
if(!isNaN(lastOffset)&&!isNaN(offset)&&!failed){_adjustTimeBetweenSyncAttempts(offset);}// Update the internal data
if(!failed&&!isNaN(offset)){timeOfLastSync=Date.now();isSynchronizing=false;// if this is the first sync we are doing perform background syncs as well to confirm current offset
var shouldAttemptBackgroundSync=isNaN(lastOffset);lastOffset=offset;if(shouldAttemptBackgroundSync){_onAttemptBackgroundSync();}logger.debug('Completed UTC sync. Setting client - server offset to '+offset);}if(failed){lastTimingSource=null;}// Notify other classes
eventBus.trigger(_Events2.default.UPDATE_TIME_SYNC_OFFSET,{offset:offset,error:failed?new _DashJSError2.default(_Errors2.default.TIME_SYNC_FAILED_ERROR_CODE,_Errors2.default.TIME_SYNC_FAILED_ERROR_MESSAGE):null});eventBus.trigger(_Events2.default.TIME_SYNCHRONIZATION_COMPLETED);}function _adjustTimeBetweenSyncAttempts(offset){try{var isOffsetDriftWithinThreshold=_isOffsetDriftWithinThreshold(offset);var timeBetweenSyncAttempts=!isNaN(internalTimeBetweenSyncAttempts)?internalTimeBetweenSyncAttempts:DEFAULT_TIME_BETWEEN_SYNC_ATTEMPTS;var timeBetweenSyncAttemptsAdjustmentFactor=!isNaN(settings.get().streaming.utcSynchronization.timeBetweenSyncAttemptsAdjustmentFactor)?settings.get().streaming.utcSynchronization.timeBetweenSyncAttemptsAdjustmentFactor:DEFAULT_TIME_BETWEEN_SYNC_ATTEMPTS_ADJUSTMENT_FACTOR;var maximumTimeBetweenSyncAttempts=!isNaN(settings.get().streaming.utcSynchronization.maximumTimeBetweenSyncAttempts)?settings.get().streaming.utcSynchronization.maximumTimeBetweenSyncAttempts:DEFAULT_MAXIMUM_TIME_BETWEEN_SYNC;var minimumTimeBetweenSyncAttempts=!isNaN(settings.get().streaming.utcSynchronization.minimumTimeBetweenSyncAttempts)?settings.get().streaming.utcSynchronization.minimumTimeBetweenSyncAttempts:DEFAULT_MINIMUM_TIME_BETWEEN_SYNC;var adjustedTimeBetweenSyncAttempts=void 0;if(isOffsetDriftWithinThreshold){// The drift between the current offset and the last offset is within the allowed threshold. Increase sync time
adjustedTimeBetweenSyncAttempts=Math.min(timeBetweenSyncAttempts*timeBetweenSyncAttemptsAdjustmentFactor,maximumTimeBetweenSyncAttempts);logger.debug('Increasing timeBetweenSyncAttempts to '+adjustedTimeBetweenSyncAttempts);}else{// Drift between the current offset and the last offset is not within the allowed threshold. Decrease sync time
adjustedTimeBetweenSyncAttempts=Math.max(timeBetweenSyncAttempts/timeBetweenSyncAttemptsAdjustmentFactor,minimumTimeBetweenSyncAttempts);logger.debug('Decreasing timeBetweenSyncAttempts to '+adjustedTimeBetweenSyncAttempts);}internalTimeBetweenSyncAttempts=adjustedTimeBetweenSyncAttempts;}catch(e){}}/**
     * Callback after all background syncs have been completed.
     * @private
     */function _completeBackgroundTimeSyncSequence(){if(!backgroundSyncTimeOffsets||backgroundSyncTimeOffsets.length===0){return;}var averageOffset=backgroundSyncTimeOffsets.reduce(function(acc,curr){return acc+curr;},0)/backgroundSyncTimeOffsets.length;if(!_isOffsetDriftWithinThreshold(averageOffset)){logger.debug('Completed background UTC sync. Setting client - server offset to '+averageOffset);lastOffset=averageOffset;eventBus.trigger(_Events2.default.UPDATE_TIME_SYNC_OFFSET,{offset:lastOffset});}else{logger.debug('Completed background UTC sync. Offset is within allowed threshold and is not adjusted.');}isBackgroundSynchronizing=false;timeOfLastBackgroundSync=Date.now();}function _isOffsetDriftWithinThreshold(offset){try{if(isNaN(lastOffset)){return true;}var maxAllowedDrift=settings.get().streaming.utcSynchronization.maximumAllowedDrift&&!isNaN(settings.get().streaming.utcSynchronization.maximumAllowedDrift)?settings.get().streaming.utcSynchronization.maximumAllowedDrift:DEFAULT_MAXIMUM_ALLOWED_DRIFT;var lowerBound=lastOffset-maxAllowedDrift;var upperBound=lastOffset+maxAllowedDrift;return offset>=lowerBound&&offset<=upperBound;}catch(e){return true;}}function reset(){_resetInitialSettings();eventBus.off(_Events2.default.ATTEMPT_BACKGROUND_SYNC,_onAttemptBackgroundSync,instance);}instance={initialize:initialize,attemptSync:attemptSync,setConfig:setConfig,reset:reset};setup();return instance;}TimeSyncController.__dashjs_factory_name='TimeSyncController';var factory=_FactoryMaker2.default.getSingletonFactory(TimeSyncController);factory.HTTP_TIMEOUT_MS=HTTP_TIMEOUT_MS;_FactoryMaker2.default.updateSingletonFactory(TimeSyncController.__dashjs_factory_name,factory);exports.default=factory;
//# sourceMappingURL=TimeSyncController.js.map
