'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _EventBus=require('../../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _MediaPlayerEvents=require('../MediaPlayerEvents');var _MediaPlayerEvents2=_interopRequireDefault(_MediaPlayerEvents);var _MetricsReportingEvents=require('../metrics/MetricsReportingEvents');var _MetricsReportingEvents2=_interopRequireDefault(_MetricsReportingEvents);var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _Settings=require('../../core/Settings');var _Settings2=_interopRequireDefault(_Settings);var _Constants=require('../../streaming/constants/Constants');var _Constants2=_interopRequireDefault(_Constants);var _HTTPRequest=require('../vo/metrics/HTTPRequest');var _DashManifestModel=require('../../dash/models/DashManifestModel');var _DashManifestModel2=_interopRequireDefault(_DashManifestModel);var _Utils=require('../../core/Utils');var _Utils2=_interopRequireDefault(_Utils);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */var CMCD_REQUEST_FIELD_NAME='CMCD';var CMCD_VERSION=1;var OBJECT_TYPES={MANIFEST:'m',AUDIO:'a',VIDEO:'v',INIT:'i',CAPTION:'c',ISOBMFF_TEXT_TRACK:'tt',ENCRYPTION_KEY:'k',OTHER:'o'};var STREAMING_FORMATS={DASH:'d',MSS:'s'};var STREAM_TYPES={VOD:'v',LIVE:'l'};var RTP_SAFETY_FACTOR=5;function CmcdModel(){var logger=void 0,dashManifestModel=void 0,instance=void 0,internalData=void 0,abrController=void 0,dashMetrics=void 0,playbackController=void 0,streamProcessors=void 0,_isStartup=void 0,_bufferLevelStarved=void 0,_initialMediaRequestsDone=void 0;var context=this.context;var eventBus=(0,_EventBus2.default)(context).getInstance();var settings=(0,_Settings2.default)(context).getInstance();function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);dashManifestModel=(0,_DashManifestModel2.default)(context).getInstance();_resetInitialSettings();}function initialize(){eventBus.on(_MediaPlayerEvents2.default.PLAYBACK_RATE_CHANGED,_onPlaybackRateChanged,instance);eventBus.on(_MediaPlayerEvents2.default.MANIFEST_LOADED,_onManifestLoaded,instance);eventBus.on(_MediaPlayerEvents2.default.BUFFER_LEVEL_STATE_CHANGED,_onBufferLevelStateChanged,instance);eventBus.on(_MediaPlayerEvents2.default.PLAYBACK_SEEKED,_onPlaybackSeeked,instance);eventBus.on(_MediaPlayerEvents2.default.PERIOD_SWITCH_COMPLETED,_onPeriodSwitchComplete,instance);}function setConfig(config){if(!config)return;if(config.abrController){abrController=config.abrController;}if(config.dashMetrics){dashMetrics=config.dashMetrics;}if(config.playbackController){playbackController=config.playbackController;}}function _resetInitialSettings(){internalData={pr:1,nor:null,st:null,sf:null,sid:''+_Utils2.default.generateUuid(),cid:null};_bufferLevelStarved={};_isStartup={};_initialMediaRequestsDone={};_updateStreamProcessors();}function _onPeriodSwitchComplete(){_updateStreamProcessors();}function _updateStreamProcessors(){if(!playbackController)return;var streamController=playbackController.getStreamController();if(!streamController)return;if(typeof streamController.getActiveStream!=='function')return;var activeStream=streamController.getActiveStream();if(!activeStream)return;streamProcessors=activeStream.getProcessors();}function getQueryParameter(request){try{if(settings.get().streaming.cmcd&&settings.get().streaming.cmcd.enabled){var cmcdData=_getCmcdData(request);var finalPayloadString=_buildFinalString(cmcdData);eventBus.trigger(_MetricsReportingEvents2.default.CMCD_DATA_GENERATED,{url:request.url,mediaType:request.mediaType,cmcdData:cmcdData,cmcdString:finalPayloadString});return{key:CMCD_REQUEST_FIELD_NAME,value:finalPayloadString};}return null;}catch(e){return null;}}function _getCmcdData(request){try{var cmcdData=null;if(request.type===_HTTPRequest.HTTPRequest.MPD_TYPE){return _getCmcdDataForMpd(request);}else if(request.type===_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE){_initForMediaType(request.mediaType);return _getCmcdDataForMediaSegment(request);}else if(request.type===_HTTPRequest.HTTPRequest.INIT_SEGMENT_TYPE){return _getCmcdDataForInitSegment(request);}else if(request.type===_HTTPRequest.HTTPRequest.OTHER_TYPE||request.type===_HTTPRequest.HTTPRequest.XLINK_EXPANSION_TYPE){return _getCmcdDataForOther(request);}else if(request.type===_HTTPRequest.HTTPRequest.LICENSE){return _getCmcdDataForLicense(request);}return cmcdData;}catch(e){return null;}}function _getCmcdDataForLicense(request){var data=_getGenericCmcdData(request);data.ot=OBJECT_TYPES.ENCRYPTION_KEY;return data;}function _getCmcdDataForMpd(){var data=_getGenericCmcdData();data.ot=''+OBJECT_TYPES.MANIFEST;return data;}function _getCmcdDataForMediaSegment(request){var data=_getGenericCmcdData();var encodedBitrate=_getBitrateByRequest(request);var d=_getObjectDurationByRequest(request);var mtp=_getMeasuredThroughputByType(request.mediaType);var dl=_getDeadlineByType(request.mediaType);var bl=_getBufferLevelByType(request.mediaType);var tb=_getTopBitrateByType(request.mediaType);var pr=internalData.pr;var nextRequest=_probeNextRequest(request.mediaType);var ot=void 0;if(request.mediaType===_Constants2.default.VIDEO)ot=OBJECT_TYPES.VIDEO;if(request.mediaType===_Constants2.default.AUDIO)ot=OBJECT_TYPES.AUDIO;if(request.mediaType===_Constants2.default.FRAGMENTED_TEXT){if(request.mediaInfo.mimeType==='application/mp4'){ot=OBJECT_TYPES.ISOBMFF_TEXT_TRACK;}else{ot=OBJECT_TYPES.CAPTION;}}var rtp=settings.get().streaming.cmcd.rtp;if(!rtp){rtp=_calculateRtp(request);}data.rtp=rtp;if(nextRequest){if(request.url!==nextRequest.url){var url=new URL(nextRequest.url);data.nor=url.pathname;}else if(nextRequest.range){data.nrr=nextRequest.range;}}if(encodedBitrate){data.br=encodedBitrate;}if(ot){data.ot=ot;}if(!isNaN(d)){data.d=d;}if(!isNaN(mtp)){data.mtp=mtp;}if(!isNaN(dl)){data.dl=dl;}if(!isNaN(bl)){data.bl=bl;}if(!isNaN(tb)){data.tb=tb;}if(!isNaN(pr)&&pr!==1){data.pr=pr;}if(_bufferLevelStarved[request.mediaType]){data.bs=true;_bufferLevelStarved[request.mediaType]=false;}if(_isStartup[request.mediaType]||!_initialMediaRequestsDone[request.mediaType]){data.su=true;_isStartup[request.mediaType]=false;_initialMediaRequestsDone[request.mediaType]=true;}return data;}function _initForMediaType(mediaType){if(!_initialMediaRequestsDone.hasOwnProperty(mediaType)){_initialMediaRequestsDone[mediaType]=false;}if(!_isStartup.hasOwnProperty(mediaType)){_isStartup[mediaType]=false;}if(!_bufferLevelStarved.hasOwnProperty(mediaType)){_bufferLevelStarved[mediaType]=false;}}function _getCmcdDataForInitSegment(){var data=_getGenericCmcdData();data.ot=''+OBJECT_TYPES.INIT;data.su=true;return data;}function _getCmcdDataForOther(){var data=_getGenericCmcdData();data.ot=''+OBJECT_TYPES.OTHER;return data;}function _getGenericCmcdData(){var data={};var cid=settings.get().streaming.cmcd.cid?settings.get().streaming.cmcd.cid:internalData.cid;data.v=CMCD_VERSION;data.sid=settings.get().streaming.cmcd.sid?settings.get().streaming.cmcd.sid:internalData.sid;data.sid=''+data.sid;if(cid){data.cid=''+cid;}if(!isNaN(internalData.pr)&&internalData.pr!==1&&internalData.pr!==null){data.pr=internalData.pr;}if(internalData.st){data.st=internalData.st;}if(internalData.sf){data.sf=internalData.sf;}return data;}function _getBitrateByRequest(request){try{var quality=request.quality;var bitrateList=request.mediaInfo.bitrateList;return parseInt(bitrateList[quality].bandwidth/1000);}catch(e){return null;}}function _getTopBitrateByType(mediaType){try{var info=abrController.getTopBitrateInfoFor(mediaType);return Math.round(info.bitrate/1000);}catch(e){return null;}}function _getObjectDurationByRequest(request){try{return!isNaN(request.duration)?Math.round(request.duration*1000):null;}catch(e){return null;}}function _getMeasuredThroughputByType(mediaType){try{return parseInt(abrController.getThroughputHistory().getSafeAverageThroughput(mediaType)/100)*100;}catch(e){return null;}}function _getDeadlineByType(mediaType){try{var playbackRate=internalData.pr;var bufferLevel=dashMetrics.getCurrentBufferLevel(mediaType);if(!isNaN(playbackRate)&&!isNaN(bufferLevel)){return parseInt(bufferLevel/playbackRate*10)*100;}return null;}catch(e){return null;}}function _getBufferLevelByType(mediaType){try{var bufferLevel=dashMetrics.getCurrentBufferLevel(mediaType);if(!isNaN(bufferLevel)){return parseInt(bufferLevel*10)*100;}return null;}catch(e){return null;}}function _onPlaybackRateChanged(data){try{internalData.pr=data.playbackRate;}catch(e){}}function _onManifestLoaded(data){try{var isDynamic=dashManifestModel.getIsDynamic(data.data);var st=isDynamic?''+STREAM_TYPES.LIVE:''+STREAM_TYPES.VOD;var sf=data.protocol&&data.protocol==='MSS'?''+STREAMING_FORMATS.MSS:''+STREAMING_FORMATS.DASH;internalData.st=''+st;internalData.sf=''+sf;}catch(e){}}function _onBufferLevelStateChanged(data){try{if(data.state&&data.mediaType){if(data.state===_MediaPlayerEvents2.default.BUFFER_EMPTY){if(!_bufferLevelStarved[data.mediaType]){_bufferLevelStarved[data.mediaType]=true;}if(!_isStartup[data.mediaType]){_isStartup[data.mediaType]=true;}}}}catch(e){}}function _onPlaybackSeeked(){for(var key in _bufferLevelStarved){if(_bufferLevelStarved.hasOwnProperty(key)){_bufferLevelStarved[key]=true;}}for(var _key in _isStartup){if(_isStartup.hasOwnProperty(_key)){_isStartup[_key]=true;}}}function _buildFinalString(cmcdData){try{if(!cmcdData){return null;}var keys=Object.keys(cmcdData).sort(function(a,b){return a.localeCompare(b);});var length=keys.length;var cmcdString=keys.reduce(function(acc,key,index){if(key==='v'&&cmcdData[key]===1)return acc;// Version key should only be reported if it is != 1
if(typeof cmcdData[key]==='string'&&(key!=='ot'||key!=='sf'||key!=='st')){var string=cmcdData[key].replace(/"/g,'\"');acc+=key+'="'+string+'"';}else{acc+=key+'='+cmcdData[key];}if(index<length-1){acc+=',';}return acc;},'');cmcdString=cmcdString.replace(/=true/g,'');return cmcdString;}catch(e){return null;}}function _probeNextRequest(mediaType){if(!streamProcessors||streamProcessors.length===0)return;var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=streamProcessors[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var streamProcessor=_step.value;if(streamProcessor.getType()===mediaType){return streamProcessor.probeNextRequest();}}}catch(err){_didIteratorError=true;_iteratorError=err;}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return();}}finally{if(_didIteratorError){throw _iteratorError;}}}}function _calculateRtp(request){// Get the values we need
var playbackRate=playbackController.getPlaybackRate();if(!playbackRate)playbackRate=1;var quality=request.quality,mediaType=request.mediaType,mediaInfo=request.mediaInfo,duration=request.duration;var currentBufferLevel=_getBufferLevelByType(mediaType);if(currentBufferLevel===0)currentBufferLevel=500;var bitrate=mediaInfo.bitrateList[quality].bandwidth;// Calculate RTP
var segmentSize=bitrate*duration/1000;// Calculate file size in kilobits
var timeToLoad=currentBufferLevel/playbackRate/1000;// Calculate time available to load file in seconds
var minBandwidth=segmentSize/timeToLoad;// Calculate the exact bandwidth required
var rtpSafetyFactor=settings.get().streaming.cmcd.rtpSafetyFactor&&!isNaN(settings.get().streaming.cmcd.rtpSafetyFactor)?settings.get().streaming.cmcd.rtpSafetyFactor:RTP_SAFETY_FACTOR;var maxBandwidth=minBandwidth*rtpSafetyFactor;// Include a safety buffer
var rtp=(parseInt(maxBandwidth/100)+1)*100;// Round to the next multiple of 100
return rtp;}function reset(){eventBus.off(_MediaPlayerEvents2.default.PLAYBACK_RATE_CHANGED,_onPlaybackRateChanged,this);eventBus.off(_MediaPlayerEvents2.default.MANIFEST_LOADED,_onManifestLoaded,this);eventBus.off(_MediaPlayerEvents2.default.BUFFER_LEVEL_STATE_CHANGED,_onBufferLevelStateChanged,instance);eventBus.off(_MediaPlayerEvents2.default.PLAYBACK_SEEKED,_onPlaybackSeeked,instance);_resetInitialSettings();}instance={getQueryParameter:getQueryParameter,setConfig:setConfig,reset:reset,initialize:initialize};setup();return instance;}CmcdModel.__dashjs_factory_name='CmcdModel';exports.default=_FactoryMaker2.default.getSingletonFactory(CmcdModel);
//# sourceMappingURL=CmcdModel.js.map
