'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _FactoryMaker=require('../../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _SwitchRequest=require('../SwitchRequest');var _SwitchRequest2=_interopRequireDefault(_SwitchRequest);var _Debug=require('../../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function DroppedFramesRule(){var context=this.context;var instance=void 0,logger=void 0;var DROPPED_PERCENTAGE_FORBID=0.15;var GOOD_SAMPLE_SIZE=375;//Don't apply the rule until this many frames have been rendered(and counted under those indices).
function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);}function getMaxIndex(rulesContext){var switchRequest=(0,_SwitchRequest2.default)(context).create();if(!rulesContext||!rulesContext.hasOwnProperty('getDroppedFramesHistory')){return switchRequest;}var droppedFramesHistory=rulesContext.getDroppedFramesHistory();if(droppedFramesHistory){var dfh=droppedFramesHistory.getFrameHistory();var droppedFrames=0;var totalFrames=0;var maxIndex=_SwitchRequest2.default.NO_CHANGE;for(var i=1;i<dfh.length;i++){//No point in measuring dropped frames for the zeroeth index.
if(dfh[i]){droppedFrames=dfh[i].droppedVideoFrames;totalFrames=dfh[i].totalVideoFrames;if(totalFrames>GOOD_SAMPLE_SIZE&&droppedFrames/totalFrames>DROPPED_PERCENTAGE_FORBID){maxIndex=i-1;logger.debug('index: '+maxIndex+' Dropped Frames: '+droppedFrames+' Total Frames: '+totalFrames);break;}}}return(0,_SwitchRequest2.default)(context).create(maxIndex,{droppedFrames:droppedFrames});}return switchRequest;}instance={getMaxIndex:getMaxIndex};setup();return instance;}DroppedFramesRule.__dashjs_factory_name='DroppedFramesRule';exports.default=_FactoryMaker2.default.getClassFactory(DroppedFramesRule);
//# sourceMappingURL=DroppedFramesRule.js.map
