'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _FactoryMaker=require('../../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _SwitchRequest=require('../SwitchRequest');var _SwitchRequest2=_interopRequireDefault(_SwitchRequest);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function SwitchHistoryRule(){var context=this.context;var instance=void 0,logger=void 0;//MAX_SWITCH is the number of drops made. It doesn't consider the size of the drop.
var MAX_SWITCH=0.075;//Before this number of switch requests(no switch or actual), don't apply the rule.
//must be < SwitchRequestHistory SWITCH_REQUEST_HISTORY_DEPTH to enable rule
var SAMPLE_SIZE=6;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);}function getMaxIndex(rulesContext){var switchRequestHistory=rulesContext?rulesContext.getSwitchHistory():null;var switchRequests=switchRequestHistory?switchRequestHistory.getSwitchRequests():[];var drops=0;var noDrops=0;var dropSize=0;var switchRequest=(0,_SwitchRequest2.default)(context).create();for(var i=0;i<switchRequests.length;i++){if(switchRequests[i]!==undefined){drops+=switchRequests[i].drops;noDrops+=switchRequests[i].noDrops;dropSize+=switchRequests[i].dropSize;if(drops+noDrops>=SAMPLE_SIZE&&drops/noDrops>MAX_SWITCH){switchRequest.quality=i>0&&switchRequests[i].drops>0?i-1:i;switchRequest.reason={index:switchRequest.quality,drops:drops,noDrops:noDrops,dropSize:dropSize};logger.debug('Switch history rule index: '+switchRequest.quality+' samples: '+(drops+noDrops)+' drops: '+drops);break;}}}return switchRequest;}instance={getMaxIndex:getMaxIndex};setup();return instance;}SwitchHistoryRule.__dashjs_factory_name='SwitchHistoryRule';exports.default=_FactoryMaker2.default.getClassFactory(SwitchHistoryRule);
//# sourceMappingURL=SwitchHistoryRule.js.map
