(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dashjs"] = factory();
	else
		root["dashjs"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./externals/xml2json.js":
/*!*******************************!*\
  !*** ./externals/xml2json.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 Copyright 2011-2013 Abdulla Abdurakhmanov
 Original sources are available at https://code.google.com/p/x2js/

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
  Further modified for dashjs to:
  - keep track of children nodes in order in attribute __children.
  - add type conversion matchers
  - re-add ignoreRoot
  - allow zero-length attributePrefix
  - don't add white-space text nodes
  - remove explicit RequireJS support
*/
function X2JS(config) {
  'use strict';

  var VERSION = "1.2.0";
  config = config || {};
  initConfigDefaults();
  initRequiredPolyfills();

  function initConfigDefaults() {
    if (config.escapeMode === undefined) {
      config.escapeMode = true;
    }

    if (config.attributePrefix === undefined) {
      config.attributePrefix = "_";
    }

    config.arrayAccessForm = config.arrayAccessForm || "none";
    config.emptyNodeForm = config.emptyNodeForm || "text";

    if (config.enableToStringFunc === undefined) {
      config.enableToStringFunc = true;
    }

    config.arrayAccessFormPaths = config.arrayAccessFormPaths || [];

    if (config.skipEmptyTextNodesForObj === undefined) {
      config.skipEmptyTextNodesForObj = true;
    }

    if (config.stripWhitespaces === undefined) {
      config.stripWhitespaces = true;
    }

    config.datetimeAccessFormPaths = config.datetimeAccessFormPaths || [];

    if (config.useDoubleQuotes === undefined) {
      config.useDoubleQuotes = false;
    }

    config.xmlElementsFilter = config.xmlElementsFilter || [];
    config.jsonPropertiesFilter = config.jsonPropertiesFilter || [];

    if (config.keepCData === undefined) {
      config.keepCData = false;
    }

    if (config.ignoreRoot === undefined) {
      config.ignoreRoot = false;
    }
  }

  var DOMNodeTypes = {
    ELEMENT_NODE: 1,
    TEXT_NODE: 3,
    CDATA_SECTION_NODE: 4,
    COMMENT_NODE: 8,
    DOCUMENT_NODE: 9
  };

  function initRequiredPolyfills() {}

  function getNodeLocalName(node) {
    var nodeLocalName = node.localName;
    if (nodeLocalName == null) // Yeah, this is IE!!
      nodeLocalName = node.baseName;
    if (nodeLocalName == null || nodeLocalName == "") // =="" is IE too
      nodeLocalName = node.nodeName;
    return nodeLocalName;
  }

  function getNodePrefix(node) {
    return node.prefix;
  }

  function escapeXmlChars(str) {
    if (typeof str == "string") return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&apos;');else return str;
  }

  function unescapeXmlChars(str) {
    return str.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&quot;/g, '"').replace(/&apos;/g, "'").replace(/&amp;/g, '&');
  }

  function checkInStdFiltersArrayForm(stdFiltersArrayForm, obj, name, path) {
    var idx = 0;

    for (; idx < stdFiltersArrayForm.length; idx++) {
      var filterPath = stdFiltersArrayForm[idx];

      if (typeof filterPath === "string") {
        if (filterPath == path) break;
      } else if (filterPath instanceof RegExp) {
        if (filterPath.test(path)) break;
      } else if (typeof filterPath === "function") {
        if (filterPath(obj, name, path)) break;
      }
    }

    return idx != stdFiltersArrayForm.length;
  }

  function toArrayAccessForm(obj, childName, path) {
    switch (config.arrayAccessForm) {
      case "property":
        if (!(obj[childName] instanceof Array)) obj[childName + "_asArray"] = [obj[childName]];else obj[childName + "_asArray"] = obj[childName];
        break;

      /*case "none":
          break;*/
    }

    if (!(obj[childName] instanceof Array) && config.arrayAccessFormPaths.length > 0) {
      if (checkInStdFiltersArrayForm(config.arrayAccessFormPaths, obj, childName, path)) {
        obj[childName] = [obj[childName]];
      }
    }
  }

  function fromXmlDateTime(prop) {
    // Implementation based up on http://stackoverflow.com/questions/8178598/xml-datetime-to-javascript-date-object
    // Improved to support full spec and optional parts
    var bits = prop.split(/[-T:+Z]/g);
    var d = new Date(bits[0], bits[1] - 1, bits[2]);
    var secondBits = bits[5].split("\.");
    d.setHours(bits[3], bits[4], secondBits[0]);
    if (secondBits.length > 1) d.setMilliseconds(secondBits[1]); // Get supplied time zone offset in minutes

    if (bits[6] && bits[7]) {
      var offsetMinutes = bits[6] * 60 + Number(bits[7]);
      var sign = /\d\d-\d\d:\d\d$/.test(prop) ? '-' : '+'; // Apply the sign

      offsetMinutes = 0 + (sign == '-' ? -1 * offsetMinutes : offsetMinutes); // Apply offset and local timezone

      d.setMinutes(d.getMinutes() - offsetMinutes - d.getTimezoneOffset());
    } else if (prop.indexOf("Z", prop.length - 1) !== -1) {
      d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds(), d.getMilliseconds()));
    } // d is now a local time equivalent to the supplied time


    return d;
  }

  function checkFromXmlDateTimePaths(value, childName, fullPath) {
    if (config.datetimeAccessFormPaths.length > 0) {
      var path = fullPath.split("\.#")[0];

      if (checkInStdFiltersArrayForm(config.datetimeAccessFormPaths, value, childName, path)) {
        return fromXmlDateTime(value);
      } else return value;
    } else return value;
  }

  function checkXmlElementsFilter(obj, childType, childName, childPath) {
    if (childType == DOMNodeTypes.ELEMENT_NODE && config.xmlElementsFilter.length > 0) {
      return checkInStdFiltersArrayForm(config.xmlElementsFilter, obj, childName, childPath);
    } else return true;
  }

  function parseDOMChildren(node, path) {
    if (node.nodeType == DOMNodeTypes.DOCUMENT_NODE) {
      var result = new Object();
      var nodeChildren = node.childNodes; // Alternative for firstElementChild which is not supported in some environments

      for (var cidx = 0; cidx < nodeChildren.length; cidx++) {
        var child = nodeChildren[cidx];

        if (child.nodeType == DOMNodeTypes.ELEMENT_NODE) {
          if (config.ignoreRoot) {
            result = parseDOMChildren(child);
          } else {
            result = {};
            var childName = getNodeLocalName(child);
            result[childName] = parseDOMChildren(child);
          }
        }
      }

      return result;
    } else if (node.nodeType == DOMNodeTypes.ELEMENT_NODE) {
      var result = new Object();
      result.__cnt = 0;
      var children = [];
      var nodeChildren = node.childNodes; // Children nodes

      for (var cidx = 0; cidx < nodeChildren.length; cidx++) {
        var child = nodeChildren[cidx];
        var childName = getNodeLocalName(child);

        if (child.nodeType != DOMNodeTypes.COMMENT_NODE) {
          var childPath = path + "." + childName;

          if (checkXmlElementsFilter(result, child.nodeType, childName, childPath)) {
            result.__cnt++;

            if (result[childName] == null) {
              var c = parseDOMChildren(child, childPath);

              if (childName != "#text" || /[^\s]/.test(c)) {
                var o = {};
                o[childName] = c;
                children.push(o);
              }

              result[childName] = c;
              toArrayAccessForm(result, childName, childPath);
            } else {
              if (result[childName] != null) {
                if (!(result[childName] instanceof Array)) {
                  result[childName] = [result[childName]];
                  toArrayAccessForm(result, childName, childPath);
                }
              }

              var c = parseDOMChildren(child, childPath);

              if (childName != "#text" || /[^\s]/.test(c)) {
                // Don't add white-space text nodes
                var o = {};
                o[childName] = c;
                children.push(o);
              }

              result[childName][result[childName].length] = c;
            }
          }
        }
      }

      result.__children = children; // Attributes

      var nodeLocalName = getNodeLocalName(node);

      for (var aidx = 0; aidx < node.attributes.length; aidx++) {
        var attr = node.attributes[aidx];
        result.__cnt++;
        var value2 = attr.value;

        for (var m = 0, ml = config.matchers.length; m < ml; m++) {
          var matchobj = config.matchers[m];
          if (matchobj.test(attr, nodeLocalName)) value2 = matchobj.converter(attr.value);
        }

        result[config.attributePrefix + attr.name] = value2;
      } // Node namespace prefix


      var nodePrefix = getNodePrefix(node);

      if (nodePrefix != null && nodePrefix != "") {
        result.__cnt++;
        result.__prefix = nodePrefix;
      }

      if (result["#text"] != null) {
        result.__text = result["#text"];

        if (result.__text instanceof Array) {
          result.__text = result.__text.join("\n");
        } //if(config.escapeMode)
        //	result.__text = unescapeXmlChars(result.__text);


        if (config.stripWhitespaces) result.__text = result.__text.trim();
        delete result["#text"];
        if (config.arrayAccessForm == "property") delete result["#text_asArray"];
        result.__text = checkFromXmlDateTimePaths(result.__text, childName, path + "." + childName);
      }

      if (result["#cdata-section"] != null) {
        result.__cdata = result["#cdata-section"];
        delete result["#cdata-section"];
        if (config.arrayAccessForm == "property") delete result["#cdata-section_asArray"];
      }

      if (result.__cnt == 0 && config.emptyNodeForm == "text") {
        result = '';
      } else if (result.__cnt == 1 && result.__text != null) {
        result = result.__text;
      } else if (result.__cnt == 1 && result.__cdata != null && !config.keepCData) {
        result = result.__cdata;
      } else if (result.__cnt > 1 && result.__text != null && config.skipEmptyTextNodesForObj) {
        if (config.stripWhitespaces && result.__text == "" || result.__text.trim() == "") {
          delete result.__text;
        }
      }

      delete result.__cnt;

      if (config.enableToStringFunc && (result.__text != null || result.__cdata != null)) {
        result.toString = function () {
          return (this.__text != null ? this.__text : '') + (this.__cdata != null ? this.__cdata : '');
        };
      }

      return result;
    } else if (node.nodeType == DOMNodeTypes.TEXT_NODE || node.nodeType == DOMNodeTypes.CDATA_SECTION_NODE) {
      return node.nodeValue;
    }
  }

  function startTag(jsonObj, element, attrList, closed) {
    var resultStr = "<" + (jsonObj != null && jsonObj.__prefix != null ? jsonObj.__prefix + ":" : "") + element;

    if (attrList != null) {
      for (var aidx = 0; aidx < attrList.length; aidx++) {
        var attrName = attrList[aidx];
        var attrVal = jsonObj[attrName];
        if (config.escapeMode) attrVal = escapeXmlChars(attrVal);
        resultStr += " " + attrName.substr(config.attributePrefix.length) + "=";
        if (config.useDoubleQuotes) resultStr += '"' + attrVal + '"';else resultStr += "'" + attrVal + "'";
      }
    }

    if (!closed) resultStr += ">";else resultStr += "/>";
    return resultStr;
  }

  function endTag(jsonObj, elementName) {
    return "</" + (jsonObj.__prefix != null ? jsonObj.__prefix + ":" : "") + elementName + ">";
  }

  function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
  }

  function jsonXmlSpecialElem(jsonObj, jsonObjField) {
    if (config.arrayAccessForm == "property" && endsWith(jsonObjField.toString(), "_asArray") || jsonObjField.toString().indexOf(config.attributePrefix) == 0 || jsonObjField.toString().indexOf("__") == 0 || jsonObj[jsonObjField] instanceof Function) return true;else return false;
  }

  function jsonXmlElemCount(jsonObj) {
    var elementsCnt = 0;

    if (jsonObj instanceof Object) {
      for (var it in jsonObj) {
        if (jsonXmlSpecialElem(jsonObj, it)) continue;
        elementsCnt++;
      }
    }

    return elementsCnt;
  }

  function checkJsonObjPropertiesFilter(jsonObj, propertyName, jsonObjPath) {
    return config.jsonPropertiesFilter.length == 0 || jsonObjPath == "" || checkInStdFiltersArrayForm(config.jsonPropertiesFilter, jsonObj, propertyName, jsonObjPath);
  }

  function parseJSONAttributes(jsonObj) {
    var attrList = [];

    if (jsonObj instanceof Object) {
      for (var ait in jsonObj) {
        if (ait.toString().indexOf("__") == -1 && ait.toString().indexOf(config.attributePrefix) == 0) {
          attrList.push(ait);
        }
      }
    }

    return attrList;
  }

  function parseJSONTextAttrs(jsonTxtObj) {
    var result = "";

    if (jsonTxtObj.__cdata != null) {
      result += "<![CDATA[" + jsonTxtObj.__cdata + "]]>";
    }

    if (jsonTxtObj.__text != null) {
      if (config.escapeMode) result += escapeXmlChars(jsonTxtObj.__text);else result += jsonTxtObj.__text;
    }

    return result;
  }

  function parseJSONTextObject(jsonTxtObj) {
    var result = "";

    if (jsonTxtObj instanceof Object) {
      result += parseJSONTextAttrs(jsonTxtObj);
    } else if (jsonTxtObj != null) {
      if (config.escapeMode) result += escapeXmlChars(jsonTxtObj);else result += jsonTxtObj;
    }

    return result;
  }

  function getJsonPropertyPath(jsonObjPath, jsonPropName) {
    if (jsonObjPath === "") {
      return jsonPropName;
    } else return jsonObjPath + "." + jsonPropName;
  }

  function parseJSONArray(jsonArrRoot, jsonArrObj, attrList, jsonObjPath) {
    var result = "";

    if (jsonArrRoot.length == 0) {
      result += startTag(jsonArrRoot, jsonArrObj, attrList, true);
    } else {
      for (var arIdx = 0; arIdx < jsonArrRoot.length; arIdx++) {
        result += startTag(jsonArrRoot[arIdx], jsonArrObj, parseJSONAttributes(jsonArrRoot[arIdx]), false);
        result += parseJSONObject(jsonArrRoot[arIdx], getJsonPropertyPath(jsonObjPath, jsonArrObj));
        result += endTag(jsonArrRoot[arIdx], jsonArrObj);
      }
    }

    return result;
  }

  function parseJSONObject(jsonObj, jsonObjPath) {
    var result = "";
    var elementsCnt = jsonXmlElemCount(jsonObj);

    if (elementsCnt > 0) {
      for (var it in jsonObj) {
        if (jsonXmlSpecialElem(jsonObj, it) || jsonObjPath != "" && !checkJsonObjPropertiesFilter(jsonObj, it, getJsonPropertyPath(jsonObjPath, it))) continue;
        var subObj = jsonObj[it];
        var attrList = parseJSONAttributes(subObj);

        if (subObj == null || subObj == undefined) {
          result += startTag(subObj, it, attrList, true);
        } else if (subObj instanceof Object) {
          if (subObj instanceof Array) {
            result += parseJSONArray(subObj, it, attrList, jsonObjPath);
          } else if (subObj instanceof Date) {
            result += startTag(subObj, it, attrList, false);
            result += subObj.toISOString();
            result += endTag(subObj, it);
          } else {
            var subObjElementsCnt = jsonXmlElemCount(subObj);

            if (subObjElementsCnt > 0 || subObj.__text != null || subObj.__cdata != null) {
              result += startTag(subObj, it, attrList, false);
              result += parseJSONObject(subObj, getJsonPropertyPath(jsonObjPath, it));
              result += endTag(subObj, it);
            } else {
              result += startTag(subObj, it, attrList, true);
            }
          }
        } else {
          result += startTag(subObj, it, attrList, false);
          result += parseJSONTextObject(subObj);
          result += endTag(subObj, it);
        }
      }
    }

    result += parseJSONTextObject(jsonObj);
    return result;
  }

  this.parseXmlString = function (xmlDocStr) {
    var isIEParser = window.ActiveXObject || "ActiveXObject" in window;

    if (xmlDocStr === undefined) {
      return null;
    }

    var xmlDoc;

    if (window.DOMParser) {
      var parser = new window.DOMParser();
      var parsererrorNS = null;

      try {
        xmlDoc = parser.parseFromString(xmlDocStr, "text/xml");

        if (xmlDoc.getElementsByTagNameNS("*", "parsererror").length > 0) {
          xmlDoc = null;
        }
      } catch (err) {
        xmlDoc = null;
      }
    } else {
      // IE :(
      if (xmlDocStr.indexOf("<?") == 0) {
        xmlDocStr = xmlDocStr.substr(xmlDocStr.indexOf("?>") + 2);
      }

      xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
      xmlDoc.async = "false";
      xmlDoc.loadXML(xmlDocStr);
    }

    return xmlDoc;
  };

  this.asArray = function (prop) {
    if (prop === undefined || prop == null) return [];else if (prop instanceof Array) return prop;else return [prop];
  };

  this.toXmlDateTime = function (dt) {
    if (dt instanceof Date) return dt.toISOString();else if (typeof dt === 'number') return new Date(dt).toISOString();else return null;
  };

  this.asDateTime = function (prop) {
    if (typeof prop == "string") {
      return fromXmlDateTime(prop);
    } else return prop;
  };

  this.xml2json = function (xmlDoc) {
    return parseDOMChildren(xmlDoc);
  };

  this.xml_str2json = function (xmlDocStr) {
    var xmlDoc = this.parseXmlString(xmlDocStr);
    if (xmlDoc != null) return this.xml2json(xmlDoc);else return null;
  };

  this.json2xml_str = function (jsonObj) {
    return parseJSONObject(jsonObj, "");
  };

  this.json2xml = function (jsonObj) {
    var xmlDocStr = this.json2xml_str(jsonObj);
    return this.parseXmlString(xmlDocStr);
  };

  this.getVersion = function () {
    return VERSION;
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (X2JS);

/***/ }),

/***/ "./src/core/Debug.js":
/*!***************************!*\
  !*** ./src/core/Debug.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



var LOG_LEVEL_NONE = 0;
var LOG_LEVEL_FATAL = 1;
var LOG_LEVEL_ERROR = 2;
var LOG_LEVEL_WARNING = 3;
var LOG_LEVEL_INFO = 4;
var LOG_LEVEL_DEBUG = 5;
/**
 * @module Debug
 * @param {object} config
 * @ignore
 */

function Debug(config) {
  config = config || {};
  var context = this.context;
  var eventBus = (0,_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var settings = config.settings;
  var logFn = [];
  var instance, showLogTimestamp, showCalleeName, startTime;

  function setup() {
    showLogTimestamp = true;
    showCalleeName = true;
    startTime = new Date().getTime();

    if (typeof window !== 'undefined' && window.console) {
      logFn[LOG_LEVEL_FATAL] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_ERROR] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_WARNING] = getLogFn(window.console.warn);
      logFn[LOG_LEVEL_INFO] = getLogFn(window.console.info);
      logFn[LOG_LEVEL_DEBUG] = getLogFn(window.console.debug);
    }
  }

  function getLogFn(fn) {
    if (fn && fn.bind) {
      return fn.bind(window.console);
    } // if not define, return the default function for reporting logs


    return window.console.log.bind(window.console);
  }
  /**
   * Retrieves a logger which can be used to write logging information in browser console.
   * @param {object} instance Object for which the logger is created. It is used
   * to include calle object information in log messages.
   * @memberof module:Debug
   * @returns {Logger}
   * @instance
   */


  function getLogger(instance) {
    return {
      fatal: fatal.bind(instance),
      error: error.bind(instance),
      warn: warn.bind(instance),
      info: info.bind(instance),
      debug: debug.bind(instance)
    };
  }
  /**
   * Prepends a timestamp in milliseconds to each log message.
   * @param {boolean} value Set to true if you want to see a timestamp in each log message.
   * @default LOG_LEVEL_WARNING
   * @memberof module:Debug
   * @instance
   */


  function setLogTimestampVisible(value) {
    showLogTimestamp = value;
  }
  /**
   * Prepends the callee object name, and media type if available, to each log message.
   * @param {boolean} value Set to true if you want to see the callee object name and media type in each log message.
   * @default true
   * @memberof module:Debug
   * @instance
   */


  function setCalleeNameVisible(value) {
    showCalleeName = value;
  }

  function fatal() {
    for (var _len = arguments.length, params = new Array(_len), _key = 0; _key < _len; _key++) {
      params[_key] = arguments[_key];
    }

    doLog.apply(void 0, [LOG_LEVEL_FATAL, this].concat(params));
  }

  function error() {
    for (var _len2 = arguments.length, params = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      params[_key2] = arguments[_key2];
    }

    doLog.apply(void 0, [LOG_LEVEL_ERROR, this].concat(params));
  }

  function warn() {
    for (var _len3 = arguments.length, params = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      params[_key3] = arguments[_key3];
    }

    doLog.apply(void 0, [LOG_LEVEL_WARNING, this].concat(params));
  }

  function info() {
    for (var _len4 = arguments.length, params = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      params[_key4] = arguments[_key4];
    }

    doLog.apply(void 0, [LOG_LEVEL_INFO, this].concat(params));
  }

  function debug() {
    for (var _len5 = arguments.length, params = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      params[_key5] = arguments[_key5];
    }

    doLog.apply(void 0, [LOG_LEVEL_DEBUG, this].concat(params));
  }

  function doLog(level, _this) {
    var message = '';
    var logTime = null;

    if (showLogTimestamp) {
      logTime = new Date().getTime();
      message += '[' + (logTime - startTime) + ']';
    }

    if (showCalleeName && _this && _this.getClassName) {
      message += '[' + _this.getClassName() + ']';

      if (_this.getType) {
        message += '[' + _this.getType() + ']';
      }
    }

    if (message.length > 0) {
      message += ' ';
    }

    for (var _len6 = arguments.length, params = new Array(_len6 > 2 ? _len6 - 2 : 0), _key6 = 2; _key6 < _len6; _key6++) {
      params[_key6 - 2] = arguments[_key6];
    }

    Array.apply(null, params).forEach(function (item) {
      message += item + ' ';
    }); // log to console if the log level is high enough

    if (logFn[level] && settings && settings.get().debug.logLevel >= level) {
      logFn[level](message);
    } // send log event regardless of log level


    if (settings && settings.get().debug.dispatchEvent) {
      eventBus.trigger(_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].LOG, {
        message: message,
        level: level
      });
    }
  }

  instance = {
    getLogger: getLogger,
    setLogTimestampVisible: setLogTimestampVisible,
    setCalleeNameVisible: setCalleeNameVisible
  };
  setup();
  return instance;
}

Debug.__dashjs_factory_name = 'Debug';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(Debug);
factory.LOG_LEVEL_NONE = LOG_LEVEL_NONE;
factory.LOG_LEVEL_FATAL = LOG_LEVEL_FATAL;
factory.LOG_LEVEL_ERROR = LOG_LEVEL_ERROR;
factory.LOG_LEVEL_WARNING = LOG_LEVEL_WARNING;
factory.LOG_LEVEL_INFO = LOG_LEVEL_INFO;
factory.LOG_LEVEL_DEBUG = LOG_LEVEL_DEBUG;
_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].updateSingletonFactory(Debug.__dashjs_factory_name, factory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/core/EventBus.js":
/*!******************************!*\
  !*** ./src/core/EventBus.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


var EVENT_PRIORITY_LOW = 0;
var EVENT_PRIORITY_HIGH = 5000;

function EventBus() {
  var handlers = {};

  function on(type, listener, scope) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    if (!type) {
      throw new Error('event type cannot be null or undefined');
    }

    if (!listener || typeof listener !== 'function') {
      throw new Error('listener must be a function: ' + listener);
    }

    var priority = options.priority || EVENT_PRIORITY_LOW;
    if (getHandlerIdx(type, listener, scope) >= 0) return;
    handlers[type] = handlers[type] || [];
    var handler = {
      callback: listener,
      scope: scope,
      priority: priority
    };

    if (scope && scope.getStreamId) {
      handler.streamId = scope.getStreamId();
    }

    if (scope && scope.getType) {
      handler.mediaType = scope.getType();
    }

    if (options && options.mode) {
      handler.mode = options.mode;
    }

    var inserted = handlers[type].some(function (item, idx) {
      if (item && priority > item.priority) {
        handlers[type].splice(idx, 0, handler);
        return true;
      }
    });

    if (!inserted) {
      handlers[type].push(handler);
    }
  }

  function off(type, listener, scope) {
    if (!type || !listener || !handlers[type]) return;
    var idx = getHandlerIdx(type, listener, scope);
    if (idx < 0) return;
    handlers[type][idx] = null;
  }

  function trigger(type) {
    var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var filters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    if (!type || !handlers[type]) return;
    payload = payload || {};
    if (payload.hasOwnProperty('type')) throw new Error('\'type\' is a reserved word for event dispatching');
    payload.type = type;

    if (filters.streamId) {
      payload.streamId = filters.streamId;
    }

    if (filters.mediaType) {
      payload.mediaType = filters.mediaType;
    }

    handlers[type].filter(function (handler) {
      if (!handler) {
        return false;
      }

      if (filters.streamId && handler.streamId && handler.streamId !== filters.streamId) {
        return false;
      }

      if (filters.mediaType && handler.mediaType && handler.mediaType !== filters.mediaType) {
        return false;
      } // This is used for dispatching DASH events. By default we use the onStart mode. Consequently we filter everything that has a non matching mode and the onReceive events for handlers that did not specify a mode.


      if (filters.mode && handler.mode && handler.mode !== filters.mode || !handler.mode && filters.mode && filters.mode === _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_MODE_ON_RECEIVE) {
        return false;
      }

      return true;
    }).forEach(function (handler) {
      return handler && handler.callback.call(handler.scope, payload);
    });
  }

  function getHandlerIdx(type, listener, scope) {
    var idx = -1;
    if (!handlers[type]) return idx;
    handlers[type].some(function (item, index) {
      if (item && item.callback === listener && (!scope || scope === item.scope)) {
        idx = index;
        return true;
      }
    });
    return idx;
  }

  function reset() {
    handlers = {};
  }

  var instance = {
    on: on,
    off: off,
    trigger: trigger,
    reset: reset
  };
  return instance;
}

EventBus.__dashjs_factory_name = 'EventBus';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(EventBus);
factory.EVENT_PRIORITY_LOW = EVENT_PRIORITY_LOW;
factory.EVENT_PRIORITY_HIGH = EVENT_PRIORITY_HIGH;
_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].updateSingletonFactory(EventBus.__dashjs_factory_name, factory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/core/FactoryMaker.js":
/*!**********************************!*\
  !*** ./src/core/FactoryMaker.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module FactoryMaker
 * @ignore
 */
var FactoryMaker = function () {
  var instance;
  var singletonContexts = [];
  var singletonFactories = {};
  var classFactories = {};

  function extend(name, childInstance, override, context) {
    if (!context[name] && childInstance) {
      context[name] = {
        instance: childInstance,
        override: override
      };
    }
  }
  /**
   * Use this method from your extended object.  this.factory is injected into your object.
   * this.factory.getSingletonInstance(this.context, 'VideoModel')
   * will return the video model for use in the extended object.
   *
   * @param {Object} context - injected into extended object as this.context
   * @param {string} className - string name found in all dash.js objects
   * with name __dashjs_factory_name Will be at the bottom. Will be the same as the object's name.
   * @returns {*} Context aware instance of specified singleton name.
   * @memberof module:FactoryMaker
   * @instance
   */


  function getSingletonInstance(context, className) {
    for (var i in singletonContexts) {
      var obj = singletonContexts[i];

      if (obj.context === context && obj.name === className) {
        return obj.instance;
      }
    }

    return null;
  }
  /**
   * Use this method to add an singleton instance to the system.  Useful for unit testing to mock objects etc.
   *
   * @param {Object} context
   * @param {string} className
   * @param {Object} instance
   * @memberof module:FactoryMaker
   * @instance
   */


  function setSingletonInstance(context, className, instance) {
    for (var i in singletonContexts) {
      var obj = singletonContexts[i];

      if (obj.context === context && obj.name === className) {
        singletonContexts[i].instance = instance;
        return;
      }
    }

    singletonContexts.push({
      name: className,
      context: context,
      instance: instance
    });
  }
  /**
   * Use this method to remove all singleton instances associated with a particular context.
   *
   * @param {Object} context
   * @memberof module:FactoryMaker
   * @instance
   */


  function deleteSingletonInstances(context) {
    singletonContexts = singletonContexts.filter(function (x) {
      return x.context !== context;
    });
  }
  /*------------------------------------------------------------------------------------------*/
  // Factories storage Management

  /*------------------------------------------------------------------------------------------*/


  function getFactoryByName(name, factoriesArray) {
    return factoriesArray[name];
  }

  function updateFactory(name, factory, factoriesArray) {
    if (name in factoriesArray) {
      factoriesArray[name] = factory;
    }
  }
  /*------------------------------------------------------------------------------------------*/
  // Class Factories Management

  /*------------------------------------------------------------------------------------------*/


  function updateClassFactory(name, factory) {
    updateFactory(name, factory, classFactories);
  }

  function getClassFactoryByName(name) {
    return getFactoryByName(name, classFactories);
  }

  function getClassFactory(classConstructor) {
    var factory = getFactoryByName(classConstructor.__dashjs_factory_name, classFactories);

    if (!factory) {
      factory = function factory(context) {
        if (context === undefined) {
          context = {};
        }

        return {
          create: function create() {
            return merge(classConstructor, context, arguments);
          }
        };
      };

      classFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }

    return factory;
  }
  /*------------------------------------------------------------------------------------------*/
  // Singleton Factory MAangement

  /*------------------------------------------------------------------------------------------*/


  function updateSingletonFactory(name, factory) {
    updateFactory(name, factory, singletonFactories);
  }

  function getSingletonFactoryByName(name) {
    return getFactoryByName(name, singletonFactories);
  }

  function getSingletonFactory(classConstructor) {
    var factory = getFactoryByName(classConstructor.__dashjs_factory_name, singletonFactories);

    if (!factory) {
      factory = function factory(context) {
        var instance;

        if (context === undefined) {
          context = {};
        }

        return {
          getInstance: function getInstance() {
            // If we don't have an instance yet check for one on the context
            if (!instance) {
              instance = getSingletonInstance(context, classConstructor.__dashjs_factory_name);
            } // If there's no instance on the context then create one


            if (!instance) {
              instance = merge(classConstructor, context, arguments);
              singletonContexts.push({
                name: classConstructor.__dashjs_factory_name,
                context: context,
                instance: instance
              });
            }

            return instance;
          }
        };
      };

      singletonFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }

    return factory;
  }

  function merge(classConstructor, context, args) {
    var classInstance;
    var className = classConstructor.__dashjs_factory_name;
    var extensionObject = context[className];

    if (extensionObject) {
      var extension = extensionObject.instance;

      if (extensionObject.override) {
        //Override public methods in parent but keep parent.
        classInstance = classConstructor.apply({
          context: context
        }, args);
        extension = extension.apply({
          context: context,
          factory: instance,
          parent: classInstance
        }, args);

        for (var prop in extension) {
          if (classInstance.hasOwnProperty(prop)) {
            classInstance[prop] = extension[prop];
          }
        }
      } else {
        //replace parent object completely with new object. Same as dijon.
        return extension.apply({
          context: context,
          factory: instance
        }, args);
      }
    } else {
      // Create new instance of the class
      classInstance = classConstructor.apply({
        context: context
      }, args);
    } // Add getClassName function to class instance prototype (used by Debug)


    classInstance.getClassName = function () {
      return className;
    };

    return classInstance;
  }

  instance = {
    extend: extend,
    getSingletonInstance: getSingletonInstance,
    setSingletonInstance: setSingletonInstance,
    deleteSingletonInstances: deleteSingletonInstances,
    getSingletonFactory: getSingletonFactory,
    getSingletonFactoryByName: getSingletonFactoryByName,
    updateSingletonFactory: updateSingletonFactory,
    getClassFactory: getClassFactory,
    getClassFactoryByName: getClassFactoryByName,
    updateClassFactory: updateClassFactory
  };
  return instance;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FactoryMaker);

/***/ }),

/***/ "./src/core/Settings.js":
/*!******************************!*\
  !*** ./src/core/Settings.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ "./src/core/Utils.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./events/Events */ "./src/core/events/Events.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */







/** @module Settings
 * @description Define the configuration parameters of Dash.js MediaPlayer.
 * @see {@link module:Settings~PlayerSettings PlayerSettings} for further information about the supported configuration properties.
 */

/**
 * @typedef {Object} PlayerSettings
 * @property {module:Settings~DebugSettings} [debug]
 * Debug related settings.
 * @property {module:Settings~ErrorSettings} [errors]
 * Error related settings
 * @property {module:Settings~StreamingSettings} [streaming]
 * Streaming related settings.
 * @example
 *
 * // Full settings object
 * settings = {
 *        debug: {
 *            logLevel: Debug.LOG_LEVEL_WARNING,
 *            dispatchEvent: false
 *        },
 *        streaming: {
 *            abandonLoadTimeout: 10000,
 *            wallclockTimeUpdateInterval: 100,
 *            manifestUpdateRetryInterval: 100,
 *            cacheInitSegments: true,
 *            applyServiceDescription: true,
 *            applyProducerReferenceTime: true,
 *            applyContentSteering: true,
 *            eventControllerRefreshDelay: 100,
 *            enableManifestDurationMismatchFix: true,
 *            enableManifestTimescaleMismatchFix: false,
 *            capabilities: {
 *               filterUnsupportedEssentialProperties: true,
 *               useMediaCapabilitiesApi: false
 *            },
 *            timeShiftBuffer: {
 *                calcFromSegmentTimeline: false,
 *                fallbackToSegmentTimeline: true
 *            },
 *            metrics: {
 *              maxListDepth: 100
 *            },
 *            delay: {
 *                liveDelayFragmentCount: NaN,
 *                liveDelay: NaN,
 *                useSuggestedPresentationDelay: true
 *            },
 *            protection: {
 *                keepProtectionMediaKeys: false,
 *                ignoreEmeEncryptedEvent: false,
 *                detectPlayreadyMessageFormat: true,
 *            },
 *            buffer: {
 *                enableSeekDecorrelationFix: true,
 *                fastSwitchEnabled: true,
 *                flushBufferAtTrackSwitch: false,
 *                reuseExistingSourceBuffers: true,
 *                bufferPruningInterval: 10,
 *                bufferToKeep: 20,
 *                bufferTimeAtTopQuality: 30,
 *                bufferTimeAtTopQualityLongForm: 60,
 *                initialBufferLevel: NaN,
 *                stableBufferTime: 12,
 *                longFormContentDurationThreshold: 600,
 *                stallThreshold: 0.5,
 *                useAppendWindow: true,
 *                setStallState: true,
 *                avoidCurrentTimeRangePruning: false,
 *                useChangeTypeForTrackSwitch: true
 *            },
 *            gaps: {
 *                jumpGaps: true,
 *                jumpLargeGaps: true,
 *                smallGapLimit: 1.5,
 *                threshold: 0.3,
 *                enableSeekFix: true,
 *                enableStallFix: false,
 *                stallSeek: 0.1
 *            },
 *            utcSynchronization: {
 *                enabled: true,
 *                useManifestDateHeaderTimeSource: true,
 *                backgroundAttempts: 2,
 *                timeBetweenSyncAttempts: 30,
 *                maximumTimeBetweenSyncAttempts: 600,
 *                minimumTimeBetweenSyncAttempts: 2,
 *                timeBetweenSyncAttemptsAdjustmentFactor: 2,
 *                maximumAllowedDrift: 100,
 *                enableBackgroundSyncAfterSegmentDownloadError: true,
 *                defaultTimingSource: {
 *                    scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
 *                    value: 'http://time.akamai.com/?iso&ms'
 *                }
 *            },
 *            scheduling: {
 *                defaultTimeout: 300,
 *                lowLatencyTimeout: 100,
 *                scheduleWhilePaused: true
 *            },
 *            text: {
 *                defaultEnabled: true,
 *                extendSegmentedCues: true,
 *                webvtt: {
 *                    customRenderingEnabled: false
 *                }
 *            },
 *            liveCatchup: {
 *                maxDrift: NaN,
 *                playbackRate: {min: NaN, max: NaN},
 *                playbackBufferMin: 0.5,
 *                enabled: false,
 *                mode: Constants.LIVE_CATCHUP_MODE_DEFAULT
 *            },
 *            lastBitrateCachingInfo: { enabled: true, ttl: 360000 },
 *            lastMediaSettingsCachingInfo: { enabled: true, ttl: 360000 },
 *            cacheLoadThresholds: { video: 50, audio: 5 },
 *            trackSwitchMode: {
 *                audio: Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE,
 *                video: Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 *            },
 *            selectionModeForInitialTrack: Constants.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY,
 *            fragmentRequestTimeout: 20000,
 *            manifestRequestTimeout: 10000,
 *            retryIntervals: {
 *                [HTTPRequest.MPD_TYPE]: 500,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 500,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.LICENSE]: 1000,
 *                [HTTPRequest.OTHER_TYPE]: 1000,
 *                lowLatencyReductionFactor: 10
 *            },
 *            retryAttempts: {
 *                [HTTPRequest.MPD_TYPE]: 3,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 1,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.LICENSE]: 3,
 *                [HTTPRequest.OTHER_TYPE]: 3,
 *                lowLatencyMultiplyFactor: 5
 *            },
 *            abr: {
 *                movingAverageMethod: Constants.MOVING_AVERAGE_SLIDING_WINDOW,
 *                ABRStrategy: Constants.ABR_STRATEGY_DYNAMIC,
 *                additionalAbrRules: {
 *                   insufficientBufferRule: false,
 *                   switchHistoryRule: true,
 *                   droppedFramesRule: true,
 *                   abandonRequestsRule: false
 *                },
 *                bandwidthSafetyFactor: 0.9,
 *                useDefaultABRRules: true,
 *                useDeadTimeLatency: true,
 *                limitBitrateByPortal: false,
 *                usePixelRatioInLimitBitrateByPortal: false,
 *                maxBitrate: { audio: -1, video: -1 },
 *                minBitrate: { audio: -1, video: -1 },
 *                maxRepresentationRatio: { audio: 1, video: 1 },
 *                initialBitrate: { audio: -1, video: -1 },
 *                initialRepresentationRatio: { audio: -1, video: -1 },
 *                autoSwitchBitrate: { audio: true, video: true },
 *                fetchThroughputCalculationMode: Constants.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA
 *            },
 *            cmcd: {
 *                enabled: false,
 *                sid: null,
 *                cid: null,
 *                rtp: null,
 *                rtpSafetyFactor: 5,
 *                mode: Constants.CMCD_MODE_QUERY,
 *                enabledKeys: ['br', 'd', 'ot', 'tb' , 'bl', 'dl', 'mtp', 'nor', 'nrr', 'su' , 'bs', 'rtp' , 'cid', 'pr', 'sf', 'sid', 'st', 'v']
 *            },
 *            cmsd: {
 *                enabled: false,
 *                abr: {
 *                    applyMb: false,
 *                    etpWeightRatio: 0
 *                }
 *           }
 *          },
 *          errors: {
 *            recoverAttempts: {
 *                mediaErrorDecode: 5
 *             }
 *          }
 * }
 */

/**
 * @typedef {Object} TimeShiftBuffer
 * @property {boolean} [calcFromSegmentTimeline=false]
 * Enable calculation of the DVR window for SegmentTimeline manifests based on the entries in \<SegmentTimeline\>.
 *  * @property {boolean} [fallbackToSegmentTimeline=true]
 * In case the MPD uses \<SegmentTimeline\ and no segment is found within the DVR window the DVR window is calculated based on the entries in \<SegmentTimeline\>.
 */

/**
 * @typedef {Object} LiveDelay
 * @property {number} [liveDelayFragmentCount=NaN]
 * Changing this value will lower or increase live stream latency.
 *
 * The detected segment duration will be multiplied by this value to define a time in seconds to delay a live stream from the live edge.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 * @property {number} [liveDelay]
 * Equivalent in seconds of setLiveDelayFragmentCount.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 *
 * This value should be less than the manifest duration by a couple of segment durations to avoid playback issues.
 *
 * If set, this parameter will take precedence over setLiveDelayFragmentCount and manifest info.
 * @property {boolean} [useSuggestedPresentationDelay=true]
 * Set to true if you would like to overwrite the default live delay and honor the SuggestedPresentationDelay attribute in by the manifest.
 */

/**
 * @typedef {Object} Buffer
 * @property {boolean} [enableSeekDecorrelationFix=false]
 * Enables a workaround for playback start on some devices, e.g. WebOS 4.9.
 * It is necessary because some browsers do not support setting currentTime on video element to a value that is outside of current buffer.
 *
 * If you experience unexpected seeking triggered by BufferController, you can try setting this value to false.

 * @property {boolean} [fastSwitchEnabled=true]
 * When enabled, after an ABR up-switch in quality, instead of requesting and appending the next fragment at the end of the current buffer range it is requested and appended closer to the current time.
 *
 * When enabled, The maximum time to render a higher quality is current time + (1.5 * fragment duration).
 *
 * Note, When ABR down-switch is detected, we appended the lower quality at the end of the buffer range to preserve the
 * higher quality media for as long as possible.
 *
 * If enabled, it should be noted there are a few cases when the client will not replace inside buffer range but rather just append at the end.
 * 1. When the buffer level is less than one fragment duration.
 * 2. The client is in an Abandonment State due to recent fragment abandonment event.
 *
 * Known issues:
 * 1. In IE11 with auto switching off, if a user switches to a quality they can not download in time the fragment may be appended in the same range as the playhead or even in the past, in IE11 it may cause a stutter or stall in playback.
 * @property {boolean} [flushBufferAtTrackSwitch=false]
 * When enabled, after a track switch and in case buffer is being replaced, the video element is flushed (seek at current playback time) once a segment of the new track is appended in buffer in order to force video decoder to play new track.
 *
 * This can be required on some devices like GoogleCast devices to make track switching functional.
 *
 * Otherwise track switching will be effective only once after previous buffered track is fully consumed.
 * @property {boolean} [reuseExistingSourceBuffers=true]
 * Enable reuse of existing MediaSource Sourcebuffers during period transition.
 * @property {number} [bufferPruningInterval=10]
 * The interval of pruning buffer in seconds.
 * @property {number} [bufferToKeep=20]
 * This value influences the buffer pruning logic.
 *
 * Allows you to modify the buffer that is kept in source buffer in seconds.
 * 0|-----------bufferToPrune-----------|-----bufferToKeep-----|currentTime|
 * @property {number} [bufferTimeAtTopQuality=30]
 * The time that the internal buffer target will be set to once playing the top quality.
 *
 * If there are multiple bitrates in your adaptation, and the media is playing at the highest bitrate, then we try to build a larger buffer at the top quality to increase stability and to maintain media quality.
 * @property {number} [bufferTimeAtTopQualityLongForm=60]
 * The time that the internal buffer target will be set to once playing the top quality for long form content.
 * @property {number} [longFormContentDurationThreshold=600]
 * The threshold which defines if the media is considered long form content.
 *
 * This will directly affect the buffer targets when playing back at the top quality.
 * @property {number} [initialBufferLevel=NaN]
 * Initial buffer level before playback starts
 * @property {number} [stableBufferTime=12]
 * The time that the internal buffer target will be set to post startup/seeks (NOT top quality).
 *
 * When the time is set higher than the default you will have to wait longer to see automatic bitrate switches but will have a larger buffer which will increase stability.
 * @property {number} [stallThreshold=0.3]
 * Stall threshold used in BufferController.js to determine whether a track should still be changed and which buffer range to prune.
 * @property {boolean} [useAppendWindow=true]
 * Specifies if the appendWindow attributes of the MSE SourceBuffers should be set according to content duration from manifest.
 * @property {boolean} [setStallState=true]
 * Specifies if we fire manual waiting events once the stall threshold is reached
 * @property {boolean} [avoidCurrentTimeRangePruning=false]
 * Avoids pruning of the buffered range that contains the current playback time.
 *
 * That buffered range is likely to have been enqueued for playback. Pruning it causes a flush and reenqueue in WPE and WebKitGTK based browsers. This stresses the video decoder and can cause stuttering on embedded platforms.
 * @property {boolean} [useChangeTypeForTrackSwitch=true]
 * If this flag is set to true then dash.js will use the MSE v.2 API call "changeType()" before switching to a different track.
 * Note that some platforms might not implement the changeType functio. dash.js is checking for the availability before trying to call it.
 */

/**
 * @typedef {Object} module:Settings~AudioVideoSettings
 * @property {number|boolean|string} [audio]
 * Configuration for audio media type of tracks.
 * @property {number|boolean|string} [video]
 * Configuration for video media type of tracks.
 */

/**
 * @typedef {Object} DebugSettings
 * @property {number} [logLevel=dashjs.Debug.LOG_LEVEL_WARNING]
 * Sets up the log level. The levels are cumulative.
 *
 * For example, if you set the log level to dashjs.Debug.LOG_LEVEL_WARNING all warnings, errors and fatals will be logged.
 *
 * Possible values.
 *
 * - dashjs.Debug.LOG_LEVEL_NONE
 * No message is written in the browser console.
 *
 * - dashjs.Debug.LOG_LEVEL_FATAL
 * Log fatal errors.
 * An error is considered fatal when it causes playback to fail completely.
 *
 * - dashjs.Debug.LOG_LEVEL_ERROR
 * Log error messages.
 *
 * - dashjs.Debug.LOG_LEVEL_WARNING
 * Log warning messages.
 *
 * - dashjs.Debug.LOG_LEVEL_INFO
 * Log info messages.
 *
 * - dashjs.Debug.LOG_LEVEL_DEBUG
 * Log debug messages.
 * @property {boolean} [dispatchEvent=false]
 * Enable to trigger a Events.LOG event whenever log output is generated.
 *
 * Note this will be dispatched regardless of log level.
 */

/**
 * @typedef {Object} module:Settings~ErrorSettings
 * @property {object} [recoverAttempts={mediaErrorDecode: 5}]
 * Defines the maximum number of recover attempts for specific media errors.
 *
 * For mediaErrorDecode the player will reset the MSE and skip the blacklisted segment that caused the decode error. The resulting gap will be handled by the GapController.
 */

/**
 * @typedef {Object} CachingInfoSettings
 * @property {boolean} [enable]
 * Enable or disable the caching feature.
 * @property {number} [ttl]
 * Time to live.
 *
 * A value defined in milliseconds representing how log to cache the settings for.
 */

/**
 * @typedef {Object} Gaps
 * @property {boolean} [jumpGaps=true]
 * Sets whether player should jump small gaps (discontinuities) in the buffer.
 * @property {boolean} [jumpLargeGaps=true]
 * Sets whether player should jump large gaps (discontinuities) in the buffer.
 * @property {number} [smallGapLimit=1.5]
 * Time in seconds for a gap to be considered small.
 * @property {number} [threshold=0.3]
 * Threshold at which the gap handling is executed. If currentRangeEnd - currentTime < threshold the gap jump will be triggered.
 * For live stream the jump might be delayed to keep a consistent live edge.
 * Note that the amount of buffer at which platforms automatically stall might differ.
 * @property {boolean} [enableSeekFix=true]
 * Enables the adjustment of the seek target once no valid segment request could be generated for a specific seek time. This can happen if the user seeks to a position for which there is a gap in the timeline.
 * @property {boolean} [enableStallFix=false]
 * If playback stalled in a buffered range this fix will perform a seek by the value defined in stallSeek to trigger playback again.
 * @property {number} [stallSeek=0.1]
 * Value to be used in case enableStallFix is set to true
 */

/**
 * @typedef {Object} UtcSynchronizationSettings
 * @property {boolean} [enabled=true]
 * Enables or disables the UTC clock synchronization
 * @property {boolean} [useManifestDateHeaderTimeSource=true]
 * Allows you to enable the use of the Date Header, if exposed with CORS, as a timing source for live edge detection.
 *
 * The use of the date header will happen only after the other timing source that take precedence fail or are omitted as described.
 * @property {number} [backgroundAttempts=2]
 * Number of synchronization attempts to perform in the background after an initial synchronization request has been done. This is used to verify that the derived client-server offset is correct.
 *
 * The background requests are async and done in parallel to the start of the playback.
 *
 * This value is also used to perform a resync after 404 errors on segments.
 * @property {number} [timeBetweenSyncAttempts=30]
 * The time in seconds between two consecutive sync attempts.
 *
 * Note: This value is used as an initial starting value. The internal value of the TimeSyncController is adjusted during playback based on the drift between two consecutive synchronization attempts.
 *
 * Note: A sync is only performed after an MPD update. In case the @minimumUpdatePeriod is larger than this value the sync will be delayed until the next MPD update.
 * @property {number} [maximumTimeBetweenSyncAttempts=600]
 * The maximum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [minimumTimeBetweenSyncAttempts=2]
 * The minimum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [timeBetweenSyncAttemptsAdjustmentFactor=2]
 * The factor used to multiply or divide the timeBetweenSyncAttempts parameter after a sync. The maximumAllowedDrift defines whether this value is used as a factor or a dividend.
 *
 * @property {number} [maximumAllowedDrift=100]
 * The maximum allowed drift specified in milliseconds between two consecutive synchronization attempts.
 *
 * @property {boolean} [enableBackgroundSyncAfterSegmentDownloadError=true]
 * Enables or disables the background sync after the player ran into a segment download error.
 *
 * @property {object} [defaultTimingSource={scheme:'urn:mpeg:dash:utc:http-xsdate:2014',value: 'http://time.akamai.com/?iso&ms'}]
 * The default timing source to be used. The timing sources in the MPD take precedence over this one.
 */

/**
 * @typedef {Object} Scheduling
 * @property {number} [defaultTimeout=300]
 * Default timeout between two consecutive segment scheduling attempts
 * @property {number} [lowLatencyTimeout]
 * Default timeout between two consecutive low-latency segment scheduling attempts
 * @property {boolean} [scheduleWhilePaused=true]
 * Set to true if you would like dash.js to keep downloading fragments in the background when the video element is paused.
 */

/**
 * @typedef {Object} Text
 * @property {number} [defaultEnabled=true]
 * Enable/disable subtitle rendering by default.
 * @property {boolean} [extendSegmentedCues=true]
 * Enable/disable patching of segmented cues in order to merge as a single cue by extending cue end time.
 * @property {object} [webvtt={customRenderingEnabled=false}]
 * Enables the custom rendering for WebVTT captions. For details refer to the "Subtitles and Captions" sample section of dash.js.
 * Custom WebVTT rendering requires the external library vtt.js that can be found in the contrib folder.
 */

/**
 * @typedef {Object} LiveCatchupSettings
 * @property {number} [maxDrift=NaN]
 * Use this method to set the maximum latency deviation allowed before dash.js to do a seeking to live position.
 *
 * In low latency mode, when the difference between the measured latency and the target one, as an absolute number, is higher than the one sets with this method, then dash.js does a seek to live edge position minus the target live delay.
 *
 * LowLatencyMaxDriftBeforeSeeking should be provided in seconds.
 *
 * If 0, then seeking operations won't be used for fixing latency deviations.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackRate={min: NaN, max: NaN}]
 * Use this parameter to set the minimum and maximum catch up rates, as percentages, for low latency live streams.
 *
 * In low latency mode, when measured latency is higher/lower than the target one, dash.js increases/decreases playback rate respectively up to (+/-) the percentage defined with this method until target is reached.
 *
 * Valid values for min catch up rate are in the range -0.5 to 0 (-50% to 0% playback rate decrease)
 *
 * Valid values for max catch up rate are in the range 0 to 1 (0% to 100% playback rate increase).
 *
 * Set min and max to NaN to turn off live catch up feature.
 *
 * These playback rate limits take precedence over any PlaybackRate values in ServiceDescription elements in an MPD. If only one of the min/max properties is given a value, the property without a value will not fall back to a ServiceDescription value. Its default value of NaN will be used.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackBufferMin=NaN]
 * Use this parameter to specify the minimum buffer which is used for LoL+ based playback rate reduction.
 *
 *
 * @property {boolean} [enabled=false]
 * Use this parameter to enable the catchup mode for non low-latency streams.
 *
 * @property {string} [mode="liveCatchupModeDefault"]
 * Use this parameter to switch between different catchup modes.
 *
 * Options: "liveCatchupModeDefault" or "liveCatchupModeLOLP".
 *
 * Note: Catch-up mechanism is automatically applied when playing low latency live streams.
 */

/**
 * @typedef {Object} RequestTypeSettings
 * @property {number} [MPD]
 * Manifest type of requests.
 * @property {number} [XLinkExpansion]
 * XLink expansion type of requests.
 * @property {number} [InitializationSegment]
 * Request to retrieve an initialization segment.
 * @property {number} [IndexSegment]
 * Request to retrieve an index segment (SegmentBase).
 * @property {number} [MediaSegment]
 * Request to retrieve a media segment (video/audio/image/text chunk).
 * @property {number} [BitstreamSwitchingSegment]
 * Bitrate stream switching type of request.
 * @property {number} [FragmentInfoSegment]
 * Request to retrieve a FragmentInfo segment (specific to Smooth Streaming live streams).
 * @property {number} [other]
 * Other type of request.
 * @property {number} [lowLatencyReductionFactor]
 * For low latency mode, values of type of request are divided by lowLatencyReductionFactor.
 *
 * Note: It's not type of request.
 * @property {number} [lowLatencyMultiplyFactor]
 * For low latency mode, values of type of request are multiplied by lowLatencyMultiplyFactor.
 *
 * Note: It's not type of request.
 */

/**
 * @typedef {Object} Protection
 * @property {boolean} [keepProtectionMediaKeys=false]
 * Set the value for the ProtectionController and MediaKeys life cycle.
 *
 * If true, the ProtectionController and then created MediaKeys and MediaKeySessions will be preserved during the MediaPlayer lifetime.
 * @property {boolean} ignoreEmeEncryptedEvent
 * If set to true the player will ignore "encrypted" and "needkey" events thrown by the EME.
 *
 * @property {boolean} detectPlayreadyMessageFormat
 * If set to true the player will use the raw unwrapped message from the Playready CDM
 */

/**
 * @typedef {Object} Capabilities
 * @property {boolean} [filterUnsupportedEssentialProperties=true]
 * Enable to filter all the AdaptationSets and Representations which contain an unsupported \<EssentialProperty\> element.
 * @property {boolean} [useMediaCapabilitiesApi=false]
 * Enable to use the MediaCapabilities API to check whether codecs are supported. If disabled MSE.isTypeSupported will be used instead.
 */

/**
 * @typedef {Object} AbrSettings
 * @property {string} [movingAverageMethod="slidingWindow"]
 * Sets the moving average method used for smoothing throughput estimates.
 *
 * Valid methods are "slidingWindow" and "ewma".
 *
 * The call has no effect if an invalid method is passed.
 *
 * The sliding window moving average method computes the average throughput using the last four segments downloaded.
 *
 * If the stream is live (as opposed to VOD), then only the last three segments are used.
 *
 * If wide variations in throughput are detected, the number of segments can be dynamically increased to avoid oscillations.
 *
 * The exponentially weighted moving average (EWMA) method computes the average using exponential smoothing.
 *
 * Two separate estimates are maintained, a fast one with a three-second half life and a slow one with an eight-second half life.
 *
 * The throughput estimate at any time is the minimum of the fast and slow estimates.
 *
 * This allows a fast reaction to a bandwidth drop and prevents oscillations on bandwidth spikes.
 * @property {string} [ABRStrategy="abrDynamic"]
 * Returns the current ABR strategy being used: "abrDynamic", "abrBola" or "abrThroughput".
 * @property {object} [trackSwitchMode={video: "neverReplace", audio: "alwaysReplace"}]
 * @property {object} [additionalAbrRules={insufficientBufferRule: false,switchHistoryRule: true,droppedFramesRule: true,abandonRequestsRule: false}]
 * Enable/Disable additional ABR rules in case ABRStrategy is set to "abrDynamic", "abrBola" or "abrThroughput".
 * @property {number} [bandwidthSafetyFactor=0.9]
 * Standard ABR throughput rules multiply the throughput by this value.
 *
 * It should be between 0 and 1, with lower values giving less rebuffering (but also lower quality).
 * @property {boolean} [useDefaultABRRules=true]
 * Should the default ABR rules be used, or the custom ones added.
 * @property {boolean} [useDeadTimeLatency=true]
 * If true, only the download portion will be considered part of the download bitrate and latency will be regarded as static.
 *
 * If false, the reciprocal of the whole transfer time will be used.
 * @property {boolean} [limitBitrateByPortal=false]
 * If true, the size of the video portal will limit the max chosen video resolution.
 * @property {boolean} [usePixelRatioInLimitBitrateByPortal=false]
 * Sets whether to take into account the device's pixel ratio when defining the portal dimensions.
 *
 * Useful on, for example, retina displays.
 * @property {module:Settings~AudioVideoSettings} [maxBitrate={audio: -1, video: -1}]
 * The maximum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [minBitrate={audio: -1, video: -1}]
 * The minimum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [maxRepresentationRatio={audio: 1, video: 1}]
 * When switching multi-bitrate content (auto or manual mode) this property specifies the maximum representation allowed, as a proportion of the size of the representation set.
 *
 * You can set or remove this cap at anytime before or during playback.
 *
 * To clear this setting you set the value to 1.
 *
 * If both this and maxAllowedBitrate are defined, maxAllowedBitrate is evaluated first, then maxAllowedRepresentation, i.e. the lowest value from executing these rules is used.
 *
 * This feature is typically used to reserve higher representations for playback only when connected over a fast connection.
 * @property {module:Settings~AudioVideoSettings} [initialBitrate={audio: -1, video: -1}]
 * Explicitly set the starting bitrate for audio or video. This value is specified in kbps.
 *
 * Use -1 to let the player decide.
 * @property {module:Settings~AudioVideoSettings} [initialRepresentationRatio={audio: -1, video: -1}]
 * Explicitly set the initial representation ratio.
 *
 * If initalBitrate is specified, this is ignored.
 * @property {module:Settings~AudioVideoSettings} [autoSwitchBitrate={audio: true, video: true}]
 * Indicates whether the player should enable ABR algorithms to switch the bitrate.
 *
 * @property {string} [fetchThroughputCalculationMode="abrFetchThroughputCalculationDownloadedData"]
 * Algorithm to determine the throughput in case the Fetch API is used for low latency streaming.
 *
 * For details please check the samples section and FetchLoader.js.
 */

/**
 * @typedef {Object} module:Settings~CmcdSettings
 * @property {boolean} [enable=false]
 * Enable or disable the CMCD reporting.
 * @property {string} [sid]
 * GUID identifying the current playback session.
 *
 * Should be in UUID format.
 *
 * If not specified a UUID will be automatically generated.
 * @property {string} [cid]
 * A unique string to identify the current content.
 *
 * If not specified it will be a hash of the MPD url.
 * @property {number} [rtp]
 * The requested maximum throughput that the client considers sufficient for delivery of the asset.
 *
 * If not specified this value will be dynamically calculated in the CMCDModel based on the current buffer level.
 * @property {number} [rtpSafetyFactor]
 * This value is used as a factor for the rtp value calculation: rtp = minBandwidth * rtpSafetyFactor
 *
 * If not specified this value defaults to 5. Note that this value is only used when no static rtp value is defined.
 * @property {number} [mode]
 * The method to use to attach cmcd metrics to the requests. 'query' to use query parameters, 'header' to use http headers.
 *
 * If not specified this value defaults to 'query'.
 * @property {Array.<string>} [enabledKeys]
 * This value is used to specify the desired CMCD parameters. Parameters not included in this list are not reported.
 */

/**
 * @typedef {Object} module:Settings~CmsdSettings
 * @property {boolean} [enabled=false]
 * Enable or disable the CMSD response headers parsing.
 * @property {module:Settings~CmsdAbrSettings} [abr]
 * Sets additional ABR rules based on CMSD response headers.
 */

/**
 * @typedef {Object} CmsdAbrSettings
 * @property {boolean} [applyMb=false]
 * Set to true if dash.js should apply CMSD maximum suggested bitrate in ABR logic.
 * @property {number} [etpWeightRatio=0]
 * Sets the weight ratio (between 0 and 1) that shall be applied on CMSD estimated throuhgput compared to measured throughput when calculating throughput.
 */

/**
 * @typedef {Object} Metrics
 * @property {number} [metricsMaxListDepth=100]
 * Maximum number of metrics that are persisted per type.
 */

/**
 * @typedef {Object} StreamingSettings
 * @property {number} [abandonLoadTimeout=10000]
 * A timeout value in seconds, which during the ABRController will block switch-up events.
 *
 * This will only take effect after an abandoned fragment event occurs.
 * @property {number} [wallclockTimeUpdateInterval=50]
 * How frequently the wallclockTimeUpdated internal event is triggered (in milliseconds).
 * @property {number} [manifestUpdateRetryInterval=100]
 * For live streams, set the interval-frequency in milliseconds at which dash.js will check if the current manifest is still processed before downloading the next manifest once the minimumUpdatePeriod time has.
 * @property {boolean} [cacheInitSegments=true]
 * Enables the caching of init segments to avoid requesting the init segments before each representation switch.
 * @property {boolean} [applyServiceDescription=true]
 * Set to true if dash.js should use the parameters defined in ServiceDescription elements
 * @property {boolean} [applyProducerReferenceTime=true]
 * Set to true if dash.js should use the parameters defined in ProducerReferenceTime elements in combination with ServiceDescription elements.
 * @property {boolean} [applyContentSteering=true]
 * Set to true if dash.js should apply content steering during playback.
 * @property {number} [eventControllerRefreshDelay=100]
 * For multi-period streams, overwrite the manifest mediaPresentationDuration attribute with the sum of period durations if the manifest mediaPresentationDuration is greater than the sum of period durations
 * @property {boolean} [enableManifestDurationMismatchFix=true]
 * Overwrite the manifest segments base information timescale attributes with the timescale set in initialization segments
 * @property {boolean} [enableManifestTimescaleMismatchFix=false]
 * Defines the delay in milliseconds between two consecutive checks for events to be fired.
 * @property {module:Settings~Metrics} metrics Metric settings
 * @property {module:Settings~LiveDelay} delay Live Delay settings
 * @property {module:Settings~TimeShiftBuffer} timeShiftBuffer TimeShiftBuffer settings
 * @property {module:Settings~Protection} protection DRM related settings
 * @property {module:Settings~Capabilities} capabilities Capability related settings
 * @property {module:Settings~Buffer}  buffer Buffer related settings
 * @property {module:Settings~Gaps}  gaps Gap related settings
 * @property {module:Settings~UtcSynchronizationSettings} utcSynchronization Settings related to UTC clock synchronization
 * @property {module:Settings~Scheduling} scheduling Settings related to segment scheduling
 * @property {module:Settings~Text} text Settings related to Subtitles and captions
 * @property {module:Settings~LiveCatchupSettings} liveCatchup  Settings related to live catchup.
 * @property {module:Settings~CachingInfoSettings} [lastBitrateCachingInfo={enabled: true, ttl: 360000}]
 * Set to false if you would like to disable the last known bit rate from being stored during playback and used to set the initial bit rate for subsequent playback within the expiration window.
 *
 * The default expiration is one hour, defined in milliseconds.
 *
 * If expired, the default initial bit rate (closest to 1000 kbps) will be used for that session and a new bit rate will be stored during that session.
 * @property {module:Settings~AudioVideoSettings} [cacheLoadThresholds={video: 50, audio: 5}]
 * For a given media type, the threshold which defines if the response to a fragment request is coming from browser cache or not.
 * @property {module:Settings~AudioVideoSettings} [trackSwitchMode={video: "neverReplace", audio: "alwaysReplace"}]
 * For a given media type defines if existing segments in the buffer should be overwritten once the track is switched. For instance if the user switches the audio language the existing segments in the audio buffer will be replaced when setting this value to "alwaysReplace".
 *
 * Possible values
 *
 * - Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE
 * Replace existing segments in the buffer
 *
 * - Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 * Do not replace existing segments in the buffer
 *
 * @property {string} [selectionModeForInitialTrack="highestBitrate"]
 * Sets the selection mode for the initial track. This mode defines how the initial track will be selected if no initial media settings are set. If initial media settings are set this parameter will be ignored. Available options are:
 *
 * Possible values
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY
 * This mode makes the player select the track with the highest selectionPriority as defined in the manifest. If not selectionPriority is given we fallback to TRACK_SELECTION_MODE_HIGHEST_BITRATE. This mode is a default mode.
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_BITRATE
 * This mode makes the player select the track with a highest bitrate.
 *
 * - Constants.TRACK_SELECTION_MODE_FIRST_TRACK
 * This mode makes the player select the first track found in the manifest.
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY
 * This mode makes the player select the track with the lowest bitrate per pixel average.
 *
 * - Constants.TRACK_SELECTION_MODE_WIDEST_RANGE
 * This mode makes the player select the track with a widest range of bitrates.
 *
 *
 * @property {number} [fragmentRequestTimeout=20000]
 * Time in milliseconds before timing out on loading a media fragment.
 *
 * @property {number} [manifestRequestTimeout=10000]
 * Time in milliseconds before timing out on loading a manifest.
 *
 * Fragments that timeout are retried as if they failed.
 * @property {module:Settings~RequestTypeSettings} [retryIntervals]
 * Time in milliseconds of which to reload a failed file load attempt.
 *
 * For low latency mode these values are divided by lowLatencyReductionFactor.
 * @property {module:Settings~RequestTypeSettings} [retryAttempts]
 * Total number of retry attempts that will occur on a file load before it fails.
 *
 * For low latency mode these values are multiplied by lowLatencyMultiplyFactor.
 * @property {module:Settings~AbrSettings} abr
 * Adaptive Bitrate algorithm related settings.
 * @property {module:Settings~CmcdSettings} cmcd
 * Settings related to Common Media Client Data reporting.
 * @property {module:Settings~CmsdSettings} cmsd
 * Settings related to Common Media Server Data parsing.
 */

/**
 * @class
 * @ignore
 */

function Settings() {
  var _retryIntervals, _retryAttempts;

  var instance;
  var context = this.context;
  var eventBus = (0,_EventBus__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  var DISPATCH_KEY_MAP = {
    'streaming.delay.liveDelay': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY,
    'streaming.delay.liveDelayFragmentCount': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,
    'streaming.liveCatchup.enabled': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_CATCHUP_ENABLED,
    'streaming.liveCatchup.playbackRate.min': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MIN,
    'streaming.liveCatchup.playbackRate.max': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MAX
  };
  /**
   * @const {PlayerSettings} defaultSettings
   * @ignore
   */

  var defaultSettings = {
    debug: {
      logLevel: _core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"].LOG_LEVEL_WARNING,
      dispatchEvent: false
    },
    streaming: {
      abandonLoadTimeout: 10000,
      wallclockTimeUpdateInterval: 100,
      manifestUpdateRetryInterval: 100,
      cacheInitSegments: false,
      applyServiceDescription: true,
      applyProducerReferenceTime: true,
      applyContentSteering: true,
      eventControllerRefreshDelay: 100,
      enableManifestDurationMismatchFix: true,
      enableManifestTimescaleMismatchFix: false,
      capabilities: {
        filterUnsupportedEssentialProperties: true,
        useMediaCapabilitiesApi: false
      },
      timeShiftBuffer: {
        calcFromSegmentTimeline: false,
        fallbackToSegmentTimeline: true
      },
      metrics: {
        maxListDepth: 100
      },
      delay: {
        liveDelayFragmentCount: NaN,
        liveDelay: NaN,
        useSuggestedPresentationDelay: true
      },
      protection: {
        keepProtectionMediaKeys: false,
        ignoreEmeEncryptedEvent: false,
        detectPlayreadyMessageFormat: true
      },
      buffer: {
        enableSeekDecorrelationFix: false,
        fastSwitchEnabled: true,
        flushBufferAtTrackSwitch: false,
        reuseExistingSourceBuffers: true,
        bufferPruningInterval: 10,
        bufferToKeep: 20,
        bufferTimeAtTopQuality: 30,
        bufferTimeAtTopQualityLongForm: 60,
        initialBufferLevel: NaN,
        stableBufferTime: 12,
        longFormContentDurationThreshold: 600,
        stallThreshold: 0.3,
        useAppendWindow: true,
        setStallState: true,
        avoidCurrentTimeRangePruning: false,
        useChangeTypeForTrackSwitch: true
      },
      gaps: {
        jumpGaps: true,
        jumpLargeGaps: true,
        smallGapLimit: 1.5,
        threshold: 0.3,
        enableSeekFix: true,
        enableStallFix: false,
        stallSeek: 0.1
      },
      utcSynchronization: {
        enabled: true,
        useManifestDateHeaderTimeSource: true,
        backgroundAttempts: 2,
        timeBetweenSyncAttempts: 30,
        maximumTimeBetweenSyncAttempts: 600,
        minimumTimeBetweenSyncAttempts: 2,
        timeBetweenSyncAttemptsAdjustmentFactor: 2,
        maximumAllowedDrift: 100,
        enableBackgroundSyncAfterSegmentDownloadError: true,
        defaultTimingSource: {
          scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
          value: 'https://time.akamai.com/?iso&ms'
        }
      },
      scheduling: {
        defaultTimeout: 500,
        lowLatencyTimeout: 0,
        scheduleWhilePaused: true
      },
      text: {
        defaultEnabled: true,
        extendSegmentedCues: true,
        webvtt: {
          customRenderingEnabled: false
        }
      },
      liveCatchup: {
        maxDrift: NaN,
        playbackRate: {
          min: NaN,
          max: NaN
        },
        playbackBufferMin: 0.5,
        enabled: null,
        mode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].LIVE_CATCHUP_MODE_DEFAULT
      },
      lastBitrateCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      lastMediaSettingsCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      cacheLoadThresholds: {
        video: 50,
        audio: 5
      },
      trackSwitchMode: {
        audio: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_ALWAYS_REPLACE,
        video: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_NEVER_REPLACE
      },
      selectionModeForInitialTrack: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY,
      fragmentRequestTimeout: 20000,
      manifestRequestTimeout: 10000,
      retryIntervals: (_retryIntervals = {}, _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE, 500), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE, 500), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE, 1000), _defineProperty(_retryIntervals, "lowLatencyReductionFactor", 10), _retryIntervals),
      retryAttempts: (_retryAttempts = {}, _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE, 1), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE, 3), _defineProperty(_retryAttempts, "lowLatencyMultiplyFactor", 5), _retryAttempts),
      abr: {
        movingAverageMethod: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].MOVING_AVERAGE_SLIDING_WINDOW,
        ABRStrategy: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].ABR_STRATEGY_DYNAMIC,
        additionalAbrRules: {
          insufficientBufferRule: true,
          switchHistoryRule: true,
          droppedFramesRule: true,
          abandonRequestsRule: true
        },
        bandwidthSafetyFactor: 0.9,
        useDefaultABRRules: true,
        useDeadTimeLatency: true,
        limitBitrateByPortal: false,
        usePixelRatioInLimitBitrateByPortal: false,
        maxBitrate: {
          audio: -1,
          video: -1
        },
        minBitrate: {
          audio: -1,
          video: -1
        },
        maxRepresentationRatio: {
          audio: 1,
          video: 1
        },
        initialBitrate: {
          audio: -1,
          video: -1
        },
        initialRepresentationRatio: {
          audio: -1,
          video: -1
        },
        autoSwitchBitrate: {
          audio: true,
          video: true
        },
        fetchThroughputCalculationMode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING
      },
      cmcd: {
        enabled: false,
        sid: null,
        cid: null,
        rtp: null,
        rtpSafetyFactor: 5,
        mode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].CMCD_MODE_QUERY,
        enabledKeys: ['br', 'd', 'ot', 'tb', 'bl', 'dl', 'mtp', 'nor', 'nrr', 'su', 'bs', 'rtp', 'cid', 'pr', 'sf', 'sid', 'st', 'v']
      },
      cmsd: {
        enabled: false,
        abr: {
          applyMb: false,
          etpWeightRatio: 0
        }
      }
    },
    errors: {
      recoverAttempts: {
        mediaErrorDecode: 5
      }
    }
  };
  var settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings); //Merge in the settings. If something exists in the new config that doesn't match the schema of the default config,
  //regard it as an error and log it.

  function mixinSettings(source, dest, path) {
    for (var n in source) {
      if (source.hasOwnProperty(n)) {
        if (dest.hasOwnProperty(n)) {
          if (_typeof(source[n]) === 'object' && !(source[n] instanceof Array) && source[n] !== null) {
            mixinSettings(source[n], dest[n], path.slice() + n + '.');
          } else {
            dest[n] = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(source[n]);

            if (DISPATCH_KEY_MAP[path + n]) {
              eventBus.trigger(DISPATCH_KEY_MAP[path + n]);
            }
          }
        } else {
          console.error('Settings parameter ' + path + n + ' is not supported');
        }
      }
    }
  }
  /**
   * Return the settings object. Don't copy/store this object, you won't get updates.
   * @func
   * @instance
   */


  function get() {
    return settings;
  }
  /**
   * @func
   * @instance
   * @param {object} settingsObj - This should be a partial object of the Settings.Schema type. That is, fields defined should match the path (e.g.
   * settingsObj.streaming.abr.autoSwitchBitrate.audio -> defaultSettings.streaming.abr.autoSwitchBitrate.audio). Where an element's path does
   * not match it is ignored, and a warning is logged.
   *
   * Use to change the settings object. Any new values defined will overwrite the settings and anything undefined will not change.
   * Implementers of new settings should add it in an approriate namespace to the defaultSettings object and give it a default value (that is not undefined).
   *
   */


  function update(settingsObj) {
    if (_typeof(settingsObj) === 'object') {
      mixinSettings(settingsObj, settings, '');
    }
  }
  /**
   * Resets the settings object. Everything is set to its default value.
   * @func
   * @instance
   *
   */


  function reset() {
    settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings);
  }

  instance = {
    get: get,
    update: update,
    reset: reset
  };
  return instance;
}

Settings.__dashjs_factory_name = 'Settings';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(Settings);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/core/Utils.js":
/*!***************************!*\
  !*** ./src/core/Utils.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var path_browserify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! path-browserify */ "./node_modules/path-browserify/index.js");
/* harmony import */ var path_browserify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_browserify__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ua-parser-js */ "./node_modules/ua-parser-js/src/ua-parser.js");
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ua_parser_js__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */



var Utils = /*#__PURE__*/function () {
  function Utils() {
    _classCallCheck(this, Utils);
  }

  _createClass(Utils, null, [{
    key: "mixin",
    value: function mixin(dest, source, copy) {
      var s;
      var empty = {};

      if (dest) {
        for (var name in source) {
          if (source.hasOwnProperty(name)) {
            s = source[name];

            if (!(name in dest) || dest[name] !== s && (!(name in empty) || empty[name] !== s)) {
              if (_typeof(dest[name]) === 'object' && dest[name] !== null) {
                dest[name] = Utils.mixin(dest[name], s, copy);
              } else {
                dest[name] = copy(s);
              }
            }
          }
        }
      }

      return dest;
    }
  }, {
    key: "clone",
    value: function clone(src) {
      if (!src || _typeof(src) !== 'object') {
        return src; // anything
      }

      var r;

      if (src instanceof Array) {
        // array
        r = [];

        for (var i = 0, l = src.length; i < l; ++i) {
          if (i in src) {
            r.push(Utils.clone(src[i]));
          }
        }
      } else {
        r = {};
      }

      return Utils.mixin(r, src, Utils.clone);
    }
  }, {
    key: "addAditionalQueryParameterToUrl",
    value: function addAditionalQueryParameterToUrl(url, params) {
      try {
        if (!params || params.length === 0) {
          return url;
        }

        var modifiedUrl = new URL(url);
        params.forEach(function (param) {
          if (param.key && param.value) {
            modifiedUrl.searchParams.set(param.key, param.value);
          }
        });
        return modifiedUrl.href;
      } catch (e) {
        return url;
      }
    }
  }, {
    key: "parseHttpHeaders",
    value: function parseHttpHeaders(headerStr) {
      var headers = {};

      if (!headerStr) {
        return headers;
      } // Trim headerStr to fix a MS Edge bug with xhr.getAllResponseHeaders method
      // which send a string starting with a "\n" character


      var headerPairs = headerStr.trim().split("\r\n");

      for (var i = 0, ilen = headerPairs.length; i < ilen; i++) {
        var headerPair = headerPairs[i];
        var index = headerPair.indexOf(": ");

        if (index > 0) {
          headers[headerPair.substring(0, index)] = headerPair.substring(index + 2);
        }
      }

      return headers;
    }
  }, {
    key: "generateUuid",
    value: function generateUuid() {
      var dt = new Date().getTime();
      var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (dt + Math.random() * 16) % 16 | 0;
        dt = Math.floor(dt / 16);
        return (c == 'x' ? r : r & 0x3 | 0x8).toString(16);
      });
      return uuid;
    }
  }, {
    key: "generateHashCode",
    value: function generateHashCode(string) {
      var hash = 0;

      if (string.length === 0) {
        return hash;
      }

      for (var i = 0; i < string.length; i++) {
        var chr = string.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash |= 0;
      }

      return hash;
    }
    /**
     * Compares both urls and returns a relative url (target relative to original)
     * @param {string} original
     * @param {string} target
     * @return {string|*}
     */

  }, {
    key: "getRelativeUrl",
    value: function getRelativeUrl(originalUrl, targetUrl) {
      try {
        var original = new URL(originalUrl);
        var target = new URL(targetUrl); // Unify the protocol to compare the origins

        original.protocol = target.protocol;

        if (original.origin !== target.origin) {
          return targetUrl;
        } // Use the relative path implementation of the path library. We need to cut off the actual filename in the end to get the relative path


        var relativePath = path_browserify__WEBPACK_IMPORTED_MODULE_0___default().relative(original.pathname.substr(0, original.pathname.lastIndexOf('/')), target.pathname.substr(0, target.pathname.lastIndexOf('/'))); // In case the relative path is empty (both path are equal) return the filename only. Otherwise add a slash in front of the filename

        var startIndexOffset = relativePath.length === 0 ? 1 : 0;
        relativePath += target.pathname.substr(target.pathname.lastIndexOf('/') + startIndexOffset, target.pathname.length - 1); // Build the other candidate, e.g. the 'host relative' path that starts with "/", and return the shortest of the two candidates.

        if (target.pathname.length < relativePath.length) {
          return target.pathname;
        }

        return relativePath;
      } catch (e) {
        return targetUrl;
      }
    }
  }, {
    key: "parseUserAgent",
    value: function parseUserAgent() {
      var ua = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      try {
        var uaString = ua === null ? typeof navigator !== 'undefined' ? navigator.userAgent.toLowerCase() : '' : '';
        return (0,ua_parser_js__WEBPACK_IMPORTED_MODULE_1__.UAParser)(uaString);
      } catch (e) {
        return {};
      }
    }
  }]);

  return Utils;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Utils);

/***/ }),

/***/ "./src/core/errors/Errors.js":
/*!***********************************!*\
  !*** ./src/core/errors/Errors.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ErrorsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ErrorsBase */ "./src/core/errors/ErrorsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Errors declaration
 * @class
 */

var Errors = /*#__PURE__*/function (_ErrorsBase) {
  _inherits(Errors, _ErrorsBase);

  var _super = _createSuper(Errors);

  function Errors() {
    var _this;

    _classCallCheck(this, Errors);

    _this = _super.call(this);
    /**
     * Error code returned when a manifest parsing error occurs
     */

    _this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE = 10;
    /**
     * Error code returned when a manifest loading error occurs
     */

    _this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE = 11;
    /**
     * Error code returned when a xlink loading error occurs
     */

    _this.XLINK_LOADER_LOADING_FAILURE_ERROR_CODE = 12;
    /**
     * Error code returned when no segment ranges could be determined from the sidx box
     */

    _this.SEGMENT_BASE_LOADER_ERROR_CODE = 15;
    /**
     * Error code returned when the time synchronization failed
     */

    _this.TIME_SYNC_FAILED_ERROR_CODE = 16;
    /**
     * Error code returned when loading a fragment failed
     */

    _this.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE = 17;
    /**
     * Error code returned when the FragmentLoader did not receive a request object
     */

    _this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE = 18;
    /**
     * Error code returned when the BaseUrl resolution failed
     */

    _this.URL_RESOLUTION_FAILED_GENERIC_ERROR_CODE = 19;
    /**
     * Error code returned when the append operation in the SourceBuffer failed
     */

    _this.APPEND_ERROR_CODE = 20;
    /**
     * Error code returned when the remove operation in the SourceBuffer failed
     */

    _this.REMOVE_ERROR_CODE = 21;
    /**
     * Error code returned when updating the internal objects after loading an MPD failed
     */

    _this.DATA_UPDATE_FAILED_ERROR_CODE = 22;
    /**
     * Error code returned when MediaSource is not supported by the browser
     */

    _this.CAPABILITY_MEDIASOURCE_ERROR_CODE = 23;
    /**
     * Error code returned when Protected contents are not supported
     */

    _this.CAPABILITY_MEDIAKEYS_ERROR_CODE = 24;
    /**
     * Error code returned when loading the manifest failed
     */

    _this.DOWNLOAD_ERROR_ID_MANIFEST_CODE = 25;
    /**
     * Error code returned when loading the sidx failed
     */

    _this.DOWNLOAD_ERROR_ID_SIDX_CODE = 26;
    /**
     * Error code returned when loading the media content failed
     */

    _this.DOWNLOAD_ERROR_ID_CONTENT_CODE = 27;
    /**
     * Error code returned when loading the init segment failed
     */

    _this.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE = 28;
    /**
     * Error code returned when loading the XLink content failed
     */

    _this.DOWNLOAD_ERROR_ID_XLINK_CODE = 29;
    /**
     * Error code returned when parsing the MPD resulted in a logical error
     */

    _this.MANIFEST_ERROR_ID_PARSE_CODE = 31;
    /**
     * Error code returned when no stream (period) has been detected in the manifest
     */

    _this.MANIFEST_ERROR_ID_NOSTREAMS_CODE = 32;
    /**
     * Error code returned when something wrong has happened during parsing and appending subtitles (TTML or VTT)
     */

    _this.TIMED_TEXT_ERROR_ID_PARSE_CODE = 33;
    /**
     * Error code returned when a 'muxed' media type has been detected in the manifest. This type is not supported
     */

    _this.MANIFEST_ERROR_ID_MULTIPLEXED_CODE = 34;
    /**
     * Error code returned when a media source type is not supported
     */

    _this.MEDIASOURCE_TYPE_UNSUPPORTED_CODE = 35;
    _this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE = 'parsing failed for ';
    _this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading manifest: ';
    _this.XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading Xlink element: ';
    _this.SEGMENTS_UPDATE_FAILED_ERROR_MESSAGE = 'Segments update failed';
    _this.SEGMENTS_UNAVAILABLE_ERROR_MESSAGE = 'no segments are available yet';
    _this.SEGMENT_BASE_LOADER_ERROR_MESSAGE = 'error loading segment ranges from sidx';
    _this.TIME_SYNC_FAILED_ERROR_MESSAGE = 'Failed to synchronize client and server time';
    _this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE = 'request is null';
    _this.URL_RESOLUTION_FAILED_GENERIC_ERROR_MESSAGE = 'Failed to resolve a valid URL';
    _this.APPEND_ERROR_MESSAGE = 'chunk is not defined';
    _this.REMOVE_ERROR_MESSAGE = 'Removing data from the SourceBuffer';
    _this.DATA_UPDATE_FAILED_ERROR_MESSAGE = 'Data update failed';
    _this.CAPABILITY_MEDIASOURCE_ERROR_MESSAGE = 'mediasource is not supported';
    _this.CAPABILITY_MEDIAKEYS_ERROR_MESSAGE = 'mediakeys is not supported';
    _this.TIMED_TEXT_ERROR_MESSAGE_PARSE = 'parsing error :';
    _this.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE = 'Error creating source buffer of type : ';
    return _this;
  }

  return Errors;
}(_ErrorsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var errors = new Errors();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (errors);

/***/ }),

/***/ "./src/core/errors/ErrorsBase.js":
/*!***************************************!*\
  !*** ./src/core/errors/ErrorsBase.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ErrorsBase = /*#__PURE__*/function () {
  function ErrorsBase() {
    _classCallCheck(this, ErrorsBase);
  }

  _createClass(ErrorsBase, [{
    key: "extend",
    value: function extend(errors, config) {
      if (!errors) return;
      var override = config ? config.override : false;
      var publicOnly = config ? config.publicOnly : false;

      for (var err in errors) {
        if (!errors.hasOwnProperty(err) || this[err] && !override) continue;
        if (publicOnly && errors[err].indexOf('public_') === -1) continue;
        this[err] = errors[err];
      }
    }
  }]);

  return ErrorsBase;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorsBase);

/***/ }),

/***/ "./src/core/events/CoreEvents.js":
/*!***************************************!*\
  !*** ./src/core/events/CoreEvents.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * These are internal events that should not be needed at the player level.
 * If you find and event in here that you would like access to from MediaPlayer level
 * please add an issue at https://github.com/Dash-Industry-Forum/dash.js/issues/new
 * @class
 * @ignore
 */

var CoreEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(CoreEvents, _EventsBase);

  var _super = _createSuper(CoreEvents);

  function CoreEvents() {
    var _this;

    _classCallCheck(this, CoreEvents);

    _this = _super.call(this);
    _this.ATTEMPT_BACKGROUND_SYNC = 'attemptBackgroundSync';
    _this.BUFFERING_COMPLETED = 'bufferingCompleted';
    _this.BUFFER_CLEARED = 'bufferCleared';
    _this.BYTES_APPENDED_END_FRAGMENT = 'bytesAppendedEndFragment';
    _this.BUFFER_REPLACEMENT_STARTED = 'bufferReplacementStarted';
    _this.CHECK_FOR_EXISTENCE_COMPLETED = 'checkForExistenceCompleted';
    _this.CMSD_STATIC_HEADER = 'cmsdStaticHeader';
    _this.CURRENT_TRACK_CHANGED = 'currentTrackChanged';
    _this.DATA_UPDATE_COMPLETED = 'dataUpdateCompleted';
    _this.INBAND_EVENTS = 'inbandEvents';
    _this.INITIAL_STREAM_SWITCH = 'initialStreamSwitch';
    _this.INIT_FRAGMENT_LOADED = 'initFragmentLoaded';
    _this.INIT_FRAGMENT_NEEDED = 'initFragmentNeeded';
    _this.INTERNAL_MANIFEST_LOADED = 'internalManifestLoaded';
    _this.ORIGINAL_MANIFEST_LOADED = 'originalManifestLoaded';
    _this.LOADING_COMPLETED = 'loadingCompleted';
    _this.LOADING_PROGRESS = 'loadingProgress';
    _this.LOADING_DATA_PROGRESS = 'loadingDataProgress';
    _this.LOADING_ABANDONED = 'loadingAborted';
    _this.MANIFEST_UPDATED = 'manifestUpdated';
    _this.MEDIA_FRAGMENT_LOADED = 'mediaFragmentLoaded';
    _this.MEDIA_FRAGMENT_NEEDED = 'mediaFragmentNeeded';
    _this.QUOTA_EXCEEDED = 'quotaExceeded';
    _this.SEGMENT_LOCATION_BLACKLIST_ADD = 'segmentLocationBlacklistAdd';
    _this.SEGMENT_LOCATION_BLACKLIST_CHANGED = 'segmentLocationBlacklistChanged';
    _this.SERVICE_LOCATION_BLACKLIST_ADD = 'serviceLocationBlacklistAdd';
    _this.SERVICE_LOCATION_BLACKLIST_CHANGED = 'serviceLocationBlacklistChanged';
    _this.SET_FRAGMENTED_TEXT_AFTER_DISABLED = 'setFragmentedTextAfterDisabled';
    _this.SET_NON_FRAGMENTED_TEXT = 'setNonFragmentedText';
    _this.SOURCE_BUFFER_ERROR = 'sourceBufferError';
    _this.STREAMS_COMPOSED = 'streamsComposed';
    _this.STREAM_BUFFERING_COMPLETED = 'streamBufferingCompleted';
    _this.STREAM_REQUESTING_COMPLETED = 'streamRequestingCompleted';
    _this.TEXT_TRACKS_QUEUE_INITIALIZED = 'textTracksQueueInitialized';
    _this.TIME_SYNCHRONIZATION_COMPLETED = 'timeSynchronizationComplete';
    _this.UPDATE_TIME_SYNC_OFFSET = 'updateTimeSyncOffset';
    _this.URL_RESOLUTION_FAILED = 'urlResolutionFailed';
    _this.VIDEO_CHUNK_RECEIVED = 'videoChunkReceived';
    _this.WALLCLOCK_TIME_UPDATED = 'wallclockTimeUpdated';
    _this.XLINK_ELEMENT_LOADED = 'xlinkElementLoaded';
    _this.XLINK_READY = 'xlinkReady';
    _this.SEEK_TARGET = 'seekTarget';
    _this.SETTING_UPDATED_LIVE_DELAY = 'settingUpdatedLiveDelay';
    _this.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT = 'settingUpdatedLiveDelayFragmentCount';
    _this.SETTING_UPDATED_CATCHUP_ENABLED = 'settingUpdatedCatchupEnabled';
    _this.SETTING_UPDATED_PLAYBACK_RATE_MIN = 'settingUpdatedPlaybackRateMin';
    _this.SETTING_UPDATED_PLAYBACK_RATE_MAX = 'settingUpdatedPlaybackRateMax';
    return _this;
  }

  return CoreEvents;
}(_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CoreEvents);

/***/ }),

/***/ "./src/core/events/Events.js":
/*!***********************************!*\
  !*** ./src/core/events/Events.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _CoreEvents__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CoreEvents */ "./src/core/events/CoreEvents.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var Events = /*#__PURE__*/function (_CoreEvents) {
  _inherits(Events, _CoreEvents);

  var _super = _createSuper(Events);

  function Events() {
    _classCallCheck(this, Events);

    return _super.apply(this, arguments);
  }

  return Events;
}(_CoreEvents__WEBPACK_IMPORTED_MODULE_0__["default"]);

var events = new Events();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (events);

/***/ }),

/***/ "./src/core/events/EventsBase.js":
/*!***************************************!*\
  !*** ./src/core/events/EventsBase.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var EventsBase = /*#__PURE__*/function () {
  function EventsBase() {
    _classCallCheck(this, EventsBase);
  }

  _createClass(EventsBase, [{
    key: "extend",
    value: function extend(events, config) {
      if (!events) return;
      var override = config ? config.override : false;
      var publicOnly = config ? config.publicOnly : false;

      for (var evt in events) {
        if (!events.hasOwnProperty(evt) || this[evt] && !override) continue;
        if (publicOnly && events[evt].indexOf('public_') === -1) continue;
        this[evt] = events[evt];
      }
    }
  }]);

  return EventsBase;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EventsBase);

/***/ }),

/***/ "./src/dash/DashHandler.js":
/*!*********************************!*\
  !*** ./src/dash/DashHandler.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../streaming/vo/FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






var DEFAULT_ADJUST_SEEK_TIME_THRESHOLD = 0.5;
var SEGMENT_START_TIME_DELTA = 0.001;

function DashHandler(config) {
  config = config || {};
  var eventBus = config.eventBus;
  var debug = config.debug;
  var urlUtils = config.urlUtils;
  var type = config.type;
  var streamInfo = config.streamInfo;
  var segmentsController = config.segmentsController;
  var timelineConverter = config.timelineConverter;
  var baseURLController = config.baseURLController;
  var instance, logger, lastSegment, isDynamicManifest, mediaHasFinished;

  function setup() {
    logger = debug.getLogger(instance);
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }

  function initialize(isDynamic) {
    isDynamicManifest = isDynamic;
    mediaHasFinished = false;
    segmentsController.initialize(isDynamic);
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function getStreamInfo() {
    return streamInfo;
  }

  function resetInitialSettings() {
    lastSegment = null;
  }

  function reset() {
    resetInitialSettings();
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }

  function _setRequestUrl(request, destination, representation) {
    var baseURL = baseURLController.resolve(representation.path);
    var url, serviceLocation;

    if (!baseURL || destination === baseURL.url || !urlUtils.isRelative(destination)) {
      url = destination;
    } else {
      url = baseURL.url;
      serviceLocation = baseURL.serviceLocation;

      if (destination) {
        url = urlUtils.resolve(destination, url);
      }
    }

    if (urlUtils.isRelative(url)) {
      return false;
    }

    request.url = url;
    request.serviceLocation = serviceLocation;
    return true;
  }

  function getInitRequest(mediaInfo, representation) {
    if (!representation) return null;
    return _generateInitRequest(mediaInfo, representation, getType());
  }

  function _generateInitRequest(mediaInfo, representation, mediaType) {
    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__["default"]();
    var period = representation.adaptation.period;
    var presentationStartTime = period.start;
    request.mediaType = mediaType;
    request.type = _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.INIT_SEGMENT_TYPE;
    request.range = representation.range;
    request.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationStartTime, representation, isDynamicManifest);
    request.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationStartTime + period.duration, representation, isDynamicManifest);
    request.quality = representation.index;
    request.mediaInfo = mediaInfo;
    request.representationId = representation.id;

    if (_setRequestUrl(request, representation.initialization, representation)) {
      request.url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(request.url, 'Bandwidth', representation.bandwidth);
      return request;
    }
  }

  function _getRequestForSegment(mediaInfo, segment) {
    if (segment === null || segment === undefined) {
      return null;
    }

    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__["default"]();
    var representation = segment.representation;
    var bandwidth = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].bandwidth;
    var url = segment.media;
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Number', segment.replacementNumber);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Time', segment.replacementTime);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Bandwidth', bandwidth);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceIDForTemplate)(url, representation.id);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.unescapeDollarsInTemplate)(url);
    request.mediaType = getType();
    request.type = _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.MEDIA_SEGMENT_TYPE;
    request.range = segment.mediaRange;
    request.startTime = segment.presentationStartTime;
    request.mediaStartTime = segment.mediaStartTime;
    request.duration = segment.duration;
    request.timescale = representation.timescale;
    request.availabilityStartTime = segment.availabilityStartTime;
    request.availabilityEndTime = segment.availabilityEndTime;
    request.availabilityTimeComplete = representation.availabilityTimeComplete;
    request.wallStartTime = segment.wallStartTime;
    request.quality = representation.index;
    request.index = segment.index;
    request.mediaInfo = mediaInfo;
    request.adaptationIndex = representation.adaptation.index;
    request.representationId = representation.id;

    if (_setRequestUrl(request, url, representation)) {
      return request;
    }
  }

  function isLastSegmentRequested(representation, bufferingTime) {
    if (!representation || !lastSegment) {
      return false;
    } // Either transition from dynamic to static was done or no next static segment found


    if (mediaHasFinished) {
      return true;
    } // Period is endless


    if (!isFinite(representation.adaptation.period.duration)) {
      return false;
    } // we are replacing existing stuff in the buffer for instance after a track switch


    if (lastSegment.presentationStartTime + lastSegment.duration > bufferingTime) {
      return false;
    } // Additional segment references may be added to the last period.
    // Additional periods may be added to the end of the MPD.
    // Segment references SHALL NOT be added to any period other than the last period.
    // An MPD update MAY combine adding segment references to the last period with adding of new periods. An MPD update that adds content MAY be combined with an MPD update that removes content.
    // The index of the last requested segment is higher than the number of available segments.
    // For SegmentTimeline and SegmentTemplate the index does not include the startNumber.
    // For SegmentList the index includes the startnumber which is why the numberOfSegments includes this as well


    if (representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.numberOfSegments) && !isNaN(lastSegment.index) && lastSegment.index >= representation.mediaFinishedInformation.numberOfSegments - 1) {
      // For static manifests and Template addressing we can compare the index against the number of available segments
      if (!isDynamicManifest || representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_TEMPLATE) {
        return true;
      } // For SegmentList we need to check if the next period is signaled
      else if (isDynamicManifest && representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_LIST && representation.adaptation.period.nextPeriodId) {
        return true;
      }
    } // For dynamic SegmentTimeline manifests we need to check if the next period is already signaled and the segment we fetched before is the last one that is signaled.
    // We can not simply use the index, as numberOfSegments might have decreased after an MPD update


    return !!(isDynamicManifest && representation.adaptation.period.nextPeriodId && representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_TIMELINE && representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment) && lastSegment && !isNaN(lastSegment.mediaStartTime) && !isNaN(lastSegment.duration) && lastSegment.mediaStartTime + lastSegment.duration >= representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment - 0.05);
  }

  function getSegmentRequestForTime(mediaInfo, representation, time) {
    var request = null;

    if (!representation || !representation.segmentInfoType) {
      return request;
    }

    var segment = segmentsController.getSegmentByTime(representation, time);

    if (segment) {
      lastSegment = segment;
      logger.debug('Index for time ' + time + ' is ' + segment.index);
      request = _getRequestForSegment(mediaInfo, segment);
    }

    return request;
  }
  /**
   * This function returns the next segment request without modifying any internal variables. Any class (e.g CMCD Model) that needs information about the upcoming request should use this method.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */


  function getNextSegmentRequestIdempotent(mediaInfo, representation) {
    var request = null;
    var indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    var segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1);
    if (!segment) return null;
    request = _getRequestForSegment(mediaInfo, segment);
    return request;
  }
  /**
   * Main function to get the next segment request.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */


  function getNextSegmentRequest(mediaInfo, representation) {
    var request = null;

    if (!representation || !representation.segmentInfoType) {
      return null;
    }

    var indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    var segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1); // No segment found

    if (!segment) {
      // Dynamic manifest there might be something available in the next iteration
      if (isDynamicManifest && !mediaHasFinished) {
        logger.debug(getType() + ' No segment found at index: ' + indexToRequest + '. Wait for next loop');
        return null;
      } else {
        mediaHasFinished = true;
      }
    } else {
      request = _getRequestForSegment(mediaInfo, segment);
      lastSegment = segment;
    }

    return request;
  }
  /**
   * This function returns a time larger than the current time for which we can generate a request.
   * This is useful in scenarios in which the user seeks into a gap in a dynamic Timeline manifest. We will not find a valid request then and need to adjust the seektime.
   * @param {number} time
   * @param {object} mediaInfo
   * @param {object} representation
   * @param {number} targetThreshold
   */


  function getValidTimeAheadOfTargetTime(time, mediaInfo, representation, targetThreshold) {
    try {
      if (isNaN(time) || !mediaInfo || !representation) {
        return NaN;
      }

      if (time < 0) {
        time = 0;
      }

      if (isNaN(targetThreshold)) {
        targetThreshold = DEFAULT_ADJUST_SEEK_TIME_THRESHOLD;
      }

      if (getSegmentRequestForTime(mediaInfo, representation, time)) {
        return time;
      }

      if (representation.adaptation.period.start + representation.adaptation.period.duration < time) {
        return NaN;
      } // If we have a duration look until the end of the duration, otherwise maximum 30 seconds


      var end = isFinite(representation.adaptation.period.duration) ? representation.adaptation.period.start + representation.adaptation.period.duration : time + 30;
      var currentUpperTime = Math.min(time + targetThreshold, end);
      var adjustedTime = NaN;
      var targetRequest = null;

      while (currentUpperTime <= end) {
        var upperRequest = null;

        if (currentUpperTime <= end) {
          upperRequest = getSegmentRequestForTime(mediaInfo, representation, currentUpperTime);
        }

        if (upperRequest) {
          adjustedTime = currentUpperTime;
          targetRequest = upperRequest;
          break;
        }

        currentUpperTime += targetThreshold;
      }

      if (targetRequest) {
        var requestEndTime = targetRequest.startTime + targetRequest.duration; // Keep the original start time in case it is covered by a segment

        if (time > targetRequest.startTime && requestEndTime - time > targetThreshold) {
          return time;
        }

        if (!isNaN(targetRequest.startTime) && time < targetRequest.startTime && adjustedTime > targetRequest.startTime) {
          // Apply delta to segment start time to get around rounding issues
          return targetRequest.startTime + SEGMENT_START_TIME_DELTA;
        }

        return Math.min(requestEndTime - targetThreshold, adjustedTime);
      }

      return adjustedTime;
    } catch (e) {
      return NaN;
    }
  }

  function getCurrentIndex() {
    return lastSegment ? lastSegment.index : -1;
  }

  function _onDynamicToStatic() {
    logger.debug('Dynamic stream complete');
    mediaHasFinished = true;
  }

  instance = {
    initialize: initialize,
    getStreamId: getStreamId,
    getType: getType,
    getStreamInfo: getStreamInfo,
    getInitRequest: getInitRequest,
    getSegmentRequestForTime: getSegmentRequestForTime,
    getCurrentIndex: getCurrentIndex,
    getNextSegmentRequest: getNextSegmentRequest,
    isLastSegmentRequested: isLastSegmentRequested,
    reset: reset,
    getNextSegmentRequestIdempotent: getNextSegmentRequestIdempotent,
    getValidTimeAheadOfTargetTime: getValidTimeAheadOfTargetTime
  };
  setup();
  return instance;
}

DashHandler.__dashjs_factory_name = 'DashHandler';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(DashHandler));

/***/ }),

/***/ "./src/dash/constants/DashConstants.js":
/*!*********************************************!*\
  !*** ./src/dash/constants/DashConstants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Dash constants declaration
 * @class
 * @ignore
 */
var DashConstants = /*#__PURE__*/function () {
  function DashConstants() {
    _classCallCheck(this, DashConstants);

    this.init();
  }

  _createClass(DashConstants, [{
    key: "init",
    value: function init() {
      this.BASE_URL = 'BaseURL';
      this.SEGMENT_BASE = 'SegmentBase';
      this.SEGMENT_TEMPLATE = 'SegmentTemplate';
      this.SEGMENT_LIST = 'SegmentList';
      this.SEGMENT_URL = 'SegmentURL';
      this.SEGMENT_TIMELINE = 'SegmentTimeline';
      this.SEGMENT_PROFILES = 'segmentProfiles';
      this.ADAPTATION_SET = 'AdaptationSet';
      this.REPRESENTATION = 'Representation';
      this.REPRESENTATION_INDEX = 'RepresentationIndex';
      this.SUB_REPRESENTATION = 'SubRepresentation';
      this.INITIALIZATION = 'Initialization';
      this.INITIALIZATION_MINUS = 'initialization';
      this.MPD = 'MPD';
      this.PERIOD = 'Period';
      this.ASSET_IDENTIFIER = 'AssetIdentifier';
      this.EVENT_STREAM = 'EventStream';
      this.ID = 'id';
      this.PROFILES = 'profiles';
      this.SERVICE_LOCATION = 'serviceLocation';
      this.RANGE = 'range';
      this.INDEX = 'index';
      this.MEDIA = 'media';
      this.BYTE_RANGE = 'byteRange';
      this.INDEX_RANGE = 'indexRange';
      this.MEDIA_RANGE = 'mediaRange';
      this.VALUE = 'value';
      this.CONTENT_TYPE = 'contentType';
      this.MIME_TYPE = 'mimeType';
      this.BITSTREAM_SWITCHING = 'BitstreamSwitching';
      this.BITSTREAM_SWITCHING_MINUS = 'bitstreamSwitching';
      this.CODECS = 'codecs';
      this.DEPENDENCY_ID = 'dependencyId';
      this.MEDIA_STREAM_STRUCTURE_ID = 'mediaStreamStructureId';
      this.METRICS = 'Metrics';
      this.METRICS_MINUS = 'metrics';
      this.REPORTING = 'Reporting';
      this.WIDTH = 'width';
      this.HEIGHT = 'height';
      this.SAR = 'sar';
      this.FRAMERATE = 'frameRate';
      this.AUDIO_SAMPLING_RATE = 'audioSamplingRate';
      this.MAXIMUM_SAP_PERIOD = 'maximumSAPPeriod';
      this.START_WITH_SAP = 'startWithSAP';
      this.MAX_PLAYOUT_RATE = 'maxPlayoutRate';
      this.CODING_DEPENDENCY = 'codingDependency';
      this.SCAN_TYPE = 'scanType';
      this.FRAME_PACKING = 'FramePacking';
      this.AUDIO_CHANNEL_CONFIGURATION = 'AudioChannelConfiguration';
      this.CONTENT_PROTECTION = 'ContentProtection';
      this.ESSENTIAL_PROPERTY = 'EssentialProperty';
      this.SUPPLEMENTAL_PROPERTY = 'SupplementalProperty';
      this.INBAND_EVENT_STREAM = 'InbandEventStream';
      this.PRODUCER_REFERENCE_TIME = 'ProducerReferenceTime';
      this.ACCESSIBILITY = 'Accessibility';
      this.ROLE = 'Role';
      this.RATING = 'Rating';
      this.CONTENT_COMPONENT = 'ContentComponent';
      this.SUBSET = 'Subset';
      this.LANG = 'lang';
      this.VIEWPOINT = 'Viewpoint';
      this.ROLE_ASARRAY = 'Role_asArray';
      this.REPRESENTATION_ASARRAY = 'Representation_asArray';
      this.PRODUCERREFERENCETIME_ASARRAY = 'ProducerReferenceTime_asArray';
      this.ACCESSIBILITY_ASARRAY = 'Accessibility_asArray';
      this.AUDIOCHANNELCONFIGURATION_ASARRAY = 'AudioChannelConfiguration_asArray';
      this.CONTENTPROTECTION_ASARRAY = 'ContentProtection_asArray';
      this.MAIN = 'main';
      this.DYNAMIC = 'dynamic';
      this.STATIC = 'static';
      this.MEDIA_PRESENTATION_DURATION = 'mediaPresentationDuration';
      this.MINIMUM_UPDATE_PERIOD = 'minimumUpdatePeriod';
      this.CODEC_PRIVATE_DATA = 'codecPrivateData';
      this.BANDWITH = 'bandwidth';
      this.SOURCE_URL = 'sourceURL';
      this.TIMESCALE = 'timescale';
      this.DURATION = 'duration';
      this.START_NUMBER = 'startNumber';
      this.PRESENTATION_TIME_OFFSET = 'presentationTimeOffset';
      this.AVAILABILITY_START_TIME = 'availabilityStartTime';
      this.AVAILABILITY_END_TIME = 'availabilityEndTime';
      this.TIMESHIFT_BUFFER_DEPTH = 'timeShiftBufferDepth';
      this.MAX_SEGMENT_DURATION = 'maxSegmentDuration';
      this.PRESENTATION_TIME = 'presentationTime';
      this.MIN_BUFFER_TIME = 'minBufferTime';
      this.MAX_SUBSEGMENT_DURATION = 'maxSubsegmentDuration';
      this.START = 'start';
      this.AVAILABILITY_TIME_OFFSET = 'availabilityTimeOffset';
      this.AVAILABILITY_TIME_COMPLETE = 'availabilityTimeComplete';
      this.CENC_DEFAULT_KID = 'cenc:default_KID';
      this.DVB_PRIORITY = 'dvb:priority';
      this.DVB_WEIGHT = 'dvb:weight';
      this.SUGGESTED_PRESENTATION_DELAY = 'suggestedPresentationDelay';
      this.SERVICE_DESCRIPTION = 'ServiceDescription';
      this.SERVICE_DESCRIPTION_SCOPE = 'Scope';
      this.SERVICE_DESCRIPTION_LATENCY = 'Latency';
      this.SERVICE_DESCRIPTION_PLAYBACK_RATE = 'PlaybackRate';
      this.SERVICE_DESCRIPTION_OPERATING_QUALITY = 'OperatingQuality';
      this.SERVICE_DESCRIPTION_OPERATING_BANDWIDTH = 'OperatingBandwidth';
      this.PATCH_LOCATION = 'PatchLocation';
      this.PUBLISH_TIME = 'publishTime';
      this.ORIGINAL_PUBLISH_TIME = 'originalPublishTime';
      this.ORIGINAL_MPD_ID = 'mpdId';
      this.WALL_CLOCK_TIME = 'wallClockTime';
      this.PRESENTATION_TIME = 'presentationTime';
      this.LABEL = 'Label';
      this.GROUP_LABEL = 'GroupLabel';
      this.CONTENT_STEERING = 'ContentSteering';
      this.CONTENT_STEERING_AS_ARRAY = 'ContentSteering_asArray';
      this.DEFAULT_SERVICE_LOCATION = 'defaultServiceLocation';
      this.QUERY_BEFORE_START = 'queryBeforeStart';
      this.PROXY_SERVER_URL = 'proxyServerURL';
      this.CONTENT_STEERING_RESPONSE = {
        VERSION: 'VERSION',
        TTL: 'TTL',
        RELOAD_URI: 'RELOAD-URI',
        SERVICE_LOCATION_PRIORITY: 'SERVICE-LOCATION-PRIORITY'
      };
    }
  }]);

  return DashConstants;
}();

var constants = new DashConstants();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (constants);

/***/ }),

/***/ "./src/dash/controllers/RepresentationController.js":
/*!**********************************************************!*\
  !*** ./src/dash/controllers/RepresentationController.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */





function RepresentationController(config) {
  config = config || {};
  var eventBus = config.eventBus;
  var events = config.events;
  var abrController = config.abrController;
  var dashMetrics = config.dashMetrics;
  var playbackController = config.playbackController;
  var timelineConverter = config.timelineConverter;
  var type = config.type;
  var streamInfo = config.streamInfo;
  var dashConstants = config.dashConstants;
  var segmentsController = config.segmentsController;
  var isDynamic = config.isDynamic;
  var instance, realAdaptation, updating, voAvailableRepresentations, currentVoRepresentation;

  function setup() {
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function checkConfig() {
    if (!abrController || !dashMetrics || !playbackController || !timelineConverter) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getData() {
    return realAdaptation;
  }

  function isUpdating() {
    return updating;
  }

  function getCurrentRepresentation() {
    return currentVoRepresentation;
  }

  function resetInitialSettings() {
    realAdaptation = null;
    updating = true;
    voAvailableRepresentations = [];
  }

  function reset() {
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
    resetInitialSettings();
  }

  function updateData(newRealAdaptation, availableRepresentations, type, isFragmented, quality) {
    checkConfig();
    updating = true;
    voAvailableRepresentations = availableRepresentations;
    var rep = getRepresentationForQuality(quality);

    _setCurrentVoRepresentation(rep);

    realAdaptation = newRealAdaptation;

    if (type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO && type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO && (type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || !isFragmented)) {
      endDataUpdate();
      return Promise.resolve();
    }

    var promises = [];

    for (var i = 0, ln = voAvailableRepresentations.length; i < ln; i++) {
      var currentRep = voAvailableRepresentations[i];
      promises.push(_updateRepresentation(currentRep));
    }

    return Promise.all(promises);
  }

  function _updateRepresentation(currentRep) {
    return new Promise(function (resolve, reject) {
      var hasInitialization = currentRep.hasInitialization();
      var hasSegments = currentRep.hasSegments(); // If representation has initialization and segments information we are done
      // otherwise, it means that a request has to be made to get initialization and/or segments information

      var promises = [];
      promises.push(segmentsController.updateInitData(currentRep, hasInitialization));
      promises.push(segmentsController.updateSegmentData(currentRep, hasSegments));
      Promise.all(promises).then(function (data) {
        if (data[0] && !data[0].error) {
          currentRep = _onInitLoaded(currentRep, data[0]);
        }

        if (data[1] && !data[1].error) {
          currentRep = _onSegmentsLoaded(currentRep, data[1]);
        }

        _setMediaFinishedInformation(currentRep);

        _onRepresentationUpdated(currentRep);

        resolve();
      })["catch"](function (e) {
        reject(e);
      });
    });
  }

  function _setMediaFinishedInformation(representation) {
    representation.mediaFinishedInformation = segmentsController.getMediaFinishedInformation(representation);
  }

  function _onInitLoaded(representation, e) {
    if (!e || e.error || !e.representation) {
      return representation;
    }

    return e.representation;
  }

  function _onSegmentsLoaded(representation, e) {
    if (!e || e.error) return;
    var fragments = e.segments;
    var segments = [];
    var count = 0;
    var i, len, s, seg;

    for (i = 0, len = fragments ? fragments.length : 0; i < len; i++) {
      s = fragments[i];
      seg = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_3__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, s.startTime, s.duration, s.timescale, s.media, s.mediaRange, count);

      if (seg) {
        segments.push(seg);
        seg = null;
        count++;
      }
    }

    if (segments.length > 0) {
      representation.segments = segments;
    }

    return representation;
  }

  function _addRepresentationSwitch() {
    checkConfig();
    var now = new Date();
    var currentRepresentation = getCurrentRepresentation();
    var currentVideoTimeMs = playbackController.getTime() * 1000;

    if (currentRepresentation) {
      dashMetrics.addRepresentationSwitch(currentRepresentation.adaptation.type, now, currentVideoTimeMs, currentRepresentation.id);
    }

    eventBus.trigger(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].REPRESENTATION_SWITCH, {
      mediaType: type,
      streamId: streamInfo.id,
      currentRepresentation: currentRepresentation,
      numberOfRepresentations: voAvailableRepresentations.length
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function getRepresentationForQuality(quality) {
    return quality === null || quality === undefined || quality >= voAvailableRepresentations.length ? null : voAvailableRepresentations[quality];
  }

  function getQualityForRepresentation(voRepresentation) {
    return voAvailableRepresentations.indexOf(voRepresentation);
  }

  function isAllRepresentationsUpdated() {
    for (var i = 0, ln = voAvailableRepresentations.length; i < ln; i++) {
      var segmentInfoType = voAvailableRepresentations[i].segmentInfoType;

      if (!voAvailableRepresentations[i].hasInitialization() || (segmentInfoType === dashConstants.SEGMENT_BASE || segmentInfoType === dashConstants.BASE_URL) && !voAvailableRepresentations[i].segments) {
        return false;
      }
    }

    return true;
  }

  function endDataUpdate(error) {
    updating = false;
    eventBus.trigger(events.DATA_UPDATE_COMPLETED, {
      data: realAdaptation,
      currentRepresentation: currentVoRepresentation,
      error: error
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function _onRepresentationUpdated(r) {
    if (!isUpdating()) return;
    var manifestUpdateInfo = dashMetrics.getCurrentManifestUpdate();
    var alreadyAdded = false;
    var repInfo, repSwitch;

    if (manifestUpdateInfo) {
      for (var i = 0; i < manifestUpdateInfo.representationInfo.length; i++) {
        repInfo = manifestUpdateInfo.representationInfo[i];

        if (repInfo.index === r.index && repInfo.mediaType === getType()) {
          alreadyAdded = true;
          break;
        }
      }

      if (!alreadyAdded) {
        dashMetrics.addManifestUpdateRepresentationInfo(r, getType());
      }
    }

    if (isAllRepresentationsUpdated()) {
      abrController.setPlaybackQuality(type, streamInfo, getQualityForRepresentation(currentVoRepresentation));
      var dvrInfo = dashMetrics.getCurrentDVRInfo(type);

      if (dvrInfo) {
        dashMetrics.updateManifestUpdateInfo({
          latency: dvrInfo.range.end - playbackController.getTime()
        });
      }

      repSwitch = dashMetrics.getCurrentRepresentationSwitch(getCurrentRepresentation().adaptation.type);

      if (!repSwitch) {
        _addRepresentationSwitch();
      }

      endDataUpdate();
    }
  }

  function prepareQualityChange(newQuality) {
    var newRep = getRepresentationForQuality(newQuality);

    _setCurrentVoRepresentation(newRep);

    _addRepresentationSwitch();
  }

  function _setCurrentVoRepresentation(value) {
    currentVoRepresentation = value;
  }

  function onManifestValidityChanged(e) {
    if (e.newDuration) {
      var representation = getCurrentRepresentation();

      if (representation && representation.adaptation.period) {
        var period = representation.adaptation.period;
        period.duration = e.newDuration;
      }
    }
  }

  instance = {
    getStreamId: getStreamId,
    getType: getType,
    getData: getData,
    isUpdating: isUpdating,
    updateData: updateData,
    getCurrentRepresentation: getCurrentRepresentation,
    getRepresentationForQuality: getRepresentationForQuality,
    prepareQualityChange: prepareQualityChange,
    reset: reset
  };
  setup();
  return instance;
}

RepresentationController.__dashjs_factory_name = 'RepresentationController';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(RepresentationController));

/***/ }),

/***/ "./src/dash/controllers/SegmentsController.js":
/*!****************************************************!*\
  !*** ./src/dash/controllers/SegmentsController.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _utils_TimelineSegmentsGetter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/TimelineSegmentsGetter */ "./src/dash/utils/TimelineSegmentsGetter.js");
/* harmony import */ var _utils_TemplateSegmentsGetter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/TemplateSegmentsGetter */ "./src/dash/utils/TemplateSegmentsGetter.js");
/* harmony import */ var _utils_ListSegmentsGetter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/ListSegmentsGetter */ "./src/dash/utils/ListSegmentsGetter.js");
/* harmony import */ var _utils_SegmentBaseGetter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/SegmentBaseGetter */ "./src/dash/utils/SegmentBaseGetter.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function SegmentsController(config) {
  config = config || {};
  var context = this.context;
  var dashConstants = config.dashConstants;
  var type = config.type;
  var segmentBaseController = config.segmentBaseController;
  var instance, getters;

  function setup() {
    getters = {};
  }

  function initialize(isDynamic) {
    getters[dashConstants.SEGMENT_TIMELINE] = (0,_utils_TimelineSegmentsGetter__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_TEMPLATE] = (0,_utils_TemplateSegmentsGetter__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_LIST] = (0,_utils_ListSegmentsGetter__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_BASE] = (0,_utils_SegmentBaseGetter__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create(config, isDynamic);
  }

  function updateInitData(voRepresentation, hasInitialization) {
    if (hasInitialization) {
      return Promise.resolve();
    }

    return segmentBaseController.getSegmentBaseInitSegment({
      representation: voRepresentation,
      mediaType: type
    });
  }

  function updateSegmentData(voRepresentation, hasSegments) {
    if (hasSegments) {
      return Promise.resolve();
    }

    return segmentBaseController.getSegmentList({
      mimeType: voRepresentation.mimeType,
      representation: voRepresentation,
      mediaType: type
    });
  }

  function getSegmentsGetter(representation) {
    return representation ? representation.segments ? getters[dashConstants.SEGMENT_BASE] : getters[representation.segmentInfoType] : null;
  }

  function getSegmentByIndex(representation, index, lastSegmentTime) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByIndex(representation, index, lastSegmentTime) : null;
  }

  function getSegmentByTime(representation, time) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByTime(representation, time) : null;
  }

  function getMediaFinishedInformation(representation) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getMediaFinishedInformation(representation) : {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
  }

  instance = {
    initialize: initialize,
    updateInitData: updateInitData,
    updateSegmentData: updateSegmentData,
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  setup();
  return instance;
}

SegmentsController.__dashjs_factory_name = 'SegmentsController';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SegmentsController);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/models/DashManifestModel.js":
/*!**********************************************!*\
  !*** ./src/dash/models/DashManifestModel.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _vo_Representation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../vo/Representation */ "./src/dash/vo/Representation.js");
/* harmony import */ var _vo_AdaptationSet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/AdaptationSet */ "./src/dash/vo/AdaptationSet.js");
/* harmony import */ var _vo_Period__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/Period */ "./src/dash/vo/Period.js");
/* harmony import */ var _vo_Mpd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vo/Mpd */ "./src/dash/vo/Mpd.js");
/* harmony import */ var _vo_UTCTiming__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vo/UTCTiming */ "./src/dash/vo/UTCTiming.js");
/* harmony import */ var _vo_Event__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../vo/Event */ "./src/dash/vo/Event.js");
/* harmony import */ var _vo_BaseURL__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../vo/BaseURL */ "./src/dash/vo/BaseURL.js");
/* harmony import */ var _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vo/EventStream */ "./src/dash/vo/EventStream.js");
/* harmony import */ var _vo_ProducerReferenceTime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vo/ProducerReferenceTime */ "./src/dash/vo/ProducerReferenceTime.js");
/* harmony import */ var _vo_ContentSteering__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../vo/ContentSteering */ "./src/dash/vo/ContentSteering.js");
/* harmony import */ var _streaming_utils_ObjectUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../streaming/utils/ObjectUtils */ "./src/streaming/utils/ObjectUtils.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../streaming/vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _streaming_thumbnail_ThumbnailTracks__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../streaming/thumbnail/ThumbnailTracks */ "./src/streaming/thumbnail/ThumbnailTracks.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




















function DashManifestModel() {
  var instance, logger, errHandler, BASE64;
  var context = this.context;
  var urlUtils = (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_13__["default"])(context).getInstance();

  var isInteger = Number.isInteger || function (value) {
    return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
  };

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_15__["default"])(context).getInstance().getLogger(instance);
  }

  function getIsTypeOf(adaptation, type) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }

    if (!type) {
      throw new Error('type is not defined');
    } // Check for thumbnail images


    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length) {
      var essentialProperties = getEssentialPropertiesForRepresentation(adaptation.Representation_asArray[0]);

      if (essentialProperties && essentialProperties.length > 0 && _streaming_thumbnail_ThumbnailTracks__WEBPACK_IMPORTED_MODULE_18__.THUMBNAILS_SCHEME_ID_URIS.indexOf(essentialProperties[0].schemeIdUri) >= 0) {
        return type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE;
      }
    } // Check ContentComponent.contentType


    if (adaptation.ContentComponent_asArray && adaptation.ContentComponent_asArray.length > 0) {
      if (adaptation.ContentComponent_asArray.length > 1) {
        return type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED;
      } else if (adaptation.ContentComponent_asArray[0].contentType === type) {
        return true;
      }
    }

    var mimeTypeRegEx = type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT ? new RegExp('(ttml|vtt|wvtt|stpp)') : new RegExp(type); // Check codecs

    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length) {
      var codecs = adaptation.Representation_asArray[0].codecs;

      if (mimeTypeRegEx.test(codecs)) {
        return true;
      }
    } // Check Adaptation's mimeType


    if (adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
      return mimeTypeRegEx.test(adaptation.mimeType);
    } // Check Representation's mimeType


    if (adaptation.Representation_asArray) {
      var representation;

      for (var i = 0; i < adaptation.Representation_asArray.length; i++) {
        representation = adaptation.Representation_asArray[i];

        if (representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
          return mimeTypeRegEx.test(representation.mimeType);
        }
      }
    }

    return false;
  }

  function getIsFragmented(adaptation) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }

    if (adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
      return true;
    }

    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0) {
      var representation = adaptation.Representation_asArray[0];

      if (representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
        return true;
      }
    }

    return false;
  }

  function getIsAudio(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO);
  }

  function getIsVideo(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO);
  }

  function getIsText(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT);
  }

  function getIsMuxed(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED);
  }

  function getIsImage(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE);
  }

  function getProducerReferenceTimesForAdaptation(adaptation) {
    var prtArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY) ? adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY] : []; // ProducerReferenceTime elements can also be contained in Representations

    var representationsArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_ASARRAY) ? adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_ASARRAY] : [];
    representationsArray.forEach(function (rep) {
      if (rep.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY)) {
        prtArray.push.apply(prtArray, _toConsumableArray(rep[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY]));
      }
    });
    var prtsForAdaptation = []; // Unlikely to have multiple ProducerReferenceTimes.

    prtArray.forEach(function (prt) {
      var entry = new _vo_ProducerReferenceTime__WEBPACK_IMPORTED_MODULE_10__["default"]();

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      } // Not interested in other attributes for now
      // UTC element contained must be same as that in the MPD


      prtsForAdaptation.push(entry);
    });
    return prtsForAdaptation;
  }

  function getLanguageForAdaptation(adaptation) {
    var lang = '';

    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG)) {
      lang = adaptation.lang;
    }

    return lang;
  }

  function getViewpointForAdaptation(adaptation) {
    return adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT) ? adaptation.Viewpoint : null;
  }

  function getRolesForAdaptation(adaptation) {
    return adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE_ASARRAY) ? adaptation.Role_asArray : [];
  }

  function getAccessibilityForAdaptation(adaptation) {
    return adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY_ASARRAY) ? adaptation.Accessibility_asArray : [];
  }

  function getAudioChannelConfigurationForAdaptation(adaptation) {
    return adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY) ? adaptation.AudioChannelConfiguration_asArray : [];
  }

  function getAudioChannelConfigurationForRepresentation(representation) {
    return representation && representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY) ? representation.AudioChannelConfiguration_asArray : [];
  }

  function getRepresentationSortFunction() {
    return function (a, b) {
      return a.bandwidth - b.bandwidth;
    };
  }

  function processAdaptation(realAdaptation) {
    if (realAdaptation && Array.isArray(realAdaptation.Representation_asArray)) {
      realAdaptation.Representation_asArray.sort(getRepresentationSortFunction());
    }

    return realAdaptation;
  }

  function getRealAdaptations(manifest, periodIndex) {
    return manifest && manifest.Period_asArray && isInteger(periodIndex) ? manifest.Period_asArray[periodIndex] ? manifest.Period_asArray[periodIndex].AdaptationSet_asArray : [] : [];
  }

  function getRealPeriods(manifest) {
    return manifest && manifest.Period_asArray ? manifest.Period_asArray : [];
  }

  function getRealPeriodForIndex(index, manifest) {
    var realPeriods = getRealPeriods(manifest);

    if (realPeriods.length > 0 && isInteger(index)) {
      return realPeriods[index];
    } else {
      return null;
    }
  }

  function getAdaptationForId(id, manifest, periodIndex) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);
    var i, len;

    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (realAdaptations[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) && realAdaptations[i].id === id) {
        return realAdaptations[i];
      }
    }

    return null;
  }

  function getAdaptationForIndex(index, manifest, periodIndex) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);

    if (realAdaptations.length > 0 && isInteger(index)) {
      return realAdaptations[index];
    } else {
      return null;
    }
  }

  function getIndexForAdaptation(realAdaptation, manifest, periodIndex) {
    if (!realAdaptation) {
      return -1;
    }

    var realAdaptations = getRealAdaptations(manifest, periodIndex);

    for (var i = 0; i < realAdaptations.length; i++) {
      var objectUtils = (0,_streaming_utils_ObjectUtils__WEBPACK_IMPORTED_MODULE_12__["default"])(context).getInstance();

      if (objectUtils.areEqual(realAdaptations[i], realAdaptation)) {
        return i;
      }
    }

    return -1;
  }

  function getAdaptationsForType(manifest, periodIndex, type) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);
    var i, len;
    var adaptations = [];

    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (getIsTypeOf(realAdaptations[i], type)) {
        adaptations.push(processAdaptation(realAdaptations[i]));
      }
    }

    return adaptations;
  }

  function getCodec(adaptation, representationId, addResolutionInfo) {
    var codec = null;

    if (adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0) {
      var representation = isInteger(representationId) && representationId >= 0 && representationId < adaptation.Representation_asArray.length ? adaptation.Representation_asArray[representationId] : adaptation.Representation_asArray[0];

      if (representation) {
        codec = representation.mimeType + ';codecs="' + representation.codecs + '"';

        if (addResolutionInfo && representation.width !== undefined) {
          codec += ';width="' + representation.width + '";height="' + representation.height + '"';
        }
      }
    } // If the codec contains a profiles parameter we remove it. Otherwise it will cause problems when checking for codec capabilities of the platform


    if (codec) {
      codec = codec.replace(/\sprofiles=[^;]*/g, '');
    }

    return codec;
  }

  function getMimeType(adaptation) {
    return adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0 ? adaptation.Representation_asArray[0].mimeType : null;
  }

  function getKID(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CENC_DEFAULT_KID)) {
      return null;
    }

    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CENC_DEFAULT_KID];
  }

  function getLabelsForAdaptation(adaptation) {
    if (!adaptation || !Array.isArray(adaptation.Label_asArray)) {
      return [];
    }

    var labelArray = [];

    for (var i = 0; i < adaptation.Label_asArray.length; i++) {
      labelArray.push({
        lang: adaptation.Label_asArray[i].lang,
        text: adaptation.Label_asArray[i].__text || adaptation.Label_asArray[i]
      });
    }

    return labelArray;
  }

  function getContentProtectionData(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENTPROTECTION_ASARRAY) || adaptation.ContentProtection_asArray.length === 0) {
      return null;
    }

    return adaptation.ContentProtection_asArray;
  }

  function getIsDynamic(manifest) {
    var isDynamic = false;

    if (manifest && manifest.hasOwnProperty('type')) {
      isDynamic = manifest.type === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DYNAMIC;
    }

    return isDynamic;
  }

  function getId(manifest) {
    return manifest && manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID] || null;
  }

  function hasProfile(manifest, profile) {
    var has = false;

    if (manifest && manifest.profiles && manifest.profiles.length > 0) {
      has = manifest.profiles.indexOf(profile) !== -1;
    }

    return has;
  }

  function getDuration(manifest) {
    var mpdDuration; //@mediaPresentationDuration specifies the duration of the entire Media Presentation.
    //If the attribute is not present, the duration of the Media Presentation is unknown.

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_PRESENTATION_DURATION)) {
      mpdDuration = manifest.mediaPresentationDuration;
    } else if (manifest && manifest.type == 'dynamic') {
      mpdDuration = Number.POSITIVE_INFINITY;
    } else {
      mpdDuration = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
    }

    return mpdDuration;
  }

  function getBandwidth(representation) {
    return representation && representation.bandwidth ? representation.bandwidth : NaN;
  }

  function getManifestUpdatePeriod(manifest) {
    var latencyOfLastUpdate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var delay = NaN;

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MINIMUM_UPDATE_PERIOD)) {
      delay = manifest.minimumUpdatePeriod;
    }

    return isNaN(delay) ? delay : Math.max(delay - latencyOfLastUpdate, 1);
  }

  function getPublishTime(manifest) {
    return manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME) ? new Date(manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME]) : null;
  }

  function getRepresentationCount(adaptation) {
    return adaptation && Array.isArray(adaptation.Representation_asArray) ? adaptation.Representation_asArray.length : 0;
  }

  function getBitrateListForAdaptation(realAdaptation) {
    var processedRealAdaptation = processAdaptation(realAdaptation);
    var realRepresentations = processedRealAdaptation && Array.isArray(processedRealAdaptation.Representation_asArray) ? processedRealAdaptation.Representation_asArray : [];
    return realRepresentations.map(function (realRepresentation) {
      return {
        bandwidth: realRepresentation.bandwidth,
        width: realRepresentation.width || 0,
        height: realRepresentation.height || 0,
        scanType: realRepresentation.scanType || null,
        id: realRepresentation.id || null
      };
    });
  }

  function getSelectionPriority(realAdaption) {
    try {
      var priority = realAdaption && typeof realAdaption.selectionPriority !== 'undefined' ? parseInt(realAdaption.selectionPriority) : 1;
      return isNaN(priority) ? 1 : priority;
    } catch (e) {
      return 1;
    }
  }

  function getEssentialPropertiesForRepresentation(realRepresentation) {
    if (!realRepresentation || !realRepresentation.EssentialProperty_asArray || !realRepresentation.EssentialProperty_asArray.length) return null;
    return realRepresentation.EssentialProperty_asArray.map(function (prop) {
      return {
        schemeIdUri: prop.schemeIdUri,
        value: prop.value
      };
    });
  }

  function getRepresentationFor(index, adaptation) {
    return adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0 && isInteger(index) ? adaptation.Representation_asArray[index] : null;
  }

  function getRealAdaptationFor(voAdaptation) {
    if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
      var periodArray = voAdaptation.period.mpd.manifest.Period_asArray[voAdaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(voAdaptation.index)) {
        return processAdaptation(periodArray.AdaptationSet_asArray[voAdaptation.index]);
      }
    }
  }

  function getRepresentationsForAdaptation(voAdaptation) {
    var voRepresentations = [];
    var processedRealAdaptation = getRealAdaptationFor(voAdaptation);
    var segmentInfo, baseUrl;

    if (processedRealAdaptation && processedRealAdaptation.Representation_asArray) {
      // TODO: TO BE REMOVED. We should get just the baseUrl elements that affects to the representations
      // that we are processing. Making it works properly will require much further changes and given
      // parsing base Urls parameters is needed for our ultra low latency examples, we will
      // keep this "tricky" code until the real (and good) solution comes
      if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
        var baseUrls = getBaseURLsFromElement(voAdaptation.period.mpd.manifest);

        if (baseUrls) {
          baseUrl = baseUrls[0];
        }
      }

      for (var i = 0, len = processedRealAdaptation.Representation_asArray.length; i < len; ++i) {
        var realRepresentation = processedRealAdaptation.Representation_asArray[i];
        var voRepresentation = new _vo_Representation__WEBPACK_IMPORTED_MODULE_2__["default"]();
        voRepresentation.index = i;
        voRepresentation.adaptation = voAdaptation;

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
          voRepresentation.id = realRepresentation.id;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS)) {
          voRepresentation.codecs = realRepresentation.codecs;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
          voRepresentation.mimeType = realRepresentation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE];
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODEC_PRIVATE_DATA)) {
          voRepresentation.codecPrivateData = realRepresentation.codecPrivateData;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BANDWITH)) {
          voRepresentation.bandwidth = realRepresentation.bandwidth;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WIDTH)) {
          voRepresentation.width = realRepresentation.width;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].HEIGHT)) {
          voRepresentation.height = realRepresentation.height;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SCAN_TYPE)) {
          voRepresentation.scanType = realRepresentation.scanType;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_PLAYOUT_RATE)) {
          voRepresentation.maxPlayoutRate = realRepresentation.maxPlayoutRate;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
          segmentInfo = realRepresentation.SegmentBase;
          voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE;
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST)) {
          segmentInfo = realRepresentation.SegmentList;

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST;
          }
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE)) {
          segmentInfo = realRepresentation.SegmentTemplate;

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION_MINUS)) {
            voRepresentation.initialization = segmentInfo.initialization.split('$Bandwidth$').join(realRepresentation.bandwidth).split('$RepresentationID$').join(realRepresentation.id);
          }
        } else {
          voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BASE_URL;
        }

        voRepresentation.essentialProperties = getEssentialPropertiesForRepresentation(realRepresentation);

        if (segmentInfo) {
          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION)) {
            var initialization = segmentInfo.Initialization;

            if (initialization.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SOURCE_URL)) {
              voRepresentation.initialization = initialization.sourceURL;
            }

            if (initialization.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE)) {
              voRepresentation.range = initialization.range; // initialization source url will be determined from
              // BaseURL when resolved at load time.
            }
          } else if (getIsText(processedRealAdaptation) && getIsFragmented(processedRealAdaptation) && processedRealAdaptation.mimeType && processedRealAdaptation.mimeType.indexOf('application/mp4') === -1) {
            voRepresentation.range = 0;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
            voRepresentation.timescale = segmentInfo.timescale;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
            // TODO according to the spec @maxSegmentDuration specifies the maximum duration of any Segment in any Representation in the Media Presentation
            // It is also said that for a SegmentTimeline any @d value shall not exceed the value of MPD@maxSegmentDuration, but nothing is said about
            // SegmentTemplate @duration attribute. We need to find out if @maxSegmentDuration should be used instead of calculated duration if the the duration
            // exceeds @maxSegmentDuration
            voRepresentation.segmentDuration = segmentInfo.duration / voRepresentation.timescale;
          } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE)) {
            segmentInfo = realRepresentation.SegmentTemplate;

            if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
              voRepresentation.segmentDuration = calcSegmentDuration(segmentInfo.SegmentTimeline) / voRepresentation.timescale;
            }
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA)) {
            voRepresentation.media = segmentInfo.media;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START_NUMBER)) {
            voRepresentation.startNumber = segmentInfo.startNumber;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE)) {
            voRepresentation.indexRange = segmentInfo.indexRange;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET)) {
            voRepresentation.presentationTimeOffset = segmentInfo.presentationTimeOffset / voRepresentation.timescale;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET)) {
            voRepresentation.availabilityTimeOffset = segmentInfo.availabilityTimeOffset;
          } else if (baseUrl && baseUrl.availabilityTimeOffset !== undefined) {
            voRepresentation.availabilityTimeOffset = baseUrl.availabilityTimeOffset;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE)) {
            voRepresentation.availabilityTimeComplete = segmentInfo.availabilityTimeComplete !== 'false';
          } else if (baseUrl && baseUrl.availabilityTimeComplete !== undefined) {
            voRepresentation.availabilityTimeComplete = baseUrl.availabilityTimeComplete;
          }
        }

        voRepresentation.MSETimeOffset = calcMSETimeOffset(voRepresentation);
        voRepresentation.path = [voAdaptation.period.index, voAdaptation.index, i];
        voRepresentations.push(voRepresentation);
      }
    }

    return voRepresentations;
  }

  function calcSegmentDuration(segmentTimeline) {
    if (!segmentTimeline || !segmentTimeline.S_asArray) {
      return NaN;
    }

    var s0 = segmentTimeline.S_asArray[0];
    var s1 = segmentTimeline.S_asArray[1];
    return s0.hasOwnProperty('d') ? s0.d : s1.t - s0.t;
  }

  function calcMSETimeOffset(representation) {
    // The MSEOffset is offset from AST for media. It is Period@start - presentationTimeOffset
    var presentationOffset = representation.presentationTimeOffset;
    var periodStart = representation.adaptation.period.start;
    return periodStart - presentationOffset;
  }

  function getAdaptationsForPeriod(voPeriod) {
    var realPeriod = voPeriod && isInteger(voPeriod.index) ? voPeriod.mpd.manifest.Period_asArray[voPeriod.index] : null;
    var voAdaptations = [];
    var voAdaptationSet, realAdaptationSet, i;

    if (realPeriod && realPeriod.AdaptationSet_asArray) {
      for (i = 0; i < realPeriod.AdaptationSet_asArray.length; i++) {
        realAdaptationSet = realPeriod.AdaptationSet_asArray[i];
        voAdaptationSet = new _vo_AdaptationSet__WEBPACK_IMPORTED_MODULE_3__["default"]();

        if (realAdaptationSet.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
          voAdaptationSet.id = realAdaptationSet.id;
        }

        voAdaptationSet.index = i;
        voAdaptationSet.period = voPeriod;

        if (getIsMuxed(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED;
        } else if (getIsAudio(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO;
        } else if (getIsVideo(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO;
        } else if (getIsText(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT;
        } else if (getIsImage(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE;
        } else {
          logger.warn('Unknown Adaptation stream type');
        }

        voAdaptations.push(voAdaptationSet);
      }
    }

    return voAdaptations;
  }

  function getRegularPeriods(mpd) {
    var isDynamic = mpd ? getIsDynamic(mpd.manifest) : false;
    var voPeriods = [];
    var realPreviousPeriod = null;
    var realPeriod = null;
    var voPreviousPeriod = null;
    var voPeriod = null;
    var len, i;

    for (i = 0, len = mpd && mpd.manifest && mpd.manifest.Period_asArray ? mpd.manifest.Period_asArray.length : 0; i < len; i++) {
      realPeriod = mpd.manifest.Period_asArray[i]; // If the attribute @start is present in the Period, then the
      // Period is a regular Period and the PeriodStart is equal
      // to the value of this attribute.

      if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START)) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = realPeriod.start;
      } // If the @start attribute is absent, but the previous Period
      // element contains a @duration attribute then then this new
      // Period is also a regular Period. The start time of the new
      // Period PeriodStart is the sum of the start time of the previous
      // Period PeriodStart and the value of the attribute @duration
      // of the previous Period.
      else if (realPreviousPeriod !== null && realPreviousPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION) && voPreviousPeriod !== null) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = parseFloat((voPreviousPeriod.start + voPreviousPeriod.duration).toFixed(5));
      } // If (i) @start attribute is absent, and (ii) the Period element
      // is the first in the MPD, and (iii) the MPD@type is 'static',
      // then the PeriodStart time shall be set to zero.
      else if (i === 0 && !isDynamic) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = 0;
      } // The Period extends until the PeriodStart of the next Period.
      // The difference between the PeriodStart time of a Period and
      // the PeriodStart time of the following Period.


      if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
        if (voPeriod !== null) {
          voPreviousPeriod.duration = parseFloat((voPeriod.start - voPreviousPeriod.start).toFixed(5));
        } else {
          logger.warn('First period duration could not be calculated because lack of start and duration period properties. This will cause timing issues during playback');
        }
      }

      if (voPeriod !== null) {
        voPeriod.id = getPeriodId(realPeriod, i);
        voPeriod.index = i;
        voPeriod.mpd = mpd;

        if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
          voPeriod.duration = realPeriod.duration;
        }

        if (voPreviousPeriod) {
          voPreviousPeriod.nextPeriodId = voPeriod.id;
        }

        voPeriods.push(voPeriod);
        realPreviousPeriod = realPeriod;
        voPreviousPeriod = voPeriod;
      }

      realPeriod = null;
      voPeriod = null;
    }

    if (voPeriods.length === 0) {
      return voPeriods;
    } // The last Period extends until the end of the Media Presentation.
    // The difference between the PeriodStart time of the last Period
    // and the mpd duration


    if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
      voPreviousPeriod.duration = parseFloat((getEndTimeForLastPeriod(voPreviousPeriod) - voPreviousPeriod.start).toFixed(5));
    }

    return voPeriods;
  }

  function getPeriodId(realPeriod, i) {
    if (!realPeriod) {
      throw new Error('Period cannot be null or undefined');
    }

    var id = _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"].DEFAULT_ID + '_' + i;

    if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) && realPeriod.id.length > 0 && realPeriod.id !== '__proto__') {
      id = realPeriod.id;
    }

    return id;
  }

  function getMpd(manifest) {
    var mpd = new _vo_Mpd__WEBPACK_IMPORTED_MODULE_5__["default"]();

    if (manifest) {
      mpd.manifest = manifest;

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME)) {
        mpd.availabilityStartTime = new Date(manifest.availabilityStartTime.getTime());
      } else {
        if (manifest.loadedTime) {
          mpd.availabilityStartTime = new Date(manifest.loadedTime.getTime());
        }
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_END_TIME)) {
        mpd.availabilityEndTime = new Date(manifest.availabilityEndTime.getTime());
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MINIMUM_UPDATE_PERIOD)) {
        mpd.minimumUpdatePeriod = manifest.minimumUpdatePeriod;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_PRESENTATION_DURATION)) {
        mpd.mediaPresentationDuration = manifest.mediaPresentationDuration;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUGGESTED_PRESENTATION_DELAY)) {
        mpd.suggestedPresentationDelay = manifest.suggestedPresentationDelay;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESHIFT_BUFFER_DEPTH)) {
        mpd.timeShiftBufferDepth = manifest.timeShiftBufferDepth;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_SEGMENT_DURATION)) {
        mpd.maxSegmentDuration = manifest.maxSegmentDuration;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME)) {
        mpd.publishTime = new Date(manifest.publishTime);
      }
    }

    return mpd;
  }

  function checkConfig() {
    if (!errHandler || !errHandler.hasOwnProperty('error')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getEndTimeForLastPeriod(voPeriod) {
    checkConfig();
    var isDynamic = getIsDynamic(voPeriod.mpd.manifest);
    var periodEnd;

    if (voPeriod.mpd.manifest.mediaPresentationDuration) {
      periodEnd = voPeriod.mpd.manifest.mediaPresentationDuration;
    } else if (voPeriod.duration) {
      periodEnd = voPeriod.duration;
    } else if (isDynamic) {
      periodEnd = Number.POSITIVE_INFINITY;
    } else {
      errHandler.error(new _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_16__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_17__["default"].MANIFEST_ERROR_ID_PARSE_CODE, 'Must have @mediaPresentationDuration on MPD or an explicit @duration on the last period.', voPeriod));
    }

    return periodEnd;
  }

  function getEventsForPeriod(period) {
    var manifest = period && period.mpd && period.mpd.manifest ? period.mpd.manifest : null;
    var periodArray = manifest ? manifest.Period_asArray : null;
    var eventStreams = periodArray && period && isInteger(period.index) ? periodArray[period.index].EventStream_asArray : null;
    var events = [];
    var i, j;

    if (eventStreams) {
      for (i = 0; i < eventStreams.length; i++) {
        var eventStream = new _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__["default"]();
        eventStream.period = period;
        eventStream.timescale = 1;

        if (eventStreams[i].hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
          eventStream.schemeIdUri = eventStreams[i][_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI];
        } else {
          throw new Error('Invalid EventStream. SchemeIdUri has to be set');
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
          eventStream.timescale = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE];
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
          eventStream.value = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE];
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET)) {
          eventStream.presentationTimeOffset = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET];
        }

        for (j = 0; eventStreams[i].Event_asArray && j < eventStreams[i].Event_asArray.length; j++) {
          var currentMpdEvent = eventStreams[i].Event_asArray[j];
          var event = new _vo_Event__WEBPACK_IMPORTED_MODULE_7__["default"]();
          event.presentationTime = 0;
          event.eventStream = eventStream;

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME)) {
            event.presentationTime = currentMpdEvent.presentationTime;
          }

          var presentationTimeOffset = eventStream.presentationTimeOffset ? eventStream.presentationTimeOffset / eventStream.timescale : 0;
          event.calculatedPresentationTime = event.presentationTime / eventStream.timescale + period.start - presentationTimeOffset;

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
            event.duration = currentMpdEvent.duration / eventStream.timescale;
          }

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
            event.id = currentMpdEvent.id;
          } else {
            event.id = null;
          }

          if (currentMpdEvent.Signal && currentMpdEvent.Signal.Binary) {
            // toString is used to manage both regular and namespaced tags
            event.messageData = BASE64.decodeArray(currentMpdEvent.Signal.Binary.toString());
          } else {
            // From Cor.1: 'NOTE: this attribute is an alternative
            // to specifying a complete XML element(s) in the Event.
            // It is useful when an event leans itself to a compact
            // string representation'.
            event.messageData = currentMpdEvent.messageData || currentMpdEvent.__cdata || currentMpdEvent.__text;
          }

          events.push(event);
        }
      }
    }

    return events;
  }

  function getEventStreams(inbandStreams, representation, period) {
    var eventStreams = [];
    var i;
    if (!inbandStreams) return eventStreams;

    for (i = 0; i < inbandStreams.length; i++) {
      var eventStream = new _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__["default"]();
      eventStream.timescale = 1;
      eventStream.representation = representation;

      if (inbandStreams[i].hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
        eventStream.schemeIdUri = inbandStreams[i].schemeIdUri;
      } else {
        throw new Error('Invalid EventStream. SchemeIdUri has to be set');
      }

      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
        eventStream.timescale = inbandStreams[i].timescale;
      }

      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
        eventStream.value = inbandStreams[i].value;
      }

      eventStreams.push(eventStream);
      eventStream.period = period;
    }

    return eventStreams;
  }

  function getEventStreamForAdaptationSet(manifest, adaptation, period) {
    var inbandStreams, periodArray, adaptationArray;

    if (manifest && manifest.Period_asArray && adaptation && adaptation.period && isInteger(adaptation.period.index)) {
      periodArray = manifest.Period_asArray[adaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet_asArray[adaptation.index];

        if (adaptationArray) {
          inbandStreams = adaptationArray.InbandEventStream_asArray;
        }
      }
    }

    return getEventStreams(inbandStreams, null, period);
  }

  function getEventStreamForRepresentation(manifest, representation, period) {
    var inbandStreams, periodArray, adaptationArray, representationArray;

    if (manifest && manifest.Period_asArray && representation && representation.adaptation && representation.adaptation.period && isInteger(representation.adaptation.period.index)) {
      periodArray = manifest.Period_asArray[representation.adaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(representation.adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet_asArray[representation.adaptation.index];

        if (adaptationArray && adaptationArray.Representation_asArray && isInteger(representation.index)) {
          representationArray = adaptationArray.Representation_asArray[representation.index];

          if (representationArray) {
            inbandStreams = representationArray.InbandEventStream_asArray;
          }
        }
      }
    }

    return getEventStreams(inbandStreams, representation, period);
  }

  function getUTCTimingSources(manifest) {
    var isDynamic = getIsDynamic(manifest);
    var hasAST = manifest ? manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME) : false;
    var utcTimingsArray = manifest ? manifest.UTCTiming_asArray : null;
    var utcTimingEntries = []; // do not bother synchronizing the clock unless MPD is live,
    // or it is static and has availabilityStartTime attribute

    if (isDynamic || hasAST) {
      if (utcTimingsArray) {
        // the order is important here - 23009-1 states that the order
        // in the manifest "indicates relative preference, first having
        // the highest, and the last the lowest priority".
        utcTimingsArray.forEach(function (utcTiming) {
          var entry = new _vo_UTCTiming__WEBPACK_IMPORTED_MODULE_6__["default"]();

          if (utcTiming.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
            entry.schemeIdUri = utcTiming.schemeIdUri;
          } else {
            // entries of type DescriptorType with no schemeIdUri
            // are meaningless. let's just ignore this entry and
            // move on.
            return;
          } // this is (incorrectly) interpreted as a number - schema
          // defines it as a string


          if (utcTiming.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
            entry.value = utcTiming.value.toString();
          } else {
            // without a value, there's not a lot we can do with
            // this entry. let's just ignore this one and move on
            return;
          } // we're not interested in the optional id or any other
          // attributes which might be attached to the entry


          utcTimingEntries.push(entry);
        });
      }
    }

    return utcTimingEntries;
  }

  function getBaseURLsFromElement(node) {
    var baseUrls = []; // if node.BaseURL_asArray and node.baseUri are undefined entries
    // will be [undefined] which entries.some will just skip

    var entries = node.BaseURL_asArray || [node.baseUri];
    var earlyReturn = false;
    entries.some(function (entry) {
      if (entry) {
        var baseUrl = new _vo_BaseURL__WEBPACK_IMPORTED_MODULE_8__["default"]();
        var text = entry.__text || entry;

        if (urlUtils.isRelative(text)) {
          // it doesn't really make sense to have relative and
          // absolute URLs at the same level, or multiple
          // relative URLs at the same level, so assume we are
          // done from this level of the MPD
          earlyReturn = true; // deal with the specific case where the MPD@BaseURL
          // is specified and is relative. when no MPD@BaseURL
          // entries exist, that case is handled by the
          // [node.baseUri] in the entries definition.

          if (node.baseUri) {
            text = urlUtils.resolve(text, node.baseUri);
          }
        }

        baseUrl.url = text; // serviceLocation is optional, but we need it in order
        // to blacklist correctly. if it's not available, use
        // anything unique since there's no relationship to any
        // other BaseURL and, in theory, the url should be
        // unique so use this instead.

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION) && entry.serviceLocation.length) {
          baseUrl.serviceLocation = entry.serviceLocation;
        } else {
          baseUrl.serviceLocation = text;
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_PRIORITY)) {
          baseUrl.dvb_priority = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_PRIORITY];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_WEIGHT)) {
          baseUrl.dvb_weight = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_WEIGHT];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET)) {
          baseUrl.availabilityTimeOffset = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE)) {
          baseUrl.availabilityTimeComplete = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE] !== 'false';
        }
        /* NOTE: byteRange currently unused
         */


        baseUrls.push(baseUrl);
        return earlyReturn;
      }
    });
    return baseUrls;
  }

  function getContentSteering(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING_AS_ARRAY)) {
      // Only one ContentSteering element is supported on MPD level
      var element = manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING_AS_ARRAY][0];
      var entry = new _vo_ContentSteering__WEBPACK_IMPORTED_MODULE_11__["default"]();
      entry.serverUrl = element.__text;

      if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_SERVICE_LOCATION)) {
        entry.defaultServiceLocation = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_SERVICE_LOCATION];
      }

      if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].QUERY_BEFORE_START)) {
        entry.queryBeforeStart = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].QUERY_BEFORE_START].toLowerCase() === 'true';
      }

      if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROXY_SERVER_URL)) {
        entry.proxyServerUrl = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROXY_SERVER_URL];
      }

      return entry;
    }

    return undefined;
  }

  function getLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].LOCATION)) {
      // for now, do not support multiple Locations -
      // just set Location to the first Location.
      manifest.Location = manifest.Location_asArray[0];
      return manifest.Location;
    } // may well be undefined


    return undefined;
  }

  function getPatchLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PATCH_LOCATION)) {
      // only include support for single patch location currently
      manifest.PatchLocation = manifest.PatchLocation_asArray[0];
      return manifest.PatchLocation;
    } // no patch location provided


    return undefined;
  }

  function getSuggestedPresentationDelay(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUGGESTED_PRESENTATION_DELAY) ? mpd.suggestedPresentationDelay : null;
  }

  function getAvailabilityStartTime(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME) && mpd.availabilityStartTime !== null ? mpd.availabilityStartTime.getTime() : null;
  }

  function getServiceDescriptions(manifest) {
    var serviceDescriptions = [];

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION)) {
      var _iterator = _createForOfIteratorHelper(manifest.ServiceDescription_asArray),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var sd = _step.value;
          // Convert each of the properties defined in
          var id = null,
              schemeIdUri = null,
              latency = null,
              playbackRate = null,
              operatingQuality = null,
              operatingBandwidth = null;

          for (var prop in sd) {
            if (sd.hasOwnProperty(prop)) {
              if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) {
                id = sd[prop];
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_SCOPE) {
                schemeIdUri = sd[prop].schemeIdUri;
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_LATENCY) {
                latency = {
                  target: parseInt(sd[prop].target),
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  referenceId: parseInt(sd[prop].referenceId)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_PLAYBACK_RATE) {
                playbackRate = {
                  max: parseFloat(sd[prop].max),
                  min: parseFloat(sd[prop].min)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_OPERATING_QUALITY) {
                operatingQuality = {
                  mediaType: sd[prop].mediaType,
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  target: parseInt(sd[prop].target),
                  type: sd[prop].type,
                  maxQualityDifference: parseInt(sd[prop].maxQualityDifference)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_OPERATING_BANDWIDTH) {
                operatingBandwidth = {
                  mediaType: sd[prop].mediaType,
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  target: parseInt(sd[prop].target)
                };
              }
            }
          }

          serviceDescriptions.push({
            id: id,
            schemeIdUri: schemeIdUri,
            latency: latency,
            playbackRate: playbackRate,
            operatingQuality: operatingQuality,
            operatingBandwidth: operatingBandwidth
          });
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    return serviceDescriptions;
  }

  function getSupplementalProperties(adaptation) {
    var supplementalProperties = {};

    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY)) {
      var _iterator2 = _createForOfIteratorHelper(adaptation.SupplementalProperty_asArray),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var sp = _step2.value;

          if (sp.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI) && sp.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
            supplementalProperties[sp[_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI]] = sp[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE];
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    return supplementalProperties;
  }

  function setConfig(config) {
    if (!config) return;

    if (config.errHandler) {
      errHandler = config.errHandler;
    }

    if (config.BASE64) {
      BASE64 = config.BASE64;
    }
  }

  instance = {
    getIsTypeOf: getIsTypeOf,
    getIsText: getIsText,
    getIsFragmented: getIsFragmented,
    getProducerReferenceTimesForAdaptation: getProducerReferenceTimesForAdaptation,
    getLanguageForAdaptation: getLanguageForAdaptation,
    getViewpointForAdaptation: getViewpointForAdaptation,
    getRolesForAdaptation: getRolesForAdaptation,
    getAccessibilityForAdaptation: getAccessibilityForAdaptation,
    getAudioChannelConfigurationForAdaptation: getAudioChannelConfigurationForAdaptation,
    getAudioChannelConfigurationForRepresentation: getAudioChannelConfigurationForRepresentation,
    getAdaptationForIndex: getAdaptationForIndex,
    getIndexForAdaptation: getIndexForAdaptation,
    getAdaptationForId: getAdaptationForId,
    getAdaptationsForType: getAdaptationsForType,
    getRealPeriods: getRealPeriods,
    getRealPeriodForIndex: getRealPeriodForIndex,
    getCodec: getCodec,
    getSelectionPriority: getSelectionPriority,
    getMimeType: getMimeType,
    getKID: getKID,
    getLabelsForAdaptation: getLabelsForAdaptation,
    getContentProtectionData: getContentProtectionData,
    getIsDynamic: getIsDynamic,
    getId: getId,
    hasProfile: hasProfile,
    getDuration: getDuration,
    getBandwidth: getBandwidth,
    getManifestUpdatePeriod: getManifestUpdatePeriod,
    getPublishTime: getPublishTime,
    getRepresentationCount: getRepresentationCount,
    getBitrateListForAdaptation: getBitrateListForAdaptation,
    getRepresentationFor: getRepresentationFor,
    getRepresentationsForAdaptation: getRepresentationsForAdaptation,
    getAdaptationsForPeriod: getAdaptationsForPeriod,
    getRegularPeriods: getRegularPeriods,
    getMpd: getMpd,
    getEventsForPeriod: getEventsForPeriod,
    getEssentialPropertiesForRepresentation: getEssentialPropertiesForRepresentation,
    getEventStreamForAdaptationSet: getEventStreamForAdaptationSet,
    getEventStreamForRepresentation: getEventStreamForRepresentation,
    getUTCTimingSources: getUTCTimingSources,
    getBaseURLsFromElement: getBaseURLsFromElement,
    getRepresentationSortFunction: getRepresentationSortFunction,
    getContentSteering: getContentSteering,
    getLocation: getLocation,
    getPatchLocation: getPatchLocation,
    getSuggestedPresentationDelay: getSuggestedPresentationDelay,
    getAvailabilityStartTime: getAvailabilityStartTime,
    getServiceDescriptions: getServiceDescriptions,
    getSupplementalProperties: getSupplementalProperties,
    setConfig: setConfig
  };
  setup();
  return instance;
}

DashManifestModel.__dashjs_factory_name = 'DashManifestModel';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_14__["default"].getSingletonFactory(DashManifestModel));

/***/ }),

/***/ "./src/dash/parser/DashParser.js":
/*!***************************************!*\
  !*** ./src/dash/parser/DashParser.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _objectiron__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./objectiron */ "./src/dash/parser/objectiron.js");
/* harmony import */ var _externals_xml2json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../externals/xml2json */ "./externals/xml2json.js");
/* harmony import */ var _matchers_StringMatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./matchers/StringMatcher */ "./src/dash/parser/matchers/StringMatcher.js");
/* harmony import */ var _matchers_DurationMatcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./matchers/DurationMatcher */ "./src/dash/parser/matchers/DurationMatcher.js");
/* harmony import */ var _matchers_DateTimeMatcher__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./matchers/DateTimeMatcher */ "./src/dash/parser/matchers/DateTimeMatcher.js");
/* harmony import */ var _matchers_NumericMatcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./matchers/NumericMatcher */ "./src/dash/parser/matchers/NumericMatcher.js");
/* harmony import */ var _matchers_LangMatcher__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./matchers/LangMatcher */ "./src/dash/parser/matchers/LangMatcher.js");
/* harmony import */ var _maps_RepresentationBaseValuesMap__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./maps/RepresentationBaseValuesMap */ "./src/dash/parser/maps/RepresentationBaseValuesMap.js");
/* harmony import */ var _maps_SegmentValuesMap__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./maps/SegmentValuesMap */ "./src/dash/parser/maps/SegmentValuesMap.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */











function DashParser(config) {
  config = config || {};
  var context = this.context;
  var debug = config.debug;
  var instance, logger, matchers, converter, objectIron;

  function setup() {
    logger = debug.getLogger(instance);
    matchers = [new _matchers_DurationMatcher__WEBPACK_IMPORTED_MODULE_4__["default"](), new _matchers_DateTimeMatcher__WEBPACK_IMPORTED_MODULE_5__["default"](), new _matchers_NumericMatcher__WEBPACK_IMPORTED_MODULE_6__["default"](), new _matchers_LangMatcher__WEBPACK_IMPORTED_MODULE_7__["default"](), new _matchers_StringMatcher__WEBPACK_IMPORTED_MODULE_3__["default"]() // last in list to take precedence over NumericMatcher
    ];
    converter = new _externals_xml2json__WEBPACK_IMPORTED_MODULE_2__["default"]({
      escapeMode: false,
      attributePrefix: '',
      arrayAccessForm: 'property',
      emptyNodeForm: 'object',
      stripWhitespaces: false,
      enableToStringFunc: true,
      ignoreRoot: false,
      matchers: matchers
    });
    objectIron = (0,_objectiron__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      adaptationset: new _maps_RepresentationBaseValuesMap__WEBPACK_IMPORTED_MODULE_8__["default"](),
      period: new _maps_SegmentValuesMap__WEBPACK_IMPORTED_MODULE_9__["default"]()
    });
  }

  function getMatchers() {
    return matchers;
  }

  function getIron() {
    return objectIron;
  }

  function parse(data) {
    var manifest;
    var startTime = window.performance.now();
    manifest = converter.xml_str2json(data);

    if (!manifest) {
      throw new Error('parsing the manifest failed');
    }

    var jsonTime = window.performance.now(); // handle full MPD and Patch ironing separately

    if (manifest.Patch) {
      manifest = manifest.Patch; // drop root reference
      // apply iron to patch operations individually

      if (manifest.add_asArray) {
        manifest.add_asArray.forEach(function (operand) {
          return objectIron.run(operand);
        });
      }

      if (manifest.replace_asArray) {
        manifest.replace_asArray.forEach(function (operand) {
          return objectIron.run(operand);
        });
      } // note that we don't need to iron remove as they contain no children

    } else {
      manifest = manifest.MPD; // drop root reference

      objectIron.run(manifest);
    }

    var ironedTime = window.performance.now();
    logger.info('Parsing complete: ( xml2json: ' + (jsonTime - startTime).toPrecision(3) + 'ms, objectiron: ' + (ironedTime - jsonTime).toPrecision(3) + 'ms, total: ' + ((ironedTime - startTime) / 1000).toPrecision(3) + 's)');
    manifest.protocol = 'DASH';
    return manifest;
  }

  instance = {
    parse: parse,
    getMatchers: getMatchers,
    getIron: getIron
  };
  setup();
  return instance;
}

DashParser.__dashjs_factory_name = 'DashParser';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(DashParser));

/***/ }),

/***/ "./src/dash/parser/maps/CommonProperty.js":
/*!************************************************!*\
  !*** ./src/dash/parser/maps/CommonProperty.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a property belonging to a MapNode
 * @ignore
 */
var CommonProperty = /*#__PURE__*/function () {
  function CommonProperty(name) {
    _classCallCheck(this, CommonProperty);

    var getDefaultMergeForName = function getDefaultMergeForName(n) {
      return n && n.length && n.charAt(0) === n.charAt(0).toUpperCase();
    };

    this._name = name;
    this._merge = getDefaultMergeForName(name);
  }

  _createClass(CommonProperty, [{
    key: "name",
    get: function get() {
      return this._name;
    }
  }, {
    key: "merge",
    get: function get() {
      return this._merge;
    }
  }]);

  return CommonProperty;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CommonProperty);

/***/ }),

/***/ "./src/dash/parser/maps/MapNode.js":
/*!*****************************************!*\
  !*** ./src/dash/parser/maps/MapNode.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _CommonProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CommonProperty */ "./src/dash/parser/maps/CommonProperty.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a node at some level in a ValueMap
 */


var MapNode = /*#__PURE__*/function () {
  function MapNode(name, properties, children) {
    var _this = this;

    _classCallCheck(this, MapNode);

    this._name = name || '';
    this._properties = [];
    this._children = children || [];

    if (Array.isArray(properties)) {
      properties.forEach(function (p) {
        _this._properties.push(new _CommonProperty__WEBPACK_IMPORTED_MODULE_0__["default"](p));
      });
    }
  }

  _createClass(MapNode, [{
    key: "name",
    get: function get() {
      return this._name;
    }
  }, {
    key: "children",
    get: function get() {
      return this._children;
    }
  }, {
    key: "properties",
    get: function get() {
      return this._properties;
    }
  }]);

  return MapNode;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MapNode);

/***/ }),

/***/ "./src/dash/parser/maps/RepresentationBaseValuesMap.js":
/*!*************************************************************!*\
  !*** ./src/dash/parser/maps/RepresentationBaseValuesMap.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _MapNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a RepresentationBaseValuesMap type for input to objectiron
 */



var RepresentationBaseValuesMap = /*#__PURE__*/function (_MapNode) {
  _inherits(RepresentationBaseValuesMap, _MapNode);

  var _super = _createSuper(RepresentationBaseValuesMap);

  function RepresentationBaseValuesMap() {
    _classCallCheck(this, RepresentationBaseValuesMap);

    var commonProperties = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WIDTH, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].HEIGHT, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SAR, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAMERATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_SAMPLING_RATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAXIMUM_SAP_PERIOD, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START_WITH_SAP, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_PLAYOUT_RATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODING_DEPENDENCY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SCAN_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAME_PACKING, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM];
    return _super.call(this, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_REPRESENTATION, commonProperties)])]);
  }

  return RepresentationBaseValuesMap;
}(_MapNode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RepresentationBaseValuesMap);

/***/ }),

/***/ "./src/dash/parser/maps/SegmentValuesMap.js":
/*!**************************************************!*\
  !*** ./src/dash/parser/maps/SegmentValuesMap.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _MapNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a SegmentValuesMap type for input to objectiron
 */



var SegmentValuesMap = /*#__PURE__*/function (_MapNode) {
  _inherits(SegmentValuesMap, _MapNode);

  var _super = _createSuper(SegmentValuesMap);

  function SegmentValuesMap() {
    _classCallCheck(this, SegmentValuesMap);

    var commonProperties = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST];
    return _super.call(this, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties)])]);
  }

  return SegmentValuesMap;
}(_MapNode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SegmentValuesMap);

/***/ }),

/***/ "./src/dash/parser/matchers/BaseMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/BaseMatcher.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a base type for matching and converting types in manifest to
 * something more useful
 * @ignore
 */
var BaseMatcher = /*#__PURE__*/function () {
  function BaseMatcher(test, converter) {
    _classCallCheck(this, BaseMatcher);

    this._test = test;
    this._converter = converter;
  }

  _createClass(BaseMatcher, [{
    key: "test",
    get: function get() {
      return this._test;
    }
  }, {
    key: "converter",
    get: function get() {
      return this._converter;
    }
  }]);

  return BaseMatcher;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DateTimeMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DateTimeMatcher.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc matches and converts xs:datetime to Date
 */

var SECONDS_IN_MIN = 60;
var MINUTES_IN_HOUR = 60;
var MILLISECONDS_IN_SECONDS = 1000;
var datetimeRegex = /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\.[0-9]*)?)?(?:([+-])([0-9]{2})(?::?)([0-9]{2}))?/;

var DateTimeMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(DateTimeMatcher, _BaseMatcher);

  var _super = _createSuper(DateTimeMatcher);

  function DateTimeMatcher() {
    _classCallCheck(this, DateTimeMatcher);

    return _super.call(this, function (attr) {
      return datetimeRegex.test(attr.value);
    }, function (str) {
      var match = datetimeRegex.exec(str);
      var utcDate; // If the string does not contain a timezone offset different browsers can interpret it either
      // as UTC or as a local time so we have to parse the string manually to normalize the given date value for
      // all browsers

      utcDate = Date.UTC(parseInt(match[1], 10), parseInt(match[2], 10) - 1, // months start from zero
      parseInt(match[3], 10), parseInt(match[4], 10), parseInt(match[5], 10), match[6] && parseInt(match[6], 10) || 0, match[7] && parseFloat(match[7]) * MILLISECONDS_IN_SECONDS || 0); // If the date has timezone offset take it into account as well

      if (match[9] && match[10]) {
        var timezoneOffset = parseInt(match[9], 10) * MINUTES_IN_HOUR + parseInt(match[10], 10);
        utcDate += (match[8] === '+' ? -1 : +1) * timezoneOffset * SECONDS_IN_MIN * MILLISECONDS_IN_SECONDS;
      }

      return new Date(utcDate);
    });
  }

  return DateTimeMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DateTimeMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DurationMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DurationMatcher.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc matches and converts xs:duration to seconds
 */



var durationRegex = /^([-])?P(([\d.]*)Y)?(([\d.]*)M)?(([\d.]*)D)?T?(([\d.]*)H)?(([\d.]*)M)?(([\d.]*)S)?/;
var SECONDS_IN_YEAR = 365 * 24 * 60 * 60;
var SECONDS_IN_MONTH = 30 * 24 * 60 * 60;
var SECONDS_IN_DAY = 24 * 60 * 60;
var SECONDS_IN_HOUR = 60 * 60;
var SECONDS_IN_MIN = 60;

var DurationMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(DurationMatcher, _BaseMatcher);

  var _super = _createSuper(DurationMatcher);

  function DurationMatcher() {
    _classCallCheck(this, DurationMatcher);

    return _super.call(this, function (attr) {
      var attributeList = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MIN_BUFFER_TIME, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MEDIA_PRESENTATION_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MINIMUM_UPDATE_PERIOD, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].TIMESHIFT_BUFFER_DEPTH, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SEGMENT_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SUBSEGMENT_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].SUGGESTED_PRESENTATION_DELAY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].START, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].START_TIME, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].DURATION];
      var len = attributeList.length;

      for (var i = 0; i < len; i++) {
        if (attr.nodeName === attributeList[i]) {
          return durationRegex.test(attr.value);
        }
      }

      return false;
    }, function (str) {
      //str = "P10Y10M10DT10H10M10.1S";
      var match = durationRegex.exec(str);
      var result = parseFloat(match[3] || 0) * SECONDS_IN_YEAR + parseFloat(match[5] || 0) * SECONDS_IN_MONTH + parseFloat(match[7] || 0) * SECONDS_IN_DAY + parseFloat(match[9] || 0) * SECONDS_IN_HOUR + parseFloat(match[11] || 0) * SECONDS_IN_MIN + parseFloat(match[13] || 0);

      if (match[1] !== undefined) {
        result = -result;
      }

      return result;
    });
  }

  return DurationMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DurationMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/LangMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/LangMatcher.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bcp-47-normalize */ "./node_modules/bcp-47-normalize/index.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts any ISO 639 language tag to BCP-47 language tags
 */




var LangMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(LangMatcher, _BaseMatcher);

  var _super = _createSuper(LangMatcher);

  function LangMatcher() {
    _classCallCheck(this, LangMatcher);

    return _super.call(this, function (attr, nodeName) {
      var _stringAttrsInElement;

      var stringAttrsInElements = (_stringAttrsInElement = {}, _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LABEL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].GROUP_LABEL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _stringAttrsInElement);

      if (stringAttrsInElements.hasOwnProperty(nodeName)) {
        var attrNames = stringAttrsInElements[nodeName];

        if (attrNames !== undefined) {
          return attrNames.indexOf(attr.name) >= 0;
        } else {
          return false;
        }
      }

      return false;
    }, function (str) {
      var lang = bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2___default()(str);

      if (lang !== undefined) {
        return lang;
      }

      return String(str);
    });
  }

  return LangMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LangMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/NumericMatcher.js":
/*!****************************************************!*\
  !*** ./src/dash/parser/matchers/NumericMatcher.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts xs:numeric to float
 */

var numericRegex = /^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$/;

var NumericMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(NumericMatcher, _BaseMatcher);

  var _super = _createSuper(NumericMatcher);

  function NumericMatcher() {
    _classCallCheck(this, NumericMatcher);

    return _super.call(this, function (attr) {
      return numericRegex.test(attr.value);
    }, function (str) {
      return parseFloat(str);
    });
  }

  return NumericMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NumericMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/StringMatcher.js":
/*!***************************************************!*\
  !*** ./src/dash/parser/matchers/StringMatcher.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts xs:string to string, but only for specific attributes on specific nodes
 */



var StringMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(StringMatcher, _BaseMatcher);

  var _super = _createSuper(StringMatcher);

  function StringMatcher() {
    _classCallCheck(this, StringMatcher);

    return _super.call(this, function (attr, nodeName) {
      var _stringAttrsInElement;

      var stringAttrsInElements = (_stringAttrsInElement = {}, _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MPD, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BASE_URL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BYTE_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_INDEX, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BITSTREAM_SWITCHING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_URL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_RANGE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION_MINUS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BITSTREAM_SWITCHING_MINUS]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ASSET_IDENTIFIER, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_STREAM, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_TYPE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAME_PACKING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RATING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_TYPE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEPENDENCY_ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_STREAM_STRUCTURE_ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUBSET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].METRICS, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].METRICS_MINUS]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPORTING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _stringAttrsInElement);

      if (stringAttrsInElements.hasOwnProperty(nodeName)) {
        var attrNames = stringAttrsInElements[nodeName];

        if (attrNames !== undefined) {
          return attrNames.indexOf(attr.name) >= 0;
        } else {
          return false;
        }
      }

      return false;
    }, function (str) {
      return String(str);
    });
  }

  return StringMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StringMatcher);

/***/ }),

/***/ "./src/dash/parser/objectiron.js":
/*!***************************************!*\
  !*** ./src/dash/parser/objectiron.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function ObjectIron(mappers) {
  function mergeValues(parentItem, childItem) {
    for (var name in parentItem) {
      if (!childItem.hasOwnProperty(name)) {
        childItem[name] = parentItem[name];
      }
    }
  }

  function mapProperties(properties, parent, child) {
    for (var i = 0, len = properties.length; i < len; ++i) {
      var property = properties[i];

      if (parent[property.name]) {
        if (child[property.name]) {
          // check to see if we should merge
          if (property.merge) {
            var parentValue = parent[property.name];
            var childValue = child[property.name]; // complex objects; merge properties

            if (_typeof(parentValue) === 'object' && _typeof(childValue) === 'object') {
              mergeValues(parentValue, childValue);
            } // simple objects; merge them together
            else {
              child[property.name] = parentValue + childValue;
            }
          }
        } else {
          // just add the property
          child[property.name] = parent[property.name];
        }
      }
    }
  }

  function mapItem(item, node) {
    for (var i = 0, len = item.children.length; i < len; ++i) {
      var childItem = item.children[i];
      var array = node[childItem.name + '_asArray'];

      if (array) {
        for (var v = 0, len2 = array.length; v < len2; ++v) {
          var childNode = array[v];
          mapProperties(item.properties, node, childNode);
          mapItem(childItem, childNode);
        }
      }
    }
  }

  function run(source) {
    if (source === null || _typeof(source) !== 'object') {
      return source;
    }

    if (source.Period_asArray && 'period' in mappers) {
      var periodMapper = mappers.period;
      var periods = source.Period_asArray;

      for (var i = 0, len = periods.length; i < len; ++i) {
        var period = periods[i];
        mapItem(periodMapper, period);

        if ('adaptationset' in mappers) {
          var adaptationSets = period.AdaptationSet_asArray;

          if (adaptationSets) {
            var adaptationSetMapper = mappers.adaptationset;

            for (var _i = 0, _len = adaptationSets.length; _i < _len; ++_i) {
              mapItem(adaptationSetMapper, adaptationSets[_i]);
            }
          }
        }
      }
    }

    return source;
  }

  return {
    run: run
  };
}

ObjectIron.__dashjs_factory_name = 'ObjectIron';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ObjectIron);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/utils/ListSegmentsGetter.js":
/*!**********************************************!*\
  !*** ./src/dash/utils/ListSegmentsGetter.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function ListSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation) {
      return mediaFinishedInformation;
    }

    var list = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    var offset = Math.max(startNumber - 1, 0);
    mediaFinishedInformation.numberOfSegments = offset + list.SegmentURL_asArray.length;
    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var list = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var len = list.SegmentURL_asArray.length;
    var startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    var offsetToSubtract = Math.max(startNumber - 1, 0);
    var relativeIndex = Math.max(index - offsetToSubtract, 0);
    var segment = null;

    if (relativeIndex < len) {
      var s = list.SegmentURL_asArray[relativeIndex];
      segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getIndexBasedSegment)(timelineConverter, isDynamic, representation, index);

      if (segment) {
        segment.replacementTime = (startNumber + index - 1) * representation.segmentDuration;
        segment.media = s.media ? s.media : '';
        segment.mediaRange = s.mediaRange;
        segment.indexRange = s.indexRange;
      }
    }

    return segment;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      return null;
    }

    var periodTime = timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation, requestedTime);
    var index = Math.floor(periodTime / duration);
    return getSegmentByIndex(representation, index);
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

ListSegmentsGetter.__dashjs_factory_name = 'ListSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ListSegmentsGetter);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/utils/SegmentBaseGetter.js":
/*!*********************************************!*\
  !*** ./src/dash/utils/SegmentBaseGetter.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



function SegmentBaseGetter(config) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation || !representation.segments) {
      return mediaFinishedInformation;
    }

    mediaFinishedInformation.numberOfSegments = representation.segments.length;
    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var len = representation.segments ? representation.segments.length : -1;
    var seg;

    if (index < len) {
      seg = representation.segments[index];

      if (seg && seg.index === index) {
        return seg;
      }
    }

    for (var i = 0; i < len; i++) {
      seg = representation.segments[i];

      if (seg && seg.index === index) {
        return seg;
      }
    }

    return null;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();
    var index = getIndexByTime(representation, requestedTime);
    return getSegmentByIndex(representation, index);
  }

  function getIndexByTime(representation, time) {
    if (!representation) {
      return -1;
    }

    var segments = representation.segments;
    var ln = segments ? segments.length : null;
    var idx = -1;
    var epsilon, seg, ft, fd, i;

    if (segments && ln > 0) {
      for (i = 0; i < ln; i++) {
        seg = segments[i];
        ft = seg.presentationStartTime;
        fd = seg.duration;
        epsilon = fd / 2;

        if (time + epsilon >= ft && time - epsilon < ft + fd) {
          idx = seg.index;
          break;
        }
      }
    }

    return idx;
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

SegmentBaseGetter.__dashjs_factory_name = 'SegmentBaseGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SegmentBaseGetter);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/utils/SegmentsUtils.js":
/*!*****************************************!*\
  !*** ./src/dash/utils/SegmentsUtils.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getIndexBasedSegment": () => (/* binding */ getIndexBasedSegment),
/* harmony export */   "getTimeBasedSegment": () => (/* binding */ getTimeBasedSegment),
/* harmony export */   "replaceIDForTemplate": () => (/* binding */ replaceIDForTemplate),
/* harmony export */   "replaceTokenForTemplate": () => (/* binding */ replaceTokenForTemplate),
/* harmony export */   "unescapeDollarsInTemplate": () => (/* binding */ unescapeDollarsInTemplate)
/* harmony export */ });
/* harmony import */ var _vo_Segment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../vo/Segment */ "./src/dash/vo/Segment.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function zeroPadToLength(numStr, minStrLength) {
  while (numStr.length < minStrLength) {
    numStr = '0' + numStr;
  }

  return numStr;
}

function getNumberForSegment(segment, segmentIndex) {
  return segment.representation.startNumber + segmentIndex;
}

function unescapeDollarsInTemplate(url) {
  return url ? url.split('$$').join('$') : url;
}
function replaceIDForTemplate(url, value) {
  if (!value || !url || url.indexOf('$RepresentationID$') === -1) {
    return url;
  }

  var v = value.toString();
  return url.split('$RepresentationID$').join(v);
}
function replaceTokenForTemplate(url, token, value) {
  var formatTag = '%0';
  var startPos, endPos, formatTagPos, specifier, width, paddedValue;
  var tokenLen = token.length;
  var formatTagLen = formatTag.length;

  if (!url) {
    return url;
  } // keep looping round until all instances of <token> have been
  // replaced. once that has happened, startPos below will be -1
  // and the completed url will be returned.


  while (true) {
    // check if there is a valid $<token>...$ identifier
    // if not, return the url as is.
    startPos = url.indexOf('$' + token);

    if (startPos < 0) {
      return url;
    } // the next '$' must be the end of the identifier
    // if there isn't one, return the url as is.


    endPos = url.indexOf('$', startPos + tokenLen);

    if (endPos < 0) {
      return url;
    } // now see if there is an additional format tag suffixed to
    // the identifier within the enclosing '$' characters


    formatTagPos = url.indexOf(formatTag, startPos + tokenLen);

    if (formatTagPos > startPos && formatTagPos < endPos) {
      specifier = url.charAt(endPos - 1);
      width = parseInt(url.substring(formatTagPos + formatTagLen, endPos - 1), 10); // support the minimum specifiers required by IEEE 1003.1
      // (d, i , o, u, x, and X) for completeness

      switch (specifier) {
        // treat all int types as uint,
        // hence deliberate fallthrough
        case 'd':
        case 'i':
        case 'u':
          paddedValue = zeroPadToLength(value.toString(), width);
          break;

        case 'x':
          paddedValue = zeroPadToLength(value.toString(16), width);
          break;

        case 'X':
          paddedValue = zeroPadToLength(value.toString(16), width).toUpperCase();
          break;

        case 'o':
          paddedValue = zeroPadToLength(value.toString(8), width);
          break;

        default:
          return url;
      }
    } else {
      paddedValue = value;
    }

    url = url.substring(0, startPos) + paddedValue + url.substring(endPos + 1);
  }
}

function getSegment(representation, duration, presentationStartTime, mediaStartTime, timelineConverter, presentationEndTime, isDynamic, index) {
  var seg = new _vo_Segment__WEBPACK_IMPORTED_MODULE_0__["default"]();
  seg.representation = representation;
  seg.duration = duration;
  seg.presentationStartTime = presentationStartTime;
  seg.mediaStartTime = mediaStartTime;
  seg.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationEndTime, representation, isDynamic);
  seg.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationEndTime + duration, representation, isDynamic);
  seg.wallStartTime = timelineConverter.calcWallTimeForSegment(seg, isDynamic);
  seg.replacementNumber = getNumberForSegment(seg, index);
  seg.index = index;
  return seg;
}

function isSegmentAvailable(timelineConverter, representation, segment, isDynamic) {
  var voPeriod = representation.adaptation.period; // Avoid requesting segments that overlap the period boundary

  if (isFinite(voPeriod.duration) && voPeriod.start + voPeriod.duration <= segment.presentationStartTime) {
    return false;
  }

  if (isDynamic) {
    if (representation.availabilityTimeOffset === 'INF') {
      return true;
    } // For dynamic manifests we check if the presentation start time + duration is included in the availability window
    // SAST = Period@start + seg@presentationStartTime + seg@duration
    // ASAST = SAST - ATO
    // SAET = SAST + TSBD + seg@duration
    // refTime serves as an anchor time to compare the availability time of the segments against.


    var refTime = timelineConverter.getClientReferenceTime();
    return segment.availabilityStartTime.getTime() <= refTime && (!isFinite(segment.availabilityEndTime) || segment.availabilityEndTime.getTime() >= refTime);
  }

  return true;
}

function getIndexBasedSegment(timelineConverter, isDynamic, representation, index) {
  var duration, presentationStartTime, presentationEndTime;
  duration = representation.segmentDuration;
  /*
   * From spec - If neither @duration attribute nor SegmentTimeline element is present, then the Representation
   * shall contain exactly one Media Segment. The MPD start time is 0 and the MPD duration is obtained
   * in the same way as for the last Media Segment in the Representation.
   */

  if (isNaN(duration)) {
    duration = representation.adaptation.period.duration;
  }

  presentationStartTime = parseFloat((representation.adaptation.period.start + index * duration).toFixed(5));
  presentationEndTime = parseFloat((presentationStartTime + duration).toFixed(5));
  var mediaTime = timelineConverter.calcMediaTimeFromPresentationTime(presentationStartTime, representation);
  var segment = getSegment(representation, duration, presentationStartTime, mediaTime, timelineConverter, presentationEndTime, isDynamic, index);

  if (!isSegmentAvailable(timelineConverter, representation, segment, isDynamic)) {
    return null;
  }

  return segment;
}
function getTimeBasedSegment(timelineConverter, isDynamic, representation, time, duration, fTimescale, url, range, index, tManifest) {
  var scaledTime = time / fTimescale;
  var scaledDuration = duration / fTimescale;
  var presentationStartTime, presentationEndTime, seg;
  presentationStartTime = timelineConverter.calcPresentationTimeFromMediaTime(scaledTime, representation);
  presentationEndTime = presentationStartTime + scaledDuration;
  seg = getSegment(representation, scaledDuration, presentationStartTime, scaledTime, timelineConverter, presentationEndTime, isDynamic, index);

  if (!isSegmentAvailable(timelineConverter, representation, seg, isDynamic)) {
    return null;
  }

  seg.replacementTime = tManifest ? tManifest : time;
  url = replaceTokenForTemplate(url, 'Number', seg.replacementNumber);
  url = replaceTokenForTemplate(url, 'Time', seg.replacementTime);
  seg.media = url;
  seg.mediaRange = range;
  return seg;
}

/***/ }),

/***/ "./src/dash/utils/TemplateSegmentsGetter.js":
/*!**************************************************!*\
  !*** ./src/dash/utils/TemplateSegmentsGetter.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function TemplateSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation) {
      return mediaFinishedInformation;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      mediaFinishedInformation.numberOfSegments = 1;
    } else {
      mediaFinishedInformation.numberOfSegments = Math.ceil(representation.adaptation.period.duration / duration);
    }

    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var template = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate; // This is the index without @startNumber

    index = Math.max(index, 0);
    var seg = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getIndexBasedSegment)(timelineConverter, isDynamic, representation, index);

    if (seg) {
      seg.replacementTime = Math.round((index - 1) * representation.segmentDuration * representation.timescale, 10);
      var url = template.media;
      url = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.replaceTokenForTemplate)(url, 'Number', seg.replacementNumber);
      url = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.replaceTokenForTemplate)(url, 'Time', seg.replacementTime);
      seg.media = url;
    }

    return seg;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      return null;
    } // Calculate the relative time for the requested time in this period


    var periodTime = timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation, requestedTime);
    var index = Math.floor(periodTime / duration);
    return getSegmentByIndex(representation, index);
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

TemplateSegmentsGetter.__dashjs_factory_name = 'TemplateSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(TemplateSegmentsGetter);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/utils/TimelineSegmentsGetter.js":
/*!**************************************************!*\
  !*** ./src/dash/utils/TimelineSegmentsGetter.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function TimelineSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var dashMetrics = config.dashMetrics;
  var instance;

  function checkConfig() {
    if (!timelineConverter) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    if (!representation) {
      return 0;
    }

    var base = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate || representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var timeline = base.SegmentTimeline;
    var time = 0;
    var scaledTime = 0;
    var availableSegments = 0;
    var fragments, frag, i, len, j, repeat, fTimescale;
    fTimescale = representation.timescale;
    fragments = timeline.S_asArray;
    len = fragments.length;

    for (i = 0; i < len; i++) {
      frag = fragments[i];
      repeat = 0;

      if (frag.hasOwnProperty('r')) {
        repeat = frag.r;
      } // For a repeated S element, t belongs only to the first segment


      if (frag.hasOwnProperty('t')) {
        time = frag.t;
        scaledTime = time / fTimescale;
      } // This is a special case: "A negative value of the @r attribute of the S element indicates that the duration indicated in @d attribute repeats until the start of the next S element, the end of the Period or until the
      // next MPD update."


      if (repeat < 0) {
        var nextFrag = fragments[i + 1];
        repeat = _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, scaledTime);
      }

      for (j = 0; j <= repeat; j++) {
        availableSegments++;
        time += frag.d;
        scaledTime = time / fTimescale;
      }
    } // We need to account for the index of the segments starting at 0. We subtract 1


    return {
      numberOfSegments: availableSegments,
      mediaTimeOfLastSignaledSegment: scaledTime
    };
  }

  function iterateSegments(representation, iterFunc) {
    var base = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate || representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var timeline = base.SegmentTimeline;
    var list = base.SegmentURL_asArray;
    var time = 0;
    var relativeIdx = -1;
    var fragments, frag, i, len, j, repeat, fTimescale;
    fTimescale = representation.timescale;
    fragments = timeline.S_asArray;
    var breakIterator = false;

    for (i = 0, len = fragments.length; i < len && !breakIterator; i++) {
      frag = fragments[i];
      repeat = 0;

      if (frag.hasOwnProperty('r')) {
        repeat = frag.r;
      } // For a repeated S element, t belongs only to the first segment


      if (frag.hasOwnProperty('t')) {
        time = frag.t;
      } // This is a special case: "A negative value of the @r attribute of the S element indicates that the duration indicated in @d attribute repeats until the start of the next S element, the end of the Period or until the
      // next MPD update."


      if (repeat < 0) {
        var nextFrag = fragments[i + 1];
        repeat = _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, time / fTimescale);
      }

      for (j = 0; j <= repeat && !breakIterator; j++) {
        relativeIdx++;
        breakIterator = iterFunc(time, base, list, frag, fTimescale, relativeIdx, i);

        if (breakIterator) {
          representation.segmentDuration = frag.d / fTimescale;
        }

        time += frag.d;
      }
    }
  }

  function _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, scaledTime) {
    var repeatEndTime;

    if (nextFrag && nextFrag.hasOwnProperty('t')) {
      repeatEndTime = nextFrag.t / fTimescale;
    } else {
      try {
        var availabilityEnd = 0;

        if (!isNaN(representation.adaptation.period.start) && !isNaN(representation.adaptation.period.duration) && isFinite(representation.adaptation.period.duration)) {
          // use end of the Period
          availabilityEnd = representation.adaptation.period.start + representation.adaptation.period.duration;
        } else {
          // use DVR window
          var dvrWindow = dashMetrics.getCurrentDVRInfo();
          availabilityEnd = !isNaN(dvrWindow.end) ? dvrWindow.end : 0;
        }

        repeatEndTime = timelineConverter.calcMediaTimeFromPresentationTime(availabilityEnd, representation);
        representation.segmentDuration = frag.d / fTimescale;
      } catch (e) {
        repeatEndTime = 0;
      }
    }

    return Math.max(Math.ceil((repeatEndTime - scaledTime) / (frag.d / fTimescale)) - 1, 0);
  }

  function getSegmentByIndex(representation, index, lastSegmentTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var segment = null;
    var found = false;
    iterateSegments(representation, function (time, base, list, frag, fTimescale, relativeIdx, i) {
      if (found || lastSegmentTime < 0) {
        var media = base.media;
        var mediaRange = frag.mediaRange;

        if (list) {
          media = list[i].media || '';
          mediaRange = list[i].mediaRange;
        }

        segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, time, frag.d, fTimescale, media, mediaRange, relativeIdx, frag.tManifest);
        return true;
      } else if (time >= lastSegmentTime * fTimescale - frag.d * 0.5) {
        // same logic, if deviation is
        // 50% of segment duration, segment is found if time is greater than or equal to (startTime of previous segment - half of the previous segment duration)
        found = true;
      }

      return false;
    });
    return segment;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    if (requestedTime === undefined) {
      requestedTime = null;
    }

    var segment = null;
    var requiredMediaTime = timelineConverter.calcMediaTimeFromPresentationTime(requestedTime, representation);
    iterateSegments(representation, function (time, base, list, frag, fTimescale, relativeIdx, i) {
      // In some cases when requiredMediaTime = actual end time of the last segment
      // it is possible that this time a bit exceeds the declared end time of the last segment.
      // in this case we still need to include the last segment in the segment list.
      var scaledMediaTime = precisionRound(requiredMediaTime * fTimescale);

      if (scaledMediaTime < time + frag.d && scaledMediaTime >= time) {
        var media = base.media;
        var mediaRange = frag.mediaRange;

        if (list) {
          media = list[i].media || '';
          mediaRange = list[i].mediaRange;
        }

        segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, time, frag.d, fTimescale, media, mediaRange, relativeIdx, frag.tManifest);
        return true;
      }

      return false;
    });
    return segment;
  }

  function precisionRound(number) {
    return parseFloat(number.toPrecision(15));
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

TimelineSegmentsGetter.__dashjs_factory_name = 'TimelineSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(TimelineSegmentsGetter);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/dash/vo/AdaptationSet.js":
/*!**************************************!*\
  !*** ./src/dash/vo/AdaptationSet.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var AdaptationSet = function AdaptationSet() {
  _classCallCheck(this, AdaptationSet);

  this.period = null;
  this.index = -1;
  this.type = null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AdaptationSet);

/***/ }),

/***/ "./src/dash/vo/BaseURL.js":
/*!********************************!*\
  !*** ./src/dash/vo/BaseURL.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var DEFAULT_DVB_PRIORITY = 1;
var DEFAULT_DVB_WEIGHT = 1;

var BaseURL = function BaseURL(url, serviceLocation, priority, weight) {
  _classCallCheck(this, BaseURL);

  this.url = url || '';
  this.serviceLocation = serviceLocation || url || ''; // DVB extensions

  this.dvb_priority = priority || DEFAULT_DVB_PRIORITY;
  this.dvb_weight = weight || DEFAULT_DVB_WEIGHT;
  this.availabilityTimeOffset = 0;
  this.availabilityTimeComplete = true;
  /* currently unused:
   * byteRange,
   */
};

BaseURL.DEFAULT_DVB_PRIORITY = DEFAULT_DVB_PRIORITY;
BaseURL.DEFAULT_DVB_WEIGHT = DEFAULT_DVB_WEIGHT;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseURL);

/***/ }),

/***/ "./src/dash/vo/ContentSteering.js":
/*!****************************************!*\
  !*** ./src/dash/vo/ContentSteering.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ContentSteering = function ContentSteering() {
  _classCallCheck(this, ContentSteering);

  this.defaultServiceLocation = null;
  this.queryBeforeStart = false;
  this.proxyServerUrl = null;
  this.serverUrl = null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentSteering);

/***/ }),

/***/ "./src/dash/vo/Event.js":
/*!******************************!*\
  !*** ./src/dash/vo/Event.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Event = function Event() {
  _classCallCheck(this, Event);

  this.duration = NaN;
  this.presentationTime = NaN;
  this.id = NaN;
  this.messageData = '';
  this.eventStream = null;
  this.presentationTimeDelta = NaN; // Specific EMSG Box parameter
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Event);

/***/ }),

/***/ "./src/dash/vo/EventStream.js":
/*!************************************!*\
  !*** ./src/dash/vo/EventStream.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var EventStream = function EventStream() {
  _classCallCheck(this, EventStream);

  this.adaptionSet = null;
  this.representation = null;
  this.period = null;
  this.timescale = 1;
  this.value = '';
  this.schemeIdUri = '';
  this.presentationTimeOffset = 0;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EventStream);

/***/ }),

/***/ "./src/dash/vo/Mpd.js":
/*!****************************!*\
  !*** ./src/dash/vo/Mpd.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Mpd = function Mpd() {
  _classCallCheck(this, Mpd);

  this.manifest = null;
  this.suggestedPresentationDelay = 0;
  this.availabilityStartTime = null;
  this.availabilityEndTime = Number.POSITIVE_INFINITY;
  this.timeShiftBufferDepth = Number.POSITIVE_INFINITY;
  this.maxSegmentDuration = Number.POSITIVE_INFINITY;
  this.publishTime = null;
  this.minimumUpdatePeriod = NaN;
  this.mediaPresentationDuration = NaN;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Mpd);

/***/ }),

/***/ "./src/dash/vo/Period.js":
/*!*******************************!*\
  !*** ./src/dash/vo/Period.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Period = function Period() {
  _classCallCheck(this, Period);

  this.id = null;
  this.index = -1;
  this.duration = NaN;
  this.start = NaN;
  this.mpd = null;
  this.nextPeriodId = null;
};

Period.DEFAULT_ID = 'defaultId';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Period);

/***/ }),

/***/ "./src/dash/vo/ProducerReferenceTime.js":
/*!**********************************************!*\
  !*** ./src/dash/vo/ProducerReferenceTime.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ProducerReferenceTime = function ProducerReferenceTime() {
  _classCallCheck(this, ProducerReferenceTime);

  this.id = null;
  this.inband = false;
  this.type = 'encoder';
  this.applicationScheme = null;
  this.wallClockTime = null;
  this.presentationTime = NaN;
  this.UTCTiming = null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProducerReferenceTime);

/***/ }),

/***/ "./src/dash/vo/Representation.js":
/*!***************************************!*\
  !*** ./src/dash/vo/Representation.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var Representation = /*#__PURE__*/function () {
  function Representation() {
    _classCallCheck(this, Representation);

    this.id = null;
    this.index = -1;
    this.adaptation = null;
    this.segmentInfoType = null;
    this.initialization = null;
    this.codecs = null;
    this.mimeType = null;
    this.codecPrivateData = null;
    this.segmentDuration = NaN;
    this.timescale = 1;
    this.startNumber = 1;
    this.indexRange = null;
    this.range = null;
    this.presentationTimeOffset = 0; // Set the source buffer timeOffset to this

    this.MSETimeOffset = NaN; // The information we need in the DashHandler to determine whether the last segment has been loaded

    this.mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
    this.bandwidth = NaN;
    this.width = NaN;
    this.height = NaN;
    this.scanType = null;
    this.maxPlayoutRate = NaN;
    this.availabilityTimeOffset = 0;
    this.availabilityTimeComplete = true;
  }

  _createClass(Representation, [{
    key: "hasInitialization",
    value: function hasInitialization() {
      return this.initialization !== null || this.range !== null;
    }
  }, {
    key: "hasSegments",
    value: function hasSegments() {
      return this.segmentInfoType !== _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].BASE_URL && this.segmentInfoType !== _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].SEGMENT_BASE && !this.indexRange;
    }
  }]);

  return Representation;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Representation);

/***/ }),

/***/ "./src/dash/vo/Segment.js":
/*!********************************!*\
  !*** ./src/dash/vo/Segment.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Segment = function Segment() {
  _classCallCheck(this, Segment);

  this.indexRange = null; // The index of the segment in the list of segments. We start at 0

  this.index = null;
  this.mediaRange = null;
  this.media = null;
  this.duration = NaN; // this is the time that should be inserted into the media url

  this.replacementTime = null; // this is the number that should be inserted into the media url

  this.replacementNumber = NaN; // This is supposed to match the time encoded in the media Segment

  this.mediaStartTime = NaN; // When the source buffer timeOffset is set to MSETimeOffset this is the
  // time that will match the seekTarget and video.currentTime

  this.presentationStartTime = NaN; // Do not schedule this segment until

  this.availabilityStartTime = NaN; // Ignore and  discard this segment after

  this.availabilityEndTime = NaN; // For dynamic mpd's, this is the wall clock time that the video
  // element currentTime should be presentationStartTime

  this.wallStartTime = NaN;
  this.representation = null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Segment);

/***/ }),

/***/ "./src/dash/vo/UTCTiming.js":
/*!**********************************!*\
  !*** ./src/dash/vo/UTCTiming.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var UTCTiming = function UTCTiming() {
  _classCallCheck(this, UTCTiming);

  // UTCTiming is a DescriptorType and doesn't have any additional fields
  this.schemeIdUri = '';
  this.value = '';
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UTCTiming);

/***/ }),

/***/ "./src/offline/OfflineDownload.js":
/*!****************************************!*\
  !*** ./src/offline/OfflineDownload.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/OfflineConstants */ "./src/offline/constants/OfflineConstants.js");
/* harmony import */ var _OfflineStream__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./OfflineStream */ "./src/offline/OfflineStream.js");
/* harmony import */ var _utils_OfflineIndexDBManifestParser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/OfflineIndexDBManifestParser */ "./src/offline/utils/OfflineIndexDBManifestParser.js");
/* harmony import */ var _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./errors/OfflineErrors */ "./src/offline/errors/OfflineErrors.js");
/* harmony import */ var _dash_parser_DashParser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dash/parser/DashParser */ "./src/dash/parser/DashParser.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function OfflineDownload(config) {
  config = config || {};
  var context = this.context;
  var manifestLoader = config.manifestLoader;
  var mediaPlayerModel = config.mediaPlayerModel;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var adapter = config.adapter;
  var dashMetrics = config.dashMetrics;
  var timelineConverter = config.timelineConverter;
  var offlineStoreController = config.offlineStoreController;
  var manifestId = config.id;
  var eventBus = config.eventBus;
  var errHandler = config.errHandler;
  var events = config.events;
  var errors = config.errors;
  var settings = config.settings;
  var debug = config.debug;
  var manifestUpdater = config.manifestUpdater;
  var baseURLController = config.baseURLController;
  var segmentBaseController = config.segmentBaseController;
  var constants = config.constants;
  var dashConstants = config.dashConstants;
  var urlUtils = config.urlUtils;

  var instance, logger, _manifestURL, _offlineURL, _xmlManifest, _streams, _manifest, _isDownloadingStatus, _isComposed, _representationsToUpdate, _indexDBManifestParser, _progressionById, _progression, _status;

  function setup() {
    logger = debug.getLogger(instance);
    manifestUpdater.initialize();
    _streams = [];
    _isDownloadingStatus = false;
    _isComposed = false;
    _progressionById = {};
    _progression = 0;
    _status = undefined;
  }

  function getId() {
    return manifestId;
  }

  function getOfflineUrl() {
    return _offlineURL;
  }

  function getManifestUrl() {
    return _manifestURL;
  }

  function getStatus() {
    return _status;
  }

  function setInitialState(state) {
    _offlineURL = state.url;
    _progression = state.progress;
    _manifestURL = state.originalUrl;
    _status = state.status;
  }
  /**
   * Download a stream, from url of manifest
   * @param {string} url
   * @instance
   */


  function downloadFromUrl(url) {
    _manifestURL = url;
    _offlineURL = "".concat(_constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_SCHEME, "://").concat(manifestId);
    _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_CREATED;
    setupOfflineEvents();
    var offlineManifest = {
      'fragmentStore': manifestId,
      'status': _status,
      'manifestId': manifestId,
      'url': _offlineURL,
      'originalURL': url
    };
    return createOfflineManifest(offlineManifest);
  }

  function initDownload() {
    manifestLoader.load(_manifestURL);
    _isDownloadingStatus = true;
  }

  function setupOfflineEvents() {
    eventBus.on(events.MANIFEST_UPDATED, onManifestUpdated, instance);
    eventBus.on(events.ORIGINAL_MANIFEST_LOADED, onOriginalManifestLoaded, instance);
    setupIndexedDBEvents();
  }

  function setupIndexedDBEvents() {
    eventBus.on(events.ERROR, onError, instance);
  }

  function isDownloading() {
    return _isDownloadingStatus;
  }

  function onManifestUpdated(e) {
    if (_isComposed) {
      return;
    }

    if (!e.error) {
      try {
        _manifest = e.manifest;
      } catch (err) {
        _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
        errHandler.error({
          code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
          message: err.message,
          data: {
            id: manifestId,
            status: _status
          }
        });
      }
    }
  }

  function onDownloadingStarted(e) {
    if (e.id !== manifestId) {
      return;
    }

    if (!e.error && manifestId !== null) {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_STARTED;
      offlineStoreController.setDownloadingStatus(manifestId, _status).then(function () {
        eventBus.trigger(events.OFFLINE_RECORD_STARTED, {
          id: manifestId,
          message: 'Downloading started for this stream !'
        });
      });
    } else {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: 'Cannot start download ',
        data: {
          id: manifestId,
          status: _status,
          error: e.error
        }
      });
    }
  }

  function OnStreamProgression(stream, downloaded, available) {
    _progressionById[stream.getStreamInfo().id] = {
      downloaded: downloaded,
      available: available
    };
    var segments = 0;
    var allSegments = 0;
    var waitForAllProgress;

    for (var property in _progressionById) {
      if (_progressionById.hasOwnProperty(property)) {
        if (_progressionById[property] === null) {
          waitForAllProgress = true;
        } else {
          segments += _progressionById[property].downloaded;
          allSegments += _progressionById[property].available;
        }
      }
    }

    if (!waitForAllProgress) {
      // all progression have been started, we can compute global progression
      _progression = segments / allSegments; // store progression

      offlineStoreController.getManifestById(manifestId).then(function (item) {
        item.progress = _progression;
        return updateOfflineManifest(item);
      });
    }
  }

  function onDownloadingFinished(e) {
    if (e.id !== manifestId) {
      return;
    }

    if (!e.error && manifestId !== null) {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_FINISHED;
      offlineStoreController.setDownloadingStatus(manifestId, _status).then(function () {
        eventBus.trigger(events.OFFLINE_RECORD_FINISHED, {
          id: manifestId,
          message: 'Downloading has been successfully completed for this stream !'
        });
        resetDownload();
      });
    } else {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: 'Error finishing download ',
        data: {
          id: manifestId,
          status: _status,
          error: e.error
        }
      });
    }
  }

  function onManifestUpdateNeeded(e) {
    if (e.id !== manifestId) {
      return;
    }

    _representationsToUpdate = e.representations;

    if (_representationsToUpdate.length > 0) {
      _indexDBManifestParser.parse(_xmlManifest, _representationsToUpdate).then(function (parsedManifest) {
        if (parsedManifest !== null && manifestId !== null) {
          offlineStoreController.getManifestById(manifestId).then(function (item) {
            item.manifest = parsedManifest;
            return updateOfflineManifest(item);
          }).then(function () {
            for (var i = 0, ln = _streams.length; i < ln; i++) {
              _streams[i].startOfflineStreamProcessors();
            }
          });
        } else {
          throw 'falling parsing offline manifest';
        }
      })["catch"](function (err) {
        throw err;
      });
    }
  }

  function composeStreams() {
    try {
      adapter.updatePeriods(_manifest);
      baseURLController.initialize(_manifest);
      var streamsInfo = adapter.getStreamsInfo();

      if (streamsInfo.length === 0) {
        _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
        errHandler.error({
          code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
          message: 'Cannot download - no streams',
          data: {
            id: manifestId,
            status: _status
          }
        });
      }

      for (var i = 0, ln = streamsInfo.length; i < ln; i++) {
        var streamInfo = streamsInfo[i];
        var stream = (0,_OfflineStream__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
          id: manifestId,
          callbacks: {
            started: onDownloadingStarted,
            progression: OnStreamProgression,
            finished: onDownloadingFinished,
            updateManifestNeeded: onManifestUpdateNeeded
          },
          constants: constants,
          dashConstants: dashConstants,
          eventBus: eventBus,
          events: events,
          errors: errors,
          settings: settings,
          debug: debug,
          errHandler: errHandler,
          mediaPlayerModel: mediaPlayerModel,
          abrController: abrController,
          playbackController: playbackController,
          dashMetrics: dashMetrics,
          baseURLController: baseURLController,
          timelineConverter: timelineConverter,
          adapter: adapter,
          segmentBaseController: segmentBaseController,
          offlineStoreController: offlineStoreController
        });

        _streams.push(stream); // initialise stream and get downloadable representations


        stream.initialize(streamInfo);
        _progressionById[streamInfo.id] = null;
      }

      _isComposed = true;
    } catch (e) {
      logger.info(e);
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: e.message,
        data: {
          id: manifestId,
          status: _status,
          error: e.error
        }
      });
    }
  }

  function getMediaInfos() {
    _streams.forEach(function (stream) {
      stream.getMediaInfos();
    });
  }
  /**
   * Init databsse to store fragments
   * @param {number} manifestId
   * @instance
   */


  function createFragmentStore(manifestId) {
    return offlineStoreController.createFragmentStore(manifestId);
  }
  /**
   * Store in database the string representation of offline manifest (with only downloaded representations)
   * @param {object} offlineManifest
   * @instance
   */


  function createOfflineManifest(offlineManifest) {
    return offlineStoreController.createOfflineManifest(offlineManifest);
  }
  /**
   * Store in database the string representation of offline manifest (with only downloaded representations)
   * @param {object} offlineManifest
   * @instance
   */


  function updateOfflineManifest(offlineManifest) {
    return offlineStoreController.updateOfflineManifest(offlineManifest);
  }
  /**
   * Triggered when manifest is loaded from internet.
   * @param {Object[]} e
   */


  function onOriginalManifestLoaded(e) {
    // unregister form event
    eventBus.off(events.ORIGINAL_MANIFEST_LOADED, onOriginalManifestLoaded, instance);
    _xmlManifest = e.originalManifest;

    if (_manifest.type === dashConstants.DYNAMIC) {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: 'Cannot handle DYNAMIC manifest',
        data: {
          id: manifestId,
          status: _status
        }
      });
      logger.error('Cannot handle DYNAMIC manifest');
      return;
    }

    if (_manifest.Period_asArray.length > 1) {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: 'MultiPeriod manifest are not yet supported',
        data: {
          id: manifestId,
          status: _status
        }
      });
      logger.error('MultiPeriod manifest are not yet supported');
      return;
    } // save original manifest (for resume)
    // initialise offline streams


    composeStreams(_manifest); // get MediaInfos

    getMediaInfos();
    eventBus.trigger(events.STREAMS_COMPOSED);
  }

  function initializeAllMediasInfoList(selectedRepresentations) {
    for (var i = 0; i < _streams.length; i++) {
      _streams[i].initializeAllMediasInfoList(selectedRepresentations);
    }
  }

  function getSelectedRepresentations(mediaInfos) {
    var rep = {};
    rep[constants.VIDEO] = [];
    rep[constants.AUDIO] = [];
    rep[constants.TEXT] = []; // selectedRepresentations.video.forEach(item => {
    //     ret[constants.VIDEO].push(item.id);
    // });
    // selectedRepresentations.audio.forEach(item => {
    //     ret[constants.AUDIO].push(item.id);
    // });
    // selectedRepresentations.text.forEach(item => {
    //     ret[item.type].push(item.id);
    // });

    mediaInfos.forEach(function (mediaInfo) {
      mediaInfo.bitrateList.forEach(function (bitrate) {
        rep[mediaInfo.type].push(bitrate.id);
      });
    });
    return rep;
  }

  function startDownload(mediaInfos) {
    try {
      var rep = getSelectedRepresentations(mediaInfos);
      offlineStoreController.saveSelectedRepresentations(manifestId, rep).then(function () {
        return createFragmentStore(manifestId);
      }).then(function () {
        return generateOfflineManifest(rep);
      }).then(function () {
        initializeAllMediasInfoList(rep);
      });
    } catch (err) {
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_ERROR;
      errHandler.error({
        code: _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].OFFLINE_ERROR,
        message: err.message,
        data: {
          id: manifestId,
          status: _status
        }
      });
    }
  }
  /**
   * Create the parser used to convert original manifest in offline manifest
   * Creates a JSON object that will be stored in database
   * @param {Object[]} selectedRepresentations
   * @instance
   */


  function generateOfflineManifest(selectedRepresentations) {
    _indexDBManifestParser = (0,_utils_OfflineIndexDBManifestParser__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      manifestId: manifestId,
      allMediaInfos: selectedRepresentations,
      debug: debug,
      dashConstants: dashConstants,
      constants: constants,
      urlUtils: urlUtils
    });
    return _indexDBManifestParser.parse(_xmlManifest).then(function (parsedManifest) {
      if (parsedManifest !== null) {
        return offlineStoreController.getManifestById(manifestId).then(function (item) {
          item.originalURL = _manifest.url;
          item.originalManifest = _xmlManifest;
          item.manifest = parsedManifest;
          return updateOfflineManifest(item);
        });
      } else {
        return Promise.reject('falling parsing offline manifest');
      }
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Stops downloading of fragments
   * @instance
   */


  function stopDownload() {
    if (manifestId !== null && isDownloading()) {
      for (var i = 0, ln = _streams.length; i < ln; i++) {
        _streams[i].stopOfflineStreamProcessors();
      } // remove streams


      _streams = [];
      _isComposed = false;
      _status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_STOPPED; // update status

      offlineStoreController.setDownloadingStatus(manifestId, _status).then(function () {
        eventBus.trigger(events.OFFLINE_RECORD_STOPPED, {
          sender: this,
          id: manifestId,
          status: _status,
          message: 'Downloading has been stopped for this stream !'
        });
        _isDownloadingStatus = false;
      });
    }
  }
  /**
   * Delete an offline manifest (and all of its data)
   * @instance
   */


  function deleteDownload() {
    stopDownload();
  }
  /**
   * Resume download of a stream
   * @instance
   */


  function resumeDownload() {
    if (isDownloading()) {
      return;
    }

    _isDownloadingStatus = true;
    var selectedRepresentations;
    offlineStoreController.getManifestById(manifestId).then(function (item) {
      var parser = (0,_dash_parser_DashParser__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create({
        debug: debug
      });
      _manifest = parser.parse(item.originalManifest);
      composeStreams(_manifest);
      selectedRepresentations = item.selected;
      eventBus.trigger(events.STREAMS_COMPOSED);
      return createFragmentStore(manifestId);
    }).then(function () {
      initializeAllMediasInfoList(selectedRepresentations);
    });
  }
  /**
   * Compute the progression of download
   * @instance
   */


  function getDownloadProgression() {
    return Math.round(_progression * 100);
  }
  /**
   * Reset events listeners
   * @instance
   */


  function resetDownload() {
    for (var i = 0, ln = _streams.length; i < ln; i++) {
      _streams[i].reset();
    }

    _indexDBManifestParser = null;
    _isDownloadingStatus = false;
    _streams = [];
    eventBus.off(events.MANIFEST_UPDATED, onManifestUpdated, instance);
    eventBus.off(events.ORIGINAL_MANIFEST_LOADED, onOriginalManifestLoaded, instance);
    resetIndexedDBEvents();
  }

  function onError(e) {
    if (e.error.code === _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].INDEXEDDB_QUOTA_EXCEED_ERROR || e.error.code === _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_3__["default"].INDEXEDDB_INVALID_STATE_ERROR) {
      stopDownload();
    }
  }

  function resetIndexedDBEvents() {
    eventBus.on(events.ERROR, onError, instance);
  }
  /**
   * Reset
   * @instance
   */


  function reset() {
    if (isDownloading()) {
      resetDownload();
    }

    baseURLController.reset();
    manifestUpdater.reset();
  }

  instance = {
    reset: reset,
    getId: getId,
    getOfflineUrl: getOfflineUrl,
    getManifestUrl: getManifestUrl,
    getStatus: getStatus,
    setInitialState: setInitialState,
    initDownload: initDownload,
    downloadFromUrl: downloadFromUrl,
    startDownload: startDownload,
    stopDownload: stopDownload,
    resumeDownload: resumeDownload,
    deleteDownload: deleteDownload,
    getDownloadProgression: getDownloadProgression,
    isDownloading: isDownloading,
    resetDownload: resetDownload
  };
  setup();
  return instance;
}

OfflineDownload.__dashjs_factory_name = 'OfflineDownload';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getClassFactory(OfflineDownload));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/OfflineStream.js":
/*!**************************************!*\
  !*** ./src/offline/OfflineStream.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _OfflineStreamProcessor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OfflineStreamProcessor */ "./src/offline/OfflineStreamProcessor.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Initialize and Manage Offline Stream for each type
 */

/**
 * @class OfflineStream
 * @description Initialize and Manage Offline Stream for each type
 * @param {Object} config - dependences
 * @ignore
 */

function OfflineStream(config) {
  config = config || {};
  var context = this.context;
  var eventBus = config.eventBus;
  var events = config.events;
  var errors = config.errors;
  var constants = config.constants;
  var dashConstants = config.dashConstants;
  var settings = config.settings;
  var debug = config.debug;
  var errHandler = config.errHandler;
  var mediaPlayerModel = config.mediaPlayerModel;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var adapter = config.adapter;
  var dashMetrics = config.dashMetrics;
  var baseURLController = config.baseURLController;
  var timelineConverter = config.timelineConverter;
  var segmentBaseController = config.segmentBaseController;
  var offlineStoreController = config.offlineStoreController;
  var manifestId = config.id;
  var startedCb = config.callbacks && config.callbacks.started;
  var progressionCb = config.callbacks && config.callbacks.progression;
  var finishedCb = config.callbacks && config.callbacks.finished;
  var updateManifest = config.callbacks && config.callbacks.updateManifestNeeded;
  var instance, offlineStreamProcessors, startedOfflineStreamProcessors, finishedOfflineStreamProcessors, streamInfo, representationsToUpdate, allMediasInfosList, progressionById;

  function setup() {
    resetInitialSettings();
  }
  /**
   * Reset
   */


  function resetInitialSettings() {
    streamInfo = null;
    offlineStreamProcessors = [];
    startedOfflineStreamProcessors = 0;
    finishedOfflineStreamProcessors = 0;
    allMediasInfosList = [];
    representationsToUpdate = [];
    progressionById = {};
  }
  /**
   * Initialize offlinestream
   * @param {Object} initStreamInfo
   */


  function initialize(initStreamInfo) {
    streamInfo = initStreamInfo;
    eventBus.on(events.DATA_UPDATE_COMPLETED, onDataUpdateCompleted, instance);
  }

  function getStreamId() {
    return streamInfo.id;
  }
  /**
   * Creates media infos list, so that user will be able to choose the representation he wants to download
   */


  function getMediaInfos() {
    var mediaInfos = adapter.getAllMediaInfoForType(streamInfo, constants.VIDEO);
    mediaInfos = mediaInfos.concat(adapter.getAllMediaInfoForType(streamInfo, constants.AUDIO));
    mediaInfos = mediaInfos.concat(adapter.getAllMediaInfoForType(streamInfo, constants.TEXT)); // mediaInfos = mediaInfos.concat(adapter.getAllMediaInfoForType(streamInfo, constants.MUXED));
    // mediaInfos = mediaInfos.concat(adapter.getAllMediaInfoForType(streamInfo, constants.IMAGE));

    eventBus.trigger(events.OFFLINE_RECORD_LOADEDMETADATA, {
      id: manifestId,
      mediaInfos: mediaInfos
    });
  }
  /**
   * Initialize with choosen representations by user
   * @param {Object} mediasInfoList
   */


  function initializeAllMediasInfoList(mediasInfoList) {
    allMediasInfosList = mediasInfoList;
    initializeMedia(streamInfo);
  }
  /**
   * Initialize media for each type
   * @param {Object} streamInfo
   */


  function initializeMedia(streamInfo) {
    createOfflineStreamProcessorFor(constants.VIDEO, streamInfo);
    createOfflineStreamProcessorFor(constants.AUDIO, streamInfo);
    createOfflineStreamProcessorFor(constants.TEXT, streamInfo);
    createOfflineStreamProcessorFor(constants.MUXED, streamInfo);
    createOfflineStreamProcessorFor(constants.IMAGE, streamInfo);
  }

  function createOfflineStreamProcessorFor(type, streamInfo) {
    // filter mediaInfo according to choosen representation id
    var allMediaInfoForType = adapter.getAllMediaInfoForType(streamInfo, type);
    allMediaInfoForType.forEach(function (media) {
      media.bitrateList = media.bitrateList.filter(function (bitrate) {
        if (allMediasInfosList[type] && allMediasInfosList[type].indexOf(bitrate.id) !== -1) {
          return true;
        }

        return false;
      });
    });
    allMediaInfoForType = allMediaInfoForType.filter(function (media) {
      return media.bitrateList && media.bitrateList.length > 0;
    }); // cration of an offline stream processor for each choosen representation

    allMediaInfoForType.forEach(function (mediaInfo) {
      if (mediaInfo.bitrateList) {
        mediaInfo.bitrateList.forEach(function (bitrate) {
          createStreamProcessor(mediaInfo, bitrate);
        });
      }
    });
    return allMediaInfoForType;
  }

  function createStreamProcessor(mediaInfo, bitrate) {
    var streamProcessor = (0,_OfflineStreamProcessor__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
      id: manifestId,
      streamInfo: streamInfo,
      debug: debug,
      events: events,
      errors: errors,
      eventBus: eventBus,
      constants: constants,
      dashConstants: dashConstants,
      settings: settings,
      type: mediaInfo.type,
      mimeType: mediaInfo.mimeType,
      bitrate: bitrate,
      errHandler: errHandler,
      mediaPlayerModel: mediaPlayerModel,
      abrController: abrController,
      playbackController: playbackController,
      adapter: adapter,
      dashMetrics: dashMetrics,
      baseURLController: baseURLController,
      timelineConverter: timelineConverter,
      offlineStoreController: offlineStoreController,
      segmentBaseController: segmentBaseController,
      callbacks: {
        completed: onStreamCompleted,
        progression: onStreamProgression
      }
    });
    offlineStreamProcessors.push(streamProcessor);
    streamProcessor.initialize(mediaInfo);
    progressionById[bitrate.id] = null;
  }

  function onStreamCompleted() {
    finishedOfflineStreamProcessors++;

    if (finishedOfflineStreamProcessors === offlineStreamProcessors.length) {
      finishedCb({
        sender: this,
        id: manifestId,
        message: 'Downloading has been successfully completed for this stream !'
      });
    }
  }

  function onStreamProgression(streamProcessor, downloadedSegments, availableSegments) {
    progressionById[streamProcessor.getRepresentationId()] = {
      downloadedSegments: downloadedSegments,
      availableSegments: availableSegments
    };
    var segments = 0;
    var allSegments = 0;
    var waitForAllProgress;

    for (var property in progressionById) {
      if (progressionById.hasOwnProperty(property)) {
        if (progressionById[property] === null) {
          waitForAllProgress = true;
        } else {
          segments += progressionById[property].downloadedSegments;
          allSegments += progressionById[property].availableSegments;
        }
      }
    }

    if (!waitForAllProgress && progressionCb) {
      // all progression have been started, we can compute global progression
      if (allSegments > 0) {
        progressionCb(instance, segments, allSegments);
      }
    }
  }

  function onDataUpdateCompleted(e) {
    if (e.currentRepresentation.segments && e.currentRepresentation.segments.length > 0) {
      representationsToUpdate.push(e.currentRepresentation);
    }

    var sp; // data are ready fr stream processor, let's start download

    for (var i = 0; i < offlineStreamProcessors.length; i++) {
      if (offlineStreamProcessors[i].getRepresentationController().getType() === e.mediaType) {
        sp = offlineStreamProcessors[i];
        break;
      }
    }

    if (sp) {
      checkIfAllOfflineStreamProcessorsStarted();
    }
  }

  function checkIfAllOfflineStreamProcessorsStarted() {
    startedOfflineStreamProcessors++;

    if (startedOfflineStreamProcessors === offlineStreamProcessors.length) {
      startedCb({
        sender: this,
        id: manifestId,
        message: 'Downloading started for this stream !'
      });

      if (representationsToUpdate.length > 0) {
        updateManifest({
          sender: this,
          id: manifestId,
          representations: representationsToUpdate
        });
      } else {
        startOfflineStreamProcessors();
      }
    }
  }

  function getStreamInfo() {
    return streamInfo;
  }

  function getStartTime() {
    return streamInfo ? streamInfo.start : NaN;
  }

  function getDuration() {
    return streamInfo ? streamInfo.duration : NaN;
  }
  /**
   * Stop offline stream processors
   */


  function stopOfflineStreamProcessors() {
    for (var i = 0; i < offlineStreamProcessors.length; i++) {
      offlineStreamProcessors[i].stop();
    }
  }
  /**
   * Start offline stream processors
   */


  function startOfflineStreamProcessors() {
    for (var i = 0; i < offlineStreamProcessors.length; i++) {
      offlineStreamProcessors[i].start();
    }
  }

  function deactivate() {
    var ln = offlineStreamProcessors ? offlineStreamProcessors.length : 0;

    for (var i = 0; i < ln; i++) {
      offlineStreamProcessors[i].removeExecutedRequestsBeforeTime(getStartTime() + getDuration());
      offlineStreamProcessors[i].reset();
    }
  }
  /**
   * Reset
   */


  function reset() {
    stopOfflineStreamProcessors();
    deactivate();
    resetInitialSettings();
    eventBus.off(events.DATA_UPDATE_COMPLETED, onDataUpdateCompleted, instance);
  }

  instance = {
    initialize: initialize,
    getStreamId: getStreamId,
    getMediaInfos: getMediaInfos,
    initializeAllMediasInfoList: initializeAllMediasInfoList,
    getStreamInfo: getStreamInfo,
    stopOfflineStreamProcessors: stopOfflineStreamProcessors,
    startOfflineStreamProcessors: startOfflineStreamProcessors,
    reset: reset
  };
  setup();
  return instance;
}

OfflineStream.__dashjs_factory_name = 'OfflineStream';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getClassFactory(OfflineStream));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/OfflineStreamProcessor.js":
/*!***********************************************!*\
  !*** ./src/offline/OfflineStreamProcessor.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dash_DashHandler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dash/DashHandler */ "./src/dash/DashHandler.js");
/* harmony import */ var _dash_controllers_RepresentationController__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dash/controllers/RepresentationController */ "./src/dash/controllers/RepresentationController.js");
/* harmony import */ var _streaming_models_FragmentModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../streaming/models/FragmentModel */ "./src/streaming/models/FragmentModel.js");
/* harmony import */ var _streaming_FragmentLoader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/FragmentLoader */ "./src/streaming/FragmentLoader.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _streaming_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../streaming/utils/RequestModifier */ "./src/streaming/utils/RequestModifier.js");
/* harmony import */ var _dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dash/controllers/SegmentsController */ "./src/dash/controllers/SegmentsController.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */








function OfflineStreamProcessor(config) {
  config = config || {};
  var context = this.context;
  var eventBus = config.eventBus;
  var events = config.events;
  var errors = config.errors;
  var debug = config.debug;
  var constants = config.constants;
  var settings = config.settings;
  var dashConstants = config.dashConstants;
  var manifestId = config.id;
  var type = config.type;
  var streamInfo = config.streamInfo;
  var errHandler = config.errHandler;
  var mediaPlayerModel = config.mediaPlayerModel;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var adapter = config.adapter;
  var dashMetrics = config.dashMetrics;
  var baseURLController = config.baseURLController;
  var timelineConverter = config.timelineConverter;
  var bitrate = config.bitrate;
  var offlineStoreController = config.offlineStoreController;
  var completedCb = config.callbacks && config.callbacks.completed;
  var progressCb = config.callbacks && config.callbacks.progression;
  var instance, logger, mediaInfo, indexHandler, representationController, fragmentModel, updating, downloadedSegments, isInitialized, segmentsController, isStopped;

  function setup() {
    resetInitialSettings();
    logger = debug.getLogger(instance);
    segmentsController = (0,_dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_6__["default"])(context).create({
      events: events,
      eventBus: eventBus,
      streamInfo: streamInfo,
      timelineConverter: timelineConverter,
      dashConstants: dashConstants,
      segmentBaseController: config.segmentBaseController,
      type: type
    });
    indexHandler = (0,_dash_DashHandler__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      timelineConverter: timelineConverter,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      baseURLController: baseURLController,
      errHandler: errHandler,
      settings: settings,
      // boxParser: boxParser,
      eventBus: eventBus,
      events: events,
      debug: debug,
      requestModifier: (0,_streaming_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance(),
      dashConstants: dashConstants,
      constants: constants,
      segmentsController: segmentsController,
      urlUtils: (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance()
    });
    representationController = (0,_dash_controllers_RepresentationController__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      abrController: abrController,
      dashMetrics: dashMetrics,
      playbackController: playbackController,
      timelineConverter: timelineConverter,
      dashConstants: dashConstants,
      events: events,
      eventBus: eventBus,
      errors: errors,
      segmentsController: segmentsController
    });
    fragmentModel = (0,_streaming_models_FragmentModel__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      streamInfo: streamInfo,
      dashMetrics: dashMetrics,
      fragmentLoader: (0,_streaming_FragmentLoader__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create({
        dashMetrics: dashMetrics,
        mediaPlayerModel: mediaPlayerModel,
        errHandler: errHandler,
        requestModifier: (0,_streaming_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance(),
        settings: settings,
        eventBus: eventBus,
        events: events,
        errors: errors,
        constants: constants,
        dashConstants: dashConstants,
        urlUtils: (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance()
      }),
      debug: debug,
      eventBus: eventBus,
      events: events
    });
    eventBus.on(events.STREAM_REQUESTING_COMPLETED, onStreamRequestingCompleted, instance);
    eventBus.on(events.FRAGMENT_LOADING_COMPLETED, onFragmentLoadingCompleted, instance);
  }

  function initialize(_mediaInfo) {
    mediaInfo = _mediaInfo;
    indexHandler.initialize(false);
    updateRepresentation(mediaInfo);
  }

  function isInitRequest(request) {
    return request.type === 'InitializationSegment';
  }

  function onFragmentLoadingCompleted(e) {
    if (e.sender !== fragmentModel) {
      return;
    }

    if (e.request !== null) {
      var isInit = isInitRequest(e.request);
      var suffix = isInit ? 'init' : e.request.index;
      var fragmentName = e.request.representationId + '_' + suffix;
      offlineStoreController.storeFragment(manifestId, fragmentName, e.response).then(function () {
        if (!isInit) {
          // store current index and downloadedSegments number
          offlineStoreController.setRepresentationCurrentState(manifestId, e.request.representationId, {
            index: e.request.index,
            downloaded: downloadedSegments
          });
        }
      });
    }

    if (e.error && e.request.serviceLocation && !isStopped) {
      fragmentModel.executeRequest(e.request);
    } else {
      downloadedSegments++;
      download();
    }
  }

  function onStreamRequestingCompleted(e) {
    if (e.fragmentModel !== fragmentModel) {
      return;
    }

    logger.info("[".concat(manifestId, "] Stream is complete"));
    stop();
    completedCb();
  }

  function getRepresentationController() {
    return representationController;
  }

  function getRepresentationId() {
    return representationController.getCurrentRepresentation().id;
  }
  /**
   * Stops download of fragments
   * @memberof OfflineStreamProcessor#
   */


  function stop() {
    if (isStopped) {
      return;
    }

    isStopped = true;
  }

  function removeExecutedRequestsBeforeTime(time) {
    if (fragmentModel) {
      fragmentModel.removeExecutedRequestsBeforeTime(time);
    }
  }
  /**
   * Execute init request for the represenation
   * @memberof OfflineStreamProcessor#
   */


  function getInitRequest() {
    if (!representationController.getCurrentRepresentation()) {
      return null;
    }

    return indexHandler.getInitRequest(getMediaInfo(), representationController.getCurrentRepresentation());
  }
  /**
   * Get next request
   * @memberof OfflineStreamProcessor#
   */


  function getNextRequest() {
    return indexHandler.getNextSegmentRequest(getMediaInfo(), representationController.getCurrentRepresentation());
  }
  /**
   * Start download
   * @memberof OfflineStreamProcessor#
   */


  function start() {
    if (representationController) {
      if (!representationController.getCurrentRepresentation()) {
        throw new Error('Start denied to OfflineStreamProcessor');
      }

      isStopped = false;
      offlineStoreController.getRepresentationCurrentState(manifestId, representationController.getCurrentRepresentation().id).then(function (state) {
        if (state) {
          indexHandler.setCurrentIndex(state.index);
          downloadedSegments = state.downloaded;
        }

        download();
      })["catch"](function () {
        // start from beginining
        download();
      });
    }
  }
  /**
   * Performs download of fragment according to type
   * @memberof OfflineStreamProcessor#
   */


  function download() {
    if (isStopped) {
      return;
    }

    if (isNaN(representationController.getCurrentRepresentation())) {
      var request = null;

      if (!isInitialized) {
        request = getInitRequest();
        isInitialized = true;
      } else {
        request = getNextRequest(); // update progression : done here because availableSegmentsNumber is done in getNextRequest from dash handler

        updateProgression();
      }

      if (request) {
        logger.info("[".concat(manifestId, "] download request : ").concat(request.url));
        fragmentModel.executeRequest(request);
      } else {
        logger.info("[".concat(manifestId, "] no request to be downloaded"));
      }
    }
  }
  /**
   * Update representation
   * @param {Object} mediaInfo - mediaInfo
   * @memberof OfflineStreamProcessor#
   */


  function updateRepresentation(mediaInfo) {
    updating = true;
    var voRepresentations = adapter.getVoRepresentations(mediaInfo); // get representation VO according to id.

    var quality = voRepresentations.findIndex(function (representation) {
      return representation.id === bitrate.id;
    });

    if (type !== constants.VIDEO && type !== constants.AUDIO && type !== constants.TEXT) {
      updating = false;
      return;
    }

    representationController.updateData(null, voRepresentations, type, mediaInfo.isFragmented, quality);
  }

  function isUpdating() {
    return updating;
  }

  function getType() {
    return type;
  }

  function getMediaInfo() {
    return mediaInfo;
  }

  function getAvailableSegmentsNumber() {
    return representationController.getCurrentRepresentation().numberOfSegments + 1; // do not forget init segment
  }

  function updateProgression() {
    if (progressCb) {
      progressCb(instance, downloadedSegments, getAvailableSegmentsNumber());
    }
  }

  function resetInitialSettings() {
    isInitialized = false;
    downloadedSegments = 0;
    updating = false;
  }
  /**
   * Reset
   * @memberof OfflineStreamProcessor#
   */


  function reset() {
    resetInitialSettings();
    indexHandler.reset();
    eventBus.off(events.STREAM_REQUESTING_COMPLETED, onStreamRequestingCompleted, instance);
    eventBus.off(events.FRAGMENT_LOADING_COMPLETED, onFragmentLoadingCompleted, instance);
  }

  instance = {
    initialize: initialize,
    getMediaInfo: getMediaInfo,
    getRepresentationController: getRepresentationController,
    removeExecutedRequestsBeforeTime: removeExecutedRequestsBeforeTime,
    getType: getType,
    getRepresentationId: getRepresentationId,
    isUpdating: isUpdating,
    start: start,
    stop: stop,
    getAvailableSegmentsNumber: getAvailableSegmentsNumber,
    reset: reset
  };
  setup();
  return instance;
}

OfflineStreamProcessor.__dashjs_factory_name = 'OfflineStreamProcessor';
var factory = dashjs.FactoryMaker.getClassFactory(OfflineStreamProcessor);
/* jshint ignore:line */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/offline/constants/OfflineConstants.js":
/*!***************************************************!*\
  !*** ./src/offline/constants/OfflineConstants.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Offline constants declaration
 * @class
 * @ignore
 */
var OfflineConstants = /*#__PURE__*/function () {
  function OfflineConstants() {
    _classCallCheck(this, OfflineConstants);

    this.init();
  }

  _createClass(OfflineConstants, [{
    key: "init",
    value: function init() {
      this.OFFLINE_SCHEME = 'offline_indexeddb';
      this.OFFLINE_URL_REGEX = /^offline_indexeddb:\/\//i;
      this.OFFLINE_STATUS_CREATED = 'created';
      this.OFFLINE_STATUS_STARTED = 'started';
      this.OFFLINE_STATUS_STOPPED = 'stopped';
      this.OFFLINE_STATUS_FINISHED = 'finished';
      this.OFFLINE_STATUS_ERROR = 'error';
    }
  }]);

  return OfflineConstants;
}();

var constants = new OfflineConstants();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (constants);

/***/ }),

/***/ "./src/offline/controllers/OfflineController.js":
/*!******************************************************!*\
  !*** ./src/offline/controllers/OfflineController.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/OfflineConstants */ "./src/offline/constants/OfflineConstants.js");
/* harmony import */ var _OfflineStoreController__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./OfflineStoreController */ "./src/offline/controllers/OfflineStoreController.js");
/* harmony import */ var _OfflineDownload__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../OfflineDownload */ "./src/offline/OfflineDownload.js");
/* harmony import */ var _net_IndexDBOfflineLoader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../net/IndexDBOfflineLoader */ "./src/offline/net/IndexDBOfflineLoader.js");
/* harmony import */ var _utils_OfflineUrlUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/OfflineUrlUtils */ "./src/offline/utils/OfflineUrlUtils.js");
/* harmony import */ var _events_OfflineEvents__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../events/OfflineEvents */ "./src/offline/events/OfflineEvents.js");
/* harmony import */ var _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../errors/OfflineErrors */ "./src/offline/errors/OfflineErrors.js");
/* harmony import */ var _vo_OfflineDownloadVo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../vo/OfflineDownloadVo */ "./src/offline/vo/OfflineDownloadVo.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */








/**
 * @module OfflineController
 * @param {Object} config - dependencies
 * @description Provides access to offline stream recording and playback functionality. This module can be accessed using the MediaPlayer API getOfflineController()
 */

function OfflineController(config) {
  var context = this.context;
  var errHandler = config.errHandler;
  var events = config.events;
  var errors = config.errors;
  var settings = config.settings;
  var eventBus = config.eventBus;
  var debug = config.debug;
  var manifestLoader = config.manifestLoader;
  var manifestModel = config.manifestModel;
  var mediaPlayerModel = config.mediaPlayerModel;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var dashMetrics = config.dashMetrics;
  var timelineConverter = config.timelineConverter;
  var segmentBaseController = config.segmentBaseController;
  var adapter = config.adapter;
  var manifestUpdater = config.manifestUpdater;
  var baseURLController = config.baseURLController;
  var schemeLoaderFactory = config.schemeLoaderFactory;
  var constants = config.constants;
  var dashConstants = config.dashConstants;
  var urlUtils = config.urlUtils;
  var instance, downloads, logger, offlineStoreController, offlineUrlUtils;

  function setup() {
    logger = debug.getLogger(instance);
    offlineStoreController = (0,_OfflineStoreController__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      eventBus: config.eventBus,
      errHandler: errHandler
    });
    offlineUrlUtils = (0,_utils_OfflineUrlUtils__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
    urlUtils.registerUrlRegex(offlineUrlUtils.getRegex(), offlineUrlUtils);
    schemeLoaderFactory.registerLoader(_constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_SCHEME, _net_IndexDBOfflineLoader__WEBPACK_IMPORTED_MODULE_3__["default"]);
    downloads = [];
  }
  /*
  ---------------------------------------------------------------------------
      DOWNLOAD LIST FUNCTIONS
  ---------------------------------------------------------------------------
  */


  function getDownloadFromId(id) {
    var download = downloads.find(function (item) {
      return item.getId() === id;
    });
    return download;
  }

  function createDownloadFromId(id) {
    var download;
    download = getDownloadFromId(id);

    if (!download) {
      // create download controller
      download = (0,_OfflineDownload__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
        id: id,
        eventBus: eventBus,
        events: events,
        errors: errors,
        settings: settings,
        manifestLoader: manifestLoader,
        manifestModel: manifestModel,
        mediaPlayerModel: mediaPlayerModel,
        manifestUpdater: manifestUpdater,
        baseURLController: baseURLController,
        abrController: abrController,
        playbackController: playbackController,
        adapter: adapter,
        dashMetrics: dashMetrics,
        timelineConverter: timelineConverter,
        errHandler: errHandler,
        segmentBaseController: segmentBaseController,
        offlineStoreController: offlineStoreController,
        debug: debug,
        constants: constants,
        dashConstants: dashConstants,
        urlUtils: urlUtils
      });
      downloads.push(download);
    }

    return download;
  }

  function createDownloadFromStorage(offline) {
    var download = getDownloadFromId(offline.manifestId);

    if (!download) {
      download = createDownloadFromId(offline.manifestId);
      var status = offline.status;

      if (status === _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_STARTED) {
        status = _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_STATUS_STOPPED;
      }

      download.setInitialState({
        url: offline.url,
        progress: offline.progress,
        originalUrl: offline.originalURL,
        status: status
      });
    }

    return download;
  }

  function removeDownloadFromId(id) {
    return new Promise(function (resolve, reject) {
      var download = getDownloadFromId(id);
      var waitForStatusChanged = false;

      if (download) {
        //is download running?
        if (download.isDownloading()) {
          //register status changed event
          waitForStatusChanged = true;

          var downloadStopped = function downloadStopped() {
            eventBus.off(events.OFFLINE_RECORD_STOPPED, downloadStopped, instance);
            return offlineStoreController.deleteDownloadById(id).then(function () {
              resolve();
            })["catch"](function (err) {
              reject(err);
            });
          };

          eventBus.on(events.OFFLINE_RECORD_STOPPED, downloadStopped, instance);
        }

        download.deleteDownload();
        var index = downloads.indexOf(download);
        downloads.splice(index, 1);
      }

      if (!waitForStatusChanged) {
        resolve();
      }
    });
  }

  function generateManifestId() {
    var timestamp = new Date().getTime();
    return timestamp;
  }
  /*
  ---------------------------------------------------------------------------
       OFFLINE CONTROLLER API
   ---------------------------------------------------------------------------
  */

  /**
   * Loads records from storage
   * This methods has to be called first, to be sure that all downloads have been loaded
   *
   * @return {Promise} asynchronously resolved
   * @memberof module:OfflineController
   */


  function loadRecordsFromStorage() {
    return new Promise(function (resolve, reject) {
      offlineStoreController.getAllManifests().then(function (items) {
        items.manifests.forEach(function (offline) {
          createDownloadFromStorage(offline);
        });
        resolve();
      })["catch"](function (e) {
        logger.error('Failed to load downloads ' + e);
        reject(e);
      });
    });
  }
  /**
   * Get all records from storage
   *
   * @return {Promise} asynchronously resolved with records
   * @memberof module:OfflineController
   * @instance
   */


  function getAllRecords() {
    var records = [];
    downloads.forEach(function (download) {
      var record = new _vo_OfflineDownloadVo__WEBPACK_IMPORTED_MODULE_7__["default"]();
      record.id = download.getId();
      record.progress = download.getDownloadProgression();
      record.url = download.getOfflineUrl();
      record.originalUrl = download.getManifestUrl();
      record.status = download.getStatus();
      records.push(record);
    });
    return records;
  }
  /**
   * Create a new content record in storage and download manifest from url
   *
   * @param {string} manifestURL - the content manifest url
   * @return {Promise} asynchronously resolved with record identifier
   * @memberof module:OfflineController
   * @instance
   */


  function createRecord(manifestURL) {
    return new Promise(function (resolve, reject) {
      var id = generateManifestId(); // create download controller

      var download = createDownloadFromId(id);
      download.downloadFromUrl(manifestURL).then(function () {
        download.initDownload();
        resolve(id);
      })["catch"](function (e) {
        logger.error('Failed to download ' + e);
        removeDownloadFromId(id).then(function () {
          reject(e);
        });
      });
    });
  }
  /**
   * Start downloading the record with selected tracks representations
   *
   * @param {string} id - record identifier
   * @param {MediaInfo[]} mediaInfos - the selected tracks representations
   * @memberof module:OfflineController
   * @instance
   */


  function startRecord(id, mediaInfos) {
    var download = getDownloadFromId(id);

    if (download) {
      download.startDownload(mediaInfos);
    }
  }
  /**
   * Stop downloading of the record
   *
   * @param {string} id - record identifier
   * @memberof module:OfflineController
   * @instance
   */


  function stopRecord(id) {
    var download = getDownloadFromId(id);

    if (download) {
      download.stopDownload();
    }
  }
  /**
   * Resume downloading of the record
   *
   * @param {string} id - record identifier
   * @memberof module:OfflineController
   * @instance
   */


  function resumeRecord(id) {
    var download = getDownloadFromId(id);

    if (download) {
      download.resumeDownload();
    }
  }
  /**
   * Deletes a record from storage
   *
   * @param {string} id - record identifier
   * @memberof module:OfflineController
   * @instance
   */


  function deleteRecord(id) {
    return removeDownloadFromId(id).then(function () {
      return offlineStoreController.deleteDownloadById(id);
    });
  }
  /**
   * Get download progression of a record
   *
   * @param {string} id - record identifier
   * @return {number} percentage progression
   * @memberof module:OfflineController
   * @instance
   */


  function getRecordProgression(id) {
    var download = getDownloadFromId(id);

    if (download) {
      return download.getDownloadProgression();
    }

    return 0;
  }
  /**
   * Reset all records
   * @memberof module:OfflineController
   * @instance
   */


  function resetRecords() {
    downloads.forEach(function (download) {
      download.resetDownload();
    });
  }
  /**
   * Reset
   * @instance
   */


  function reset() {
    resetRecords();
    schemeLoaderFactory.unregisterLoader(_constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_SCHEME);
  }

  instance = {
    loadRecordsFromStorage: loadRecordsFromStorage,
    createRecord: createRecord,
    startRecord: startRecord,
    stopRecord: stopRecord,
    resumeRecord: resumeRecord,
    deleteRecord: deleteRecord,
    getRecordProgression: getRecordProgression,
    getAllRecords: getAllRecords,
    resetRecords: resetRecords,
    reset: reset
  };
  setup();
  return instance;
}

OfflineController.__dashjs_factory_name = 'OfflineController';
var factory = dashjs.FactoryMaker.getClassFactory(OfflineController);
/* jshint ignore:line */

factory.events = _events_OfflineEvents__WEBPACK_IMPORTED_MODULE_5__["default"];
factory.errors = _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_6__["default"];
dashjs.FactoryMaker.updateClassFactory(OfflineController.__dashjs_factory_name, factory);
/* jshint ignore:line */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/offline/controllers/OfflineStoreController.js":
/*!***********************************************************!*\
  !*** ./src/offline/controllers/OfflineStoreController.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _storage_IndexDBStore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../storage/IndexDBStore */ "./src/offline/storage/IndexDBStore.js");
/* harmony import */ var _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../errors/OfflineErrors */ "./src/offline/errors/OfflineErrors.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @class OfflineStoreController
 * @description This class manages database store
 * @param {object} config
 * @ignore
 */

function OfflineStoreController(config) {
  config = config || {};
  var context = this.context;
  var errHandler = config.errHandler;
  var instance, indexDBStore;

  function setup() {
    indexDBStore = (0,_storage_IndexDBStore__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  }

  function createFragmentStore(manifestId, storeName) {
    try {
      indexDBStore.createFragmentStore(manifestId, storeName);
    } catch (err) {
      manageDOMError(err);
    }
  }

  function storeFragment(manifestId, fragmentId, fragmentData) {
    return indexDBStore.storeFragment(manifestId, fragmentId, fragmentData)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function createOfflineManifest(manifest) {
    return indexDBStore.storeManifest(manifest)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function updateOfflineManifest(manifest) {
    return indexDBStore.updateManifest(manifest)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function getManifestById(manifestId) {
    return indexDBStore.getManifestById(manifestId)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function saveSelectedRepresentations(manifestId, selected) {
    return indexDBStore.saveSelectedRepresentations(manifestId, selected)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function getCurrentHigherManifestId() {
    return indexDBStore.getCurrentHigherManifestId()["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function getAllManifests() {
    return indexDBStore.getAllManifests()["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function deleteDownloadById(manifestId) {
    return indexDBStore.deleteDownloadById(manifestId)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function setDownloadingStatus(manifestId, status) {
    return indexDBStore.setDownloadingStatus(manifestId, status)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function setRepresentationCurrentState(manifestId, representationId, state) {
    return indexDBStore.setRepresentationCurrentState(manifestId, representationId, state)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function getRepresentationCurrentState(manifestId, representationId) {
    return indexDBStore.getRepresentationCurrentState(manifestId, representationId)["catch"](function (err) {
      manageDOMError(err);
    });
  }

  function manageDOMError(err) {
    var error;

    if (err) {
      switch (err.name) {
        case 'QuotaExceededError':
          error = _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_1__["default"].INDEXEDDB_QUOTA_EXCEED_ERROR;
          break;

        case 'InvalidStateError':
          error = _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_1__["default"].INDEXEDDB_INVALID_STATE_ERROR;
          break;

        case 'NotFoundError':
          error = _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_1__["default"].INDEXEDDB_NOT_FOUND_ERROR;
          break;

        case 'VersionError':
          error = _errors_OfflineErrors__WEBPACK_IMPORTED_MODULE_1__["default"].INDEXEDDB_VERSION_ERROR;
          break;
        // TODO : Manage all DOM cases
      } // avoid importing DashJSError object from streaming


      errHandler.error({
        code: error,
        message: err.name,
        data: err
      });
    }
  }

  instance = {
    storeFragment: storeFragment,
    createOfflineManifest: createOfflineManifest,
    updateOfflineManifest: updateOfflineManifest,
    getManifestById: getManifestById,
    saveSelectedRepresentations: saveSelectedRepresentations,
    createFragmentStore: createFragmentStore,
    getCurrentHigherManifestId: getCurrentHigherManifestId,
    getAllManifests: getAllManifests,
    deleteDownloadById: deleteDownloadById,
    setDownloadingStatus: setDownloadingStatus,
    setRepresentationCurrentState: setRepresentationCurrentState,
    getRepresentationCurrentState: getRepresentationCurrentState
  };
  setup();
  return instance;
}

OfflineStoreController.__dashjs_factory_name = 'OfflineStoreController';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getClassFactory(OfflineStoreController));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/errors/OfflineErrors.js":
/*!*********************************************!*\
  !*** ./src/offline/errors/OfflineErrors.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_errors_ErrorsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/errors/ErrorsBase */ "./src/core/errors/ErrorsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Offline Errors declaration
 * @class
 */

var OfflineErrors = /*#__PURE__*/function (_ErrorsBase) {
  _inherits(OfflineErrors, _ErrorsBase);

  var _super = _createSuper(OfflineErrors);

  function OfflineErrors() {
    var _this;

    _classCallCheck(this, OfflineErrors);

    _this = _super.call(this);
    /**
     * Error code returned when an error occurs in offline module
     */

    _this.OFFLINE_ERROR = 11000; // Based upon https://developer.mozilla.org/fr/docs/Web/API/DOMException

    _this.INDEXEDDB_QUOTA_EXCEED_ERROR = 11001;
    _this.INDEXEDDB_INVALID_STATE_ERROR = 11002;
    _this.INDEXEDDB_NOT_READABLE_ERROR = 11003;
    _this.INDEXEDDB_NOT_FOUND_ERROR = 11004;
    _this.INDEXEDDB_NETWORK_ERROR = 11005;
    _this.INDEXEDDB_DATA_ERROR = 11006;
    _this.INDEXEDDB_TRANSACTION_INACTIVE_ERROR = 11007;
    _this.INDEXEDDB_NOT_ALLOWED_ERROR = 11008;
    _this.INDEXEDDB_NOT_SUPPORTED_ERROR = 11009;
    _this.INDEXEDDB_VERSION_ERROR = 11010;
    _this.INDEXEDDB_TIMEOUT_ERROR = 11011;
    _this.INDEXEDDB_ABORT_ERROR = 11012;
    _this.INDEXEDDB_UNKNOWN_ERROR = 11013;
    return _this;
  }

  return OfflineErrors;
}(_core_errors_ErrorsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var offlineErrors = new OfflineErrors();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (offlineErrors);

/***/ }),

/***/ "./src/offline/events/OfflineEvents.js":
/*!*********************************************!*\
  !*** ./src/offline/events/OfflineEvents.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../../core/events/EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }


/**
 * These are offline events that should be sent to the player level.
 * @class
 */

var OfflineEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(OfflineEvents, _EventsBase);

  var _super = _createSuper(OfflineEvents);

  function OfflineEvents() {
    var _this;

    _classCallCheck(this, OfflineEvents);

    _this = _super.call(this);
    /**
    * Triggered when all mediaInfo has been loaded
    * @event OfflineEvents#OFFLINE_RECORD_LOADEDMETADATA
    */

    _this.OFFLINE_RECORD_LOADEDMETADATA = 'public_offlineRecordLoadedmetadata';
    /**
    * Triggered when a record is initialized and download is started
    * @event OfflineEvents#OFFLINE_RECORD_STARTED
    */

    _this.OFFLINE_RECORD_STARTED = 'public_offlineRecordStarted';
    /**
    * Triggered when the user stop downloading a record
    * @event OfflineEvents#OFFLINE_RECORD_STOPPED
    */

    _this.OFFLINE_RECORD_STOPPED = 'public_offlineRecordStopped';
    /**
    * Triggered when all record has been downloaded
    * @event OfflineEvents#OFFLINE_RECORD_FINISHED
    */

    _this.OFFLINE_RECORD_FINISHED = 'public_offlineRecordFinished';
    return _this;
  }

  return OfflineEvents;
}(_core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var offlineEvents = new OfflineEvents();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (offlineEvents);

/***/ }),

/***/ "./src/offline/net/IndexDBOfflineLoader.js":
/*!*************************************************!*\
  !*** ./src/offline/net/IndexDBOfflineLoader.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _storage_IndexDBStore__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../storage/IndexDBStore */ "./src/offline/storage/IndexDBStore.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function IndexDBOfflineLoader(config) {
  config = config || {};
  var context = this.context;
  var urlUtils = config.urlUtils;
  var constants = config.constants;
  var dashConstants = config.dashConstants;
  var instance, indexDBStore;

  function setup() {
    indexDBStore = (0,_storage_IndexDBStore__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  }

  function getManifestId(url) {
    var myURL = urlUtils.removeHostname(url);
    var parts = myURL.split('/');
    return parts[0];
  }
  /**
   * Load manifest or fragment from indexeddb database
   * @param {object} config configuration of request
   */


  function load(config) {
    if (config.request) {
      var manifestId = getManifestId(config.request.url);

      if (manifestId % 1 === 0) {
        if (config.request.mediaType === constants.AUDIO || config.request.mediaType === constants.VIDEO || config.request.mediaType === constants.TEXT || config.request.mediaType === constants.MUXED || config.request.mediaType === constants.IMAGE) {
          var suffix = config.request.type === 'InitializationSegment' ? 'init' : config.request.index;
          var key = config.request.representationId + '_' + suffix;
          indexDBStore.getFragmentByKey(manifestId, key).then(function (fragment) {
            config.success(fragment, null, config.request.url, constants.ARRAY_BUFFER);
          })["catch"](function (err) {
            config.error(err);
          });
        } else if (config.request.type === dashConstants.MPD) {
          indexDBStore.getManifestById(manifestId).then(function (item) {
            indexDBStore.createFragmentStore(item.fragmentStore);
            config.success(item.manifest, null, config.request.url, constants.XML);
          })["catch"](function (err) {
            config.error(config.request, 404, err);
          });
        }
      } else {
        config.error(config.request, null, 'MediaType can not be found');
      }
    }
  }

  function abort() {// nothing to do
  }

  setup();
  instance = {
    load: load,
    abort: abort
  };
  return instance;
}

IndexDBOfflineLoader.__dashjs_factory_name = 'IndexDBOfflineLoader';
var factory = dashjs.FactoryMaker.getClassFactory(IndexDBOfflineLoader);
/* jshint ignore:line */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/offline/storage/IndexDBStore.js":
/*!*********************************************!*\
  !*** ./src/offline/storage/IndexDBStore.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @ignore
 */
var localforage = __webpack_require__(/*! localforage */ "./node_modules/localforage/dist/localforage.js");

var entities = (__webpack_require__(/*! html-entities */ "./node_modules/html-entities/index.js").XmlEntities);

function IndexDBStore() {
  var instance, manifestStore, fragmentStores;

  function setup() {
    fragmentStores = {};

    if (typeof window === 'undefined') {
      return;
    }

    localforage.config({
      driver: localforage.INDEXEDDB,
      name: 'dash_offline_db'
    });
    manifestStore = localforage.createInstance({
      driver: localforage.INDEXEDDB,
      name: 'dash_offline_db',
      version: 1.0,
      storeName: 'manifest'
    });
  } /////////////////////////////////////////
  //
  // GET/SET Methods
  //
  ////////////////////////////////////////

  /**
   * Creates an instance of localforage to store fragments in indexed db
   * @param {string} storeName
   * @instance
   */


  function createFragmentStore(storeName) {
    if (!fragmentStores[storeName]) {
      console.log('setStore  ' + storeName);
      var fragmentStore = localforage.createInstance({
        driver: localforage.INDEXEDDB,
        name: 'dash_offline_db',
        version: 1.0,
        storeName: storeName
      });
      fragmentStores[storeName] = fragmentStore;
    }
  }
  /**
   * Update download status
   * @param {number} manifestId
   * @param {string} newStatus
   * @returns {Promise} promise
   * @instance
   */


  function setDownloadingStatus(manifestId, newStatus) {
    return getManifestById(manifestId).then(function (item) {
      item.status = newStatus;
      return updateManifest(item)["catch"](function () {
        return Promise.reject('Cannot set status ' + newStatus + ' for this stream !');
      });
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Updat last downloaded fragment index for representationId
   * @param {number} manifestId - manifest id
    * @param {string} representationId - representation
   * @param {number} state - representation state
   * @returns {Promise} promise
   * @instance
   */


  function setRepresentationCurrentState(manifestId, representationId, state) {
    return getManifestById(manifestId).then(function (item) {
      if (!item.state) {
        item.state = {};
      }

      if (!item.state[representationId]) {
        item.state[representationId] = {
          index: -1,
          downloaded: 0
        };
      }

      item.state[representationId] = state;
      return updateManifest(item)["catch"](function () {
        return Promise.reject('Cannot set current index for represenation id ' + representationId);
      });
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Returns current downloaded segment index for representation
   * @param {number} manifestId - manifest id
   * @param {string} representationId - representation
   * @returns {Promise} promise
   * @instance
   */


  function getRepresentationCurrentState(manifestId, representationId) {
    return getManifestById(manifestId).then(function (item) {
      var state = {
        index: -1,
        downloaded: 0
      };

      if (item.state && item.state[representationId]) {
        state = item.state[representationId];
      }

      return Promise.resolve(state);
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Returns a fragment from its key
   * @param {number} manifestId
   * @param {number} key
   * @returns {Promise} fragment
   * @instance
   */


  function getFragmentByKey(manifestId, key) {
    var fragmentStore = fragmentStores[manifestId];

    if (!fragmentStore) {
      return Promise.reject(new Error("No fragment store found for manifest ".concat(manifestId)));
    }

    return fragmentStore.getItem(key).then(function (value) {
      return Promise.resolve(value);
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Returns a manifest from its identifier
   * @param {number} id
   * @returns {Promise} {Object[]} manifests
   * @instance
   */


  function getManifestById(id) {
    return getAllManifests().then(function (array) {
      if (array) {
        var item = null;

        for (var i = 0; i < array.manifests.length; i++) {
          if (array.manifests[i].manifestId === parseInt(id)) {
            item = array.manifests[i];
          }
        }

        if (item !== null) {
          item.manifest = entities.decode(item.manifest);
          return Promise.resolve(item);
        } else {
          return Promise.reject('Cannot found manifest with this manifestId : ' + id);
        }
      } else {
        return Promise.reject('Any manifests stored in DB !');
      }
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Returns all offline manifests
   * @returns {Promise} {Object[]} manifests
   * @instance
   */


  function getAllManifests() {
    return manifestStore.getItem('manifest').then(function (array) {
      return Promise.resolve(array ? array : {
        'manifests': []
      });
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Return higher manifest id
   * @returns {Promise} number
   * @instance
   */


  function getCurrentHigherManifestId() {
    return getAllManifests().then(function (array) {
      var higherManifestId = 0;

      if (array) {
        for (var i = 0; i < array.manifests.length; i++) {
          if (array.manifests[i].manifestId > higherManifestId) {
            higherManifestId = array.manifests[i].manifestId;
          }
        }

        return Promise.resolve(higherManifestId);
      } else {
        return Promise.resolve(higherManifestId);
      }
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Update manifest
   * @param {Object} manifest updated manifest
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function updateManifest(manifest) {
    return getAllManifests().then(function (array) {
      try {
        for (var i = 0; i < array.manifests.length; i++) {
          if (array.manifests[i].manifestId === manifest.manifestId) {
            array.manifests[i] = manifest;
          }
        }

        return manifestStore.setItem('manifest', array);
      } catch (err) {
        throw new Error('Any results found !');
      }
    });
  }
  /**
   * save selected representation by user
   * @param {Object} manifest updated manifest
   * @param {Object} selected selected representations
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function saveSelectedRepresentations(manifest, selected) {
    return getManifestById(manifest).then(function (item) {
      if (!item.selected) {
        item.selected = {};
      }

      item.selected = selected;
      return updateManifest(item)["catch"](function () {
        return Promise.reject('Cannot save selected representations');
      });
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Store a manifest in manifest array
   * @param {Object} manifest
   * @instance
   */


  function storeManifest(manifest) {
    return manifestStore.getItem('manifest').then(function (results) {
      var array = results ? results : {
        'manifests': []
      };
      array.manifests.push(manifest);
      return manifestStore.setItem('manifest', array);
    });
  }
  /**
   * Store a fragment in fragment store
   * @param {number} manifestId
   * @param {number} fragmentId
   * @param {Object} fragmentData
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function storeFragment(manifestId, fragmentId, fragmentData) {
    var fragmentStore = fragmentStores[manifestId];

    if (!fragmentStore) {
      return Promise.reject(new Error("No fragment store found for manifest ".concat(manifestId)));
    }

    return fragmentStore.setItem(fragmentId, fragmentData, function () {
      return Promise.resolve();
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  } /////////////////////////////////////////
  //
  // DROP Methods
  //
  ////////////////////////////////////////

  /**
   * Remove all manifest and fragment store
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function dropAll() {
    return localforage.clear().then(function () {
      return Promise.resolve();
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Remove framgent store given its name
   * @param {string} storeName
   * @instance
   */


  function dropFragmentStore(storeName) {
    localforage.dropInstance({
      driver: localforage.INDEXEDDB,
      name: 'dash_offline_db',
      version: 1.0,
      storeName: storeName
    }).then(function () {
      delete fragmentStores[storeName];
    })["catch"](function (err) {
      console.log('dropFragmentStore failed ' + err);
    });
    return;
  }
  /**
   * Remove download given its id (fragmentStore + manifest entry in manifest array)
   * @param {number} manifestId
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function deleteDownloadById(manifestId) {
    return manifestStore.getItem('manifest').then(function (array) {
      if (array) {
        return deleteFragmentStore(manifestId).then(function () {
          for (var i = 0; i < array.manifests.length; i++) {
            if (array.manifests[i].manifestId === parseInt(manifestId)) {
              array.manifests.splice(i, 1);
            }
          }

          return manifestStore.setItem('manifest', array).then(function () {
            return Promise.resolve('This stream has been successfull removed !');
          })["catch"](function () {
            return Promise.reject('An error occured when trying to delete this manifest');
          });
        });
      } else {
        return Promise.resolve('Nothing to delete !');
      }
    })["catch"](function (err) {
      return Promise.reject(err);
    });
  }
  /**
   * Remove fragment store
   * @param {string} storeName
   * @returns {Promise} promise asynchronously resolved
   * @instance
   */


  function deleteFragmentStore(storeName) {
    localforage.createInstance({
      name: 'dash_offline_db',
      storeName: storeName
    });
    return localforage.dropInstance({
      name: 'dash_offline_db',
      storeName: storeName
    }).then(function () {
      delete fragmentStores[storeName];
      return Promise.resolve();
    })["catch"](function (err) {
      console.log(err);
      return Promise.reject(err);
    });
  }

  setup();
  instance = {
    dropAll: dropAll,
    getFragmentByKey: getFragmentByKey,
    getManifestById: getManifestById,
    storeFragment: storeFragment,
    storeManifest: storeManifest,
    updateManifest: updateManifest,
    saveSelectedRepresentations: saveSelectedRepresentations,
    createFragmentStore: createFragmentStore,
    setDownloadingStatus: setDownloadingStatus,
    setRepresentationCurrentState: setRepresentationCurrentState,
    getRepresentationCurrentState: getRepresentationCurrentState,
    getCurrentHigherManifestId: getCurrentHigherManifestId,
    getAllManifests: getAllManifests,
    dropFragmentStore: dropFragmentStore,
    deleteDownloadById: deleteDownloadById
  };
  return instance;
}

IndexDBStore.__dashjs_factory_name = 'IndexDBStore';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getSingletonFactory(IndexDBStore));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/utils/OfflineIndexDBManifestParser.js":
/*!***********************************************************!*\
  !*** ./src/offline/utils/OfflineIndexDBManifestParser.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @ignore
 */
var Entities = (__webpack_require__(/*! html-entities */ "./node_modules/html-entities/index.js").XmlEntities);

var OFFLINE_BASE_URL = 'offline_indexeddb://';

function OfflineIndexDBManifestParser(config) {
  var manifestId = config.manifestId;
  var allMediaInfos = config.allMediaInfos;
  var urlUtils = config.urlUtils;
  var debug = config.debug;
  var dashConstants = config.dashConstants;
  var constants = config.constants;
  var instance, DOM, logger;

  function setup() {
    logger = debug.getLogger(instance);
  }
  /**
   * Parse XML manifest
   * @param {string} XMLDoc - xml manifest
   * @param {object} representation
   * @returns {Promise} a promise that will be resolved or rejected at the end of encoding process
   * @instance
  */


  function parse(XMLDoc, representation) {
    return new Promise(function (resolve, reject) {
      DOM = new DOMParser().parseFromString(XMLDoc, 'application/xml');
      var mpd = DOM.getElementsByTagName(dashConstants.MPD) ? DOM.getElementsByTagName(dashConstants.MPD) : null;

      for (var i = 0; i < mpd.length; i++) {
        if (mpd[i] !== null) {
          editBaseURLAttribute(mpd[i]);
          browsePeriods(mpd[i], representation);
        }
      }

      var manifestEncoded = encodeManifest(DOM);

      if (manifestEncoded !== '') {
        resolve(manifestEncoded);
      } else {
        reject('Encoded error');
      }
    });
  }
  /**
   * URL encode parsed manifest
   * @param {string} DOM
   * @returns {string} Url encoded XML
   * @instance
  */


  function encodeManifest(DOM) {
    logger.info('encodedManifest ' + new XMLSerializer().serializeToString(DOM));
    return new Entities().encode(new XMLSerializer().serializeToString(DOM));
  }
  /**
   * Update baseURL to point to local stored data P
   * @param {XML} currentMPD
   * @instance
  */


  function editBaseURLAttribute(currentMPD) {
    var basesURL, fragmentId, representationId;
    var url = "".concat(OFFLINE_BASE_URL).concat(manifestId, "/");
    basesURL = currentMPD.getElementsByTagName(dashConstants.BASE_URL);

    if (basesURL.length === 0) {
      // add baseURL
      var element = DOM.createElement(dashConstants.BASE_URL);
      element.innerHTML = url;
      currentMPD.appendChild(element);
    }

    basesURL = currentMPD.getElementsByTagName(dashConstants.BASE_URL);

    for (var i = 0; i < basesURL.length; i++) {
      var parent = basesURL[i].parentNode;

      if (parent.nodeName === dashConstants.MPD) {
        basesURL[i].innerHTML = url;
      } else if (parent.nodeName === dashConstants.REPRESENTATION) {
        var adaptationsSet = parent.parentNode;

        if (adaptationsSet.nodeName == dashConstants.ADAPTATION_SET) {
          if (urlUtils.isHTTPS(basesURL[i].innerHTML) || urlUtils.isHTTPURL(basesURL[i].innerHTML)) {
            fragmentId = getFragmentId(basesURL[i].innerHTML);
            representationId = getBestRepresentationId(adaptationsSet);
            basesURL[i].innerHTML = url + representationId + '_' + fragmentId;
          } else if (basesURL[i].innerHTML === './') {
            basesURL[i].innerHTML = url;
          } else {
            fragmentId = getFragmentId(basesURL[i].innerHTML);
            representationId = getBestRepresentationId(adaptationsSet);
            basesURL[i].innerHTML = representationId + '_' + fragmentId;
          }
        }
      } else {
        basesURL[i].innerHTML = url;
      }
    }
  }
  /**
   * Browse periods
   * @param {XML} currentMPD
   * @param {Object} representation
   * @instance
  */


  function browsePeriods(currentMPD, representation) {
    var periods = currentMPD.getElementsByTagName(dashConstants.PERIOD);

    for (var j = 0; j < periods.length; j++) {
      browseAdaptationsSet(periods[j], representation);
    }
  }
  /**
   * Browse adapatation set to update data (delete those taht are not choosen by user ...)
   * @param {XML} currentPeriod
   * @param {Array} representationsToUpdate
   * @instance
  */


  function browseAdaptationsSet(currentPeriod, representationsToUpdate) {
    var adaptationsSet, currentAdaptationSet, currentAdaptationType, representations;
    adaptationsSet = currentPeriod.getElementsByTagName(dashConstants.ADAPTATION_SET);

    for (var i = adaptationsSet.length - 1; i >= 0; i--) {
      currentAdaptationSet = adaptationsSet[i];

      if (currentAdaptationSet) {
        currentAdaptationType = findAdaptationType(currentAdaptationSet);
        representations = findRepresentations(currentAdaptationSet);
        findAndKeepOnlySelectedRepresentations(currentAdaptationSet, representations, currentAdaptationType);
        representations = findRepresentations(currentAdaptationSet);
        deleteSegmentBase(currentAdaptationSet);

        if (representations.length === 0) {
          currentPeriod.removeChild(currentAdaptationSet);
        } else {
          //detect Segment list use case
          for (var _i = 0; _i < representations.length; _i++) {
            var rep = representations[_i];
            var segmentList = getSegmentList(rep);

            if (segmentList.length >= 1) {
              editSegmentListAttributes(segmentList, rep);
            }
          }

          var segmentTemplate = getSegmentTemplate(currentAdaptationSet); // segmentTemplate is defined, update attributes in order to be correctly played offline

          if (segmentTemplate.length >= 1) {
            editSegmentTemplateAttributes(segmentTemplate);
          } // detect SegmentBase use case => transfrom manifest to SegmentList in SegmentTemplate


          if (representationsToUpdate && representationsToUpdate.length > 0) {
            var selectedRep = void 0;

            for (var _i2 = 0; _i2 < representations.length; _i2++) {
              var _rep = representations[_i2];

              for (var j = 0; representationsToUpdate && j < representationsToUpdate.length; j++) {
                if (representationsToUpdate[j].id === _rep.id) {
                  selectedRep = representationsToUpdate[j];
                  break;
                }
              }
            }

            addSegmentTemplateAttributes(currentAdaptationSet, selectedRep);
          }
        }
      }
    }
  }
  /**
   * Returns type of adapation set
   * @param {XML} currentAdaptationSet
   * @returns {string|null} type
   * @instance
  */


  function findAdaptationType(currentAdaptationSet) {
    if (getIsMuxed(currentAdaptationSet)) {
      return constants.MUXED;
    } else if (getIsAudio(currentAdaptationSet)) {
      return constants.AUDIO;
    } else if (getIsVideo(currentAdaptationSet)) {
      return constants.VIDEO;
    } else if (getIsText(currentAdaptationSet)) {
      return constants.TEXT;
    } else if (getIsImage(currentAdaptationSet)) {
      return constants.IMAGE;
    }

    return null;
  }

  function getIsAudio(adaptation) {
    return getIsTypeOf(adaptation, constants.AUDIO);
  }

  function getIsVideo(adaptation) {
    return getIsTypeOf(adaptation, constants.VIDEO);
  }

  function getIsText(adaptation) {
    return getIsTypeOf(adaptation, constants.TEXT);
  }

  function getIsMuxed(adaptation) {
    return getIsTypeOf(adaptation, constants.MUXED);
  }

  function getIsImage(adaptation) {
    return getIsTypeOf(adaptation, constants.IMAGE);
  } // based upon DashManifestModel, but using DomParser


  function getIsTypeOf(adaptation, type) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }

    if (!type) {
      throw new Error('type is not defined');
    }

    return testMimeType(adaptation, type);
  }

  function testMimeType(adaptation, type) {
    var mimeTypeRegEx = type !== constants.TEXT ? new RegExp(type) : new RegExp('(vtt|ttml)');
    var mimeType = findMimeType(adaptation);

    if (mimeType) {
      return mimeTypeRegEx.test(mimeType);
    } // no mime type in adaptation, search in representation


    var representations = findRepresentations(adaptation);

    if (representations) {
      for (var i = 0; i < representations.length; i++) {
        var representation = representations[i];
        mimeType = findMimeType(representation);

        if (mimeType) {
          return mimeTypeRegEx.test(mimeType);
        }
      }
    }

    return false;
  }
  /**
   * Returns mime-type of xml tag
   * @param {Object} tag
   * @returns {string|null} mimeType
   * @instance
  */


  function findMimeType(tag) {
    return tag.getAttribute(dashConstants.MIME_TYPE);
  }
  /**
   * Returns representations of adaptation set
   * @param {XML} adaptation
   * @returns {XML} representations
   * @instance
  */


  function findRepresentations(adaptation) {
    return adaptation.getElementsByTagName(dashConstants.REPRESENTATION);
  }
  /**
   * Return segment template list of adaptations set
   * @param {XML} currentAdaptationSet
   * @returns {XML} representations
   * @instance
  */


  function getSegmentTemplate(currentAdaptationSet) {
    return currentAdaptationSet.getElementsByTagName(dashConstants.SEGMENT_TEMPLATE);
  }
  /**
   * Return segment list tags of adaptations set
   * @param {XML} tag
   * @returns {XML} representations
   * @instance
  */


  function getSegmentList(tag) {
    return tag.getElementsByTagName(dashConstants.SEGMENT_LIST);
  }

  function deleteSegmentBase(tag) {
    var elements = tag.getElementsByTagName(dashConstants.SEGMENT_BASE);

    for (var i = 0; i < elements.length; i++) {
      var segmentBase = elements[i];
      segmentBase.parentNode.removeChild(segmentBase);
    }
  }
  /**
   * @param {XML} segmentTemplate
   * @param {object} rep
   * @instance
  */


  function addSegmentTimelineElements(segmentTemplate, rep) {
    var S = DOM.createElement('S');

    if (rep && rep.segments) {
      var segmentTimelineElement = DOM.createElement(dashConstants.SEGMENT_TIMELINE);
      var changedDuration = getDurationChangeArray(rep);

      for (var i = 0; i < changedDuration.length; i++) {
        var repeatValue = i + 1 < changedDuration.length ? changedDuration[i + 1] - changedDuration[i] - 1 : 0;

        if (repeatValue > 1) {
          S.setAttribute('r', repeatValue);
        }

        S.setAttribute('d', rep.segments[changedDuration[i]].duration);
        segmentTimelineElement.appendChild(S);
        S = DOM.createElement('S');
      }

      segmentTemplate.appendChild(segmentTimelineElement);
    }
  }

  function getDurationChangeArray(rep) {
    var array = [];
    array.push(0);

    for (var i = 1; i < rep.segments.length; i++) {
      if (rep.segments[i - 1].duration !== rep.segments[i].duration) {
        array.push(i);
      }
    }

    return array;
  }
  /**
   * Update attributes of segment templates to match offline urls
   * @param {Array} segmentsTemplates
   * @instance
  */


  function editSegmentTemplateAttributes(segmentsTemplates) {
    for (var i = 0; i < segmentsTemplates.length; i++) {
      var media = segmentsTemplates[i].getAttribute(dashConstants.MEDIA);
      media = '$RepresentationID$_$Number$' + media.substring(media.indexOf('.'), media.length); //id + extension

      segmentsTemplates[i].setAttribute(dashConstants.START_NUMBER, '0');
      segmentsTemplates[i].setAttribute(dashConstants.MEDIA, media);
      segmentsTemplates[i].setAttribute(dashConstants.INITIALIZATION_MINUS, '$RepresentationID$_init');
    }
  }
  /**
   * Update attributes of segment list to match offline urls
   * @param {Array} segmentLists
   * @param {Object} representation
   * @instance
  */


  function editSegmentListAttributes(segmentLists, representation) {
    var repId = representation.getAttribute(dashConstants.ID);

    for (var i = 0; i < segmentLists.length; i++) {
      var segmentList = segmentLists[i];
      var initialisation = segmentList.getElementsByTagName(dashConstants.INITIALIZATION);

      if (initialisation) {
        var sourceURL = initialisation[0].getAttribute(dashConstants.SOURCE_URL);
        sourceURL = "".concat(repId, "_init");
        initialisation[0].setAttribute(dashConstants.SOURCE_URL, sourceURL);
      }

      var segmentURLs = segmentList.getElementsByTagName(dashConstants.SEGMENT_URL);

      if (segmentURLs) {
        for (var j = 0; j < segmentURLs.length; j++) {
          var segmentUrl = segmentURLs[j];
          var media = segmentUrl.getAttribute(dashConstants.MEDIA);
          media = "".concat(repId, "_").concat(j);
          segmentUrl.setAttribute(dashConstants.MEDIA, media);
        }
      }
    }
  }
  /**
   * @param {XML} adaptationSet
   * @param {object} rep
   * @instance
  */


  function addSegmentTemplateAttributes(adaptationSet, rep) {
    var segmentTemplateElement = DOM.createElement(dashConstants.SEGMENT_TEMPLATE);
    segmentTemplateElement.setAttribute(dashConstants.START_NUMBER, '0');
    segmentTemplateElement.setAttribute(dashConstants.MEDIA, '$RepresentationID$-$Time$');
    segmentTemplateElement.setAttribute(dashConstants.INITIALIZATION_MINUS, '$RepresentationID$_init');
    addSegmentTimelineElements(segmentTemplateElement, rep);
    adaptationSet.appendChild(segmentTemplateElement);
  }
  /**
   * Delete all representations except the one choosed by user
   * @param {XML} currentAdaptationSet
   * @param {XML} representations
   * @param {string} adaptationType
   * @instance
  */


  function findAndKeepOnlySelectedRepresentations(currentAdaptationSet, representations, adaptationType) {
    for (var i = representations.length - 1; i >= 0; i--) {
      var representation = representations[i];
      var repId = representation.getAttribute(dashConstants.ID);

      if (allMediaInfos[adaptationType] && allMediaInfos[adaptationType].indexOf(repId) === -1) {
        // representation is not selected, remove it
        currentAdaptationSet.removeChild(representation);
      }
    }
  } //  UTILS

  /**
   * Get id of first representation of adaptation set
   * @param {XMl} currentAdaptationSet
   * @returns {string} id
   * @instance
  */


  function getBestRepresentationId(currentAdaptationSet) {
    var bestRepresentation = currentAdaptationSet.getElementsByTagName(dashConstants.REPRESENTATION)[0];
    console.log(bestRepresentation.getAttribute(dashConstants.ID));
    return bestRepresentation.getAttribute(dashConstants.ID);
  }
  /**
   * Parse and returns fragments of offline url => xxxx://xxxx/fragmentId/
   * @param {string} url
   * @returns {string} fragmentId
   * @instance
  */


  function getFragmentId(url) {
    var idxFragId = url.lastIndexOf('/'); //logger.warn('fragId : ' + url.substring(idxFragId + 1, url.length));

    return url.substring(idxFragId, url.length);
  }

  setup();
  instance = {
    parse: parse
  };
  return instance;
}

OfflineIndexDBManifestParser.__dashjs_factory_name = 'OfflineIndexDBManifestParser';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getClassFactory(OfflineIndexDBManifestParser));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/utils/OfflineUrlUtils.js":
/*!**********************************************!*\
  !*** ./src/offline/utils/OfflineUrlUtils.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/OfflineConstants */ "./src/offline/constants/OfflineConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function OfflineUrlUtils() {
  function setup() {}

  function getRegex() {
    return _constants_OfflineConstants__WEBPACK_IMPORTED_MODULE_0__["default"].OFFLINE_URL_REGEX;
  }
  /*
   * -------------------
   * SPECIFIC BEHAVIOUR
   * -------------------
   */


  function removeHostname(url) {
    return url.replace(/(^\w+:|^)\/\//, '');
  }

  function isRelative() {
    return false;
  }

  function resolve(url, baseUrl) {
    if (baseUrl.charAt(baseUrl.length - 1) !== '/') {
      baseUrl = baseUrl.concat('/');
    }

    return baseUrl + url;
  }

  setup();
  var instance = {
    getRegex: getRegex,
    isRelative: isRelative,
    removeHostname: removeHostname,
    resolve: resolve
  };
  return instance;
}

OfflineUrlUtils.__dashjs_factory_name = 'OfflineUrlUtils';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dashjs.FactoryMaker.getSingletonFactory(OfflineUrlUtils));
/* jshint ignore:line */

/***/ }),

/***/ "./src/offline/vo/OfflineDownloadVo.js":
/*!*********************************************!*\
  !*** ./src/offline/vo/OfflineDownloadVo.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var OfflineDownload = function OfflineDownload() {
  _classCallCheck(this, OfflineDownload);

  this.id = null;
  this.url = null;
  this.originalUrl = null;
  this.status = null;
  this.progress = null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OfflineDownload);

/***/ }),

/***/ "./src/streaming/FragmentLoader.js":
/*!*****************************************!*\
  !*** ./src/streaming/FragmentLoader.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _net_URLLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _vo_HeadRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vo/HeadRequest */ "./src/streaming/vo/HeadRequest.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function FragmentLoader(config) {
  config = config || {};
  var context = this.context;
  var eventBus = config.eventBus;
  var events = config.events;
  var urlUtils = config.urlUtils;
  var errors = config.errors;
  var streamId = config.streamId;
  var instance, urlLoader;

  function setup() {
    urlLoader = (0,_net_URLLoader__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      errHandler: config.errHandler,
      errors: errors,
      dashMetrics: config.dashMetrics,
      mediaPlayerModel: config.mediaPlayerModel,
      requestModifier: config.requestModifier,
      urlUtils: urlUtils,
      constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"],
      boxParser: config.boxParser,
      dashConstants: config.dashConstants,
      requestTimeout: config.settings.get().streaming.fragmentRequestTimeout
    });
  }

  function checkForExistence(request) {
    var report = function report(success) {
      eventBus.trigger(events.CHECK_FOR_EXISTENCE_COMPLETED, {
        request: request,
        exists: success
      });
    };

    if (request) {
      var headRequest = new _vo_HeadRequest__WEBPACK_IMPORTED_MODULE_2__["default"](request.url);
      urlLoader.load({
        request: headRequest,
        success: function success() {
          report(true);
        },
        error: function error() {
          report(false);
        }
      });
    } else {
      report(false);
    }
  }

  function load(request) {
    var report = function report(data, error) {
      eventBus.trigger(events.LOADING_COMPLETED, {
        request: request,
        response: data || null,
        error: error || null,
        sender: instance
      });
    };

    if (request) {
      urlLoader.load({
        request: request,
        progress: function progress(event) {
          eventBus.trigger(events.LOADING_PROGRESS, {
            request: request,
            stream: event.stream,
            streamId: streamId
          });

          if (event.data) {
            eventBus.trigger(events.LOADING_DATA_PROGRESS, {
              request: request,
              response: event.data || null,
              error: null,
              sender: instance
            });
          }
        },
        success: function success(data) {
          report(data);
        },
        error: function error(request, statusText, errorText) {
          report(undefined, new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__["default"](errors.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE, errorText, statusText));
        },
        abort: function abort(request) {
          if (request) {
            eventBus.trigger(events.LOADING_ABANDONED, {
              mediaType: request.mediaType,
              request: request,
              sender: instance
            });
          }
        }
      });
    } else {
      report(undefined, new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__["default"](errors.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE, errors.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE));
    }
  }

  function abort() {
    if (urlLoader) {
      urlLoader.abort();
    }
  }

  function reset() {
    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  instance = {
    checkForExistence: checkForExistence,
    load: load,
    abort: abort,
    reset: reset
  };
  setup();
  return instance;
}

FragmentLoader.__dashjs_factory_name = 'FragmentLoader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_4__["default"].getClassFactory(FragmentLoader));

/***/ }),

/***/ "./src/streaming/MediaPlayerEvents.js":
/*!********************************************!*\
  !*** ./src/streaming/MediaPlayerEvents.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/events/EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @implements EventsBase
 */

var MediaPlayerEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(MediaPlayerEvents, _EventsBase);

  var _super = _createSuper(MediaPlayerEvents);

  /**
   * @description Public facing external events to be used when developing a player that implements dash.js.
   */
  function MediaPlayerEvents() {
    var _this;

    _classCallCheck(this, MediaPlayerEvents);

    _this = _super.call(this);
    /**
     * Triggered when playback will not start yet
     * as the MPD's availabilityStartTime is in the future.
     * Check delay property in payload to determine time before playback will start.
     * @event MediaPlayerEvents#AST_IN_FUTURE
     */

    _this.AST_IN_FUTURE = 'astInFuture';
    /**
     * Triggered when the video element's buffer state changes to stalled.
     * Check mediaType in payload to determine type (Video, Audio, FragmentedText).
     * @event MediaPlayerEvents#BUFFER_EMPTY
     */

    _this.BUFFER_EMPTY = 'bufferStalled';
    /**
     * Triggered when the video element's buffer state changes to loaded.
     * Check mediaType in payload to determine type (Video, Audio, FragmentedText).
     * @event MediaPlayerEvents#BUFFER_LOADED
     */

    _this.BUFFER_LOADED = 'bufferLoaded';
    /**
     * Triggered when the video element's buffer state changes, either stalled or loaded. Check payload for state.
     * @event MediaPlayerEvents#BUFFER_LEVEL_STATE_CHANGED
     */

    _this.BUFFER_LEVEL_STATE_CHANGED = 'bufferStateChanged';
    /**
     * Triggered when the buffer level of a media type has been updated
     * @event MediaPlayerEvents#BUFFER_LEVEL_UPDATED
     */

    _this.BUFFER_LEVEL_UPDATED = 'bufferLevelUpdated';
    /**
     * Triggered when a dynamic stream changed to static (transition phase between Live and On-Demand).
     * @event MediaPlayerEvents#DYNAMIC_TO_STATIC
     */

    _this.DYNAMIC_TO_STATIC = 'dynamicToStatic';
    /**
     * Triggered when there is an error from the element or MSE source buffer.
     * @event MediaPlayerEvents#ERROR
     */

    _this.ERROR = 'error';
    /**
     * Triggered when a fragment download has completed.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_COMPLETED
     */

    _this.FRAGMENT_LOADING_COMPLETED = 'fragmentLoadingCompleted';
    /**
     * Triggered when a partial fragment download has completed.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_PROGRESS
     */

    _this.FRAGMENT_LOADING_PROGRESS = 'fragmentLoadingProgress';
    /**
     * Triggered when a fragment download has started.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_STARTED
     */

    _this.FRAGMENT_LOADING_STARTED = 'fragmentLoadingStarted';
    /**
     * Triggered when a fragment download is abandoned due to detection of slow download base on the ABR abandon rule..
     * @event MediaPlayerEvents#FRAGMENT_LOADING_ABANDONED
     */

    _this.FRAGMENT_LOADING_ABANDONED = 'fragmentLoadingAbandoned';
    /**
     * Triggered when {@link module:Debug} logger methods are called.
     * @event MediaPlayerEvents#LOG
     */

    _this.LOG = 'log';
    /**
     * Triggered when the manifest load is complete
     * @event MediaPlayerEvents#MANIFEST_LOADED
     */

    _this.MANIFEST_LOADED = 'manifestLoaded';
    /**
     * Triggered anytime there is a change to the overall metrics.
     * @event MediaPlayerEvents#METRICS_CHANGED
     */

    _this.METRICS_CHANGED = 'metricsChanged';
    /**
     * Triggered when an individual metric is added, updated or cleared.
     * @event MediaPlayerEvents#METRIC_CHANGED
     */

    _this.METRIC_CHANGED = 'metricChanged';
    /**
     * Triggered every time a new metric is added.
     * @event MediaPlayerEvents#METRIC_ADDED
     */

    _this.METRIC_ADDED = 'metricAdded';
    /**
     * Triggered every time a metric is updated.
     * @event MediaPlayerEvents#METRIC_UPDATED
     */

    _this.METRIC_UPDATED = 'metricUpdated';
    /**
     * Triggered when a new stream (period) starts.
     * @event MediaPlayerEvents#PERIOD_SWITCH_STARTED
     */

    _this.PERIOD_SWITCH_STARTED = 'periodSwitchStarted';
    /**
     * Triggered at the stream end of a period.
     * @event MediaPlayerEvents#PERIOD_SWITCH_COMPLETED
     */

    _this.PERIOD_SWITCH_COMPLETED = 'periodSwitchCompleted';
    /**
     * Triggered when an ABR up /down switch is initiated; either by user in manual mode or auto mode via ABR rules.
     * @event MediaPlayerEvents#QUALITY_CHANGE_REQUESTED
     */

    _this.QUALITY_CHANGE_REQUESTED = 'qualityChangeRequested';
    /**
     * Triggered when the new ABR quality is being rendered on-screen.
     * @event MediaPlayerEvents#QUALITY_CHANGE_RENDERED
     */

    _this.QUALITY_CHANGE_RENDERED = 'qualityChangeRendered';
    /**
     * Triggered when the new track is being rendered.
     * @event MediaPlayerEvents#TRACK_CHANGE_RENDERED
     */

    _this.TRACK_CHANGE_RENDERED = 'trackChangeRendered';
    /**
     * Triggered when a stream (period) is being loaded
     * @event MediaPlayerEvents#STREAM_INITIALIZING
     */

    _this.STREAM_INITIALIZING = 'streamInitializing';
    /**
     * Triggered when a stream (period) is loaded
     * @event MediaPlayerEvents#STREAM_UPDATED
     */

    _this.STREAM_UPDATED = 'streamUpdated';
    /**
     * Triggered when a stream (period) is activated
     * @event MediaPlayerEvents#STREAM_ACTIVATED
     */

    _this.STREAM_ACTIVATED = 'streamActivated';
    /**
     * Triggered when a stream (period) is deactivated
     * @event MediaPlayerEvents#STREAM_DEACTIVATED
     */

    _this.STREAM_DEACTIVATED = 'streamDeactivated';
    /**
     * Triggered when a stream (period) is activated
     * @event MediaPlayerEvents#STREAM_INITIALIZED
     */

    _this.STREAM_INITIALIZED = 'streamInitialized';
    /**
     * Triggered when the player has been reset.
     * @event MediaPlayerEvents#STREAM_TEARDOWN_COMPLETE
     */

    _this.STREAM_TEARDOWN_COMPLETE = 'streamTeardownComplete';
    /**
     * Triggered once all text tracks detected in the MPD are added to the video element.
     * @event MediaPlayerEvents#TEXT_TRACKS_ADDED
     */

    _this.TEXT_TRACKS_ADDED = 'allTextTracksAdded';
    /**
     * Triggered when a text track is added to the video element's TextTrackList
     * @event MediaPlayerEvents#TEXT_TRACK_ADDED
     */

    _this.TEXT_TRACK_ADDED = 'textTrackAdded';
    /**
     * Triggered when a ttml chunk is parsed.
     * @event MediaPlayerEvents#TTML_PARSED
     */

    _this.TTML_PARSED = 'ttmlParsed';
    /**
     * Triggered when a ttml chunk has to be parsed.
     * @event MediaPlayerEvents#TTML_TO_PARSE
     */

    _this.TTML_TO_PARSE = 'ttmlToParse';
    /**
     * Triggered when a caption is rendered.
     * @event MediaPlayerEvents#CAPTION_RENDERED
     */

    _this.CAPTION_RENDERED = 'captionRendered';
    /**
     * Triggered when the caption container is resized.
     * @event MediaPlayerEvents#CAPTION_CONTAINER_RESIZE
     */

    _this.CAPTION_CONTAINER_RESIZE = 'captionContainerResize';
    /**
     * Sent when enough data is available that the media can be played,
     * at least for a couple of frames.  This corresponds to the
     * HAVE_ENOUGH_DATA readyState.
     * @event MediaPlayerEvents#CAN_PLAY
     */

    _this.CAN_PLAY = 'canPlay';
    /**
     * This corresponds to the CAN_PLAY_THROUGH readyState.
     * @event MediaPlayerEvents#CAN_PLAY_THROUGH
     */

    _this.CAN_PLAY_THROUGH = 'canPlayThrough';
    /**
     * Sent when playback completes.
     * @event MediaPlayerEvents#PLAYBACK_ENDED
     */

    _this.PLAYBACK_ENDED = 'playbackEnded';
    /**
     * Sent when an error occurs.  The element's error
     * attribute contains more information.
     * @event MediaPlayerEvents#PLAYBACK_ERROR
     */

    _this.PLAYBACK_ERROR = 'playbackError';
    /**
     * Sent when playback is not allowed (for example if user gesture is needed).
     * @event MediaPlayerEvents#PLAYBACK_NOT_ALLOWED
     */

    _this.PLAYBACK_NOT_ALLOWED = 'playbackNotAllowed';
    /**
     * The media's metadata has finished loading; all attributes now
     * contain as much useful information as they're going to.
     * @event MediaPlayerEvents#PLAYBACK_METADATA_LOADED
     */

    _this.PLAYBACK_METADATA_LOADED = 'playbackMetaDataLoaded';
    /**
     * The event is fired when the frame at the current playback position of the media has finished loading;
     * often the first frame
     * @event MediaPlayerEvents#PLAYBACK_LOADED_DATA
     */

    _this.PLAYBACK_LOADED_DATA = 'playbackLoadedData';
    /**
     * Sent when playback is paused.
     * @event MediaPlayerEvents#PLAYBACK_PAUSED
     */

    _this.PLAYBACK_PAUSED = 'playbackPaused';
    /**
     * Sent when the media begins to play (either for the first time, after having been paused,
     * or after ending and then restarting).
     *
     * @event MediaPlayerEvents#PLAYBACK_PLAYING
     */

    _this.PLAYBACK_PLAYING = 'playbackPlaying';
    /**
     * Sent periodically to inform interested parties of progress downloading
     * the media. Information about the current amount of the media that has
     * been downloaded is available in the media element's buffered attribute.
     * @event MediaPlayerEvents#PLAYBACK_PROGRESS
     */

    _this.PLAYBACK_PROGRESS = 'playbackProgress';
    /**
     * Sent when the playback speed changes.
     * @event MediaPlayerEvents#PLAYBACK_RATE_CHANGED
     */

    _this.PLAYBACK_RATE_CHANGED = 'playbackRateChanged';
    /**
     * Sent when a seek operation completes.
     * @event MediaPlayerEvents#PLAYBACK_SEEKED
     */

    _this.PLAYBACK_SEEKED = 'playbackSeeked';
    /**
     * Sent when a seek operation begins.
     * @event MediaPlayerEvents#PLAYBACK_SEEKING
     */

    _this.PLAYBACK_SEEKING = 'playbackSeeking';
    /**
     * Sent when the video element reports stalled
     * @event MediaPlayerEvents#PLAYBACK_STALLED
     */

    _this.PLAYBACK_STALLED = 'playbackStalled';
    /**
     * Sent when playback of the media starts after having been paused;
     * that is, when playback is resumed after a prior pause event.
     *
     * @event MediaPlayerEvents#PLAYBACK_STARTED
     */

    _this.PLAYBACK_STARTED = 'playbackStarted';
    /**
     * The time indicated by the element's currentTime attribute has changed.
     * @event MediaPlayerEvents#PLAYBACK_TIME_UPDATED
     */

    _this.PLAYBACK_TIME_UPDATED = 'playbackTimeUpdated';
    /**
     * Sent when the video element reports that the volume has changed
     * @event MediaPlayerEvents#PLAYBACK_VOLUME_CHANGED
     */

    _this.PLAYBACK_VOLUME_CHANGED = 'playbackVolumeChanged';
    /**
     * Sent when the media playback has stopped because of a temporary lack of data.
     *
     * @event MediaPlayerEvents#PLAYBACK_WAITING
     */

    _this.PLAYBACK_WAITING = 'playbackWaiting';
    /**
     * Manifest validity changed - As a result of an MPD validity expiration event.
     * @event MediaPlayerEvents#MANIFEST_VALIDITY_CHANGED
     */

    _this.MANIFEST_VALIDITY_CHANGED = 'manifestValidityChanged';
    /**
     * Dash events are triggered at their respective start points on the timeline.
     * @event MediaPlayerEvents#EVENT_MODE_ON_START
     */

    _this.EVENT_MODE_ON_START = 'eventModeOnStart';
    /**
     * Dash events are triggered as soon as they were parsed.
     * @event MediaPlayerEvents#EVENT_MODE_ON_RECEIVE
     */

    _this.EVENT_MODE_ON_RECEIVE = 'eventModeOnReceive';
    /**
     * Event that is dispatched whenever the player encounters a potential conformance validation that might lead to unexpected/not optimal behavior
     * @event MediaPlayerEvents#CONFORMANCE_VIOLATION
     */

    _this.CONFORMANCE_VIOLATION = 'conformanceViolation';
    /**
     * Event that is dispatched whenever the player switches to a different representation
     * @event MediaPlayerEvents#REPRESENTATION_SWITCH
     */

    _this.REPRESENTATION_SWITCH = 'representationSwitch';
    /**
     * Event that is dispatched whenever an adaptation set is removed due to all representations not being supported.
     * @event MediaPlayerEvents#ADAPTATION_SET_REMOVED_NO_CAPABILITIES
     */

    _this.ADAPTATION_SET_REMOVED_NO_CAPABILITIES = 'adaptationSetRemovedNoCapabilities';
    /**
     * Triggered when a content steering request has completed.
     * @event MediaPlayerEvents#CONTENT_STEERING_REQUEST_COMPLETED
     */

    _this.CONTENT_STEERING_REQUEST_COMPLETED = 'contentSteeringRequestCompleted';
    return _this;
  }

  return MediaPlayerEvents;
}(_core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var mediaPlayerEvents = new MediaPlayerEvents();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mediaPlayerEvents);

/***/ }),

/***/ "./src/streaming/constants/Constants.js":
/*!**********************************************!*\
  !*** ./src/streaming/constants/Constants.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Constants declaration
 * @class
 * @ignore
 * @hideconstructor
 */
var Constants = /*#__PURE__*/function () {
  function Constants() {
    _classCallCheck(this, Constants);

    this.init();
  }

  _createClass(Constants, [{
    key: "init",
    value: function init() {
      /**
       *  @constant {string} STREAM Stream media type. Mainly used to report metrics relative to the full stream
       *  @memberof Constants#
       *  @static
       */
      this.STREAM = 'stream';
      /**
       *  @constant {string} VIDEO Video media type
       *  @memberof Constants#
       *  @static
       */

      this.VIDEO = 'video';
      /**
       *  @constant {string} AUDIO Audio media type
       *  @memberof Constants#
       *  @static
       */

      this.AUDIO = 'audio';
      /**
       *  @constant {string} TEXT Text media type
       *  @memberof Constants#
       *  @static
       */

      this.TEXT = 'text';
      /**
       *  @constant {string} MUXED Muxed (video/audio in the same chunk) media type
       *  @memberof Constants#
       *  @static
       */

      this.MUXED = 'muxed';
      /**
       *  @constant {string} IMAGE Image media type
       *  @memberof Constants#
       *  @static
       */

      this.IMAGE = 'image';
      /**
       *  @constant {string} STPP STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.STPP = 'stpp';
      /**
       *  @constant {string} TTML STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.TTML = 'ttml';
      /**
       *  @constant {string} VTT STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.VTT = 'vtt';
      /**
       *  @constant {string} WVTT STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.WVTT = 'wvtt';
      /**
       *  @constant {string} Content Steering
       *  @memberof Constants#
       *  @static
       */

      this.CONTENT_STEERING = 'contentSteering';
      /**
       *  @constant {string} ABR_STRATEGY_DYNAMIC Dynamic Adaptive bitrate algorithm
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_DYNAMIC = 'abrDynamic';
      /**
       *  @constant {string} ABR_STRATEGY_BOLA Adaptive bitrate algorithm based on Bola (buffer level)
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_BOLA = 'abrBola';
      /**
       *  @constant {string} ABR_STRATEGY_L2A Adaptive bitrate algorithm based on L2A (online learning)
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_L2A = 'abrL2A';
      /**
       *  @constant {string} ABR_STRATEGY_LoLP Adaptive bitrate algorithm based on LoL+
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_LoLP = 'abrLoLP';
      /**
       *  @constant {string} ABR_STRATEGY_THROUGHPUT Adaptive bitrate algorithm based on throughput
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_THROUGHPUT = 'abrThroughput';
      /**
       *  @constant {string} ABR_FETCH_THROUGHPUT_CALUCUALTION_DOWNLOADED_DATA Throughput calculation based on downloaded data array
       *  @memberof Constants#
       *  @static
       */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA = 'abrFetchThroughputCalculationDownloadedData';
      /**
       *  @constant {string} ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING = 'abrFetchThroughputCalculationMoofParsing';
      /**
      *  @constant {string} ABR_FETCH_THROUGHPUT_CALCULATION_AAST Throughput calculation based on adjusted availability start time in low latency mode
      *  @memberof Constants#
      *  @static
      */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_AAST = 'abrFetchThroughputCalculationAAST';
      /**
       *  @constant {string} LIVE_CATCHUP_MODE_DEFAULT Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.LIVE_CATCHUP_MODE_DEFAULT = 'liveCatchupModeDefault';
      /**
       *  @constant {string} LIVE_CATCHUP_MODE_LOLP Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.LIVE_CATCHUP_MODE_LOLP = 'liveCatchupModeLoLP';
      /**
       *  @constant {string} MOVING_AVERAGE_SLIDING_WINDOW Moving average sliding window
       *  @memberof Constants#
       *  @static
       */

      this.MOVING_AVERAGE_SLIDING_WINDOW = 'slidingWindow';
      /**
       *  @constant {string} EWMA Exponential moving average
       *  @memberof Constants#
       *  @static
       */

      this.MOVING_AVERAGE_EWMA = 'ewma';
      /**
       *  @constant {string} BAD_ARGUMENT_ERROR Invalid Arguments type of error
       *  @memberof Constants#
       *  @static
       */

      this.BAD_ARGUMENT_ERROR = 'Invalid Arguments';
      /**
       *  @constant {string} MISSING_CONFIG_ERROR Missing configuration parameters type of error
       *  @memberof Constants#
       *  @static
       */

      this.MISSING_CONFIG_ERROR = 'Missing config parameter(s)';
      /**
       *  @constant {string} TRACK_SWITCH_MODE_ALWAYS_REPLACE used to clear the buffered data (prior to current playback position) after track switch. Default for audio
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SWITCH_MODE_ALWAYS_REPLACE = 'alwaysReplace';
      /**
       *  @constant {string} TRACK_SWITCH_MODE_NEVER_REPLACE used to forbid clearing the buffered data (prior to current playback position) after track switch. Defers to fastSwitchEnabled for placement of new data. Default for video
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SWITCH_MODE_NEVER_REPLACE = 'neverReplace';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_FIRST_TRACK makes the player select the first track found in the manifest.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_FIRST_TRACK = 'firstTrack';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_HIGHEST_BITRATE makes the player select the track with a highest bitrate. This mode is a default mode.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_BITRATE = 'highestBitrate';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY makes the player select the track with the lowest bitrate per pixel average.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY = 'highestEfficiency';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_WIDEST_RANGE makes the player select the track with a widest range of bitrates.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_WIDEST_RANGE = 'widestRange';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_WIDEST_RANGE makes the player select the track with the highest selectionPriority as defined in the manifest
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY = 'highestSelectionPriority';
      /**
       *  @constant {string} CMCD_MODE_QUERY specifies to attach CMCD metrics as query parameters.
       *  @memberof Constants#
       *  @static
       */

      this.CMCD_MODE_QUERY = 'query';
      /**
       *  @constant {string} CMCD_MODE_HEADER specifies to attach CMCD metrics as HTTP headers.
       *  @memberof Constants#
       *  @static
       */

      this.CMCD_MODE_HEADER = 'header';
      this.LOCATION = 'Location';
      this.INITIALIZE = 'initialize';
      this.TEXT_SHOWING = 'showing';
      this.TEXT_HIDDEN = 'hidden';
      this.CC1 = 'CC1';
      this.CC3 = 'CC3';
      this.UTF8 = 'utf-8';
      this.SCHEME_ID_URI = 'schemeIdUri';
      this.START_TIME = 'starttime';
      this.SERVICE_DESCRIPTION_DVB_LL_SCHEME = 'urn:dvb:dash:lowlatency:scope:2019';
      this.SUPPLEMENTAL_PROPERTY_DVB_LL_SCHEME = 'urn:dvb:dash:lowlatency:critical:2019';
      this.XML = 'XML';
      this.ARRAY_BUFFER = 'ArrayBuffer';
      this.DVB_REPORTING_URL = 'dvb:reportingUrl';
      this.DVB_PROBABILITY = 'dvb:probability';
      this.VIDEO_ELEMENT_READY_STATES = {
        HAVE_NOTHING: 0,
        HAVE_METADATA: 1,
        HAVE_CURRENT_DATA: 2,
        HAVE_FUTURE_DATA: 3,
        HAVE_ENOUGH_DATA: 4
      };
      this.FILE_LOADER_TYPES = {
        FETCH: 'fetch_loader',
        XHR: 'xhr_loader'
      };
    }
  }]);

  return Constants;
}();

var constants = new Constants();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (constants);

/***/ }),

/***/ "./src/streaming/constants/MetricsConstants.js":
/*!*****************************************************!*\
  !*** ./src/streaming/constants/MetricsConstants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Metrics Constants declaration
 * @class
 * @ignore
 */
var MetricsConstants = /*#__PURE__*/function () {
  function MetricsConstants() {
    _classCallCheck(this, MetricsConstants);

    this.init();
  }

  _createClass(MetricsConstants, [{
    key: "init",
    value: function init() {
      this.TCP_CONNECTION = 'TcpList';
      this.HTTP_REQUEST = 'HttpList';
      this.TRACK_SWITCH = 'RepSwitchList';
      this.BUFFER_LEVEL = 'BufferLevel';
      this.BUFFER_LOADED = 'bufferLoaded';
      this.ABANDON_LOAD = 'abandonload';
      this.ALLOW_LOAD = 'allowload';
      this.BUFFER_EMPTY = 'bufferStalled';
      this.BUFFER_STATE = 'BufferState';
      this.DVR_INFO = 'DVRInfo';
      this.DROPPED_FRAMES = 'DroppedFrames';
      this.SCHEDULING_INFO = 'SchedulingInfo';
      this.REQUESTS_QUEUE = 'RequestsQueue';
      this.MANIFEST_UPDATE = 'ManifestUpdate';
      this.MANIFEST_UPDATE_STREAM_INFO = 'ManifestUpdatePeriodInfo';
      this.MANIFEST_UPDATE_TRACK_INFO = 'ManifestUpdateRepresentationInfo';
      this.PLAY_LIST = 'PlayList';
      this.DVB_ERRORS = 'DVBErrors';
      this.HTTP_REQUEST_DVB_REPORTING_TYPE = 'DVBReporting';
    }
  }]);

  return MetricsConstants;
}();

var constants = new MetricsConstants();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (constants);

/***/ }),

/***/ "./src/streaming/metrics/MetricsReportingEvents.js":
/*!*********************************************************!*\
  !*** ./src/streaming/metrics/MetricsReportingEvents.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/events/EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @implements EventsBase
 */

var MetricsReportingEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(MetricsReportingEvents, _EventsBase);

  var _super = _createSuper(MetricsReportingEvents);

  function MetricsReportingEvents() {
    var _this;

    _classCallCheck(this, MetricsReportingEvents);

    _this = _super.call(this);
    _this.METRICS_INITIALISATION_COMPLETE = 'internal_metricsReportingInitialized';
    _this.BECAME_REPORTING_PLAYER = 'internal_becameReportingPlayer';
    /**
     * Triggered when CMCD data was generated for a HTTP request
     * @event MetricsReportingEvents#CMCD_DATA_GENERATED
     */

    _this.CMCD_DATA_GENERATED = 'cmcdDataGenerated';
    return _this;
  }

  return MetricsReportingEvents;
}(_core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var metricsReportingEvents = new MetricsReportingEvents();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (metricsReportingEvents);

/***/ }),

/***/ "./src/streaming/models/CmcdModel.js":
/*!*******************************************!*\
  !*** ./src/streaming/models/CmcdModel.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _metrics_MetricsReportingEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../metrics/MetricsReportingEvents */ "./src/streaming/metrics/MetricsReportingEvents.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _dash_models_DashManifestModel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../dash/models/DashManifestModel */ "./src/dash/models/DashManifestModel.js");
/* harmony import */ var _core_Utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/Utils */ "./src/core/Utils.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */









var CMCD_REQUEST_FIELD_NAME = 'CMCD';
var CMCD_VERSION = 1;
var OBJECT_TYPES = {
  MANIFEST: 'm',
  AUDIO: 'a',
  VIDEO: 'v',
  INIT: 'i',
  CAPTION: 'c',
  ISOBMFF_TEXT_TRACK: 'tt',
  ENCRYPTION_KEY: 'k',
  OTHER: 'o'
};
var STREAMING_FORMATS = {
  DASH: 'd',
  MSS: 's'
};
var STREAM_TYPES = {
  VOD: 'v',
  LIVE: 'l'
};
var RTP_SAFETY_FACTOR = 5;

function CmcdModel() {
  var dashManifestModel, instance, internalData, abrController, dashMetrics, playbackController, streamProcessors, _isStartup, _bufferLevelStarved, _initialMediaRequestsDone;

  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();

  function setup() {
    dashManifestModel = (0,_dash_models_DashManifestModel__WEBPACK_IMPORTED_MODULE_7__["default"])(context).getInstance();

    _resetInitialSettings();
  }

  function initialize() {
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].PLAYBACK_RATE_CHANGED, _onPlaybackRateChanged, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].MANIFEST_LOADED, _onManifestLoaded, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].BUFFER_LEVEL_STATE_CHANGED, _onBufferLevelStateChanged, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].PLAYBACK_SEEKED, _onPlaybackSeeked, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD_SWITCH_COMPLETED, _onPeriodSwitchComplete, instance);
  }

  function setConfig(config) {
    if (!config) return;

    if (config.abrController) {
      abrController = config.abrController;
    }

    if (config.dashMetrics) {
      dashMetrics = config.dashMetrics;
    }

    if (config.playbackController) {
      playbackController = config.playbackController;
    }
  }

  function _resetInitialSettings() {
    internalData = {
      pr: 1,
      nor: null,
      st: null,
      sf: null,
      sid: "".concat(_core_Utils__WEBPACK_IMPORTED_MODULE_8__["default"].generateUuid()),
      cid: null
    };
    _bufferLevelStarved = {};
    _isStartup = {};
    _initialMediaRequestsDone = {};

    _updateStreamProcessors();
  }

  function _onPeriodSwitchComplete() {
    _updateStreamProcessors();
  }

  function _updateStreamProcessors() {
    if (!playbackController) return;
    var streamController = playbackController.getStreamController();
    if (!streamController) return;
    if (typeof streamController.getActiveStream !== 'function') return;
    var activeStream = streamController.getActiveStream();
    if (!activeStream) return;
    streamProcessors = activeStream.getProcessors();
  }

  function getQueryParameter(request) {
    try {
      if (settings.get().streaming.cmcd && settings.get().streaming.cmcd.enabled) {
        var cmcdData = _getCmcdData(request);

        var filteredCmcdData = _applyWhitelist(cmcdData);

        var finalPayloadString = _buildFinalString(filteredCmcdData);

        eventBus.trigger(_metrics_MetricsReportingEvents__WEBPACK_IMPORTED_MODULE_2__["default"].CMCD_DATA_GENERATED, {
          url: request.url,
          mediaType: request.mediaType,
          cmcdData: cmcdData,
          cmcdString: finalPayloadString
        });
        return {
          key: CMCD_REQUEST_FIELD_NAME,
          value: finalPayloadString
        };
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  function _applyWhitelist(cmcdData) {
    try {
      var enabledCMCDKeys = settings.get().streaming.cmcd.enabledKeys;
      return Object.keys(cmcdData).filter(function (key) {
        return enabledCMCDKeys.includes(key);
      }).reduce(function (obj, key) {
        obj[key] = cmcdData[key];
        return obj;
      }, {});
    } catch (e) {
      return cmcdData;
    }
  }

  function _copyParameters(data, parameterNames) {
    var copiedData = {};

    var _iterator = _createForOfIteratorHelper(parameterNames),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var name = _step.value;

        if (data[name]) {
          copiedData[name] = data[name];
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return copiedData;
  }

  function getHeaderParameters(request) {
    try {
      if (settings.get().streaming.cmcd && settings.get().streaming.cmcd.enabled) {
        var cmcdData = _getCmcdData(request);

        var cmcdObjectHeader = _copyParameters(cmcdData, _applyWhitelistByKeys(['br', 'd', 'ot', 'tb']));

        var cmcdRequestHeader = _copyParameters(cmcdData, _applyWhitelistByKeys(['bl', 'dl', 'mtp', 'nor', 'nrr', 'su']));

        var cmcdStatusHeader = _copyParameters(cmcdData, _applyWhitelistByKeys(['bs', 'rtp']));

        var cmcdSessionHeader = _copyParameters(cmcdData, _applyWhitelistByKeys(['cid', 'pr', 'sf', 'sid', 'st', 'v']));

        var headers = {
          'CMCD-Object': _buildFinalString(cmcdObjectHeader),
          'CMCD-Request': _buildFinalString(cmcdRequestHeader),
          'CMCD-Status': _buildFinalString(cmcdStatusHeader),
          'CMCD-Session': _buildFinalString(cmcdSessionHeader)
        };
        eventBus.trigger(_metrics_MetricsReportingEvents__WEBPACK_IMPORTED_MODULE_2__["default"].CMCD_DATA_GENERATED, {
          url: request.url,
          mediaType: request.mediaType,
          cmcdData: cmcdData,
          headers: headers
        });
        return headers;
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  function _applyWhitelistByKeys(keys) {
    var enabledCMCDKeys = settings.get().streaming.cmcd.enabledKeys;
    return keys.filter(function (key) {
      return enabledCMCDKeys.includes(key);
    });
  }

  function _getCmcdData(request) {
    try {
      var cmcdData = null;

      if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.MPD_TYPE) {
        return _getCmcdDataForMpd(request);
      } else if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.MEDIA_SEGMENT_TYPE) {
        _initForMediaType(request.mediaType);

        return _getCmcdDataForMediaSegment(request);
      } else if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.INIT_SEGMENT_TYPE) {
        return _getCmcdDataForInitSegment(request);
      } else if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.OTHER_TYPE || request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.XLINK_EXPANSION_TYPE) {
        return _getCmcdDataForOther(request);
      } else if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.LICENSE) {
        return _getCmcdDataForLicense(request);
      }

      return cmcdData;
    } catch (e) {
      return null;
    }
  }

  function _getCmcdDataForLicense(request) {
    var data = _getGenericCmcdData(request);

    data.ot = OBJECT_TYPES.ENCRYPTION_KEY;
    return data;
  }

  function _getCmcdDataForMpd() {
    var data = _getGenericCmcdData();

    data.ot = OBJECT_TYPES.MANIFEST;
    return data;
  }

  function _getCmcdDataForMediaSegment(request) {
    var data = _getGenericCmcdData();

    var encodedBitrate = _getBitrateByRequest(request);

    var d = _getObjectDurationByRequest(request);

    var mtp = _getMeasuredThroughputByType(request.mediaType);

    var dl = _getDeadlineByType(request.mediaType);

    var bl = _getBufferLevelByType(request.mediaType);

    var tb = _getTopBitrateByType(request.mediaType);

    var pr = internalData.pr;

    var nextRequest = _probeNextRequest(request.mediaType);

    var ot;
    if (request.mediaType === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].VIDEO) ot = OBJECT_TYPES.VIDEO;
    if (request.mediaType === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].AUDIO) ot = OBJECT_TYPES.AUDIO;

    if (request.mediaType === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].TEXT) {
      if (request.mediaInfo.mimeType === 'application/mp4') {
        ot = OBJECT_TYPES.ISOBMFF_TEXT_TRACK;
      } else {
        ot = OBJECT_TYPES.CAPTION;
      }
    }

    var rtp = settings.get().streaming.cmcd.rtp;

    if (!rtp) {
      rtp = _calculateRtp(request);
    }

    data.rtp = rtp;

    if (nextRequest) {
      if (request.url !== nextRequest.url) {
        data.nor = encodeURIComponent(_core_Utils__WEBPACK_IMPORTED_MODULE_8__["default"].getRelativeUrl(request.url, nextRequest.url));
      } else if (nextRequest.range) {
        data.nrr = nextRequest.range;
      }
    }

    if (encodedBitrate) {
      data.br = encodedBitrate;
    }

    if (ot) {
      data.ot = ot;
    }

    if (!isNaN(d)) {
      data.d = d;
    }

    if (!isNaN(mtp)) {
      data.mtp = mtp;
    }

    if (!isNaN(dl)) {
      data.dl = dl;
    }

    if (!isNaN(bl)) {
      data.bl = bl;
    }

    if (!isNaN(tb)) {
      data.tb = tb;
    }

    if (!isNaN(pr) && pr !== 1) {
      data.pr = pr;
    }

    if (_bufferLevelStarved[request.mediaType]) {
      data.bs = true;
      _bufferLevelStarved[request.mediaType] = false;
    }

    if (_isStartup[request.mediaType] || !_initialMediaRequestsDone[request.mediaType]) {
      data.su = true;
      _isStartup[request.mediaType] = false;
      _initialMediaRequestsDone[request.mediaType] = true;
    }

    return data;
  }

  function _initForMediaType(mediaType) {
    if (!_initialMediaRequestsDone.hasOwnProperty(mediaType)) {
      _initialMediaRequestsDone[mediaType] = false;
    }

    if (!_isStartup.hasOwnProperty(mediaType)) {
      _isStartup[mediaType] = false;
    }

    if (!_bufferLevelStarved.hasOwnProperty(mediaType)) {
      _bufferLevelStarved[mediaType] = false;
    }
  }

  function _getCmcdDataForInitSegment() {
    var data = _getGenericCmcdData();

    data.ot = OBJECT_TYPES.INIT;
    data.su = true;
    return data;
  }

  function _getCmcdDataForOther() {
    var data = _getGenericCmcdData();

    data.ot = OBJECT_TYPES.OTHER;
    return data;
  }

  function _getGenericCmcdData() {
    var data = {};
    var cid = settings.get().streaming.cmcd.cid ? settings.get().streaming.cmcd.cid : internalData.cid;
    data.v = CMCD_VERSION;
    data.sid = settings.get().streaming.cmcd.sid ? settings.get().streaming.cmcd.sid : internalData.sid;
    data.sid = "".concat(data.sid);

    if (cid) {
      data.cid = "".concat(cid);
    }

    if (!isNaN(internalData.pr) && internalData.pr !== 1 && internalData.pr !== null) {
      data.pr = internalData.pr;
    }

    if (internalData.st) {
      data.st = internalData.st;
    }

    if (internalData.sf) {
      data.sf = internalData.sf;
    }

    return data;
  }

  function _getBitrateByRequest(request) {
    try {
      var quality = request.quality;
      var bitrateList = request.mediaInfo.bitrateList;
      return parseInt(bitrateList[quality].bandwidth / 1000);
    } catch (e) {
      return null;
    }
  }

  function _getTopBitrateByType(mediaType) {
    try {
      var info = abrController.getTopBitrateInfoFor(mediaType);
      return Math.round(info.bitrate / 1000);
    } catch (e) {
      return null;
    }
  }

  function _getObjectDurationByRequest(request) {
    try {
      return !isNaN(request.duration) ? Math.round(request.duration * 1000) : null;
    } catch (e) {
      return null;
    }
  }

  function _getMeasuredThroughputByType(mediaType) {
    try {
      return parseInt(abrController.getThroughputHistory().getSafeAverageThroughput(mediaType) / 100) * 100;
    } catch (e) {
      return null;
    }
  }

  function _getDeadlineByType(mediaType) {
    try {
      var playbackRate = internalData.pr;
      var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);

      if (!isNaN(playbackRate) && !isNaN(bufferLevel)) {
        return parseInt(bufferLevel / playbackRate * 10) * 100;
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  function _getBufferLevelByType(mediaType) {
    try {
      var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);

      if (!isNaN(bufferLevel)) {
        return parseInt(bufferLevel * 10) * 100;
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  function _onPlaybackRateChanged(data) {
    try {
      internalData.pr = data.playbackRate;
    } catch (e) {}
  }

  function _onManifestLoaded(data) {
    try {
      var isDynamic = dashManifestModel.getIsDynamic(data.data);
      var st = isDynamic ? STREAM_TYPES.LIVE : STREAM_TYPES.VOD;
      var sf = data.protocol && data.protocol === 'MSS' ? STREAMING_FORMATS.MSS : STREAMING_FORMATS.DASH;
      internalData.st = "".concat(st);
      internalData.sf = "".concat(sf);
    } catch (e) {}
  }

  function _onBufferLevelStateChanged(data) {
    try {
      if (data.state && data.mediaType) {
        if (data.state === _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].BUFFER_EMPTY) {
          if (!_bufferLevelStarved[data.mediaType]) {
            _bufferLevelStarved[data.mediaType] = true;
          }

          if (!_isStartup[data.mediaType]) {
            _isStartup[data.mediaType] = true;
          }
        }
      }
    } catch (e) {}
  }

  function _onPlaybackSeeked() {
    for (var key in _bufferLevelStarved) {
      if (_bufferLevelStarved.hasOwnProperty(key)) {
        _bufferLevelStarved[key] = true;
      }
    }

    for (var _key in _isStartup) {
      if (_isStartup.hasOwnProperty(_key)) {
        _isStartup[_key] = true;
      }
    }
  }

  function _buildFinalString(cmcdData) {
    try {
      if (!cmcdData) {
        return null;
      }

      var keys = Object.keys(cmcdData).sort(function (a, b) {
        return a.localeCompare(b);
      });
      var length = keys.length;
      var cmcdString = keys.reduce(function (acc, key, index) {
        if (key === 'v' && cmcdData[key] === 1) return acc; // Version key should only be reported if it is != 1

        if (typeof cmcdData[key] === 'string' && key !== 'ot' && key !== 'sf' && key !== 'st') {
          acc += "".concat(key, "=").concat(JSON.stringify(cmcdData[key]));
        } else {
          acc += "".concat(key, "=").concat(cmcdData[key]);
        }

        if (index < length - 1) {
          acc += ',';
        }

        return acc;
      }, '');
      cmcdString = cmcdString.replace(/=true/g, ''); // Remove last comma at the end

      cmcdString = cmcdString.replace(/,\s*$/, '');
      return cmcdString;
    } catch (e) {
      return null;
    }
  }

  function _probeNextRequest(mediaType) {
    if (!streamProcessors || streamProcessors.length === 0) return;

    var _iterator2 = _createForOfIteratorHelper(streamProcessors),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var streamProcessor = _step2.value;

        if (streamProcessor.getType() === mediaType) {
          return streamProcessor.probeNextRequest();
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }

  function _calculateRtp(request) {
    // Get the values we need
    var playbackRate = playbackController.getPlaybackRate();
    if (!playbackRate) playbackRate = 1;
    var quality = request.quality,
        mediaType = request.mediaType,
        mediaInfo = request.mediaInfo,
        duration = request.duration;

    var currentBufferLevel = _getBufferLevelByType(mediaType);

    if (currentBufferLevel === 0) currentBufferLevel = 500;
    var bitrate = mediaInfo.bitrateList[quality].bandwidth; // Calculate RTP

    var segmentSize = bitrate * duration / 1000; // Calculate file size in kilobits

    var timeToLoad = currentBufferLevel / playbackRate / 1000; // Calculate time available to load file in seconds

    var minBandwidth = segmentSize / timeToLoad; // Calculate the exact bandwidth required

    var rtpSafetyFactor = settings.get().streaming.cmcd.rtpSafetyFactor && !isNaN(settings.get().streaming.cmcd.rtpSafetyFactor) ? settings.get().streaming.cmcd.rtpSafetyFactor : RTP_SAFETY_FACTOR;
    var maxBandwidth = minBandwidth * rtpSafetyFactor; // Include a safety buffer

    var rtp = (parseInt(maxBandwidth / 100) + 1) * 100; // Round to the next multiple of 100

    return rtp;
  }

  function reset() {
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].PLAYBACK_RATE_CHANGED, _onPlaybackRateChanged, this);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].MANIFEST_LOADED, _onManifestLoaded, this);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].BUFFER_LEVEL_STATE_CHANGED, _onBufferLevelStateChanged, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].PLAYBACK_SEEKED, _onPlaybackSeeked, instance);

    _resetInitialSettings();
  }

  instance = {
    getQueryParameter: getQueryParameter,
    getHeaderParameters: getHeaderParameters,
    setConfig: setConfig,
    reset: reset,
    initialize: initialize
  };
  setup();
  return instance;
}

CmcdModel.__dashjs_factory_name = 'CmcdModel';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__["default"].getSingletonFactory(CmcdModel));

/***/ }),

/***/ "./src/streaming/models/CmsdModel.js":
/*!*******************************************!*\
  !*** ./src/streaming/models/CmsdModel.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _wrapRegExp(re, groups) { _wrapRegExp = function _wrapRegExp(re, groups) { return new BabelRegExp(re, undefined, groups); }; var _RegExp = _wrapNativeSuper(RegExp); var _super = RegExp.prototype; var _groups = new WeakMap(); function BabelRegExp(re, flags, groups) { var _this = _RegExp.call(this, re, flags); _groups.set(_this, groups || _groups.get(re)); return _this; } _inherits(BabelRegExp, _RegExp); BabelRegExp.prototype.exec = function (str) { var result = _super.exec.call(this, str); if (result) result.groups = buildGroups(result, this); return result; }; BabelRegExp.prototype[Symbol.replace] = function (str, substitution) { if (typeof substitution === "string") { var groups = _groups.get(this); return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) { return "$" + groups[name]; })); } else if (typeof substitution === "function") { var _this = this; return _super[Symbol.replace].call(this, str, function () { var args = []; args.push.apply(args, arguments); if (_typeof(args[args.length - 1]) !== "object") { args.push(buildGroups(args, _this)); } return substitution.apply(this, args); }); } else { return _super[Symbol.replace].call(this, str, substitution); } }; function buildGroups(result, re) { var g = _groups.get(re); return Object.keys(g).reduce(function (groups, name) { groups[name] = result[g[name]]; return groups; }, Object.create(null)); } return _wrapRegExp.apply(this, arguments); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2022, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



 // Note: in modern browsers, the header names are returned in all lower case

var CMSD_STATIC = 'static';
var CMSD_DYNAMIC = 'dynamic';
var CMSD_RESPONSE_FIELD_BASENAME = 'cmsd-';
var CMSD_STATIC_RESPONSE_FIELD_NAME = CMSD_RESPONSE_FIELD_BASENAME + CMSD_STATIC;
var CMSD_DYNAMIC_RESPONSE_FIELD_NAME = CMSD_RESPONSE_FIELD_BASENAME + CMSD_DYNAMIC;
var CMSD_KEYS = {
  AVAILABILITY_TIME: 'at',
  DURESS: 'du',
  ENCODED_BITRATE: 'br',
  ESTIMATED_THROUGHPUT: 'etp',
  HELD_TIME: 'ht',
  INTERMEDIARY_IDENTIFIER: 'n',
  MAX_SUGGESTED_BITRATE: 'mb',
  NEXT_OBJECT_RESPONSE: 'nor',
  NEXT_RANGE_RESPONSE: 'nrr',
  OBJECT_DURATION: 'd',
  OBJECT_TYPE: 'ot',
  RESPONSE_DELAY: 'rd',
  ROUND_TRIP_TIME: 'rtt',
  STARTUP: 'su',
  STREAM_TYPE: 'st',
  STREAMING_FORMAT: 'sf',
  VERSION: 'v'
};
var OBJECT_TYPES = {
  MANIFEST: 'm',
  AUDIO: 'a',
  VIDEO: 'v',
  INIT: 'i',
  CAPTION: 'c',
  ISOBMFF_TEXT_TRACK: 'tt',
  ENCRYPTION_KEY: 'k',
  OTHER: 'o',
  STREAM: 'stream' // Specific value for parameters without object type, which apply for all media/objects

};
var PERSISTENT_PARAMS = [CMSD_KEYS.MAX_SUGGESTED_BITRATE, CMSD_KEYS.STREAM_TYPE, CMSD_KEYS.STREAMING_FORMAT, CMSD_KEYS.VERSION];
var MEDIATYPE_TO_OBJECTTYPE = {
  'video': OBJECT_TYPES.VIDEO,
  'audio': OBJECT_TYPES.AUDIO,
  'text': OBJECT_TYPES.ISOBMFF_TEXT_TRACK,
  'stream': OBJECT_TYPES.STREAM
};
var integerRegex = /^[-0-9]/;

function CmsdModel() {
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance();

  var instance, logger, _staticParamsDict, _dynamicParamsDict;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_3__["default"])(context).getInstance().getLogger(instance);

    _resetInitialSettings();
  }

  function initialize() {}

  function setConfig() {}

  function _resetInitialSettings() {
    _staticParamsDict = {};
    _dynamicParamsDict = {};
  }

  function _clearParams(params) {
    if (!params) {
      return;
    }

    Object.keys(params).forEach(function (key) {
      if (!PERSISTENT_PARAMS.includes(key)) {
        delete params[key];
      }
    });
  }

  function _parseParameterValue(value) {
    // If the value type is BOOLEAN and the value is TRUE, then the equals sign and the value are omitted
    if (!value) {
      return true;
    } // Check if boolean 'false'


    if (value.toLowerCase() === 'false') {
      return false;
    } // Check if a number


    if (integerRegex.test(value)) {
      return parseInt(value, 10);
    } // Value is a string, remove double quotes from string value


    return value.replace(/["]+/g, '');
  }

  function _parseCMSDStatic(value) {
    try {
      var params = {};
      var items = value.split(',');

      for (var i = 0; i < items.length; i++) {
        // <key>=<value>
        var substrs = items[i].split('=');
        var key = substrs[0];

        var v = _parseParameterValue(substrs[1]);

        params[key] = v;
      }

      return params;
    } catch (e) {
      logger.error('Failed to parse CMSD-Static response header value:', e);
    }
  }

  function _parseCMSDDynamic(value) {
    try {
      var params = {};
      var entries = value.split(','); // Consider only last CMSD-Dynamic entry

      var entry = entries[entries.length - 1];
      var items = entry.split(';'); // Server identifier as 1st item

      for (var i = 1; i < items.length; i++) {
        // <key>=<value>
        var substrs = items[i].split('=');
        var key = substrs[0];

        var v = _parseParameterValue(substrs[1]);

        params[key] = v;
      }

      return params;
    } catch (e) {
      logger.error('Failed to parse CMSD-Dynamic response header value:', e);
      return [];
    }
  }

  function _mediaTypetoObjectType(mediaType) {
    return MEDIATYPE_TO_OBJECTTYPE[mediaType] || OBJECT_TYPES.OTHER;
  }

  function _getParamValueForObjectType(paramsType, ot, key) {
    var params = paramsType === CMSD_STATIC ? _staticParamsDict : _dynamicParamsDict;
    var otParams = params[ot] || {};
    var streamParams = params[OBJECT_TYPES.STREAM] || {};
    var value = otParams[key] || streamParams[key];
    return value;
  }

  function parseResponseHeaders(responseHeaders, mediaType) {
    var staticParams = null;
    var dynamicParams = null;
    var headers = responseHeaders.split('\r\n'); // Ge in reverse order in order to consider only last CMSD-Dynamic header

    for (var i = headers.length - 1; i >= 0; i--) {
      var header = headers[i];
      var m = header.match( /*#__PURE__*/_wrapRegExp(/^((?:(?!:)[\s\S])*):[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*(.*)$/, {
        key: 1,
        value: 2
      }));

      if (m && m.groups) {
        // Note: in modern browsers, the header names are returned in all lower case
        var key = m.groups.key.toLowerCase(),
            value = m.groups.value;

        switch (key) {
          case CMSD_STATIC_RESPONSE_FIELD_NAME:
            staticParams = _parseCMSDStatic(value);
            eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_2__["default"].CMSD_STATIC_HEADER, staticParams);
            break;

          case CMSD_DYNAMIC_RESPONSE_FIELD_NAME:
            if (!dynamicParams) {
              dynamicParams = _parseCMSDDynamic(value);
            }

            break;

          default:
            break;
        }
      }
    } // Get object type


    var ot = OBJECT_TYPES.STREAM;

    if (staticParams && staticParams[CMSD_KEYS.OBJECT_TYPE]) {
      ot = staticParams[CMSD_KEYS.OBJECT_TYPE];
    } else if (mediaType) {
      ot = _mediaTypetoObjectType(mediaType);
    } // Clear previously received params except persistent ones 


    _clearParams(_staticParamsDict[ot]);

    _clearParams(_dynamicParamsDict[ot]); // Merge params with previously received params 


    if (staticParams) {
      _staticParamsDict[ot] = Object.assign(_staticParamsDict[ot] || {}, staticParams);
    }

    if (dynamicParams) {
      _dynamicParamsDict[ot] = Object.assign(_dynamicParamsDict[ot] || {}, dynamicParams);
    }

    return {
      "static": staticParams,
      dynamic: dynamicParams
    };
  }

  function getMaxBitrate(type) {
    var ot = _mediaTypetoObjectType(type);

    var mb = _getParamValueForObjectType(CMSD_DYNAMIC, ot, CMSD_KEYS.MAX_SUGGESTED_BITRATE);

    return mb ? mb : -1;
  }

  function getEstimatedThroughput(type) {
    var ot = _mediaTypetoObjectType(type);

    var etp = _getParamValueForObjectType(CMSD_DYNAMIC, ot, CMSD_KEYS.ESTIMATED_THROUGHPUT);

    return etp ? etp : null;
  }

  function getResponseDelay(type) {
    var ot = _mediaTypetoObjectType(type);

    var rd = _getParamValueForObjectType(CMSD_DYNAMIC, ot, CMSD_KEYS.RESPONSE_DELAY);

    return rd ? rd : null;
  }

  function getRoundTripTime(type) {
    var ot = _mediaTypetoObjectType(type);

    var rd = _getParamValueForObjectType(CMSD_DYNAMIC, ot, CMSD_KEYS.ROUND_TRIP_TIME);

    return rd ? rd : null;
  }

  function reset() {
    _resetInitialSettings();
  }

  instance = {
    setConfig: setConfig,
    initialize: initialize,
    reset: reset,
    parseResponseHeaders: parseResponseHeaders,
    getMaxBitrate: getMaxBitrate,
    getEstimatedThroughput: getEstimatedThroughput,
    getResponseDelay: getResponseDelay,
    getRoundTripTime: getRoundTripTime
  };
  setup();
  return instance;
}

CmsdModel.__dashjs_factory_name = 'CmsdModel';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(CmsdModel));

/***/ }),

/***/ "./src/streaming/models/CustomParametersModel.js":
/*!*******************************************************!*\
  !*** ./src/streaming/models/CustomParametersModel.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dash_vo_UTCTiming__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../dash/vo/UTCTiming */ "./src/dash/vo/UTCTiming.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/SupervisorTools */ "./src/streaming/utils/SupervisorTools.js");
/* harmony import */ var _rules_abr_ABRRulesCollection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../rules/abr/ABRRulesCollection */ "./src/streaming/rules/abr/ABRRulesCollection.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






var DEFAULT_XHR_WITH_CREDENTIALS = false;

function CustomParametersModel() {
  var instance, utcTimingSources, xhrWithCredentials, licenseRequestFilters, licenseResponseFilters, customCapabilitiesFilters, customInitialTrackSelectionFunction, customAbrRules;
  var context = this.context;
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_2__["default"])(context).getInstance();

  function setup() {
    xhrWithCredentials = {
      "default": DEFAULT_XHR_WITH_CREDENTIALS
    };

    _resetInitialSettings();
  }

  function _resetInitialSettings() {
    licenseRequestFilters = [];
    licenseResponseFilters = [];
    customCapabilitiesFilters = [];
    customAbrRules = [];
    customInitialTrackSelectionFunction = null;
    utcTimingSources = [];
  }

  function reset() {
    _resetInitialSettings();
  }

  function setConfig() {}
  /**
   * Registers a custom initial track selection function. Only one function is allowed. Calling this method will overwrite a potentially existing function.
   * @param {function} customFunc - the custom function that returns the initial track
   */


  function setCustomInitialTrackSelectionFunction(customFunc) {
    customInitialTrackSelectionFunction = customFunc;
  }
  /**
   * Resets the custom initial track selection
   */


  function resetCustomInitialTrackSelectionFunction() {
    customInitialTrackSelectionFunction = null;
  }
  /**
   * Returns the initial track selection function
   * @return {function}
   */


  function getCustomInitialTrackSelectionFunction() {
    return customInitialTrackSelectionFunction;
  }
  /**
   * Returns all license request filters
   * @return {array}
   */


  function getLicenseRequestFilters() {
    return licenseRequestFilters;
  }
  /**
   * Returns all license response filters
   * @return {array}
   */


  function getLicenseResponseFilters() {
    return licenseResponseFilters;
  }
  /**
   * Registers a license request filter. This enables application to manipulate/overwrite any request parameter and/or request data.
   * The provided callback function shall return a promise that shall be resolved once the filter process is completed.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the license request filter callback
   */


  function registerLicenseRequestFilter(filter) {
    licenseRequestFilters.push(filter);
  }
  /**
   * Registers a license response filter. This enables application to manipulate/overwrite the response data
   * The provided callback function shall return a promise that shall be resolved once the filter process is completed.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the license response filter callback
   */


  function registerLicenseResponseFilter(filter) {
    licenseResponseFilters.push(filter);
  }
  /**
   * Unregisters a license request filter.
   * @param {function} filter - the license request filter callback
   */


  function unregisterLicenseRequestFilter(filter) {
    _unregisterFilter(licenseRequestFilters, filter);
  }
  /**
   * Unregisters a license response filter.
   * @param {function} filter - the license response filter callback
   */


  function unregisterLicenseResponseFilter(filter) {
    _unregisterFilter(licenseResponseFilters, filter);
  }
  /**
   * Returns all custom capabilities filter
   * @return {array}
   */


  function getCustomCapabilitiesFilters() {
    return customCapabilitiesFilters;
  }
  /**
   * Registers a custom capabilities filter. This enables application to filter representations to use.
   * The provided callback function shall return a boolean based on whether or not to use the representation.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the custom capabilities filter callback
   */


  function registerCustomCapabilitiesFilter(filter) {
    customCapabilitiesFilters.push(filter);
  }
  /**
   * Unregisters a custom capabilities filter.
   * @param {function} filter - the custom capabilities filter callback
   */


  function unregisterCustomCapabilitiesFilter(filter) {
    _unregisterFilter(customCapabilitiesFilters, filter);
  }
  /**
   * Unregister a filter from the list of existing filers.
   * @param {array} filters
   * @param {function} filter
   * @private
   */


  function _unregisterFilter(filters, filter) {
    var index = -1;
    filters.some(function (item, i) {
      if (item === filter) {
        index = i;
        return true;
      }
    });
    if (index < 0) return;
    filters.splice(index, 1);
  }
  /**
   * Iterate through the list of custom ABR rules and find the right rule by name
   * @param {string} rulename
   * @return {number} rule number
   */


  function _findAbrCustomRuleIndex(rulename) {
    var i;

    for (i = 0; i < customAbrRules.length; i++) {
      if (customAbrRules[i].rulename === rulename) {
        return i;
      }
    }

    return -1;
  }
  /**
   * Add a custom ABR Rule
   * Rule will be apply on next stream if a stream is being played
   *
   * @param {string} type - rule type (one of ['qualitySwitchRules','abandonFragmentRules'])
   * @param {string} rulename - name of rule (used to identify custom rule). If one rule of same name has been added, then existing rule will be updated
   * @param {object} rule - the rule object instance
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with invalid arguments.
   */


  function addAbrCustomRule(type, rulename, rule) {
    if (typeof type !== 'string' || type !== _rules_abr_ABRRulesCollection__WEBPACK_IMPORTED_MODULE_4__["default"].ABANDON_FRAGMENT_RULES && type !== _rules_abr_ABRRulesCollection__WEBPACK_IMPORTED_MODULE_4__["default"].QUALITY_SWITCH_RULES || typeof rulename !== 'string') {
      throw _constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].BAD_ARGUMENT_ERROR;
    }

    var index = _findAbrCustomRuleIndex(rulename);

    if (index === -1) {
      // add rule
      customAbrRules.push({
        type: type,
        rulename: rulename,
        rule: rule
      });
    } else {
      // update rule
      customAbrRules[index].type = type;
      customAbrRules[index].rule = rule;
    }
  }
  /**
   * Remove a custom ABR Rule
   *
   * @param {string} rulename - name of the rule to be removed
   */


  function removeAbrCustomRule(rulename) {
    if (rulename) {
      var index = _findAbrCustomRuleIndex(rulename); //if no rulename custom rule has been found, do nothing


      if (index !== -1) {
        // remove rule
        customAbrRules.splice(index, 1);
      }
    } else {
      //if no rulename is defined, remove all ABR custome rules
      customAbrRules = [];
    }
  }
  /**
   * Remove all custom rules
   */


  function removeAllAbrCustomRule() {
    customAbrRules = [];
  }
  /**
   * Return all ABR custom rules
   * @return {array}
   */


  function getAbrCustomRules() {
    return customAbrRules;
  }
  /**
   * Add a UTC timing source at the top of the list
   * @param {string} schemeIdUri
   * @param {string} value
   */


  function addUTCTimingSource(schemeIdUri, value) {
    removeUTCTimingSource(schemeIdUri, value); //check if it already exists and remove if so.

    var vo = new _dash_vo_UTCTiming__WEBPACK_IMPORTED_MODULE_0__["default"]();
    vo.schemeIdUri = schemeIdUri;
    vo.value = value;
    utcTimingSources.push(vo);
  }
  /**
   * Return all UTC timing sources
   * @return {array}
   */


  function getUTCTimingSources() {
    return utcTimingSources;
  }
  /**
   * Remove a specific timing source from the array
   * @param {string} schemeIdUri
   * @param {string} value
   */


  function removeUTCTimingSource(schemeIdUri, value) {
    (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_3__.checkParameterType)(schemeIdUri, 'string');
    (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_3__.checkParameterType)(value, 'string');
    utcTimingSources.forEach(function (obj, idx) {
      if (obj.schemeIdUri === schemeIdUri && obj.value === value) {
        utcTimingSources.splice(idx, 1);
      }
    });
  }
  /**
   * Remove all timing sources
   */


  function clearDefaultUTCTimingSources() {
    utcTimingSources = [];
  }
  /**
   * Add the default timing source to the list
   */


  function restoreDefaultUTCTimingSources() {
    var defaultUtcTimingSource = settings.get().streaming.utcSynchronization.defaultTimingSource;
    addUTCTimingSource(defaultUtcTimingSource.scheme, defaultUtcTimingSource.value);
  }

  function setXHRWithCredentialsForType(type, value) {
    if (!type) {
      Object.keys(xhrWithCredentials).forEach(function (key) {
        setXHRWithCredentialsForType(key, value);
      });
    } else {
      xhrWithCredentials[type] = !!value;
    }
  }

  function getXHRWithCredentialsForType(type) {
    var useCreds = xhrWithCredentials[type];
    return useCreds === undefined ? xhrWithCredentials["default"] : useCreds;
  }

  instance = {
    getCustomInitialTrackSelectionFunction: getCustomInitialTrackSelectionFunction,
    setCustomInitialTrackSelectionFunction: setCustomInitialTrackSelectionFunction,
    resetCustomInitialTrackSelectionFunction: resetCustomInitialTrackSelectionFunction,
    getLicenseResponseFilters: getLicenseResponseFilters,
    getLicenseRequestFilters: getLicenseRequestFilters,
    getCustomCapabilitiesFilters: getCustomCapabilitiesFilters,
    registerCustomCapabilitiesFilter: registerCustomCapabilitiesFilter,
    registerLicenseResponseFilter: registerLicenseResponseFilter,
    registerLicenseRequestFilter: registerLicenseRequestFilter,
    unregisterCustomCapabilitiesFilter: unregisterCustomCapabilitiesFilter,
    unregisterLicenseResponseFilter: unregisterLicenseResponseFilter,
    unregisterLicenseRequestFilter: unregisterLicenseRequestFilter,
    addAbrCustomRule: addAbrCustomRule,
    removeAllAbrCustomRule: removeAllAbrCustomRule,
    removeAbrCustomRule: removeAbrCustomRule,
    getAbrCustomRules: getAbrCustomRules,
    addUTCTimingSource: addUTCTimingSource,
    removeUTCTimingSource: removeUTCTimingSource,
    getUTCTimingSources: getUTCTimingSources,
    clearDefaultUTCTimingSources: clearDefaultUTCTimingSources,
    restoreDefaultUTCTimingSources: restoreDefaultUTCTimingSources,
    setXHRWithCredentialsForType: setXHRWithCredentialsForType,
    getXHRWithCredentialsForType: getXHRWithCredentialsForType,
    setConfig: setConfig,
    reset: reset
  };
  setup();
  return instance;
}

CustomParametersModel.__dashjs_factory_name = 'CustomParametersModel';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getSingletonFactory(CustomParametersModel));

/***/ }),

/***/ "./src/streaming/models/FragmentModel.js":
/*!***********************************************!*\
  !*** ./src/streaming/models/FragmentModel.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../vo/FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


var FRAGMENT_MODEL_LOADING = 'loading';
var FRAGMENT_MODEL_EXECUTED = 'executed';
var FRAGMENT_MODEL_CANCELED = 'canceled';
var FRAGMENT_MODEL_FAILED = 'failed';

function FragmentModel(config) {
  config = config || {};
  var eventBus = config.eventBus;
  var events = config.events;
  var dashMetrics = config.dashMetrics;
  var fragmentLoader = config.fragmentLoader;
  var debug = config.debug;
  var streamInfo = config.streamInfo;
  var type = config.type;
  var instance, logger, executedRequests, loadingRequests;

  function setup() {
    logger = debug.getLogger(instance);
    resetInitialSettings();
    eventBus.on(events.LOADING_COMPLETED, onLoadingCompleted, instance);
    eventBus.on(events.LOADING_DATA_PROGRESS, onLoadingInProgress, instance);
    eventBus.on(events.LOADING_ABANDONED, onLoadingAborted, instance);
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function isFragmentLoaded(request) {
    var isEqualComplete = function isEqualComplete(req1, req2) {
      return req1.action === _vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_1__["default"].ACTION_COMPLETE && req1.action === req2.action;
    };

    var isEqualMedia = function isEqualMedia(req1, req2) {
      return !isNaN(req1.index) && req1.startTime === req2.startTime && req1.adaptationIndex === req2.adaptationIndex && req1.type === req2.type;
    };

    var isEqualInit = function isEqualInit(req1, req2) {
      return isNaN(req1.index) && isNaN(req2.index) && req1.quality === req2.quality;
    };

    var check = function check(requests) {
      var isLoaded = false;
      requests.some(function (req) {
        if (isEqualMedia(request, req) || isEqualInit(request, req) || isEqualComplete(request, req)) {
          isLoaded = true;
          return isLoaded;
        }
      });
      return isLoaded;
    };

    if (!request) {
      return false;
    }

    return check(executedRequests);
  }

  function isFragmentLoadedOrPending(request) {
    var isLoaded = false;
    var i = 0;
    var req; // First, check if the fragment has already been loaded

    isLoaded = isFragmentLoaded(request); // Then, check if the fragment is about to be loeaded

    if (!isLoaded) {
      for (i = 0; i < loadingRequests.length; i++) {
        req = loadingRequests[i];

        if (request.url === req.url && request.startTime === req.startTime) {
          isLoaded = true;
        }
      }
    }

    return isLoaded;
  }
  /**
   *
   * Gets an array of {@link FragmentRequest} objects
   *
   * @param {Object} filter The object with properties by which the method filters the requests to be returned.
   *  the only mandatory property is state, which must be a value from
   *  other properties should match the properties of {@link FragmentRequest}. E.g.:
   *  getRequests({state: FragmentModel.FRAGMENT_MODEL_EXECUTED, quality: 0}) - returns
   *  all the requests from executedRequests array where requests.quality = filter.quality
   *
   * @returns {Array}
   * @memberof FragmentModel#
   */


  function getRequests(filter) {
    var states = filter ? filter.state instanceof Array ? filter.state : [filter.state] : [];
    var filteredRequests = [];
    states.forEach(function (state) {
      var requests = getRequestsForState(state);
      filteredRequests = filteredRequests.concat(filterRequests(requests, filter));
    });
    return filteredRequests;
  }

  function getRequestThreshold(req) {
    return isNaN(req.duration) ? 0.25 : Math.min(req.duration / 8, 0.5);
  }

  function removeExecutedRequestsBeforeTime(time) {
    executedRequests = executedRequests.filter(function (req) {
      var threshold = getRequestThreshold(req);
      return isNaN(req.startTime) || (time !== undefined ? req.startTime >= time - threshold : false);
    });
  }

  function removeExecutedRequestsAfterTime(time) {
    executedRequests = executedRequests.filter(function (req) {
      return isNaN(req.startTime) || (time !== undefined ? req.startTime < time : false);
    });
  }

  function removeExecutedRequestsInTimeRange(start, end) {
    if (end <= start + 0.5) {
      return;
    }

    executedRequests = executedRequests.filter(function (req) {
      var threshold = getRequestThreshold(req);
      return isNaN(req.startTime) || req.startTime >= end - threshold || isNaN(req.duration) || req.startTime + req.duration <= start + threshold;
    });
  } // Remove requests that are not "represented" by any of buffered ranges


  function syncExecutedRequestsWithBufferedRange(bufferedRanges, streamDuration) {
    if (!bufferedRanges || bufferedRanges.length === 0) {
      removeExecutedRequestsBeforeTime();
      return;
    }

    var start = 0;

    for (var i = 0, ln = bufferedRanges.length; i < ln; i++) {
      removeExecutedRequestsInTimeRange(start, bufferedRanges.start(i));
      start = bufferedRanges.end(i);
    }

    if (streamDuration > 0) {
      removeExecutedRequestsInTimeRange(start, streamDuration);
    }
  }

  function abortRequests() {
    logger.debug('abort requests');
    fragmentLoader.abort();
    loadingRequests = [];
  }

  function executeRequest(request) {
    switch (request.action) {
      case _vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_1__["default"].ACTION_DOWNLOAD:
        addSchedulingInfoMetrics(request, FRAGMENT_MODEL_LOADING);
        loadingRequests.push(request);
        loadCurrentFragment(request);
        break;

      default:
        logger.warn('Unknown request action.');
    }
  }

  function loadCurrentFragment(request) {
    eventBus.trigger(events.FRAGMENT_LOADING_STARTED, {
      request: request
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
    fragmentLoader.load(request);
  }

  function getRequestForTime(arr, time, threshold) {
    // loop through the executed requests and pick the one for which the playback interval matches the given time
    var lastIdx = arr.length - 1;

    for (var i = lastIdx; i >= 0; i--) {
      var req = arr[i];
      var start = req.startTime;
      var end = start + req.duration;
      threshold = !isNaN(threshold) ? threshold : getRequestThreshold(req);

      if (!isNaN(start) && !isNaN(end) && time + threshold >= start && time - threshold < end || isNaN(start) && isNaN(time)) {
        return req;
      }
    }

    return null;
  }

  function filterRequests(arr, filter) {
    // for time use a specific filtration function
    if (filter.hasOwnProperty('time')) {
      return [getRequestForTime(arr, filter.time, filter.threshold)];
    }

    return arr.filter(function (request) {
      for (var prop in filter) {
        if (prop === 'state') continue;
        if (filter.hasOwnProperty(prop) && request[prop] != filter[prop]) return false;
      }

      return true;
    });
  }

  function getRequestsForState(state) {
    var requests;

    switch (state) {
      case FRAGMENT_MODEL_LOADING:
        requests = loadingRequests;
        break;

      case FRAGMENT_MODEL_EXECUTED:
        requests = executedRequests;
        break;

      default:
        requests = [];
    }

    return requests;
  }

  function addSchedulingInfoMetrics(request, state) {
    dashMetrics.addSchedulingInfo(request, state);
    dashMetrics.addRequestsQueue(request.mediaType, loadingRequests, executedRequests);
  }

  function onLoadingCompleted(e) {
    if (e.sender !== fragmentLoader) return;
    loadingRequests.splice(loadingRequests.indexOf(e.request), 1);

    if (e.response && !e.error) {
      executedRequests.push(e.request);
    }

    addSchedulingInfoMetrics(e.request, e.error ? FRAGMENT_MODEL_FAILED : FRAGMENT_MODEL_EXECUTED);
    eventBus.trigger(events.FRAGMENT_LOADING_COMPLETED, {
      request: e.request,
      response: e.response,
      error: e.error,
      sender: this
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function onLoadingInProgress(e) {
    if (e.sender !== fragmentLoader) return;
    eventBus.trigger(events.FRAGMENT_LOADING_PROGRESS, {
      request: e.request,
      response: e.response,
      error: e.error,
      sender: this
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function onLoadingAborted(e) {
    if (e.sender !== fragmentLoader) return;
    eventBus.trigger(events.FRAGMENT_LOADING_ABANDONED, {
      request: e.request
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function resetInitialSettings() {
    executedRequests = [];
    loadingRequests = [];
  }

  function reset() {
    eventBus.off(events.LOADING_COMPLETED, onLoadingCompleted, this);
    eventBus.off(events.LOADING_DATA_PROGRESS, onLoadingInProgress, this);
    eventBus.off(events.LOADING_ABANDONED, onLoadingAborted, this);

    if (fragmentLoader) {
      fragmentLoader.reset();
    }

    resetInitialSettings();
  }

  function addExecutedRequest(request) {
    executedRequests.push(request);
  }

  instance = {
    getStreamId: getStreamId,
    getType: getType,
    getRequests: getRequests,
    isFragmentLoaded: isFragmentLoaded,
    isFragmentLoadedOrPending: isFragmentLoadedOrPending,
    removeExecutedRequestsBeforeTime: removeExecutedRequestsBeforeTime,
    removeExecutedRequestsAfterTime: removeExecutedRequestsAfterTime,
    syncExecutedRequestsWithBufferedRange: syncExecutedRequestsWithBufferedRange,
    abortRequests: abortRequests,
    executeRequest: executeRequest,
    reset: reset,
    resetInitialSettings: resetInitialSettings,
    addExecutedRequest: addExecutedRequest
  };
  setup();
  return instance;
}

FragmentModel.__dashjs_factory_name = 'FragmentModel';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(FragmentModel);
factory.FRAGMENT_MODEL_LOADING = FRAGMENT_MODEL_LOADING;
factory.FRAGMENT_MODEL_EXECUTED = FRAGMENT_MODEL_EXECUTED;
factory.FRAGMENT_MODEL_CANCELED = FRAGMENT_MODEL_CANCELED;
factory.FRAGMENT_MODEL_FAILED = FRAGMENT_MODEL_FAILED;
_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].updateClassFactory(FragmentModel.__dashjs_factory_name, factory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/models/LowLatencyThroughputModel.js":
/*!***********************************************************!*\
  !*** ./src/streaming/models/LowLatencyThroughputModel.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



function LowLatencyThroughputModel() {
  var LLTM_MAX_MEASUREMENTS = 10; // factor (<1) is used to reduce the real needed download time when at very bleeding live edge

  var LLTM_SEMI_OPTIMISTIC_ESTIMATE_FACTOR = 0.8;
  var LLTM_OPTIMISTIC_ESTIMATE_FACTOR = 0.6;
  var LLTM_SLOW_SEGMENT_DOWNLOAD_TOLERANCE = 1.05;
  var LLTM_MAX_DELAY_MS = 250;
  var context = this.context;
  var instance;
  var logger;
  var measurements = {};

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance().getLogger(instance);
  }
  /**
   * Linear regression with least squares method to get a trend function for buffer lavel at chunk receive timestamps
   * @param {*} chunkMeasurements
   * @returns linear trend function
   */


  function createBufferLevelTrendFunction(chunkMeasurements) {
    var result = {};
    var sumX = 0;
    var sumY = 0;
    var sumXY = 0;
    var sumXSq = 0;
    var N = chunkMeasurements.length;

    for (var i = 0; i < N; ++i) {
      sumX += chunkMeasurements[i].chunkDownloadTimeRelativeMS;
      sumY += chunkMeasurements[i].bufferLevel;
      sumXY += chunkMeasurements[i].chunkDownloadTimeRelativeMS * chunkMeasurements[i].bufferLevel;
      sumXSq += chunkMeasurements[i].chunkDownloadTimeRelativeMS * chunkMeasurements[i].chunkDownloadTimeRelativeMS;
    }

    result.m = (sumXY - sumX * sumY / N) / (sumXSq - sumX * sumX / N);
    result.b = sumY / N - result.m * sumX / N;
    return function (x) {
      return result.m * x + result.b;
    };
  }

  function isBufferSafeAndStable(lastMeasurements) {
    var isBufferSafeAndStable = true;
    var lastBitrate;
    var aveBufferLevelLastSegements = lastMeasurements.reduce(function (prev, curr) {
      return prev + curr.bufferLevelAtSegmentEnd;
    }, 0) / lastMeasurements.length;
    lastMeasurements.forEach(function (m) {
      // inner segment buffer stability
      if (Math.abs(m.bufferLevelAtSegmentEnd / m.bufferLevelAtSegmentStart) < 0.95) {
        isBufferSafeAndStable = false;
      } // inter segment buffer stability


      if (m.bufferLevelAtSegmentEnd / aveBufferLevelLastSegements < 0.8) {
        isBufferSafeAndStable = false;
      } // representation bitrate remained at least constant


      if (!lastBitrate) {
        lastBitrate = m.bitrate;
      } else if (lastBitrate > m.bitrate) {
        isBufferSafeAndStable = false;
      }
    });
    return isBufferSafeAndStable;
  }
  /**
   * Based on the MPD, timing and buffer information of the last recent segments and their chunks
   * the most stable download time (in milliseconds) is calculated.
   * @param {*} request HTTPLoader request object
   * @returns download time in milliseconds of last fetched segment
   */


  function getEstimatedDownloadDurationMS(request) {
    var lastMeasurement = measurements[request.mediaType].slice(-1).pop();
    var lastThreeMeasurements = measurements[request.mediaType].slice(-3); // calculate and remember the buffer level trend during the last fetched segment

    var lastChunkRelativeTimeMS = lastMeasurement.chunkMeasurements.slice(-1).pop().chunkDownloadTimeRelativeMS;
    lastMeasurement.bufferLevelAtSegmentStart = lastMeasurement.getEstimatedBufferLevel(lastChunkRelativeTimeMS / 2);
    lastMeasurement.bufferLevelAtSegmentEnd = lastMeasurement.getEstimatedBufferLevel(lastChunkRelativeTimeMS);
    var isBufferStable = isBufferSafeAndStable(lastThreeMeasurements);
    var selectedOptimisticFactor = isBufferStable ? LLTM_OPTIMISTIC_ESTIMATE_FACTOR : LLTM_SEMI_OPTIMISTIC_ESTIMATE_FACTOR; // fetch duration was longer than segment duration, but buffer was stable

    if (lastMeasurement.isBufferStable && lastMeasurement.segDurationMS * LLTM_SLOW_SEGMENT_DOWNLOAD_TOLERANCE < lastMeasurement.fetchDownloadDurationMS) {
      return lastMeasurement.fetchDownloadDurationMS;
    } // buffer is drying or fetch took too long


    if (!isBufferStable || lastMeasurement.segDurationMS < lastMeasurement.fetchDownloadDurationMS) {
      return lastMeasurement.fetchDownloadDurationMS * LLTM_SEMI_OPTIMISTIC_ESTIMATE_FACTOR;
    } // did we requested a fully available segment? -> most accurate throughput calculation
    // we use adjusted availability start time to decide
    // Note: this "download mode" usually happens at startup and if requests are delayed artificially


    if (lastMeasurement.adjustedAvailabilityStartTimeMS <= lastMeasurement.requestTimeMS + lastMeasurement.throughputCapacityDelayMS - lastMeasurement.segDurationMS) {
      return lastMeasurement.fetchDownloadDurationMS * LLTM_SEMI_OPTIMISTIC_ESTIMATE_FACTOR;
    } // get all chunks that have been downloaded before fetch reached bleeding live edge
    // the remaining chunks loaded at production rate we will approximated


    var chunkAvailablePeriod = lastMeasurement.requestTimeMS + lastMeasurement.throughputCapacityDelayMS - lastMeasurement.adjustedAvailabilityStartTimeMS;
    var chunkBytesBBLE = 0; // BBLE -> Before bleeding live edge

    var chunkDownloadtimeMSBBLE = 0;
    var chunkCount = 0;

    for (var index = 0; index < lastMeasurement.chunkMeasurements.length; index++) {
      var chunk = lastMeasurement.chunkMeasurements[index];

      if (chunkAvailablePeriod < chunkDownloadtimeMSBBLE + chunk.chunkDownloadDurationMS) {
        break;
      }

      chunkDownloadtimeMSBBLE += chunk.chunkDownloadDurationMS;
      chunkBytesBBLE += chunk.chunkBytes;
      chunkCount++;
    }

    if (chunkAvailablePeriod < 0) {
      logger.warn('request time was before adjusted availibitly start time');
    } // there have to be some chunks available (20% of max count)
    // otherwise we are at bleeding live edge and the few chunks are insufficient to estimate correctly


    if (chunkBytesBBLE && chunkDownloadtimeMSBBLE && chunkCount > lastMeasurement.chunkMeasurements.length * 0.2) {
      var downloadThroughput = chunkBytesBBLE / chunkDownloadtimeMSBBLE; // bytes per millesecond

      var estimatedDownloadtimeMS = lastMeasurement.segmentBytes / downloadThroughput; // if real download was shorter then report this incl. semi optimistical estimate factor

      if (lastMeasurement.fetchDownloadDurationMS < estimatedDownloadtimeMS) {
        return lastMeasurement.fetchDownloadDurationMS * selectedOptimisticFactor;
      }

      return estimatedDownloadtimeMS * selectedOptimisticFactor;
    } // when we are to tight at live edge and it's stable then
    // we start to optimistically estimate download time
    // in such a way that a switch to next rep will be possible
    // optimistical estimate: assume download was fast enough for next higher rendition


    var nextHigherBitrate = lastMeasurement.bitrate;
    lastMeasurement.bitrateList.some(function (b) {
      if (b.bandwidth > lastMeasurement.bitrate) {
        nextHigherBitrate = b.bandwidth;
        return true;
      }
    }); // already highest bitrate?

    if (nextHigherBitrate === lastMeasurement.bitrate) {
      return lastMeasurement.fetchDownloadDurationMS * selectedOptimisticFactor;
    }

    return selectedOptimisticFactor * lastMeasurement.segmentBytes * 8 * 1000 / nextHigherBitrate;
  }
  /**
   * Get calculated value for a safe artificial delay of the next request to allow to accumulate some chunks.
   * This allows better line throughput measurement.
   * @param {*} request
   * @param {*} currentBufferLevel current buffer level in milliseconds
   * @returns delay in milliseconds
   */


  function getThroughputCapacityDelayMS(request, currentBufferLevelMS) {
    var lastThreeMeasurements = measurements[request.mediaType] && measurements[request.mediaType].slice(-3);

    if (!lastThreeMeasurements || lastThreeMeasurements.length < 3) {
      return 0;
    } // in case not stable buffer, no artificially delay for the next request


    if (!isBufferSafeAndStable(lastThreeMeasurements)) {
      return 0;
    } // allowed artificial delay is the min of quater of buffer level in milliseconds and LLTM_MAX_DELAY_MS


    return currentBufferLevelMS / 4 > LLTM_MAX_DELAY_MS ? LLTM_MAX_DELAY_MS : currentBufferLevelMS / 4;
  }
  /**
   * Add some measurement data for bookkeeping and being able to derive decisions on estimated throughput.
   * @param {*} request HTTPLoader object to get MPD and media info from
   * @param {*} fetchDownloadDurationMS Duration how long the fetch actually took
   * @param {*} chunkMeasurements Array containing chunk timings and buffer levels
   * @param {*} requestTimeMS Timestamp at which the fetch was initiated
   * @param {*} throughputCapacityDelayMS An artificial delay that was used for this request
   */


  function addMeasurement(request, fetchDownloadDurationMS, chunkMeasurements, requestTimeMS, throughputCapacityDelayMS) {
    if (request && request.mediaType && !measurements[request.mediaType]) {
      measurements[request.mediaType] = [];
    }

    var bitrateEntry = request.mediaInfo.bitrateList.find(function (item) {
      return item.id === request.representationId;
    });
    measurements[request.mediaType].push({
      index: request.index,
      repId: request.representationId,
      mediaType: request.mediaType,
      requestTimeMS: requestTimeMS,
      adjustedAvailabilityStartTimeMS: request.availabilityStartTime.getTime(),
      segDurationMS: request.duration * 1000,
      chunksDurationMS: chunkMeasurements.reduce(function (prev, curr) {
        return prev + curr.chunkDownloadDurationMS;
      }, 0),
      segmentBytes: chunkMeasurements.reduce(function (prev, curr) {
        return prev + curr.chunkBytes;
      }, 0),
      bitrate: bitrateEntry && bitrateEntry.bandwidth,
      bitrateList: request.mediaInfo.bitrateList,
      chunkMeasurements: chunkMeasurements,
      fetchDownloadDurationMS: fetchDownloadDurationMS,
      throughputCapacityDelayMS: throughputCapacityDelayMS,
      getEstimatedBufferLevel: createBufferLevelTrendFunction(chunkMeasurements.slice(1)) // don't use first chunk's buffer level

    }); // maintain only a maximum amount of most recent measurements

    if (measurements[request.mediaType].length > LLTM_MAX_MEASUREMENTS) {
      measurements[request.mediaType].shift();
    }
  }

  instance = {
    setup: setup,
    addMeasurement: addMeasurement,
    getThroughputCapacityDelayMS: getThroughputCapacityDelayMS,
    getEstimatedDownloadDurationMS: getEstimatedDownloadDurationMS
  };
  setup();
  return instance;
}

LowLatencyThroughputModel.__dashjs_factory_name = 'LowLatencyThroughputModel';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getSingletonFactory(LowLatencyThroughputModel));

/***/ }),

/***/ "./src/streaming/net/FetchLoader.js":
/*!******************************************!*\
  !*** ./src/streaming/net/FetchLoader.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _utils_RequestModifier__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/RequestModifier */ "./src/streaming/utils/RequestModifier.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




/**
 * @module FetchLoader
 * @ignore
 * @description Manages download of resources via HTTP using fetch.
 * @param {Object} cfg - dependencies from parent
 */

function FetchLoader(cfg) {
  cfg = cfg || {};
  var context = this.context;
  var requestModifier = cfg.requestModifier;
  var lowLatencyThroughputModel = cfg.lowLatencyThroughputModel;
  var boxParser = cfg.boxParser;
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance();
  var instance, dashMetrics;

  function setup(cfg) {
    dashMetrics = cfg.dashMetrics;
  }

  function load(httpRequest) {
    if (requestModifier && requestModifier.modifyRequest) {
      (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_3__.modifyRequest)(httpRequest, requestModifier).then(function () {
        return request(httpRequest);
      });
    } else {
      request(httpRequest);
    }
  }

  function request(httpRequest) {
    // Variables will be used in the callback functions
    var requestStartTime = new Date();
    var request = httpRequest.request;
    var headers = new Headers();
    /*jshint ignore:line*/

    if (request.range) {
      headers.append('Range', 'bytes=' + request.range);
    }

    if (httpRequest.headers) {
      for (var header in httpRequest.headers) {
        var value = httpRequest.headers[header];

        if (value) {
          headers.append(header, value);
        }
      }
    }

    if (!request.requestStartDate) {
      request.requestStartDate = requestStartTime;
    }

    if (requestModifier && requestModifier.modifyRequestHeader) {
      // modifyRequestHeader expects a XMLHttpRequest object so,
      // to keep backward compatibility, we should expose a setRequestHeader method
      // TODO: Remove RequestModifier dependency on XMLHttpRequest object and define
      // a more generic way to intercept/modify requests
      requestModifier.modifyRequestHeader({
        setRequestHeader: function setRequestHeader(header, value) {
          headers.append(header, value);
        }
      }, {
        url: httpRequest.url
      });
    }

    var abortController;

    if (typeof window.AbortController === 'function') {
      abortController = new AbortController();
      /*jshint ignore:line*/

      httpRequest.abortController = abortController;
      abortController.signal.onabort = httpRequest.onabort;
    }

    var reqOptions = {
      method: httpRequest.method,
      headers: headers,
      credentials: httpRequest.withCredentials ? 'include' : undefined,
      signal: abortController ? abortController.signal : undefined
    };
    var calculationMode = settings.get().streaming.abr.fetchThroughputCalculationMode;
    var requestTime = Date.now();
    var throughputCapacityDelayMS = 0;
    new Promise(function (resolve) {
      if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_AAST && lowLatencyThroughputModel) {
        throughputCapacityDelayMS = lowLatencyThroughputModel.getThroughputCapacityDelayMS(request, dashMetrics.getCurrentBufferLevel(request.mediaType) * 1000);

        if (throughputCapacityDelayMS) {
          // safely delay the "fetch" call a bit to be able to meassure the throughput capacity of the line.
          // this will lead to first few chunks downloaded at max network speed
          return setTimeout(resolve, throughputCapacityDelayMS);
        }
      }

      resolve();
    }).then(function () {
      var markBeforeFetch = Date.now();
      fetch(httpRequest.url, reqOptions).then(function (response) {
        if (!httpRequest.response) {
          httpRequest.response = {};
        }

        httpRequest.response.status = response.status;
        httpRequest.response.statusText = response.statusText;
        httpRequest.response.responseURL = response.url;

        if (!response.ok) {
          httpRequest.onerror();
        }

        var responseHeaders = '';

        var _iterator = _createForOfIteratorHelper(response.headers.keys()),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var key = _step.value;
            responseHeaders += key + ': ' + response.headers.get(key) + '\r\n';
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        httpRequest.response.responseHeaders = responseHeaders;

        if (!response.body) {
          // Fetch returning a ReadableStream response body is not currently supported by all browsers.
          // Browser compatibility: https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API
          // If it is not supported, returning the whole segment when it's ready (as xhr)
          return response.arrayBuffer().then(function (buffer) {
            httpRequest.response.response = buffer;
            var event = {
              loaded: buffer.byteLength,
              total: buffer.byteLength,
              stream: false
            };
            httpRequest.progress(event);
            httpRequest.onload();
            httpRequest.onend();
            return;
          });
        }

        var totalBytes = parseInt(response.headers.get('Content-Length'), 10);
        var bytesReceived = 0;
        var signaledFirstByte = false;
        var remaining = new Uint8Array();
        var offset = 0;

        if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_AAST && lowLatencyThroughputModel) {
          var fetchMeassurement = function fetchMeassurement(stream) {
            var reader = stream.getReader();
            var measurement = [];
            reader.read().then(function processFetch(args) {
              var value = args.value;
              var done = args.done;
              markB = Date.now();

              if (value && value.length) {
                var chunkDownloadDurationMS = markB - markA;
                var chunkBytes = value.length;
                measurement.push({
                  chunkDownloadTimeRelativeMS: markB - markBeforeFetch,
                  chunkDownloadDurationMS: chunkDownloadDurationMS,
                  chunkBytes: chunkBytes,
                  kbps: Math.round(8 * chunkBytes / (chunkDownloadDurationMS / 1000)),
                  bufferLevel: dashMetrics.getCurrentBufferLevel(request.mediaType)
                });
              }

              if (done) {
                var fetchDuration = markB - markBeforeFetch;
                var bytesAllChunks = measurement.reduce(function (prev, curr) {
                  return prev + curr.chunkBytes;
                }, 0);
                lowLatencyThroughputModel.addMeasurement(request, fetchDuration, measurement, requestTime, throughputCapacityDelayMS, responseHeaders);
                httpRequest.progress({
                  loaded: bytesAllChunks,
                  total: bytesAllChunks,
                  lengthComputable: true,
                  time: lowLatencyThroughputModel.getEstimatedDownloadDurationMS(request),
                  stream: true
                });
                return;
              }

              markA = Date.now();
              return reader.read().then(processFetch);
            });
          }; // tee'ing streams is supported by all current major browsers
          // https://developer.mozilla.org/en-US/docs/Web/API/ReadableStream/tee


          var markA = markBeforeFetch;
          var markB = 0;

          var _response$body$tee = response.body.tee(),
              _response$body$tee2 = _slicedToArray(_response$body$tee, 2),
              forMeasure = _response$body$tee2[0],
              forConsumer = _response$body$tee2[1];

          fetchMeassurement(forMeasure);
          httpRequest.reader = forConsumer.getReader();
        } else {
          httpRequest.reader = response.body.getReader();
        }

        var downloadedData = [];
        var startTimeData = [];
        var endTimeData = [];
        var lastChunkWasFinished = true;

        var processResult = function processResult(_ref) {
          var value = _ref.value,
              done = _ref.done;

          // Bug fix Parse whenever data is coming [value] better than 1ms looking that increase CPU
          if (done) {
            if (remaining) {
              if (calculationMode !== _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_AAST) {
                // If there is pending data, call progress so network metrics
                // are correctly generated
                // Same structure as https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequestEventTarget/
                var calculatedThroughput = null;
                var calculatedTime = null;

                if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING) {
                  calculatedThroughput = calculateThroughputByChunkData(startTimeData, endTimeData);

                  if (calculatedThroughput) {
                    calculatedTime = bytesReceived * 8 / calculatedThroughput;
                  }
                } else if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA) {
                  calculatedTime = calculateDownloadedTime(downloadedData, bytesReceived);
                }

                httpRequest.progress({
                  loaded: bytesReceived,
                  total: isNaN(totalBytes) ? bytesReceived : totalBytes,
                  lengthComputable: true,
                  time: calculatedTime,
                  stream: true
                });
              }

              httpRequest.response.response = remaining.buffer;
            }

            httpRequest.onload();
            httpRequest.onend();
            return;
          }

          if (value && value.length > 0) {
            remaining = concatTypedArray(remaining, value);
            bytesReceived += value.length;
            downloadedData.push({
              ts: Date.now(),
              bytes: value.length
            });

            if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING && lastChunkWasFinished) {
              // Parse the payload and capture the the 'moof' box
              var _boxesInfo = boxParser.findLastTopIsoBoxCompleted(['moof'], remaining, offset);

              if (_boxesInfo.found) {
                // Store the beginning time of each chunk download in array StartTimeData
                lastChunkWasFinished = false;
                startTimeData.push({
                  ts: performance.now(),

                  /* jshint ignore:line */
                  bytes: value.length
                });
              }
            }

            var boxesInfo = boxParser.findLastTopIsoBoxCompleted(['moov', 'mdat'], remaining, offset);

            if (boxesInfo.found) {
              var end = boxesInfo.lastCompletedOffset + boxesInfo.size; // Store the end time of each chunk download  with its size in array EndTimeData

              if (calculationMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING && !lastChunkWasFinished) {
                lastChunkWasFinished = true;
                endTimeData.push({
                  ts: performance.now(),

                  /* jshint ignore:line */
                  bytes: remaining.length
                });
              } // If we are going to pass full buffer, avoid copying it and pass
              // complete buffer. Otherwise clone the part of the buffer that is completed
              // and adjust remaining buffer. A clone is needed because ArrayBuffer of a typed-array
              // keeps a reference to the original data


              var data;

              if (end === remaining.length) {
                data = remaining;
                remaining = new Uint8Array();
              } else {
                data = new Uint8Array(remaining.subarray(0, end));
                remaining = remaining.subarray(end);
              } // Announce progress but don't track traces. Throughput measures are quite unstable
              // when they are based in small amount of data


              httpRequest.progress({
                data: data.buffer,
                lengthComputable: false,
                noTrace: true
              });
              offset = 0;
            } else {
              offset = boxesInfo.lastCompletedOffset; // Call progress so it generates traces that will be later used to know when the first byte
              // were received

              if (!signaledFirstByte) {
                httpRequest.progress({
                  lengthComputable: false,
                  noTrace: true
                });
                signaledFirstByte = true;
              }
            }
          }

          read(httpRequest, processResult);
        };

        read(httpRequest, processResult);
      })["catch"](function (e) {
        if (httpRequest.onerror) {
          httpRequest.onerror(e);
        }
      });
    });
  }

  function read(httpRequest, processResult) {
    httpRequest.reader.read().then(processResult)["catch"](function (e) {
      if (httpRequest.onerror && httpRequest.response.status === 200) {
        // Error, but response code is 200, trigger error
        httpRequest.onerror(e);
      }
    });
  }

  function concatTypedArray(remaining, data) {
    if (remaining.length === 0) {
      return data;
    }

    var result = new Uint8Array(remaining.length + data.length);
    result.set(remaining);
    result.set(data, remaining.length);
    return result;
  }

  function abort(request) {
    if (request.abortController) {
      // For firefox and edge
      request.abortController.abort();
    } else if (request.reader) {
      // For Chrome
      try {
        request.reader.cancel();
        request.onabort();
      } catch (e) {// throw exceptions (TypeError) when reader was previously closed,
        // for example, because a network issue
      }
    }
  }

  function calculateDownloadedTime(downloadedData, bytesReceived) {
    try {
      downloadedData = downloadedData.filter(function (data) {
        return data.bytes > bytesReceived / 4 / downloadedData.length;
      });

      if (downloadedData.length > 1) {
        var time = 0;
        var avgTimeDistance = (downloadedData[downloadedData.length - 1].ts - downloadedData[0].ts) / downloadedData.length;
        downloadedData.forEach(function (data, index) {
          // To be counted the data has to be over a threshold
          var next = downloadedData[index + 1];

          if (next) {
            var distance = next.ts - data.ts;
            time += distance < avgTimeDistance ? distance : 0;
          }
        });
        return time;
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  function calculateThroughputByChunkData(startTimeData, endTimeData) {
    try {
      var datum, datumE; // Filter the last chunks in a segment in both arrays [StartTimeData and EndTimeData]

      datum = startTimeData.filter(function (data, i) {
        return i < startTimeData.length - 1;
      });
      datumE = endTimeData.filter(function (dataE, i) {
        return i < endTimeData.length - 1;
      });
      var chunkThroughputs = []; // Compute the average throughput of the filtered chunk data

      if (datum.length > 1) {
        var shortDurationBytesReceived = 0;
        var shortDurationStartTime = 0;

        for (var i = 0; i < datum.length; i++) {
          if (datum[i] && datumE[i]) {
            var chunkDownloadTime = datumE[i].ts - datum[i].ts;

            if (chunkDownloadTime > 1) {
              chunkThroughputs.push(8 * datumE[i].bytes / chunkDownloadTime);
            } else {
              if (shortDurationStartTime === 0) {
                shortDurationStartTime = datum[i].ts;
              }

              var cumulatedChunkDownloadTime = datumE[i].ts - shortDurationStartTime;

              if (cumulatedChunkDownloadTime > 1) {
                chunkThroughputs.push(8 * shortDurationBytesReceived / cumulatedChunkDownloadTime);
                shortDurationBytesReceived = 0;
                shortDurationStartTime = 0;
              } else {
                // continue cumulating short duration data
                shortDurationBytesReceived += datumE[i].bytes;
              }
            }
          }
        }

        if (chunkThroughputs.length > 0) {
          var sumOfChunkThroughputs = chunkThroughputs.reduce(function (a, b) {
            return a + b;
          }, 0);
          return sumOfChunkThroughputs / chunkThroughputs.length;
        }
      }

      return null;
    } catch (e) {
      return null;
    }
  }

  instance = {
    load: load,
    abort: abort,
    calculateDownloadedTime: calculateDownloadedTime,
    setup: setup
  };
  return instance;
}

FetchLoader.__dashjs_factory_name = 'FetchLoader';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(FetchLoader);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/net/HTTPLoader.js":
/*!*****************************************!*\
  !*** ./src/streaming/net/HTTPLoader.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _XHRLoader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./XHRLoader */ "./src/streaming/net/XHRLoader.js");
/* harmony import */ var _FetchLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FetchLoader */ "./src/streaming/net/FetchLoader.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _models_CmcdModel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models/CmcdModel */ "./src/streaming/models/CmcdModel.js");
/* harmony import */ var _models_CmsdModel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../models/CmsdModel */ "./src/streaming/models/CmsdModel.js");
/* harmony import */ var _core_Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/Utils */ "./src/core/Utils.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _models_LowLatencyThroughputModel__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../models/LowLatencyThroughputModel */ "./src/streaming/models/LowLatencyThroughputModel.js");
/* harmony import */ var _models_CustomParametersModel__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../models/CustomParametersModel */ "./src/streaming/models/CustomParametersModel.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */















/**
 * @module HTTPLoader
 * @ignore
 * @description Manages download of resources via HTTP.
 * @param {Object} cfg - dependencies from parent
 */

function HTTPLoader(cfg) {
  cfg = cfg || {};
  var context = this.context;
  var errHandler = cfg.errHandler;
  var dashMetrics = cfg.dashMetrics;
  var mediaPlayerModel = cfg.mediaPlayerModel;
  var requestModifier = cfg.requestModifier;
  var boxParser = cfg.boxParser;
  var errors = cfg.errors;
  var requestTimeout = cfg.requestTimeout || 0;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_9__["default"])(context).getInstance();
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_11__["default"])(context).getInstance();
  var instance, requests, delayedRequests, retryRequests, downloadErrorToRequestTypeMap, cmcdModel, cmsdModel, customParametersModel, lowLatencyThroughputModel, logger;

  function setup() {
    var _downloadErrorToReque;

    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_8__["default"])(context).getInstance().getLogger(instance);
    requests = [];
    delayedRequests = [];
    retryRequests = [];
    cmcdModel = (0,_models_CmcdModel__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
    cmsdModel = (0,_models_CmsdModel__WEBPACK_IMPORTED_MODULE_6__["default"])(context).getInstance();
    lowLatencyThroughputModel = (0,_models_LowLatencyThroughputModel__WEBPACK_IMPORTED_MODULE_13__["default"])(context).getInstance();
    customParametersModel = (0,_models_CustomParametersModel__WEBPACK_IMPORTED_MODULE_14__["default"])(context).getInstance();
    downloadErrorToRequestTypeMap = (_downloadErrorToReque = {}, _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MPD_TYPE, errors.DOWNLOAD_ERROR_ID_MANIFEST_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.XLINK_EXPANSION_TYPE, errors.DOWNLOAD_ERROR_ID_XLINK_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.INIT_SEGMENT_TYPE, errors.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MEDIA_SEGMENT_TYPE, errors.DOWNLOAD_ERROR_ID_CONTENT_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.INDEX_SEGMENT_TYPE, errors.DOWNLOAD_ERROR_ID_CONTENT_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE, errors.DOWNLOAD_ERROR_ID_CONTENT_CODE), _defineProperty(_downloadErrorToReque, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.OTHER_TYPE, errors.DOWNLOAD_ERROR_ID_CONTENT_CODE), _downloadErrorToReque);
  }

  function internalLoad(config, remainingAttempts) {
    var request = config.request;
    var traces = [];
    var firstProgress = true;
    var needFailureReport = true;
    var requestStartTime = new Date();
    var lastTraceTime = requestStartTime;
    var lastTraceReceivedCount = 0;
    var fileLoaderType = null;
    var httpRequest;

    if (!requestModifier || !dashMetrics || !errHandler) {
      throw new Error('config object is not correct or missing');
    }

    var handleLoaded = function handleLoaded(success) {
      needFailureReport = false;
      request.requestStartDate = requestStartTime;
      request.requestEndDate = new Date();
      request.firstByteDate = request.firstByteDate || requestStartTime;
      request.fileLoaderType = fileLoaderType;

      if (!request.checkExistenceOnly) {
        var responseUrl = httpRequest.response ? httpRequest.response.responseURL : null;
        var responseStatus = httpRequest.response ? httpRequest.response.status : null;
        var responseHeaders = httpRequest.response && httpRequest.response.getAllResponseHeaders ? httpRequest.response.getAllResponseHeaders() : httpRequest.response ? httpRequest.response.responseHeaders : null;
        var cmsd = settings.get().streaming.cmsd && settings.get().streaming.cmsd.enabled ? cmsdModel.parseResponseHeaders(responseHeaders, request.mediaType) : null;
        dashMetrics.addHttpRequest(request, responseUrl, responseStatus, responseHeaders, success ? traces : null, cmsd);

        if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MPD_TYPE) {
          dashMetrics.addManifestUpdate(request);
        }
      }
    };

    var onloadend = function onloadend() {
      if (requests.indexOf(httpRequest) === -1) {
        return;
      } else {
        requests.splice(requests.indexOf(httpRequest), 1);
      }

      if (needFailureReport) {
        handleLoaded(false);

        if (remainingAttempts > 0) {
          // If we get a 404 to a media segment we should check the client clock again and perform a UTC sync in the background.
          try {
            if (settings.get().streaming.utcSynchronization.enableBackgroundSyncAfterSegmentDownloadError && request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MEDIA_SEGMENT_TYPE) {
              // Only trigger a sync if the loading failed for the first time
              var initialNumberOfAttempts = mediaPlayerModel.getRetryAttemptsForType(_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MEDIA_SEGMENT_TYPE);

              if (initialNumberOfAttempts === remainingAttempts) {
                eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_10__["default"].ATTEMPT_BACKGROUND_SYNC);
              }
            }
          } catch (e) {}

          remainingAttempts--;
          var retryRequest = {
            config: config
          };
          retryRequests.push(retryRequest);
          retryRequest.timeout = setTimeout(function () {
            if (retryRequests.indexOf(retryRequest) === -1) {
              return;
            } else {
              retryRequests.splice(retryRequests.indexOf(retryRequest), 1);
            }

            internalLoad(config, remainingAttempts);
          }, mediaPlayerModel.getRetryIntervalsForType(request.type));
        } else {
          if (request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE) {
            return;
          }

          errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_4__["default"](downloadErrorToRequestTypeMap[request.type], request.url + ' is not available', {
            request: request,
            response: httpRequest.response
          }));

          if (config.error) {
            config.error(request, 'error', httpRequest.response.statusText);
          }

          if (config.complete) {
            config.complete(request, httpRequest.response.statusText);
          }
        }
      }
    };

    var progress = function progress(event) {
      var currentTime = new Date();

      if (firstProgress) {
        firstProgress = false;

        if (!event.lengthComputable || event.lengthComputable && event.total !== event.loaded) {
          request.firstByteDate = currentTime;
        }
      }

      if (event.lengthComputable) {
        request.bytesLoaded = event.loaded;
        request.bytesTotal = event.total;
      }

      if (!event.noTrace) {
        traces.push({
          s: lastTraceTime,
          d: event.time ? event.time : currentTime.getTime() - lastTraceTime.getTime(),
          b: [event.loaded ? event.loaded - lastTraceReceivedCount : 0]
        });
        lastTraceTime = currentTime;
        lastTraceReceivedCount = event.loaded;
      }

      if (config.progress && event) {
        config.progress(event);
      }
    };

    var onload = function onload() {
      if (httpRequest.response.status >= 200 && httpRequest.response.status <= 299) {
        handleLoaded(true);

        if (config.success) {
          config.success(httpRequest.response.response, httpRequest.response.statusText, httpRequest.response.responseURL);
        }

        if (config.complete) {
          config.complete(request, httpRequest.response.statusText);
        }
      }
    };

    var onabort = function onabort() {
      if (config.abort) {
        config.abort(request);
      }
    };

    var ontimeout = function ontimeout(event) {
      var timeoutMessage;

      if (event.lengthComputable) {
        var percentageComplete = event.loaded / event.total * 100;
        timeoutMessage = 'Request timeout: loaded: ' + event.loaded + ', out of: ' + event.total + ' : ' + percentageComplete.toFixed(3) + '% Completed';
      } else {
        timeoutMessage = 'Request timeout: non-computable download size';
      }

      logger.warn(timeoutMessage);
    };

    var loader;

    if (request.hasOwnProperty('availabilityTimeComplete') && request.availabilityTimeComplete === false && window.fetch && request.responseType === 'arraybuffer' && request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MEDIA_SEGMENT_TYPE) {
      loader = (0,_FetchLoader__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
        requestModifier: requestModifier,
        lowLatencyThroughputModel: lowLatencyThroughputModel,
        boxParser: boxParser
      });
      loader.setup({
        dashMetrics: dashMetrics
      });
      fileLoaderType = _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].FILE_LOADER_TYPES.FETCH;
    } else {
      loader = (0,_XHRLoader__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
        requestModifier: requestModifier
      });
      fileLoaderType = _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].FILE_LOADER_TYPES.XHR;
    }

    var headers = null;
    var modifiedUrl = requestModifier.modifyRequestURL ? requestModifier.modifyRequestURL(request.url) : request.url;

    if (settings.get().streaming.cmcd && settings.get().streaming.cmcd.enabled) {
      var cmcdMode = settings.get().streaming.cmcd.mode;

      if (cmcdMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].CMCD_MODE_QUERY) {
        var additionalQueryParameter = _getAdditionalQueryParameter(request);

        modifiedUrl = _core_Utils__WEBPACK_IMPORTED_MODULE_7__["default"].addAditionalQueryParameterToUrl(modifiedUrl, additionalQueryParameter);
      } else if (cmcdMode === _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["default"].CMCD_MODE_HEADER) {
        headers = cmcdModel.getHeaderParameters(request);
      }
    }

    request.url = modifiedUrl;
    var verb = request.checkExistenceOnly ? _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.HEAD : _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.GET;
    var withCredentials = customParametersModel.getXHRWithCredentialsForType(request.type);
    httpRequest = {
      url: modifiedUrl,
      method: verb,
      withCredentials: withCredentials,
      request: request,
      onload: onload,
      onend: onloadend,
      onerror: onloadend,
      progress: progress,
      onabort: onabort,
      ontimeout: ontimeout,
      loader: loader,
      timeout: requestTimeout,
      headers: headers
    }; // Adds the ability to delay single fragment loading time to control buffer.

    var now = new Date().getTime();

    if (isNaN(request.delayLoadingTime) || now >= request.delayLoadingTime) {
      // no delay - just send
      requests.push(httpRequest);
      loader.load(httpRequest);
    } else {
      // delay
      var delayedRequest = {
        httpRequest: httpRequest
      };
      delayedRequests.push(delayedRequest);
      delayedRequest.delayTimeout = setTimeout(function () {
        if (delayedRequests.indexOf(delayedRequest) === -1) {
          return;
        } else {
          delayedRequests.splice(delayedRequests.indexOf(delayedRequest), 1);
        }

        try {
          requestStartTime = new Date();
          lastTraceTime = requestStartTime;
          requests.push(delayedRequest.httpRequest);
          loader.load(delayedRequest.httpRequest);
        } catch (e) {
          delayedRequest.httpRequest.onerror();
        }
      }, request.delayLoadingTime - now);
    }
  }

  function _getAdditionalQueryParameter(request) {
    try {
      var additionalQueryParameter = [];
      var cmcdQueryParameter = cmcdModel.getQueryParameter(request);

      if (cmcdQueryParameter) {
        additionalQueryParameter.push(cmcdQueryParameter);
      }

      return additionalQueryParameter;
    } catch (e) {
      return [];
    }
  }
  /**
   * Initiates a download of the resource described by config.request
   * @param {Object} config - contains request (FragmentRequest or derived type), and callbacks
   * @memberof module:HTTPLoader
   * @instance
   */


  function load(config) {
    if (config.request) {
      internalLoad(config, mediaPlayerModel.getRetryAttemptsForType(config.request.type));
    } else {
      if (config.error) {
        config.error(config.request, 'error');
      }
    }
  }
  /**
   * Aborts any inflight downloads
   * @memberof module:HTTPLoader
   * @instance
   */


  function abort() {
    retryRequests.forEach(function (t) {
      clearTimeout(t.timeout); // abort request in order to trigger LOADING_ABANDONED event

      if (t.config.request && t.config.abort) {
        t.config.abort(t.config.request);
      }
    });
    retryRequests = [];
    delayedRequests.forEach(function (x) {
      return clearTimeout(x.delayTimeout);
    });
    delayedRequests = [];
    requests.forEach(function (x) {
      // MSS patch: ignore FragmentInfo requests
      if (x.request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE) {
        return;
      } // abort will trigger onloadend which we don't want
      // when deliberately aborting inflight requests -
      // set them to undefined so they are not called


      x.onloadend = x.onerror = x.onprogress = undefined;
      x.loader.abort(x);
    });
    requests = [];
  }

  instance = {
    load: load,
    abort: abort
  };
  setup();
  return instance;
}

HTTPLoader.__dashjs_factory_name = 'HTTPLoader';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__["default"].getClassFactory(HTTPLoader);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/net/SchemeLoaderFactory.js":
/*!**************************************************!*\
  !*** ./src/streaming/net/SchemeLoaderFactory.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_net_HTTPLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/net/HTTPLoader */ "./src/streaming/net/HTTPLoader.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @module
 * @description Choose right url loader for scheme
 * @ignore
 */

function SchemeLoaderFactory() {
  var instance;
  var schemeLoaderMap;

  function registerLoader(scheme, loader) {
    schemeLoaderMap[scheme] = loader;
  }

  function unregisterLoader(scheme) {
    if (schemeLoaderMap[scheme]) {
      delete schemeLoaderMap[scheme];
    }
  }

  function unregisterAllLoader() {
    schemeLoaderMap = {};
  }

  function getLoader(url) {
    // iterates through schemeLoaderMap to find a loader for the scheme
    for (var scheme in schemeLoaderMap) {
      if (schemeLoaderMap.hasOwnProperty(scheme) && url.startsWith(scheme)) {
        return schemeLoaderMap[scheme];
      }
    }

    return _streaming_net_HTTPLoader__WEBPACK_IMPORTED_MODULE_1__["default"];
  }

  function reset() {
    unregisterAllLoader();
  }

  function setup() {
    reset();
  }

  setup();
  instance = {
    getLoader: getLoader,
    registerLoader: registerLoader,
    unregisterLoader: unregisterLoader,
    unregisterAllLoader: unregisterAllLoader,
    reset: reset
  };
  return instance;
}

SchemeLoaderFactory.__dashjs_factory_name = 'SchemeLoaderFactory';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(SchemeLoaderFactory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/net/URLLoader.js":
/*!****************************************!*\
  !*** ./src/streaming/net/URLLoader.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_net_SchemeLoaderFactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/net/SchemeLoaderFactory */ "./src/streaming/net/SchemeLoaderFactory.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @class URLLoader
 * @description  Call Offline Loader or Online Loader depending on URL
 * @param {Object} cfg - dependencies
 * @ignore
*/

function URLLoader(cfg) {
  cfg = cfg || {};
  var context = this.context;
  var instance, schemeLoaderFactory, loader;
  schemeLoaderFactory = (0,_streaming_net_SchemeLoaderFactory__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance();

  function load(config) {
    if (!loader) {
      var loaderFactory = schemeLoaderFactory.getLoader(config && config.request ? config.request.url : null);
      loader = loaderFactory(context).create({
        errHandler: cfg.errHandler,
        mediaPlayerModel: cfg.mediaPlayerModel,
        requestModifier: cfg.requestModifier,
        dashMetrics: cfg.dashMetrics,
        boxParser: cfg.boxParser ? cfg.boxParser : null,
        constants: cfg.constants ? cfg.constants : null,
        dashConstants: cfg.dashConstants ? cfg.dashConstants : null,
        urlUtils: cfg.urlUtils ? cfg.urlUtils : null,
        requestTimeout: !isNaN(cfg.requestTimeout) ? cfg.requestTimeout : 0,
        errors: cfg.errors
      });
    }

    loader.load(config);
  }

  function abort() {
    if (loader) {
      loader.abort();
    }
  }

  instance = {
    load: load,
    abort: abort
  };
  return instance;
}

URLLoader.__dashjs_factory_name = 'URLLoader';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(URLLoader);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/net/XHRLoader.js":
/*!****************************************!*\
  !*** ./src/streaming/net/XHRLoader.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _utils_RequestModifier__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/RequestModifier */ "./src/streaming/utils/RequestModifier.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @module XHRLoader
 * @ignore
 * @description Manages download of resources via HTTP.
 * @param {Object} cfg - dependencies from parent
 */

function XHRLoader(cfg) {
  cfg = cfg || {};
  var requestModifier = cfg.requestModifier;
  var instance;

  function load(httpRequest) {
    if (requestModifier && requestModifier.modifyRequest) {
      (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_1__.modifyRequest)(httpRequest, requestModifier).then(function () {
        return request(httpRequest);
      });
    } else {
      request(httpRequest);
    }
  }

  function request(httpRequest) {
    // Variables will be used in the callback functions
    var requestStartTime = new Date();
    var request = httpRequest.request;
    var xhr = new XMLHttpRequest();
    xhr.open(httpRequest.method, httpRequest.url, true);

    if (request.responseType) {
      xhr.responseType = request.responseType;
    }

    if (request.range) {
      xhr.setRequestHeader('Range', 'bytes=' + request.range);
    }

    if (!request.requestStartDate) {
      request.requestStartDate = requestStartTime;
    }

    if (requestModifier && requestModifier.modifyRequestHeader) {
      xhr = requestModifier.modifyRequestHeader(xhr, {
        url: httpRequest.url
      });
    }

    if (httpRequest.headers) {
      for (var header in httpRequest.headers) {
        var value = httpRequest.headers[header];

        if (value) {
          xhr.setRequestHeader(header, value);
        }
      }
    }

    xhr.withCredentials = httpRequest.withCredentials;
    xhr.onload = httpRequest.onload;
    xhr.onloadend = httpRequest.onend;
    xhr.onerror = httpRequest.onerror;
    xhr.onprogress = httpRequest.progress;
    xhr.onabort = httpRequest.onabort;
    xhr.ontimeout = httpRequest.ontimeout;
    xhr.timeout = httpRequest.timeout;
    xhr.send();
    httpRequest.response = xhr;
  }

  function abort(request) {
    var x = request.response;
    x.onloadend = x.onerror = x.onprogress = undefined; //Ignore events from aborted requests.

    x.abort();
  }

  instance = {
    load: load,
    abort: abort
  };
  return instance;
}

XHRLoader.__dashjs_factory_name = 'XHRLoader';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(XHRLoader);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/rules/SwitchRequest.js":
/*!**********************************************!*\
  !*** ./src/streaming/rules/SwitchRequest.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

var NO_CHANGE = -1;
var PRIORITY = {
  DEFAULT: 0.5,
  STRONG: 1,
  WEAK: 0
};

function SwitchRequest(q, r, p) {
  //TODO refactor all the calls to this to use config to be like everything else.
  var instance, quality, priority, reason; // check priority value

  function getPriority(p) {
    var ret = PRIORITY.DEFAULT; // check that p is one of declared priority value

    if (p === PRIORITY.DEFAULT || p === PRIORITY.STRONG || p === PRIORITY.WEAK) {
      ret = p;
    }

    return ret;
  } // init attributes


  quality = q === undefined ? NO_CHANGE : q;
  priority = getPriority(p);
  reason = r === undefined ? null : r;
  instance = {
    quality: quality,
    reason: reason,
    priority: priority
  };
  return instance;
}

SwitchRequest.__dashjs_factory_name = 'SwitchRequest';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SwitchRequest);
factory.NO_CHANGE = NO_CHANGE;
factory.PRIORITY = PRIORITY;
_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].updateClassFactory(SwitchRequest.__dashjs_factory_name, factory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/rules/abr/ABRRulesCollection.js":
/*!*******************************************************!*\
  !*** ./src/streaming/rules/abr/ABRRulesCollection.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ThroughputRule__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ThroughputRule */ "./src/streaming/rules/abr/ThroughputRule.js");
/* harmony import */ var _InsufficientBufferRule__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InsufficientBufferRule */ "./src/streaming/rules/abr/InsufficientBufferRule.js");
/* harmony import */ var _AbandonRequestsRule__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AbandonRequestsRule */ "./src/streaming/rules/abr/AbandonRequestsRule.js");
/* harmony import */ var _DroppedFramesRule__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DroppedFramesRule */ "./src/streaming/rules/abr/DroppedFramesRule.js");
/* harmony import */ var _SwitchHistoryRule__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SwitchHistoryRule */ "./src/streaming/rules/abr/SwitchHistoryRule.js");
/* harmony import */ var _BolaRule__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./BolaRule */ "./src/streaming/rules/abr/BolaRule.js");
/* harmony import */ var _L2ARule_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./L2ARule.js */ "./src/streaming/rules/abr/L2ARule.js");
/* harmony import */ var _lolp_LoLpRule_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./lolp/LoLpRule.js */ "./src/streaming/rules/abr/lolp/LoLpRule.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */











var QUALITY_SWITCH_RULES = 'qualitySwitchRules';
var ABANDON_FRAGMENT_RULES = 'abandonFragmentRules';

function ABRRulesCollection(config) {
  config = config || {};
  var context = this.context;
  var mediaPlayerModel = config.mediaPlayerModel;
  var customParametersModel = config.customParametersModel;
  var dashMetrics = config.dashMetrics;
  var settings = config.settings;
  var instance, qualitySwitchRules, abandonFragmentRules;

  function initialize() {
    qualitySwitchRules = [];
    abandonFragmentRules = [];

    if (settings.get().streaming.abr.useDefaultABRRules) {
      // If L2A is used we only need this one rule
      if (settings.get().streaming.abr.ABRStrategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_10__["default"].ABR_STRATEGY_L2A) {
        qualitySwitchRules.push((0,_L2ARule_js__WEBPACK_IMPORTED_MODULE_6__["default"])(context).create({
          dashMetrics: dashMetrics,
          settings: settings
        }));
      } // If LoLP is used we only need this one rule
      else if (settings.get().streaming.abr.ABRStrategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_10__["default"].ABR_STRATEGY_LoLP) {
        qualitySwitchRules.push((0,_lolp_LoLpRule_js__WEBPACK_IMPORTED_MODULE_7__["default"])(context).create({
          dashMetrics: dashMetrics
        }));
      } else {
        // Only one of BolaRule and ThroughputRule will give a switchRequest.quality !== SwitchRequest.NO_CHANGE.
        // This is controlled by useBufferOccupancyABR mechanism in AbrController.
        qualitySwitchRules.push((0,_BolaRule__WEBPACK_IMPORTED_MODULE_5__["default"])(context).create({
          dashMetrics: dashMetrics,
          mediaPlayerModel: mediaPlayerModel,
          settings: settings
        }));
        qualitySwitchRules.push((0,_ThroughputRule__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
          dashMetrics: dashMetrics
        }));

        if (settings.get().streaming.abr.additionalAbrRules.insufficientBufferRule) {
          qualitySwitchRules.push((0,_InsufficientBufferRule__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
            dashMetrics: dashMetrics,
            settings: settings
          }));
        }

        if (settings.get().streaming.abr.additionalAbrRules.switchHistoryRule) {
          qualitySwitchRules.push((0,_SwitchHistoryRule__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create());
        }

        if (settings.get().streaming.abr.additionalAbrRules.droppedFramesRule) {
          qualitySwitchRules.push((0,_DroppedFramesRule__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create());
        }

        if (settings.get().streaming.abr.additionalAbrRules.abandonRequestsRule) {
          abandonFragmentRules.push((0,_AbandonRequestsRule__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
            dashMetrics: dashMetrics,
            mediaPlayerModel: mediaPlayerModel,
            settings: settings
          }));
        }
      }
    } // add custom ABR rules if any


    var customRules = customParametersModel.getAbrCustomRules();
    customRules.forEach(function (rule) {
      if (rule.type === QUALITY_SWITCH_RULES) {
        qualitySwitchRules.push(rule.rule(context).create());
      }

      if (rule.type === ABANDON_FRAGMENT_RULES) {
        abandonFragmentRules.push(rule.rule(context).create());
      }
    });
  }

  function _getRulesWithChange(srArray) {
    return srArray.filter(function (sr) {
      return sr.quality > _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE;
    });
  }
  /**
   *
   * @param {array} srArray
   * @return {object} SwitchRequest
   */


  function getMinSwitchRequest(srArray) {
    var values = {};
    var newSwitchReq = null;
    var i, len, req, quality, reason;

    if (srArray.length === 0) {
      return;
    }

    values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.STRONG] = {
      quality: _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE,
      reason: null
    };
    values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.WEAK] = {
      quality: _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE,
      reason: null
    };
    values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.DEFAULT] = {
      quality: _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE,
      reason: null
    };

    for (i = 0, len = srArray.length; i < len; i += 1) {
      req = srArray[i];

      if (req.quality !== _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE) {
        // We only use the new quality in case it is lower than the already saved one or if no new quality has been selected for the respective priority
        if (values[req.priority].quality === _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE || values[req.priority].quality > req.quality) {
          values[req.priority].quality = req.quality;
          values[req.priority].reason = req.reason || null;
        }
      }
    }

    if (values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.WEAK].quality !== _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE) {
      newSwitchReq = values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.WEAK];
    }

    if (values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.DEFAULT].quality !== _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE) {
      newSwitchReq = values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.DEFAULT];
    }

    if (values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.STRONG].quality !== _SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].NO_CHANGE) {
      newSwitchReq = values[_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"].PRIORITY.STRONG];
    }

    if (newSwitchReq) {
      quality = newSwitchReq.quality;
      reason = newSwitchReq.reason;
    }

    return (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"])(context).create(quality, reason);
  }

  function getMaxQuality(rulesContext) {
    var switchRequestArray = qualitySwitchRules.map(function (rule) {
      return rule.getMaxIndex(rulesContext);
    });

    var activeRules = _getRulesWithChange(switchRequestArray);

    var maxQuality = getMinSwitchRequest(activeRules);
    return maxQuality || (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"])(context).create();
  }

  function shouldAbandonFragment(rulesContext, streamId) {
    var abandonRequestArray = abandonFragmentRules.map(function (rule) {
      return rule.shouldAbandon(rulesContext, streamId);
    });

    var activeRules = _getRulesWithChange(abandonRequestArray);

    var shouldAbandon = getMinSwitchRequest(activeRules);
    return shouldAbandon || (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__["default"])(context).create();
  }

  function reset() {
    [qualitySwitchRules, abandonFragmentRules].forEach(function (rules) {
      if (rules && rules.length) {
        rules.forEach(function (rule) {
          return rule.reset && rule.reset();
        });
      }
    });
    qualitySwitchRules = [];
    abandonFragmentRules = [];
  }

  function getQualitySwitchRules() {
    return qualitySwitchRules;
  }

  instance = {
    initialize: initialize,
    reset: reset,
    getMaxQuality: getMaxQuality,
    getMinSwitchRequest: getMinSwitchRequest,
    shouldAbandonFragment: shouldAbandonFragment,
    getQualitySwitchRules: getQualitySwitchRules
  };
  return instance;
}

ABRRulesCollection.__dashjs_factory_name = 'ABRRulesCollection';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_8__["default"].getClassFactory(ABRRulesCollection);
factory.QUALITY_SWITCH_RULES = QUALITY_SWITCH_RULES;
factory.ABANDON_FRAGMENT_RULES = ABANDON_FRAGMENT_RULES;
_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_8__["default"].updateSingletonFactory(ABRRulesCollection.__dashjs_factory_name, factory);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/rules/abr/AbandonRequestsRule.js":
/*!********************************************************!*\
  !*** ./src/streaming/rules/abr/AbandonRequestsRule.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function AbandonRequestsRule(config) {
  config = config || {};
  var ABANDON_MULTIPLIER = 1.8;
  var GRACE_TIME_THRESHOLD = 500;
  var MIN_LENGTH_TO_AVERAGE = 5;
  var context = this.context;
  var mediaPlayerModel = config.mediaPlayerModel;
  var dashMetrics = config.dashMetrics;
  var settings = config.settings;
  var instance, logger, fragmentDict, abandonDict, throughputArray;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"])(context).getInstance().getLogger(instance);
    reset();
  }

  function setFragmentRequestDict(type, id) {
    fragmentDict[type] = fragmentDict[type] || {};
    fragmentDict[type][id] = fragmentDict[type][id] || {};
  }

  function storeLastRequestThroughputByType(type, throughput) {
    throughputArray[type] = throughputArray[type] || [];
    throughputArray[type].push(throughput);
  }

  function shouldAbandon(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create(_SwitchRequest__WEBPACK_IMPORTED_MODULE_0__["default"].NO_CHANGE, {
      name: AbandonRequestsRule.__dashjs_factory_name
    });

    if (!rulesContext || !rulesContext.hasOwnProperty('getMediaInfo') || !rulesContext.hasOwnProperty('getMediaType') || !rulesContext.hasOwnProperty('getCurrentRequest') || !rulesContext.hasOwnProperty('getRepresentationInfo') || !rulesContext.hasOwnProperty('getAbrController')) {
      return switchRequest;
    }

    var mediaInfo = rulesContext.getMediaInfo();
    var mediaType = rulesContext.getMediaType();
    var streamInfo = rulesContext.getStreamInfo();
    var streamId = streamInfo ? streamInfo.id : null;
    var req = rulesContext.getCurrentRequest();

    if (!isNaN(req.index)) {
      setFragmentRequestDict(mediaType, req.index);
      var stableBufferTime = mediaPlayerModel.getStableBufferTime();
      var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);

      if (bufferLevel > stableBufferTime) {
        return switchRequest;
      }

      var fragmentInfo = fragmentDict[mediaType][req.index];

      if (fragmentInfo === null || req.firstByteDate === null || abandonDict.hasOwnProperty(fragmentInfo.id)) {
        return switchRequest;
      } //setup some init info based on first progress event


      if (fragmentInfo.firstByteTime === undefined) {
        throughputArray[mediaType] = [];
        fragmentInfo.firstByteTime = req.firstByteDate.getTime();
        fragmentInfo.segmentDuration = req.duration;
        fragmentInfo.bytesTotal = req.bytesTotal;
        fragmentInfo.id = req.index;
      }

      fragmentInfo.bytesLoaded = req.bytesLoaded;
      fragmentInfo.elapsedTime = new Date().getTime() - fragmentInfo.firstByteTime;

      if (fragmentInfo.bytesLoaded > 0 && fragmentInfo.elapsedTime > 0) {
        storeLastRequestThroughputByType(mediaType, Math.round(fragmentInfo.bytesLoaded * 8 / fragmentInfo.elapsedTime));
      }

      if (throughputArray[mediaType].length >= MIN_LENGTH_TO_AVERAGE && fragmentInfo.elapsedTime > GRACE_TIME_THRESHOLD && fragmentInfo.bytesLoaded < fragmentInfo.bytesTotal) {
        var totalSampledValue = throughputArray[mediaType].reduce(function (a, b) {
          return a + b;
        }, 0);
        fragmentInfo.measuredBandwidthInKbps = Math.round(totalSampledValue / throughputArray[mediaType].length);
        fragmentInfo.estimatedTimeOfDownload = +(fragmentInfo.bytesTotal * 8 / fragmentInfo.measuredBandwidthInKbps / 1000).toFixed(2);

        if (fragmentInfo.estimatedTimeOfDownload < fragmentInfo.segmentDuration * ABANDON_MULTIPLIER || rulesContext.getRepresentationInfo().quality === 0) {
          return switchRequest;
        } else if (!abandonDict.hasOwnProperty(fragmentInfo.id)) {
          var abrController = rulesContext.getAbrController();
          var bytesRemaining = fragmentInfo.bytesTotal - fragmentInfo.bytesLoaded;
          var bitrateList = abrController.getBitrateList(mediaInfo);
          var quality = abrController.getQualityForBitrate(mediaInfo, fragmentInfo.measuredBandwidthInKbps * settings.get().streaming.abr.bandwidthSafetyFactor, streamId);
          var minQuality = abrController.getMinAllowedIndexFor(mediaType, streamId);
          var newQuality = minQuality !== undefined ? Math.max(minQuality, quality) : quality;
          var estimateOtherBytesTotal = fragmentInfo.bytesTotal * bitrateList[newQuality].bitrate / bitrateList[abrController.getQualityFor(mediaType, streamId)].bitrate;

          if (bytesRemaining > estimateOtherBytesTotal) {
            switchRequest.quality = newQuality;
            switchRequest.reason.throughput = fragmentInfo.measuredBandwidthInKbps;
            switchRequest.reason.fragmentID = fragmentInfo.id;
            abandonDict[fragmentInfo.id] = fragmentInfo;
            logger.debug('[' + mediaType + '] frag id', fragmentInfo.id, ' is asking to abandon and switch to quality to ', newQuality, ' measured bandwidth was', fragmentInfo.measuredBandwidthInKbps);
            delete fragmentDict[mediaType][fragmentInfo.id];
          }
        }
      } else if (fragmentInfo.bytesLoaded === fragmentInfo.bytesTotal) {
        delete fragmentDict[mediaType][fragmentInfo.id];
      }
    }

    return switchRequest;
  }

  function reset() {
    fragmentDict = {};
    abandonDict = {};
    throughputArray = [];
  }

  instance = {
    shouldAbandon: shouldAbandon,
    reset: reset
  };
  setup();
  return instance;
}

AbandonRequestsRule.__dashjs_factory_name = 'AbandonRequestsRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(AbandonRequestsRule));

/***/ }),

/***/ "./src/streaming/rules/abr/BolaRule.js":
/*!*********************************************!*\
  !*** ./src/streaming/rules/abr/BolaRule.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2016, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
// For a description of the BOLA adaptive bitrate (ABR) algorithm, see http://arxiv.org/abs/1601.06748








 // BOLA_STATE_ONE_BITRATE   : If there is only one bitrate (or initialization failed), always return NO_CHANGE.
// BOLA_STATE_STARTUP       : Set placeholder buffer such that we download fragments at most recently measured throughput.
// BOLA_STATE_STEADY        : Buffer primed, we switch to steady operation.
// TODO: add BOLA_STATE_SEEK and tune BOLA behavior on seeking

var BOLA_STATE_ONE_BITRATE = 0;
var BOLA_STATE_STARTUP = 1;
var BOLA_STATE_STEADY = 2;
var MINIMUM_BUFFER_S = 10; // BOLA should never add artificial delays if buffer is less than MINIMUM_BUFFER_S.

var MINIMUM_BUFFER_PER_BITRATE_LEVEL_S = 2; // E.g. if there are 5 bitrates, BOLA switches to top bitrate at buffer = 10 + 5 * 2 = 20s.
// If Schedule Controller does not allow buffer to reach that level, it can be achieved through the placeholder buffer level.

var PLACEHOLDER_BUFFER_DECAY = 0.99; // Make sure placeholder buffer does not stick around too long.

function BolaRule(config) {
  config = config || {};
  var context = this.context;
  var dashMetrics = config.dashMetrics;
  var mediaPlayerModel = config.mediaPlayerModel;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var instance, logger, bolaStateDict;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_6__["default"])(context).getInstance().getLogger(instance);
    resetInitialSettings();
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].BUFFER_EMPTY, onBufferEmpty, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].PLAYBACK_SEEKING, onPlaybackSeeking, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].METRIC_ADDED, onMetricAdded, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].QUALITY_CHANGE_REQUESTED, onQualityChangeRequested, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].FRAGMENT_LOADING_ABANDONED, onFragmentLoadingAbandoned, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].MEDIA_FRAGMENT_LOADED, onMediaFragmentLoaded, instance);
  }

  function utilitiesFromBitrates(bitrates) {
    return bitrates.map(function (b) {
      return Math.log(b);
    }); // no need to worry about offset, utilities will be offset (uniformly) anyway later
  } // NOTE: in live streaming, the real buffer level can drop below minimumBufferS, but bola should not stick to lowest bitrate by using a placeholder buffer level


  function calculateBolaParameters(stableBufferTime, bitrates, utilities) {
    var highestUtilityIndex = utilities.reduce(function (highestIndex, u, uIndex) {
      return u > utilities[highestIndex] ? uIndex : highestIndex;
    }, 0);

    if (highestUtilityIndex === 0) {
      // if highestUtilityIndex === 0, then always use lowest bitrate
      return null;
    }

    var bufferTime = Math.max(stableBufferTime, MINIMUM_BUFFER_S + MINIMUM_BUFFER_PER_BITRATE_LEVEL_S * bitrates.length); // TODO: Investigate if following can be better if utilities are not the default Math.log utilities.
    // If using Math.log utilities, we can choose Vp and gp to always prefer bitrates[0] at minimumBufferS and bitrates[max] at bufferTarget.
    // (Vp * (utility + gp) - bufferLevel) / bitrate has the maxima described when:
    // Vp * (utilities[0] + gp - 1) === minimumBufferS and Vp * (utilities[max] + gp - 1) === bufferTarget
    // giving:

    var gp = (utilities[highestUtilityIndex] - 1) / (bufferTime / MINIMUM_BUFFER_S - 1);
    var Vp = MINIMUM_BUFFER_S / gp; // note that expressions for gp and Vp assume utilities[0] === 1, which is true because of normalization

    return {
      gp: gp,
      Vp: Vp
    };
  }

  function getInitialBolaState(rulesContext) {
    var initialState = {};
    var mediaInfo = rulesContext.getMediaInfo();
    var bitrates = mediaInfo.bitrateList.map(function (b) {
      return b.bandwidth;
    });
    var utilities = utilitiesFromBitrates(bitrates);
    utilities = utilities.map(function (u) {
      return u - utilities[0] + 1;
    }); // normalize

    var stableBufferTime = mediaPlayerModel.getStableBufferTime();
    var params = calculateBolaParameters(stableBufferTime, bitrates, utilities);

    if (!params) {
      // only happens when there is only one bitrate level
      initialState.state = BOLA_STATE_ONE_BITRATE;
    } else {
      initialState.state = BOLA_STATE_STARTUP;
      initialState.bitrates = bitrates;
      initialState.utilities = utilities;
      initialState.stableBufferTime = stableBufferTime;
      initialState.Vp = params.Vp;
      initialState.gp = params.gp;
      initialState.lastQuality = 0;
      clearBolaStateOnSeek(initialState);
    }

    return initialState;
  }

  function clearBolaStateOnSeek(bolaState) {
    bolaState.placeholderBuffer = 0;
    bolaState.mostAdvancedSegmentStart = NaN;
    bolaState.lastSegmentWasReplacement = false;
    bolaState.lastSegmentStart = NaN;
    bolaState.lastSegmentDurationS = NaN;
    bolaState.lastSegmentRequestTimeMs = NaN;
    bolaState.lastSegmentFinishTimeMs = NaN;
  } // If the buffer target is changed (can this happen mid-stream?), then adjust BOLA parameters accordingly.


  function checkBolaStateStableBufferTime(bolaState, mediaType) {
    var stableBufferTime = mediaPlayerModel.getStableBufferTime();

    if (bolaState.stableBufferTime !== stableBufferTime) {
      var params = calculateBolaParameters(stableBufferTime, bolaState.bitrates, bolaState.utilities);

      if (params.Vp !== bolaState.Vp || params.gp !== bolaState.gp) {
        // correct placeholder buffer using two criteria:
        // 1. do not change effective buffer level at effectiveBufferLevel === MINIMUM_BUFFER_S ( === Vp * gp )
        // 2. scale placeholder buffer by Vp subject to offset indicated in 1.
        var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);
        var effectiveBufferLevel = bufferLevel + bolaState.placeholderBuffer;
        effectiveBufferLevel -= MINIMUM_BUFFER_S;
        effectiveBufferLevel *= params.Vp / bolaState.Vp;
        effectiveBufferLevel += MINIMUM_BUFFER_S;
        bolaState.stableBufferTime = stableBufferTime;
        bolaState.Vp = params.Vp;
        bolaState.gp = params.gp;
        bolaState.placeholderBuffer = Math.max(0, effectiveBufferLevel - bufferLevel);
      }
    }
  }

  function getBolaState(rulesContext) {
    var mediaType = rulesContext.getMediaType();
    var bolaState = bolaStateDict[mediaType];

    if (!bolaState) {
      bolaState = getInitialBolaState(rulesContext);
      bolaStateDict[mediaType] = bolaState;
    } else if (bolaState.state !== BOLA_STATE_ONE_BITRATE) {
      checkBolaStateStableBufferTime(bolaState, mediaType);
    }

    return bolaState;
  } // The core idea of BOLA.


  function getQualityFromBufferLevel(bolaState, bufferLevel) {
    var bitrateCount = bolaState.bitrates.length;
    var quality = NaN;
    var score = NaN;

    for (var i = 0; i < bitrateCount; ++i) {
      var s = (bolaState.Vp * (bolaState.utilities[i] + bolaState.gp) - bufferLevel) / bolaState.bitrates[i];

      if (isNaN(score) || s >= score) {
        score = s;
        quality = i;
      }
    }

    return quality;
  } // maximum buffer level which prefers to download at quality rather than wait


  function maxBufferLevelForQuality(bolaState, quality) {
    return bolaState.Vp * (bolaState.utilities[quality] + bolaState.gp);
  } // the minimum buffer level that would cause BOLA to choose quality rather than a lower bitrate


  function minBufferLevelForQuality(bolaState, quality) {
    var qBitrate = bolaState.bitrates[quality];
    var qUtility = bolaState.utilities[quality];
    var min = 0;

    for (var i = quality - 1; i >= 0; --i) {
      // for each bitrate less than bitrates[quality], BOLA should prefer quality (unless other bitrate has higher utility)
      if (bolaState.utilities[i] < bolaState.utilities[quality]) {
        var iBitrate = bolaState.bitrates[i];
        var iUtility = bolaState.utilities[i];
        var level = bolaState.Vp * (bolaState.gp + (qBitrate * iUtility - iBitrate * qUtility) / (qBitrate - iBitrate));
        min = Math.max(min, level); // we want min to be small but at least level(i) for all i
      }
    }

    return min;
  }
  /*
   * The placeholder buffer increases the effective buffer that is used to calculate the bitrate.
   * There are two main reasons we might want to increase the placeholder buffer:
   *
   * 1. When a segment finishes downloading, we would expect to get a call on getMaxIndex() regarding the quality for
   *    the next segment. However, there might be a delay before the next call. E.g. when streaming live content, the
   *    next segment might not be available yet. If the call to getMaxIndex() does happens after a delay, we don't
   *    want the delay to change the BOLA decision - we only want to factor download time to decide on bitrate level.
   *
   * 2. It is possible to get a call to getMaxIndex() without having a segment download. The buffer target in dash.js
   *    is different for top-quality segments and lower-quality segments. If getMaxIndex() returns a lower-than-top
   *    quality, then the buffer controller might decide not to download a segment. When dash.js is ready for the next
   *    segment, getMaxIndex() will be called again. We don't want this extra delay to factor in the bitrate decision.
   */


  function updatePlaceholderBuffer(bolaState, mediaType) {
    var nowMs = Date.now();

    if (!isNaN(bolaState.lastSegmentFinishTimeMs)) {
      // compensate for non-bandwidth-derived delays, e.g., live streaming availability, buffer controller
      var delay = 0.001 * (nowMs - bolaState.lastSegmentFinishTimeMs);
      bolaState.placeholderBuffer += Math.max(0, delay);
    } else if (!isNaN(bolaState.lastCallTimeMs)) {
      // no download after last call, compensate for delay between calls
      var _delay = 0.001 * (nowMs - bolaState.lastCallTimeMs);

      bolaState.placeholderBuffer += Math.max(0, _delay);
    }

    bolaState.lastCallTimeMs = nowMs;
    bolaState.lastSegmentStart = NaN;
    bolaState.lastSegmentRequestTimeMs = NaN;
    bolaState.lastSegmentFinishTimeMs = NaN;
    checkBolaStateStableBufferTime(bolaState, mediaType);
  }

  function onBufferEmpty(e) {
    // if we rebuffer, we don't want the placeholder buffer to artificially raise BOLA quality
    var mediaType = e.mediaType; // if audio buffer runs empty (due to track switch for example) then reset placeholder buffer only for audio (to avoid decrease video BOLA quality)

    var stateDict = mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_8__["default"].AUDIO ? [_constants_Constants__WEBPACK_IMPORTED_MODULE_8__["default"].AUDIO] : bolaStateDict;

    for (var _mediaType in stateDict) {
      if (bolaStateDict.hasOwnProperty(_mediaType) && bolaStateDict[_mediaType].state === BOLA_STATE_STEADY) {
        bolaStateDict[_mediaType].placeholderBuffer = 0;
      }
    }
  }

  function onPlaybackSeeking() {
    // TODO: 1. Verify what happens if we seek mid-fragment.
    // TODO: 2. If e.g. we have 10s fragments and seek, we might want to download the first fragment at a lower quality to restart playback quickly.
    for (var mediaType in bolaStateDict) {
      if (bolaStateDict.hasOwnProperty(mediaType)) {
        var bolaState = bolaStateDict[mediaType];

        if (bolaState.state !== BOLA_STATE_ONE_BITRATE) {
          bolaState.state = BOLA_STATE_STARTUP; // TODO: BOLA_STATE_SEEK?

          clearBolaStateOnSeek(bolaState);
        }
      }
    }
  }

  function onMediaFragmentLoaded(e) {
    if (e && e.chunk && e.chunk.mediaInfo) {
      var bolaState = bolaStateDict[e.chunk.mediaInfo.type];

      if (bolaState && bolaState.state !== BOLA_STATE_ONE_BITRATE) {
        var start = e.chunk.start;

        if (isNaN(bolaState.mostAdvancedSegmentStart) || start > bolaState.mostAdvancedSegmentStart) {
          bolaState.mostAdvancedSegmentStart = start;
          bolaState.lastSegmentWasReplacement = false;
        } else {
          bolaState.lastSegmentWasReplacement = true;
        }

        bolaState.lastSegmentStart = start;
        bolaState.lastSegmentDurationS = e.chunk.duration;
        bolaState.lastQuality = e.chunk.quality;
        checkNewSegment(bolaState, e.chunk.mediaInfo.type);
      }
    }
  }

  function onMetricAdded(e) {
    if (e && e.metric === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_0__["default"].HTTP_REQUEST && e.value && e.value.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_3__.HTTPRequest.MEDIA_SEGMENT_TYPE && e.value.trace && e.value.trace.length) {
      var bolaState = bolaStateDict[e.mediaType];

      if (bolaState && bolaState.state !== BOLA_STATE_ONE_BITRATE) {
        bolaState.lastSegmentRequestTimeMs = e.value.trequest.getTime();
        bolaState.lastSegmentFinishTimeMs = e.value._tfinish.getTime();
        checkNewSegment(bolaState, e.mediaType);
      }
    }
  }
  /*
   * When a new segment is downloaded, we get two notifications: onMediaFragmentLoaded() and onMetricAdded(). It is
   * possible that the quality for the downloaded segment was lower (not higher) than the quality indicated by BOLA.
   * This might happen because of other rules such as the DroppedFramesRule. When this happens, we trim the
   * placeholder buffer to make BOLA more stable. This mechanism also avoids inflating the buffer when BOLA itself
   * decides not to increase the quality to avoid oscillations.
   *
   * We should also check for replacement segments (fast switching). In this case, a segment is downloaded but does
   * not grow the actual buffer. Fast switching might cause the buffer to deplete, causing BOLA to drop the bitrate.
   * We avoid this by growing the placeholder buffer.
   */


  function checkNewSegment(bolaState, mediaType) {
    if (!isNaN(bolaState.lastSegmentStart) && !isNaN(bolaState.lastSegmentRequestTimeMs) && !isNaN(bolaState.placeholderBuffer)) {
      bolaState.placeholderBuffer *= PLACEHOLDER_BUFFER_DECAY; // Find what maximum buffer corresponding to last segment was, and ensure placeholder is not relatively larger.

      if (!isNaN(bolaState.lastSegmentFinishTimeMs)) {
        var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);
        var bufferAtLastSegmentRequest = bufferLevel + 0.001 * (bolaState.lastSegmentFinishTimeMs - bolaState.lastSegmentRequestTimeMs); // estimate

        var maxEffectiveBufferForLastSegment = maxBufferLevelForQuality(bolaState, bolaState.lastQuality);
        var maxPlaceholderBuffer = Math.max(0, maxEffectiveBufferForLastSegment - bufferAtLastSegmentRequest);
        bolaState.placeholderBuffer = Math.min(maxPlaceholderBuffer, bolaState.placeholderBuffer);
      } // then see if we should grow placeholder buffer


      if (bolaState.lastSegmentWasReplacement && !isNaN(bolaState.lastSegmentDurationS)) {
        // compensate for segments that were downloaded but did not grow the buffer
        bolaState.placeholderBuffer += bolaState.lastSegmentDurationS;
      }

      bolaState.lastSegmentStart = NaN;
      bolaState.lastSegmentRequestTimeMs = NaN;
    }
  }

  function onQualityChangeRequested(e) {
    // Useful to store change requests when abandoning a download.
    if (e) {
      var bolaState = bolaStateDict[e.mediaType];

      if (bolaState && bolaState.state !== BOLA_STATE_ONE_BITRATE) {
        bolaState.abrQuality = e.newQuality;
      }
    }
  }

  function onFragmentLoadingAbandoned(e) {
    if (e) {
      var bolaState = bolaStateDict[e.mediaType];

      if (bolaState && bolaState.state !== BOLA_STATE_ONE_BITRATE) {
        // deflate placeholderBuffer - note that we want to be conservative when abandoning
        var bufferLevel = dashMetrics.getCurrentBufferLevel(e.mediaType);
        var wantEffectiveBufferLevel;

        if (bolaState.abrQuality > 0) {
          // deflate to point where BOLA just chooses newQuality over newQuality-1
          wantEffectiveBufferLevel = minBufferLevelForQuality(bolaState, bolaState.abrQuality);
        } else {
          wantEffectiveBufferLevel = MINIMUM_BUFFER_S;
        }

        var maxPlaceholderBuffer = Math.max(0, wantEffectiveBufferLevel - bufferLevel);
        bolaState.placeholderBuffer = Math.min(bolaState.placeholderBuffer, maxPlaceholderBuffer);
      }
    }
  }

  function getMaxIndex(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create();

    if (!rulesContext || !rulesContext.hasOwnProperty('getMediaInfo') || !rulesContext.hasOwnProperty('getMediaType') || !rulesContext.hasOwnProperty('getScheduleController') || !rulesContext.hasOwnProperty('getStreamInfo') || !rulesContext.hasOwnProperty('getAbrController') || !rulesContext.hasOwnProperty('useBufferOccupancyABR')) {
      return switchRequest;
    }

    var mediaInfo = rulesContext.getMediaInfo();
    var mediaType = rulesContext.getMediaType();
    var scheduleController = rulesContext.getScheduleController();
    var streamInfo = rulesContext.getStreamInfo();
    var abrController = rulesContext.getAbrController();
    var throughputHistory = abrController.getThroughputHistory();
    var streamId = streamInfo ? streamInfo.id : null;
    var isDynamic = streamInfo && streamInfo.manifestInfo && streamInfo.manifestInfo.isDynamic;
    var useBufferOccupancyABR = rulesContext.useBufferOccupancyABR();
    switchRequest.reason = switchRequest.reason || {};

    if (!useBufferOccupancyABR) {
      return switchRequest;
    }

    scheduleController.setTimeToLoadDelay(0);
    var bolaState = getBolaState(rulesContext);

    if (bolaState.state === BOLA_STATE_ONE_BITRATE) {
      // shouldn't even have been called
      return switchRequest;
    }

    var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);
    var throughput = throughputHistory.getAverageThroughput(mediaType, isDynamic);
    var safeThroughput = throughputHistory.getSafeAverageThroughput(mediaType, isDynamic);
    var latency = throughputHistory.getAverageLatency(mediaType);
    var quality;
    switchRequest.reason.state = bolaState.state;
    switchRequest.reason.throughput = throughput;
    switchRequest.reason.latency = latency;

    if (isNaN(throughput)) {
      // isNaN(throughput) === isNaN(safeThroughput) === isNaN(latency)
      // still starting up - not enough information
      return switchRequest;
    }

    switch (bolaState.state) {
      case BOLA_STATE_STARTUP:
        quality = abrController.getQualityForBitrate(mediaInfo, safeThroughput, streamId, latency);
        switchRequest.quality = quality;
        switchRequest.reason.throughput = safeThroughput;
        bolaState.placeholderBuffer = Math.max(0, minBufferLevelForQuality(bolaState, quality) - bufferLevel);
        bolaState.lastQuality = quality;

        if (!isNaN(bolaState.lastSegmentDurationS) && bufferLevel >= bolaState.lastSegmentDurationS) {
          bolaState.state = BOLA_STATE_STEADY;
        }

        break;
      // BOLA_STATE_STARTUP

      case BOLA_STATE_STEADY:
        // NB: The placeholder buffer is added to bufferLevel to come up with a bitrate.
        //     This might lead BOLA to be too optimistic and to choose a bitrate that would lead to rebuffering -
        //     if the real buffer bufferLevel runs out, the placeholder buffer cannot prevent rebuffering.
        //     However, the InsufficientBufferRule takes care of this scenario.
        updatePlaceholderBuffer(bolaState, mediaType);
        quality = getQualityFromBufferLevel(bolaState, bufferLevel + bolaState.placeholderBuffer); // we want to avoid oscillations
        // We implement the "BOLA-O" variant: when network bandwidth lies between two encoded bitrate levels, stick to the lowest level.

        var qualityForThroughput = abrController.getQualityForBitrate(mediaInfo, safeThroughput, streamId, latency);

        if (quality > bolaState.lastQuality && quality > qualityForThroughput) {
          // only intervene if we are trying to *increase* quality to an *unsustainable* level
          // we are only avoid oscillations - do not drop below last quality
          quality = Math.max(qualityForThroughput, bolaState.lastQuality);
        } // We do not want to overfill buffer with low quality chunks.
        // Note that there will be no delay if buffer level is below MINIMUM_BUFFER_S, probably even with some margin higher than MINIMUM_BUFFER_S.


        var delayS = Math.max(0, bufferLevel + bolaState.placeholderBuffer - maxBufferLevelForQuality(bolaState, quality)); // First reduce placeholder buffer, then tell schedule controller to pause.

        if (delayS <= bolaState.placeholderBuffer) {
          bolaState.placeholderBuffer -= delayS;
          delayS = 0;
        } else {
          delayS -= bolaState.placeholderBuffer;
          bolaState.placeholderBuffer = 0;

          if (quality < abrController.getMaxAllowedIndexFor(mediaType, streamId)) {
            // At top quality, allow schedule controller to decide how far to fill buffer.
            scheduleController.setTimeToLoadDelay(1000 * delayS);
          } else {
            delayS = 0;
          }
        }

        switchRequest.quality = quality;
        switchRequest.reason.throughput = throughput;
        switchRequest.reason.latency = latency;
        switchRequest.reason.bufferLevel = bufferLevel;
        switchRequest.reason.placeholderBuffer = bolaState.placeholderBuffer;
        switchRequest.reason.delay = delayS;
        bolaState.lastQuality = quality; // keep bolaState.state === BOLA_STATE_STEADY

        break;
      // BOLA_STATE_STEADY

      default:
        logger.debug('BOLA ABR rule invoked in bad state.'); // should not arrive here, try to recover

        switchRequest.quality = abrController.getQualityForBitrate(mediaInfo, safeThroughput, streamId, latency);
        switchRequest.reason.state = bolaState.state;
        switchRequest.reason.throughput = safeThroughput;
        switchRequest.reason.latency = latency;
        bolaState.state = BOLA_STATE_STARTUP;
        clearBolaStateOnSeek(bolaState);
    }

    return switchRequest;
  }

  function resetInitialSettings() {
    bolaStateDict = {};
  }

  function reset() {
    resetInitialSettings();
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].BUFFER_EMPTY, onBufferEmpty, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].PLAYBACK_SEEKING, onPlaybackSeeking, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].METRIC_ADDED, onMetricAdded, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].QUALITY_CHANGE_REQUESTED, onQualityChangeRequested, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].FRAGMENT_LOADING_ABANDONED, onFragmentLoadingAbandoned, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].MEDIA_FRAGMENT_LOADED, onMediaFragmentLoaded, instance);
  }

  instance = {
    getMaxIndex: getMaxIndex,
    reset: reset
  };
  setup();
  return instance;
}

BolaRule.__dashjs_factory_name = 'BolaRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(BolaRule));

/***/ }),

/***/ "./src/streaming/rules/abr/DroppedFramesRule.js":
/*!******************************************************!*\
  !*** ./src/streaming/rules/abr/DroppedFramesRule.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");




function DroppedFramesRule() {
  var context = this.context;
  var instance, logger;
  var DROPPED_PERCENTAGE_FORBID = 0.15;
  var GOOD_SAMPLE_SIZE = 375; //Don't apply the rule until this many frames have been rendered(and counted under those indices).

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"])(context).getInstance().getLogger(instance);
  }

  function getMaxIndex(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create();

    if (!rulesContext || !rulesContext.hasOwnProperty('getDroppedFramesHistory')) {
      return switchRequest;
    }

    var droppedFramesHistory = rulesContext.getDroppedFramesHistory();
    var streamId = rulesContext.getStreamInfo().id;

    if (droppedFramesHistory) {
      var dfh = droppedFramesHistory.getFrameHistory(streamId);

      if (!dfh || dfh.length === 0) {
        return switchRequest;
      }

      var droppedFrames = 0;
      var totalFrames = 0;
      var maxIndex = _SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"].NO_CHANGE; //No point in measuring dropped frames for the zeroeth index.

      for (var i = 1; i < dfh.length; i++) {
        if (dfh[i]) {
          droppedFrames = dfh[i].droppedVideoFrames;
          totalFrames = dfh[i].totalVideoFrames;

          if (totalFrames > GOOD_SAMPLE_SIZE && droppedFrames / totalFrames > DROPPED_PERCENTAGE_FORBID) {
            maxIndex = i - 1;
            logger.debug('index: ' + maxIndex + ' Dropped Frames: ' + droppedFrames + ' Total Frames: ' + totalFrames);
            break;
          }
        }
      }

      return (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create(maxIndex, {
        droppedFrames: droppedFrames
      });
    }

    return switchRequest;
  }

  instance = {
    getMaxIndex: getMaxIndex
  };
  setup();
  return instance;
}

DroppedFramesRule.__dashjs_factory_name = 'DroppedFramesRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(DroppedFramesRule));

/***/ }),

/***/ "./src/streaming/rules/abr/InsufficientBufferRule.js":
/*!***********************************************************!*\
  !*** ./src/streaming/rules/abr/InsufficientBufferRule.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */









function InsufficientBufferRule(config) {
  config = config || {};
  var INSUFFICIENT_BUFFER_SAFETY_FACTOR = 0.5;
  var SEGMENT_IGNORE_COUNT = 2;
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var dashMetrics = config.dashMetrics;
  var instance, logger, bufferStateDict;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_3__["default"])(context).getInstance().getLogger(instance);
    resetInitialSettings();
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].PLAYBACK_SEEKING, _onPlaybackSeeking, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].BYTES_APPENDED_END_FRAGMENT, _onBytesAppended, instance);
  }

  function checkConfig() {
    if (!dashMetrics || !dashMetrics.hasOwnProperty('getCurrentBufferLevel') || !dashMetrics.hasOwnProperty('getCurrentBufferState')) {
      throw new Error(_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].MISSING_CONFIG_ERROR);
    }
  }
  /**
   * If a BUFFER_EMPTY event happens, then InsufficientBufferRule returns switchRequest.quality=0 until BUFFER_LOADED happens.
   * Otherwise InsufficientBufferRule gives a maximum bitrate depending on throughput and bufferLevel such that
   * a whole fragment can be downloaded before the buffer runs out, subject to a conservative safety factor of 0.5.
   * If the bufferLevel is low, then InsufficientBufferRule avoids rebuffering risk.
   * If the bufferLevel is high, then InsufficientBufferRule give a high MaxIndex allowing other rules to take over.
   * @param rulesContext
   * @return {object}
   */


  function getMaxIndex(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create();

    if (!rulesContext || !rulesContext.hasOwnProperty('getMediaType')) {
      return switchRequest;
    }

    checkConfig();
    var mediaType = rulesContext.getMediaType();
    var currentBufferState = dashMetrics.getCurrentBufferState(mediaType);
    var representationInfo = rulesContext.getRepresentationInfo();
    var fragmentDuration = representationInfo.fragmentDuration;
    var streamInfo = rulesContext.getStreamInfo();
    var streamId = streamInfo ? streamInfo.id : null;
    var scheduleController = rulesContext.getScheduleController();
    var isDynamic = streamInfo && streamInfo.manifestInfo && streamInfo.manifestInfo.isDynamic;
    var playbackController = scheduleController.getPlaybackController(); // Don't ask for a bitrate change if there is not info about buffer state or if fragmentDuration is not defined

    var lowLatencyEnabled = playbackController.getLowLatencyModeEnabled();

    if (shouldIgnore(lowLatencyEnabled, mediaType) || !fragmentDuration) {
      return switchRequest;
    }

    if (currentBufferState && currentBufferState.state === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_6__["default"].BUFFER_EMPTY) {
      logger.debug('[' + mediaType + '] Switch to index 0; buffer is empty.');
      switchRequest.quality = 0;
      switchRequest.reason = 'InsufficientBufferRule: Buffer is empty';
    } else {
      var mediaInfo = rulesContext.getMediaInfo();
      var abrController = rulesContext.getAbrController();
      var throughputHistory = abrController.getThroughputHistory();
      var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType);
      var throughput = throughputHistory.getAverageThroughput(mediaType, isDynamic);
      var latency = throughputHistory.getAverageLatency(mediaType);
      var bitrate = throughput * (bufferLevel / fragmentDuration) * INSUFFICIENT_BUFFER_SAFETY_FACTOR;
      switchRequest.quality = abrController.getQualityForBitrate(mediaInfo, bitrate, streamId, latency);
      switchRequest.reason = 'InsufficientBufferRule: being conservative to avoid immediate rebuffering';
    }

    return switchRequest;
  }

  function shouldIgnore(lowLatencyEnabled, mediaType) {
    return !lowLatencyEnabled && bufferStateDict[mediaType].ignoreCount > 0;
  }

  function resetInitialSettings() {
    bufferStateDict = {};
    bufferStateDict[_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].VIDEO] = {
      ignoreCount: SEGMENT_IGNORE_COUNT
    };
    bufferStateDict[_constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].AUDIO] = {
      ignoreCount: SEGMENT_IGNORE_COUNT
    };
  }

  function _onPlaybackSeeking() {
    resetInitialSettings();
  }

  function _onBytesAppended(e) {
    if (!isNaN(e.startTime) && (e.mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].AUDIO || e.mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].VIDEO)) {
      if (bufferStateDict[e.mediaType].ignoreCount > 0) {
        bufferStateDict[e.mediaType].ignoreCount--;
      }
    }
  }

  function reset() {
    resetInitialSettings();
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].PLAYBACK_SEEKING, _onPlaybackSeeking, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].BYTES_APPENDED_END_FRAGMENT, _onBytesAppended, instance);
  }

  instance = {
    getMaxIndex: getMaxIndex,
    reset: reset
  };
  setup();
  return instance;
}

InsufficientBufferRule.__dashjs_factory_name = 'InsufficientBufferRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(InsufficientBufferRule));

/***/ }),

/***/ "./src/streaming/rules/abr/L2ARule.js":
/*!********************************************!*\
  !*** ./src/streaming/rules/abr/L2ARule.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2020, Unified Streaming.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
// For a description of the Learn2Adapt-LowLatency (L2A-LL) bitrate adaptation algorithm, see https://github.com/unifiedstreaming/Learn2Adapt-LowLatency/blob/master/Online_learning_for_bitrate_adaptation_in_low_latency_live_streaming_CR.pdf








var L2A_STATE_ONE_BITRATE = 0; // If there is only one bitrate (or initialization failed), always return NO_CHANGE.

var L2A_STATE_STARTUP = 1; // Set placeholder buffer such that we download fragments at most recently measured throughput.

var L2A_STATE_STEADY = 2; // Buffer primed, we switch to steady operation.

function L2ARule(config) {
  config = config || {};
  var context = this.context;
  var dashMetrics = config.dashMetrics;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var instance, l2AStateDict, l2AParameterDict, logger;
  /**
   * Setup function to initialize L2ARule
   */

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_6__["default"])(context).getInstance().getLogger(instance);

    _resetInitialSettings();

    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].PLAYBACK_SEEKING, _onPlaybackSeeking, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].MEDIA_FRAGMENT_LOADED, _onMediaFragmentLoaded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].METRIC_ADDED, _onMetricAdded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].QUALITY_CHANGE_REQUESTED, _onQualityChangeRequested, instance);
  }
  /**
   * Sets the initial state of the algorithm. Calls the initialize function for the paramteters.
   * @param {object} rulesContext
   * @return {object} initialState
   * @private
   */


  function _getInitialL2AState(rulesContext) {
    var initialState = {};
    var mediaInfo = rulesContext.getMediaInfo();
    var bitrates = mediaInfo.bitrateList.map(function (b) {
      return b.bandwidth / 1000;
    });
    initialState.state = L2A_STATE_STARTUP;
    initialState.bitrates = bitrates;
    initialState.lastQuality = 0;

    _initializeL2AParameters(mediaInfo);

    _clearL2AStateOnSeek(initialState);

    return initialState;
  }
  /**
   * Initializes the parameters of the algorithm. This will be done once for each media type.
   * @param {object} mediaInfo
   * @private
   */


  function _initializeL2AParameters(mediaInfo) {
    if (!mediaInfo || !mediaInfo.type) {
      return;
    }

    l2AParameterDict[mediaInfo.type] = {};
    l2AParameterDict[mediaInfo.type].w = []; //Vector of probabilities associated with bitrate decisions

    l2AParameterDict[mediaInfo.type].prev_w = []; //Vector of probabilities associated with bitrate decisions calculated in the previous step

    l2AParameterDict[mediaInfo.type].Q = 0; //Initialization of Lagrangian multiplier (This keeps track of the buffer displacement)

    l2AParameterDict[mediaInfo.type].segment_request_start_s = 0;
    l2AParameterDict[mediaInfo.type].segment_download_finish_s = 0;
    l2AParameterDict[mediaInfo.type].B_target = 1.5; //Target buffer level
  }
  /**
   * Clears the state object
   * @param {object} l2AState
   * @private
   */


  function _clearL2AStateOnSeek(l2AState) {
    l2AState.placeholderBuffer = 0;
    l2AState.mostAdvancedSegmentStart = NaN;
    l2AState.lastSegmentWasReplacement = false;
    l2AState.lastSegmentStart = NaN;
    l2AState.lastSegmentDurationS = NaN;
    l2AState.lastSegmentRequestTimeMs = NaN;
    l2AState.lastSegmentFinishTimeMs = NaN;
  }
  /**
   * Returns the state object for a fiven media type. If the state object is not yet defined _getInitialL2AState is called
   * @param {object} rulesContext
   * @return {object} l2AState
   * @private
   */


  function _getL2AState(rulesContext) {
    var mediaType = rulesContext.getMediaType();
    var l2AState = l2AStateDict[mediaType];

    if (!l2AState) {
      l2AState = _getInitialL2AState(rulesContext);
      l2AStateDict[mediaType] = l2AState;
    }

    return l2AState;
  }
  /**
   * Event handler for the seeking event.
   * @private
   */


  function _onPlaybackSeeking() {
    for (var mediaType in l2AStateDict) {
      if (l2AStateDict.hasOwnProperty(mediaType)) {
        var l2aState = l2AStateDict[mediaType];

        if (l2aState.state !== L2A_STATE_ONE_BITRATE) {
          l2aState.state = L2A_STATE_STARTUP;

          _clearL2AStateOnSeek(l2aState);
        }
      }
    }
  }
  /**
   * Event handler for the mediaFragmentLoaded event
   * @param {object} e
   * @private
   */


  function _onMediaFragmentLoaded(e) {
    if (e && e.chunk && e.chunk.mediaInfo) {
      var l2AState = l2AStateDict[e.chunk.mediaInfo.type];
      var l2AParameters = l2AParameterDict[e.chunk.mediaInfo.type];

      if (l2AState && l2AState.state !== L2A_STATE_ONE_BITRATE) {
        var start = e.chunk.start;

        if (isNaN(l2AState.mostAdvancedSegmentStart) || start > l2AState.mostAdvancedSegmentStart) {
          l2AState.mostAdvancedSegmentStart = start;
          l2AState.lastSegmentWasReplacement = false;
        } else {
          l2AState.lastSegmentWasReplacement = true;
        }

        l2AState.lastSegmentStart = start;
        l2AState.lastSegmentDurationS = e.chunk.duration;
        l2AState.lastQuality = e.chunk.quality;

        _checkNewSegment(l2AState, l2AParameters);
      }
    }
  }
  /**
   * Event handler for the metricAdded event
   * @param {object} e
   * @private
   */


  function _onMetricAdded(e) {
    if (e && e.metric === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_0__["default"].HTTP_REQUEST && e.value && e.value.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_3__.HTTPRequest.MEDIA_SEGMENT_TYPE && e.value.trace && e.value.trace.length) {
      var l2AState = l2AStateDict[e.mediaType];
      var l2AParameters = l2AParameterDict[e.mediaType];

      if (l2AState && l2AState.state !== L2A_STATE_ONE_BITRATE) {
        l2AState.lastSegmentRequestTimeMs = e.value.trequest.getTime();
        l2AState.lastSegmentFinishTimeMs = e.value._tfinish.getTime();

        _checkNewSegment(l2AState, l2AParameters);
      }
    }
  }
  /**
   * When a new metric has been added or a media fragment has been loaded the state is adjusted accordingly
   * @param {object} L2AState
   * @param {object} l2AParameters
   * @private
   */


  function _checkNewSegment(L2AState, l2AParameters) {
    if (!isNaN(L2AState.lastSegmentStart) && !isNaN(L2AState.lastSegmentRequestTimeMs)) {
      l2AParameters.segment_request_start_s = 0.001 * L2AState.lastSegmentRequestTimeMs;
      l2AParameters.segment_download_finish_s = 0.001 * L2AState.lastSegmentFinishTimeMs;
      L2AState.lastSegmentStart = NaN;
      L2AState.lastSegmentRequestTimeMs = NaN;
    }
  }
  /**
   * Event handler for the qualityChangeRequested event
   * @param {object} e
   * @private
   */


  function _onQualityChangeRequested(e) {
    // Useful to store change requests when abandoning a download.
    if (e && e.mediaType) {
      var L2AState = l2AStateDict[e.mediaType];

      if (L2AState && L2AState.state !== L2A_STATE_ONE_BITRATE) {
        L2AState.abrQuality = e.newQuality;
      }
    }
  }
  /**
   * Dot multiplication of two arrays
   * @param {array} arr1
   * @param {array} arr2
   * @return {number} sumdot
   * @private
   */


  function _dotmultiplication(arr1, arr2) {
    if (arr1.length !== arr2.length) {
      return -1;
    }

    var sumdot = 0;

    for (var i = 0; i < arr1.length; i++) {
      sumdot = sumdot + arr1[i] * arr2[i];
    }

    return sumdot;
  }
  /**
   * Project an n-dim vector y to the simplex Dn
   * Dn = { x : x n-dim, 1 >= x >= 0, sum(x) = 1}
   * Algorithm is explained at http://arxiv.org/abs/1101.6081
   * @param {array} arr
   * @return {array}
   */


  function euclideanProjection(arr) {
    var m = arr.length;
    var bget = false;
    var arr2 = [];

    for (var ii = 0; ii < m; ++ii) {
      arr2[ii] = arr[ii];
    }

    var s = arr.sort(function (a, b) {
      return b - a;
    });
    var tmpsum = 0;
    var tmax = 0;
    var x = [];

    for (var _ii = 0; _ii < m - 1; ++_ii) {
      tmpsum = tmpsum + s[_ii];
      tmax = (tmpsum - 1) / (_ii + 1);

      if (tmax >= s[_ii + 1]) {
        bget = true;
        break;
      }
    }

    if (!bget) {
      tmax = (tmpsum + s[m - 1] - 1) / m;
    }

    for (var _ii2 = 0; _ii2 < m; ++_ii2) {
      x[_ii2] = Math.max(arr2[_ii2] - tmax, 0);
    }

    return x;
  }
  /**
   * Returns a switch request object indicating which quality is to be played
   * @param {object} rulesContext
   * @return {object}
   */


  function getMaxIndex(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create();
    var horizon = 4; // Optimization horizon (The amount of steps required to achieve convergence)

    var vl = Math.pow(horizon, 0.99); // Cautiousness parameter, used to control aggressiveness of the bitrate decision process.

    var alpha = Math.max(Math.pow(horizon, 1), vl * Math.sqrt(horizon)); // Step size, used for gradient descent exploration granularity

    var mediaInfo = rulesContext.getMediaInfo();
    var mediaType = rulesContext.getMediaType();
    var bitrates = mediaInfo.bitrateList.map(function (b) {
      return b.bandwidth;
    });
    var bitrateCount = bitrates.length;
    var scheduleController = rulesContext.getScheduleController();
    var streamInfo = rulesContext.getStreamInfo();
    var abrController = rulesContext.getAbrController();
    var throughputHistory = abrController.getThroughputHistory();
    var isDynamic = streamInfo && streamInfo.manifestInfo && streamInfo.manifestInfo.isDynamic;
    var useL2AABR = rulesContext.useL2AABR();
    var bufferLevel = dashMetrics.getCurrentBufferLevel(mediaType, true);
    var safeThroughput = throughputHistory.getSafeAverageThroughput(mediaType, isDynamic);
    var throughput = throughputHistory.getAverageThroughput(mediaType, isDynamic); // In kbits/s

    var react = 2; // Reactiveness to volatility (abrupt throughput drops), used to re-calibrate Lagrangian multiplier Q

    var latency = throughputHistory.getAverageLatency(mediaType);
    var videoModel = rulesContext.getVideoModel();
    var quality;
    var currentPlaybackRate = videoModel.getPlaybackRate();

    if (!rulesContext || !rulesContext.hasOwnProperty('getMediaInfo') || !rulesContext.hasOwnProperty('getMediaType') || !rulesContext.hasOwnProperty('getScheduleController') || !rulesContext.hasOwnProperty('getStreamInfo') || !rulesContext.hasOwnProperty('getAbrController') || !rulesContext.hasOwnProperty('useL2AABR')) {
      return switchRequest;
    }

    switchRequest.reason = switchRequest.reason || {};

    if (!useL2AABR || mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO) {
      // L2A decides bitrate only for video. Audio to be included in decision process in a later stage
      return switchRequest;
    }

    scheduleController.setTimeToLoadDelay(0);

    var l2AState = _getL2AState(rulesContext);

    if (l2AState.state === L2A_STATE_ONE_BITRATE) {
      // shouldn't even have been called
      return switchRequest;
    }

    var l2AParameter = l2AParameterDict[mediaType];

    if (!l2AParameter) {
      return switchRequest;
    }

    switchRequest.reason.state = l2AState.state;
    switchRequest.reason.throughput = throughput;
    switchRequest.reason.latency = latency;

    if (isNaN(throughput)) {
      // still starting up - not enough information
      return switchRequest;
    }

    switch (l2AState.state) {
      case L2A_STATE_STARTUP:
        quality = abrController.getQualityForBitrate(mediaInfo, safeThroughput, streamInfo.id, latency); //During strat-up phase abr.controller is responsible for bitrate decisions.

        switchRequest.quality = quality;
        switchRequest.reason.throughput = safeThroughput;
        l2AState.lastQuality = quality;

        if (!isNaN(l2AState.lastSegmentDurationS) && bufferLevel >= l2AParameter.B_target) {
          l2AState.state = L2A_STATE_STEADY;
          l2AParameter.Q = vl; // Initialization of Q langrangian multiplier
          // Update of probability vector w, to be used in main adaptation logic of L2A below (steady state)

          for (var i = 0; i < bitrateCount; ++i) {
            if (i === l2AState.lastQuality) {
              l2AParameter.prev_w[i] = 1;
            } else {
              l2AParameter.prev_w[i] = 0;
            }
          }
        }

        break;
      // L2A_STATE_STARTUP

      case L2A_STATE_STEADY:
        var diff1 = []; //Used to calculate the difference between consecutive decisions (w-w_prev)
        // Manual calculation of latency and throughput during previous request

        var throughputMeasureTime = dashMetrics.getCurrentHttpRequest(mediaType).trace.reduce(function (a, b) {
          return a + b.d;
        }, 0);
        var downloadBytes = dashMetrics.getCurrentHttpRequest(mediaType).trace.reduce(function (a, b) {
          return a + b.b[0];
        }, 0);
        var lastthroughput = Math.round(8 * downloadBytes / throughputMeasureTime); // bits/ms = kbits/s

        if (lastthroughput < 1) {
          lastthroughput = 1;
        } //To avoid division with 0 (avoid infinity) in case of an absolute network outage


        var V = l2AState.lastSegmentDurationS;
        var sign = 1; //Main adaptation logic of L2A-LL

        for (var _i = 0; _i < bitrateCount; ++_i) {
          bitrates[_i] = bitrates[_i] / 1000; // Originally in bps, now in Kbps

          if (currentPlaybackRate * bitrates[_i] > lastthroughput) {
            // In this case buffer would deplete, leading to a stall, which increases latency and thus the particular probability of selsection of bitrate[i] should be decreased.
            sign = -1;
          } // The objective of L2A is to minimize the overall latency=request-response time + buffer length after download+ potential stalling (if buffer less than chunk downlad time)


          l2AParameter.w[_i] = l2AParameter.prev_w[_i] + sign * (V / (2 * alpha)) * ((l2AParameter.Q + vl) * (currentPlaybackRate * bitrates[_i] / lastthroughput)); //Lagrangian descent
        } // Apply euclidean projection on w to ensure w expresses a probability distribution


        l2AParameter.w = euclideanProjection(l2AParameter.w);

        for (var _i2 = 0; _i2 < bitrateCount; ++_i2) {
          diff1[_i2] = l2AParameter.w[_i2] - l2AParameter.prev_w[_i2];
          l2AParameter.prev_w[_i2] = l2AParameter.w[_i2];
        } // Lagrangian multiplier Q calculation:


        l2AParameter.Q = Math.max(0, l2AParameter.Q - V + V * currentPlaybackRate * ((_dotmultiplication(bitrates, l2AParameter.prev_w) + _dotmultiplication(bitrates, diff1)) / lastthroughput)); // Quality is calculated as argmin of the absolute difference between available bitrates (bitrates[i]) and bitrate estimation (dotmultiplication(w,bitrates)).

        var temp = [];

        for (var _i3 = 0; _i3 < bitrateCount; ++_i3) {
          temp[_i3] = Math.abs(bitrates[_i3] - _dotmultiplication(l2AParameter.w, bitrates));
        } // Quality is calculated based on the probability distribution w (the output of L2A)


        quality = temp.indexOf(Math.min.apply(Math, temp)); // We employ a cautious -stepwise- ascent

        if (quality > l2AState.lastQuality) {
          if (bitrates[l2AState.lastQuality + 1] <= lastthroughput) {
            quality = l2AState.lastQuality + 1;
          }
        } // Provision against bitrate over-estimation, by re-calibrating the Lagrangian multiplier Q, to be taken into account for the next chunk


        if (bitrates[quality] >= lastthroughput) {
          l2AParameter.Q = react * Math.max(vl, l2AParameter.Q);
        }

        switchRequest.quality = quality;
        switchRequest.reason.throughput = throughput;
        switchRequest.reason.latency = latency;
        switchRequest.reason.bufferLevel = bufferLevel;
        l2AState.lastQuality = switchRequest.quality;
        break;

      default:
        // should not arrive here, try to recover
        logger.debug('L2A ABR rule invoked in bad state.');
        switchRequest.quality = abrController.getQualityForBitrate(mediaInfo, safeThroughput, streamInfo.id, latency);
        switchRequest.reason.state = l2AState.state;
        switchRequest.reason.throughput = safeThroughput;
        switchRequest.reason.latency = latency;
        l2AState.state = L2A_STATE_STARTUP;

        _clearL2AStateOnSeek(l2AState);

    }

    return switchRequest;
  }
  /**
   * Reset objects to their initial state
   * @private
   */


  function _resetInitialSettings() {
    l2AStateDict = {};
    l2AParameterDict = {};
  }
  /**
   * Reset the rule
   */


  function reset() {
    _resetInitialSettings();

    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].PLAYBACK_SEEKING, _onPlaybackSeeking, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].MEDIA_FRAGMENT_LOADED, _onMediaFragmentLoaded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].METRIC_ADDED, _onMetricAdded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].QUALITY_CHANGE_REQUESTED, _onQualityChangeRequested, instance);
  }

  instance = {
    getMaxIndex: getMaxIndex,
    reset: reset
  };
  setup();
  return instance;
}

L2ARule.__dashjs_factory_name = 'L2ARule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(L2ARule));

/***/ }),

/***/ "./src/streaming/rules/abr/SwitchHistoryRule.js":
/*!******************************************************!*\
  !*** ./src/streaming/rules/abr/SwitchHistoryRule.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");




function SwitchHistoryRule() {
  var context = this.context;
  var instance, logger; //MAX_SWITCH is the number of drops made. It doesn't consider the size of the drop.

  var MAX_SWITCH = 0.075; //Before this number of switch requests(no switch or actual), don't apply the rule.
  //must be < SwitchRequestHistory SWITCH_REQUEST_HISTORY_DEPTH to enable rule

  var SAMPLE_SIZE = 6;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance().getLogger(instance);
  }

  function getMaxIndex(rulesContext) {
    var switchRequestHistory = rulesContext ? rulesContext.getSwitchHistory() : null;
    var switchRequests = switchRequestHistory ? switchRequestHistory.getSwitchRequests() : [];
    var drops = 0;
    var noDrops = 0;
    var dropSize = 0;
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create();

    for (var i = 0; i < switchRequests.length; i++) {
      if (switchRequests[i] !== undefined) {
        drops += switchRequests[i].drops;
        noDrops += switchRequests[i].noDrops;
        dropSize += switchRequests[i].dropSize;

        if (drops + noDrops >= SAMPLE_SIZE && drops / noDrops > MAX_SWITCH) {
          switchRequest.quality = i > 0 && switchRequests[i].drops > 0 ? i - 1 : i;
          switchRequest.reason = {
            index: switchRequest.quality,
            drops: drops,
            noDrops: noDrops,
            dropSize: dropSize
          };
          logger.debug('Switch history rule index: ' + switchRequest.quality + ' samples: ' + (drops + noDrops) + ' drops: ' + drops);
          break;
        }
      }
    }

    return switchRequest;
  }

  instance = {
    getMaxIndex: getMaxIndex
  };
  setup();
  return instance;
}

SwitchHistoryRule.__dashjs_factory_name = 'SwitchHistoryRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SwitchHistoryRule));

/***/ }),

/***/ "./src/streaming/rules/abr/ThroughputRule.js":
/*!***************************************************!*\
  !*** ./src/streaming/rules/abr/ThroughputRule.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */





function ThroughputRule(config) {
  config = config || {};
  var context = this.context;
  var dashMetrics = config.dashMetrics;
  var instance;

  function setup() {}

  function checkConfig() {
    if (!dashMetrics || !dashMetrics.hasOwnProperty('getCurrentBufferState')) {
      throw new Error(_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMaxIndex(rulesContext) {
    var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create();

    if (!rulesContext || !rulesContext.hasOwnProperty('getMediaInfo') || !rulesContext.hasOwnProperty('getMediaType') || !rulesContext.hasOwnProperty('useBufferOccupancyABR') || !rulesContext.hasOwnProperty('getAbrController') || !rulesContext.hasOwnProperty('getScheduleController')) {
      return switchRequest;
    }

    checkConfig();
    var mediaInfo = rulesContext.getMediaInfo();
    var mediaType = rulesContext.getMediaType();
    var currentBufferState = dashMetrics.getCurrentBufferState(mediaType);
    var scheduleController = rulesContext.getScheduleController();
    var abrController = rulesContext.getAbrController();
    var streamInfo = rulesContext.getStreamInfo();
    var streamId = streamInfo ? streamInfo.id : null;
    var isDynamic = streamInfo && streamInfo.manifestInfo ? streamInfo.manifestInfo.isDynamic : null;
    var throughputHistory = abrController.getThroughputHistory();
    var throughput = throughputHistory.getSafeAverageThroughput(mediaType, isDynamic);
    var latency = throughputHistory.getAverageLatency(mediaType);
    var useBufferOccupancyABR = rulesContext.useBufferOccupancyABR();

    if (isNaN(throughput) || !currentBufferState || useBufferOccupancyABR) {
      return switchRequest;
    }

    if (abrController.getAbandonmentStateFor(streamId, mediaType) !== _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].ABANDON_LOAD) {
      if (currentBufferState.state === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].BUFFER_LOADED || isDynamic) {
        switchRequest.quality = abrController.getQualityForBitrate(mediaInfo, throughput, streamId, latency);
        scheduleController.setTimeToLoadDelay(0);
        switchRequest.reason = {
          throughput: throughput,
          latency: latency
        };
      }
    }

    return switchRequest;
  }

  function reset() {// no persistent information to reset
  }

  instance = {
    getMaxIndex: getMaxIndex,
    reset: reset
  };
  setup();
  return instance;
}

ThroughputRule.__dashjs_factory_name = 'ThroughputRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ThroughputRule));

/***/ }),

/***/ "./src/streaming/rules/abr/lolp/LearningAbrController.js":
/*!***************************************************************!*\
  !*** ./src/streaming/rules/abr/lolp/LearningAbrController.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../core/Debug */ "./src/core/Debug.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Authors:
 * Abdelhak Bentaleb | National University of Singapore | bentaleb@comp.nus.edu.sg
 * Mehmet N. Akcay | Ozyegin University | necmettin.akcay@ozu.edu.tr
 * May Lim | National University of Singapore | maylim@comp.nus.edu.sg
 */


var WEIGHT_SELECTION_MODES = {
  MANUAL: 'manual_weight_selection',
  RANDOM: 'random_weight_selection',
  DYNAMIC: 'dynamic_weight_selection'
};

function LearningAbrController() {
  var context = this.context;
  var instance, logger, somBitrateNeurons, bitrateNormalizationFactor, latencyNormalizationFactor, minBitrate, weights, sortedCenters, weightSelectionMode;
  /**
   * Setup the class
   */

  function _setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance().getLogger(instance);

    _resetInitialSettings();
  }
  /**
   * Reset all values
   */


  function reset() {
    _resetInitialSettings();
  }
  /**
   * Reset to initial settings
   * @private
   */


  function _resetInitialSettings() {
    somBitrateNeurons = null;
    bitrateNormalizationFactor = 1;
    latencyNormalizationFactor = 100;
    minBitrate = 0;
    weights = null;
    sortedCenters = null;
    weightSelectionMode = WEIGHT_SELECTION_MODES.DYNAMIC;
  }
  /**
   * Returns the maximum throughput
   * @return {number}
   * @private
   */


  function _getMaxThroughput() {
    var maxThroughput = 0;

    if (somBitrateNeurons) {
      for (var i = 0; i < somBitrateNeurons.length; i++) {
        var neuron = somBitrateNeurons[i];

        if (neuron.state.throughput > maxThroughput) {
          maxThroughput = neuron.state.throughput;
        }
      }
    }

    return maxThroughput;
  }
  /**
   *
   * @param {array} w
   * @return {number}
   * @private
   */


  function _getMagnitude(w) {
    var magnitude = w.map(function (x) {
      return Math.pow(x, 2);
    }).reduce(function (sum, now) {
      return sum + now;
    });
    return Math.sqrt(magnitude);
  }
  /**
   *
   * @param {array} a
   * @param {array} b
   * @param {array} w
   * @return {number}
   * @private
   */


  function _getDistance(a, b, w) {
    var sum = a.map(function (x, i) {
      return w[i] * Math.pow(x - b[i], 2);
    }) // square the difference*w
    .reduce(function (sum, now) {
      return sum + now;
    }); // sum

    var sign = sum < 0 ? -1 : 1;
    return sign * Math.sqrt(Math.abs(sum));
  }
  /**
   *
   * @param {object} a
   * @param {object} b
   * @return {number}
   * @private
   */


  function _getNeuronDistance(a, b) {
    var aState = [a.state.throughput, a.state.latency, a.state.rebuffer, a.state["switch"]];
    var bState = [b.state.throughput, b.state.latency, b.state.rebuffer, b.state["switch"]];
    return _getDistance(aState, bState, [1, 1, 1, 1]);
  }
  /**
   *
   * @param {object} winnerNeuron
   * @param {array} somElements
   * @param {array} x
   * @private
   */


  function _updateNeurons(winnerNeuron, somElements, x) {
    for (var i = 0; i < somElements.length; i++) {
      var somNeuron = somElements[i];
      var sigma = 0.1;

      var neuronDistance = _getNeuronDistance(somNeuron, winnerNeuron);

      var neighbourHood = Math.exp(-1 * Math.pow(neuronDistance, 2) / (2 * Math.pow(sigma, 2)));

      _updateNeuronState(somNeuron, x, neighbourHood);
    }
  }
  /**
   *
   * @param {object} neuron
   * @param {array} x
   * @param {object} neighbourHood
   * @private
   */


  function _updateNeuronState(neuron, x, neighbourHood) {
    var state = neuron.state;
    var w = [0.01, 0.01, 0.01, 0.01]; // learning rate

    state.throughput = state.throughput + (x[0] - state.throughput) * w[0] * neighbourHood;
    state.latency = state.latency + (x[1] - state.latency) * w[1] * neighbourHood;
    state.rebuffer = state.rebuffer + (x[2] - state.rebuffer) * w[2] * neighbourHood;
    state["switch"] = state["switch"] + (x[3] - state["switch"]) * w[3] * neighbourHood;
  }
  /**
   *
   * @param {object} currentNeuron
   * @param {number} currentThroughput
   * @return {object}
   * @private
   */


  function _getDownShiftNeuron(currentNeuron, currentThroughput) {
    var maxSuitableBitrate = 0;
    var result = currentNeuron;

    if (somBitrateNeurons) {
      for (var i = 0; i < somBitrateNeurons.length; i++) {
        var n = somBitrateNeurons[i];

        if (n.bitrate < currentNeuron.bitrate && n.bitrate > maxSuitableBitrate && currentThroughput > n.bitrate) {
          // possible downshiftable neuron
          maxSuitableBitrate = n.bitrate;
          result = n;
        }
      }
    }

    return result;
  }
  /**
   *
   * @param {object} mediaInfo
   * @param {number} throughput
   * @param {number} latency
   * @param {number} bufferSize
   * @param {number} playbackRate
   * @param {number} currentQualityIndex
   * @param {object} dynamicWeightsSelector
   * @return {null|*}
   */


  function getNextQuality(mediaInfo, throughput, latency, bufferSize, playbackRate, currentQualityIndex, dynamicWeightsSelector) {
    // For Dynamic Weights Selector
    var currentLatency = latency;
    var currentBuffer = bufferSize;
    var currentThroughput = throughput;

    var somElements = _getSomBitrateNeurons(mediaInfo); // normalize throughput


    var throughputNormalized = throughput / bitrateNormalizationFactor; // saturate values higher than 1

    if (throughputNormalized > 1) {
      throughputNormalized = _getMaxThroughput();
    } // normalize latency


    latency = latency / latencyNormalizationFactor;
    var targetLatency = 0;
    var targetRebufferLevel = 0;
    var targetSwitch = 0; // 10K + video encoding is the recommended throughput

    var throughputDelta = 10000;
    logger.debug("getNextQuality called throughput:".concat(throughputNormalized, " latency:").concat(latency, " bufferSize:").concat(bufferSize, " currentQualityIndex:").concat(currentQualityIndex, " playbackRate:").concat(playbackRate));
    var currentNeuron = somElements[currentQualityIndex];
    var downloadTime = currentNeuron.bitrate * dynamicWeightsSelector.getSegmentDuration() / currentThroughput;
    var rebuffer = Math.max(0, downloadTime - currentBuffer); // check buffer for possible stall

    if (currentBuffer - downloadTime < dynamicWeightsSelector.getMinBuffer()) {
      logger.debug("Buffer is low for bitrate= ".concat(currentNeuron.bitrate, " downloadTime=").concat(downloadTime, " currentBuffer=").concat(currentBuffer, " rebuffer=").concat(rebuffer));
      return _getDownShiftNeuron(currentNeuron, currentThroughput).qualityIndex;
    }

    switch (weightSelectionMode) {
      case WEIGHT_SELECTION_MODES.MANUAL:
        _manualWeightSelection();

        break;

      case WEIGHT_SELECTION_MODES.RANDOM:
        _randomWeightSelection(somElements);

        break;

      case WEIGHT_SELECTION_MODES.DYNAMIC:
        _dynamicWeightSelection(dynamicWeightsSelector, somElements, currentLatency, currentBuffer, rebuffer, currentThroughput, playbackRate);

        break;

      default:
        _dynamicWeightSelection(dynamicWeightsSelector, somElements, currentLatency, currentBuffer, rebuffer, currentThroughput, playbackRate);

    }

    var minDistance = null;
    var minIndex = null;
    var winnerNeuron = null;

    for (var i = 0; i < somElements.length; i++) {
      var somNeuron = somElements[i];
      var somNeuronState = somNeuron.state;
      var somData = [somNeuronState.throughput, somNeuronState.latency, somNeuronState.rebuffer, somNeuronState["switch"]];
      var distanceWeights = weights.slice();
      var nextBuffer = dynamicWeightsSelector.getNextBufferWithBitrate(somNeuron.bitrate, currentBuffer, currentThroughput);
      var isBufferLow = nextBuffer < dynamicWeightsSelector.getMinBuffer();

      if (isBufferLow) {
        logger.debug("Buffer is low for bitrate=".concat(somNeuron.bitrate, " downloadTime=").concat(downloadTime, " currentBuffer=").concat(currentBuffer, " nextBuffer=").concat(nextBuffer));
      } // special condition downshift immediately


      if (somNeuron.bitrate > throughput - throughputDelta || isBufferLow) {
        if (somNeuron.bitrate !== minBitrate) {
          // encourage to pick smaller bitrates throughputWeight=100
          distanceWeights[0] = 100;
        }
      } // calculate the distance with the target


      var distance = _getDistance(somData, [throughputNormalized, targetLatency, targetRebufferLevel, targetSwitch], distanceWeights);

      if (minDistance === null || distance < minDistance) {
        minDistance = distance;
        minIndex = somNeuron.qualityIndex;
        winnerNeuron = somNeuron;
      }
    } // update current neuron and the neighbourhood with the calculated QoE
    // will punish current if it is not picked


    var bitrateSwitch = Math.abs(currentNeuron.bitrate - winnerNeuron.bitrate) / bitrateNormalizationFactor;

    _updateNeurons(currentNeuron, somElements, [throughputNormalized, latency, rebuffer, bitrateSwitch]); // update bmu and  neighbours with targetQoE=1, targetLatency=0


    _updateNeurons(winnerNeuron, somElements, [throughputNormalized, targetLatency, targetRebufferLevel, bitrateSwitch]);

    return minIndex;
  }
  /**
   * Option 1: Manual weights
   * @private
   */


  function _manualWeightSelection() {
    var throughputWeight = 0.4;
    var latencyWeight = 0.4;
    var bufferWeight = 0.4;
    var switchWeight = 0.4;
    weights = [throughputWeight, latencyWeight, bufferWeight, switchWeight]; // throughput, latency, buffer, switch
  }
  /**
   * Option 2: Random (Xavier) weights
   * @param {array} somElements
   * @private
   */


  function _randomWeightSelection(somElements) {
    weights = _getXavierWeights(somElements.length, 4);
  }
  /**
   * Dynamic Weight Selector weights
   * @param {object} dynamicWeightsSelector
   * @param {array} somElements
   * @param {number} currentLatency
   * @param {number} currentBuffer
   * @param {number} rebuffer
   * @param {number} currentThroughput
   * @param {number} playbackRate
   * @private
   */


  function _dynamicWeightSelection(dynamicWeightsSelector, somElements, currentLatency, currentBuffer, rebuffer, currentThroughput, playbackRate) {
    if (!weights) {
      weights = sortedCenters[sortedCenters.length - 1];
    } // Dynamic Weights Selector (step 2/2: find weights)


    var weightVector = dynamicWeightsSelector.findWeightVector(somElements, currentLatency, currentBuffer, rebuffer, currentThroughput, playbackRate);

    if (weightVector !== null && weightVector !== -1) {
      // null: something went wrong, -1: constraints not met
      weights = weightVector;
    }
  }
  /**
   *
   * @param {number }neuronCount
   * @param {number }weightCount
   * @return {array}
   * @private
   */


  function _getXavierWeights(neuronCount, weightCount) {
    var W = [];
    var upperBound = Math.sqrt(2 / neuronCount);

    for (var i = 0; i < weightCount; i++) {
      W.push(Math.random() * upperBound);
    }

    weights = W;
    return weights;
  }
  /**
   *
   * @param {object} mediaInfo
   * @return {array}
   * @private
   */


  function _getSomBitrateNeurons(mediaInfo) {
    if (!somBitrateNeurons) {
      somBitrateNeurons = [];
      var bitrateList = mediaInfo.bitrateList;
      var bitrateVector = [];
      minBitrate = bitrateList[0].bandwidth;
      bitrateList.forEach(function (element) {
        bitrateVector.push(element.bandwidth);

        if (element.bandwidth < minBitrate) {
          minBitrate = element.bandwidth;
        }
      });
      bitrateNormalizationFactor = _getMagnitude(bitrateVector);

      for (var i = 0; i < bitrateList.length; i++) {
        var neuron = {
          qualityIndex: i,
          bitrate: bitrateList[i].bandwidth,
          state: {
            // normalize throughputs
            throughput: bitrateList[i].bandwidth / bitrateNormalizationFactor,
            latency: 0,
            rebuffer: 0,
            "switch": 0
          }
        };
        somBitrateNeurons.push(neuron);
      }

      sortedCenters = _getInitialKmeansPlusPlusCenters(somBitrateNeurons);
    }

    return somBitrateNeurons;
  }
  /**
   *
   * @param {number} size
   * @return {array}
   * @private
   */


  function _getRandomData(size) {
    var dataArray = [];

    for (var i = 0; i < size; i++) {
      var data = [Math.random() * _getMaxThroughput(), //throughput
      Math.random(), //latency
      Math.random(), //buffersize
      Math.random() //switch
      ];
      dataArray.push(data);
    }

    return dataArray;
  }
  /**
   *
   * @param {array} somElements
   * @return {array}
   * @private
   */


  function _getInitialKmeansPlusPlusCenters(somElements) {
    var centers = [];

    var randomDataSet = _getRandomData(Math.pow(somElements.length, 2));

    centers.push(randomDataSet[0]);
    var distanceWeights = [1, 1, 1, 1];

    for (var k = 1; k < somElements.length; k++) {
      var nextPoint = null;
      var _maxDistance = null;

      for (var i = 0; i < randomDataSet.length; i++) {
        var currentPoint = randomDataSet[i];
        var minDistance = null;

        for (var j = 0; j < centers.length; j++) {
          var distance = _getDistance(currentPoint, centers[j], distanceWeights);

          if (minDistance === null || distance < minDistance) {
            minDistance = distance;
          }
        }

        if (_maxDistance === null || minDistance > _maxDistance) {
          nextPoint = currentPoint;
          _maxDistance = minDistance;
        }
      }

      centers.push(nextPoint);
    } // find the least similar center


    var maxDistance = null;
    var leastSimilarIndex = null;

    for (var _i = 0; _i < centers.length; _i++) {
      var _distance = 0;

      for (var _j = 0; _j < centers.length; _j++) {
        if (_i === _j) continue;
        _distance += _getDistance(centers[_i], centers[_j], distanceWeights);
      }

      if (maxDistance === null || _distance > maxDistance) {
        maxDistance = _distance;
        leastSimilarIndex = _i;
      }
    } // move centers to sortedCenters


    var sortedCenters = [];
    sortedCenters.push(centers[leastSimilarIndex]);
    centers.splice(leastSimilarIndex, 1);

    while (centers.length > 0) {
      var _minDistance = null;
      var minIndex = null;

      for (var _i2 = 0; _i2 < centers.length; _i2++) {
        var _distance2 = _getDistance(sortedCenters[0], centers[_i2], distanceWeights);

        if (_minDistance === null || _distance2 < _minDistance) {
          _minDistance = _distance2;
          minIndex = _i2;
        }
      }

      sortedCenters.push(centers[minIndex]);
      centers.splice(minIndex, 1);
    }

    return sortedCenters;
  }

  instance = {
    getNextQuality: getNextQuality,
    reset: reset
  };

  _setup();

  return instance;
}

LearningAbrController.__dashjs_factory_name = 'LearningAbrController';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(LearningAbrController));

/***/ }),

/***/ "./src/streaming/rules/abr/lolp/LoLpQoEEvaluator.js":
/*!**********************************************************!*\
  !*** ./src/streaming/rules/abr/lolp/LoLpQoEEvaluator.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _QoeInfo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./QoeInfo */ "./src/streaming/rules/abr/lolp/QoeInfo.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Authors:
 * Abdelhak Bentaleb | National University of Singapore | bentaleb@comp.nus.edu.sg
 * Mehmet N. Akcay | Ozyegin University | necmettin.akcay@ozu.edu.tr
 * May Lim | National University of Singapore | maylim@comp.nus.edu.sg
 */



function LoLpQoeEvaluator() {
  var instance, voPerSegmentQoeInfo, segmentDuration, maxBitrateKbps, minBitrateKbps;

  function _setup() {
    _resetInitialSettings();
  }

  function _resetInitialSettings() {
    voPerSegmentQoeInfo = null;
    segmentDuration = null;
    maxBitrateKbps = null;
    minBitrateKbps = null;
  }

  function setupPerSegmentQoe(sDuration, maxBrKbps, minBrKbps) {
    // Set up Per Segment QoeInfo
    voPerSegmentQoeInfo = _createQoeInfo('segment', sDuration, maxBrKbps, minBrKbps);
    segmentDuration = sDuration;
    maxBitrateKbps = maxBrKbps;
    minBitrateKbps = minBrKbps;
  }

  function _createQoeInfo(fragmentType, fragmentDuration, maxBitrateKbps, minBitrateKbps) {
    /*
     * [Weights][Source: Abdelhak Bentaleb, 2020 (last updated: 30 Mar 2020)]
     * bitrateReward:           segment duration, e.g. 0.5s
     * bitrateSwitchPenalty:    0.02s or 1s if the bitrate switch is too important
     * rebufferPenalty:         max encoding bitrate, e.g. 1000kbps
     * latencyPenalty:          if L ≤ 1.1 seconds then = min encoding bitrate * 0.05, otherwise = max encoding bitrate * 0.1
     * playbackSpeedPenalty:    min encoding bitrate, e.g. 200kbps
     */
    // Create new QoeInfo object
    var qoeInfo = new _QoeInfo__WEBPACK_IMPORTED_MODULE_1__["default"]();
    qoeInfo.type = fragmentType; // Set weight: bitrateReward
    // set some safe value, else consider throwing error

    if (!fragmentDuration) {
      qoeInfo.weights.bitrateReward = 1;
    } else {
      qoeInfo.weights.bitrateReward = fragmentDuration;
    } // Set weight: bitrateSwitchPenalty
    // qoeInfo.weights.bitrateSwitchPenalty = 0.02;


    qoeInfo.weights.bitrateSwitchPenalty = 1; // Set weight: rebufferPenalty
    // set some safe value, else consider throwing error

    if (!maxBitrateKbps) {
      qoeInfo.weights.rebufferPenalty = 1000;
    } else {
      qoeInfo.weights.rebufferPenalty = maxBitrateKbps;
    } // Set weight: latencyPenalty


    qoeInfo.weights.latencyPenalty = [];
    qoeInfo.weights.latencyPenalty.push({
      threshold: 1.1,
      penalty: minBitrateKbps * 0.05
    });
    qoeInfo.weights.latencyPenalty.push({
      threshold: 100000000,
      penalty: maxBitrateKbps * 0.1
    }); // Set weight: playbackSpeedPenalty

    if (!minBitrateKbps) qoeInfo.weights.playbackSpeedPenalty = 200; // set some safe value, else consider throwing error
    else qoeInfo.weights.playbackSpeedPenalty = minBitrateKbps;
    return qoeInfo;
  }

  function logSegmentMetrics(segmentBitrate, segmentRebufferTime, currentLatency, currentPlaybackSpeed) {
    if (voPerSegmentQoeInfo) {
      _logMetricsInQoeInfo(segmentBitrate, segmentRebufferTime, currentLatency, currentPlaybackSpeed, voPerSegmentQoeInfo);
    }
  }

  function _logMetricsInQoeInfo(bitrate, rebufferTime, latency, playbackSpeed, qoeInfo) {
    // Update: bitrate Weighted Sum value
    qoeInfo.bitrateWSum += qoeInfo.weights.bitrateReward * bitrate; // Update: bitrateSwitch Weighted Sum value

    if (qoeInfo.lastBitrate) {
      qoeInfo.bitrateSwitchWSum += qoeInfo.weights.bitrateSwitchPenalty * Math.abs(bitrate - qoeInfo.lastBitrate);
    }

    qoeInfo.lastBitrate = bitrate; // Update: rebuffer Weighted Sum value

    qoeInfo.rebufferWSum += qoeInfo.weights.rebufferPenalty * rebufferTime; // Update: latency Weighted Sum value

    for (var i = 0; i < qoeInfo.weights.latencyPenalty.length; i++) {
      var latencyRange = qoeInfo.weights.latencyPenalty[i];

      if (latency <= latencyRange.threshold) {
        qoeInfo.latencyWSum += latencyRange.penalty * latency;
        break;
      }
    } // Update: playbackSpeed Weighted Sum value


    qoeInfo.playbackSpeedWSum += qoeInfo.weights.playbackSpeedPenalty * Math.abs(1 - playbackSpeed); // Update: Total Qoe value

    qoeInfo.totalQoe = qoeInfo.bitrateWSum - qoeInfo.bitrateSwitchWSum - qoeInfo.rebufferWSum - qoeInfo.latencyWSum - qoeInfo.playbackSpeedWSum;
  } // Returns current Per Segment QoeInfo


  function getPerSegmentQoe() {
    return voPerSegmentQoeInfo;
  } // For one-time use only
  // Returns totalQoe based on a single set of metrics.


  function calculateSingleUseQoe(segmentBitrate, segmentRebufferTime, currentLatency, currentPlaybackSpeed) {
    var singleUseQoeInfo = null;

    if (segmentDuration && maxBitrateKbps && minBitrateKbps) {
      singleUseQoeInfo = _createQoeInfo('segment', segmentDuration, maxBitrateKbps, minBitrateKbps);
    }

    if (singleUseQoeInfo) {
      _logMetricsInQoeInfo(segmentBitrate, segmentRebufferTime, currentLatency, currentPlaybackSpeed, singleUseQoeInfo);

      return singleUseQoeInfo.totalQoe;
    } else {
      // Something went wrong..
      return 0;
    }
  }

  function reset() {
    _resetInitialSettings();
  }

  instance = {
    setupPerSegmentQoe: setupPerSegmentQoe,
    logSegmentMetrics: logSegmentMetrics,
    getPerSegmentQoe: getPerSegmentQoe,
    calculateSingleUseQoe: calculateSingleUseQoe,
    reset: reset
  };

  _setup();

  return instance;
}

LoLpQoeEvaluator.__dashjs_factory_name = 'LoLpQoeEvaluator';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(LoLpQoeEvaluator));

/***/ }),

/***/ "./src/streaming/rules/abr/lolp/LoLpRule.js":
/*!**************************************************!*\
  !*** ./src/streaming/rules/abr/lolp/LoLpRule.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _LearningAbrController__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearningAbrController */ "./src/streaming/rules/abr/lolp/LearningAbrController.js");
/* harmony import */ var _LoLpQoEEvaluator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LoLpQoEEvaluator */ "./src/streaming/rules/abr/lolp/LoLpQoEEvaluator.js");
/* harmony import */ var _SwitchRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _LoLpWeightSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LoLpWeightSelector */ "./src/streaming/rules/abr/lolp/LoLpWeightSelector.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Authors:
 * Abdelhak Bentaleb | National University of Singapore | bentaleb@comp.nus.edu.sg
 * Mehmet N. Akcay | Ozyegin University | necmettin.akcay@ozu.edu.tr
 * May Lim | National University of Singapore | maylim@comp.nus.edu.sg
 */








var DWS_TARGET_LATENCY = 1.5;
var DWS_BUFFER_MIN = 0.3;

function LoLPRule(config) {
  config = config || {};
  var dashMetrics = config.dashMetrics;
  var context = this.context;
  var logger, instance, learningController, qoeEvaluator;

  function _setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance().getLogger(instance);
    learningController = (0,_LearningAbrController__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create();
    qoeEvaluator = (0,_LoLpQoEEvaluator__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create();
  }

  function getMaxIndex(rulesContext) {
    try {
      var switchRequest = (0,_SwitchRequest__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create();
      var mediaType = rulesContext.getMediaInfo().type;
      var abrController = rulesContext.getAbrController();
      var streamInfo = rulesContext.getStreamInfo();
      var currentQuality = abrController.getQualityFor(mediaType, streamInfo.id);
      var mediaInfo = rulesContext.getMediaInfo();
      var bufferStateVO = dashMetrics.getCurrentBufferState(mediaType);
      var scheduleController = rulesContext.getScheduleController();
      var currentBufferLevel = dashMetrics.getCurrentBufferLevel(mediaType, true);
      var isDynamic = streamInfo && streamInfo.manifestInfo ? streamInfo.manifestInfo.isDynamic : null;
      var playbackController = scheduleController.getPlaybackController();
      var latency = playbackController.getCurrentLiveLatency();

      if (!rulesContext.useLoLPABR() || mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO) {
        return switchRequest;
      }

      if (!latency) {
        latency = 0;
      }

      var playbackRate = playbackController.getPlaybackRate();
      var throughputHistory = abrController.getThroughputHistory();
      var throughput = throughputHistory.getSafeAverageThroughput(mediaType, isDynamic);
      logger.debug("Throughput ".concat(Math.round(throughput), " kbps"));

      if (isNaN(throughput) || !bufferStateVO) {
        return switchRequest;
      }

      if (abrController.getAbandonmentStateFor(streamInfo.id, mediaType) === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_5__["default"].ABANDON_LOAD) {
        return switchRequest;
      } // QoE parameters


      var bitrateList = mediaInfo.bitrateList; // [{bandwidth: 200000, width: 640, height: 360}, ...]

      var segmentDuration = rulesContext.getRepresentationInfo().fragmentDuration;
      var minBitrateKbps = bitrateList[0].bandwidth / 1000.0; // min bitrate level

      var maxBitrateKbps = bitrateList[bitrateList.length - 1].bandwidth / 1000.0; // max bitrate level

      for (var i = 0; i < bitrateList.length; i++) {
        // in case bitrateList is not sorted as expected
        var b = bitrateList[i].bandwidth / 1000.0;
        if (b > maxBitrateKbps) maxBitrateKbps = b;else if (b < minBitrateKbps) {
          minBitrateKbps = b;
        }
      } // Learning rule pre-calculations


      var currentBitrate = bitrateList[currentQuality].bandwidth;
      var currentBitrateKbps = currentBitrate / 1000.0;
      var httpRequest = dashMetrics.getCurrentHttpRequest(mediaType, true);
      var lastFragmentDownloadTime = (httpRequest.tresponse.getTime() - httpRequest.trequest.getTime()) / 1000;
      var segmentRebufferTime = lastFragmentDownloadTime > segmentDuration ? lastFragmentDownloadTime - segmentDuration : 0;
      qoeEvaluator.setupPerSegmentQoe(segmentDuration, maxBitrateKbps, minBitrateKbps);
      qoeEvaluator.logSegmentMetrics(currentBitrateKbps, segmentRebufferTime, latency, playbackRate);
      /*
      * Dynamic Weights Selector (step 1/2: initialization)
      */

      var dynamicWeightsSelector = (0,_LoLpWeightSelector__WEBPACK_IMPORTED_MODULE_6__["default"])(context).create({
        targetLatency: DWS_TARGET_LATENCY,
        bufferMin: DWS_BUFFER_MIN,
        segmentDuration: segmentDuration,
        qoeEvaluator: qoeEvaluator
      });
      /*
       * Select next quality
       */

      switchRequest.quality = learningController.getNextQuality(mediaInfo, throughput * 1000, latency, currentBufferLevel, playbackRate, currentQuality, dynamicWeightsSelector);
      switchRequest.reason = {
        throughput: throughput,
        latency: latency
      };
      switchRequest.priority = _SwitchRequest__WEBPACK_IMPORTED_MODULE_4__["default"].PRIORITY.STRONG;
      scheduleController.setTimeToLoadDelay(0);

      if (switchRequest.quality !== currentQuality) {
        console.log('[TgcLearningRule][' + mediaType + '] requesting switch to index: ', switchRequest.quality, 'Average throughput', Math.round(throughput), 'kbps');
      }

      return switchRequest;
    } catch (e) {
      throw e;
    }
  }
  /**
   * Reset objects to their initial state
   * @private
   */


  function _resetInitialSettings() {
    learningController.reset();
    qoeEvaluator.reset();
  }
  /**
   * Reset the rule
   */


  function reset() {
    _resetInitialSettings();
  }

  instance = {
    getMaxIndex: getMaxIndex,
    reset: reset
  };

  _setup();

  return instance;
}

LoLPRule.__dashjs_factory_name = 'LoLPRule';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(LoLPRule));

/***/ }),

/***/ "./src/streaming/rules/abr/lolp/LoLpWeightSelector.js":
/*!************************************************************!*\
  !*** ./src/streaming/rules/abr/lolp/LoLpWeightSelector.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Authors:
 * Abdelhak Bentaleb | National University of Singapore | bentaleb@comp.nus.edu.sg
 * Mehmet N. Akcay | Ozyegin University | necmettin.akcay@ozu.edu.tr
 * May Lim | National University of Singapore | maylim@comp.nus.edu.sg
 */


function LoLpWeightSelector(config) {
  var targetLatency = config.targetLatency;
  var bufferMin = config.bufferMin;
  var segmentDuration = config.segmentDuration;
  var qoeEvaluator = config.qoeEvaluator;
  var instance, valueList, weightTypeCount, weightOptions, previousLatency;
  /**
   *
   * @private
   */

  function _setup() {
    _resetInitialSettings();
  }
  /**
   *
   * @private
   */


  function _resetInitialSettings() {
    valueList = [0.2, 0.4, 0.6, 0.8, 1];
    weightTypeCount = 4;
    weightOptions = _getPermutations(valueList, weightTypeCount);
    previousLatency = 0;
  }
  /**
   * Next, at each segment boundary, ABR to input current neurons and target state (only used in Method II) to find the desired weight vector
   * @param {array} neurons
   * @param {number} currentLatency
   * @param {number} currentBuffer
   * @param {number} currentRebuffer
   * @param {number} currentThroughput
   * @param {number} playbackRate
   * @return {null}
   * @private
   */


  function findWeightVector(neurons, currentLatency, currentBuffer, currentRebuffer, currentThroughput, playbackRate) {
    var maxQoE = null;
    var winnerWeights = null;
    var winnerBitrate = null;
    var deltaLatency = Math.abs(currentLatency - previousLatency); // For each neuron, m

    neurons.forEach(function (neuron) {
      // For each possible weight vector, z
      // E.g. For [ throughput, latency, buffer, playbackRate, QoE ]
      //      Possible weightVector = [ 0.2, 0.4, 0.2, 0, 0.2 ]
      weightOptions.forEach(function (weightVector) {
        // Apply weightVector to neuron, compute utility and determine winnerWeights
        // Method I: Utility based on QoE given current state
        var weightsObj = {
          throughput: weightVector[0],
          latency: weightVector[1],
          buffer: weightVector[2],
          "switch": weightVector[3]
        };
        var downloadTime = neuron.bitrate * segmentDuration / currentThroughput;
        var nextBuffer = getNextBuffer(currentBuffer, downloadTime);
        var rebuffer = Math.max(0.00001, downloadTime - nextBuffer);
        var wt;

        if (weightsObj.buffer === 0) {
          wt = 10;
        } else {
          wt = 1 / weightsObj.buffer;
        }

        var weightedRebuffer = wt * rebuffer;

        if (weightsObj.latency === 0) {
          wt = 10;
        } else {
          wt = 1 / weightsObj.latency; // inverse the weight because wt and latency should have positive relationship, i.e., higher latency = higher wt
        }

        var weightedLatency = wt * neuron.state.latency;
        var totalQoE = qoeEvaluator.calculateSingleUseQoe(neuron.bitrate, weightedRebuffer, weightedLatency, playbackRate);

        if ((maxQoE === null || totalQoE > maxQoE) && _checkConstraints(currentLatency, nextBuffer, deltaLatency)) {
          maxQoE = totalQoE;
          winnerWeights = weightVector;
          winnerBitrate = neuron.bitrate;
        }
      });
    }); // winnerWeights was found, check if constraints are satisfied

    if (winnerWeights === null && winnerBitrate === null) {
      winnerWeights = -1;
    }

    previousLatency = currentLatency;
    return winnerWeights;
  }
  /**
   *
   * @param {number} nextLatency
   * @param {number} nextBuffer
   * @param {number} deltaLatency
   * @return {boolean}
   * @private
   */


  function _checkConstraints(nextLatency, nextBuffer, deltaLatency) {
    // A1
    // disabled till we find a better way of estimating latency
    // fails for all with current value
    if (nextLatency > targetLatency + deltaLatency) {
      return false;
    }

    return nextBuffer >= bufferMin;
  }
  /**
   *
   * @param {array} list
   * @param {number} length
   * @return {*}
   * @private
   */


  function _getPermutations(list, length) {
    // Copy initial values as arrays
    var perm = list.map(function (val) {
      return [val];
    }); // Our permutation generator

    var generate = function generate(perm, length, currLen) {
      // Reached desired length
      if (currLen === length) {
        return perm;
      } // For each existing permutation


      var len = perm.length;

      for (var i = 0; i < len; i++) {
        var currPerm = perm.shift(); // Create new permutation

        for (var k = 0; k < list.length; k++) {
          perm.push(currPerm.concat(list[k]));
        }
      } // Recurse


      return generate(perm, length, currLen + 1);
    }; // Start with size 1 because of initial values


    return generate(perm, length, 1);
  }
  /**
   *
   * @return {number}
   */


  function getMinBuffer() {
    return bufferMin;
  }
  /**
   *
   * @return {number}
   */


  function getSegmentDuration() {
    return segmentDuration;
  }
  /**
   *
   * @param {number} bitrateToDownload
   * @param {number} currentBuffer
   * @param {number} currentThroughput
   * @return {number}
   */


  function getNextBufferWithBitrate(bitrateToDownload, currentBuffer, currentThroughput) {
    var downloadTime = bitrateToDownload * segmentDuration / currentThroughput;
    return getNextBuffer(currentBuffer, downloadTime);
  }
  /**
   *
   * @param {number} currentBuffer
   * @param {number} downloadTime
   * @return {number}
   */


  function getNextBuffer(currentBuffer, downloadTime) {
    var segmentDuration = getSegmentDuration();
    var nextBuffer;

    if (downloadTime > segmentDuration) {
      nextBuffer = currentBuffer - segmentDuration;
    } else {
      nextBuffer = currentBuffer + segmentDuration - downloadTime;
    }

    return nextBuffer;
  }

  instance = {
    getMinBuffer: getMinBuffer,
    getSegmentDuration: getSegmentDuration,
    getNextBufferWithBitrate: getNextBufferWithBitrate,
    getNextBuffer: getNextBuffer,
    findWeightVector: findWeightVector
  };

  _setup();

  return instance;
}

LoLpWeightSelector.__dashjs_factory_name = 'LoLpWeightSelector';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(LoLpWeightSelector));

/***/ }),

/***/ "./src/streaming/rules/abr/lolp/QoeInfo.js":
/*!*************************************************!*\
  !*** ./src/streaming/rules/abr/lolp/QoeInfo.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var QoeInfo = function QoeInfo() {
  _classCallCheck(this, QoeInfo);

  // Type e.g. 'segment'
  this.type = null; // Store lastBitrate for calculation of bitrateSwitchWSum

  this.lastBitrate = null; // Weights for each Qoe factor

  this.weights = {};
  this.weights.bitrateReward = null;
  this.weights.bitrateSwitchPenalty = null;
  this.weights.rebufferPenalty = null;
  this.weights.latencyPenalty = null;
  this.weights.playbackSpeedPenalty = null; // Weighted Sum for each Qoe factor

  this.bitrateWSum = 0; // kbps

  this.bitrateSwitchWSum = 0; // kbps

  this.rebufferWSum = 0; // seconds

  this.latencyWSum = 0; // seconds

  this.playbackSpeedWSum = 0; // e.g. 0.95, 1.0, 1.05
  // Store total Qoe value based on current Weighted Sum values

  this.totalQoe = 0;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QoeInfo);

/***/ }),

/***/ "./src/streaming/thumbnail/ThumbnailTracks.js":
/*!****************************************************!*\
  !*** ./src/streaming/thumbnail/ThumbnailTracks.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "THUMBNAILS_SCHEME_ID_URIS": () => (/* binding */ THUMBNAILS_SCHEME_ID_URIS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_ThumbnailTrackInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/ThumbnailTrackInfo */ "./src/streaming/vo/ThumbnailTrackInfo.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _dash_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../dash/utils/SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/* harmony import */ var _streaming_utils_BoxParser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../streaming/utils/BoxParser */ "./src/streaming/utils/BoxParser.js");
/* harmony import */ var _streaming_net_XHRLoader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../streaming/net/XHRLoader */ "./src/streaming/net/XHRLoader.js");
/* harmony import */ var _dash_DashHandler__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../dash/DashHandler */ "./src/dash/DashHandler.js");
/* harmony import */ var _dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../dash/controllers/SegmentsController */ "./src/dash/controllers/SegmentsController.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */










var THUMBNAILS_SCHEME_ID_URIS = ['http://dashif.org/thumbnail_tile', 'http://dashif.org/guidelines/thumbnail_tile'];

function ThumbnailTracks(config) {
  var context = this.context;
  var adapter = config.adapter;
  var baseURLController = config.baseURLController;
  var streamInfo = config.streamInfo;
  var timelineConverter = config.timelineConverter;
  var debug = config.debug;
  var eventBus = config.eventBus;
  var events = config.events;
  var dashConstants = config.dashConstants;
  var urlUtils = (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var instance, tracks, dashHandler, currentTrackIndex, mediaInfo, segmentsController, loader, boxParser;

  function setup() {
    reset();
    loader = (0,_streaming_net_XHRLoader__WEBPACK_IMPORTED_MODULE_7__["default"])(context).create({});
    boxParser = (0,_streaming_utils_BoxParser__WEBPACK_IMPORTED_MODULE_6__["default"])(context).getInstance();
    segmentsController = (0,_dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_9__["default"])(context).create({
      events: events,
      eventBus: eventBus,
      streamInfo: streamInfo,
      timelineConverter: timelineConverter,
      dashConstants: dashConstants,
      dashMetrics: config.dashMetrics,
      segmentBaseController: config.segmentBaseController,
      type: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE
    });
    dashHandler = (0,_dash_DashHandler__WEBPACK_IMPORTED_MODULE_8__["default"])(context).create({
      streamInfo: streamInfo,
      type: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE,
      timelineConverter: timelineConverter,
      segmentsController: segmentsController,
      baseURLController: baseURLController,
      debug: debug,
      eventBus: eventBus,
      events: events,
      dashConstants: dashConstants,
      urlUtils: urlUtils
    }); // initialize controllers

    dashHandler.initialize(adapter ? adapter.getIsDynamic() : false);
  }

  function addTracks() {
    if (!streamInfo || !adapter) {
      return;
    } // Extract thumbnail tracks


    mediaInfo = adapter.getMediaInfoForType(streamInfo, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE);

    if (!mediaInfo) {
      return;
    }

    var voReps = adapter.getVoRepresentations(mediaInfo);

    if (voReps && voReps.length > 0) {
      voReps.forEach(function (rep) {
        if (rep.segmentInfoType === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE && rep.segmentDuration > 0 && rep.media || rep.segmentInfoType === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) {
          _createTrack(rep);
        }

        if (rep.segmentInfoType === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE) {
          _createTrack(rep, true);
        }
      });
    }

    if (tracks.length > 0) {
      // Sort bitrates and select the lowest bitrate rendition
      tracks.sort(function (a, b) {
        return a.bitrate - b.bitrate;
      });
    }
  }

  function _createTrack(representation, useSegmentBase) {
    var track = new _vo_ThumbnailTrackInfo__WEBPACK_IMPORTED_MODULE_3__["default"]();
    track.id = representation.id;
    track.bitrate = representation.bandwidth;
    track.width = representation.width;
    track.height = representation.height;
    track.tilesHor = 1;
    track.tilesVert = 1;

    if (representation.essentialProperties) {
      representation.essentialProperties.forEach(function (p) {
        if (THUMBNAILS_SCHEME_ID_URIS.indexOf(p.schemeIdUri) >= 0 && p.value) {
          var vars = p.value.split('x');

          if (vars.length === 2 && !isNaN(vars[0]) && !isNaN(vars[1])) {
            track.tilesHor = parseInt(vars[0], 10);
            track.tilesVert = parseInt(vars[1], 10);
          }
        }
      });
    }

    if (useSegmentBase) {
      segmentsController.updateSegmentData(representation).then(function (data) {
        _handleUpdatedSegmentData(track, representation, data);
      });
    } else {
      track.startNumber = representation.startNumber;
      track.segmentDuration = representation.segmentDuration;
      track.timescale = representation.timescale;
      track.templateUrl = buildTemplateUrl(representation);
    }

    if (track.tilesHor > 0 && track.tilesVert > 0) {
      // Precalculate width and heigth per tile for perf reasons
      track.widthPerTile = track.width / track.tilesHor;
      track.heightPerTile = track.height / track.tilesVert;
      tracks.push(track);
    }
  }

  function _handleUpdatedSegmentData(track, representation, data) {
    var cache = [];

    var segments = _normalizeSegments(data, representation);

    representation.segments = segments;
    track.segmentDuration = representation.segments[0].duration; //assume all segments have the same duration

    track.readThumbnail = function (time, callback) {
      var cached = null;
      cache.some(function (el) {
        if (el.start <= time && el.end > time) {
          cached = el.url;
          return true;
        }
      });

      if (cached) {
        callback(cached);
      } else {
        representation.segments.some(function (ss) {
          if (ss.mediaStartTime <= time && ss.mediaStartTime + ss.duration > time) {
            var baseURL = baseURLController.resolve(representation.path);
            loader.load({
              method: 'get',
              url: baseURL.url,
              request: {
                range: ss.mediaRange,
                responseType: 'arraybuffer'
              },
              onload: function onload(e) {
                var info = boxParser.getSamplesInfo(e.target.response);
                var blob = new Blob([e.target.response.slice(info.sampleList[0].offset, info.sampleList[0].offset + info.sampleList[0].size)], {
                  type: 'image/jpeg'
                });
                var imageUrl = window.URL.createObjectURL(blob);
                cache.push({
                  start: ss.mediaStartTime,
                  end: ss.mediaStartTime + ss.duration,
                  url: imageUrl
                });
                if (callback) callback(imageUrl);
              }
            });
            return true;
          }
        });
      }
    };
  }

  function _normalizeSegments(data, representation) {
    var segments = [];
    var count = 0;
    var i, len, s, seg;

    for (i = 0, len = data.segments.length; i < len; i++) {
      s = data.segments[i];
      seg = (0,_dash_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_5__.getTimeBasedSegment)(timelineConverter, adapter.getIsDynamic(), representation, s.startTime, s.duration, s.timescale, s.media, s.mediaRange, count);

      if (seg) {
        segments.push(seg);
        seg = null;
        count++;
      }
    }

    return segments;
  }

  function buildTemplateUrl(representation) {
    var templateUrl = urlUtils.isRelative(representation.media) ? urlUtils.resolve(representation.media, baseURLController.resolve(representation.path).url) : representation.media;

    if (!templateUrl) {
      return '';
    }

    return (0,_dash_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_5__.replaceIDForTemplate)(templateUrl, representation.id);
  }

  function getTracks() {
    return tracks;
  }

  function getCurrentTrackIndex() {
    return currentTrackIndex;
  }

  function getCurrentTrack() {
    if (currentTrackIndex < 0) {
      return null;
    }

    return tracks[currentTrackIndex];
  }

  function setTrackByIndex(index) {
    if (!tracks || tracks.length === 0) {
      return;
    } // select highest bitrate in case selected index is higher than bitrate list length


    if (index >= tracks.length) {
      index = tracks.length - 1;
    }

    currentTrackIndex = index;
  }

  function getThumbnailRequestForTime(time) {
    var currentVoRep;
    var voReps = adapter.getVoRepresentations(mediaInfo);

    for (var i = 0; i < voReps.length; i++) {
      if (tracks[currentTrackIndex].id === voReps[i].id) {
        currentVoRep = voReps[i];
        break;
      }
    }

    return dashHandler.getSegmentRequestForTime(mediaInfo, currentVoRep, time);
  }

  function reset() {
    tracks = [];
    currentTrackIndex = -1;
    mediaInfo = null;
  }

  instance = {
    getTracks: getTracks,
    addTracks: addTracks,
    reset: reset,
    setTrackByIndex: setTrackByIndex,
    getCurrentTrack: getCurrentTrack,
    getCurrentTrackIndex: getCurrentTrackIndex,
    getThumbnailRequestForTime: getThumbnailRequestForTime
  };
  setup();
  return instance;
}

ThumbnailTracks.__dashjs_factory_name = 'ThumbnailTracks';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(ThumbnailTracks));

/***/ }),

/***/ "./src/streaming/utils/BoxParser.js":
/*!******************************************!*\
  !*** ./src/streaming/utils/BoxParser.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _IsoFile__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IsoFile */ "./src/streaming/utils/IsoFile.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var codem_isoboxer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! codem-isoboxer */ "./node_modules/codem-isoboxer/dist/iso_boxer.js");
/* harmony import */ var _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/IsoBoxSearchInfo */ "./src/streaming/vo/IsoBoxSearchInfo.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function BoxParser() {
  var logger, instance;
  var context = this.context;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance().getLogger(instance);
  }
  /**
   * @param {ArrayBuffer} data
   * @returns {IsoFile|null}
   * @memberof BoxParser#
   */


  function parse(data) {
    if (!data) return null;

    if (data.fileStart === undefined) {
      data.fileStart = 0;
    }

    var parsedFile = codem_isoboxer__WEBPACK_IMPORTED_MODULE_3__.parseBuffer(data);
    var dashIsoFile = (0,_IsoFile__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create();
    dashIsoFile.setData(parsedFile);
    return dashIsoFile;
  }
  /**
   * From the list of type boxes to look for, returns the latest one that is fully completed (header + payload). This
   * method only looks into the list of top boxes and doesn't analyze nested boxes.
   * @param {string[]} types
   * @param {ArrayBuffer|uint8Array} buffer
   * @param {number} offset
   * @returns {IsoBoxSearchInfo}
   * @memberof BoxParser#
   */


  function findLastTopIsoBoxCompleted(types, buffer, offset) {
    if (offset === undefined) {
      offset = 0;
    } // 8 = size (uint32) + type (4 characters)


    if (!buffer || offset + 8 >= buffer.byteLength) {
      return new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](0, false);
    }

    var data = buffer instanceof ArrayBuffer ? new Uint8Array(buffer) : buffer;
    var boxInfo;
    var lastCompletedOffset = 0;

    while (offset < data.byteLength) {
      var boxSize = parseUint32(data, offset);
      var boxType = parseIsoBoxType(data, offset + 4);

      if (boxSize === 0) {
        break;
      }

      if (offset + boxSize <= data.byteLength) {
        if (types.indexOf(boxType) >= 0) {
          boxInfo = new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](offset, true, boxSize);
        } else {
          lastCompletedOffset = offset + boxSize;
        }
      }

      offset += boxSize;
    }

    if (!boxInfo) {
      return new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](lastCompletedOffset, false);
    }

    return boxInfo;
  }

  function getSamplesInfo(ab) {
    if (!ab || ab.byteLength === 0) {
      return {
        sampleList: [],
        lastSequenceNumber: NaN,
        totalDuration: NaN,
        numSequences: NaN
      };
    }

    var isoFile = parse(ab); // zero or more moofs

    var moofBoxes = isoFile.getBoxes('moof'); // exactly one mfhd per moof

    var mfhdBoxes = isoFile.getBoxes('mfhd');
    var sampleDuration, sampleCompositionTimeOffset, sampleCount, sampleSize, sampleDts, sampleList, sample, i, j, k, l, m, n, dataOffset, lastSequenceNumber, numSequences, totalDuration;
    numSequences = isoFile.getBoxes('moof').length;
    lastSequenceNumber = mfhdBoxes[mfhdBoxes.length - 1].sequence_number;
    sampleCount = 0;
    sampleList = [];
    var subsIndex = -1;
    var nextSubsSample = -1;

    for (l = 0; l < moofBoxes.length; l++) {
      var moofBox = moofBoxes[l]; // zero or more trafs per moof

      var trafBoxes = moofBox.getChildBoxes('traf');

      for (j = 0; j < trafBoxes.length; j++) {
        var trafBox = trafBoxes[j]; // exactly one tfhd per traf

        var tfhdBox = trafBox.getChildBox('tfhd'); // zero or one tfdt per traf

        var tfdtBox = trafBox.getChildBox('tfdt');
        sampleDts = tfdtBox.baseMediaDecodeTime; // zero or more truns per traf

        var trunBoxes = trafBox.getChildBoxes('trun'); // zero or more subs per traf

        var subsBoxes = trafBox.getChildBoxes('subs');

        for (k = 0; k < trunBoxes.length; k++) {
          var trunBox = trunBoxes[k];
          sampleCount = trunBox.sample_count;
          dataOffset = (tfhdBox.base_data_offset || 0) + (trunBox.data_offset || 0);

          for (i = 0; i < sampleCount; i++) {
            sample = trunBox.samples[i];
            sampleDuration = sample.sample_duration !== undefined ? sample.sample_duration : tfhdBox.default_sample_duration;
            sampleSize = sample.sample_size !== undefined ? sample.sample_size : tfhdBox.default_sample_size;
            sampleCompositionTimeOffset = sample.sample_composition_time_offset !== undefined ? sample.sample_composition_time_offset : 0;
            var sampleData = {
              'dts': sampleDts,
              'cts': sampleDts + sampleCompositionTimeOffset,
              'duration': sampleDuration,
              'offset': moofBox.offset + dataOffset,
              'size': sampleSize,
              'subSizes': [sampleSize]
            };

            if (subsBoxes) {
              for (m = 0; m < subsBoxes.length; m++) {
                var subsBox = subsBoxes[m];

                if (subsIndex < subsBox.entry_count - 1 && i > nextSubsSample) {
                  subsIndex++;
                  nextSubsSample += subsBox.entries[subsIndex].sample_delta;
                }

                if (i == nextSubsSample) {
                  sampleData.subSizes = [];
                  var entry = subsBox.entries[subsIndex];

                  for (n = 0; n < entry.subsample_count; n++) {
                    sampleData.subSizes.push(entry.subsamples[n].subsample_size);
                  }
                }
              }
            }

            sampleList.push(sampleData);
            dataOffset += sampleSize;
            sampleDts += sampleDuration;
          }
        }

        totalDuration = sampleDts - tfdtBox.baseMediaDecodeTime;
      }
    }

    return {
      sampleList: sampleList,
      lastSequenceNumber: lastSequenceNumber,
      totalDuration: totalDuration,
      numSequences: numSequences
    };
  }

  function getMediaTimescaleFromMoov(ab) {
    var isoFile = parse(ab);
    var mdhdBox = isoFile ? isoFile.getBox('mdhd') : undefined;
    return mdhdBox ? mdhdBox.timescale : NaN;
  }

  function parseUint32(data, offset) {
    return data[offset + 3] >>> 0 | data[offset + 2] << 8 >>> 0 | data[offset + 1] << 16 >>> 0 | data[offset] << 24 >>> 0;
  }

  function parseIsoBoxType(data, offset) {
    return String.fromCharCode(data[offset++]) + String.fromCharCode(data[offset++]) + String.fromCharCode(data[offset++]) + String.fromCharCode(data[offset]);
  }

  function findInitRange(data) {
    var initRange = null;
    var start, end;
    var isoFile = parse(data);

    if (!isoFile) {
      return initRange;
    }

    var ftyp = isoFile.getBox('ftyp');
    var moov = isoFile.getBox('moov');
    logger.debug('Searching for initialization.');

    if (moov && moov.isComplete) {
      start = ftyp ? ftyp.offset : moov.offset;
      end = moov.offset + moov.size - 1;
      initRange = start + '-' + end;
      logger.debug('Found the initialization.  Range: ' + initRange);
    }

    return initRange;
  }
  /**
   * Real-time parsing (whenever data is loaded in the buffer payload) of the payload to capture the moof of a chunk
   * @param {array} types
   * @param {ArrayBuffer} buffer
   * @param {number} offset
   * @return {IsoBoxSearchInfo}
   */


  function parsePayload(types, buffer, offset) {
    if (offset === undefined) {
      offset = 0;
    }

    if (!buffer || offset + 8 >= buffer.byteLength) {
      return new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](0, false);
    }

    var data = buffer instanceof ArrayBuffer ? new Uint8Array(buffer) : buffer;
    var boxInfo;
    var lastCompletedOffset = 0;

    while (offset < data.byteLength) {
      var boxSize = parseUint32(data, offset);
      var boxType = parseIsoBoxType(data, offset + 4);

      if (boxSize === 0) {
        break;
      }

      if (offset + boxSize <= data.byteLength) {
        if (types.indexOf(boxType) >= 0) {
          boxInfo = new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](offset, true, boxSize, boxType);
        } else {
          lastCompletedOffset = offset + boxSize;
        }
      }

      offset += boxSize;
    }

    if (!boxInfo) {
      return new _vo_IsoBoxSearchInfo__WEBPACK_IMPORTED_MODULE_4__["default"](lastCompletedOffset, false);
    }

    return boxInfo;
  }

  instance = {
    parse: parse,
    findLastTopIsoBoxCompleted: findLastTopIsoBoxCompleted,
    getMediaTimescaleFromMoov: getMediaTimescaleFromMoov,
    getSamplesInfo: getSamplesInfo,
    findInitRange: findInitRange,
    parsePayload: parsePayload
  };
  setup();
  return instance;
}

BoxParser.__dashjs_factory_name = 'BoxParser';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(BoxParser));

/***/ }),

/***/ "./src/streaming/utils/DefaultURLUtils.js":
/*!************************************************!*\
  !*** ./src/streaming/utils/DefaultURLUtils.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module DefaultURLUtils
 * @description Provides utility functions for operating on URLs.
 * Initially this is simply a method to determine the Base URL of a URL, but
 * should probably include other things provided all over the place such as
 * determining whether a URL is relative/absolute, resolving two paths etc.
 * @ignore
 */

function DefaultURLUtils() {
  var resolveFunction;
  var schemeRegex = /^[a-z][a-z0-9+\-_.]*:/i;
  var httpUrlRegex = /^https?:\/\//i;
  var httpsUrlRegex = /^https:\/\//i;
  var originRegex = /^([a-z][a-z0-9+\-_.]*:\/\/[^\/]+)\/?/i;
  /**
   * Resolves a url given an optional base url
   * Uses window.URL to do the resolution.
   *
   * @param {string} url
   * @param {string} [baseUrl]
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   * @private
   */

  var nativeURLResolver = function nativeURLResolver(url, baseUrl) {
    try {
      return new window.URL(url, baseUrl).toString();
    } catch (e) {
      return url;
    }
  };
  /**
   * Resolves a url given an optional base url
   * Does not resolve ./, ../ etc but will do enough to construct something
   * which will satisfy XHR etc when window.URL is not available ie
   * IE11/node etc.
   *
   * @param {string} url
   * @param {string} [baseUrl]
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   * @private
   */


  var dumbURLResolver = function dumbURLResolver(url, baseUrl) {
    var baseUrlParseFunc = parseBaseUrl;

    if (!baseUrl) {
      return url;
    }

    if (!isRelative(url)) {
      return url;
    }

    if (isPathAbsolute(url)) {
      baseUrlParseFunc = parseOrigin;
    }

    if (isSchemeRelative(url)) {
      baseUrlParseFunc = parseScheme;
    }

    var base = baseUrlParseFunc(baseUrl);
    var joinChar = base.charAt(base.length - 1) !== '/' && url.charAt(0) !== '/' ? '/' : '';
    return [base, url].join(joinChar);
  };

  function setup() {
    try {
      var u = new window.URL('x', 'http://y'); // eslint-disable-line

      resolveFunction = nativeURLResolver;
    } catch (e) {// must be IE11/Node etc
    } finally {
      resolveFunction = resolveFunction || dumbURLResolver;
    }
  }
  /**
   * Returns a string that contains the Base URL of a URL, if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function parseBaseUrl(url) {
    var slashIndex = url.indexOf('/');
    var lastSlashIndex = url.lastIndexOf('/');

    if (slashIndex !== -1) {
      // if there is only '//'
      if (lastSlashIndex === slashIndex + 1) {
        return url;
      }

      if (url.indexOf('?') !== -1) {
        url = url.substring(0, url.indexOf('?'));
      }

      return url.substring(0, lastSlashIndex + 1);
    }

    return '';
  }
  /**
   * Returns a string that contains the scheme and origin of a URL,
   * if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function parseOrigin(url) {
    var matches = url.match(originRegex);

    if (matches) {
      return matches[1];
    }

    return '';
  }
  /**
   * Returns a string that contains the fragment of a URL without scheme,
   * if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function removeHostname(url) {
    var urlParts = /^(?:\w+\:\/\/)?([^\/]+)(.*)$/.exec(url); //[1] = host / [2] = path

    return urlParts[2].substring(1);
  }
  /**
   * Returns a string that contains the scheme of a URL, if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function parseScheme(url) {
    var matches = url.match(schemeRegex);

    if (matches) {
      return matches[0];
    }

    return '';
  }
  /**
   * Determines whether the url is relative.
   * @return {boolean}
   * @param {string} url
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function isRelative(url) {
    return !schemeRegex.test(url);
  }
  /**
   * Determines whether the url is path-absolute.
   * @return {bool}
   * @param {string} url
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function isPathAbsolute(url) {
    return isRelative(url) && url.charAt(0) === '/';
  }
  /**
   * Determines whether the url is scheme-relative.
   * @return {bool}
   * @param {string} url
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function isSchemeRelative(url) {
    return url.indexOf('//') === 0;
  }
  /**
   * Determines whether the url is an HTTP-URL as defined in ISO/IEC
   * 23009-1:2014 3.1.15. ie URL with a fixed scheme of http or https
   * @return {bool}
   * @param {string} url
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function isHTTPURL(url) {
    return httpUrlRegex.test(url);
  }
  /**
   * Determines whether the supplied url has https scheme
   * @return {bool}
   * @param {string} url
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function isHTTPS(url) {
    return httpsUrlRegex.test(url);
  }
  /**
   * Resolves a url given an optional base url
   * @return {string}
   * @param {string} url
   * @param {string} [baseUrl]
   * @memberof module:DefaultURLUtils
   * @instance
   */


  function resolve(url, baseUrl) {
    return resolveFunction(url, baseUrl);
  }

  setup();
  var instance = {
    parseBaseUrl: parseBaseUrl,
    parseOrigin: parseOrigin,
    parseScheme: parseScheme,
    isRelative: isRelative,
    isPathAbsolute: isPathAbsolute,
    isSchemeRelative: isSchemeRelative,
    isHTTPURL: isHTTPURL,
    isHTTPS: isHTTPS,
    removeHostname: removeHostname,
    resolve: resolve
  };
  return instance;
}

DefaultURLUtils.__dashjs_factory_name = 'DefaultURLUtils';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(DefaultURLUtils));

/***/ }),

/***/ "./src/streaming/utils/IsoFile.js":
/*!****************************************!*\
  !*** ./src/streaming/utils/IsoFile.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _vo_IsoBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vo/IsoBox */ "./src/streaming/vo/IsoBox.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



function IsoFile() {
  var instance, parsedIsoFile;
  /**
  * @param {string} type
  * @returns {IsoBox|null}
  * @memberof IsoFile#
  */

  function getBox(type) {
    if (!type || !parsedIsoFile || !parsedIsoFile.boxes || parsedIsoFile.boxes.length === 0 || typeof parsedIsoFile.fetch !== 'function') return null;
    return convertToDashIsoBox(parsedIsoFile.fetch(type));
  }
  /**
  * @param {string} type
  * @returns {Array|null} array of {@link IsoBox}
  * @memberof IsoFile#
  */


  function getBoxes(type) {
    var boxes = [];

    if (!type || !parsedIsoFile || typeof parsedIsoFile.fetchAll !== 'function') {
      return boxes;
    }

    var boxData = parsedIsoFile.fetchAll(type);
    var box;

    for (var i = 0, ln = boxData.length; i < ln; i++) {
      box = convertToDashIsoBox(boxData[i]);

      if (box) {
        boxes.push(box);
      }
    }

    return boxes;
  }
  /**
  * @param {string} value
  * @memberof IsoFile#
  */


  function setData(value) {
    parsedIsoFile = value;
  }
  /**
  * @returns {IsoBox|null}
  * @memberof IsoFile#
  */


  function getLastBox() {
    if (!parsedIsoFile || !parsedIsoFile.boxes || !parsedIsoFile.boxes.length) return null;
    var type = parsedIsoFile.boxes[parsedIsoFile.boxes.length - 1].type;
    var boxes = getBoxes(type);
    return boxes.length > 0 ? boxes[boxes.length - 1] : null;
  }

  function convertToDashIsoBox(boxData) {
    if (!boxData) return null;
    var box = new _vo_IsoBox__WEBPACK_IMPORTED_MODULE_0__["default"](boxData);

    if (boxData.hasOwnProperty('_incomplete')) {
      box.isComplete = !boxData._incomplete;
    }

    return box;
  }

  instance = {
    getBox: getBox,
    getBoxes: getBoxes,
    setData: setData,
    getLastBox: getLastBox
  };
  return instance;
}

IsoFile.__dashjs_factory_name = 'IsoFile';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(IsoFile));

/***/ }),

/***/ "./src/streaming/utils/ObjectUtils.js":
/*!********************************************!*\
  !*** ./src/streaming/utils/ObjectUtils.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var fast_deep_equal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! fast-deep-equal */ "./node_modules/fast-deep-equal/index.js");
/* harmony import */ var fast_deep_equal__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal__WEBPACK_IMPORTED_MODULE_1__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @module ObjectUtils
 * @ignore
 * @description Provides utility functions for objects
 */

function ObjectUtils() {
  var instance;
  /**
   * Returns true if objects are equal
   * @return {boolean}
   * @param {object} obj1
   * @param {object} obj2
   * @memberof module:ObjectUtils
   * @instance
   */

  function areEqual(obj1, obj2) {
    return fast_deep_equal__WEBPACK_IMPORTED_MODULE_1___default()(obj1, obj2);
  }

  instance = {
    areEqual: areEqual
  };
  return instance;
}

ObjectUtils.__dashjs_factory_name = 'ObjectUtils';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(ObjectUtils));

/***/ }),

/***/ "./src/streaming/utils/RequestModifier.js":
/*!************************************************!*\
  !*** ./src/streaming/utils/RequestModifier.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "modifyRequest": () => (/* binding */ modifyRequest)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

function modifyRequest(httpRequest, requestModifier) {
  var request = {
    url: httpRequest.url,
    method: httpRequest.method,
    headers: Object.assign({}, httpRequest.headers),
    credentials: httpRequest.withCredentials ? 'include' : undefined
  };
  return Promise.resolve(requestModifier.modifyRequest(request)).then(function () {
    return Object.assign(httpRequest, request, {
      withCredentials: request.credentials === 'include'
    });
  });
}

function RequestModifier() {
  var instance;

  function modifyRequestURL(url) {
    return url;
  } // eslint-disable-next-line no-unused-vars


  function modifyRequestHeader(request, _ref) {
    var url = _ref.url;
    return request;
  }

  instance = {
    modifyRequest: null,
    modifyRequestURL: modifyRequestURL,
    modifyRequestHeader: modifyRequestHeader
  };
  return instance;
}

RequestModifier.__dashjs_factory_name = 'RequestModifier';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(RequestModifier));

/***/ }),

/***/ "./src/streaming/utils/SupervisorTools.js":
/*!************************************************!*\
  !*** ./src/streaming/utils/SupervisorTools.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "checkInteger": () => (/* binding */ checkInteger),
/* harmony export */   "checkIsVideoOrAudioType": () => (/* binding */ checkIsVideoOrAudioType),
/* harmony export */   "checkParameterType": () => (/* binding */ checkParameterType),
/* harmony export */   "checkRange": () => (/* binding */ checkRange)
/* harmony export */ });
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

function checkParameterType(parameter, type) {
  if (_typeof(parameter) !== type) {
    throw _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].BAD_ARGUMENT_ERROR;
  }
}
function checkInteger(parameter) {
  var isInt = parameter !== null && !isNaN(parameter) && parameter % 1 === 0;

  if (!isInt) {
    throw _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].BAD_ARGUMENT_ERROR + ' : argument is not an integer';
  }
}
function checkRange(parameter, min, max) {
  if (parameter < min || parameter > max) {
    throw _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].BAD_ARGUMENT_ERROR + ' : argument out of range';
  }
}
function checkIsVideoOrAudioType(type) {
  if (typeof type !== 'string' || type !== _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO && type !== _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO) {
    throw _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].BAD_ARGUMENT_ERROR;
  }
}

/***/ }),

/***/ "./src/streaming/utils/URLUtils.js":
/*!*****************************************!*\
  !*** ./src/streaming/utils/URLUtils.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _DefaultURLUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DefaultURLUtils */ "./src/streaming/utils/DefaultURLUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * @module URLUtils
 * @ignore
 * @description Provides utility functions for operating on URLs.
 * Initially this is simply a method to determine the Base URL of a URL, but
 * should probably include other things provided all over the place such as
 * determining whether a URL is relative/absolute, resolving two paths etc.
 */

function URLUtils() {
  var instance;
  var defaultURLUtils;
  var regexUtils = [];
  var context = this.context;

  function getUtils(url) {
    var i;

    for (i = 0; i < regexUtils.length; i++) {
      var regex = regexUtils[i].regex;

      if (regex.test(url)) {
        return regexUtils[i].utils;
      }
    }

    return defaultURLUtils;
  }

  function setup() {
    defaultURLUtils = (0,_DefaultURLUtils__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance();
  }
  /**
   * Register a module to handle specific url.
   * @param {regex} regex - url regex
   * @param {object} utils - object that handles the regex
   * @memberof module:URLUtils
   * @instance
   */


  function registerUrlRegex(regex, utils) {
    regexUtils.push({
      regex: regex,
      utils: utils
    });
  }

  function internalCall(functionName, url, baseUrl) {
    var utils = getUtils(baseUrl || url);
    return utils && typeof utils[functionName] === 'function' ? utils[functionName](url, baseUrl) : defaultURLUtils[functionName](url, baseUrl);
  }
  /**
   * Returns a string that contains the Base URL of a URL, if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:URLUtils
   * @instance
   */


  function parseBaseUrl(url) {
    return internalCall('parseBaseUrl', url);
  }
  /**
   * Returns a string that contains the scheme and origin of a URL,
   * if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:URLUtils
   * @instance
   */


  function parseOrigin(url) {
    return internalCall('parseOrigin', url);
  }
  /**
   * Returns a string that contains the fragment of a URL without scheme,
   * if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:URLUtils
   * @instance
   */


  function removeHostname(url) {
    return internalCall('removeHostname', url);
  }
  /**
   * Returns a string that contains the scheme of a URL, if determinable.
   * @param {string} url - full url
   * @return {string}
   * @memberof module:URLUtils
   * @instance
   */


  function parseScheme(url) {
    return internalCall('parseScheme', url);
  }
  /**
   * Determines whether the url is relative.
   * @return {boolean}
   * @param {string} url
   * @memberof module:URLUtils
   * @instance
   */


  function isRelative(url) {
    return internalCall('isRelative', url);
  }
  /**
   * Determines whether the url is path-absolute.
   * @return {bool}
   * @param {string} url
   * @memberof module:URLUtils
   * @instance
   */


  function isPathAbsolute(url) {
    return internalCall('isPathAbsolute', url);
  }
  /**
   * Determines whether the url is scheme-relative.
   * @return {bool}
   * @param {string} url
   * @memberof module:URLUtils
   * @instance
   */


  function isSchemeRelative(url) {
    return internalCall('isSchemeRelative', url);
  }
  /**
   * Determines whether the url is an HTTP-URL as defined in ISO/IEC
   * 23009-1:2014 3.1.15. ie URL with a fixed scheme of http or https
   * @return {bool}
   * @param {string} url
   * @memberof module:URLUtils
   * @instance
   */


  function isHTTPURL(url) {
    return internalCall('isHTTPURL', url);
  }
  /**
   * Determines whether the supplied url has https scheme
   * @return {bool}
   * @param {string} url
   * @memberof module:URLUtils
   * @instance
   */


  function isHTTPS(url) {
    return internalCall('isHTTPS', url);
  }
  /**
   * Resolves a url given an optional base url
   * @return {string}
   * @param {string} url
   * @param {string} [baseUrl]
   * @memberof module:URLUtils
   * @instance
   */


  function resolve(url, baseUrl) {
    return internalCall('resolve', url, baseUrl);
  }

  setup();
  instance = {
    registerUrlRegex: registerUrlRegex,
    parseBaseUrl: parseBaseUrl,
    parseOrigin: parseOrigin,
    parseScheme: parseScheme,
    isRelative: isRelative,
    isPathAbsolute: isPathAbsolute,
    isSchemeRelative: isSchemeRelative,
    isHTTPURL: isHTTPURL,
    isHTTPS: isHTTPS,
    removeHostname: removeHostname,
    resolve: resolve
  };
  return instance;
}

URLUtils.__dashjs_factory_name = 'URLUtils';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(URLUtils);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (factory);

/***/ }),

/***/ "./src/streaming/vo/DashJSError.js":
/*!*****************************************!*\
  !*** ./src/streaming/vo/DashJSError.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var DashJSError = function DashJSError(code, message, data) {
  _classCallCheck(this, DashJSError);

  this.code = code || null;
  this.message = message || null;
  this.data = data || null;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DashJSError);

/***/ }),

/***/ "./src/streaming/vo/FragmentRequest.js":
/*!*********************************************!*\
  !*** ./src/streaming/vo/FragmentRequest.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */

var FragmentRequest = /*#__PURE__*/function () {
  function FragmentRequest(url) {
    _classCallCheck(this, FragmentRequest);

    this.action = FragmentRequest.ACTION_DOWNLOAD;
    this.startTime = NaN;
    this.mediaStartTime = NaN;
    this.mediaType = null;
    this.mediaInfo = null;
    this.type = null;
    this.duration = NaN;
    this.timescale = NaN;
    this.range = null;
    this.url = url || null;
    this.serviceLocation = null;
    this.requestStartDate = null;
    this.firstByteDate = null;
    this.requestEndDate = null;
    this.quality = NaN;
    this.index = NaN;
    this.availabilityStartTime = null;
    this.availabilityEndTime = null;
    this.wallStartTime = null;
    this.bytesLoaded = NaN;
    this.bytesTotal = NaN;
    this.delayLoadingTime = NaN;
    this.responseType = 'arraybuffer';
    this.representationId = null;
  }

  _createClass(FragmentRequest, [{
    key: "isInitializationRequest",
    value: function isInitializationRequest() {
      return this.type && this.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__.HTTPRequest.INIT_SEGMENT_TYPE;
    }
  }, {
    key: "setInfo",
    value: function setInfo(info) {
      this.type = info && info.init ? _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__.HTTPRequest.INIT_SEGMENT_TYPE : _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__.HTTPRequest.MEDIA_SEGMENT_TYPE;
      this.url = info && info.url ? info.url : null;
      this.range = info && info.range ? info.range.start + '-' + info.range.end : null;
      this.mediaType = info && info.mediaType ? info.mediaType : null;
    }
  }]);

  return FragmentRequest;
}();

FragmentRequest.ACTION_DOWNLOAD = 'download';
FragmentRequest.ACTION_COMPLETE = 'complete';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FragmentRequest);

/***/ }),

/***/ "./src/streaming/vo/HeadRequest.js":
/*!*****************************************!*\
  !*** ./src/streaming/vo/HeadRequest.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FragmentRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var HeadRequest = /*#__PURE__*/function (_FragmentRequest) {
  _inherits(HeadRequest, _FragmentRequest);

  var _super = _createSuper(HeadRequest);

  function HeadRequest(url) {
    var _this;

    _classCallCheck(this, HeadRequest);

    _this = _super.call(this, url);
    _this.checkForExistenceOnly = true;
    return _this;
  }

  return HeadRequest;
}(_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeadRequest);

/***/ }),

/***/ "./src/streaming/vo/IsoBox.js":
/*!************************************!*\
  !*** ./src/streaming/vo/IsoBox.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var IsoBox = /*#__PURE__*/function () {
  function IsoBox(boxData) {
    _classCallCheck(this, IsoBox);

    this.offset = boxData._offset;
    this.type = boxData.type;
    this.size = boxData.size;
    this.boxes = [];

    if (boxData.boxes) {
      for (var i = 0; i < boxData.boxes.length; i++) {
        this.boxes.push(new IsoBox(boxData.boxes[i]));
      }
    }

    this.isComplete = true;

    switch (boxData.type) {
      case 'sidx':
        this.timescale = boxData.timescale;
        this.earliest_presentation_time = boxData.earliest_presentation_time;
        this.first_offset = boxData.first_offset;
        this.references = boxData.references;

        if (boxData.references) {
          this.references = [];

          for (var _i = 0; _i < boxData.references.length; _i++) {
            var reference = {
              reference_type: boxData.references[_i].reference_type,
              referenced_size: boxData.references[_i].referenced_size,
              subsegment_duration: boxData.references[_i].subsegment_duration
            };
            this.references.push(reference);
          }
        }

        break;

      case 'emsg':
        this.id = boxData.id;
        this.version = boxData.version === 1 ? 1 : 0;
        this.value = boxData.value;
        this.timescale = boxData.timescale;
        this.scheme_id_uri = boxData.scheme_id_uri;
        this.presentation_time_delta = boxData.version === 1 ? boxData.presentation_time : boxData.presentation_time_delta;
        this.event_duration = boxData.event_duration;
        this.message_data = boxData.message_data;
        break;

      case 'mdhd':
        this.timescale = boxData.timescale;
        break;

      case 'mfhd':
        this.sequence_number = boxData.sequence_number;
        break;

      case 'subs':
        this.entry_count = boxData.entry_count;
        this.entries = boxData.entries;
        break;

      case 'tfhd':
        this.base_data_offset = boxData.base_data_offset;
        this.sample_description_index = boxData.sample_description_index;
        this.default_sample_duration = boxData.default_sample_duration;
        this.default_sample_size = boxData.default_sample_size;
        this.default_sample_flags = boxData.default_sample_flags;
        this.flags = boxData.flags;
        break;

      case 'tfdt':
        this.version = boxData.version;
        this.baseMediaDecodeTime = boxData.baseMediaDecodeTime;
        this.flags = boxData.flags;
        break;

      case 'trun':
        this.sample_count = boxData.sample_count;
        this.first_sample_flags = boxData.first_sample_flags;
        this.data_offset = boxData.data_offset;
        this.flags = boxData.flags;
        this.samples = boxData.samples;

        if (boxData.samples) {
          this.samples = [];

          for (var _i2 = 0, ln = boxData.samples.length; _i2 < ln; _i2++) {
            var sample = {
              sample_size: boxData.samples[_i2].sample_size,
              sample_duration: boxData.samples[_i2].sample_duration,
              sample_composition_time_offset: boxData.samples[_i2].sample_composition_time_offset
            };
            this.samples.push(sample);
          }
        }

        break;
    }
  }

  _createClass(IsoBox, [{
    key: "getChildBox",
    value: function getChildBox(type) {
      for (var i = 0; i < this.boxes.length; i++) {
        if (this.boxes[i].type === type) {
          return this.boxes[i];
        }
      }
    }
  }, {
    key: "getChildBoxes",
    value: function getChildBoxes(type) {
      var boxes = [];

      for (var i = 0; i < this.boxes.length; i++) {
        if (this.boxes[i].type === type) {
          boxes.push(this.boxes[i]);
        }
      }

      return boxes;
    }
  }]);

  return IsoBox;
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IsoBox);

/***/ }),

/***/ "./src/streaming/vo/IsoBoxSearchInfo.js":
/*!**********************************************!*\
  !*** ./src/streaming/vo/IsoBoxSearchInfo.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var IsoBoxSearchInfo = function IsoBoxSearchInfo(lastCompletedOffset, found, size) {
  _classCallCheck(this, IsoBoxSearchInfo);

  this.lastCompletedOffset = lastCompletedOffset;
  this.found = found;
  this.size = size;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IsoBoxSearchInfo);

/***/ }),

/***/ "./src/streaming/vo/ThumbnailTrackInfo.js":
/*!************************************************!*\
  !*** ./src/streaming/vo/ThumbnailTrackInfo.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ThumbnailTrackInfo = function ThumbnailTrackInfo() {
  _classCallCheck(this, ThumbnailTrackInfo);

  this.bitrate = 0;
  this.width = 0;
  this.height = 0;
  this.tilesHor = 0;
  this.tilesVert = 0;
  this.widthPerTile = 0;
  this.heightPerTile = 0;
  this.startNumber = 0;
  this.segmentDuration = 0;
  this.timescale = 0;
  this.templateUrl = '';
  this.id = '';
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ThumbnailTrackInfo);

/***/ }),

/***/ "./src/streaming/vo/metrics/HTTPRequest.js":
/*!*************************************************!*\
  !*** ./src/streaming/vo/metrics/HTTPRequest.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HTTPRequest": () => (/* binding */ HTTPRequest),
/* harmony export */   "HTTPRequestTrace": () => (/* binding */ HTTPRequestTrace)
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc This Object holds reference to the HTTPRequest for manifest, fragment and xlink loading.
 * Members which are not defined in ISO23009-1 Annex D should be prefixed by a _ so that they are ignored
 * by Metrics Reporting code.
 * @ignore
 */
var HTTPRequest =
/**
 * @class
 */
function HTTPRequest() {
  _classCallCheck(this, HTTPRequest);

  /**
   * Identifier of the TCP connection on which the HTTP request was sent.
   * @public
   */
  this.tcpid = null;
  /**
   * This is an optional parameter and should not be included in HTTP request/response transactions for progressive download.
   * The type of the request:
   * - MPD
   * - XLink expansion
   * - Initialization Fragment
   * - Index Fragment
   * - Media Fragment
   * - Bitstream Switching Fragment
   * - other
   * @public
   */

  this.type = null;
  /**
   * The original URL (before any redirects or failures)
   * @public
   */

  this.url = null;
  /**
   * The actual URL requested, if different from above
   * @public
   */

  this.actualurl = null;
  /**
   * The contents of the byte-range-spec part of the HTTP Range header.
   * @public
   */

  this.range = null;
  /**
   * Real-Time | The real time at which the request was sent.
   * @public
   */

  this.trequest = null;
  /**
   * Real-Time | The real time at which the first byte of the response was received.
   * @public
   */

  this.tresponse = null;
  /**
   * The HTTP response code.
   * @public
   */

  this.responsecode = null;
  /**
   * The duration of the throughput trace intervals (ms), for successful requests only.
   * @public
   */

  this.interval = null;
  /**
   * Throughput traces, for successful requests only.
   * @public
   */

  this.trace = [];
  /**
   * The CMSD static and dynamic values retrieved from CMSD response headers.
   * @public
   */

  this.cmsd = null;
  /**
   * Type of stream ("audio" | "video" etc..)
   * @public
   */

  this._stream = null;
  /**
   * Real-Time | The real time at which the request finished.
   * @public
   */

  this._tfinish = null;
  /**
   * The duration of the media requests, if available, in seconds.
   * @public
   */

  this._mediaduration = null;
  /**
   * The media segment quality
   * @public
   */

  this._quality = null;
  /**
   * all the response headers from request.
   * @public
   */

  this._responseHeaders = null;
  /**
   * The selected service location for the request. string.
   * @public
   */

  this._serviceLocation = null;
  /**
   * The type of the loader that was used. Distinguish between fetch loader and xhr loader
   */

  this._fileLoaderType = null;
};
/**
 * @classdesc This Object holds reference to the progress of the HTTPRequest.
 * @ignore
 */


var HTTPRequestTrace =
/**
 * @class
 */
function HTTPRequestTrace() {
  _classCallCheck(this, HTTPRequestTrace);

  /**
   * Real-Time | Measurement stream start.
   * @public
   */
  this.s = null;
  /**
   * Measurement stream duration (ms).
   * @public
   */

  this.d = null;
  /**
   * List of integers counting the bytes received in each trace interval within the measurement stream.
   * @public
   */

  this.b = [];
};

HTTPRequest.GET = 'GET';
HTTPRequest.HEAD = 'HEAD';
HTTPRequest.MPD_TYPE = 'MPD';
HTTPRequest.XLINK_EXPANSION_TYPE = 'XLinkExpansion';
HTTPRequest.INIT_SEGMENT_TYPE = 'InitializationSegment';
HTTPRequest.INDEX_SEGMENT_TYPE = 'IndexSegment';
HTTPRequest.MEDIA_SEGMENT_TYPE = 'MediaSegment';
HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE = 'BitstreamSwitchingSegment';
HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE = 'FragmentInfoSegment';
HTTPRequest.DVB_REPORTING_TYPE = 'DVBReporting';
HTTPRequest.LICENSE = 'license';
HTTPRequest.CONTENT_STEERING_TYPE = 'ContentSteering';
HTTPRequest.OTHER_TYPE = 'other';


/***/ }),

/***/ "./node_modules/bcp-47-match/index.js":
/*!********************************************!*\
  !*** ./node_modules/bcp-47-match/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// See https://tools.ietf.org/html/rfc4647#section-3.1
// for more information on the algorithms.

exports.basicFilter = factory(basic, true)
exports.extendedFilter = factory(extended, true)
exports.lookup = factory(lookup)

// Basic Filtering (Section 3.3.1) matches a language priority list consisting
// of basic language ranges (Section 2.1) to sets of language tags.
function basic(tag, range) {
  return range === '*' || tag === range || tag.indexOf(range + '-') > -1
}

// Extended Filtering (Section 3.3.2) matches a language priority list
// consisting of extended language ranges (Section 2.2) to sets of language
// tags.
function extended(tag, range) {
  // 3.3.2.1
  var left = tag.split('-')
  var right = range.split('-')
  var leftIndex = 0
  var rightIndex = 0

  // 3.3.2.2
  if (right[rightIndex] !== '*' && left[leftIndex] !== right[rightIndex]) {
    return false
  }

  leftIndex++
  rightIndex++

  // 3.3.2.3
  while (rightIndex < right.length) {
    // 3.3.2.3.A
    if (right[rightIndex] === '*') {
      rightIndex++
      continue
    }

    // 3.3.2.3.B
    if (!left[leftIndex]) return false

    // 3.3.2.3.C
    if (left[leftIndex] === right[rightIndex]) {
      leftIndex++
      rightIndex++
      continue
    }

    // 3.3.2.3.D
    if (left[leftIndex].length === 1) return false

    // 3.3.2.3.E
    leftIndex++
  }

  // 3.3.2.4
  return true
}

// Lookup (Section 3.4) matches a language priority list consisting of basic
// language ranges to sets of language tags to find the one exact language tag
// that best matches the range.
function lookup(tag, range) {
  var right = range
  var index

  /* eslint-disable-next-line no-constant-condition */
  while (true) {
    if (right === '*' || tag === right) return true

    index = right.lastIndexOf('-')

    if (index < 0) return false

    if (right.charAt(index - 2) === '-') index -= 2

    right = right.slice(0, index)
  }
}

// Factory to perform a filter or a lookup.
// This factory creates a function that accepts a list of tags and a list of
// ranges, and contains logic to exit early for lookups.
// `check` just has to deal with one tag and one range.
// This match function iterates over ranges, and for each range,
// iterates over tags.  That way, earlier ranges matching any tag have
// precedence over later ranges.
function factory(check, filter) {
  return match

  function match(tags, ranges) {
    var left = cast(tags, 'tag')
    var right = cast(ranges == null ? '*' : ranges, 'range')
    var matches = []
    var rightIndex = -1
    var range
    var leftIndex
    var next

    while (++rightIndex < right.length) {
      range = right[rightIndex].toLowerCase()

      // Ignore wildcards in lookup mode.
      if (!filter && range === '*') continue

      leftIndex = -1
      next = []

      while (++leftIndex < left.length) {
        if (check(left[leftIndex].toLowerCase(), range)) {
          // Exit if this is a lookup and we have a match.
          if (!filter) return left[leftIndex]
          matches.push(left[leftIndex])
        } else {
          next.push(left[leftIndex])
        }
      }

      left = next
    }

    // If this is a filter, return the list.  If it’s a lookup, we didn’t find
    // a match, so return `undefined`.
    return filter ? matches : undefined
  }
}

// Validate tags or ranges, and cast them to arrays.
function cast(values, name) {
  var value = values && typeof values === 'string' ? [values] : values

  if (!value || typeof value !== 'object' || !('length' in value)) {
    throw new Error(
      'Invalid ' + name + ' `' + value + '`, expected non-empty string'
    )
  }

  return value
}


/***/ }),

/***/ "./node_modules/bcp-47-normalize/index.js":
/*!************************************************!*\
  !*** ./node_modules/bcp-47-normalize/index.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


module.exports = __webpack_require__(/*! ./lib */ "./node_modules/bcp-47-normalize/lib/index.js")


/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/index.js":
/*!****************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/index.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bcp47 = __webpack_require__(/*! bcp-47 */ "./node_modules/bcp-47/index.js")
var match = __webpack_require__(/*! bcp-47-match */ "./node_modules/bcp-47-match/index.js")
var matches = __webpack_require__(/*! ./matches.json */ "./node_modules/bcp-47-normalize/lib/matches.json")
var fields = __webpack_require__(/*! ./fields.json */ "./node_modules/bcp-47-normalize/lib/fields.json")
var defaults = __webpack_require__(/*! ./defaults.json */ "./node_modules/bcp-47-normalize/lib/defaults.json")
var many = __webpack_require__(/*! ./many.json */ "./node_modules/bcp-47-normalize/lib/many.json")

module.exports = normalize

var own = {}.hasOwnProperty

var collator = new Intl.Collator()

var emptyExtraFields = {
  variants: [],
  extensions: [],
  privateuse: [],
  irregular: null,
  regular: null
}

function normalize(value, options) {
  var settings = options || {}
  // 1. normalize and lowercase the tag (`sgn-be-fr` -> `sfb`).
  var schema = bcp47.parse(String(value || '').toLowerCase(), settings)
  var tag = bcp47.stringify(schema)
  var index = -1
  var key

  if (!tag) {
    return tag
  }

  // 2. Do fancy, expensive replaces (`ha-latn-gh` -> `ha-gh`).
  while (++index < matches.length) {
    if (match.extendedFilter(tag, matches[index].from).length) {
      replace(schema, matches[index].from, matches[index].to)
      tag = bcp47.stringify(schema)
    }
  }

  // 3. Do basic field replaces (`en-840` -> `en-us`).
  index = -1

  while (++index < fields.length) {
    if (remove(schema, fields[index].from.field, fields[index].from.value)) {
      add(schema, fields[index].to.field, fields[index].to.value)
    }
  }

  // 4. Remove defaults (`nl-nl` -> `nl`).
  tag = bcp47.stringify(Object.assign({}, schema, emptyExtraFields))
  index = -1

  while (++index < defaults.length) {
    if (tag === defaults[index]) {
      replace(
        schema,
        defaults[index],
        defaults[index].split('-').slice(0, -1).join('-')
      )
      tag = bcp47.stringify(Object.assign({}, schema, emptyExtraFields))
    }
  }

  // 5. Sort extensions on singleton.
  schema.extensions.sort(compareSingleton)

  // 6. Warn if fields (currently only regions) should be updated but have
  // multiple choices.
  if (settings.warning) {
    for (key in many) {
      if (own.call(many[key], schema[key])) {
        settings.warning(
          'Deprecated ' +
            key +
            ' `' +
            schema[key] +
            '`, expected one of `' +
            many[key][schema[key]].join('`, `') +
            '`',
          null,
          7
        )
      }
    }
  }

  // 7. Add proper casing back.
  // Format script (ISO 15924) as titlecase (example: `Latn`):
  if (schema.script) {
    schema.script =
      schema.script.charAt(0).toUpperCase() + schema.script.slice(1)
  }

  // Format region (ISO 3166) as uppercase (note: this doesn’t affect numeric
  // codes, which is fine):
  if (schema.region) {
    schema.region = schema.region.toUpperCase()
  }

  return bcp47.stringify(schema)
}

function replace(schema, from, to) {
  var left = bcp47.parse(from)
  var right = bcp47.parse(to)
  var removed = []
  var key

  // Remove values from `from`:
  for (key in left) {
    if (left[key] && left[key].length && remove(schema, key, left[key])) {
      removed.push(key)
    }
  }

  // Add values from `to`:
  for (key in right) {
    // Only add values that are defined on `to`, and that were either removed by
    // `from` or are currently empty.
    if (
      right[key] &&
      right[key].length &&
      (removed.indexOf(key) > -1 || !schema[key] || !schema[key].length)
    ) {
      add(schema, key, right[key])
    }
  }
}

function remove(object, key, value) {
  var removed = false
  var current
  var result
  var index
  var item

  /* istanbul ignore else - this is currently done by wrapping code, so else is
   * never reached.
   * However, that could change in the future, so leave this guard here. */
  if (value) {
    current = object[key]
    result = current

    if (current && typeof current === 'object') {
      result = []
      index = -1

      while (++index < current.length) {
        item = current[index]

        if (value.indexOf(item) < 0) {
          result.push(item)
        } else {
          removed = true
        }
      }
    } else if (current === value) {
      result = null
      removed = true
    }

    object[key] = result
  }

  return removed
}

function add(object, key, value) {
  var current = object[key]
  var list
  var index
  var item

  if (current && typeof current === 'object') {
    list = [].concat(value)
    index = -1

    while (++index < list.length) {
      item = list[index]

      /* istanbul ignore else - this currently can’t happen, but guard for the
       * future. */
      if (current.indexOf(item) < 0) {
        current.push(item)
      }
    }
  } else {
    object[key] = value
  }
}

function compareSingleton(left, right) {
  return collator.compare(left.singleton, right.singleton)
}


/***/ }),

/***/ "./node_modules/bcp-47/index.js":
/*!**************************************!*\
  !*** ./node_modules/bcp-47/index.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.parse = __webpack_require__(/*! ./lib/parse */ "./node_modules/bcp-47/lib/parse.js")
exports.stringify = __webpack_require__(/*! ./lib/stringify */ "./node_modules/bcp-47/lib/stringify.js")


/***/ }),

/***/ "./node_modules/bcp-47/lib/parse.js":
/*!******************************************!*\
  !*** ./node_modules/bcp-47/lib/parse.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var alphanumeric = __webpack_require__(/*! is-alphanumerical */ "./node_modules/is-alphanumerical/index.js")
var alphabetical = __webpack_require__(/*! is-alphabetical */ "./node_modules/is-alphabetical/index.js")
var decimal = __webpack_require__(/*! is-decimal */ "./node_modules/is-decimal/index.js")
var regular = __webpack_require__(/*! ./regular.json */ "./node_modules/bcp-47/lib/regular.json")
var normal = __webpack_require__(/*! ./normalize.json */ "./node_modules/bcp-47/lib/normalize.json")

module.exports = parse

var own = {}.hasOwnProperty

// Parse a BCP 47 language tag.
/* eslint-disable-next-line complexity */
function parse(tag, options) {
  var settings = options || {}
  var result = empty()
  var source = String(tag)
  var value = source.toLowerCase()
  var index = 0
  var start
  var groups
  var offset

  // Check input.
  if (tag == null) {
    throw new Error('Expected string, got `' + tag + '`')
  }

  // Let’s start.
  // First: the edge cases.
  if (own.call(normal, value)) {
    if ((settings.normalize == null || settings.normalize) && normal[value]) {
      return parse(normal[value])
    }

    result[regular.indexOf(value) === -1 ? 'irregular' : 'regular'] = source

    return result
  }

  // Now, to actually parse, eat what could be a language.
  while (alphabetical(value.charCodeAt(index)) && index < 9) index++

  // A language.
  if (index > 1 /* Min 639. */ && index < 9 /* Max subtag. */) {
    // 5 and up is a subtag.
    // 4 is the size of reserved languages.
    // 3 an ISO 639-2 or ISO 639-3.
    // 2 is an ISO 639-1.
    // <https://github.com/wooorm/iso-639-2>
    // <https://github.com/wooorm/iso-639-3>
    result.language = source.slice(0, index)

    if (index < 4 /* Max 639. */) {
      groups = 0

      while (
        value.charCodeAt(index) === 45 /* `-` */ &&
        alphabetical(value.charCodeAt(index + 1)) &&
        alphabetical(value.charCodeAt(index + 2)) &&
        alphabetical(value.charCodeAt(index + 3)) &&
        !alphabetical(value.charCodeAt(index + 4))
      ) {
        if (groups > 2 /* Max extended language subtag count. */) {
          return fail(
            index,
            3,
            'Too many extended language subtags, expected at most 3 subtags'
          )
        }

        // Extended language subtag.
        result.extendedLanguageSubtags.push(source.slice(index + 1, index + 4))
        index += 4
        groups++
      }
    }

    // ISO 15924 script.
    // <https://github.com/wooorm/iso-15924>
    if (
      value.charCodeAt(index) === 45 /* `-` */ &&
      alphabetical(value.charCodeAt(index + 1)) &&
      alphabetical(value.charCodeAt(index + 2)) &&
      alphabetical(value.charCodeAt(index + 3)) &&
      alphabetical(value.charCodeAt(index + 4)) &&
      !alphabetical(value.charCodeAt(index + 5))
    ) {
      result.script = source.slice(index + 1, index + 5)
      index += 5
    }

    if (value.charCodeAt(index) === 45 /* `-` */) {
      // ISO 3166-1 region.
      // <https://github.com/wooorm/iso-3166>
      if (
        alphabetical(value.charCodeAt(index + 1)) &&
        alphabetical(value.charCodeAt(index + 2)) &&
        !alphabetical(value.charCodeAt(index + 3))
      ) {
        result.region = source.slice(index + 1, index + 3)
        index += 3
      }
      // UN M49 region.
      // <https://github.com/wooorm/un-m49>
      else if (
        decimal(value.charCodeAt(index + 1)) &&
        decimal(value.charCodeAt(index + 2)) &&
        decimal(value.charCodeAt(index + 3)) &&
        !decimal(value.charCodeAt(index + 4))
      ) {
        result.region = source.slice(index + 1, index + 4)
        index += 4
      }
    }

    while (value.charCodeAt(index) === 45 /* `-` */) {
      offset = start = index + 1

      while (alphanumeric(value.charCodeAt(offset))) {
        if (offset - start > 7 /* Max variant. */) {
          return fail(
            offset,
            1,
            'Too long variant, expected at most 8 characters'
          )
        }

        offset++
      }

      if (
        // Long variant.
        offset - start > 4 /* Min alpha numeric variant. */ ||
        // Short variant.
        (offset - start > 3 /* Min variant. */ &&
          decimal(value.charCodeAt(start)))
      ) {
        result.variants.push(source.slice(start, offset))
        index = offset
      }
      // Something else.
      else {
        break
      }
    }

    // Extensions.
    while (value.charCodeAt(index) === 45 /* `-` */) {
      // Exit if this isn’t an extension.
      if (
        value.charCodeAt(index + 1) === 120 /* `x` */ ||
        !alphanumeric(value.charCodeAt(index + 1)) ||
        value.charCodeAt(index + 2) !== 45 /* `-` */ ||
        !alphanumeric(value.charCodeAt(index + 3))
      ) {
        break
      }

      offset = index + 2
      groups = 0

      while (
        value.charCodeAt(offset) === 45 /* `-` */ &&
        alphanumeric(value.charCodeAt(offset + 1)) &&
        alphanumeric(value.charCodeAt(offset + 2))
      ) {
        start = offset + 1
        offset = start + 2
        groups++

        while (alphanumeric(value.charCodeAt(offset))) {
          if (offset - start > 7 /* Max extension. */) {
            return fail(
              offset,
              2,
              'Too long extension, expected at most 8 characters'
            )
          }

          offset++
        }
      }

      if (!groups) {
        return fail(
          offset,
          4,
          'Empty extension, extensions must have at least 2 characters of content'
        )
      }

      result.extensions.push({
        singleton: source.charAt(index + 1),
        extensions: source.slice(index + 3, offset).split('-')
      })

      index = offset
    }
  }
  // Not a language.
  else {
    index = 0
  }

  // Private use.
  if (
    (index === 0 && value.charCodeAt(index) === 120) /* `x` */ ||
    (value.charCodeAt(index) === 45 /* `-` */ &&
      value.charCodeAt(index + 1) === 120) /* `x` */
  ) {
    offset = index = index ? index + 2 : 1

    while (
      value.charCodeAt(offset) === 45 /* `-` */ &&
      alphanumeric(value.charCodeAt(offset + 1))
    ) {
      offset = start = index + 1

      while (alphanumeric(value.charCodeAt(offset))) {
        if (offset - start > 7 /* Max private use. */) {
          return fail(
            offset,
            5,
            'Too long private-use area, expected at most 8 characters'
          )
        }

        offset++
      }

      result.privateuse.push(source.slice(index + 1, offset))
      index = offset
    }
  }

  if (index !== source.length) {
    return fail(index, 6, 'Found superfluous content after tag')
  }

  return result

  function fail(offset, code, reason) {
    if (settings.warning) settings.warning(reason, code, offset)
    return settings.forgiving ? result : empty()
  }
}

// Create an empty results object.
function empty() {
  return {
    language: null,
    extendedLanguageSubtags: [],
    script: null,
    region: null,
    variants: [],
    extensions: [],
    privateuse: [],
    irregular: null,
    regular: null
  }
}


/***/ }),

/***/ "./node_modules/bcp-47/lib/stringify.js":
/*!**********************************************!*\
  !*** ./node_modules/bcp-47/lib/stringify.js ***!
  \**********************************************/
/***/ ((module) => {

"use strict";


module.exports = stringify

// Compile a language schema to a BCP 47 language tag.
function stringify(schema) {
  var fields = schema || {}
  var result = []
  var values
  var index
  var value

  if (fields.irregular || fields.regular) {
    return fields.irregular || fields.regular
  }

  if (fields.language) {
    result = result.concat(
      fields.language,
      fields.extendedLanguageSubtags || [],
      fields.script || [],
      fields.region || [],
      fields.variants || []
    )

    values = fields.extensions || []
    index = -1

    while (++index < values.length) {
      value = values[index]

      if (value.singleton && value.extensions && value.extensions.length) {
        result = result.concat(value.singleton, value.extensions)
      }
    }
  }

  if (fields.privateuse && fields.privateuse.length) {
    result = result.concat('x', fields.privateuse)
  }

  return result.join('-')
}


/***/ }),

/***/ "./node_modules/codem-isoboxer/dist/iso_boxer.js":
/*!*******************************************************!*\
  !*** ./node_modules/codem-isoboxer/dist/iso_boxer.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

/*! codem-isoboxer v0.3.6 https://github.com/madebyhiro/codem-isoboxer/blob/master/LICENSE.txt */
var ISOBoxer = {};

ISOBoxer.parseBuffer = function(arrayBuffer) {
  return new ISOFile(arrayBuffer).parse();
};

ISOBoxer.addBoxProcessor = function(type, parser) {
  if (typeof type !== 'string' || typeof parser !== 'function') {
    return;
  }
  ISOBox.prototype._boxProcessors[type] = parser;
};

ISOBoxer.createFile = function() {
  return new ISOFile();
};

// See ISOBoxer.append() for 'pos' parameter syntax
ISOBoxer.createBox = function(type, parent, pos) {
  var newBox = ISOBox.create(type);
  if (parent) {
    parent.append(newBox, pos);
  }
  return newBox;
};

// See ISOBoxer.append() for 'pos' parameter syntax
ISOBoxer.createFullBox = function(type, parent, pos) {
  var newBox = ISOBoxer.createBox(type, parent, pos);
  newBox.version = 0;
  newBox.flags = 0;
  return newBox;
};

ISOBoxer.Utils = {};
ISOBoxer.Utils.dataViewToString = function(dataView, encoding) {
  var impliedEncoding = encoding || 'utf-8';
  if (typeof TextDecoder !== 'undefined') {
    return new TextDecoder(impliedEncoding).decode(dataView);
  }
  var a = [];
  var i = 0;

  if (impliedEncoding === 'utf-8') {
    /* The following algorithm is essentially a rewrite of the UTF8.decode at
    http://bannister.us/weblog/2007/simple-base64-encodedecode-javascript/
    */

    while (i < dataView.byteLength) {
      var c = dataView.getUint8(i++);
      if (c < 0x80) {
        // 1-byte character (7 bits)
      } else if (c < 0xe0) {
        // 2-byte character (11 bits)
        c = (c & 0x1f) << 6;
        c |= (dataView.getUint8(i++) & 0x3f);
      } else if (c < 0xf0) {
        // 3-byte character (16 bits)
        c = (c & 0xf) << 12;
        c |= (dataView.getUint8(i++) & 0x3f) << 6;
        c |= (dataView.getUint8(i++) & 0x3f);
      } else {
        // 4-byte character (21 bits)
        c = (c & 0x7) << 18;
        c |= (dataView.getUint8(i++) & 0x3f) << 12;
        c |= (dataView.getUint8(i++) & 0x3f) << 6;
        c |= (dataView.getUint8(i++) & 0x3f);
      }
      a.push(String.fromCharCode(c));
    }
  } else { // Just map byte-by-byte (probably wrong)
    while (i < dataView.byteLength) {
      a.push(String.fromCharCode(dataView.getUint8(i++)));
    }
  }
  return a.join('');
};

ISOBoxer.Utils.utf8ToByteArray = function(string) {
  // Only UTF-8 encoding is supported by TextEncoder
  var u, i;
  if (typeof TextEncoder !== 'undefined') {
    u = new TextEncoder().encode(string);
  } else {
    u = [];
    for (i = 0; i < string.length; ++i) {
      var c = string.charCodeAt(i);
      if (c < 0x80) {
        u.push(c);
      } else if (c < 0x800) {
        u.push(0xC0 | (c >> 6));
        u.push(0x80 | (63 & c));
      } else if (c < 0x10000) {
        u.push(0xE0 | (c >> 12));
        u.push(0x80 | (63 & (c >> 6)));
        u.push(0x80 | (63 & c));
      } else {
        u.push(0xF0 | (c >> 18));
        u.push(0x80 | (63 & (c >> 12)));
        u.push(0x80 | (63 & (c >> 6)));
        u.push(0x80 | (63 & c));
      }
    }
  }
  return u;
};

// Method to append a box in the list of child boxes
// The 'pos' parameter can be either:
//   - (number) a position index at which to insert the new box
//   - (string) the type of the box after which to insert the new box
//   - (object) the box after which to insert the new box
ISOBoxer.Utils.appendBox = function(parent, box, pos) {
  box._offset = parent._cursor.offset;
  box._root = (parent._root ? parent._root : parent);
  box._raw = parent._raw;
  box._parent = parent;

  if (pos === -1) {
    // The new box is a sub-box of the parent but not added in boxes array,
    // for example when the new box is set as an entry (see dref and stsd for example)
    return;
  }

  if (pos === undefined || pos === null) {
    parent.boxes.push(box);
    return;
  }

  var index = -1,
      type;

  if (typeof pos === "number") {
    index = pos;
  } else {
    if (typeof pos === "string") {
      type = pos;
    } else if (typeof pos === "object" && pos.type) {
      type = pos.type;
    } else {
      parent.boxes.push(box);
      return;
    }

    for (var i = 0; i < parent.boxes.length; i++) {
      if (type === parent.boxes[i].type) {
        index = i + 1;
        break;
      }
    }
  }
  parent.boxes.splice(index, 0, box);
};

if (true) {
  exports.parseBuffer     = ISOBoxer.parseBuffer;
  exports.addBoxProcessor = ISOBoxer.addBoxProcessor;
  exports.createFile      = ISOBoxer.createFile;
  exports.createBox       = ISOBoxer.createBox;
  exports.createFullBox   = ISOBoxer.createFullBox;
  exports.Utils           = ISOBoxer.Utils;
}

ISOBoxer.Cursor = function(initialOffset) {
  this.offset = (typeof initialOffset == 'undefined' ? 0 : initialOffset);
};

var ISOFile = function(arrayBuffer) {
  this._cursor = new ISOBoxer.Cursor();
  this.boxes = [];
  if (arrayBuffer) {
    this._raw = new DataView(arrayBuffer);
  }
};

ISOFile.prototype.fetch = function(type) {
  var result = this.fetchAll(type, true);
  return (result.length ? result[0] : null);
};

ISOFile.prototype.fetchAll = function(type, returnEarly) {
  var result = [];
  ISOFile._sweep.call(this, type, result, returnEarly);
  return result;
};

ISOFile.prototype.parse = function() {
  this._cursor.offset = 0;
  this.boxes = [];
  while (this._cursor.offset < this._raw.byteLength) {
    var box = ISOBox.parse(this);

    // Box could not be parsed
    if (typeof box.type === 'undefined') break;

    this.boxes.push(box);
  }
  return this;
};

ISOFile._sweep = function(type, result, returnEarly) {
  if (this.type && this.type == type) result.push(this);
  for (var box in this.boxes) {
    if (result.length && returnEarly) return;
    ISOFile._sweep.call(this.boxes[box], type, result, returnEarly);
  }
};

ISOFile.prototype.write = function() {

  var length = 0,
      i;

  for (i = 0; i < this.boxes.length; i++) {
    length += this.boxes[i].getLength(false);
  }

  var bytes = new Uint8Array(length);
  this._rawo = new DataView(bytes.buffer);
  this.bytes = bytes;
  this._cursor.offset = 0;

  for (i = 0; i < this.boxes.length; i++) {
    this.boxes[i].write();
  }

  return bytes.buffer;
};

ISOFile.prototype.append = function(box, pos) {
  ISOBoxer.Utils.appendBox(this, box, pos);
};
var ISOBox = function() {
  this._cursor = new ISOBoxer.Cursor();
};

ISOBox.parse = function(parent) {
  var newBox = new ISOBox();
  newBox._offset = parent._cursor.offset;
  newBox._root = (parent._root ? parent._root : parent);
  newBox._raw = parent._raw;
  newBox._parent = parent;
  newBox._parseBox();
  parent._cursor.offset = newBox._raw.byteOffset + newBox._raw.byteLength;
  return newBox;
};

ISOBox.create = function(type) {
  var newBox = new ISOBox();
  newBox.type = type;
  newBox.boxes = [];
  return newBox;
};

ISOBox.prototype._boxContainers = ['dinf', 'edts', 'mdia', 'meco', 'mfra', 'minf', 'moof', 'moov', 'mvex', 'stbl', 'strk', 'traf', 'trak', 'tref', 'udta', 'vttc', 'sinf', 'schi', 'encv', 'enca'];

ISOBox.prototype._boxProcessors = {};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Generic read/write functions

ISOBox.prototype._procField = function (name, type, size) {
  if (this._parsing) {
    this[name] = this._readField(type, size);
  }
  else {
    this._writeField(type, size, this[name]);
  }
};

ISOBox.prototype._procFieldArray = function (name, length, type, size) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name][i] = this._readField(type, size);
    }
  }
  else {
    for (i = 0; i < this[name].length; i++) {
      this._writeField(type, size, this[name][i]);
    }
  }
};

ISOBox.prototype._procFullBox = function() {
  this._procField('version', 'uint', 8);
  this._procField('flags', 'uint', 24);
};

ISOBox.prototype._procEntries = function(name, length, fn) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name].push({});
      fn.call(this, this[name][i]);
    }
  }
  else {
    for (i = 0; i < length; i++) {
      fn.call(this, this[name][i]);
    }
  }
};

ISOBox.prototype._procSubEntries = function(entry, name, length, fn) {
  var i;
  if (this._parsing) {
    entry[name] = [];
    for (i = 0; i < length; i++) {
      entry[name].push({});
      fn.call(this, entry[name][i]);
    }
  }
  else {
    for (i = 0; i < length; i++) {
      fn.call(this, entry[name][i]);
    }
  }
};

ISOBox.prototype._procEntryField = function (entry, name, type, size) {
  if (this._parsing) {
    entry[name] = this._readField(type, size);
  }
  else {
    this._writeField(type, size, entry[name]);
  }
};

ISOBox.prototype._procSubBoxes = function(name, length) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name].push(ISOBox.parse(this));
    }
  }
  else {
    for (i = 0; i < length; i++) {
      if (this._rawo) {
        this[name][i].write();
      } else {
        this.size += this[name][i].getLength();
      }
    }
  }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Read/parse functions

ISOBox.prototype._readField = function(type, size) {
  switch (type) {
    case 'uint':
      return this._readUint(size);
    case 'int':
      return this._readInt(size);
    case 'template':
      return this._readTemplate(size);
    case 'string':
      return (size === -1) ? this._readTerminatedString() : this._readString(size);
    case 'data':
      return this._readData(size);
    case 'utf8':
      return this._readUTF8String();
    default:
      return -1;
  }
};

ISOBox.prototype._readInt = function(size) {
  var result = null,
      offset = this._cursor.offset - this._raw.byteOffset;
  switch(size) {
  case 8:
    result = this._raw.getInt8(offset);
    break;
  case 16:
    result = this._raw.getInt16(offset);
    break;
  case 32:
    result = this._raw.getInt32(offset);
    break;
  case 64:
    // Warning: JavaScript cannot handle 64-bit integers natively.
    // This will give unexpected results for integers >= 2^53
    var s1 = this._raw.getInt32(offset);
    var s2 = this._raw.getInt32(offset + 4);
    result = (s1 * Math.pow(2,32)) + s2;
    break;
  }
  this._cursor.offset += (size >> 3);
  return result;
};

ISOBox.prototype._readUint = function(size) {
  var result = null,
      offset = this._cursor.offset - this._raw.byteOffset,
      s1, s2;
  switch(size) {
  case 8:
    result = this._raw.getUint8(offset);
    break;
  case 16:
    result = this._raw.getUint16(offset);
    break;
  case 24:
    s1 = this._raw.getUint16(offset);
    s2 = this._raw.getUint8(offset + 2);
    result = (s1 << 8) + s2;
    break;
  case 32:
    result = this._raw.getUint32(offset);
    break;
  case 64:
    // Warning: JavaScript cannot handle 64-bit integers natively.
    // This will give unexpected results for integers >= 2^53
    s1 = this._raw.getUint32(offset);
    s2 = this._raw.getUint32(offset + 4);
    result = (s1 * Math.pow(2,32)) + s2;
    break;
  }
  this._cursor.offset += (size >> 3);
  return result;
};

ISOBox.prototype._readString = function(length) {
  var str = '';
  for (var c = 0; c < length; c++) {
    var char = this._readUint(8);
    str += String.fromCharCode(char);
  }
  return str;
};

ISOBox.prototype._readTemplate = function(size) {
  var pre = this._readUint(size / 2);
  var post = this._readUint(size / 2);
  return pre + (post / Math.pow(2, size / 2));
};

ISOBox.prototype._readTerminatedString = function() {
  var str = '';
  while (this._cursor.offset - this._offset < this._raw.byteLength) {
    var char = this._readUint(8);
    if (char === 0) break;
    str += String.fromCharCode(char);
  }
  return str;
};

ISOBox.prototype._readData = function(size) {
  var length = (size > 0) ? size : (this._raw.byteLength - (this._cursor.offset - this._offset));
  if (length > 0) {
    var data = new Uint8Array(this._raw.buffer, this._cursor.offset, length);

    this._cursor.offset += length;
    return data;
  }
  else {
    return null;
  }
};

ISOBox.prototype._readUTF8String = function() {
  var length = this._raw.byteLength - (this._cursor.offset - this._offset);
  var data = null;
  if (length > 0) {
    data = new DataView(this._raw.buffer, this._cursor.offset, length);
    this._cursor.offset += length;
  }
 
  return data ? ISOBoxer.Utils.dataViewToString(data) : data;
};

ISOBox.prototype._parseBox = function() {
  this._parsing = true;
  this._cursor.offset = this._offset;

  // return immediately if there are not enough bytes to read the header
  if (this._offset + 8 > this._raw.buffer.byteLength) {
    this._root._incomplete = true;
    return;
  }

  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);

  if (this.size === 1)      { this._procField('largesize', 'uint', 64); }
  if (this.type === 'uuid') { this._procFieldArray('usertype', 16, 'uint', 8); }

  switch(this.size) {
  case 0:
    this._raw = new DataView(this._raw.buffer, this._offset, (this._raw.byteLength - this._cursor.offset + 8));
    break;
  case 1:
    if (this._offset + this.size > this._raw.buffer.byteLength) {
      this._incomplete = true;
      this._root._incomplete = true;
    } else {
      this._raw = new DataView(this._raw.buffer, this._offset, this.largesize);
    }
    break;
  default:
    if (this._offset + this.size > this._raw.buffer.byteLength) {
      this._incomplete = true;
      this._root._incomplete = true;
    } else {
      this._raw = new DataView(this._raw.buffer, this._offset, this.size);
    }
  }

  // additional parsing
  if (!this._incomplete) {
    if (this._boxProcessors[this.type]) {
      this._boxProcessors[this.type].call(this);
    }
    if (this._boxContainers.indexOf(this.type) !== -1) {
      this._parseContainerBox();
    } else{
      // Unknown box => read and store box content
      this._data = this._readData();
    }
  }
};

ISOBox.prototype._parseFullBox = function() {
  this.version = this._readUint(8);
  this.flags = this._readUint(24);
};

ISOBox.prototype._parseContainerBox = function() {
  this.boxes = [];
  while (this._cursor.offset - this._raw.byteOffset < this._raw.byteLength) {
    this.boxes.push(ISOBox.parse(this));
  }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Write functions

ISOBox.prototype.append = function(box, pos) {
  ISOBoxer.Utils.appendBox(this, box, pos);
};

ISOBox.prototype.getLength = function() {
  this._parsing = false;
  this._rawo = null;

  this.size = 0;
  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);

  if (this.size === 1)      { this._procField('largesize', 'uint', 64); }
  if (this.type === 'uuid') { this._procFieldArray('usertype', 16, 'uint', 8); }

  if (this._boxProcessors[this.type]) {
    this._boxProcessors[this.type].call(this);
  }

  if (this._boxContainers.indexOf(this.type) !== -1) {
    for (var i = 0; i < this.boxes.length; i++) {
      this.size += this.boxes[i].getLength();
    }
  } 

  if (this._data) {
    this._writeData(this._data);
  }

  return this.size;
};

ISOBox.prototype.write = function() {
  this._parsing = false;
  this._cursor.offset = this._parent._cursor.offset;

  switch(this.size) {
  case 0:
    this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, (this.parent._rawo.byteLength - this._cursor.offset));
    break;
  case 1:
      this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, this.largesize);
    break;
  default:
      this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, this.size);
  }

  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);

  if (this.size === 1)      { this._procField('largesize', 'uint', 64); }
  if (this.type === 'uuid') { this._procFieldArray('usertype', 16, 'uint', 8); }

  if (this._boxProcessors[this.type]) {
    this._boxProcessors[this.type].call(this);
  }

  if (this._boxContainers.indexOf(this.type) !== -1) {
    for (var i = 0; i < this.boxes.length; i++) {
      this.boxes[i].write();
    }
  } 

  if (this._data) {
    this._writeData(this._data);
  }

  this._parent._cursor.offset += this.size;

  return this.size;
};

ISOBox.prototype._writeInt = function(size, value) {
  if (this._rawo) {
    var offset = this._cursor.offset - this._rawo.byteOffset;
    switch(size) {
    case 8:
      this._rawo.setInt8(offset, value);
      break;
    case 16:
      this._rawo.setInt16(offset, value);
      break;
    case 32:
      this._rawo.setInt32(offset, value);
      break;
    case 64:
      // Warning: JavaScript cannot handle 64-bit integers natively.
      // This will give unexpected results for integers >= 2^53
      var s1 = Math.floor(value / Math.pow(2,32));
      var s2 = value - (s1 * Math.pow(2,32));
      this._rawo.setUint32(offset, s1);
      this._rawo.setUint32(offset + 4, s2);
      break;
    }
    this._cursor.offset += (size >> 3);
  } else {
    this.size += (size >> 3);
  }
};

ISOBox.prototype._writeUint = function(size, value) {

  if (this._rawo) {
    var offset = this._cursor.offset - this._rawo.byteOffset,
        s1, s2;
    switch(size) {
    case 8:
      this._rawo.setUint8(offset, value);
      break;
    case 16:
      this._rawo.setUint16(offset, value);
      break;
    case 24:
      s1 = (value & 0xFFFF00) >> 8;
      s2 = (value & 0x0000FF);
      this._rawo.setUint16(offset, s1);
      this._rawo.setUint8(offset + 2, s2);
      break;
    case 32:
      this._rawo.setUint32(offset, value);
      break;
    case 64:
      // Warning: JavaScript cannot handle 64-bit integers natively.
      // This will give unexpected results for integers >= 2^53
      s1 = Math.floor(value / Math.pow(2,32));
      s2 = value - (s1 * Math.pow(2,32));
      this._rawo.setUint32(offset, s1);
      this._rawo.setUint32(offset + 4, s2);
      break;
    }
    this._cursor.offset += (size >> 3);
  } else {
    this.size += (size >> 3);
  }
};

ISOBox.prototype._writeString = function(size, str) {
  for (var c = 0; c < size; c++) {
    this._writeUint(8, str.charCodeAt(c));
  }
};

ISOBox.prototype._writeTerminatedString = function(str) {
  if (str.length === 0) {
    return;
  }
  for (var c = 0; c < str.length; c++) {
    this._writeUint(8, str.charCodeAt(c));
  }
  this._writeUint(8, 0);
};

ISOBox.prototype._writeTemplate = function(size, value) {
  var pre = Math.floor(value);
  var post = (value - pre) * Math.pow(2, size / 2);
  this._writeUint(size / 2, pre);
  this._writeUint(size / 2, post);
};

ISOBox.prototype._writeData = function(data) {
  var i;
  //data to copy
  if (data) {
    if (this._rawo) {
      //Array and Uint8Array has also to be managed
      if (data instanceof Array) {
        var offset = this._cursor.offset - this._rawo.byteOffset;
        for (var i = 0; i < data.length; i++) {
          this._rawo.setInt8(offset + i, data[i]);
        }
        this._cursor.offset += data.length;
      } 

      if (data instanceof Uint8Array) {
        this._root.bytes.set(data, this._cursor.offset);
        this._cursor.offset += data.length;
      }

    } else {
      //nothing to copy only size to compute
      this.size += data.length;
    }
  }
};

ISOBox.prototype._writeUTF8String = function(string) {
  var u = ISOBoxer.Utils.utf8ToByteArray(string);
  if (this._rawo) {
    var dataView = new DataView(this._rawo.buffer, this._cursor.offset, u.length);
    for (var i = 0; i < u.length; i++) {
      dataView.setUint8(i, u[i]);
    }
  } else {
    this.size += u.length;
  }
};

ISOBox.prototype._writeField = function(type, size, value) {
  switch (type) {
  case 'uint':
    this._writeUint(size, value);
    break;
  case 'int':
    this._writeInt(size, value);
    break;
  case 'template':
    this._writeTemplate(size, value);
    break;
  case 'string':
      if (size == -1) {
        this._writeTerminatedString(value);
      } else {
        this._writeString(size, value);
      }
      break;
  case 'data':
    this._writeData(value);
    break;
  case 'utf8':
    this._writeUTF8String(value);
    break;
  default:
    break;
  }
};

// ISO/IEC 14496-15:2014 - avc1 box
ISOBox.prototype._boxProcessors['avc1'] = ISOBox.prototype._boxProcessors['encv'] = function() {
  // SampleEntry fields
  this._procFieldArray('reserved1', 6,    'uint', 8);
  this._procField('data_reference_index', 'uint', 16);
  // VisualSampleEntry fields
  this._procField('pre_defined1',         'uint',     16);
  this._procField('reserved2',            'uint',     16);
  this._procFieldArray('pre_defined2', 3, 'uint',     32);
  this._procField('width',                'uint',     16);
  this._procField('height',               'uint',     16);
  this._procField('horizresolution',      'template', 32);
  this._procField('vertresolution',       'template', 32);
  this._procField('reserved3',            'uint',     32);
  this._procField('frame_count',          'uint',     16);
  this._procFieldArray('compressorname', 32,'uint',    8);
  this._procField('depth',                'uint',     16);
  this._procField('pre_defined3',         'int',      16);
  // AVCSampleEntry fields
  this._procField('config', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.7.2 Data Reference Box
ISOBox.prototype._boxProcessors['dref'] = function() {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procSubBoxes('entries', this.entry_count);
};

// ISO/IEC 14496-12:2012 - 8.6.6 Edit List Box
ISOBox.prototype._boxProcessors['elst'] = function() {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function(entry) {
    this._procEntryField(entry, 'segment_duration',     'uint', (this.version === 1) ? 64 : 32);
    this._procEntryField(entry, 'media_time',           'int',  (this.version === 1) ? 64 : 32);
    this._procEntryField(entry, 'media_rate_integer',   'int',  16);
    this._procEntryField(entry, 'media_rate_fraction',  'int',  16);
  });
};

// ISO/IEC 23009-1:2014 - 5.10.3.3 Event Message Box
ISOBox.prototype._boxProcessors['emsg'] = function() {
  this._procFullBox();
  if (this.version == 1) {
    this._procField('timescale',                'uint',   32);
    this._procField('presentation_time',        'uint',   64);
    this._procField('event_duration',           'uint',   32);
    this._procField('id',                       'uint',   32);
    this._procField('scheme_id_uri',            'string', -1);
    this._procField('value',                    'string', -1);
  } else {
    this._procField('scheme_id_uri',            'string', -1);
    this._procField('value',                    'string', -1);
    this._procField('timescale',                'uint',   32);
    this._procField('presentation_time_delta',  'uint',   32);
    this._procField('event_duration',           'uint',   32);
    this._procField('id',                       'uint',   32);
  }
  this._procField('message_data',             'data',   -1);
};
// ISO/IEC 14496-12:2012 - 8.1.2 Free Space Box
ISOBox.prototype._boxProcessors['free'] = ISOBox.prototype._boxProcessors['skip'] = function() {
  this._procField('data', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.12.2 Original Format Box
ISOBox.prototype._boxProcessors['frma'] = function() {
  this._procField('data_format', 'uint', 32);
};
// ISO/IEC 14496-12:2012 - 4.3 File Type Box / 8.16.2 Segment Type Box
ISOBox.prototype._boxProcessors['ftyp'] =
ISOBox.prototype._boxProcessors['styp'] = function() {
  this._procField('major_brand', 'string', 4);
  this._procField('minor_version', 'uint', 32);
  var nbCompatibleBrands = -1;
  if (this._parsing) {
    nbCompatibleBrands = (this._raw.byteLength - (this._cursor.offset - this._raw.byteOffset)) / 4;
  }
  this._procFieldArray('compatible_brands', nbCompatibleBrands, 'string', 4);
};

// ISO/IEC 14496-12:2012 - 8.4.3 Handler Reference Box
ISOBox.prototype._boxProcessors['hdlr'] = function() {
  this._procFullBox();
  this._procField('pre_defined',      'uint',   32);
  this._procField('handler_type',     'string', 4);
  this._procFieldArray('reserved', 3, 'uint', 32);
  this._procField('name',             'string', -1);
};

// ISO/IEC 14496-12:2012 - 8.1.1 Media Data Box
ISOBox.prototype._boxProcessors['mdat'] = function() {
  this._procField('data', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.4.2 Media Header Box
ISOBox.prototype._boxProcessors['mdhd'] = function() {
  this._procFullBox();
  this._procField('creation_time',      'uint', (this.version == 1) ? 64 : 32);
  this._procField('modification_time',  'uint', (this.version == 1) ? 64 : 32);
  this._procField('timescale',          'uint', 32);
  this._procField('duration',           'uint', (this.version == 1) ? 64 : 32);
  if (!this._parsing && typeof this.language === 'string') {
    // In case of writing and language has been set as a string, then convert it into char codes array
    this.language = ((this.language.charCodeAt(0) - 0x60) << 10) |
                    ((this.language.charCodeAt(1) - 0x60) << 5) |
                    ((this.language.charCodeAt(2) - 0x60));
  }
  this._procField('language',           'uint', 16);
  if (this._parsing) {
    this.language = String.fromCharCode(((this.language >> 10) & 0x1F) + 0x60,
                                        ((this.language >> 5) & 0x1F) + 0x60,
                                        (this.language & 0x1F) + 0x60);
  }
  this._procField('pre_defined',        'uint', 16);
};

// ISO/IEC 14496-12:2012 - 8.8.2 Movie Extends Header Box
ISOBox.prototype._boxProcessors['mehd'] = function() {
  this._procFullBox();
  this._procField('fragment_duration', 'uint', (this.version == 1) ? 64 : 32);
};

// ISO/IEC 14496-12:2012 - 8.8.5 Movie Fragment Header Box
ISOBox.prototype._boxProcessors['mfhd'] = function() {
  this._procFullBox();
  this._procField('sequence_number', 'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.11 Movie Fragment Random Access Box
ISOBox.prototype._boxProcessors['mfro'] = function() {
  this._procFullBox();
  this._procField('mfra_size', 'uint', 32); // Called mfra_size to distinguish from the normal "size" attribute of a box
};


// ISO/IEC 14496-12:2012 - 8.5.2.2 mp4a box (use AudioSampleEntry definition and naming)
ISOBox.prototype._boxProcessors['mp4a'] = ISOBox.prototype._boxProcessors['enca'] = function() {
  // SampleEntry fields
  this._procFieldArray('reserved1', 6,    'uint', 8);
  this._procField('data_reference_index', 'uint', 16);
  // AudioSampleEntry fields
  this._procFieldArray('reserved2', 2,    'uint', 32);
  this._procField('channelcount',         'uint', 16);
  this._procField('samplesize',           'uint', 16);
  this._procField('pre_defined',          'uint', 16);
  this._procField('reserved3',            'uint', 16);
  this._procField('samplerate',           'template', 32);
  // ESDescriptor fields
  this._procField('esds',                 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.2.2 Movie Header Box
ISOBox.prototype._boxProcessors['mvhd'] = function() {
  this._procFullBox();
  this._procField('creation_time',      'uint',     (this.version == 1) ? 64 : 32);
  this._procField('modification_time',  'uint',     (this.version == 1) ? 64 : 32);
  this._procField('timescale',          'uint',     32);
  this._procField('duration',           'uint',     (this.version == 1) ? 64 : 32);
  this._procField('rate',               'template', 32);
  this._procField('volume',             'template', 16);
  this._procField('reserved1',          'uint',  16);
  this._procFieldArray('reserved2', 2,  'uint',     32);
  this._procFieldArray('matrix', 9,     'template', 32);
  this._procFieldArray('pre_defined', 6,'uint',   32);
  this._procField('next_track_ID',      'uint',     32);
};

// ISO/IEC 14496-30:2014 - WebVTT Cue Payload Box.
ISOBox.prototype._boxProcessors['payl'] = function() {
  this._procField('cue_text', 'utf8');
};

//ISO/IEC 23001-7:2011 - 8.1 Protection System Specific Header Box
ISOBox.prototype._boxProcessors['pssh'] = function() {
  this._procFullBox();
  
  this._procFieldArray('SystemID', 16, 'uint', 8);
  this._procField('DataSize', 'uint', 32);
  this._procFieldArray('Data', this.DataSize, 'uint', 8);
};
// ISO/IEC 14496-12:2012 - 8.12.5 Scheme Type Box
ISOBox.prototype._boxProcessors['schm'] = function() {
    this._procFullBox();
    
    this._procField('scheme_type', 'uint', 32);
    this._procField('scheme_version', 'uint', 32);

    if (this.flags & 0x000001) {
        this._procField('scheme_uri', 'string', -1);
    }
};
// ISO/IEC 14496-12:2012 - 8.6.4.1 sdtp box 
ISOBox.prototype._boxProcessors['sdtp'] = function() {
  this._procFullBox();

  var sample_count = -1;
  if (this._parsing) {
    sample_count = (this._raw.byteLength - (this._cursor.offset - this._raw.byteOffset));
  }

  this._procFieldArray('sample_dependency_table', sample_count, 'uint', 8);
};

// ISO/IEC 14496-12:2012 - 8.16.3 Segment Index Box
ISOBox.prototype._boxProcessors['sidx'] = function() {
  this._procFullBox();
  this._procField('reference_ID', 'uint', 32);
  this._procField('timescale', 'uint', 32);
  this._procField('earliest_presentation_time', 'uint', (this.version == 1) ? 64 : 32);
  this._procField('first_offset', 'uint', (this.version == 1) ? 64 : 32);
  this._procField('reserved', 'uint', 16);
  this._procField('reference_count', 'uint', 16);
  this._procEntries('references', this.reference_count, function(entry) {
    if (!this._parsing) {
      entry.reference  = (entry.reference_type  & 0x00000001) << 31;
      entry.reference |= (entry.referenced_size & 0x7FFFFFFF);
      entry.sap  = (entry.starts_with_SAP & 0x00000001) << 31;
      entry.sap |= (entry.SAP_type        & 0x00000003) << 28;
      entry.sap |= (entry.SAP_delta_time  & 0x0FFFFFFF);
    }
    this._procEntryField(entry, 'reference', 'uint', 32);
    this._procEntryField(entry, 'subsegment_duration', 'uint', 32);
    this._procEntryField(entry, 'sap', 'uint', 32);
    if (this._parsing) {
      entry.reference_type = (entry.reference >> 31) & 0x00000001;
      entry.referenced_size = entry.reference & 0x7FFFFFFF;
      entry.starts_with_SAP  = (entry.sap >> 31) & 0x00000001;
      entry.SAP_type = (entry.sap >> 28) & 0x00000007;
      entry.SAP_delta_time = (entry.sap  & 0x0FFFFFFF);
    }
  });
};

// ISO/IEC 14496-12:2012 - 8.4.5.3 Sound Media Header Box
ISOBox.prototype._boxProcessors['smhd'] = function() {
  this._procFullBox();
  this._procField('balance',  'uint', 16);
  this._procField('reserved', 'uint', 16);
};

// ISO/IEC 14496-12:2012 - 8.16.4 Subsegment Index Box
ISOBox.prototype._boxProcessors['ssix'] = function() {
  this._procFullBox();
  this._procField('subsegment_count', 'uint', 32);
  this._procEntries('subsegments', this.subsegment_count, function(subsegment) {
    this._procEntryField(subsegment, 'ranges_count', 'uint', 32);
    this._procSubEntries(subsegment, 'ranges', subsegment.ranges_count, function(range) {
      this._procEntryField(range, 'level', 'uint', 8);
      this._procEntryField(range, 'range_size', 'uint', 24);
    });
  });
};

// ISO/IEC 14496-12:2012 - 8.5.2 Sample Description Box
ISOBox.prototype._boxProcessors['stsd'] = function() {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procSubBoxes('entries', this.entry_count);
};

// ISO/IEC 14496-12:2015 - 8.7.7 Sub-Sample Information Box
ISOBox.prototype._boxProcessors['subs'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function(entry) {
    this._procEntryField(entry, 'sample_delta', 'uint', 32);
    this._procEntryField(entry, 'subsample_count', 'uint', 16);
    this._procSubEntries(entry, 'subsamples', entry.subsample_count, function(subsample) {
      this._procEntryField(subsample, 'subsample_size', 'uint', (this.version === 1) ? 32 : 16);
      this._procEntryField(subsample, 'subsample_priority', 'uint', 8);
      this._procEntryField(subsample, 'discardable', 'uint', 8);
      this._procEntryField(subsample, 'codec_specific_parameters', 'uint', 32);
    });
  });
};

//ISO/IEC 23001-7:2011 - 8.2 Track Encryption Box
ISOBox.prototype._boxProcessors['tenc'] = function() {
    this._procFullBox();

    this._procField('default_IsEncrypted', 'uint', 24);
    this._procField('default_IV_size', 'uint', 8);
    this._procFieldArray('default_KID', 16,    'uint', 8);
 };

// ISO/IEC 14496-12:2012 - 8.8.12 Track Fragmnent Decode Time
ISOBox.prototype._boxProcessors['tfdt'] = function() {
  this._procFullBox();
  this._procField('baseMediaDecodeTime', 'uint', (this.version == 1) ? 64 : 32);
};

// ISO/IEC 14496-12:2012 - 8.8.7 Track Fragment Header Box
ISOBox.prototype._boxProcessors['tfhd'] = function() {
  this._procFullBox();
  this._procField('track_ID', 'uint', 32);
  if (this.flags & 0x01) this._procField('base_data_offset',          'uint', 64);
  if (this.flags & 0x02) this._procField('sample_description_offset', 'uint', 32);
  if (this.flags & 0x08) this._procField('default_sample_duration',   'uint', 32);
  if (this.flags & 0x10) this._procField('default_sample_size',       'uint', 32);
  if (this.flags & 0x20) this._procField('default_sample_flags',      'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.10 Track Fragment Random Access Box
ISOBox.prototype._boxProcessors['tfra'] = function() {
  this._procFullBox();
  this._procField('track_ID', 'uint', 32);
  if (!this._parsing) {
    this.reserved = 0;
    this.reserved |= (this.length_size_of_traf_num  & 0x00000030) << 4;
    this.reserved |= (this.length_size_of_trun_num  & 0x0000000C) << 2;
    this.reserved |= (this.length_size_of_sample_num  & 0x00000003);
  }
  this._procField('reserved', 'uint', 32);
  if (this._parsing) {
    this.length_size_of_traf_num = (this.reserved & 0x00000030) >> 4;
    this.length_size_of_trun_num = (this.reserved & 0x0000000C) >> 2;
    this.length_size_of_sample_num = (this.reserved & 0x00000003);
  }
  this._procField('number_of_entry', 'uint', 32);
  this._procEntries('entries', this.number_of_entry, function(entry) {
    this._procEntryField(entry, 'time', 'uint', (this.version === 1) ? 64 : 32);
    this._procEntryField(entry, 'moof_offset', 'uint', (this.version === 1) ? 64 : 32);
    this._procEntryField(entry, 'traf_number', 'uint', (this.length_size_of_traf_num + 1) * 8);
    this._procEntryField(entry, 'trun_number', 'uint', (this.length_size_of_trun_num + 1) * 8);
    this._procEntryField(entry, 'sample_number', 'uint', (this.length_size_of_sample_num + 1) * 8);
  });
};

// ISO/IEC 14496-12:2012 - 8.3.2 Track Header Box
ISOBox.prototype._boxProcessors['tkhd'] = function() {
  this._procFullBox();
  this._procField('creation_time',      'uint',     (this.version == 1) ? 64 : 32);
  this._procField('modification_time',  'uint',     (this.version == 1) ? 64 : 32);
  this._procField('track_ID',           'uint',     32);
  this._procField('reserved1',          'uint',     32);
  this._procField('duration',           'uint',     (this.version == 1) ? 64 : 32);
  this._procFieldArray('reserved2', 2,  'uint',     32);
  this._procField('layer',              'uint',     16);
  this._procField('alternate_group',    'uint',     16);
  this._procField('volume',             'template', 16);
  this._procField('reserved3',          'uint',     16);
  this._procFieldArray('matrix', 9,     'template', 32);
  this._procField('width',              'template', 32);
  this._procField('height',             'template', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.3 Track Extends Box
ISOBox.prototype._boxProcessors['trex'] = function() {
  this._procFullBox();
  this._procField('track_ID',                         'uint', 32);
  this._procField('default_sample_description_index', 'uint', 32);
  this._procField('default_sample_duration',          'uint', 32);
  this._procField('default_sample_size',              'uint', 32);
  this._procField('default_sample_flags',             'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.8 Track Run Box
// Note: the 'trun' box has a direct relation to the 'tfhd' box for defaults.
// These defaults are not set explicitly here, but are left to resolve for the user.
ISOBox.prototype._boxProcessors['trun'] = function() {
  this._procFullBox();
  this._procField('sample_count', 'uint', 32);
  if (this.flags & 0x1) this._procField('data_offset', 'int', 32);
  if (this.flags & 0x4) this._procField('first_sample_flags', 'uint', 32);
  this._procEntries('samples', this.sample_count, function(sample) {
    if (this.flags & 0x100) this._procEntryField(sample, 'sample_duration', 'uint', 32);
    if (this.flags & 0x200) this._procEntryField(sample, 'sample_size', 'uint', 32);
    if (this.flags & 0x400) this._procEntryField(sample, 'sample_flags', 'uint', 32);
    if (this.flags & 0x800) this._procEntryField(sample, 'sample_composition_time_offset', (this.version === 1) ? 'int' : 'uint',  32);
  });
};

// ISO/IEC 14496-12:2012 - 8.7.2 Data Reference Box
ISOBox.prototype._boxProcessors['url '] = ISOBox.prototype._boxProcessors['urn '] = function() {
  this._procFullBox();
  if (this.type === 'urn ') {
    this._procField('name', 'string', -1);
  }
  this._procField('location', 'string', -1);
};

// ISO/IEC 14496-30:2014 - WebVTT Source Label Box
ISOBox.prototype._boxProcessors['vlab'] = function() {
  this._procField('source_label', 'utf8');
};

// ISO/IEC 14496-12:2012 - 8.4.5.2 Video Media Header Box
ISOBox.prototype._boxProcessors['vmhd'] = function() {
  this._procFullBox();
  this._procField('graphicsmode', 'uint', 16);
  this._procFieldArray('opcolor', 3, 'uint', 16);
};

// ISO/IEC 14496-30:2014 - WebVTT Configuration Box
ISOBox.prototype._boxProcessors['vttC'] = function() {
  this._procField('config', 'utf8');
};

// ISO/IEC 14496-30:2014 - WebVTT Empty Sample Box
ISOBox.prototype._boxProcessors['vtte'] = function() {
  // Nothing should happen here.
};


/***/ }),

/***/ "./node_modules/fast-deep-equal/index.js":
/*!***********************************************!*\
  !*** ./node_modules/fast-deep-equal/index.js ***!
  \***********************************************/
/***/ ((module) => {

"use strict";


var isArray = Array.isArray;
var keyList = Object.keys;
var hasProp = Object.prototype.hasOwnProperty;

module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    var arrA = isArray(a)
      , arrB = isArray(b)
      , i
      , length
      , key;

    if (arrA && arrB) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }

    if (arrA != arrB) return false;

    var dateA = a instanceof Date
      , dateB = b instanceof Date;
    if (dateA != dateB) return false;
    if (dateA && dateB) return a.getTime() == b.getTime();

    var regexpA = a instanceof RegExp
      , regexpB = b instanceof RegExp;
    if (regexpA != regexpB) return false;
    if (regexpA && regexpB) return a.toString() == b.toString();

    var keys = keyList(a);
    length = keys.length;

    if (length !== keyList(b).length)
      return false;

    for (i = length; i-- !== 0;)
      if (!hasProp.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      key = keys[i];
      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  return a!==a && b!==b;
};


/***/ }),

/***/ "./node_modules/html-entities/index.js":
/*!*********************************************!*\
  !*** ./node_modules/html-entities/index.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = {
  XmlEntities: __webpack_require__(/*! ./lib/xml-entities.js */ "./node_modules/html-entities/lib/xml-entities.js"),
  Html4Entities: __webpack_require__(/*! ./lib/html4-entities.js */ "./node_modules/html-entities/lib/html4-entities.js"),
  Html5Entities: __webpack_require__(/*! ./lib/html5-entities.js */ "./node_modules/html-entities/lib/html5-entities.js"),
  AllHtmlEntities: __webpack_require__(/*! ./lib/html5-entities.js */ "./node_modules/html-entities/lib/html5-entities.js")
};


/***/ }),

/***/ "./node_modules/html-entities/lib/html4-entities.js":
/*!**********************************************************!*\
  !*** ./node_modules/html-entities/lib/html4-entities.js ***!
  \**********************************************************/
/***/ ((module) => {

var HTML_ALPHA = ['apos', 'nbsp', 'iexcl', 'cent', 'pound', 'curren', 'yen', 'brvbar', 'sect', 'uml', 'copy', 'ordf', 'laquo', 'not', 'shy', 'reg', 'macr', 'deg', 'plusmn', 'sup2', 'sup3', 'acute', 'micro', 'para', 'middot', 'cedil', 'sup1', 'ordm', 'raquo', 'frac14', 'frac12', 'frac34', 'iquest', 'Agrave', 'Aacute', 'Acirc', 'Atilde', 'Auml', 'Aring', 'Aelig', 'Ccedil', 'Egrave', 'Eacute', 'Ecirc', 'Euml', 'Igrave', 'Iacute', 'Icirc', 'Iuml', 'ETH', 'Ntilde', 'Ograve', 'Oacute', 'Ocirc', 'Otilde', 'Ouml', 'times', 'Oslash', 'Ugrave', 'Uacute', 'Ucirc', 'Uuml', 'Yacute', 'THORN', 'szlig', 'agrave', 'aacute', 'acirc', 'atilde', 'auml', 'aring', 'aelig', 'ccedil', 'egrave', 'eacute', 'ecirc', 'euml', 'igrave', 'iacute', 'icirc', 'iuml', 'eth', 'ntilde', 'ograve', 'oacute', 'ocirc', 'otilde', 'ouml', 'divide', 'oslash', 'ugrave', 'uacute', 'ucirc', 'uuml', 'yacute', 'thorn', 'yuml', 'quot', 'amp', 'lt', 'gt', 'OElig', 'oelig', 'Scaron', 'scaron', 'Yuml', 'circ', 'tilde', 'ensp', 'emsp', 'thinsp', 'zwnj', 'zwj', 'lrm', 'rlm', 'ndash', 'mdash', 'lsquo', 'rsquo', 'sbquo', 'ldquo', 'rdquo', 'bdquo', 'dagger', 'Dagger', 'permil', 'lsaquo', 'rsaquo', 'euro', 'fnof', 'Alpha', 'Beta', 'Gamma', 'Delta', 'Epsilon', 'Zeta', 'Eta', 'Theta', 'Iota', 'Kappa', 'Lambda', 'Mu', 'Nu', 'Xi', 'Omicron', 'Pi', 'Rho', 'Sigma', 'Tau', 'Upsilon', 'Phi', 'Chi', 'Psi', 'Omega', 'alpha', 'beta', 'gamma', 'delta', 'epsilon', 'zeta', 'eta', 'theta', 'iota', 'kappa', 'lambda', 'mu', 'nu', 'xi', 'omicron', 'pi', 'rho', 'sigmaf', 'sigma', 'tau', 'upsilon', 'phi', 'chi', 'psi', 'omega', 'thetasym', 'upsih', 'piv', 'bull', 'hellip', 'prime', 'Prime', 'oline', 'frasl', 'weierp', 'image', 'real', 'trade', 'alefsym', 'larr', 'uarr', 'rarr', 'darr', 'harr', 'crarr', 'lArr', 'uArr', 'rArr', 'dArr', 'hArr', 'forall', 'part', 'exist', 'empty', 'nabla', 'isin', 'notin', 'ni', 'prod', 'sum', 'minus', 'lowast', 'radic', 'prop', 'infin', 'ang', 'and', 'or', 'cap', 'cup', 'int', 'there4', 'sim', 'cong', 'asymp', 'ne', 'equiv', 'le', 'ge', 'sub', 'sup', 'nsub', 'sube', 'supe', 'oplus', 'otimes', 'perp', 'sdot', 'lceil', 'rceil', 'lfloor', 'rfloor', 'lang', 'rang', 'loz', 'spades', 'clubs', 'hearts', 'diams'];
var HTML_CODES = [39, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 34, 38, 60, 62, 338, 339, 352, 353, 376, 710, 732, 8194, 8195, 8201, 8204, 8205, 8206, 8207, 8211, 8212, 8216, 8217, 8218, 8220, 8221, 8222, 8224, 8225, 8240, 8249, 8250, 8364, 402, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 9