import { noop } from '@datadog/browser-core';
import type { RumConfiguration } from '@datadog/browser-rum-core';
import type { MutationCallBack } from './observers';
interface RumCharacterDataMutationRecord {
    type: 'characterData';
    target: Node;
    oldValue: string | null;
}
interface RumAttributesMutationRecord {
    type: 'attributes';
    target: Element;
    oldValue: string | null;
    attributeName: string | null;
}
interface RumChildListMutationRecord {
    type: 'childList';
    target: Node;
    addedNodes: NodeList;
    removedNodes: NodeList;
}
export declare type RumMutationRecord = RumCharacterDataMutationRecord | RumAttributesMutationRecord | RumChildListMutationRecord;
/**
 * Buffers and aggregate mutations generated by a MutationObserver into MutationPayload
 */
export declare function startMutationObserver(controller: MutationController, mutationCallback: MutationCallBack, configuration: RumConfiguration): {
    stop: typeof noop;
};
/**
 * Controls how mutations are processed, allowing to flush pending mutations.
 */
export declare class MutationController {
    private flushListener?;
    flush(): void;
    onFlush(listener: () => void): void;
}
export declare function sortAddedAndMovedNodes(nodes: Node[]): void;
export {};
