"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaInteractionType = exports.MouseInteractionType = exports.IncrementalSource = exports.NodeType = exports.RecordType = void 0;
exports.RecordType = {
    FullSnapshot: 2,
    IncrementalSnapshot: 3,
    Meta: 4,
    Focus: 6,
    ViewEnd: 7,
    VisualViewport: 8,
    FrustrationRecord: 9,
};
exports.NodeType = {
    Document: 0,
    DocumentType: 1,
    Element: 2,
    Text: 3,
    CDATA: 4,
};
exports.IncrementalSource = {
    Mutation: 0,
    MouseMove: 1,
    MouseInteraction: 2,
    Scroll: 3,
    ViewportResize: 4,
    Input: 5,
    TouchMove: 6,
    MediaInteraction: 7,
    StyleSheetRule: 8,
    // CanvasMutation : 9,
    // Font : 10,
};
exports.MouseInteractionType = {
    MouseUp: 0,
    MouseDown: 1,
    Click: 2,
    ContextMenu: 3,
    DblClick: 4,
    Focus: 5,
    Blur: 6,
    TouchStart: 7,
    TouchEnd: 9,
};
exports.MediaInteractionType = {
    Play: 0,
    Pause: 1,
};
//# sourceMappingURL=sessionReplayConstants.js.map