import { CronExprs } from '@datasert/cronjs-parser';
export interface Func<I, O> {
    (input: I): O;
}
export interface MatchOptions {
    timezone?: string;
    startAt?: string;
    endAt?: string;
    matchCount?: number;
    formatInTimezone?: boolean;
    maxLoopCount?: number;
    matchValidator?: Func<string, boolean>;
}
/**
 * Evaluates the parsed cron expression and returns the run times.
 * Note that it is assumed that cron expression is parsed using @datasert/cron-parser. Otherwise the results
 * are undefined.
 */
export declare function getFutureMatches(expr: CronExprs | string, options?: MatchOptions): string[];
export declare function isTimeMatches(exprs: CronExprs | string, time: string, timezone?: string): boolean;
