export interface PlainObject<T> {
    [key: string]: T;
}
export interface ParseOptions {
    hasSeconds?: boolean;
}
export interface CronRange {
    from: number;
    to: number;
}
export interface CronStep {
    from: number;
    to: number;
    step: number;
}
export interface CronNth {
    day_of_week: number;
    instance: number;
}
export interface CronField {
    all?: boolean;
    omit?: boolean;
    ranges?: CronRange[];
    steps?: CronStep[];
    nthDays?: CronNth[];
    values?: number[];
    lastDay?: boolean;
    lastDays?: number[];
    lastWeekday?: boolean;
    nearestWeekdays?: number[];
}
export type CronExpr = Record<FieldType, CronField>;
export interface CronExprs {
    pattern: string;
    expressions: CronExpr[];
}
export interface FieldInfo {
    min: number;
    max: number;
    alias?: PlainObject<number>;
}
export type FieldType = 'second' | 'minute' | 'hour' | 'month' | 'day_of_month' | 'day_of_week' | 'year';
export declare const FIELD_INFO: Record<FieldType, FieldInfo>;
export declare function parse(exprs: string, options?: ParseOptions): CronExprs;
